/********************************************************************************
* QLogic QLA2x00 device driver for Linux 2.2.x and 2.4.x 
* Copyright (C) 2000,2001         Qlogic Corporation 
* (www.qlogic.com)
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation; either version 2, or (at your option) any
* later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
**
******************************************************************************/
#define QLA2100_VERSION      "4.28"
/****************************************************************************
Revision History:
    Rev. 4.28b 	         May 10, 2001    DG QLogic
	- Cleanup and release.
    Rev. 4.28b 	         March 26, 2001    DG QLogic
	- Fixed persistent binding of target devices.
    Rev. 4.27 	         March 15, 2001    DG QLogic
	- Fixed Mailbox timeout logic
	- Fixed to compile on 2.4.x RedHat systems.
    Rev. 4.25 	         March 15, 2001    DG QLogic
	- released
    Rev. 4.25 Beta       March 9, 2001    DG QLogic
	- incl new qlavendor.c file.
    Rev. 4.24 Beta Test32  February 22, 2001    BN QLogic
        - Added code for scanning of missing LUN to let the
          SCSI layer skip it.
        - Revised init_cb_t structure in qla2x00.h for the new
          QLA2300 as well as QLA2200 devices.
        - Changed criteria of 64/32 Bit mode of HBA
          operation according to BITS_PER_LONG rather
          than HBA's NVRAM setting of >4Gig memory bit;
          so that the HBA auto-configures without the need
          to setup each system individually.
        - Merged changes for proper compile and operation in Alpha systems.
        - Upgrade FC firmware to: QLA2300 v3.00.18 *new
          and enabled FC Loopback test on QLA2300 HBAs.
        - Add statistics counters and IOCTL support for
          HBA Error Count, LIP Resets, and total ISR count.
        - Changed qla2100_reinit on loop down after 4 minutes 
          specific to QLA2100 HBAs only.
        - Added code and Makefile option to handle RISC code 
          download differently for ia-64 platforms than x86 or alpha.
    Rev. 4.23 Beta       January 12, 2001    BN QLogic
        - Use cmd->sc_data_direction for setting of HBA data transfer
          direction for 2.4.0 and higher kernels.
          Note: Users must set the reply_len in sg_header.
                For Writes and no data transfer; reply_len should
                be the lenght of sg_header.
                For Reads, reply_len should be the length of sg_header
                plus the number of bytes to be read.
        - Added check of SCSI_RESET_SUGGEST_BUS_RESET during 
          qla2100_reset() and perform BUS_RESET. 
          Also perform DEVICE_RESET on else of flag checking.
        - Added new /proc/scsi/qla2x00/HbaApiNode for IOCTL interface
          for 2.4.x kernels; so driver can be accessed with out need
          to have at least one mapped scsi drive.
        - Modified qla2100_mailbox_command's second parameter
          to 32 bits for use by Loop-Back Diagnostic function
        - Increase MAILBOX_REGISTER_COUNT to 32
        - Added Loop-Back Diagnostic function to qla2x00ioctl.c
          for QLA2200 HBAs only.
        - Order HBA detection as follows:
          QLA2300, QLA2200, QLA2100.
        - Changed queue_task() to queue_task_irq() in 
          qla2100_intr_handler() for proper usage.
        - In qla2100_register_with_Linux() put check and getting 
          device iobase before registering of interrupt with Linux;
          to help with driver loading/unloading when ramdisk is also loaded.
        - Change IOCTL support to SDM_VERSION 5 in qla2x00ioctl.c
          to be support SNIA HBA API 1.0 Library
        - Upgrade FC firmware to: QLA2200 v2.01.27 *new
                                  QLA2300 v3.00.17 *new
        - Added copy of HBA Serial Number to /proc entry
        - Added sigmask(SIGKILL) as second parameter to 
          siginitsetinv() function called during qla2100_do_dpc();
          so that the driver can be unloaded for 2.4.0 kernels.
    Rev. 4.22 Beta       November 22, 2000    BN QLogic
        - Change IOCTL support to SDM_VERSION 4 in qla2x00_v4_ioctl.c
          to be compatible with ln_rel-1.0Beta API library
    Rev. 4.21 Beta       November 15, 2000    BN QLogic
        - Upgrade FC firmware to: 2100 v1.19.16
                                  2200 v2.01.24
                                  2300 v3.00.12
        - Merge of qla2x00 driver 2.19.16Beta changes.
        - Updated qlavendor.c for vendor unique command
          decoding. 
    Rev. 4.20 Beta       October 17, 2000    BN QLogic
        - QLA2300 Support added.
    Rev. 4.14 Beta       October 16, 2000    BN QLogic
        - Added setting of higher address bits for
          MBC_INITIALIZE_FIRMWARE operation.
        - Release also contains newer qlavendor.c file
        - Move to the new SCSI initialization scheme
          and always declare the static driver_template
          for kernels 2.4.0 and higher
    Rev. 4.13 Beta       September 21, 2000    BN QLogic
        - Added "quiet" option to keep from printing LIP
          occurred messages on systems that specify it.
        - Added option to choose tp or ef, FC firmware
    Rev. 4.12 Beta       September 18, 2000    BN QLogic
        - Added pci_set_master() to qla2100_pci_config
          function to make sure all systems are supported
    Rev. 4.11 Beta       September 6, 2000    BN QLogic
        - Enabled IOCTLs for external IOCTL and APIs
    Rev. 4.10 Beta       August 28, 2000      BN Qlogic
        - Use new PCI DMA mapping APIs for 2.4.x kernel
        - Added driver IOCTL support code; but disabled
          it with #if 0 for next release
        - Verified correct 64 bit addressing with NVRAM:
          enable_64bit_addressing (>4GByte Addressing)
          enabled in BIOS advanced settings option.
    Rev. 4.0           July  24, 2000      BN Qlogic
        - Added FC Tape Support by use of new FC Firmware
             ql2100_fw.h   must be  v1.19.12  or greater
             ql2200_fw.h   must be  v2.01.16  or greater
        - Corrected HBA Node Name equal to zero 
        - Changed QLBoardTbl to QLBoardTbl_fc to avoid
          double definition error with regards to qla1280
          on new 2.4.0 kernel build tools
    Rev. 3.90 Beta     July  21, 2000      BN Qlogic
	- Added 64 bit OS and IA-64 hardware support
        - Move to new major revision number
    Rev. 2.22         July  14, 2000      BN Qlogic
	- Updated 2100 FW to  1.19.10
	- Updated 2200 FW to  2.01.14
	- Move version to 2.22 for release to DVT
    Rev. 2.19.8       July  11, 2000      DG Qlogic
    - Fixed 2100 issue of login retry when no fabric is attached.
    Rev. 2.19.7       July  6, 2000      DG
    - Set queue depth per lun to 16 instead of throttle which is a
      port max queue size and added an option "ql2xmaxqdepth=xx"
      to allow user to change queue depth. This prevents us from
      exceeding the adapter's throttle size which causes requests
      to sit in the input queue for long periods of time.
    Rev. 2.19.6       June  28, 2000      DG Qlogic
    - GA release 
    - Fixed panic in putq_t routine when called from abort.
    Rev. 2.19.5b7     June  27, 2000      DG
    - Add logic to wait reset delay if no fabric devices are found.
    Rev. 2.19.5b6     June  26, 2000      DG
    - Fixed Fw ready issue.
    - Clear sent flag in SRB, so we will abort commands in Lun
      queue that were previously sent.
    - Flush input queue when an isp_abort occurs.
    Rev. 2.19.5b5     June  16, 2000      DG
    - Fixed issue of not holding off request if multiple RSCN or
      PORT updates occur while process the currect RSCN.
    Rev. 2.19.5b4     June  16, 2000      DG
    - Added lock for done_q to prevent losing requests in timer.
    Rev. 2.19.5b3     June  16, 2000      DG
    - Added routine to set the correct direction for vendor specific
      commands. Set the new option "QLA_SCSI_VENDOR_DIR".
    - Fixed issue of retrying continuously on a Missing SCSI device.
    - Fixed multiple adapter issue. Only login into adapter node 
      once and never again. 
    - Change code not to use loop id 0 for Fabric nodes. 
    Rev. 2.19.5b2     June  15, 2000      DG
    - Added code to reset port down count on good requests.
    Rev. 2.19.5       June  8, 2000      DG
    - Added code to display the connection type F, FL, or N.
    - Reaarange code in DPC routine to put "retry login"
      further  down in the routine and skip is loop is down.
    - Check the returned status after GAN (qla2100_sns_device)
      and retry on ISP TX timeout (0x4005).
    Rev. 2.19.4       June  6, 2000      DG
    - Fixed for panic that occurs when system is shutdown.
    Rev. 2.19.3       June  5, 2000      DG
    - Fixed retry logic for user configured targets.
    Rev. 2.19.2       May  31, 2000      DG
    - Remove spinlock in qla2100_timer.
    - Change the jiffies timer to loop timer in fw_ready. 
    Rev. 2.19.1       May  6, 2000      DG
    - Change risc code 2200 from 2.1.12 to 2.1.13 to correct issue
      of getting mailbox timeouts.
    - Change mailbox timer to get correct timeout.
    - Added qla2100_cmd_wait to wait for outstanding commands to
      complete before querying the name server after a LIP.  
    Rev. 2.19         May  6, 2000      DG
    - Fixed mailbox timeout recovery logic.
    Rev. 2.18         May  1, 2000      DG
    - Changes from Fabric testing
    Rev. 2.18b4       Apr 21, 2000      DG
    - Fixed login retry count to retry count.
    - If the loop is down for more than 4 minutes then restart 
      queues and reset adpater if enabled.
    - In qla2100_queuecommand we no longer return new requests 
      immediately back to kernel when loop is down. This causes
      SYSTEM to HANG when a lot of requests are outstanding. We 
      now put them in the done queue and let the DPC routine 
      return them to kernel.
    - Fixed panic cause by changing the timeout value of new request
      when the loop is down. 
    - Cleanup qla2100_next.
    Rev. 2.18b3       Apr 18, 2000      DG
    - After the GAN, check returned status in resp buffer.
    Rev. 2.18b2       Apr 12, 2000      DG
    - Added handling of firmware bug when we use connection mode
      1 (P2P). The firmware tries to change to loop mode after
      encountering some IO failures/resets.
    - Added logic to reset all modules during a chip reset.
    - After the GAN, if we lost devices or have a device that was 
      configured by the user then retry the login. This is a 
      work-a-round for Brocade switches. It sometimes does
      not return all the devices in the port list.
    Rev. 2.18b1     Apr 1, 2000      DG
    - Added logic to ignore device types other than FL/F 
      from gan list. Mcdata switch returns a bogus port of
      type 85 in the list.
    - Added firmware 2.1.11 to fix issues with reusing loop ids.
    Rev. 2.17       Mar 21, 2000      DG
    - Fixed mailbox timeout timer.
    - Added counters to record timeouts and aborts.
    Rev. 2.16       Mar 8, 2000      DG
    - Fixed Profiling code to reduced output of inactive devices.
    - Fixed driver name in "/proc/scsi/qla2x00" instead of "qla".
    - Fixed extended timeout value for loop down retries.
    - Fixed code that search for target binding in command line to search
      for all occurences instead of the first four.
    - Disable the reinit of adapter when the LOOP is DOWN
      for more than 4 minutes. It can be enabled with the command
      line option "reinit_on_loopdown".
    - Fixed issue of not setting HBA instance number before
      calling HBA initialized.
    Rev. 2.15       Feb 19, 2000      DG
    - Fixed 2100 issue of driver not seeing storage when switch is connected
      to loop.
    Rev. 2.14       Feb 11, 2000      DG
    - Added new logic to accept persistent binding information from the command line.
    - Modified command parser to handle properties on the command line after
      the regular options.
    Rev. 2.13       Jan 27, 2000      TT
    - Modify to use makefile parameter "IP=1" to enanle IP support.
    - Fix SNS mailbox cmd parameter in qla2x00_register_ip_device.
    - Reverse byte order on ha->port_id to match NT and fix compare bugs.
    Rev. 2.12       Jan 26, 2000      TT+DG
    - Updated Qlogic Linux sofware license.
    - Added IP support for qla2xip driver.
    - Fix host adapter structure initialization in qla2100_detect.
    - Fix port name byte order in qla2100_update_fc_db.
    - Fix the issue of not returning "NO_CONNECT" back to the user
      when the loop is down after the loop down timer has expired.
    - Added option QLA2100_EXT_TIMEOUT to extend timeout of each command.
      default if OFF.
    - Change device high water mark (hiwat) to execution throttle.
    Rev. 2.11       Dec 8, 1999       DG
    - Added Qlogic Linux sofware license.
    Rev. 2.10       Oct 31, 1999      DG
    - Fixed issue of not releasing requests if port is down (DPC issue).
    - Ignore BIOS setting for MAX number of luns unless USE_BIOS_MAX_LUNS
    is set.
*****************************************************************************/
  
/*
* Compile time Options:
*            0 - Disable and 1 - Enable
*/
#define  QL2100_TARGET_MODE_SUPPORT    0   /* Target mode support */
#define  MEMORY_MAPPED_IO              0
#define  DEBUG_QLA2100_INTR            0
#define  USE_NVRAM_DEFAULTS	       0
#define  DEBUG_PRINT_NVRAM             0
#define  LOADING_RISC_ACTIVITY         0
#define  AUTO_ESCALATE_RESET           0   /* Automatically escalate resets */
#define  AUTO_ESCALATE_ABORT           0   /* Automatically escalate aborts */
#define  STOP_ON_ERROR                 0   /* Stop on aborts and resets  */
#define  STOP_ON_RESET                 0
#define  STOP_ON_ABORT                 0
#define  QLA2100_COMTRACE              0    /* One char tracing  */
#define  WATCH_THREADS_SIZ             0    /* watch size of pending queue */
#define  USE_PORTNAME                  1    /* option to use port names for targets */
#define  QLA2100_EXT_TIMEOUT           0    /* Extend timeout for commands up to 1 min*/
#define  LUN_MASKING                   0
#define  USE_FLASH                     0
#define  QLA2100_PROFILE               1
#define  QLA_SCSI_VENDOR_DIR           0 /* Decode vendor specific opcodes for direction */
#define QLA2100_LIPTEST    	       0
#define REQ_TRACE    		       1

#undef   TRACECODE                       /* include tracing code in watchdog routines */
#define  CHECK_BINDING

#define  DEBUG_QLA2100                 0  /* For Debug of qla2x00 */
#define  DEBUG_GET_FW_DUMP             0  /* also set DEBUG_QLA2100 and 
                                             use COM1 and capture it */
#define  USE_TP_FW                     1  /* use tp or ef firmware */

/* The following WORD_FW_LOAD is defined in Makefile for ia-64 builds
   and can also be decommented here for Word by Word confirmation of
   RISC code download operation */
/* #define  WORD_FW_LOAD               0  */

/*
* String arrays
*/
#define LINESIZE    256
#define MAXARGS      26
 
/*
* Include files
*/
#include <linux/config.h>
#ifdef MODULE
#include <linux/module.h>
#endif

#ifndef LINUX_VERSION_CODE
#include <linux/version.h>
#endif  /* LINUX_VERSION_CODE not defined */

static int num_hosts;           /* ioctl related  */
static int apiHBAInstance = 0;  /* ioctl related keeps track of API HBA Instance */


#include <stdarg.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/segment.h>
#include <asm/byteorder.h>
#include <asm/pgtable.h>
#include <linux/types.h>
#include <linux/string.h>
#include <linux/errno.h>
#include <linux/kernel.h>
#include <linux/ioport.h>
#include <linux/delay.h>
#include <linux/timer.h>
#include <linux/sched.h>
#include <linux/pci.h>
#include <linux/proc_fs.h>
#include <linux/blk.h>
#include <linux/tqueue.h>
#include <linux/interrupt.h>


#ifndef KERNEL_VERSION
#  define KERNEL_VERSION(x,y,z) (((x)<<16)+((y)<<8)+(z))
#endif

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,3,18)
#define  APIDEV        1
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,95)
#include <linux/tasks.h>
# include <linux/bios32.h>
#else
/*#include <asm/spinlock.h>*/

#define __KERNEL_SYSCALLS__

#include <linux/unistd.h>
#include <linux/smp_lock.h>

#include <asm/system.h>
#define SHUTDOWN_SIGS	(sigmask(SIGKILL)|sigmask(SIGINT)|sigmask(SIGTERM))
#endif
#include "sd.h"
#include "scsi.h"
#include "hosts.h"

#ifdef FC_IP_SUPPORT
#include <linux/skbuff.h>
#include "qlcommon.h"
#endif

#include "qla2x00.h"
#define UNIQUE_FW_NAME                 /* unique F/W array names */
#ifdef UNIQUE_FW_NAME
#include "ql2100_fw.h"                     /* ISP RISC code */
#ifdef FC_IP_SUPPORT
#include "ql2200ip_fw.h"                   /* ISP RISC 2200 code */
#include "ql2300ip_fw.h"                   /* ISP RISC 2300 code */
#else
#include "ql2200_fw.h"                     /* ISP RISC 2200 code */
#include "ql2300_fw.h"                     /* ISP RISC 2300 code */
#endif
#else
#include "isp_fw.h"                     /* ISP RISC code */
#include "isp1_fw.h"                     /* ISP RISC 2200 code */
#endif
#include <linux/stat.h>
#include <linux/slab.h>       


#define  BZERO(ptr, amt)		memset((ptr), 0, amt)
#define  BCOPY(src, dst, amt)	memcpy((dst), src, amt)
#define  KMALLOC(siz)	kmalloc((siz), GFP_ATOMIC | GFP_DMA)
#define  KMFREE(ip,siz)	kfree((ip))
#define  SYS_DELAY(x)		udelay(x);barrier()
#define  QLA2100_DELAY(sec)  mdelay(sec * HZ)

/* 4.10 */
#if  BITS_PER_LONG > 32
#define pci_dma_lo32(a) (a & 0xffffffff)
#define pci_dma_hi32(a) ((a >> 32) & 0xffffffff)
#else
#define pci_dma_lo32(a) (a & 0xffffffff)
#define pci_dma_hi32(a) 0
#endif

#define  VIRT_TO_BUS(a) virt_to_bus((a))

#if  BITS_PER_LONG <= 32
#define  VIRT_TO_BUS_LOW(a) (uint32_t)virt_to_bus(((void *)a))
#define  VIRT_TO_BUS_HIGH(a) (uint32_t)(0x0)
#else
#define  VIRT_TO_BUS_LOW(a) (uint32_t)(0xffffffff & virt_to_bus((void *)(a)))
#define  VIRT_TO_BUS_HIGH(a) (uint32_t)(0xffffffff & (virt_to_bus((void *)(a))>>32))
#endif

#define  CACHE_FLUSH(a) (RD_REG_WORD(a))
#define  INVALID_HANDLE    (MAX_OUTSTANDING_COMMANDS+1)

#define  STATIC

#if  BITS_PER_LONG <= 32
#define  LS_64BITS(x) (uint32_t)((unsigned long)x)
#define  MS_64BITS(x) (uint32_t)((unsigned long) 0x0)
#else
#define  LS_64BITS(x) (uint32_t)(0xffffffff & ((unsigned long)x))
#define  MS_64BITS(x) (uint32_t)(0xffffffff & (((unsigned long)x)>>32) )
#endif

#if  BITS_PER_LONG <= 32
#define  MSB(x)          (uint8_t)(((uint16_t)(x) >> 8) & 0xff)
#define  LSB(x)          (uint8_t)(x & 0xff)
#define  MSW(x)          (uint16_t)(((uint32_t)(x) >> 16) & 0xffff)
#define  LSW(x)          (uint16_t)(x & 0xffff)
#define  QL21_64BITS_3RDWD(x)   ((uint16_t) 0)
#define  QL21_64BITS_4THWD(x)   ((uint16_t) 0)
#else
#define  MSB(x)          (uint8_t)(((uint16_t)(x) >> 8) & 0xff)
#define  LSB(x)          (uint8_t)(x & 0xff)
#define  MSW(x)          (uint16_t)(((uint32_t)(x) >> 16) & 0xffff)
#define  LSW(x)          (uint16_t)(x & 0xffff)
#define  QL21_64BITS_3RDWD(x)   ((uint16_t) (x >> 32) & 0xffff)
#define  QL21_64BITS_4THWD(x)   ((uint16_t) (x >> 48) & 0xffff)
#endif

#define  OFFSET(w)   (((u_long) &w) & 0xFFFF)  /* 256 byte offsets */
#define  SCSI_BUS_32(scp)   ((scp)->channel)
#define  SCSI_TCN_32(scp)    ((scp)->target)
#define  SCSI_LUN_32(scp)    ((scp)->lun)

/*
* TIMER MACROS
*/
#define  QLA2100_TIMER_LOCK(ap)   spin_lock_irqsave(&(ap)->retry_lock, cpu_flags);
#define  QLA2100_TIMER_UNLOCK(ap) spin_unlock_irqrestore(&(ap)->retry_lock, cpu_flags);


#define	WATCH_INTERVAL		1       /* number of seconds */
#define	START_TIMER(f, h, w)	\
{ \
init_timer(&(h)->timer); \
(h)->timer.expires = jiffies + w * HZ;\
(h)->timer.data = (unsigned long) h; \
(h)->timer.function = (void (*)(unsigned long))f; \
(h)->flags.start_timer = FALSE; \
add_timer(&(h)->timer); \
(h)->timer_active = 1;\
}

#define	RESTART_TIMER(f, h, w)	\
{ \
(h)->timer.expires = jiffies + w * HZ;\
(h)->flags.start_timer = FALSE; \
add_timer(&(h)->timer); \
}

#define	STOP_TIMER(f, h)	\
{ \
del_timer(&(h)->timer); \
(h)->timer_active = 0;\
}

#define NVRAM_DELAY() udelay(500) /* 2 microsecond delay */

typedef unsigned long paddr32_t;

/*
*  Qlogic Driver support Function Prototypes.
*/
STATIC uint8_t  qla2100_register_with_Linux(scsi_qla_host_t *ha, uint8_t maxchannels);
STATIC void   qla2100_done(scsi_qla_host_t *, srb_t **, srb_t **),
qla2100_next(scsi_qla_host_t *, scsi_lu_t *),
qla2100_select_queue_depth(struct Scsi_Host *, Scsi_Device *);

STATIC void      qla2100_done_q_put(scsi_qla_host_t *, srb_t *, srb_t **, srb_t **),
qla2100_putq_b(scsi_lu_t *, srb_t *),
qla2100_putq_t(scsi_lu_t *, srb_t *),
qla2100_removeq(scsi_lu_t *, srb_t *),
qla2100_timer(scsi_qla_host_t *),
qla2100_timeout_insert(scsi_qla_host_t *, srb_t *),
qla2100_timeout_remove(scsi_qla_host_t *, srb_t *);

STATIC uint8_t   qla2100_mem_alloc(scsi_qla_host_t *);

static void qla2100_dump_regs(struct Scsi_Host *host);
#if  STOP_ON_ERROR
static void qla2100_panic(char *, struct Scsi_Host *host);
#endif
void qla2100_print_scsi_cmd(Scsi_Cmnd *cmd);
STATIC void qla2100_abort_queue_single(scsi_qla_host_t *,uint32_t,uint32_t,uint32_t,uint32_t);

STATIC int qla2100_return_status(scsi_qla_host_t *ha, sts_entry_t *sts, Scsi_Cmnd       *cp);
STATIC void qla2100_removeq(scsi_lu_t *q, srb_t *sp);
STATIC void qla2100_mem_free(scsi_qla_host_t *ha);
void qla2100_do_dpc(void *p);

static inline void qla2100_callback(scsi_qla_host_t *ha, srb_t *sp, uint8_t dec),
qla2100_tgt_dealloc(scsi_qla_host_t *, tgt_t *),
qla2100_lun_dealloc(scsi_lu_t *);
static inline tgt_t     *qla2100_tgt_alloc(scsi_qla_host_t *);
static inline scsi_lu_t *qla2100_lun_alloc(void);

static inline void qla2100_enable_intrs(scsi_qla_host_t *);
static inline void qla2100_disable_intrs(scsi_qla_host_t *);
#if QLA2100_EXT_TIMEOUT
static void qla2100_extend_timeout(Scsi_Cmnd *cmd, int timeout);
#endif
static int  qla2100_get_tokens(char *line, char **argv, int maxargs );

/*
*  QLogic ISP2100 Hardware Support Function Prototypes.
*/
STATIC  uint8_t  qla2100_initialize_adapter(scsi_qla_host_t *),
qla2100_isp_firmware(scsi_qla_host_t *),
qla2100_pci_config(scsi_qla_host_t *),
qla2100_set_cache_line(scsi_qla_host_t *),
qla2100_chip_diag(scsi_qla_host_t *),
qla2100_setup_chip(scsi_qla_host_t *),
qla2100_init_rings(scsi_qla_host_t *),
qla2100_fw_ready(scsi_qla_host_t *),
qla2100_nvram_config(scsi_qla_host_t *),
qla2200_nvram_config(scsi_qla_host_t *),
qla2100_mailbox_command(scsi_qla_host_t *, uint32_t, uint16_t *),
qla2100_update_device_data(scsi_qla_host_t *, device_data_t *, u_char),
qla2100_sns_device(scsi_qla_host_t *, u_char),
qla2100_update_fc_db(scsi_qla_host_t *, u_char),
qla2100_map_targets(scsi_qla_host_t *),
#if USE_FLASH
qla2100_get_database(scsi_qla_host_t *),
qla2100_save_database(scsi_qla_host_t *),
qla2100_program_flash_address(scsi_qla_host_t *, uint32_t, u_char),
qla2100_erase_flash_sector(scsi_qla_host_t *, uint32_t),
qla2100_poll_flash(scsi_qla_host_t *, uint32_t, u_char),
#endif
qla2100_loop_reset(scsi_qla_host_t *),
qla2100_device_reset(scsi_qla_host_t *, uint32_t, uint32_t),
qla2100_abort_device(scsi_qla_host_t *, uint32_t, uint32_t, uint32_t),
qla2100_abort_command(scsi_qla_host_t *, srb_t *),
qla2100_64bit_start_scsi(scsi_qla_host_t *, srb_t *),
qla2100_32bit_start_scsi(scsi_qla_host_t *, srb_t *),
qla2100_abort_isp(scsi_qla_host_t *),
qla2100_loop_resync(scsi_qla_host_t *);
STATIC uint8_t qla2100_cmd_wait(scsi_qla_host_t *ha);

STATIC void      qla2100_nv_write(scsi_qla_host_t *, uint16_t),
qla2100_nv_delay(void),
qla2100_poll(scsi_qla_host_t *),
qla2100_init_fc_db(scsi_qla_host_t *),
qla2100_init_tgt_map(scsi_qla_host_t *),
#if USE_FLASH
qla2100_flash_enable(scsi_qla_host_t *),
qla2100_flash_disable(scsi_qla_host_t *),
qla2100_write_flash_byte(scsi_qla_host_t *, uint32_t, u_char),
#endif
qla2100_reset_adapter(scsi_qla_host_t *),
qla2100_marker(scsi_qla_host_t *, uint32_t, uint32_t, uint32_t,
u_char),
qla2100_enable_lun(scsi_qla_host_t *),
qla2100_notify_ack(scsi_qla_host_t *, notify_entry_t *),
qla2100_64bit_continue_io(scsi_qla_host_t *, atio_entry_t *,
                                           uint32_t, u_long *),
qla2100_32bit_continue_io(scsi_qla_host_t *, atio_entry_t *,
                                           uint32_t, u_long *),
qla2100_isp_cmd(scsi_qla_host_t *),
qla2100_isr(scsi_qla_host_t *, srb_t **, srb_t **),
qla2100_rst_aen(scsi_qla_host_t *),
qla2100_atio_entry(scsi_qla_host_t *, atio_entry_t *),
qla2100_status_entry(scsi_qla_host_t *, sts_entry_t *, srb_t **,
srb_t **),
qla2100_error_entry(scsi_qla_host_t *, response_t *, srb_t **,
srb_t **),
qla2100_restart_queues(scsi_qla_host_t *, uint8_t),
qla2100_restart_watchdog_queue(scsi_qla_host_t *),
qla2100_abort_queues(scsi_qla_host_t *, uint8_t);

STATIC uint16_t  qla2100_get_nvram_word(scsi_qla_host_t *, uint32_t),
qla2100_nvram_request(scsi_qla_host_t *, uint32_t),
qla2100_read_flash_byte(scsi_qla_host_t *, uint32_t),
qla2100_debounce_register(volatile uint16_t *);

STATIC request_t *qla2100_req_pkt(scsi_qla_host_t *);
STATIC request_t *qla2100_ms_req_pkt(scsi_qla_host_t *, srb_t *);
uint8_t          qla2100_update_config(scsi_qla_host_t *ha);
STATIC uint8_t qla2100_configure_hba(scsi_qla_host_t *ha);
STATIC uint8_t qla2100_configure_loop(scsi_qla_host_t *ha, uint8_t );
STATIC void qla2100_reset_chip(scsi_qla_host_t *ha);
#if QL2100_TARGET_MODE_SUPPORT
qla2100_enable_lun(scsi_qla_host_t *, uint8_t, uint32_t),
qla2100_notify_ack(scsi_qla_host_t *, notify_entry_t *),
qla2100_immed_notify(scsi_qla_host_t *, notify_entry_t *),
qla2100_accept_io(scsi_qla_host_t *, ctio_ret_entry_t *),
qla2100_64bit_continue_io(scsi_qla_host_t *, atio_entry_t *, uint32_t,
                                     u_long *),
qla2100_32bit_continue_io(scsi_qla_host_t *, atio_entry_t *, uint32_t,
                                     u_long *),
qla2100_atio_entry(scsi_qla_host_t *, atio_entry_t *),
qla2100_notify_entry(scsi_qla_host_t *, notify_entry_t *),

#endif  /* QLA2100_TARGET_MODE_SUPPORT */
STATIC uint8_t qla2100_sns_get_name( scsi_qla_host_t *ha, device_data_t *device, uint8_t flag );
STATIC void qla2100_display_fc_names(scsi_qla_host_t *ha);
void ql2100_dump_requests(scsi_qla_host_t *ha);
static void qla2100_get_properties(scsi_qla_host_t *ha, char *string);
STATIC uint8_t qla2100_find_propname(scsi_qla_host_t *ha, char *propname, char *propstr, char *db);
static int qla2100_get_prop_16chars(scsi_qla_host_t *ha, char *propname, char *propval, char *cmdline);
static char	*qla2100_get_line(char *str, char *line);
void qla2100_check_fabric_devices(scsi_qla_host_t *ha);

#ifdef FC_IP_SUPPORT

/* Entry points for IP network driver */
int  qla2x00_ip_inquiry(uint16_t wAdapterNumber, BD_INQUIRY_DATA *pInquiryData);
int  qla2x00_ip_enable(scsi_qla_host_t *ha, BD_ENABLE_DATA *pEnableData);
void qla2x00_ip_disable(scsi_qla_host_t *ha);
void qla2x00_add_buffers(scsi_qla_host_t *ha, uint16_t wBufferCount);
int  qla2x00_send_packet(scsi_qla_host_t *ha, SEND_CB *pSendCB);

static int qla2x00_ip_initialize(scsi_qla_host_t *ha);
static int qla2x00_add_new_ip_device(scsi_qla_host_t *ha,
uint16_t wLoopId,
uint8_t *pPortId,
uint8_t *pPortName,
int bForceAdd);
static int qla2x00_convert_to_arp(scsi_qla_host_t *ha, SEND_CB *pSendCB);
static void qla2x00_free_ip_block(scsi_qla_host_t *ha,
IP_DEVICE_BLOCK *pIpDevice);
static int qla2x00_get_ip_loopid(scsi_qla_host_t *ha,
uint8_t *pNodeName,
uint8_t *pLoopId);
static int qla2x00_send_farp_request(scsi_qla_host_t *ha,
uint8_t *pPortName);
static int qla2x00_register_ip_device(scsi_qla_host_t *ha);
static int qla2x00_reserve_ip_block(scsi_qla_host_t *ha,
PIP_DEVICE_BLOCK *pIpDevBlk);
static int qla2x00_update_ip_device_data(scsi_qla_host_t *ha,
device_data_t *pDeviceData);
static int qla2x00_reserve_loopid(scsi_qla_host_t *ha, uint16_t *pLoopId);
static void qla2x00_free_loopid(scsi_qla_host_t *ha, uint16_t wLoopId);
static int qla2x00_login_public_device(scsi_qla_host_t *ha,
uint16_t *pLoopId,
uint8_t  *pPortID,
uint16_t wOptions);
static int qla2x00_logout_public_device(scsi_qla_host_t *ha,
uint16_t wLoopId,
uint16_t wOptions);
#else
/* v2.19.8 */
static int qla2x00_login_public_device(scsi_qla_host_t *ha,
uint16_t *pLoopId,
uint8_t  *pPortID,
uint16_t wOptions);
static int qla2x00_reserve_loopid(scsi_qla_host_t *ha, uint16_t *pLoopId);
static void qla2x00_free_loopid(scsi_qla_host_t *ha, uint16_t wLoopId);
#endif

#if  APIDEV
static int apidev_init(struct Scsi_Host*);
static int apidev_cleanup(void);
#endif

void qla2100_print_q_info(scsi_lu_t *q);

#if  DEBUG_QLA2100
#ifndef QL_DEBUG_ROUTINES
#define QL_DEBUG_ROUTINES
#endif
#endif
#ifdef QL_DEBUG_ROUTINES
/*
*  Driver Debug Function Prototypes.
*/
STATIC uint8_t  qla2100_getbyte(uint8_t *);
STATIC uint16_t qla2100_getword(uint16_t *);
STATIC uint32_t qla2100_getdword(uint32_t *);
STATIC void     qla2100_putbyte(uint8_t *, uint8_t),
qla2100_putword(uint16_t *, uint16_t),
qla2100_putdword(uint32_t *, uint32_t),
qla2100_print(int8_t *),
qla2100_output_number(u_long, uint8_t),
qla2100_putc(int8_t);
#endif
#if DEBUG_GET_FW_DUMP
STATIC void qla2300_dump_isp(scsi_qla_host_t *ha),
qla2100_dump_word(uint8_t *, uint32_t, uint32_t);
#endif

/* Debug print buffer */
char          debug_buff[LINESIZE];
#if DEBUG_QLA2100
STATIC uint8_t ql2x_debug_print = 1;
#else
STATIC uint8_t ql2x_debug_print = 0;
#endif

/*
* insmod needs to find the variable and make it point to something
*/
static char *ql2xdevconf = NULL;
static int ql2xretrycount = 8;
#ifdef MODULE
static char *ql2xopts = NULL;
static int ql2xmaxqdepth = 0;
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,18)

/* insmod qla2100 ql2xopts=verbose" */
MODULE_PARM(ql2xopts, "s");
MODULE_PARM(ql2xmaxqdepth, "i");
#endif
/*
* Just in case someone uses commas to separate items on the insmod
* command line, we define a dummy buffer here to avoid having insmod
* write wild stuff into our code segment
*/
static char dummy_buffer[60] = "Please don't add commas in your insmod command!!\n";

#endif

/*
* Macros to change names of OS remapping routines.
*/
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,0)
#define ioremap vremap
#define iounmap vfree
#endif


/*
* This is the pointer to the /proc/scsi/qla2100 code.
* access the driver.
*/
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
#if CONFIG_PROC_FS
/* this definition is normally in proc_fs.h     PROC_SCSI_QL2100 */
#define PROC_SCSI_QL2100  PROC_SCSI_QLOGICISP

struct proc_dir_entry proc_scsi_qla2100 = {
PROC_SCSI_QL2100, 7, "qla2x00",
S_IFDIR | S_IRUGO | S_IXUGO, 2,
0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL
};
#endif
#endif
static int qla2100_lip = 0;

#include <linux/ioctl.h>
#include <scsi/scsi_ioctl.h>

/* multi-OS QLOGIC IOCTL definition file */
#include "exioct.h"


#if QLA_SCSI_VENDOR_DIR
/* Include routine to set direction for vendor specific commands */
#include "qlavendor.c"
#endif 
/***********************************************************************
* We use the Scsi_Pointer structure that's included with each command
* SCSI_Cmnd as a scratchpad for our SRB. This allows us to accept
* an unlimited number of commands.
*
* SCp will always point to the SRB structure (defined in qla2100.h).
* It is defined as follows:
*  - SCp.ptr  -- > pointer back to the cmd
*  - SCp.this_residual --> used as forward pointer to next srb
*  - SCp.buffer --> used as backward pointer to next srb
*  - SCp.buffers_residual --> used as flags field
*  - SCp.have_data_in --> not used
*  - SCp.sent_command --> not used
*  - SCp.phase --> not used
***********************************************************************/
#define	CMD_SP(Cmnd)		(&(Cmnd)->SCp)
#define	CMD_XFRLEN(Cmnd)	(Cmnd)->request_bufflen
#define	CMD_CDBLEN(Cmnd)	(Cmnd)->cmd_len
#define	CMD_CDBP(Cmnd)		(Cmnd)->cmnd
#define	CMD_SNSP(Cmnd)		(Cmnd)->sense_buffer
#define	CMD_SNSLEN(Cmnd)	(sizeof (Cmnd)->sense_buffer)
#define	CMD_RESULT(Cmnd)	((Cmnd)->result)
#define	CMD_HANDLE(Cmnd)	((Cmnd)->host_scribble)
#define	CMD_TIMEOUT(Cmnd)	((Cmnd)->timeout_per_command)

#define DID_RETRY		DID_ERROR


/*
* Macros use for debugging the driver.
*/
#ifdef QL_DEBUG_LEVEL_3
#define ENTER(x)	sprintf(debug_buff,"qla2100 : Entering %s()\n\r", x); \
qla2100_print(debug_buff);
#define LEAVE(x)	sprintf(debug_buff,"qla2100 : Leaving %s()\n\r", x); \
qla2100_print(debug_buff);
#define ENTER_INTR(x)	sprintf(debug_buff,"qla2100 : Entering %s()\n\r", x); \
qla2100_print(debug_buff);
#define LEAVE_INTR(x)	sprintf(debug_buff,"qla2100 : Leaving %s()\n\r", x); \
qla2100_print(debug_buff);
#define DEBUG3(x)	x
#else
#define ENTER(x)
#define LEAVE(x)
#define ENTER_INTR(x)
#define LEAVE_INTR(x)
#define DEBUG3(x)
#endif

#if  QLA2100_COMTRACE
#define COMTRACE(x)     qla2100_putc(x);
#else
#define COMTRACE(x)
#endif

#if  DEBUG_QLA2100
#define DEBUG(x)	x
#define DEBUG4(x)
#else
#define DEBUG(x)
#define DEBUG4(x)
#endif

#ifdef QL_DEBUG_LEVEL_2
#define DEBUG2(x)          x
#else
#define DEBUG2(x)
#endif
#ifdef QL_DEBUG_LEVEL_5
#define DEBUG5(x)          x
#else
#define DEBUG5(x)
#endif

uint8_t copyright[48] = "Copyright 1999-2001, Qlogic Corporation";

/****************************************************************************/
/*  LINUX -  Loadable Module Functions.                                     */
/****************************************************************************/

/*****************************************/
/*   ISP Boards supported by this driver */
/*****************************************/
#define QLA2100_VENDOR_ID   0x1077
#define QLA2100_DEVICE_ID   0x2100
#define QLA2200_DEVICE_ID   0x2200
#define QLA2200A_DEVICE_ID  0x2200A
#define QLA2300_DEVICE_ID   0x2300
#define QLA2200A_RISC_ROM_VER  4

#define NUM_OF_ISP_DEVICES     4

typedef struct _qlaboards
{
unsigned char   bdName[9];       /* Board ID String             */
unsigned long   device_id;       /* Device ID                   */
int   numPorts;                  /* number of loops on adapter  */
unsigned short   *fwcode;        /* pointer to FW array         */
unsigned long    *fwlen;         /* number of words in array    */
unsigned short   *fwstart;       /* start address for F/W       */
unsigned char   *fwver;          /* Ptr to F/W version array    */
} qla_boards_t;


#if USE_TP_FW
struct _qlaboards   QLBoardTbl_fc[NUM_OF_ISP_DEVICES] =
{
/* Name ,  Board PCI Device ID,         Number of ports */
{"QLA2300 ", QLA2300_DEVICE_ID,           MAX_BUSES,
#ifdef FC_IP_SUPPORT
&fw2300ip_code01[0],  (unsigned long *)&fw2300ip_length01, &fw2300ip_addr01, &fw2300ip_version_str[0] },
#else
&fw2300tp_code01[0],  (unsigned long *)&fw2300tp_length01, &fw2300tp_addr01, &fw2300tp_version_str[0] },
#endif
{"QLA2200 ", QLA2200_DEVICE_ID,           MAX_BUSES,
#ifdef FC_IP_SUPPORT
&fw2200ip_code01[0],  (unsigned long *)&fw2200ip_length01, &fw2200ip_addr01, &fw2200ip_version_str[0] },
#else
&fw2200tp_code01[0],  (unsigned long *)&fw2200tp_length01, &fw2200tp_addr01, &fw2200tp_version_str[0] },
#endif
{"QLA2100 ", QLA2100_DEVICE_ID,           MAX_BUSES,
&fw2100tp_code01[0],  (unsigned long *)&fw2100tp_length01,&fw2100tp_addr01, &fw2100tp_version_str[0] },
{"        ",                 0,           0}
};

#else  /* USE_TP_FW */

struct _qlaboards   QLBoardTbl_fc[NUM_OF_ISP_DEVICES] =
{
/* Name ,  Board PCI Device ID,         Number of ports */
{"QLA2300 ", QLA2300_DEVICE_ID,           MAX_BUSES,
#ifdef FC_IP_SUPPORT
&fw2300ip_code01[0],  (unsigned long *)&fw2300ip_length01, &fw2300ip_addr01, &fw2300ip_version_str[0] },
#else
&fw2300ef_code01[0],  (unsigned long *)&fw2300ef_length01, &fw2300ef_addr01, &fw2300ef_version_str[0] },
#endif
{"QLA2200 ", QLA2200_DEVICE_ID,           MAX_BUSES,
#ifdef FC_IP_SUPPORT
&fw2200ip_code01[0],  (unsigned long *)&fw2200ip_length01, &fw2200ip_addr01, &fw2200ip_version_str[0] },
#else
&fw2200ef_code01[0],  (unsigned long *)&fw2200ef_length01, &fw2200ef_addr01, &fw2200ef_version_str[0] },
#endif
{"QLA2100 ", QLA2100_DEVICE_ID,           MAX_BUSES,
&fw2100ef_code01[0],  (unsigned long *)&fw2100ef_length01,&fw2100ef_addr01, &fw2100ef_version_str[0] },
{"        ",                 0,           0}
};
#endif /* USE_TP_FW  */

/*
* Stat info
*/
static struct _qla2100stats  {
unsigned long   mboxtout;            /* mailbox timeouts */
unsigned long   mboxerr;             /* mailbox errors */
unsigned long   ispAbort;            /* ISP aborts */
unsigned long   debugNo;
unsigned long   loop_resync;
unsigned long   outarray_full;
unsigned long   retry_q_cnt;
unsigned long   done_q_cnt;
scsi_qla_host_t *irqhba;
} qla2100_stats;

/*
* Command line options
*/
static unsigned long qla2100_verbose = 1L;
static unsigned long qla2100_quiet   = 0L;
static unsigned long qla2100_reinit = 1L;
static unsigned long qla2100_req_dmp = 0L;
static scsi_qla_host_t *qla2100_hostlist = NULL;

#ifdef QLA2100_PROFILE
static int qla2100_buffer_size = 0;
static char *qla2100_buffer = NULL;
#endif

#include <linux/ioctl.h>
#include <scsi/scsi_ioctl.h>
#include <asm/uaccess.h>

/*************************************************************************
*   qla2100_set_info
*
* Description:
*   Set parameters for the driver from the /proc filesystem.
*
* Returns:
*************************************************************************/
int
qla2100_set_info(char *buffer, int length, struct Scsi_Host *HBAptr) {
    return (-ENOSYS);  /* Currently this is a no-op */
}


#include "qla2x00ioctl.c"


/*************************************************************************
* qla2100_proc_info
*
* Description:
*   Return information to handle /proc support for the driver.
*
* inout : decides on the direction of the dataflow and the meaning of the
*         variables
* buffer: If inout==FALSE data is being written to it else read from it
*         (ptrs to a page buffer)
* *start: If inout==FALSE start of the valid data in the buffer
* offset: If inout==FALSE offset from the beginning of the imaginary file
*         from which we start writing into the buffer
* length: If inout==FALSE max number of bytes to be written into the buffer
*         else number of bytes in the buffer
* Returns:
*************************************************************************/
#define	PROC_BUF	(&qla2100_buffer[len])
int
qla2100_proc_info( char *buffer, char **start, off_t offset, int length,
int hostno, int inout) {
#if QLA2100_PROFILE
    struct Scsi_Host *host;
    scsi_qla_host_t *ha;
    int    size = 0;
    scsi_lu_t  *up;
    int   len = 0;
    qla_boards_t   *bdp;
    uint32_t        t, l;

#if REQ_TRACE
    Scsi_Cmnd       *cp;
    srb_t           *sp;
    int i;
#endif
    
    DEBUG5(printk("Entering proc_info 0x%x,0x%lx,0x%x,0x%x\n",(int)buffer,offset,length,hostno);)
    host = NULL;

    /* Find the host that was specified */
    for( ha=qla2100_hostlist; (ha != NULL) && ha->host->host_no != hostno; ha=ha->next )
        ;

    /* if host wasn't found then exit */
    if( !ha ) {
        size = sprintf(buffer, "Can't find adapter for host number %d\n", hostno);
        if( size > length ) {
            return (size);
        } else {
            return (0);
        }
    }

    host = ha->host;

    if( inout == TRUE ) /* Has data been written to the file? */
    {
        printk("qla2100_proc: has data been written to the file. \n");
        return (qla2100_set_info(buffer, length, host));
    }


    /*
    * if our old buffer is the right size use it otherwise
    * allocate a new one.
    */
    size = 4096;  /* get a page */
    if( qla2100_buffer_size != size ) {
        /* deallocate this buffer and get a new one */
        if( qla2100_buffer != NULL ) {
            kfree(qla2100_buffer);
            qla2100_buffer_size = 0;
        }
        qla2100_buffer = kmalloc(size, GFP_KERNEL);
    }
    if( qla2100_buffer == NULL ) {
        size = sprintf(buffer, "qla2100 - kmalloc error at line %d\n",
        __LINE__);
        return size;
    }
    /* save the size of our buffer */
    qla2100_buffer_size = size;

    /* start building the print buffer */
    bdp = &QLBoardTbl_fc[ha->devnum];
    qla2100_lip = 1;
    size =  sprintf(PROC_BUF,
    "QLogic PCI to Fibre Channel Host Adapter for ISP2100/ISP2200/ISP2300:\n"     /* 72 */
    "        Firmware version: %2d.%02d.%02d, Driver version %s\n",                /* 66 */
    bdp->fwver[0], bdp->fwver[1], bdp->fwver[2], QLA2100_VERSION);
    len += size;

#if 0
    size = sprintf(PROC_BUF, 
           "FC HBA: %s; HBA Serial# %x%x%x\n", 
            bdp->bdName,
            ha->serial0,
            ha->serial1,
            ha->serial2);
    len += size;

    size = sprintf(PROC_BUF, 
           "[%c%c%c%c%c%c]; Part#%c%c%c%c%c%c%c%c; FRU#%c%c%c%c%c%c%c%c; EC#%c%c%c%c%c%c%c%c\n", 
            ha->oem_string[0],
            ha->oem_string[1],
            ha->oem_string[2],
            ha->oem_string[3],
            ha->oem_string[4],
            ha->oem_string[5],

            ha->oem_part[0],
            ha->oem_part[1],
            ha->oem_part[2],
            ha->oem_part[3],
            ha->oem_part[4],
            ha->oem_part[5],
            ha->oem_part[6],
            ha->oem_part[7],

            ha->oem_fru[0],
            ha->oem_fru[1],
            ha->oem_fru[2],
            ha->oem_fru[3],
            ha->oem_fru[4],
            ha->oem_fru[5],
            ha->oem_fru[6],
            ha->oem_fru[7],

            ha->oem_ec[0],
            ha->oem_ec[1],
            ha->oem_ec[2],
            ha->oem_ec[3],
            ha->oem_ec[4],
            ha->oem_ec[5],
            ha->oem_ec[6],
            ha->oem_ec[7]);
    len += size;
#endif

    size = sprintf(PROC_BUF, "Request Queue = 0x%lx, Response Queue = 0x%lx\n",
    (long unsigned int)ha->request_dma,
    (long unsigned int)ha->response_dma);
    len += size;
    size = sprintf(PROC_BUF, "Request Queue count= %ld, Response Queue count= %ld\n",
    (long)REQUEST_ENTRY_CNT,
    (long)RESPONSE_ENTRY_CNT);
    len += size;
    size = sprintf(PROC_BUF, "Number of pending commands = 0x%lx\n", ha->actthreads);
    len += size;
    size = sprintf(PROC_BUF, "Number of queued commands = 0x%lx\n", ha->qthreads);
    len += size;
    size = sprintf(PROC_BUF, "Number of free request entries = %d\n",ha->req_q_cnt);
    len += size;
    size = sprintf(PROC_BUF, "Number of mailbox timeouts = %ld\n",qla2100_stats.mboxtout);
    len += size;
    size = sprintf(PROC_BUF, "Number of ISP aborts = %ld\n",qla2100_stats.ispAbort);
    len += size;
    size = sprintf(PROC_BUF, "Number of loop resyncs = %ld\n",qla2100_stats.ispAbort);
    len += size;
    size = sprintf(PROC_BUF, "Number of retries for empty slots = %ld\n",qla2100_stats.outarray_full);
    len += size;
    size = sprintf(PROC_BUF, "Number of reqs in retry_q = %ld\n",qla2100_stats.retry_q_cnt);
    len += size;
    size = sprintf(PROC_BUF, "Number of reqs in done_q = %ld\n",qla2100_stats.done_q_cnt);
    len += size;

#if REQ_TRACE
    if ( qla2100_req_dmp ) {
    	size  = sprintf(PROC_BUF,"Outstanding Commands on controller:\n");
    	len += size;
    	for( i=0; i < MAX_OUTSTANDING_COMMANDS; i++ ) {
      	if( (sp = ha->outstanding_cmds[i]) == NULL )
                 	continue;
      	if( (cp = sp->cmd) == NULL )
               continue;
        size = sprintf(PROC_BUF,
           "(%d): Pid=%ld, sp flags=0x%x, cmd=0x%p, state=%x handle=%x\n\r",
           i, (int)sp->cmd->pid, (long)sp->flags,
           CMD_SP(sp->cmd),(int)sp->state,CMD_HANDLE(sp->cmd));

      	len += size;
        if( len >= qla2100_buffer_size )
                goto profile_stop;
    	}
    }
#endif

    /* 2.25 node/port display to proc */
    /* Display the node name for adapter */
    size = sprintf(PROC_BUF, "\nSCSI Device Information:\n");
    len += size;
    size = sprintf(PROC_BUF,
           "scsi-qla%d-adapter-node=%02x%02x%02x%02x%02x%02x%02x%02x;\n",
           (int)ha->instance,
           ha->init_cb->node_name[0],
           ha->init_cb->node_name[1],
           ha->init_cb->node_name[2],
           ha->init_cb->node_name[3],
           ha->init_cb->node_name[4],
           ha->init_cb->node_name[5],
           ha->init_cb->node_name[6],
           ha->init_cb->node_name[7]);
    len += size;

    /* display the port name for adapter */
    size = sprintf(PROC_BUF,
           "scsi-qla%d-adapter-port=%02x%02x%02x%02x%02x%02x%02x%02x;\n",
           (int)ha->instance,
           ha->init_cb->port_name[0],
           ha->init_cb->port_name[1],
           ha->init_cb->port_name[2],
           ha->init_cb->port_name[3],
           ha->init_cb->port_name[4],
           ha->init_cb->port_name[5],
           ha->init_cb->port_name[6],
           ha->init_cb->port_name[7]);
    len += size;

    /* Print out device port names */
    for (i = 0; i < MAX_FIBRE_DEVICES; i++) {
         if (ha->fc_db[i].loop_id == PORT_UNUSED)
                        continue;

         size = sprintf(PROC_BUF,
                    "scsi-qla%d-target-%d=%08x%08x;\n",
                    (int)ha->instance, i,
                    ha->fc_db[i].name[1],
                    ha->fc_db[i].name[0]);
         len += size;
    } /* 2.25 node/port display to proc */

    size = sprintf(PROC_BUF, "\nSCSI LUN Information:\n");
    len += size;
    size = sprintf(PROC_BUF, "(Id:Lun)\n");
    len += size;
    /* scan for all equipment stats */
    for (t = 0; t < MAX_FIBRE_DEVICES; t++) {
        /* valid target */
        if (ha->fc_db[t].loop_id == PORT_UNUSED)
            continue;
        /* scan all luns */
        for( l = 0; l < ha->max_luns; l++ ) {
            up = (scsi_lu_t *) GET_LU_Q(ha, 0, t, l);
            if( up == NULL )
                continue;
            if( up->io_cnt == 0 || up->io_cnt < 5)
                continue;
            /* total reads since boot */
            /* total writes since boot */
            /* total requests since boot  */
            size = sprintf(PROC_BUF, "(%2d:%2d): Total reqs %ld,",t,l,up->io_cnt);
            len += size;
            /* current number of pending requests */
            size = sprintf(PROC_BUF, " Pending reqs %d,",up->q_outcnt);
            len += size;

            /* current number of pending requests */
            size = sprintf(PROC_BUF, " Queued reqs %d,",(int)up->q_incnt);
            len += size;
            size = sprintf(PROC_BUF, "\n");
            len += size;
            if( len >= qla2100_buffer_size )
                goto profile_stop;
        }
        if( len >= qla2100_buffer_size )
            break;
    }

    profile_stop:
    if( len >= qla2100_buffer_size ) {
        printk(KERN_WARNING "qla2100: Overflow buffer in qla2100_proc.c\n");
    }

    if( offset > len - 1 ) {
        kfree(qla2100_buffer);
        qla2100_buffer = NULL;
        qla2100_buffer_size = length = 0;
        *start = NULL;
    } else {
        *start = &qla2100_buffer[offset];   /* Start of wanted data */
        if( len - offset < length ) {
            length = len - offset;
        }
    }
    return (length);
#else
    return (0);
#endif

}

/**************************************************************************
* qla2100_detect
*
* Description:
*    This routine will probe for Qlogic FC SCSI host adapters.
*    It returns the number of host adapters of a particular
*    type that were found.	 It also initialize all data necessary for
*    the driver.  It is passed-in the host number, so that it
*    knows where its first entry is in the scsi_hosts[] array.
*
* Input:
*     template - pointer to SCSI template
*
* Returns:
*  num - number of host adapters found.
**************************************************************************/
int
qla2100_detect(Scsi_Host_Template *template) {
    struct Scsi_Host *host;
    scsi_qla_host_t *ha, *cur_ha;
    struct _qlaboards  *bdp;
    int i, j;
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
    unsigned short subsys;
#endif
#if LINUX_VERSION_CODE <= KERNEL_VERSION(2,1,95)
    unsigned int piobase;
    unsigned char pci_bus, pci_devfn, pci_irq;
    config_reg_t   *cfgp = 0;
#endif
    device_reg_t   *reg;
    char   *cp;
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,95)
    struct pci_dev *pdev = NULL;
#else
    int index;
#endif
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
    struct semaphore sem = MUTEX_LOCKED;
#else
    DECLARE_MUTEX_LOCKED(sem);
#endif

    unsigned long wait_switch = 0; 


    ENTER("qla2100_detect");

    if( sizeof(srb_t) > sizeof(Scsi_Pointer) ) 
        printk("qla2x00: [[WARNING]] srb_t must be re-defined  - its too big");

#ifdef CODECHECK
    if( sizeof(srb_t) > sizeof(Scsi_Pointer) ) {
        printk("Redefine srb_t - its too big");
        return 0;
    }
#endif

#ifdef MODULE
    DEBUG2(sprintf(debug_buff,"DEBUG: qla2100_detect starts at address = 0x%8lx\n",(uint32_t)qla2100_detect);)
    DEBUG2(qla2100_print(debug_buff);)
    /*
    * If we are called as a module, the qla2100 pointer may not be null
    * and it would point to our bootup string, just like on the lilo
    * command line.  IF not NULL, then process this config string with
    * qla2100_setup
    *
    * Boot time Options
    * To add options at boot time add a line to your lilo.conf file like:
    * append="qla2100=verbose,tag_info:{{32,32,32,32},{32,32,32,32}}"
    * which will result in the first four devices on the first two
    * controllers being set to a tagged queue depth of 32.
    */
    if( ql2xopts )
        qla2100_setup(ql2xopts, NULL);
    if( dummy_buffer[0] != 'P' )
        printk(KERN_WARNING "qla2100: Please read the file /usr/src/linux/drivers"
        "/scsi/README.qla2100\n"
        "qla2100: to see the proper way to specify options to the qla2100 "
        "module\n"
        "qla2100: Specifically, don't use any commas when passing arguments to\n"
        "qla2100: insmod or else it might trash certain memory areas.\n");
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
    if( (int) !pcibios_present() ) 
#else 
    if (!pci_present())
#endif
    {
        printk("scsi: PCI not present\n");
        return 0;
    } /* end of IF */

    bdp = &QLBoardTbl_fc[0];
    qla2100_hostlist = NULL;
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
    template->proc_dir = &proc_scsi_qla2100;

#else
    template->proc_name = "qla2x00";
#endif
    /* Try and find each different type of adapter we support */
    for( i=0; bdp->device_id != 0 && i < NUM_OF_ISP_DEVICES; i++, bdp++ ) {
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,95)
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,3,18)
                /* PCI_SUBSYSTEM_IDS supported */ 
		while ((pdev = pci_find_subsys(QLA2100_VENDOR_ID,
			bdp->device_id, PCI_ANY_ID, PCI_ANY_ID, pdev) )) {
			if (pci_enable_device(pdev)) continue;
#else
		while ((pdev = pci_find_device(QLA2100_VENDOR_ID,
			bdp->device_id, pdev ) ))  {
#endif /* 2,3,18 */
#else  /* less than 2,1,95 */  
		while (!(pcibios_find_device(QLA2100_VENDOR_ID,
			bdp->device_id,
			index++, &pci_bus, &pci_devfn)) )  {
#endif /* 2,1,95 */ 
                /* found a adapter */
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,3,18)
                  printk("qla2x00: detect() found an HBA\n");
		  printk("qla2x00: VID=%x DID=%x SSVID=%x SSDID=%x\n",
			pdev->vendor, pdev->device,
			pdev->subsystem_vendor, pdev->subsystem_device); 
		  /* If it's an XXX SubSys Vendor ID adapter, skip it. */
                 /* if (pdev->subsystem_vendor == PCI_VENDOR_ID_XXX) 
                    { 
                      printk("qla2x00:Skip XXX SubSys Vendor ID Controller\n");
                      continue;
                    } */
#else
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,95)
		  pci_read_config_word(pdev, PCI_SUBSYSTEM_VENDOR_ID,
                                       &subsys);
		  /* Bypass all XXX SUBSYS VENDOR IDs */
                 /* if (subsys == PCI_VENDOR_ID_XXX) 
                    { 
                      printk("qla2x00:Skip XXX SubSys Vendor ID Controller\n");
                      continue;
                    } */
#endif /* 2,1,95 */
#endif /* 2,3,18 */
                host = scsi_register(template, sizeof(scsi_qla_host_t));
                ha = (scsi_qla_host_t *) host->hostdata;
                /* Clear our data area */
                for( j =0, cp = (char *)ha;  j < sizeof(scsi_qla_host_t); j++, cp++ )
                    *cp = 0;
                /* Sanitize the information from PCI BIOS.  */
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,95)
                host->irq = pdev->irq;
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
                host->io_port = (unsigned long) pdev->base_address[0];
#else
                host->io_port = pdev->resource[0].start;
#endif
                ha->pci_bus = pdev->bus->number;
                ha->pci_device_fn = pdev->devfn;
                ha->pdev = pdev;
#else
                pcibios_read_config_byte(pci_bus, pci_devfn, OFFSET(cfgp->interrupt_line), &pci_irq);
                pcibios_read_config_dword(pci_bus, pci_devfn, OFFSET(cfgp->base_port), &piobase);
                host->irq = pci_irq;
                host->io_port = (unsigned int) piobase;
                ha->pci_bus = pci_bus;
                ha->pci_device_fn = pci_devfn;
#endif
                ha->device_id = bdp->device_id;
                host->io_port &= PCI_BASE_ADDRESS_IO_MASK;
                ha->devnum = i;
                if( qla2100_verbose ) {
                    printk("(scsi): Found a %s @ bus %d, device 0x%x, irq %d, iobase 0x%lx\n",
                    bdp->bdName,ha->pci_bus, (ha->pci_device_fn & 0xf8) >> 3, host->irq,(unsigned long)host->io_port);
                }

                ha->iobase     = (device_reg_t *)     host->io_port;
                ha->iobase2300 = (device2300_reg_t *) host->io_port;
                ha->host = host;

                /* 4.23 Initialize /proc/scsi/qla2x00 counters */
                ha->actthreads = 0;
                ha->qthreads   = 0;
                ha->dump_done  = 0;
                ha->isp_aborts = 0;
                ha->lip_count = 0;

                if( qla2100_mem_alloc(ha) ) {
                    printk(KERN_INFO "qla2100: Failed to allocate memory for adapter\n");
                }
                ha->prev_topology = 0;
                ha->ports = bdp->numPorts;
                ha->host_no = host->host_no;

                /* 4.10 */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
                ha->ioctl_mem      = (void *)KMALLOC(PAGE_SIZE);
                ha->ioctl_mem_phys =  VIRT_TO_BUS(ha->ioctl_mem);
#else
                /* get consistent memory allocated for ioctl I/O operations */
                ha->ioctl_mem = pci_alloc_consistent(ha->pdev, PAGE_SIZE, 
                                                     &ha->ioctl_mem_phys);
#endif

                if (ha->ioctl_mem == NULL) {
                   printk("qla2100: ERROR in ioctl physical memory allocation\n");
                   return(0);
                }

                if( ha->device_id == QLA2100_DEVICE_ID )
                    ha->max_targets = MAX_TARGETS_2100;
                else
                    ha->max_targets = MAX_TARGETS_2200;

                /* load the F/W, read paramaters, and init the H/W */
                ha->instance = num_hosts;

                if( qla2100_initialize_adapter(ha) ) {

                    printk("qla2100_detect: Failed to initialize adapter\n");
                    qla2100_mem_free(ha);
                    scsi_unregister(host);
                    continue;
                }
                ha->next = NULL;
                /*  Mark preallocated Loop IDs in use. */
                ha->fabricid[SNS_FL_PORT].in_use = TRUE;
                ha->fabricid[FABRIC_CONTROLLER].in_use = TRUE;
                ha->fabricid[SIMPLE_NAME_SERVER].in_use = TRUE;


                /* Register our resources with Linux */
                if( qla2100_register_with_Linux(ha, bdp->numPorts-1) ) {
                    printk(KERN_INFO "qla2100: Failed to register our resources\n");
                    qla2100_mem_free(ha);
                    scsi_unregister(host);
                    continue;
                }

                /* reg uses here in detect() are common: 2100/2200/2300 */
                reg = ha->iobase;
                /* Disable ISP interrupts. */
                qla2100_disable_intrs(ha);

                /*
                * Startup the kernel thread for this host adapter
                */

                ha->dpc_notify = &sem;
                kernel_thread((int (*)(void *))qla2100_do_dpc,
                (void *) ha, 0);

                /*
                * Now wait for the kernel dpc thread to initialize and go to sleep.
                */
                down(&sem);
                ha->dpc_notify = NULL;

                /*
                * These locks are used to prevent more than one CPU from modifying the queue at
                * the same time. The higher level "io_request_lock" will reduce most contention
                * for these locks.
                */
                ha->retry_lock = SPIN_LOCK_UNLOCKED;

                /* Insure mailbox registers are free. */
                WRT_REG_WORD(&reg->semaphore, 0);
                WRT_REG_WORD(&reg->host_cmd, HC_CLR_RISC_INT);
                WRT_REG_WORD(&reg->host_cmd, HC_CLR_HOST_INT);

		/* Wait around max 5 secs for the devices to come on-line */
		/* we don't want Linux scanning before we are ready       */ 
                /* v2.19.5b6                                              */
	        for (wait_switch = jiffies + (ha->loop_reset_delay * HZ); 
                        wait_switch > jiffies  && 
                        !(ha->device_flags & DFLG_FABRIC_DEVICES) ;) {
                     qla2100_check_fabric_devices(ha);
                }
                /* just in case we turned it on */
	        ha->dpc_flags &= ~COMMAND_WAIT_NEEDED;

                /* List the target we have found */
                qla2100_display_fc_names(ha);

                /* Enable chip interrupts. */
                qla2100_enable_intrs(ha);
                /* Insert new entry into the list of adapters */
                ha->next = NULL;
                if( qla2100_hostlist == NULL ) {
                    qla2100_hostlist = ha;
                } else {
                    cur_ha = qla2100_hostlist;
                    while( cur_ha->next != NULL )
                        cur_ha = cur_ha->next;
                    cur_ha->next = ha;
                }
                num_hosts++;
            }
        } /* end of FOR */

        LEAVE("qla2100_detect");
        return num_hosts;
    }

    /**************************************************************************
    *   qla2100_register_with_Linux
    *
    * Description:
    *   Free the passed in Scsi_Host memory structures prior to unloading the
    *   module.
    *
    * Input:
    *     ha - pointer to host adapter structure
    *     maxchannels - MAX number of channels.
    *
    * Returns:
    *  0 - Sucessfully reserved resources.
    *  1 - Failed to reserved a resource.
    **************************************************************************/
    STATIC uint8_t  qla2100_register_with_Linux(scsi_qla_host_t *ha, uint8_t maxchannels) {

        struct Scsi_Host *host = ha->host;
        char drvname[9];

        host->can_queue = 0xfffff;  /* unlimited  */
        host->cmd_per_lun = 1;
        host->select_queue_depths = qla2100_select_queue_depth;
        host->n_io_port = 0xFF;
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
        host->base = (unsigned char *) ha->mmpbase;
#else
        host->base = (u_long) ha->mmpbase;
#endif
        host->max_channel = maxchannels;
        /* fix: 07/31 host->max_lun = MAX_LUNS-1; */
        host->max_lun = ha->max_luns;
        host->unique_id = ha->instance;
        host->max_id = ha->max_targets;

        /* set our host ID  (need to do something about our two IDs) */
        host->this_id = 255;

        /* Register the I/O space with Linux */
        if( check_region(host->io_port, 0xff) ) {
            printk("qla2100 : Failed to reserved i/o region 0x%04lx-0x%04lx already in use\n",
            host->io_port, host->io_port + 0xff);
            free_irq(host->irq, NULL);
            return 1;
        }

        request_region(host->io_port, 0xff, drvname);

        /* ER# 4368 */
        sprintf(drvname,"qla2x00#%02d",host->unique_id);
        /* Register the IRQ with Linux (sharable) */
        if( request_irq(host->irq, qla2100_intr_handler, SA_INTERRUPT| SA_SHIRQ, "qla2x00", ha) ) {
            printk("qla2100 : Failed to reserved interrupt %d already in use\n", host->irq);
            return 1;
        }

        /* Initialized the timer */
        START_TIMER(qla2100_timer,ha,WATCH_INTERVAL);

        return 0;
    }


    /**************************************************************************
    *   qla2100_release
    *
    * Description:
    *   Free the passed in Scsi_Host memory structures prior to unloading the
    *   module.
    *
    * Input:
    *     ha - pointer to host adapter structure
    *
    * Returns:
    *  0 - Always returns good status
    **************************************************************************/
    int
    qla2100_release(struct Scsi_Host *host) {
        scsi_qla_host_t *ha = (scsi_qla_host_t *) host->hostdata;

        ENTER("qla2100_release");
        /* if adpater is running and online */
        if( !ha->flags.online )
            return(0);

        /* turn-off interrupts on the card */
        qla2100_disable_intrs(ha);

        /* Detach interrupts */
        if( host->irq )
            free_irq(host->irq, ha);

        /* release io space registers  */
        if( host->io_port )
            release_region(host->io_port, 0xff);

        /* Disable timer */
        if( ha->timer_active )
            STOP_TIMER(qla2100_timer,ha)

            /* Kill the kernel thread for this host */
            if( ha->dpc_handler != NULL ) {
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
                struct semaphore sem = MUTEX_LOCKED;
#else
                DECLARE_MUTEX_LOCKED(sem);
#endif

                ha->dpc_notify = &sem;
                send_sig(SIGKILL, ha->dpc_handler, 1);
                down(&sem);
                ha->dpc_notify = NULL;
            }
#if USE_FLASH
            /* Move driver database to flash, if enabled. */
            if( ha->flags.enable_flash_db_update && ha->flags.updated_fc_db ) {
                ha->flags.updated_fc_db = FALSE;
                qla2100_save_database(ha);
            }
#endif
#if MEMORY_MAPPED_IO
            if( ha->mmpbase ) {
                iounmap((void *) (((unsigned long) ha->mmpbase) & PAGE_MASK));
            }
#endif /* MEMORY_MAPPED_IO */

#if  APIDEV
            apidev_cleanup();
#endif

            qla2100_mem_free(ha);
            ha->flags.online = FALSE;

            LEAVE("qla2100_release");
            return(0);
    }

    /**************************************************************************
    *   qla2100_info
    *
    * Description:
    *
    * Input:
    *     host - pointer to Scsi host adapter structure
    *
    * Returns:
    *     Return a text string describing the driver.
    **************************************************************************/
    const char *
    qla2100_info(struct Scsi_Host *host) {
        static char qla2100_buffer[255];
        char *bp;
        scsi_qla_host_t *ha;
        qla_boards_t   *bdp;

#if  APIDEV
/* We must create the api node here instead of qla2100_detect since we want
   the api node to be subdirectory of /proc/scsi/qla2x00 which will not
   have been created when qla2100_detect exits, but which will have been
   created by this point. */

        apidev_init(host);
#endif
        bp = &qla2100_buffer[0];
        ha = (scsi_qla_host_t *)host->hostdata;
        bdp = &QLBoardTbl_fc[ha->devnum];
        memset(bp, 0, sizeof(qla2100_buffer));
        sprintf(bp,
        "QLogic %sPCI to Fibre Channel Host Adapter: bus %d device %d irq %d\n"
        "        Firmware version: %2d.%02d.%02d, Driver version %s",
        (char *)&bdp->bdName[0], ha->pci_bus, (ha->pci_device_fn & 0xf8) >> 3, host->irq,
        bdp->fwver[0], bdp->fwver[1], bdp->fwver[2], QLA2100_VERSION);
        return(bp);
    }

    /**************************************************************************
    *   qla1200_queuecommand
    *
    * Description:
    *     Queue a command to the controller.
    *
    * Input:
    *     cmd - pointer to Scsi cmd structure
    *     fn - pointer to Scsi done function
    *
    * Returns:
    *   0 - Always
    *
    * Note:
    * The mid-level driver tries to ensures that queuecommand never gets invoked
    * concurrently with itself or the interrupt handler (although the
    * interrupt handler may call this routine as part of request-completion
    * handling).
    **************************************************************************/
    int
    qla2100_queuecommand(Scsi_Cmnd *cmd, void (*fn)(Scsi_Cmnd *)) {
        scsi_qla_host_t *ha;
        srb_t  *sp;
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,95)
        unsigned long cpu_flags = 0;
#endif
        struct Scsi_Host *host;
        uint32_t        b, t, l;
        scsi_lu_t       *q;
        u_long          handle;

        ENTER("qla2100_queuecommand");
        COMTRACE('C') 

        host = cmd->host;
        ha = (scsi_qla_host_t *) host->hostdata;
        /* Get our SCSI request pointer
        * SCp always point to it - see definition in qla2100.h.
        */
        sp = (srb_t *) CMD_SP(cmd);
        sp->cmd =  cmd;
        cmd->scsi_done = fn;

        /* If we not trying to do a recovery procedure of some sort
        * then this is probably a new command.
        */
        if( cmd->flags == 0 &&
        cmd->retries == 0 )
            sp->flags = 0;

        /* Generate LU queue on bus, target, LUN */
        b = SCSI_BUS_32(cmd);
        t = SCSI_TCN_32(cmd);
        l = SCSI_LUN_32(cmd);

        DEBUG5(qla2100_print_scsi_cmd(cmd);)
        DEBUG5(sprintf(debug_buff,"qla2100_queuecmd: pid=%d, opcode=%d, timeout=%d\n",cmd->pid,cmd->cmnd[0],CMD_TIMEOUT(cmd));)
        DEBUG5(qla2100_print(debug_buff);)

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
        /*DEBUG(sprintf(debug_buff,"\n\nQC: t=%x CDB=%x Size=%x\n\r",
        t,cmd->cmnd[0],CMD_XFRLEN(cmd));)
        DEBUG(qla2100_print(debug_buff)); */ 
#endif
        /*
        * We found all the devices at LIP time, and created a device
        * table for them, so we only need to check the table to see
        * if the device is present. if PORT_AVAILABLE or PORT_UNUSED
        * then no target exists.
        *
        * We return DID_NO_CONNECT if the loop is down after loop down
        * timer has expired.
        */
        if( TGT_Q(ha,b,t) == NULL ||
           (TGT_Q(ha,b,t) && TGT_Q(ha,b,t)->loop_id > LAST_SNS_LOOP_ID)  ) {
            /* DEBUG2(printk("scsi(%2d:%2d:%2d:%2d): port unavailable\n",
            (int)ha->host_no,b,t,l);) */ 
            CMD_RESULT(sp->cmd) = DID_NO_CONNECT << 16;
            qla2100_callback(ha,sp,FALSE);
            LEAVE("qla2100_queuecommand");
            return(0);
        }
        /* v218b4 */ 
        if (ha->loop_down_timer == 0 && 
            ha->loop_state == LOOP_DOWN ){  /* 01/21/00 DG */
            DEBUG2(printk("scsi(%2d:%2d:%2d:%2d): Loop down - returning pid=%ld \n",(int)ha->host_no,b,t,l,cmd->pid);)
            CMD_RESULT(sp->cmd) = DID_NO_CONNECT << 16;
            ha->flags.done_requests_needed = TRUE;
            qla2100_done_q_put(ha, sp, (srb_t **)&ha->done_q_first, (srb_t **)&ha->done_q_last);
            LEAVE("qla2100_queuecommand");
            return(0);
        }

        /*
        * Allocate a LUN/DEVICE queue from this request if we haven't
        * already did it on a previous command.
        */
        if( (q = GET_LU_Q(ha, b, t,l)) == NULL ) {
            DRIVER_LOCK
            if( (q = qla2100_lun_alloc()) == NULL ) {
                CMD_RESULT(sp->cmd) = DID_RETRY << 16;
                qla2100_callback(ha,sp,FALSE);
                return(0);
            }
            LU_Q(ha, b, t, l) = q;
            DEBUG(sprintf(debug_buff,"Allocate new device queue 0x%x\n",q));
            DEBUG(qla2100_print(debug_buff));
            DRIVER_UNLOCK
        }

        /* Set an invalid handle until we issue the command to ISP */
        /* then we will set the real handle value.                 */
        handle = INVALID_HANDLE;
        CMD_HANDLE(cmd) = (unsigned char *)handle;

#if QLA2100_EXT_TIMEOUT
        /* Extend timeout for this request */
        qla2100_extend_timeout(cmd,60*HZ);
#endif

        /*
        * SCSI Kluge
        * ========
        * Whenever, we need to wait for an event such as loop down
        * (i.e. loop_down_timer ) or port down (i.e. LUN request qeueue is
        * suspended) then we will recycle new commands back to the SCSI layer.
        * We do this because this is normally a temporary condition and we don't
        * want the mid-level scsi.c driver to get upset and start aborting
        * commands.

        * The timeout value is extracted from the command minus 1-second
        * and put on a retry queue (watchdog). Once the command timeout it
        * is returned to the mid-level with a BUSY status, so the mid-level
        * will retry it. This process continues until the LOOP DOWN time
        * expires or the condition goes away.
        */
        if( ha->loop_down_timer ||
        ha->loop_state ==  LOOP_DOWN ||
        (PORT_DOWN(ha,t) > 0) ||
        ha->loop_state != LOOP_READY ||
        (q->q_flag & QLA2100_QSUSP) ) {
            /* Insert command into watchdog queue */
            qla2100_timeout_insert(ha, sp);
            LEAVE("qla2100_queuecommand");
            return (0);
        }
        /* Set retry count if this is a new command */
        if( sp->flags == 0 &&
        !(q->q_flag & QLA2100_QSUSP) ) {
            sp->retry_count = ha->retry_count;
            if( TGT_Q(ha, b, t)->down_timer == 0 ) 
	    	sp->port_down_retry_count = ha->port_down_retry_count;
            DEBUG3(qla2100_print(debug_buff));
        }

        /* No timeout necessary, because the upper layer is doing it for us */
        sp->wdg_time = 0;

        /* add the command to our queue */
        ha->qthreads++;
        qla2100_putq_t(q,sp);

        DEBUG5(sprintf(debug_buff,"\nQC: queue pid=%d, hndl=0x%x\n\r",
               cmd->pid,handle));
        DEBUG5(qla2100_print(debug_buff));

        /* send command to adapter */
        qla2100_restart_queues(ha,FALSE);

        COMTRACE('c')
        LEAVE("qla2100_queuecommand"); 
        return (0);
    }

    /**************************************************************************
    *   qla1200_abort
    *
    * Description:
    *     Abort the specified SCSI command.
    *
    * Input:
    *     cmd - pointer to Scsi cmd structure
    *
    * Returns:
    **************************************************************************/
    int
    qla2100_abort(Scsi_Cmnd *cmd) {
        scsi_qla_host_t *ha;
        srb_t  *sp;
        srb_t  *rp, *rp_next;
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,95)
        unsigned long cpu_flags = 0;
#endif
        struct Scsi_Host *host;
        uint32_t        b, t, l;
        scsi_lu_t       *q;
        int return_status = SCSI_ABORT_SUCCESS;
        int found = 0;
        int i;
        u_long          handle;

        uint16_t    data;

        ENTER("qla2100_abort");
        COMTRACE('A')

        ha = (scsi_qla_host_t *) cmd->host->hostdata;
        host = cmd->host;

#if DEBUG_GET_FW_DUMP
        if (ha->device_id == QLA2300_DEVICE_ID)
        {  
          if (ha->dump_done != 1) {
              DEBUG(sprintf(debug_buff,"\nqla2100_abort handle=%x: >>>>>>> DUMP 2300 FW <<<<<<<\n",CMD_HANDLE(cmd));)
              DEBUG(qla2100_print(debug_buff);)
              qla2300_dump_isp(ha);
              ha->dump_done = 1;
          }
        }
#endif

        DRIVER_LOCK
        /* Get the SCSI request ptr */
        sp = (srb_t *) CMD_SP(cmd);

        /*
        * if the handle is NULL then we already completed the command.
        * We always give the handle a value of "INVALID_HANDLE" when
        * we received it.
        */
        if( (u_long)   CMD_HANDLE(cmd) == 0L ) {

            DRIVER_UNLOCK
#if  STOP_ON_ABORT
            qla2100_panic("qla2100_abort",ha->host);
#endif
            return(SCSI_ABORT_NOT_RUNNING);  /* no action - we don't have command */
        }

        /* Check for a pending interrupt. */
        if (ha->device_id == QLA2300_DEVICE_ID) 
             data = qla2100_debounce_register((uint16_t *)&ha->iobase2300->host_status) &   RISC_2300_INT;
        else data = qla2100_debounce_register(&ha->iobase->istatus) & 
                    RISC_INT;

        /* Check for pending interrupts. */
        if( !(ha->flags.in_isr) && (data)) {
            /* Add any completed commands in the done queue */
            DEBUG(qla2100_print("qla2100_abort: Calling isr\n");)
            qla2100_isr(ha, (srb_t **)&ha->done_q_first, (srb_t **)&ha->done_q_last);
        }

        /*
        * if no LUN queue then something is very wrong!!!
        */
        handle = (u_long) CMD_HANDLE(cmd);

        /* Generate LU queue on bus, target, LUN */
        b = SCSI_BUS_32(cmd);
        t = SCSI_TCN_32(cmd);
        l = SCSI_LUN_32(cmd);
        if( (q = GET_LU_Q(ha, b, t, l)) == NULL ) {
            COMTRACE('a')

            DRIVER_UNLOCK
            printk(KERN_WARNING "qla2100 (%d:%d:%d): No LUN queue for the specified device\n",(int)b,(int)t,(int)l);
            return(SCSI_ABORT_NOT_RUNNING);  /* no action - we don't have command */
        }

#if AUTO_ESCALATE_ABORT
        if( (sp->flags & SRB_ABORTED) ) {
            DRIVER_UNLOCK
            DEBUG(qla2100_print("qla2100_abort: Abort escalayted - returning SCSI_ABORT_SNOOZE.\n\r"));
            return(SCSI_ABORT_SNOOZE);
        }
#endif
        /*
        * if the command ahs a abort pending then tell the upper layer
        */
        if( (sp->flags & SRB_ABORT_PENDING) ) {
            COMTRACE('a')
            DRIVER_UNLOCK
            if( qla2100_verbose )
                printk("scsi(): Command has a pending abort message - ABORT_PENDING.\n");
            DEBUG(qla2100_print("qla2100: Command has a pending abort message - ABORT_PENDING.\n\r"));
            return(SCSI_ABORT_PENDING);
        }

        DEBUG(sprintf(debug_buff,"ABORTing command= 0x%x, sp=%x sp->state=%x\n",
        (int)cmd,sp,sp->state);)
        DEBUG(qla2100_print(debug_buff);)
        DEBUG(qla2100_print_scsi_cmd(cmd));
#if  STOP_ON_ABORT
#endif

        for( rp = ha->retry_q_first; (rp); rp = rp_next ) {
            rp_next = rp->s_next;
            if( sp != rp )
                continue;
            qla2100_timeout_remove(ha, sp);
            CMD_RESULT(sp->cmd) = DID_BUS_BUSY << 16;
            CMD_HANDLE(sp->cmd) = (unsigned char *) NULL;
            qla2100_done_q_put(ha, sp, (srb_t **)&ha->done_q_first, (srb_t **)&ha->done_q_last);
            found++;
        }

        /*
        * Our SP pointer points at the command we want to remove from the
        * LUN queue providing we haven't already sent it to the adapter.
        */
        if( found )
            return_status = SCSI_ABORT_SUCCESS;
        else if( !(sp->flags&SRB_SENT) ) {
            found++;
            DEBUG(sprintf(debug_buff,"qla2100: Cmd in LUN queue aborted pid %d.\n\r",sp->cmd->pid);)
            DEBUG(qla2100_print(debug_buff);)
            /* Remove srb from SCSI LU queue. */
            qla2100_removeq(q, sp);
            sp->flags |=  SRB_ABORTED;
            CMD_RESULT(cmd) = DID_ABORT << 16;
            qla2100_done_q_put(ha, sp, &ha->done_q_first, &ha->done_q_last);
            return_status = SCSI_ABORT_SUCCESS;
        } else {  /* find the command in our active list */
            for( i = 1; i < MAX_OUTSTANDING_COMMANDS; i++ ) {
                if( sp == ha->outstanding_cmds[i] ) {
                    found++;
                    DEBUG(sprintf(debug_buff,
                          "qla2100: RISC aborting pid %d sp->state=%x\n\r",
                          sp->cmd->pid,sp->state);)
                    DEBUG(qla2100_print(debug_buff);)
                    DEBUG(qla2100_print_scsi_cmd(cmd));
                    DEBUG(qla2100_print_q_info(q);)
                    /* v2.19.8 Ignore abort request if port is down */
                        if ( qla2100_abort_command(ha,sp) ) {
                            DEBUG(printk("qla2100: Failed to abort pid %ld.\n",sp->cmd->pid);)
                            return_status = SCSI_ABORT_NOT_RUNNING;  /* no action */
                        }
                    else
                        return_status = SCSI_ABORT_PENDING;
                    break;
                }
            }
        }

#if  STOP_ON_ABORT
        qla2100_panic("qla2100_abort",ha->host);
#endif
        if( found == 0 )
            return_status = SCSI_ABORT_NOT_RUNNING;  /* no action */

        DEBUG(sprintf(debug_buff, "qla2100_abort: Aborted status returned = 0x%x.\n\r",return_status));
        DEBUG(qla2100_print(debug_buff));
        /*
        * Complete any commands
        */
        if( ha->done_q_first )
            qla2100_done(ha, (srb_t **)&ha->done_q_first, (srb_t **)&ha->done_q_last);

        if( found ) {
            qla2100_restart_queues(ha,TRUE);
        }
        DRIVER_UNLOCK

        LEAVE("qla2100_abort");
        COMTRACE('a')
        return(return_status);
    }

    /**************************************************************************
    * qla1200_reset
    *
    * Description:
    *    The reset function will reset the SCSI bus and abort any executing
    *    commands.
    *
    * Input:
    *      cmd = Linux SCSI command packet of the command that cause the
    *            bus reset.
    *      flags = SCSI bus reset option flags (see scsi.h)
    *
    * Returns:
    *      DID_RESET in cmd.host_byte of aborted command(s)
    *
    * Note:
    *      Resetting the bus always succeeds - is has to, otherwise the
    *      kernel will panic! Try a surgical technique - sending a BUS
    *      DEVICE RESET message - on the offending target before pulling
    *      the SCSI bus reset line.
    **************************************************************************/
    int
    qla2100_reset(Scsi_Cmnd *cmd, unsigned int flags) {
        scsi_qla_host_t *ha;
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,95)
        unsigned long cpu_flags = 0;
#endif
        uint32_t        b, t, l;
        srb_t  *sp;
        typedef enum {
            ABORT_DEVICE = 1,
            DEVICE_RESET = 2,
            BUS_RESET    = 3,
            ADAPTER_RESET= 4,
            RESET_DELAYED= 5,
            FAIL         = 6
        } action_t;
        action_t     action = ADAPTER_RESET;
        uint16_t    data;
        scsi_lu_t       *q;
        int result;


        ENTER("qla2100_reset");
        COMTRACE('R')
        if( cmd == NULL ) {
            printk(KERN_WARNING "(scsi?:?:?:?) Reset called with NULL Scsi_Cmnd "
            "pointer, failing.\n");
            return(SCSI_RESET_SNOOZE);
        }
        ha = (scsi_qla_host_t *) cmd->host->hostdata;
        sp = (srb_t *) CMD_SP(cmd);

#if  STOP_ON_RESET
        sprintf(debug_buff,"ABORTing command= 0x%x\n",(int)cmd);
        qla2100_print(debug_buff);
        qla2100_print_scsi_cmd(cmd);
        qla2100_panic("qla2100_reset",ha->host);
#endif


        DRIVER_LOCK
        if (ha->device_id == QLA2300_DEVICE_ID) 
             data = qla2100_debounce_register((uint16_t *)&ha->iobase2300->host_status) &
                    RISC_2300_INT;
        else data = qla2100_debounce_register(&ha->iobase->istatus) & 
                    RISC_INT;

        /* Check for pending interrupts. */
        if( !(ha->flags.in_isr) && (data) ) {
            DEBUG(qla2100_print("qla2100_reset: Calling isr\n");)
            qla2100_isr(ha, (srb_t **)&ha->done_q_first, (srb_t **)&ha->done_q_last);
        }
        DRIVER_UNLOCK

        /*
        * Determine the suggested action that the mid-level driver wants
        * us to perform.
        */
        if( CMD_HANDLE(cmd) == (unsigned char *) 0 ) {
            /*
            * if mid-level driver called reset with a orphan SCSI_Cmnd
            * (i.e. a command that's not pending ), so perform the
            * function specified.
            */
            /* 4.23 */
            if( (flags & SCSI_RESET_SUGGEST_HOST_RESET) )
                action = ADAPTER_RESET;
            else if( flags & SCSI_RESET_SUGGEST_BUS_RESET )
                action = BUS_RESET;
            else
                action = DEVICE_RESET;
        } else { /*
            * Mid-level driver has called reset with this SCSI_Cmnd and
            * its pending.
            */
            if( flags & SCSI_RESET_SUGGEST_HOST_RESET )
                action = ADAPTER_RESET;
            else if( flags & SCSI_RESET_SUGGEST_BUS_RESET )
                action = BUS_RESET;
            else
                action = DEVICE_RESET;
        }

        b = SCSI_BUS_32(cmd);
        t = SCSI_TCN_32(cmd);
        l = SCSI_LUN_32(cmd);
        q = GET_LU_Q(ha, b, t, l);

#if AUTO_ESCALATE_RESET
        if( (action & DEVICE_RESET) && (q->q_flag & QLA2100_QRESET) ) {
            printk(KERN_INFO "qla2100(%d): Bus device reset already sent to " "device, escalating.\n", (int)ha->host_no);
            action = BUS_RESET;
        }
        if( (action & DEVICE_RESET) && (sp->flags & SRB_ABORT_PENDING) ) {
            printk(KERN_INFO "qla2100(%d):Have already attempted to reach " "device with abort device\n", (int)ha->host_no);
            printk(KERN_INFO "qla2100(%d):message, will escalate to BUS " "RESET.\n",(int) ha->host_no);
            action = BUS_RESET;
        }
#endif

        /*
        *  By this point, we want to already know what we are going to do,
        *  so we only need to perform the course of action.
        */

        DRIVER_LOCK
        result = SCSI_RESET_ERROR;
        switch( action ) {
            case FAIL:
                break;

            case RESET_DELAYED:
                result = SCSI_RESET_PENDING;
                break;

            case ABORT_DEVICE:
                if( qla2100_verbose )
                    printk(KERN_INFO "scsi(%d:%d:%d:%d): ABORT DEVICE ISSUED.\n", (int)ha->host_no,(int)b,(int)t,(int)l);
                qla2100_abort_queue_single(ha,b,t,l,DID_ABORT);
                if( !ha->loop_down_timer )
                    if( qla2100_abort_device(ha, b, t, l) == 0 )
                        result = SCSI_RESET_PENDING;
                    break;

                case DEVICE_RESET:
                    if( qla2100_verbose )
                        printk(KERN_INFO "scsi(%d:%d:%d:%d): DEVICE RESET ISSUED.\n",(int) ha->host_no,(int)b,(int)t,(int)l);
                    for( l = 0; l <  ha->max_luns; l++ )
                        qla2100_abort_queue_single(ha,b,t,l,DID_ABORT);
                    if( !ha->loop_down_timer )
                        if( qla2100_device_reset(ha, b, t) == 0 )
                            result = SCSI_RESET_PENDING;
                        q->q_flag |= QLA2100_QRESET;
                        break;

                    case BUS_RESET:
                        if( qla2100_verbose )
                            printk(KERN_INFO "scsi(%d:%d:%d:%d): LOOP RESET ISSUED.\n",(int) ha->host_no,(int)b,(int)t,(int)l);
                        for( t = 0; t < ha->max_targets; t++ )
                            for( l = 0; l <  ha->max_luns; l++ )
                                qla2100_abort_queue_single(ha,b,t,l,DID_RESET);
                            if( !ha->loop_down_timer )
                                if( qla2100_loop_reset(ha) == 0 )
                                    result = SCSI_RESET_SUCCESS | SCSI_RESET_BUS_RESET;
                                /*
                                * The reset loop routine returns all the outstanding commands back
                                * with "DID_RESET" in the status field.
                                */
                                if( flags & SCSI_RESET_SYNCHRONOUS ) {
                                    CMD_RESULT(cmd) = (int) (DID_BUS_BUSY << 16);
                                    (*(cmd)->scsi_done)(cmd);
                                }

                                /* ha->reset_start = jiffies; */
                                break;

                            case ADAPTER_RESET:
                            default:
                                if( qla2100_verbose ) {
                                        printk(KERN_INFO "scsi(%d:%d:%d:%d): ADAPTER RESET ISSUED.\n",(int) ha->host_no,(int)b,(int)t,(int)l);
                                }
                                ha->flags.reset_active = TRUE;
                                /*
                                * We restarted all of the commands automatically, so the mid-level code can expect
                                * completions momentitarily.
                                */
                                if( qla2100_abort_isp(ha) == 0 )
                                    result = SCSI_RESET_SUCCESS | SCSI_RESET_HOST_RESET;

                                ha->flags.reset_active = FALSE;
        }

        if( ha->done_q_first )
            qla2100_done(ha, (srb_t **)&ha->done_q_first, (srb_t **)&ha->done_q_last);
        qla2100_restart_queues(ha,TRUE);
        DRIVER_UNLOCK

        COMTRACE('r')
        LEAVE("qla2100_reset");
        return(result);
    }

    /**************************************************************************
    * qla1200_biosparam
    *
    * Description:
    *   Return the disk geometry for the given SCSI device.
    **************************************************************************/
    int
    qla2100_biosparam(Disk *disk, kdev_t dev, int geom[]) {
        int heads, sectors, cylinders;

        heads = 64;
        sectors = 32;
        cylinders = disk->capacity / (heads * sectors);
        if( cylinders > 1024 ) {
            heads = 255;
            sectors = 63;
            cylinders = disk->capacity / (heads * sectors);
        }

        geom[0] = heads;
        geom[1] = sectors;
        geom[2] = cylinders;

        return (0);
    }

    /**************************************************************************
    * qla2100_intr_handler
    *
    * Description:
    *   Handles the actual interrupt from the adapter.
    *
    * Context: Interrupt
    **************************************************************************/
    void
    qla2100_intr_handler(int irq, void *dev_id, struct pt_regs *regs) {
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,1,95)
        unsigned long cpu_flags = 0;
#endif
        scsi_qla_host_t *ha;
        uint16_t    data;
        device_reg_t *reg;
        device2300_reg_t *reg2300;

        ENTER_INTR("qla2100_intr_handler");
        COMTRACE('I')
        ha = (scsi_qla_host_t *) dev_id;
        if( !ha ) {
            printk(KERN_INFO "qla2100_intr_handler: NULL host ptr\n");
            COMTRACE('X')
            return;
        }
        ha->isr_count++;
        qla2100_stats.irqhba = ha;

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,1,95)
        /* Prevent concurrent access to adapters register */
        spin_lock_irqsave(&io_request_lock, cpu_flags);
        qla2100_disable_intrs(ha);

        if (ha->device_id == QLA2300_DEVICE_ID) {
             reg2300 = ha->iobase2300;
             data    = qla2100_debounce_register(
                       (uint16_t *)&reg2300->host_status) &  RISC_2300_INT;
        } else {
              reg     = ha->iobase;
              data    = qla2100_debounce_register(&reg->istatus) & 
                        RISC_INT;
         }

        /* Check for pending interrupts. */
        if( data ) {
         /*DEBUG(qla2100_print("qla2100_intr_handler: Int active, Calling isr\n");)*/
          qla2100_isr(ha, 
                     (srb_t **)&ha->done_q_first, 
                     (srb_t **)&ha->done_q_last);
        }

        if( ha->done_q_first )
            qla2100_done(ha, (srb_t **)&ha->done_q_first, (srb_t **)&ha->done_q_last);

        spin_unlock_irqrestore(&io_request_lock, cpu_flags);
        qla2100_enable_intrs(ha);

        /* Wakeup the DPC routine */
        if( (!ha->flags.mbox_busy && (ha->flags.isp_abort_needed   ||
        ha->flags.reset_marker       ||
        ha->flags.update_config_needed       ||
        ( !ha->flags.loop_resync_active &&
        ha->flags.loop_resync_needed)  ) )
        && ha->dpc_wait && !ha->dpc_active ) {  /* v2.19.4 */
            up(ha->dpc_wait);
        }

#else /* LINUX_VERSION_CODE < KERNEL_VERSION(2,1,95) */

        /* Prevent concurrent access to istatus register */
        if( test_bit(QLA2100_IN_ISR_BIT, (int *)&ha->flags) ) {
            COMTRACE('X')
            DEBUG(printk("scsi%d: Already in interrupt - returning \n", (int)ha->host_no);)
            return;
        }
        set_bit(QLA2100_IN_ISR_BIT, (int *)&ha->flags);
        qla2100_disable_intrs(ha);

        if (ha->device_id == QLA2300_DEVICE_ID) { 
           reg2300 = ha->iobase2300;
           data = qla2100_debounce_register(
                  (uint16_t *)&reg2300->host_status) & RISC_2300_INT;
        } else {
           reg  = ha->iobase;
           data = qla2100_debounce_register(&reg->istatus) & 
                  RISC_INT;
        }

        /* Check for pending interrupts. */
        if( data ) {
            DEBUG(qla2100_print("qla2100_intr_handler_2: Int active, Calling isr\n");)
            qla2100_isr(ha, 
                        (srb_t **)&ha->done_q_first, 
                        (srb_t **)&ha->done_q_last);
        }

        if( ha->done_q_first )
            qla2100_done(ha, (srb_t **)&ha->done_q_first, (srb_t **)&ha->done_q_last);


        /* Schedule the DPC routine */
        if( (ha->flags.isp_abort_needed   ||
        ha->flags.reset_marker       ||
        ( !ha->flags.loop_resync_active &&
        ha->flags.loop_resync_needed) ||
        ha->done_q_first ) && !ha->flags.dpc_sched ) {

            ha->run_qla_bh.data = (void *) ha;
            ha->run_qla_bh.routine = qla2100_do_dpc;

            COMTRACE('P')
            queue_task_irq(&ha->run_qla_bh,&tq_scheduler);
            ha->flags.dpc_sched = TRUE;
        }
        clear_bit(QLA2100_IN_ISR_BIT, (int *)&ha->flags);
        qla2100_enable_intrs(ha);
#endif

        COMTRACE('i')
        LEAVE_INTR("qla2100_intr_handler");
    }
    /**************************************************************************
    * qla2100_do_dpc
    *   This kernel thread is a task that is schedule by the interrupt handler
    *   to perform the background processing for interrupts.
    *
    * Notes:
    * This task always run in the context of a kernel thread.  It
    * is kick-off by the driver's detect code and starts up
    * up one per adapter. It immediately goes to sleep and waits for
    * some fibre event.  When either the interrupt handler or
    * the timer routine detects a event it will one of the task
    * bits then wake us up.
    **************************************************************************/
    void
    qla2100_do_dpc(void *p) {
        scsi_qla_host_t *ha = (scsi_qla_host_t *) p;
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
        struct semaphore sem = MUTEX_LOCKED;
#else 
        DECLARE_MUTEX_LOCKED(sem);
#endif
        unsigned long flags;
        srb_t *sp, *sp_next;
        uint32_t        b, t, l;
        scsi_lu_t       *q;
        int status;

        lock_kernel();

        /*
        * If we were started as result of loading a module, close all of the
        * user space pages.  We don't need them, and if we didn't close them
        * they would be locked into memory.
        */
        exit_mm(current);

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,3,18)

        daemonize();

#endif
        current->session = 1;
        current->pgrp = 1;
        /*
        * FIXME(dg) this is still a child process of the one that did the insmod.
        * This needs to be attached to task[0] instead.
        */

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
        siginitsetinv(&current->blocked, SHUTDOWN_SIGS);
#else
        siginitsetinv(&current->blocked, sigmask(SIGKILL));  
#endif
        current->fs->umask = 0;

        /*
        * Set the name of this process.
        */
        sprintf(current->comm, "qla2100_dpc_%d", (int)ha->host_no);

        ha->dpc_wait = &sem;
        ha->dpc_handler = current;

        unlock_kernel();

        /*
        * Wake up the thread that created us.
        */
        DEBUG(printk("qla2100_dpc: Wake up parent %d\n", ha->dpc_notify->count.counter));

        up(ha->dpc_notify);

        while( 1 ) {
            /*
            * If we get a signal, it means we are supposed to go
            * away and die.  This typically happens if the user is
            * trying to unload a module.
            */
            DEBUG(printk("qla2100 %d: DPC handler sleeping\n",(int)ha->host_no));
            down_interruptible(&sem);

            if( signal_pending(current) )
                break;   /* get out */

            DEBUG(printk("qla2100 %d: DPC handler waking up\n",(int)ha->host_no);)

	    if (ha->dpc_flags & COMMAND_WAIT_NEEDED) {
		    /* Release task daemon lock. */
                    DEBUG(printk("Waiting on commands to complete\n");)
		    if( qla2100_cmd_wait(ha) )
                       continue;
		    /* Acquire task daemon lock. */
	    }
            spin_lock_irqsave(&io_request_lock, flags);
            ha->dpc_active = 1;

            /* Determine what action is necessary */

            /* Flush all commands in watchdog queue */
            if( ha->flags.port_restart_needed ) {
                DEBUG(qla2100_print("qla2100: DPC port restarting - flushing all cmds in watchdog queue.\n");)
                ha->flags.port_restart_needed = FALSE;
                for( sp = ha->retry_q_first; (sp != NULL); sp =  sp_next ) {
                    sp_next = sp->s_next;
                    b = SCSI_BUS_32(sp->cmd);
                    t = SCSI_TCN_32(sp->cmd);
                    l = SCSI_LUN_32(sp->cmd);
                    if( (q = GET_LU_Q(ha, b, t,l)) == NULL ||
                    !(q->q_flag & QLA2100_QSUSP) )
                        continue;
                    q->q_flag &= ~QLA2100_QSUSP;
                    qla2100_timeout_remove(ha, sp);
                    CMD_RESULT(sp->cmd) = DID_BUS_BUSY << 16;
                    CMD_HANDLE(sp->cmd) = (unsigned char *) NULL;
                    qla2100_done_q_put(ha, sp, (srb_t **)&ha->done_q_first, (srb_t **)&ha->done_q_last);
                }

                /* v2.19 -  We want to wait until the end to 
                 * return all requests back to OS.
                 */ 
                /* deleted: qla2100_restart_queues(ha, FALSE); */
                ha->flags.restart_queues_needed = TRUE;
            }

            /* Process any pending mailbox commands */
            if( !ha->flags.mbox_busy ) {
                if( ha->flags.isp_abort_needed ) {
                    DEBUG(printk("dpc: qla2100_abort_isp ha = %p\n", ha);)
                    ha->flags.isp_abort_needed = FALSE;
                    qla2100_abort_isp(ha);
                }

                if( ha->flags.reset_marker ) {
                    DEBUG(printk("dpc: qla2100_reset_marker \n");)
                    qla2100_rst_aen(ha);
                }

                if( ha->flags.update_config_needed ) {
                    DEBUG(printk("dpc: qla2100_update_config\n");)
                    qla2100_update_config(ha);
                }

                /* v2.19.8 Retry each device up to login retry count */
                if ( (ha->device_flags & RELOGIN_NEEDED) &&
                     !ha->loop_state != LOOP_DOWN ) { /* v2.19.5 */
                    DEBUG(printk("dpc: qla2100_login\n");)
                    ha->device_flags &= ~RELOGIN_NEEDED;
                    for (t = 0; t < MAX_FIBRE_DEVICES; t++) {
					    /* check if fabric logic retry needed */
						if ( (ha->fc_db[t].flag & DEV_PUBLIC) &&
						     (ha->fc_db[t].flag & DEV_RELOGIN) ) {
							if ( PORT_DOWN(ha,t) ) {
                                PORT_DOWN(ha,t)--;
                                if ( (status = qla2x00_login_public_device(ha,
                                  &ha->fc_db[t].loop_id,
                                  &ha->fc_db[t].port_id[0],
                                  (uint16_t) MBC_NO_PLOGI_IF_LOGGED_IN)) == QL_STATUS_SUCCESS ) {
                                    DEBUG(printk("dpc: logged in ID %x\n",ha->fc_db[t].loop_id);)
							        /* restart ports */
						            ha->fc_db[t].flag &= ~DEV_RELOGIN;
                                    PORT_DOWN(ha,t) = 0;
                                  } else if ( status == QL_STATUS_FATAL_ERROR ) {
                                    ha->flags.isp_abort_needed = TRUE;
						            ha->fc_db[t].flag &= ~DEV_RELOGIN;
                                    PORT_DOWN(ha,t) = 0;
                                  } else {
								    /* retry the login again */
                                    ha->device_flags |= RELOGIN_NEEDED;
                                    DEBUG(printk("dpc: Retry %d logged in ID %x\n",PORT_DOWN(ha,t),
									      ha->fc_db[t].loop_id);)
								  }
							}
						}
                    }
                    DEBUG(printk("dpc: qla2100_login_end.\n");)
                }

                /* v2.19.5 */
                if ( (ha->device_flags & LOGIN_RETRY_NEEDED) &&
                     !ha->loop_state != LOOP_DOWN ) { /* v2.19.5 */
                    ha->device_flags &= ~LOGIN_RETRY_NEEDED;
                    DEBUG(printk("dpc: qla2100_login_retry\n");)
                    qla2100_loop_resync(ha);
                    DEBUG(printk("dpc: qla2100_login_retry end.\n");)
                }

                 /* v2.19.5b5 */
                if( ha->flags.loop_resync_needed ) {
                   if( (ha->device_flags & RSCN_UPDATE ) ) {
                     DEBUG(printk("dpc: qla2100_rscn_update\n");)
                     ha->device_flags &= ~RSCN_UPDATE;
                   }
                   else
                     DEBUG(printk("dpc: qla2100_loop_resync\n");)
                     qla2100_loop_resync(ha);
                    DEBUG(printk("dpc: qla2100_loop_resync/rscn_update done\n");)
                }

                if( ha->flags.restart_queues_needed ) {
                    DEBUG(printk("dpc: calling qla2100_restart_queues\n");)
                    qla2100_restart_queues(ha,FALSE);
                }

                if( ha->flags.abort_queue_needed ) {
                    DEBUG(printk("dpc: qla2100_abort_queues\n");)
                    qla2100_abort_queues(ha, FALSE);
                }
                if( !ha->interrupts_on )
                    qla2100_enable_intrs(ha);
            }

            if( ha->flags.done_requests_needed )
                ha->flags.done_requests_needed = FALSE;

            if( ha->done_q_first ) {
                qla2100_done(ha, (srb_t **)&ha->done_q_first, (srb_t **)&ha->done_q_last);
            }

            ha->dpc_active = 0;

            /* The spinlock is really needed up to this point. (DB) */
            spin_unlock_irqrestore(&io_request_lock, flags);
        }
        DEBUG(qla2100_print("dpc: DPC handler exiting\n");)

        /*
        * Make sure that nobody tries to wake us up again.
        */
        ha->dpc_wait = NULL;
        ha->dpc_handler = NULL;
        ha->dpc_active = 0;

        /*
        * If anyone is waiting for us to exit (i.e. someone trying to unload
        * a driver), then wake up that process to let them know we are on
        * the way out the door.  This may be overkill - I *think* that we
        * could probably just unload the driver and send the signal, and when
        * the error handling thread wakes up that it would just exit without
        * needing to touch any memory associated with the driver itself.
        */
        if( ha->dpc_notify != NULL )
            up(ha->dpc_notify);


    }

    /**************************************************************************
    * qla2100_device_queue_depth
    *   Determines the queue depth for a given device.  There are two ways
    *   a queue depth can be obtained for a tagged queueing device.  One
    *   way is the default queue depth which is determined by whether
    *   If it is defined, then it is used
    *   as the default queue depth.  Otherwise, we use either 4 or 8 as the
    *   default queue depth (dependent on the number of hardware SCBs).
    **************************************************************************/
    STATIC void qla2100_device_queue_depth(scsi_qla_host_t *p, Scsi_Device *device) {
        int default_depth = 16;
         
        device->queue_depth = default_depth;
        if( device->tagged_supported ) {
            device->tagged_queue = 1;
            device->current_tag = 0;
#ifdef MODULE
            if( !(ql2xmaxqdepth == 0 || ql2xmaxqdepth > 256) )
              device->queue_depth = ql2xmaxqdepth;
#endif

            printk(KERN_INFO "scsi(%d:%d:%d:%d): Enabled tagged queuing, queue depth %d.\n",
            (int)p->host_no, device->channel, device->id,
            device->lun, device->queue_depth);
        } else {
            printk(KERN_WARNING "scsi(%d:%d:%d:%d):Device does not supoort tags queuing!!!.\n",
            (int)p->host_no, device->channel, device->id,
            device->lun);
        }
    }

    /**************************************************************************
    *   qla2100_select_queue_depth
    *
    * Description:
    *   Sets the queue depth for each SCSI device hanging off the input
    *   host adapter.  We use a queue depth of 2 for devices that do not
    *   support tagged queueing.
    **************************************************************************/
    STATIC void
    qla2100_select_queue_depth(struct Scsi_Host *host, Scsi_Device *scsi_devs) {
        Scsi_Device *device;
        scsi_qla_host_t  *p = (scsi_qla_host_t *) host->hostdata;

        ENTER("qla2100_select_queue_depth");
        for( device = scsi_devs; device != NULL; device = device->next ) {
            if( device->host == host )
                qla2100_device_queue_depth(p, device);
        }
        LEAVE("qla2100_select_queue_depth");
    }

    /**************************************************************************
    * ** Driver Support Routines **
    *
    * qla2100_enable_intrs
    * qla2100_disable_intrs
    **************************************************************************/
    static inline void qla2100_enable_intrs(scsi_qla_host_t *ha) {
        device_reg_t *reg;

        reg = ha->iobase;
        ha->interrupts_on = 1;
        /* enable risc and host interrupts */
        WRT_REG_WORD(&reg->ictrl, (ISP_EN_INT+ ISP_EN_RISC));
    }

    static inline void qla2100_disable_intrs(scsi_qla_host_t *ha) {
        device_reg_t *reg;

        reg = ha->iobase;
        ha->interrupts_on = 0;
        /* disable risc and host interrupts */
        WRT_REG_WORD(&reg->ictrl, 0);
    }

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,0)
    /**************************************************************************
    *  mdelay
    *     Delay in milliseconds
    *
    **************************************************************************/
    STATIC inline void
    mdelay(int milliseconds) {
        int i;

        for( i=0; i<milliseconds; i++ ) {
            SYS_DELAY(HZ);
        }
    }
#endif

    /**************************************************************************
    * qla2100_done
    *      Process completed commands.
    *
    * Input:
    *      ha           = adapter block pointer.
    *      done_q_first = done queue first pointer.
    *      done_q_last  = done queue last pointer.
    *
    * Returns:
    *     None
    **************************************************************************/
    STATIC void
    qla2100_done(scsi_qla_host_t *ha, srb_t **done_q_first, srb_t **done_q_last) {
        srb_t           *sp;
        scsi_lu_t       *q;
        uint32_t        b, t, l;
        Scsi_Cmnd  *cmd;
        unsigned long cpu_flags = 0; 

        /* ENTER("qla2100_done"); */
        COMTRACE('D')

        while( *done_q_first ) {
            /* remove command from done list */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,95)
            DRIVER_LOCK
#endif
            QLA2100_TIMER_LOCK(ha);
            sp = *done_q_first;
            if( !(*done_q_first = sp->s_next) )
                *done_q_last = NULL;
            else
                (*done_q_first)->s_prev = NULL;
            qla2100_stats.done_q_cnt--;
            DEBUG(sp->state = 5;)
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,95)
            DRIVER_UNLOCK
#endif
            QLA2100_TIMER_UNLOCK(ha);
            cmd = sp->cmd;
            b = SCSI_BUS_32(cmd);
            t = SCSI_TCN_32(cmd);
            l = SCSI_LUN_32(cmd);
            q = GET_LU_Q(ha, b, t, l);

            /* Decrement outstanding commands on device. */
            if( q->q_outcnt )
                q->q_outcnt--;
            if( q->q_outcnt < ha->hiwat ) {
                q->q_flag &= ~QLA2100_QBUSY;
            }

            q->io_cnt++;

            switch( (CMD_RESULT(cmd)>>16) ) {
                case DID_RESET:
                    q->q_flag &= ~QLA2100_QRESET;
                    /* Issue marker command. */
                    qla2100_marker(ha, b, t, 0, MK_SYNC_ID);
                    break;
                case DID_ABORT:
                    sp->flags &= ~SRB_ABORT_PENDING;
                    sp->flags |= SRB_ABORTED;
                    if( sp->flags & SRB_TIMEOUT )
                        CMD_RESULT(sp->cmd)= DID_TIME_OUT << 16;
                    break;
                default:
                    break;
            }

        /* 4.10   64 and 32 bit */
        /* Release memory used for this I/O */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,18)
        if (cmd->use_sg) {
            /* DEBUG(sprintf(debug_buff,
            "S/G unmap_sg cmd=%x\n\r",cmd);)
            DEBUG(qla2100_print(debug_buff)); */
            pci_unmap_sg(ha->pdev, cmd->request_buffer,
                         cmd->use_sg,
                         scsi_to_pci_dma_dir(cmd->sc_data_direction));
        }
        else if (cmd->request_bufflen) {
                 /* DEBUG(sprintf(debug_buff,
                 "No S/G unmap_single cmd=%x saved_dma_handle=%lx\n\r",
                  cmd,sp->saved_dma_handle);)
                  DEBUG(qla2100_print(debug_buff);) */
                  pci_unmap_single(ha->pdev,sp->saved_dma_handle,
                                  cmd->request_bufflen,
                                  scsi_to_pci_dma_dir(cmd->sc_data_direction));
       }
#endif 
            /* Call the mid-level driver interrupt handler */
            /* DEBUG(sprintf(debug_buff," [%d] ",cmd->pid);)
               DEBUG(qla2100_print(debug_buff);) */

            qla2100_callback(ha,sp,TRUE);
            qla2100_next(ha, q);
        }


        COMTRACE('d')
        /* LEAVE("qla2100_done"); */
    }

    /**************************************************************************
    * qla2100_return_status
    * 	Translates a ISP error to a Linux SCSI error
    **************************************************************************/
    STATIC int qla2100_return_status(scsi_qla_host_t *ha, 
                                     sts_entry_t *sts, Scsi_Cmnd       *cp) {
        int host_status = DID_ERROR;
        int scsi_status;
        int comp_status;
        unsigned resid;
        srb_t  *sp;
        uint32_t        t;
        uint8_t  *strp;
        scsi_lu_t *up;

#if DEBUG_QLA2100_INTR
        STATIC char *reason[] = {
            "DID_OK",
            "DID_NO_CONNECT",
            "DID_BUS_BUSY",
            "DID_TIME_OUT",
            "DID_BAD_TARGET",
            "DID_ABORT",
            "DID_PARITY",
            "DID_ERROR",
            "DID_RESET",
            "DID_BAD_INTR"
        };
#endif /* DEBUG_QLA2100_INTR */

        ENTER("qla2100_return_status");

#if DEBUG_QLA2100_INTR
        /*
        DEBUG(printk("qla2100: compl status = 0x%04x\n", sts->comp_status));
        */
#endif
        scsi_status = sts->scsi_status;
        comp_status = sts->comp_status;
        sp = (srb_t *) CMD_SP(cp);

        if( (scsi_status & SS_RESIDUAL_OVER) )
            comp_status = CS_DATA_OVERRUN;
        else if( (scsi_status & SS_RESPONSE_INFO_LEN_VALID) &&
        sts->rsp_info[3] == (uint8_t) 0 )
            comp_status = CS_COMPLETE;

	/* If scanning and missing lun then let the scsi layer skip it */
	/* 4.24   dg 01/18/2001 */
        if( cp->cmnd[0] == 0x12 && 
              	cp->lun == 0 ) { /* inquiry */
		strp = (uint8_t *)cp->request_buffer;
        	up = (scsi_lu_t *) GET_LU_Q(ha, 0, cp->target, cp->lun);
		if( *strp == 0x7f && up->io_cnt < 5) {
			/* Make lun unassigned and wrong type */
			*strp = 0x23;
		}
	   }

        switch( comp_status ) {
            case CS_COMPLETE:
                host_status = DID_OK;
		        /* v2.19.5b2 Reset port down retry on success. */
			sp->port_down_retry_count = ha->port_down_retry_count;
                break;
            case CS_PORT_UNAVAILABLE:
                /* release target data structure */
                host_status = DID_NO_CONNECT;
                DEBUG(sprintf(debug_buff,"scsi: Unavail port detected 0x%x-0x%x.\n",
                sts->comp_status, sts->scsi_status); )
                DEBUG(qla2100_print(debug_buff);)
                break;
            case CS_PORT_LOGGED_OUT:
            case CS_PORT_CONFIG_CHG:
            case CS_PORT_BUSY:
            case CS_INCOMPLETE:
                host_status = DID_NO_CONNECT;
                DEBUG(sprintf(debug_buff,"scsi: Port Error detected 0x%x-0x%x.\n",
                sts->comp_status, sts->scsi_status); )
                DEBUG(qla2100_print(debug_buff);)
                break;
            case CS_RESET:
                host_status = DID_RESET;
                break;
            case CS_ABORTED:
                /* v2.19.12 - DID_ABORT does not retry the request */
				/* if we aborted this request then abort otherwise it must be a reset */
                   if ( (sp->flags & SRB_ABORT_PENDING) )
                host_status = DID_ABORT;
		   else
                	host_status = DID_RESET;
                break;
            case CS_TIMEOUT:
                  host_status = DID_ERROR;
                  /* v2.19.8 if timeout then check to see if logout occurred*/
                  t = SCSI_TCN_32(cp);
		  if ( (ha->fc_db[t].flag & DEV_PUBLIC)  &&
                       (sts->status_flags & IOCBSTAT_SF_LOGO) ) {
				ha->fc_db[t].flag |= DEV_RELOGIN;
                    DEBUG(printk("scsi: Timeout occurred with Logo, status flag (%x) with public device loop id (%x), attempt new recovery\n",
                    sts->status_flags, ha->fc_db[t].loop_id);)
					/* Suspend port */
                    PORT_DOWN(ha,t) = ha->port_down_retry_count;
                    ha->device_flags |= RELOGIN_NEEDED;
                }
                break;
            case CS_DATA_UNDERRUN:
                resid = sts->residual_length;
                /* if RISC reports underrun and target does not report it
                * then we must have a lost frame, so tell upper layer
                * to retry it by reporting an error.
                */
                if( !(sts->scsi_status & SS_RESIDUAL_UNDER) ) {
                    resid = (unsigned)(CMD_XFRLEN(cp));
                }

                if( (unsigned)(CMD_XFRLEN(cp) - resid) < cp->underflow ) {
                        host_status = DID_ERROR;
                        DEBUG3(sprintf(debug_buff,"scsi: Underflow detected - retrying command.\n");)
                        DEBUG3(qla2100_print(debug_buff);)
                } else {
	            /* v2.19.5b2 Reset port down retry on success. */
	            sp->port_down_retry_count = ha->port_down_retry_count;
                    host_status = DID_OK;
                }
                break;

            default:
                DEBUG3(printk("scsi: Error detected 0x%x-0x%x.\n",
                sts->comp_status, sts->scsi_status);)
                host_status = DID_ERROR;
                break;
        }

#if DEBUG_QLA2100_INTR
        sprintf(debug_buff, "qla2100 ISP status: host status (%s) scsi status %x\n\r", reason[host_status], scsi_status);
        DEBUG(qla2100_print(debug_buff);)
#endif

        LEAVE("qla2100_return_status");

        return ((scsi_status & STATUS_MASK) | (host_status << 16) );
    }

    /*
    * qla2100_done_q_put
    *      Place SRB command on done queue.
    *
    * Input:
    *      ha           = host pointer
    *      sp           = srb pointer.
    *      done_q_first = done queue first pointer.
    *      done_q_last  = done queue last pointer.
    */
    STATIC void
    qla2100_done_q_put(scsi_qla_host_t *ha, srb_t *sp, srb_t **done_q_first, srb_t **done_q_last) {
    
        unsigned long cpu_flags = 0; 

#ifdef QL_DEBUG_LEVEL_3
        ENTER("qla2100_put_done_q");
#endif
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,95)
            DRIVER_LOCK
#else
            QLA2100_TIMER_LOCK(ha);
#endif
        /* Place block on done queue */
        sp->s_next = NULL;
        sp->s_prev = *done_q_last;
        if( !*done_q_first )
            *done_q_first = sp;
        else
            (*done_q_last)->s_next = sp;
        *done_q_last = sp;

        qla2100_stats.done_q_cnt++;
        DEBUG(sp->state = 3;)
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,95)
            DRIVER_LOCK
#else
            QLA2100_TIMER_UNLOCK(ha);
#endif

#ifdef QL_DEBUG_LEVEL_3
        LEAVE("qla2100_put_done_q");
#endif
    }


    /**************************************************************************
    *   qla2100_timer
    *
    * Description:
    *   One second timer 
    *
    * Context: Interrupt
    **************************************************************************/
    STATIC void
    qla2100_timer(scsi_qla_host_t *ha) {

        srb_t *sp, *sp_next;
        int  stop_timer, kick_off = 0;
        int  cnt;
	int t;
        /* unsigned long cpu_flags = 0; */


        /* ENTER("qla2100_timer"); */

        /* v2.19.02 spin_lock_irqsave(&io_request_lock, cpu_flags); */

        stop_timer = 0;

        for( t = 0; t < ha->max_targets; t++ ) {
            if( TGT_Q(ha, 0, t)  == NULL )
                   continue;
            if( TGT_Q(ha, 0, t)->down_timer > 0 )
            	TGT_Q(ha, 0, t)->down_timer--;
	}

        /* Port Down Handler. */
        if( ha->queue_restart_timer > 0 ) {
            ha->queue_restart_timer--;
#ifdef TRACECODE
            sprintf(debug_buff,"timer: Port down time in secs %d\n",ha->queue_restart_timer);
            qla2100_print(debug_buff);
#endif
            /*
             * When a port goes DOWN, we suspend the queue and wait 1 second
             * (one timer tick) before trying to kick off the commands again.
             * We will do this for "port_down_retry_count" times per
             * command before giving up on the command altogether.
             */
             if( !ha->queue_restart_timer ) {
                 ha->flags.port_restart_needed = TRUE;
                 DEBUG(qla2100_print("qla2100_timer: Port Down complete - restarting commands in the queues\n");)
                 stop_timer++;
             }
         }
            /* Loop down handler. */
            if( ha->loop_down_timer > 0 &&
            !ha->flags.abort_isp_active &&
            ha->flags.online ) {
                if( ha->loop_down_timer == LOOP_DOWN_TIME ) {
                    DEBUG(printk("qla2100_timer: Loop Down time expired - aborting the queues before time expire\n");)
#ifdef TRACECODE
                    qla2100_print("qla2100_timer: Loop Down - aborting the queues before time expire\n");
#endif
#if 1
                    ha->flags.abort_queue_needed = TRUE;
#else
                    qla2100_abort_queues(ha, TRUE);
#endif
                }

                ha->loop_down_timer--;
#ifdef TRACECODE
                sprintf(debug_buff,"qla2100_timer: Loop Down - seconds remainning %d\n",ha->loop_down_timer);
                qla2100_print(debug_buff);
#endif
                /* if the loop has been down for 4 minutes on QLA2100,
                   reinit adapter */
                if( !ha->loop_down_timer ) {
#ifdef TRACECODE
                    qla2100_print("qla2100_timer: Loop down for 4 mins \n");
#endif
                    DEBUG(printk("qla2100_timer: Loop down exceed 4 mins -restarting queues and abort ISP.\n");)
                    ha->flags.restart_queues_needed = TRUE;
                    if ( (ha->device_id  == QLA2100_DEVICE_ID) &&
                          (qla2100_reinit == 1 ))
                        ha->flags.isp_abort_needed = TRUE;
                    stop_timer++;
                }
            }

            /*
            * Retry Handler -- This handler will recycle queued requests until the
            * temporary loop down condition terminates.
            */
            if( !ha->flags.abort_isp_active ) {
#ifdef TRACECODE
                if( ha->retry_q_first )
                    qla2100_print("qla2100_timer: Scanning for timed out commands\n");
#endif
                for( cnt=0, sp = ha->retry_q_first; (sp); sp =  sp_next ) {
                    if( sp->wdg_time )
                        sp->wdg_time--;
                    sp_next = sp->s_next;
                    if( sp->wdg_time ==  0 ) {
                        kick_off++;
                        DEBUG3(sprintf(debug_buff,"timer: CMD timeout %p,  pid %d\n",sp, sp->cmd->pid);)
                        DEBUG3(qla2100_print(debug_buff);)
                        cnt++;
                        qla2100_timeout_remove(ha, sp);
                        CMD_RESULT(sp->cmd) = DID_BUS_BUSY << 16;
                        CMD_HANDLE(sp->cmd) = (unsigned char *) NULL;
                        qla2100_done_q_put(ha, sp, (srb_t **)&ha->done_q_first, (srb_t **)&ha->done_q_last);
                    }
                }

                if( cnt > 0 ) {
                    DEBUG2(sprintf(debug_buff,"timer: found %d requests\n",cnt);)
                    DEBUG2(qla2100_print(debug_buff);)
                }
            }

            if( ha->done_q_first )
                ha->flags.done_requests_needed = TRUE;

            if( ha->dpc_flags & ISP_RESET_NEEDED) {
               ha->dpc_flags &= ~ISP_RESET_NEEDED;
               ha->flags.isp_abort_needed = TRUE;
	    }


#if QLA2100_LIPTEST
            if( (ha->forceLip++) == (60*3) && qla2100_lip) {
                /* qla2100_loop_reset(ha); */
                qla2100_abort_isp(ha);
                ha->forceLip = 0;
            }
#endif
            /* v2.19.02 spin_unlock_irqrestore(&io_request_lock, cpu_flags); */

            /* Schedule the DPC routine if needed */
            if( ( ha->flags.isp_abort_needed ||
            (!ha->flags.loop_resync_active && ha->flags.loop_resync_needed) ||
            ha->flags.restart_queues_needed ||
            ha->flags.port_restart_needed ||
            ha->flags.done_requests_needed ||
            (ha->device_flags & RELOGIN_NEEDED) ||
		    (ha->dpc_flags & COMMAND_WAIT_NEEDED) ||
            (ha->device_flags & LOGIN_RETRY_NEEDED) ||
            kick_off > 0  ||
            ha->flags.abort_queue_needed ) &&
            ha->dpc_wait && !ha->dpc_active ) {  /* v2.19.4 */
                up(ha->dpc_wait);
            }

            /* IOCTL SCSI Pass Thru Handler. */
            if (ha->IoctlPassThru_InProgress)  {
               if (ha->ioctl_timer) ha->ioctl_timer--;
            }

            /* IOCTL FCCT Pass Thru Handler. */
            if (ha->IoctlPassFCCT_InProgress)  {
               if (ha->ioctl_timer) ha->ioctl_timer--;
            }

            /* ha->flags.watchdog_enabled = FALSE; */
            RESTART_TIMER(qla2100_timer,ha,WATCH_INTERVAL);

            /* LEAVE("qla2100_timer");  */
        }

        /*
        * qla2100_timeout_insert
        *      Function used to insert a command block onto the
        *      watchdog timer queue.
        *
        *      Note: Must insure that sc_time is not zero
        *            before calling qla2100_timeout_insert.
        *
        * Input:
        *      ha = adapter block pointer.
        *      sp = srb pointer.
        */
        STATIC void
        qla2100_timeout_insert(scsi_qla_host_t *ha, srb_t *sp) {
            unsigned long cpu_flags = 0;
            uint8_t timeoutcnt;

#ifdef QL_DEBUG_LEVEL_3
            /* ENTER("qla2100_timeout_insert"); */
#endif

            /* Compute number of time intervals */
            timeoutcnt = (uint8_t) (CMD_TIMEOUT(sp->cmd)/(WATCH_INTERVAL * HZ));
            if( timeoutcnt >= 3 )  /* 3 or more */
                /* sp->wdg_time = timeoutcnt - 3;  */
                sp->wdg_time = 3;
            else
                sp->wdg_time = 1;

            DEBUG3(sprintf(debug_buff,"Watchdog (insert) - pid=%d, tmo=%d \n",sp->cmd->pid,sp->wdg_time);)
            DEBUG3(qla2100_print(debug_buff);)

            /* Acquire watchdoq queue specific lock */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,95)
            DRIVER_LOCK
#else
            QLA2100_TIMER_LOCK(ha);
#endif
            /* Add command to queue */
            if (ha->retry_q_first == NULL) {
                ha->retry_q_first = sp;
                ha->retry_q_last = sp;
            } else {
                ha->retry_q_last->s_next = sp;
                ha->retry_q_last = sp;
            }
            sp->s_next = NULL;
            qla2100_stats.retry_q_cnt++;
            sp->state = 0xd0;

            sp->flags |= SRB_WATCHDOG;
            ha->flags.watchdog_enabled = TRUE;

            /* Release watchdog queue specific lock */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,95)
            DRIVER_UNLOCK
#else
            QLA2100_TIMER_UNLOCK(ha);
#endif

#ifdef QL_DEBUG_LEVEL_3
            /*  LEAVE("qla2100_timeout_insert"); */
#endif
        }

        /*
        * qla2100_timeout_remove
        *      Function used to remove a command block from the
        *      watchdog timer queue.
        *
        *      Note: Must insure that command is on watchdog
        *            list before calling qla2100_timeout_remove.
        *            if (sp->flags & SRB_WATCHDOG)
        *
        * Input:
        *      ha = adapter block pointer.
        *      sp = srb pointer.
        */
        STATIC void
        qla2100_timeout_remove(scsi_qla_host_t *ha, srb_t *sp) {
            unsigned long cpu_flags = 0;
            srb_t *nextsp;

#ifdef QL_DEBUG_LEVEL_3
            /* ENTER("qla2100_timeout_remove"); */
#endif

            DEBUG3(sprintf(debug_buff,"Watchdog (remove) pid=%d time%d\n",sp->cmd->pid,sp->wdg_time);)
            DEBUG3(qla2100_print(debug_buff);)

            /* Acquire watchdoq queue specific lock */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,95)
            DRIVER_LOCK
#else
            QLA2100_TIMER_LOCK(ha);
#endif
            /* Remove command block from watchdog queue. */
            if (ha->retry_q_first != NULL) {
                if (ha->retry_q_first == sp) {
                    /* Remove from top of queue */
                    ha->retry_q_first = sp->s_next;
                    if (ha->retry_q_first == NULL) {

                        ha->retry_q_last = NULL;
                        ha->flags.watchdog_enabled = FALSE;
                    }
                } else {
                    /* Remove from middle of queue or bottom of queue */
                    for (nextsp = ha->retry_q_first; nextsp->s_next != NULL;
                    nextsp = nextsp->s_next) {
                        if (nextsp->s_next == sp) {
                            nextsp->s_next = sp->s_next;
                            if (nextsp->s_next == NULL)
                                ha->retry_q_last = nextsp;
                            break;
                        }
                    }
                }
                sp->flags &= ~SRB_WATCHDOG;
                qla2100_stats.retry_q_cnt--;
            }

            /* Release watchdog queue specific lock */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,95)
            DRIVER_UNLOCK
#else
            QLA2100_TIMER_UNLOCK(ha);
#endif

#ifdef QL_DEBUG_LEVEL_3
            /* LEAVE("qla2100_timeout_remove"); */
#endif
        }

        /*
        * qla2100_next
        *      Retrieve and process next job in the queue.
        *
        * Input:
        *      ha = adapter block pointer.
        *      q  = SCSI LU pointer.
        *      SCSI_LU_Q lock must be already obtained and no other locks.
        *
        * Output:
        *      Releases SCSI_LU_Q upon exit.
        */
        STATIC void
        qla2100_next(scsi_qla_host_t *ha, scsi_lu_t *q) {
            srb_t    *sp;
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,95)
            unsigned long cpu_flags = 0;
#endif
            uint8_t  status;

#ifdef QL_DEBUG_LEVEL_3
            ENTER("qla2100_next"); 
#endif

            DRIVER_LOCK
            COMTRACE('N')
            while( ((sp = q->q_first) != NULL) &&   /* we have a pending cmds */
            !(q->q_flag & QLA2100_QBUSY) &&     /* device can accept more cmds */
            !((q->q_flag & QLA2100_QSUSP) &&    /* device queue not suspended */
            !ha->flags.abort_isp_active &&      /* adapter abort active */
            !ha->loop_down_timer) )             /* down timer not active */
            {
                /* Remove srb from SCSI LU queue. */
                qla2100_removeq(q, sp);
                sp->state = 0x32;
                /* Set busy flag if reached high water mark. */
                q->q_outcnt++;
                if( q->q_outcnt >= ha->hiwat ) {
                    q->q_flag |= QLA2100_QBUSY;
                }

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,18)
                if( ha->flags.enable_64bit_addressing )
                    status = qla2100_64bit_start_scsi(ha, sp);
                else
#endif
                    status = qla2100_32bit_start_scsi(ha, sp);

                if( status ) {
                    qla2100_putq_t(q, sp);

                    if( q->q_outcnt )
                        q->q_outcnt--;
                    if( q->q_outcnt < ha->hiwat )
                       q->q_flag &= ~QLA2100_QBUSY;
                      break;
                }
            }

            COMTRACE('n')
            DRIVER_UNLOCK
            /* Release SCSI LU queue specific lock */

#ifdef QL_DEBUG_LEVEL_3
            LEAVE("qla2100_next");
#endif
        }
#if 0
/*******************************************************
v4.10    * This function has been de-implemented 
        * All DMAable memory is allocated on the spot
        * according to what kernel version is in effect.
********************************************************  
        * qla2100_alloc_phys
        *      Function used to allocate physical memory
        *      and zero it.
        *
        * Input:
        *      size     = size in bytes.
        *      flag     = sleep flag.
        *      phy_addr = physical address pointer.
        *
        * Returns:
        *      not NULL = success
        */
        STATIC void *
        qla2100_alloc_phys(int siz, u_long *phy_addr) {
            void        *mem = NULL;

#ifdef QL_DEBUG_LEVEL_3
            ENTER("qla2100_alloc_phys");
#endif
            mem = KMALLOC(siz);
            if( mem != NULL ) {
                *phy_addr = VIRT_TO_BUS(mem);
                BZERO((caddr_t)mem, siz);
                DEBUG5(sprintf(debug_buff,"qla2100: get phys mem =0x%lx\n\r",(long)*phy_addr));
                DEBUG5(qla2100_print(debug_buff);)
            }

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
            if( mem == NULL )
                qla2100_print("qla2100_alloc_phys: **** FAILED ****\n\r");
#endif
#ifdef QL_DEBUG_LEVEL_3
            else
                LEAVE("qla2100_alloc_phys");
#endif
            return(mem);
        }
#endif

        /*
        * qla2100_putq_t
        *      Add the standard SCB job to the top of standard SCB commands.
        *
        * Input:
        *      q  = SCSI LU pointer.
        *      sp = srb pointer.
        *      SCSI_LU_Q lock must be already obtained.
        */
        STATIC void
        qla2100_putq_t(scsi_lu_t *q, srb_t *sp) {
            srb_t *srb_p;
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,95)
            unsigned long cpu_flags = 0;
#endif

#ifdef QL_DEBUG_LEVEL_3
            /* ENTER("qla2100_putq_t"); */
#endif
            DRIVER_LOCK
            DEBUG5(sprintf(debug_buff,"Adding to queue 0x%x<-(0x%x)\n\r",q,sp));
            DEBUG5(qla2100_print(debug_buff));
            sp->s_next = NULL;
            q->q_incnt++;
            sp->state = 2;
            /* v2.19.6 */
            if( !q->q_first || !q->q_last)  /* If queue empty */
            {
                sp->s_prev = NULL;
                q->q_first = sp;
                q->q_last = sp;
            } else {
                srb_p = q->q_first;
                while( srb_p )
                    srb_p = srb_p->s_next;

                if( srb_p ) {
                    sp->s_prev = srb_p->s_prev;
                    if( srb_p->s_prev )
                        srb_p->s_prev->s_next = sp;
                    else
                        q->q_first = sp;
                    srb_p->s_prev = sp;
                    sp->s_next = srb_p;
                } else {
                    sp->s_prev = q->q_last;
                    q->q_last->s_next = sp;
                    q->q_last = sp;
                }
            }

            DRIVER_UNLOCK
#ifdef QL_DEBUG_LEVEL_3
            /* LEAVE("qla2100_putq_t"); */
#endif
        }

        /*
        * qla2100_removeq
        *      Function used to remove a command block from the
        *      LU queue.
        *
        * Input:
        *      q  = SCSI LU pointer.
        *      sp = srb pointer.
        *      SCSI_LU_Q lock must be already obtained.
        */
        STATIC void
        qla2100_removeq(scsi_lu_t *q, srb_t *sp) {
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,95)
            unsigned long cpu_flags = 0;
#endif
            DEBUG5(sprintf(debug_buff,"Removing from device_q (0x%x)->(0x%x)\n\r",q,sp));
            DEBUG5(qla2100_print(debug_buff));
            DRIVER_LOCK
            if( sp->s_prev ) {
                if( (sp->s_prev->s_next = sp->s_next) != NULL )
                    sp->s_next->s_prev = sp->s_prev;
                else
                    q->q_last = sp->s_prev;
            } else if( !(q->q_first = sp->s_next) )
                q->q_last = NULL;
            else
                q->q_first->s_prev = NULL;
            q->q_incnt--;
            DRIVER_UNLOCK
        }
        /*
        * qla2100_callback
        *      Returns the completed SCSI command to LINUX.
        *
        * Returns:
        *      None
        */
        static inline void qla2100_callback(scsi_qla_host_t *ha, srb_t *sp, uint8_t dec) {
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,95)
            unsigned long cpu_flags = 0;
#endif

            CMD_HANDLE(sp->cmd) = (unsigned char *) NULL;
            sp->flags &= ~SRB_SENT;
            
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,95)
            DRIVER_LOCK
#endif
#if 0
            if( dec )
                ha->actthreads--;
#endif

	/* v2.19.14 
  	 * Perform internal retries, if needed.
	 */
          switch( (CMD_RESULT(sp->cmd)>>16) ) {
                case DID_ERROR:
			if( sp->retry_count > 0 ) {
				sp->retry_count--;
            			DEBUG3(printk("qla2100: RETRY - os retry %d, drv retry %d, port retry %d\n\r",sp->cmd->retries,sp->retry_count,sp->port_down_retry_count));
                        	CMD_RESULT(sp->cmd) = (int) DID_BUS_BUSY << 16;
			} else {
            	  		sp->retry_count = ha->retry_count;
				/* all resetted commands must return with RESET */
				if(sp->cmd->flags & IS_RESETTING ) {
                        		CMD_RESULT(sp->cmd) = (int) DID_RESET << 16;
            				DEBUG3(printk("qla2100: RESET cmd %p\n",sp->cmd));
				}
            			DEBUG3(printk("qla2100: OSerr = %p\n\r",sp->cmd));
			}
                    break;
                default:
                    break;
            }

            /* Call the mid-level driver interrupt handler */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,95)
            sti();
            (*(sp->cmd)->scsi_done)(sp->cmd);
            cli();
#else
            (*(sp->cmd)->scsi_done)(sp->cmd);
#endif
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,95)
            DRIVER_UNLOCK
#endif
        }


        /*
        * qla2100_mem_alloc
        *      Allocates adapter memory.
        *
        * Returns:
        *      0  = success.
        *      1  = failure.
        */
        STATIC uint8_t
        qla2100_mem_alloc(scsi_qla_host_t *ha) {

            uint8_t   status = 1;

#ifdef QL_DEBUG_LEVEL_3
            ENTER("qla2100_mem_alloc");
#endif

            /* 4.10 */
            /* get consistent memory allocated for request/response rings */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
            ha->request_ring  = &ha->req[0];
            ha->request_dma   = VIRT_TO_BUS(&ha->req[0]);
            ha->response_ring = &ha->res[0];
            ha->response_dma  = VIRT_TO_BUS(&ha->res[0]);
#ifdef FC_IP_SUPPORT
            ha->pIpBufferQueue          = &ha->asIpBuffers[0];
            ha->ppIpBufferQueueLow      = VIRT_TO_BUS_LOW(&ha->asIpBuffers[0]);
            ha->ppIpBufferQueueHigh     = VIRT_TO_BUS_HIGH(&ha->asIpBuffers[0]);
#endif /* FC_IP_SUPPORT */
#else  /* KERNEL >= 2.3.18 */ 
            ha->request_ring   = pci_alloc_consistent(ha->pdev,
                                 ((REQUEST_ENTRY_CNT+1)*(sizeof(request_t))),
                                 &ha->request_dma);
            ha->response_ring  = pci_alloc_consistent(ha->pdev,
                                 ((RESPONSE_ENTRY_CNT+1)*(sizeof(response_t))),
                                 &ha->response_dma);
#ifdef FC_IP_SUPPORT 
            /* not ported yet to new pci_alloc_consistent */
            ha->pIpBufferQueue          = &ha->asIpBuffers[0];
            ha->ppIpBufferQueueLow      = VIRT_TO_BUS_LOW(&ha->asIpBuffers[0]);
            ha->ppIpBufferQueueHigh     = VIRT_TO_BUS_HIGH(&ha->asIpBuffers[0]);
#endif 
#endif
            /* 4.10 */
            /* get consistent memory allocated for init control block */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
            ha->init_cb = KMALLOC(sizeof(init_cb_t));
            if( ha->init_cb != NULL ) {
                ha->init_cb_dma = VIRT_TO_BUS(ha->init_cb);
                BZERO((caddr_t)ha->init_cb, sizeof(init_cb_t));
            }
#else
            ha->init_cb  = pci_alloc_consistent(ha->pdev,
                                                sizeof(init_cb_t),
                                                &ha->init_cb_dma);
            BZERO((caddr_t)ha->init_cb, sizeof(init_cb_t));
#endif
            if( ha->init_cb ) status = 0;

            if( status ) 
                printk("qla2100_mem_alloc: **** FAILED ****\n");

#ifdef QL_DEBUG_LEVEL_3
            else
                LEAVE("qla2100_mem_alloc");
#endif
            return(status);
        }

        /*
        * qla2100_mem_free
        *      Frees all adapter allocated memory.
        *
        * Input:
        *      ha = adapter block pointer.
        */
        STATIC void
        qla2100_mem_free(scsi_qla_host_t *ha) {
            tgt_t    *tgt;
            uint32_t b, t;

#ifdef QL_DEBUG_LEVEL_3
            ENTER("qla2100_mem_free");
#endif
            if( ha ) {
                /* Free the target queues */
                b = 0;
                for( t = 0; t < MAX_FIBRE_DEVICES; t++ ) {
                    tgt = TGT_Q(ha, b, t);
                    if( tgt )
                        qla2100_tgt_dealloc(ha, tgt);
                }

            /* 4.10 */
            /* free consistent memory allocated for request and response rings */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,18)
            pci_free_consistent(ha->pdev, ((REQUEST_ENTRY_CNT+1)*(sizeof(request_t))),
                                ha->request_ring, ha->request_dma);

            pci_free_consistent(ha->pdev,((RESPONSE_ENTRY_CNT+1)*(sizeof(response_t))),
            ha->response_ring, ha->response_dma); 
#endif 
            /* free memory allocated for ioctl operations */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
            KMFREE(ha->ioctl_mem, PAGE_SIZE);
#else
            pci_free_consistent(ha->pdev, PAGE_SIZE,
                                ha->ioctl_mem, ha->ioctl_mem_phys);
#endif
            /* free memory allocated for init_cb */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
            KMFREE(ha->init_cb, sizeof(init_cb_t));
#else
            pci_free_consistent(ha->pdev, sizeof(init_cb_t),
                                ha->init_cb, ha->init_cb_dma);
#endif
            }
#ifdef QL_DEBUG_LEVEL_3
            LEAVE("qla2100_mem_free");
#endif
        }



        /*
        * qla2100_tgt_alloc
        *      Allocates a target queue structure.
        *
        * Input:
        *      ha  = adapter block pointer.
        *
        * Returns
        *      target queue structure = success:
        *      NULL = otherwise
        */
        static inline tgt_t *
        qla2100_tgt_alloc(scsi_qla_host_t *ha) {
            tgt_t    *tgt;

#ifdef QL_DEBUG_LEVEL_3
            ENTER("qla2100_tgt_alloc");
#endif

            tgt = (tgt_t *)KMALLOC(sizeof(tgt_t));   /* Could Sleep here */
            if( tgt != NULL ) {
                BZERO(tgt,sizeof(tgt_t));
                DEBUG(sprintf(debug_buff,"Alloc Target @ %08x \n",tgt);)
                DEBUG(qla2100_print(debug_buff);)
            }

#ifdef QL_DEBUG_LEVEL_3
            LEAVE("qla2100_tgt_alloc");
#endif
            return(tgt);
        }

        /*
        * qla2100_lun_alloc
        *      Allocates a logical device queue structure and lock
        *
        * Returns:
        *      SCSI LU structure pointer
        */
        STATIC inline scsi_lu_t *
        qla2100_lun_alloc(void) {
            scsi_lu_t *q;

#ifdef QL_DEBUG_LEVEL_3
            ENTER("qla2100_lun_alloc");
#endif

            q = (scsi_lu_t *)KMALLOC(sizeof(scsi_lu_t));  /* Sleep */
            BZERO(q,sizeof(struct scsi_lu));
            DEBUG(sprintf(debug_buff,"Alloc Lun @ %08x \n",q);)
            DEBUG(qla2100_print(debug_buff);)

#ifdef QL_DEBUG_LEVEL_3
            LEAVE("qla2100_lun_alloc");
#endif
            return(q);
        }

        /*
        * qla2100_tgt_dealloc
        *      Deallocates a target and all logical device queue structures.
        *
        * Input:
        *      ha  = adapter block pointer.
        *      tgt = Target queue structure pointer
        */
        static inline void
        qla2100_tgt_dealloc(scsi_qla_host_t *ha, tgt_t *tgt) {
            uint32_t  l;

#ifdef QL_DEBUG_LEVEL_3
            ENTER("qla2100_tgt_dealloc");
#endif

            if( tgt != NULL ) {
                /* Insure all LUN memory is released. */
                for( l = 0; l <  ha->max_luns; l++ ) {
                    if( tgt->luns[l] )
                        qla2100_lun_dealloc(tgt->luns[l]);
                }
                KMFREE(tgt, sizeof(tgt_t));
            }

#ifdef QL_DEBUG_LEVEL_3
            LEAVE("qla2100_tgt_dealloc");
#endif
        }

        /*
        * qla2100_lun_dealloc
        *      Deallocates a logical unit queue structure.
        *
        * Input:
        *      q = SCSI LU structure pointer
        */
        static inline void
        qla2100_lun_dealloc(scsi_lu_t *q) {
#ifdef QL_DEBUG_LEVEL_3
            ENTER("qla2100_lun_dealloc");
#endif
            if( q != NULL ) {
                DEBUG(sprintf(debug_buff,"Dealloc Lun @ %08x -- deleted\n",q);)
                DEBUG(qla2100_print(debug_buff);)
                KMFREE(q, sizeof(scsi_lu_t));
            }
#ifdef QL_DEBUG_LEVEL_3
            ENTER("qla2100_lun_dealloc");
#endif

        }

        /*
        *  qla2100_abort_queue_single
        *      Abort all commands on a device queues.
        *
        * Input:
        *      ha = adapter block pointer.
        */
        STATIC void qla2100_abort_queue_single(scsi_qla_host_t *ha,uint32_t b,uint32_t t,uint32_t l,uint32_t stat) {
            scsi_lu_t *q;
            srb_t     *sp;

            ENTER("qla2100_abort_queue_single");
            /* dg - 08/23/99
            * We don't want to try and abort queues that don't exists
            * (i.e. the device is not configure on the loop )
            */
            if( ha->loop_down_timer > 0 ) {
                return;
            }
            DEBUG5(sprintf(debug_buff,"Abort queue single %2d:%2d:%2d:%2d\n",
            ha->host_no,b,t,l);)
            DEBUG5(qla2100_print(debug_buff);)
            q = (scsi_lu_t * )GET_LU_Q(ha, b, t, l);
            while( q != NULL && (sp = q->q_first) != NULL ) {
                /* Acquire LU queue specific lock */

                qla2100_removeq(q, sp);

                /* Release LU queue specific lock */
                CMD_RESULT(sp->cmd) = stat;
                qla2100_done_q_put(ha, sp, (srb_t **)&ha->done_q_first, (srb_t **)&ha->done_q_last);
            }
            LEAVE("qla2100_abort_queue_single");
        }

        /****************************************************************************/
        /*                QLogic ISP2100 Hardware Support Functions.                */
        /****************************************************************************/

        /*
        * qla2100_initialize_adapter
        *      Initialize board.
        *
        * Input:
        *      ha = adapter block pointer.
        *
        * Returns:
        *      0 = success
        */
        uint8_t
        qla2100_initialize_adapter(scsi_qla_host_t *ha) {
            device_reg_t *reg;
            uint8_t      status;
            uint8_t      isp_init = 0;
            uint8_t      restart_risc = 0;
            uint8_t      retry;

#ifdef QL_DEBUG_LEVEL_3
            ENTER("qla2100_initialize_adapter");
#endif

            /* Clear adapter flags. */
            ha->forceLip = 0;
            ha->flags.online = FALSE;
            ha->flags.isp_abort_needed = FALSE;
            ha->flags.disable_host_adapter = FALSE;
            ha->flags.loop_resync_active = FALSE;
            ha->flags.reset_active = FALSE;
            ha->flags.abort_isp_active = FALSE;
            ha->flags.watchdog_enabled = FALSE;
            ha->loop_down_timer = LOOP_DOWN_TIME;
            ha->loop_state = LOOP_DOWN;
            ha->flags.start_timer  = FALSE;
            ha->flags.done_requests_needed = FALSE;
            ha->device_flags = 0;
            ha->dpc_flags = 0;
            ha->sns_retry_cnt = 0;
            ha->host_db_ptr = 0;
            ha->device_flags = 0;
            /* 4.11 */
            ha->flags.managment_server_logged_in = 0;

            DEBUG(printk("Configure PCI space for adapter...\n"));

            if( !(status = qla2100_pci_config(ha)) ) {
                reg = ha->iobase;

                qla2100_reset_chip(ha);

                /* Initialize Fibre Channel database. */
                qla2100_init_fc_db(ha);

                /* Initialize target map database. */
                qla2100_init_tgt_map(ha);
                if( qla2100_verbose )
                    printk("scsi(%d): Configure NVRAM parameters...\n",(int)ha->host_no);

                if( ha->device_id == QLA2100_DEVICE_ID )
                    qla2100_nvram_config(ha);
                else
                    qla2200_nvram_config(ha);
	 			/* v2.19.12 */
				ha->retry_count = ql2xretrycount;

                if( qla2100_verbose )
                    printk("scsi(%d): Verifying loaded RISC code...\n",(int)ha->host_no);

                qla2100_set_cache_line(ha);

                /* If the user specified a device configuration on
                * the command line then use it as the configuration.
                * Otherwise, we scan for all devices.
                */
                if ( ql2xdevconf ) {
                    qla2100_get_properties(ha, ql2xdevconf);
                }

                retry = 10; 
                /*
                * Try an configure the loop.
                */
                do {
                    DEBUG(qla2100_print("qla2100_initialize_adapter: check if firmware needs to be loaded\n");)
                    /* If firmware needs to be loaded */
                    if( qla2100_isp_firmware(ha) ) {
                        if( qla2100_verbose )
                            printk("scsi(%d): Verifying chip...\n",
                                  (int)ha->host_no);

                        if( !(status = qla2100_chip_diag(ha)) )
                            status = qla2100_setup_chip(ha);

                        if( !status )
                            DEBUG(printk("scsi(%d): Chip verified and RISC loaded...\n",(int)ha->host_no));
                    }
                    if( !status && !(status = qla2100_init_rings(ha)) ) {
                        /* dg - 7/3/1999
                        *
                        * Wait for a successful LIP up to a maximum of (in seconds):
                        * RISC login timeout value, RISC retry count value, and port
                        * down retry value OR a minimum of 4 seconds OR If no cable,
                        * only 5 seconds.
                        */
                        DEBUG(printk("scsi(%d): qla2100_init_rings OK, call qla2100_fw_ready...\n",(int)ha->host_no));
                        DEBUG(qla2100_print("qla2100_init_rings OK, call qla2100_fw_ready...\n");)
                        if( !qla2100_fw_ready(ha) ) {
                            ha->flags.reset_marker = FALSE;
                            /* Go setup flash database devices with proper Loop ID's. */
                            do {
                                ha->flags.loop_resync_needed = FALSE;
                                status = qla2100_update_fc_db(ha, FALSE);
                            }while( !ha->loop_down_timer && ha->flags.loop_resync_needed );

                            /* If database was full and a device was not configured. */
                            /* try and reuse the slots.                              */
                            if( status == 2 ) {  
                                do {
                                    ha->flags.loop_resync_needed = FALSE;
                                    status = qla2100_update_fc_db(ha, TRUE); 
                                }while( !ha->loop_down_timer && ha->flags.loop_resync_needed );
                            }
                        }
                        if( ha->flags.update_config_needed ) {
                            ha->init_cb->additional_firmware_options.connection_options = ha->operating_mode;
                            restart_risc = 1;
                        }
                        isp_init = 1;

                    }
                } while( restart_risc && retry-- );

                if( isp_init ) {
                    ha->flags.reset_marker = FALSE;
                    qla2100_marker(ha, 0, 0, 0, MK_SYNC_ALL);

                    ha->flags.online = TRUE;

                    /* Enable target response to SCSI bus. */
                    if( ha->flags.enable_target_mode )
                        qla2100_enable_lun(ha);
                }

            }

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
            if( status )
                qla2100_print("qla2100_initialize_adapter: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
            else
                LEAVE("qla2100_initialize_adapter");
#endif
            return(status);
        }

        /*
        * ISP Firmware Test
        *      Checks if present version of RISC firmware is older than
        *      driver firmware.
        *
        * Input:
        *      ha = adapter block pointer.
        *
        * Returns:
        *      0 = firmware does not need to be loaded.
        */
        STATIC uint8_t
        qla2100_isp_firmware(scsi_qla_host_t *ha) {
            uint8_t  status;
            uint16_t mb[MAILBOX_REGISTER_COUNT];

#ifdef QL_DEBUG_LEVEL_3
            ENTER("qla2x00_isp_firmware");
#endif

            if( ha->flags.disable_risc_code_load ) {
                /* Verify checksum of loaded RISC code. */
                mb[0] = MBC_VERIFY_CHECKSUM;
                mb[1] = *QLBoardTbl_fc[ha->devnum].fwstart;
                if( !(status = qla2100_mailbox_command(ha, BIT_1|BIT_0, &mb[0])) ) {
                    /* Start firmware execution. */
                    mb[0] = MBC_EXECUTE_FIRMWARE;
                    mb[1] = *QLBoardTbl_fc[ha->devnum].fwstart;
                    qla2100_mailbox_command(ha, BIT_1|BIT_0, &mb[0]);
                }
            } else
                status = 1;

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
            if( status )
                qla2100_print(
                "qla2100_isp_firmware: **** Return status=1; RISC Load Needed ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
                LEAVE("qla2x00_isp_firmware");
#endif
            return(status);
        }



        /*
        * (08/05/99)
        *
        * PCI configuration
        *      Setup device PCI configuration registers.
        *
        * Input:
        *      ha = adapter block pointer.
        *
        * Returns:
        *      0 = success.
        */
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,95)
        STATIC uint8_t
        qla2100_pci_config(scsi_qla_host_t *ha) {
            uint8_t      status = 1;
            uint32_t     command;
#if MEMORY_MAPPED_IO
            uint32_t  page_offset, base;
            uint32_t   mmapbase;
#endif
            config_reg_t *creg = 0;
            uint16_t     buf_wd;

            ENTER("qla2100_pci_config");
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,95)
/* 4.12 */
           /* turn on PCI master; for system BIOSes that don't turn
              it on by default */
            pci_set_master(ha->pdev);

           if (ha->device_id == QLA2300_DEVICE_ID) {
               pci_read_config_word(ha->pdev,OFFSET(creg->command), &buf_wd);
               buf_wd = buf_wd | 
                        PCI_COMMAND_IO |
                        PCI_COMMAND_MEMORY | 
                        PCI_COMMAND_MASTER | 
                        PCI_COMMAND_INVALIDATE |
                        PCI_COMMAND_PARITY | 
                        PCI_COMMAND_SERR;
               buf_wd = buf_wd & ~PCI_COMMAND_INVALIDATE;
               pci_write_config_word(ha->pdev,OFFSET(creg->command), buf_wd);
               /* temporary: set upper 32 bits of 64 bit address to 0 */
               buf_wd = 0;
               pci_write_config_word(ha->pdev,PCI_BASE_ADDRESS_2, buf_wd);
           }
#endif
            pci_read_config_word(ha->pdev,OFFSET(creg->revision_id), &buf_wd);
            ha->revision = buf_wd;
            if( !ha->iobase ) {
                /* Get command register. */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
                if( pci_read_config_word(ha->pdev,OFFSET(creg->command), &buf_wd) == PCIBIOS_SUCCESSFUL ) {
#else
                if( pci_read_config_word(ha->pdev,OFFSET(creg->command), &buf_wd) == PCIBIOS_SUCCESSFUL ) {
#endif
                    command = buf_wd;
                    /*
                    * Set Bus Master Enable (bit-2), Memory Address Space Enable and
                    * reset any error bits.
                    */
                    buf_wd &= ~0x7;
#if MEMORY_MAPPED_IO
                    DEBUG(printk("qla2100: I/O SPACE and MEMORY MAPPED IO is enabled.\n"));
                    buf_wd |= BIT_2 + BIT_1 + BIT_0;
#else
                    DEBUG(printk("qla2100: I/O SPACE Enabled and MEMORY MAPPED IO is disabled.\n"));
                    buf_wd |= BIT_2 + BIT_0;
#endif
                    if( pci_write_config_word(ha->pdev,OFFSET(creg->command), buf_wd) ) {
                        printk(KERN_WARNING "qla2100: Could not write config word.\n");
                    }
                    /* Get expansion ROM address. */
                    if( pci_read_config_word(ha->pdev, OFFSET(creg->expansion_rom), &buf_wd) == PCIBIOS_SUCCESSFUL ) {
                        /* Reset expansion ROM address decode enable. */
                        buf_wd &= ~BIT_0;
                        if( pci_write_config_word(ha->pdev, OFFSET(creg->expansion_rom), buf_wd) == PCIBIOS_SUCCESSFUL ) {
#if MEMORY_MAPPED_IO
                            /* Get memory mapped I/O address. */
                            pcibios_read_config_dword(ha->pci_bus, ha->pci_device_fn,OFFSET(cfgp->mem_base_addr), &mmapbase);
                            mmapbase &= PCI_BASE_ADDRESS_MEM_MASK;

                            /* Find proper memory chunk for memory map I/O reg. */
                            base = mmapbase & PAGE_MASK;
                            page_offset = mmapbase - base;
                            /* Get virtual address for I/O registers. */
                            ha->mmpbase = ioremap(base,page_offset + 256);
                            if( ha->mmpbase ) {
                                ha->mmpbase += page_offset;
                                /* ha->iobase = ha->mmpbase; */
                                status = 0;
                            }
#else /* MEMORY_MAPPED_IO */
                            status = 0;
#endif /* MEMORY_MAPPED_IO */
                        }
                    }
                }
            } else
                status = 0;


            LEAVE("qla2100_pci_config");
            return(status);
        }
#else
        STATIC uint8_t
        qla2100_pci_config(scsi_qla_host_t *ha) {
            uint8_t      status = 1;
            uint32_t     command;
#if MEMORY_MAPPED_IO
            uint32_t  page_offset, base;
            uint32_t   mmapbase;
#endif
            config_reg_t *creg = 0;
            uint16_t     buf_wd;

            ENTER("qla2100_pci_config");

            pcibios_read_config_word(ha->pci_bus,ha->pci_device_fn, OFFSET(creg->revision_id), &buf_wd);
            ha->revision = buf_wd;
            if( !ha->iobase ) {
                /* Get command register. */
                if( pcibios_read_config_word(ha->pci_bus,ha->pci_device_fn, OFFSET(creg->command), &buf_wd) == PCIBIOS_SUCCESSFUL ) {
                    command = buf_wd;

                    /*
                    * Set Bus Master Enable (bit-2), Memory Address Space Enable and
                    * reset any error bits.
                    */
                    buf_wd &= ~0x7;
#if MEMORY_MAPPED_IO
                    DEBUG(printk("qla2100: I/O SPACE and MEMORY MAPPED IO is enabled.\n"));
                    buf_wd |= BIT_2 + BIT_1 + BIT_0;
#else
                    DEBUG(printk("qla2100: I/O SPACE Enabled and MEMORY MAPPED IO is disabled.\n"));
                    buf_wd |= BIT_2 + BIT_0;
#endif
                    if( pcibios_write_config_word(ha->pci_bus,ha->pci_device_fn, OFFSET(creg->command), buf_wd) ) {
                        printk(KERN_WARNING "qla2100: Could not write config word.\n");
                    }
                    /* Get expansion ROM address. */
                    if( pcibios_read_config_word(ha->pci_bus,ha->pci_device_fn, OFFSET(creg->expansion_rom), &buf_wd) == PCIBIOS_SUCCESSFUL ) {
                        /* Reset expansion ROM address decode enable. */
                        buf_wd &= ~BIT_0;
                        if( pcibios_write_config_word(ha->pci_bus,ha->pci_device_fn, OFFSET(creg->expansion_rom), buf_wd) == PCIBIOS_SUCCESSFUL ) {
#if MEMORY_MAPPED_IO
                            /* Get memory mapped I/O address. */
                            pcibios_read_config_dword(ha->pci_bus, ha->pci_device_fn,OFFSET(cfgp->mem_base_addr), &mmapbase);
                            mmapbase &= PCI_BASE_ADDRESS_MEM_MASK;

                            /* Find proper memory chunk for memory map I/O reg. */
                            base = mmapbase & PAGE_MASK;
                            page_offset = mmapbase - base;
                            /* Get virtual address for I/O registers. */
                            ha->mmpbase = ioremap(base,page_offset + 256);
                            if( ha->mmpbase ) {
                                ha->mmpbase += page_offset;
                                /* ha->iobase = ha->mmpbase; */
                                status = 0;
                            }
#else /* MEMORY_MAPPED_IO */
                            status = 0;
#endif /* MEMORY_MAPPED_IO */
                        }
                    }
                }
            } else
                status = 0;


            LEAVE("qla2100_pci_config");
            return(status);
        }
#endif


        /*
        * qla2100_set_cache_line
        *      Sets PCI cache line parameter.
        *
        * Input:
        *      ha = adapter block pointer.
        *
        * Returns:
        *      0 = success.
        */
        STATIC uint8_t
        qla2100_set_cache_line(scsi_qla_host_t *ha) {
            int          status = 0;
            uint8_t      buf;
            config_reg_t *creg = 0;

#ifdef QL_DEBUG_LEVEL_3
            ENTER("qla2100_set_cache_line");
#endif
            /* Set the cache line. */
            if( ha->flags.set_cache_line_size_1 ) {
                buf = 1;
                if( pcibios_write_config_byte(ha->pci_bus,
                    ha->pci_device_fn,
                    (u_long)&creg->cache_line,buf) != PCIBIOS_SUCCESSFUL )
                    status = 1;
            }

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
            if( status )
                qla2100_print("qla2100_set_cache_line: **** FAILED ****\n\r");
#endif
#ifdef QL_DEBUG_LEVEL_3
            else
                LEAVE("qla2100_set_cache_line");
#endif
            return(status);
        }

        /*
        * Chip diagnostics
        *      Test chip for proper operation.
        *
        * Input:
        *      ha = adapter block pointer.
        *
        * Returns:
        *      0 = success.
        */
        STATIC uint8_t
        qla2100_chip_diag(scsi_qla_host_t *ha) {
            device_reg_t     *reg       = ha->iobase;
            device2300_reg_t *reg2300   = ha->iobase2300;
            uint8_t      status = 0;
            uint16_t     data;
            uint32_t     cnt;
            uint16_t     mb[MAILBOX_REGISTER_COUNT];

            ENTER("qla2100_chip_diag");
#ifdef QL_DEBUG_LEVEL_3
            qla2100_print("qla2100_chip_diag: testing device at ");
        qla2100_output_number((u_long)&reg->flash_address, 16);
            qla2100_print("\n");
#endif

            /* Reset ISP chip. */
            WRT_REG_WORD(&reg->ctrl_status, ISP_RESET);
            data = qla2100_debounce_register(&reg->ctrl_status);
            for( cnt = 6000000 ; cnt && (data & ISP_RESET); cnt-- ) {
                SYS_DELAY(5);
                data = RD_REG_WORD(&reg->ctrl_status);
            }

            if( cnt ) {
#if defined(QL_DEBUG_LEVEL_2)
                qla2100_print("{{{qla2100_chip_diag: Reset register cleared by chip}}}\n\r");
#endif
                /* Reset RISC processor. */
                WRT_REG_WORD(&reg->host_cmd, HC_RESET_RISC);
                WRT_REG_WORD(&reg->host_cmd, HC_RELEASE_RISC);
                data = qla2100_debounce_register(&reg->mailbox0);
                for( cnt = 6000000; cnt && (data == MBS_BUSY); cnt-- ) {
                    SYS_DELAY(5);
                    data = RD_REG_WORD(&reg->mailbox0);
                }

                if( cnt ) {
                    /* Check product ID of chip */
#if defined(QL_DEBUG_LEVEL_2)
                    qla2100_print("{{{qla2100_chip_diag: Checking product ID of chip}}}\n\r");
#endif
                if (ha->device_id != QLA2300_DEVICE_ID) {
                    if( RD_REG_WORD(&reg->mailbox1) != PROD_ID_1 ||
                       (RD_REG_WORD(&reg->mailbox2) != PROD_ID_2 &&
                        RD_REG_WORD(&reg->mailbox2) != PROD_ID_2a) ||
                        RD_REG_WORD(&reg->mailbox3) != PROD_ID_3 ||
                        qla2100_debounce_register(&reg->mailbox4) != PROD_ID_4 ) {
                        printk(KERN_INFO "qla2100: Wrong product ID = 0x%x,0x%x,0x%x,0x%x\n",
                        RD_REG_WORD(&reg->mailbox1),
                        RD_REG_WORD(&reg->mailbox2),
                        RD_REG_WORD(&reg->mailbox3),
                        RD_REG_WORD(&reg->mailbox4));
                        status = 1;
                    } else {
                        /* Now determine if we have a 2200A board */
                        if( ( ha->device_id == QLA2200_DEVICE_ID   ||
                              ha->device_id == QLA2200A_DEVICE_ID ) &&
                              RD_REG_WORD(&reg->mailbox7) ==
                              QLA2200A_RISC_ROM_VER ) {
                                  ha->device_id = QLA2200A_DEVICE_ID;
#if defined(QL_DEBUG_LEVEL_2)
                                  qla2100_print("qla2100_chip_diag: Found QLA2200A chip.\n\r");
#endif
                        }
                    }
                } else {  /* check prod id of 2300 here */
                    if( RD_REG_WORD(&reg2300->mailbox1) != PROD_ID_1 ||
                       (RD_REG_WORD(&reg2300->mailbox2) != PROD_ID_2 &&
                        RD_REG_WORD(&reg2300->mailbox2) != PROD_ID_2a) ||
                        RD_REG_WORD(&reg2300->mailbox3) != PROD_ID_3 ||
                        qla2100_debounce_register(&reg2300->mailbox4) != PROD_ID_4 ) {
                        printk("qla2300: Wrong product ID = 0x%x,0x%x,0x%x,0x%x\n",
                        RD_REG_WORD(&reg2300->mailbox1),
                        RD_REG_WORD(&reg2300->mailbox2),
                        RD_REG_WORD(&reg2300->mailbox3),
                        RD_REG_WORD(&reg2300->mailbox4));
                        status = 1;
                }
                DEBUG(printk("qla2100_chip_diag: Do MBC_MAILBOX_REGISTER_TEST\n"));
#if defined(QL_DEBUG_LEVEL_2)
                qla2100_print("qla2100_chip_diag: Do MBC_MAILBOX_REGISTER_TEST\n\r");
#endif
                        /* Wrap Incoming Mailboxes Test. */
                        mb[0] = MBC_MAILBOX_REGISTER_TEST;
                        mb[1] = 0xAAAA;
                        mb[2] = 0x5555;
                        mb[3] = 0xAA55;
                        mb[4] = 0x55AA;
                        mb[5] = 0xA5A5;
                        mb[6] = 0x5A5A;
                        mb[7] = 0x2525;
                        if( !(status = qla2100_mailbox_command(ha,
                        BIT_7|BIT_6|BIT_5|BIT_4|BIT_3|BIT_2|BIT_1|BIT_0,
                        &mb[0])) ) {
                            if( mb[1] != 0xAAAA || mb[2] != 0x5555 ||
                            mb[3] != 0xAA55 || mb[4] != 0x55AA )
                                status = 1;
                            if( mb[5] != 0xA5A5 || mb[6] != 0x5A5A ||
                            mb[7] != 0x2525 )
                                status = 1;
                            if( status ) {
                                printk("qla2100_chip_diag: *** Failed mailbox register test ***\n\r");
                                DEBUG(qla2100_print("qla2100_chip_diag: *** Failed mailbox register test ***\n\r");)
                            }
                        } else {
                                printk("qla2100_chip_diag: failed mailbox send register test\n");
                                DEBUG(qla2100_print("qla2100_chip_diag: Failed mailbox send register test\n\r");)
                        }
                    }
                } else
                    status = 1;
            } else
                status = 1;

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
            if( status )
                 qla2100_print("qla2100_chip_diag: **** FAILED ****\n");
            else qla2100_print("qla2100_chip_diag: Returning Good Status \n");
#endif
#ifdef QL_DEBUG_LEVEL_3
            LEAVE("qla2100_chip_diag");
#endif
            return(status);
        }

        /*
        * Setup chip
        *      Load and start RISC firmware.
        *
        * Input:
        *      ha = adapter block pointer.
        *
        * Returns:
        *      0 = success.
        */
        STATIC uint8_t
        qla2100_setup_chip(scsi_qla_host_t *ha) {
            uint16_t cnt;
            uint16_t risc_address;
            uint16_t *risc_code_address;
            long risc_code_size;
            uint16_t mb[MAILBOX_REGISTER_COUNT];
            uint8_t  status = 0;
            int num, temp;
#ifdef WORD_FW_LOAD
            uint16_t *ql21_risc_code_addr01;
            uint16_t  ql21_risc_code_length01;
            uint8_t   dump_status;
#endif

#ifdef QL_DEBUG_LEVEL_3
            ENTER("qla2100_setup_chip");
#endif

            /* Load RISC code. */
            risc_address = *QLBoardTbl_fc[ha->devnum].fwstart;
            risc_code_address = QLBoardTbl_fc[ha->devnum].fwcode;
            risc_code_size    = (long)(*QLBoardTbl_fc[ha->devnum].fwlen & 0xffff);

            DEBUG(printk("qla2100_setup_chip: Loading RISC code size =(0x%lx)\n",risc_code_size);)
            DEBUG(qla2100_print("qla2100_setup_chip: Loading RISC code now in silent mode!\n\r");)
            num = 0;
            DEBUG(sprintf(debug_buff,"virt=%x phys=%x\n\r",ha->request_ring,ha->request_dma);)
            DEBUG(qla2100_print(debug_buff);)
            /* go into silent mode */
            temp =  ql2x_debug_print;
            if( ql2x_debug_print )    ql2x_debug_print = 0;

            while( risc_code_size > 0 && !status ) {
                /* for 2200A set transfer size to 128 bytes */
                if( ha->device_id == QLA2200A_DEVICE_ID )
                    cnt = 128 >> 1;
                else
                    cnt = REQUEST_ENTRY_SIZE * REQUEST_ENTRY_CNT >> 1;
                if( cnt > risc_code_size )
                    cnt = risc_code_size;

                DEBUG(sprintf(debug_buff,"qla2100_setup_chip:loading risc segment@ addr 0x%x, number of bytes 0x%x, offset 0x%x.\n\r",risc_code_address,cnt,risc_address);)
                DEBUG(qla2100_print(debug_buff);)

                BCOPY((caddr_t) risc_code_address,(caddr_t) ha->request_ring, (cnt <<1));

                flush_cache_all(); /* flush written firmware to the
                                      ha->request_ring buffer before DMA */

                mb[0] = MBC_LOAD_RAM;
                mb[1] = risc_address;
                mb[3] = (uint16_t)(ha->request_dma & 0xffff);
                mb[2] = (uint16_t)((ha->request_dma >> 16) & 0xffff);
                mb[4] = cnt;
                status = qla2100_mailbox_command(ha, BIT_4|BIT_3|BIT_2|BIT_1|BIT_0,
                &mb[0]);

                if( status ) {
                    qla2100_dump_regs(ha->host);
                    printk("Failed to load segment %d of FW\n",num);
                    DEBUG(qla2100_print("qla2100_setup_chip: Failed to load segment of FW\n");)
                    break;
                }
                risc_address += cnt;
                risc_code_size -= cnt;
                risc_code_address += cnt;
                num++;
            }
            ql2x_debug_print = temp;

#ifdef WORD_FW_LOAD
            {
                int i;
                uint8_t temp;

                temp =  ql2x_debug_print;
                if( ql2x_debug_print )   ql2x_debug_print = 0;
                risc_address = *QLBoardTbl_fc[ha->devnum].fwstart;
                ql21_risc_code_addr01  = QLBoardTbl_fc[ha->devnum].fwcode;
                ql21_risc_code_length01= (long)(*QLBoardTbl_fc[ha->devnum].fwlen & 0xffff);

                for( i = 0; i < ql21_risc_code_length01 ; i++ ) {

                    mb[0] = MBC_WRITE_RAM_WORD;
                    mb[1] = risc_address + i;
                    mb[2] = *(ql21_risc_code_addr01 + i);

                    dump_status = qla2100_mailbox_command(ha,BIT_2|BIT_1|BIT_0,
                    &mb[0]);
                    if( dump_status ) {
                        printk("qla2100 : firmware load failure\n");
                        break;
                    }

                    mb[0] = MBC_READ_RAM_WORD;
                    mb[1] = risc_address + i;
                    mb[2] = 0;

                    dump_status = qla2100_mailbox_command(ha,BIT_2|BIT_1|BIT_0,
                    &mb[0]);
                    if( dump_status ) {
                        printk("qla2x00: RISC FW Read Failure\n");
                        break;
                    }
                    if( mb[2] != *(ql21_risc_code_addr01 + i) )
                        printk("qla2x00: RISC FW Compare ERROR @ (0x%p)\n",
                        (void *) (ql21_risc_code_addr01+i));
                }
                ql2x_debug_print = temp;
                printk("qla2x00: RISC FW download confirmed... \n");
            }
#endif
            /* Verify checksum of loaded RISC code. */
            if( !status ) {
                DEBUG(printk("qla2100_setup_chip: Verifying Check Sum of loaded RISC code.\n");)
                mb[0] = MBC_VERIFY_CHECKSUM;
                mb[1] = *QLBoardTbl_fc[ha->devnum].fwstart;
                if( !(status = qla2100_mailbox_command(ha, BIT_1|BIT_0, &mb[0])) ) {
                    /* Start firmware execution. */
                    DEBUG(qla2100_print("qla2100_setup_chip: CS Ok, Start firmware running\n\r");)
                    mb[0] = MBC_EXECUTE_FIRMWARE;
                    mb[1]= *QLBoardTbl_fc[ha->devnum].fwstart;
                    status = qla2100_mailbox_command(ha, BIT_1|BIT_0, &mb[0]);
                }
#if defined(QL_DEBUG_LEVEL_2)
                else
                    qla2100_print("qla2100_setup_chip: ISP FW Failed Check Sum\n");
#endif
            }

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
            if( status )
                qla2100_print("qla2100_setup_chip: **** FAILED ****\n");
            else qla2100_print("qla2100_setup_chip: Returning Good Status\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
            LEAVE("qla2100_setup_chip");
#endif
            return(status);
        }

        /*
        * qla2100_init_rings
        *      Initializes firmware.
        *
        *      Beginning of request ring has initialization control block
        *      already built by nvram config routine.
        *
        * Input:
        *      ha                = adapter block pointer.
        *      ha->request_ring  = request ring virtual address
        *      ha->response_ring = response ring virtual address
        *      ha->request_dma   = request ring physical address
        *      ha->response_dma  = response ring physical address
        *
        * Returns:
        *      0 = success.
        */
        STATIC uint8_t
        qla2100_init_rings(scsi_qla_host_t *ha) {
            uint8_t  status;
            uint16_t mb[MAILBOX_REGISTER_COUNT];
            int cnt;
            device2300_reg_t *reg2300   = ha->iobase2300;

#ifdef QL_DEBUG_LEVEL_3
            ENTER("qla2100_init_rings");
#endif
            /* Clear outstanding commands array. */
            for( cnt = 0; cnt < MAX_OUTSTANDING_COMMANDS; cnt++ )
                ha->outstanding_cmds[cnt] = 0;

#ifdef RSCN
            /* Clear RSCN queue. */
            ha->rscn_in_ptr = 0;
            ha->rscn_out_ptr = 0;
#endif

            /* Initialize firmware. */
            ha->request_ring_ptr  = ha->request_ring;
            ha->req_ring_index    = 0;
            ha->req_q_cnt         = REQUEST_ENTRY_CNT;
            ha->response_ring_ptr = ha->response_ring;
            ha->rsp_ring_index    = 0;
            mb[0] = MBC_INITIALIZE_FIRMWARE;
            mb[3] = LSW(ha->init_cb_dma);
            mb[2] = MSW(ha->init_cb_dma);
            mb[4] = 0; /* set request queue in ptr   for 2100/2200 */
            mb[5] = 0; /* set response queue out ptr for 2100/2200*/
            mb[7] = QL21_64BITS_3RDWD(ha->init_cb_dma);
            mb[6] = QL21_64BITS_4THWD(ha->init_cb_dma);

            if (ha->device_id == QLA2300_DEVICE_ID) {
            /* set request queue in ptr , response queue out ptr for 2300 */ 
               WRT_REG_WORD(&reg2300->req_q_in,  0);
               WRT_REG_WORD(&reg2300->rsp_q_out, 0);
            }

            DEBUG(qla2100_print("qla2100_init_rings: Issue MBC_INIT_FIRMWARE op\n");)
            status = qla2100_mailbox_command(ha,
            BIT_7|BIT_6|BIT_5|BIT_4|BIT_3|BIT_2|BIT_0,
            &mb[0]);

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
            if( status )
                qla2100_print("qla2100_init_rings: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
                LEAVE("qla2100_init_rings");
#endif
            return(status);
        }

    /*
    * qla2100_fw_ready
    *      Waits for firmware ready.
    *
    * Input:
    *      ha = adapter block pointer.
    *
    * Returns:
    *      0 = success.
    */
    STATIC uint8_t
    qla2100_fw_ready(scsi_qla_host_t *ha) {
        uint8_t  status = 0;
        uint32_t cnt, cnt1;
        uint16_t mb[MAILBOX_REGISTER_COUNT];
        uint16_t timeout;

#ifdef QL_DEBUG_LEVEL_3
        ENTER("qla2100_fw_ready");
#endif
        timeout = (ha->retry_count * ha->login_timeout) + 5;
        cnt1 = 0x350;   /* 25 secs */ 
        /* Wait for ISP to finish LIP */
        if(!qla2100_quiet) printk("scsi(%d): Waiting for LIP to complete...\n", (int)ha->host->host_no);
        if( timeout )
          cnt = 36 * timeout;
        else
          cnt = 0x700;

        for( ; cnt; cnt-- ) {
            mb[0] = MBC_GET_FIRMWARE_STATE;
            if( !(status = qla2100_mailbox_command(ha, BIT_0, &mb[0])) ) {
                if( ha->loop_down_timer || mb[1] != FSTATE_READY ) {
                    status = 1;
                    /* Exit if no cable connected after 10 seconds. */
                    if( !cnt1-- )
                        if( mb[1] == FSTATE_CONFIG_WAIT || mb[1] == FSTATE_LOSS_OF_SYNC ) {

                            break;   
                        }
                } else {
                    DEBUG(printk("qla2100_fw_ready: F/W Ready - OK \n");)
                    status = 0;   /* dg 09/15/99 */
                    break;
                }
            }

            if( ha->flags.online ) {
                status = 0;   /* dg 09/15/99 */
                break;
            }

            /* Delay for a while */
            udelay(10);

#ifdef QL_DEBUG_LEVEL_2
/*            qla2100_print("qla2100_fw_ready: mailbox_out[1] = ");
            qla2100_output_number((uint32_t)mb[1], 16);
            qla2100_print("\n");*/
#endif
        }

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
        if( status )
            qla2100_print("qla2100_fw_ready: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
        else
            LEAVE("qla2100_fw_ready");
#endif
        return(status);
    }

        /*
        *  qla2100_configure_hba
        *      Setup adapter context.
        *
        * Input:
        *      ha = adapter state pointer.
        *
        * Returns:
        *      0 = success
        *
        * Context:
        *      Kernel context.
        */
        STATIC uint8_t
        qla2100_configure_hba(scsi_qla_host_t *ha) {
            uint8_t       rval;
            uint16_t    mb[MAILBOX_REGISTER_COUNT];
            uint8_t       connect_type[22];

#ifdef QL_DEBUG_LEVEL_3
            ENTER("qla2100_configure_hba");
#endif

            /* Get host addresses. */
            mb[0] = MBC_GET_ADAPTER_LOOP_ID;
            rval = qla2100_mailbox_command(ha, BIT_0, &mb[0]);
            if( !rval ) {
                ha->loop_id = mb[1];

                /* Get loop topology. */
                if( ha->device_id == QLA2100_DEVICE_ID ) {
                    mb[6] = 0;
                }
                ha->min_external_loopid = SNS_FIRST_LOOP_ID;
                ha->operating_mode = LOOP;
                switch( mb[6] ) {
                    case 0:
                        ha->current_topology = ISP_CFG_NL;
                        strcpy((char *)&connect_type[0],"(Loop)");
                        break;
                    case 1:
                        ha->current_topology = ISP_CFG_FL;
                        strcpy((char *)&connect_type[0],"(FL_Port)");
                        break;
                    case 2:
                        ha->operating_mode = P2P;
                        ha->current_topology = ISP_CFG_N;
                        ha->min_external_loopid = 1;  /* v2.19.5b3 */
                        strcpy((char *)&connect_type[0],"(N_Port-to-N_Port)");
                        break;
                    case 3:
                        ha->operating_mode = P2P;
                        ha->current_topology = ISP_CFG_F;
                        ha->min_external_loopid = 1;  /* v2.19.5b3 */
                        strcpy((char *)&connect_type[0],"(F_Port)");
                        break;
                    default:
                        ha->current_topology = ISP_CFG_NL;
                        strcpy((char *)&connect_type[0],"(Loop)");
                        break;
                }

                /* Save Host port and loop ID. */
                /* Reverse byte order - TT */
                ha->port_id[2] = LSB(mb[2]);
                ha->port_id[1] = MSB(mb[2]);
                ha->port_id[0] = LSB(mb[3]);
                if (!qla2100_quiet) printk("scsi%d: Topology - %s, Host Loop address  0x%x\n",(int)ha->host_no,connect_type, ha->loop_id);
            } else
                printk("qla2100_configure_hba: Get host loop ID  failed\n");

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
            if( rval != 0 )
                qla2100_print("qla2100_configure_hba: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
            else
                LEAVE("qla2100_configure_hba");
#endif
            return(rval);
        }
        /*
        * NVRAM configuration for 2100.
        *
        * Input:
        *      ha                = adapter block pointer.
        *      ha->request_ring  = request ring virtual address
        *      ha->response_ring = response ring virtual address
        *      ha->request_dma   = request ring physical address
        *      ha->response_dma  = response ring physical address
        *
        * Output:
        *      initialization control block in response_ring
        *      host adapters parameters in host adapter block
        *
        * Returns:
        *      0 = success.
        */
        STATIC uint8_t
        qla2100_nvram_config(scsi_qla_host_t *ha) {
            uint8_t   status = 0;
            uint16_t  cnt;
            caddr_t   dptr1, dptr2;
            init_cb_t *icb   = ha->init_cb;
            nvram21_t   *nv    = (nvram21_t *)ha->request_ring;
            uint16_t  *wptr  = (uint16_t *)ha->request_ring;
            uint8_t   chksum = 0;

#ifdef QL_DEBUG_LEVEL_3
            ENTER("qla2100_nvram_config");
#endif

            /* Verify valid NVRAM checksum. */
            for( cnt = 0; cnt < sizeof(nvram21_t)/2; cnt++ ) {
                *wptr = qla2100_get_nvram_word(ha, cnt);
                chksum += (uint8_t)*wptr;
                chksum += (uint8_t)(*wptr >> 8);
                wptr++;
            }

#if  DEBUG_PRINT_NVRAM
            qla2100_print(
            "qla2100_nvram_config: Contents of NVRAM ");
            qla2100_print("\n\r");
            qla2100_dump_buffer((uint8_t *)ha->request_ring, sizeof(nvram21_t));
#endif

            /* Bad NVRAM data, set defaults parameters. */
            if( chksum || nv->id[0] != 'I' || nv->id[1] != 'S' || nv->id[2] != 'P' ||
            nv->id[3] != ' ' || nv->nvram_version < 1 ) {
                /* Reset NVRAM data. */
                DEBUG(printk("Using defaults for NVRAM: \n"));
                DEBUG(printk("checksum=0x%x, Id=%c, version=0x%x\n",chksum,nv->id[0],nv->nvram_version));
                wptr = (uint16_t *)ha->request_ring;
                for( cnt = 0; cnt < sizeof(nvram21_t)/2; cnt++ )
                    *wptr++ = 0;

                /*
                * Set default initialization control block.
                */
                nv->parameter_block_version = ICB_VERSION;
                nv->firmware_options.enable_fairness = 1;
                nv->firmware_options.enable_fast_posting = 1;
                nv->firmware_options.enable_full_login_on_lip = 1;

                nv->frame_payload_size  = 1024;
                nv->max_iocb_allocation = 256;
                nv->execution_throttle  = 16;
                nv->retry_count         = 8;
                nv->retry_delay         = 1;
                nv->node_name[0]        = 32;
                nv->node_name[3]        = 224;
                nv->node_name[4]        = 139;
                nv->login_timeout       = 4;

                /*
                * Set default host adapter parameters
                */
                nv->host_p.enable_lip_full_login = 1;
                nv->reset_delay = 5;
                nv->port_down_retry_count = 8;
                nv->maximum_luns_per_target = 8;
                status = 1;
            }

            /*
            * Copy over NVRAM RISC parameter block
            * to initialization control block.
            */
            dptr1 = (caddr_t)icb;
            dptr2 = (caddr_t)&nv->parameter_block_version;
            cnt = (caddr_t)&nv->host_p - (caddr_t)&nv->parameter_block_version;
            while( cnt-- )
                *dptr1++ = *dptr2++;

            /* HBA node name 0 correction */
            for (cnt=0 ; cnt<8 ; cnt++) {
                if (icb->node_name[cnt] != 0)
                   break;
            }
            if (cnt == 8) {
               for ( cnt= 0 ; cnt < 8 ; cnt++) 
                    icb->node_name[cnt] = icb->port_name[cnt];
               icb->node_name[0] = icb->node_name[0] & ~BIT_0;
               icb->port_name[0] = icb->port_name[0] |  BIT_0;
            }

            /*
            * Setup driver firmware options.
            */
#if  QL2100_TARGET_MODE_SUPPORT
            icb->firmware_options.enable_target_mode       = 1;
#else
            icb->firmware_options.enable_target_mode       = 0;
#endif
            icb->firmware_options.disable_initiator_mode   = 0;
            icb->firmware_options.enable_port_update_event = 1;
            icb->firmware_options.enable_full_login_on_lip = 1;

            /*
            * Set host adapter parameters
            */
            ha->flags.enable_target_mode = icb->firmware_options.enable_target_mode;
            ha->flags.disable_luns            = nv->host_p.disable_luns;
            ha->flags.disable_risc_code_load  = nv->host_p.disable_risc_code_load;
            ha->flags.set_cache_line_size_1   = nv->host_p.set_cache_line_size_1;
            ha->flags.enable_64bit_addressing = nv->host_p.enable_64bit_addressing;

#if BITS_PER_LONG > 32
    /* Enable 64bit addressing for OS/System combination supporting it   */
    /* actual NVRAM bit is: nv->cntr_flags_1.enable_64bit_addressing     */ 
    /* but we will ignore it and use BITS_PER_LONG macro to setup for    */
    /* 64 or 32 bit access of host memory in all x86/ia-64/Alpha systems */
    ha->flags.enable_64bit_addressing = 1;
#else
    ha->flags.enable_64bit_addressing = 0;
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,18)
        if (ha->flags.enable_64bit_addressing)
           printk("[[[ qla2x00: 64 Bit PCI Addressing Enabled ]]]\n");

#if BITS_PER_LONG > 32
           /* Update our PCI device dma_mask for full 64 bit mask */
           /* ha->pdev->dma_mask = (pci_dma_t) 0xffffffffffffffffull; */
           ha->pdev->dma_mask = 0xffffffffffffffff;
#endif
#endif
            ha->flags.enable_lip_reset        = nv->host_p.enable_lip_reset;
            ha->flags.enable_lip_full_login   = nv->host_p.enable_lip_full_login;
            ha->flags.enable_target_reset     = nv->host_p.enable_target_reset;
            ha->flags.enable_flash_db_update  = nv->host_p.enable_database_storage;

            /* new for IOCTL support of APIs */
            ha->node_name[0] = icb->node_name[0];
            ha->node_name[1] = icb->node_name[1];
            ha->node_name[2] = icb->node_name[2];
            ha->node_name[3] = icb->node_name[3];
            ha->node_name[4] = icb->node_name[4];
            ha->node_name[5] = icb->node_name[5];
            ha->node_name[6] = icb->node_name[6];
            ha->node_name[7] = icb->node_name[7];
            ha->nvram_version = nv->nvram_version;

            /* empty data for QLA2100s OEM stuff */
            ha->oem_id          = 0;
            ha->oem_spare0      = 0;
            for ( cnt= 0 ; cnt < 8 ; cnt++) {
                 ha->oem_string[cnt] = 0; 
                 ha->oem_part[cnt]   = 0; 
                 ha->oem_fru[cnt]    = 0; 
                 ha->oem_ec[cnt]     = 0; 
            }

            ha->hiwat                 = icb->iocb_allocation;
            ha->execution_throttle  = nv->execution_throttle;

            ha->retry_count           = nv->retry_count;
            ha->login_timeout         = nv->login_timeout;
            /* Set minimum login_timeout to 4 seconds. */
            if( ha->login_timeout < 4 )
                ha->login_timeout = 4;
            ha->port_down_retry_count = nv->port_down_retry_count;
            ha->minimum_timeout       = (ha->login_timeout * ha->retry_count)
            + ha->port_down_retry_count;
            ha->loop_reset_delay      = nv->reset_delay;
            /* Will get the value from nvram. */
            ha->loop_down_timeout     = LOOP_DOWN_TIMEOUT;
            ha->loop_down_abort_time  = LOOP_DOWN_TIME - ha->loop_down_timeout;

            /* save HBA serial number */
            ha->serial0 = nv->node_name[5];
            ha->serial1 = nv->node_name[6];
            ha->serial2 = nv->node_name[7];

#if  USE_BIOS_MAX_LUNS
            if( !nv->maximum_luns_per_target )
                ha->max_luns = MAX_LUNS-1;
            else
                ha->max_luns = nv->maximum_luns_per_target;
#else
            ha->max_luns = MAX_LUNS-1;
#endif

            /*
            * Setup ring parameters in initialization control block
            */
            icb->request_q_outpointer  = 0;
            icb->response_q_inpointer  = 0;
            icb->request_q_length      = REQUEST_ENTRY_CNT;
            icb->response_q_length     = RESPONSE_ENTRY_CNT;
            icb->request_q_address[0]  = LS_64BITS(ha->request_dma);
            icb->request_q_address[1]  = MS_64BITS(ha->request_dma);
            icb->response_q_address[0] = LS_64BITS(ha->response_dma);
            icb->response_q_address[1] = MS_64BITS(ha->response_dma);

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
            if( status )
                qla2100_print("qla2100_nvram_config: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
            else
                LEAVE("qla2100_nvram_config");
#endif
            return(status);
        }

        /*
        * NVRAM configuration for the 2200.
        *
        * Input:
        *      ha                = adapter block pointer.
        *      ha->request_ring  = request ring virtual address
        *      ha->response_ring = response ring virtual address
        *      ha->request_dma   = request ring physical address
        *      ha->response_dma  = response ring physical address
        *
        * Output:
        *      initialization control block in response_ring
        *      host adapters parameters in host adapter block
        *
        * Returns:
        *      0 = success.
        */
        STATIC uint8_t
        qla2200_nvram_config(scsi_qla_host_t *ha) {
            uint8_t   status = 0;
            uint16_t  cnt;
            caddr_t   dptr1, dptr2;
            init_cb_t *icb   = ha->init_cb;
            nvram22_t   *nv    = (nvram22_t *)ha->request_ring;
            uint16_t  *wptr  = (uint16_t *)ha->request_ring;
            uint8_t   chksum = 0;

#ifdef QL_DEBUG_LEVEL_3
            ENTER("qla2200/2300_nvram_config");
#endif

            if( !ha->flags.nvram_config_done ) {

                /* Verify valid NVRAM checksum. */
                for( cnt = 0; cnt < sizeof(nvram22_t)/2; cnt++ ) {
                    *wptr = qla2100_get_nvram_word(ha, cnt);
                    chksum += (uint8_t)*wptr;
                    chksum += (uint8_t)(*wptr >> 8);
                    wptr++;
                }

#if  DEBUG_PRINT_NVRAM
                qla2100_print(
                "qla2200_nvram_config: Contents of NVRAM ");
                qla2100_print("\n\r");
                qla2100_dump_buffer((uint8_t *)ha->request_ring, sizeof(nvram22_t));
#endif

                /* Bad NVRAM data, set defaults parameters. */
                if( chksum || nv->id[0] != 'I' || nv->id[1] != 'S' || nv->id[2] != 'P' ||
                nv->id[3] != ' ' || nv->nvram_version < 1 ) {
                    /* Reset NVRAM data. */
                    DEBUG(printk("Using defaults for 2200/2300 NVRAM: \n"));
                    DEBUG(printk("checksum=0x%x, Id0=%c Id1=%c Id2=%x, version=0x%x\n",chksum,nv->id[0],nv->id[1],nv->id[2],nv->nvram_version));
                    wptr = (uint16_t *)nv;
                    for( cnt = 0; cnt < sizeof(nvram21_t)/2; cnt++ )
                        *wptr++ = 0;

                    /*
                    * Set default initialization control block.
                    */
                    nv->parameter_block_version = ICB_VERSION;
                    nv->firmware_options.enable_fairness = 1;
                    nv->firmware_options.enable_fast_posting = 1;
                    nv->firmware_options.enable_full_login_on_lip = 1;
                    nv->firmware_options.enable_name_change = 1;
                    nv->firmware_options.expanded_ifwcb = 1;

                    nv->frame_payload_size  = 1024;
                    nv->max_iocb_allocation = 256;
                    nv->execution_throttle  = 16;
                    nv->retry_count         = 8;
                    nv->retry_delay         = 1;
                    nv->port_name[0]        = 32;
                    nv->port_name[3]        = 224;
                    nv->port_name[4]        = 139;
                    nv->login_timeout       = 4;
                    nv->additional_firmware_options.connection_options = P2P_LOOP;
                    /*
                    * Set default host adapter parameters
                    */
                    nv->host_p.enable_lip_full_login = 1;
                    nv->reset_delay = 5;
                    nv->port_down_retry_count = 8;
                    nv->maximum_luns_per_target = 8;
                    status = 1;
                }

                /* Reset icb data */
                BZERO((caddr_t)icb, sizeof(init_cb_t));
                /*
                * Copy over NVRAM RISC parameter block
                * to initialization control block.
                */
                dptr1 = (caddr_t)icb;
                dptr2 = (caddr_t)&nv->parameter_block_version;
                cnt = (caddr_t)&nv->additional_firmware_options - (caddr_t)&nv->parameter_block_version;
                while( cnt-- )
                    *dptr1++ = *dptr2++;

                dptr1 += (caddr_t)&icb->additional_firmware_options - (caddr_t)&icb->request_q_outpointer;
                cnt = (caddr_t)&nv->host_p - (caddr_t)&nv->additional_firmware_options;
                while( cnt-- )
                    *dptr1++ = *dptr2++;

                /* HBA node name 0 correction */
                for (cnt=0 ; cnt<8 ; cnt++) {
                    if (icb->node_name[cnt] != 0)
                       break;
                }
                if (cnt == 8) {
                   for ( cnt= 0 ; cnt < 8 ; cnt++) 
                       icb->node_name[cnt] = icb->port_name[cnt];
                   icb->node_name[0] = icb->node_name[0] & ~BIT_0;
                   icb->port_name[0] = icb->port_name[0] |  BIT_0;
                }

                /*
                * Setup driver firmware options.
                */
                icb->firmware_options.enable_full_duplex       = 0;
#if  QL2100_TARGET_MODE_SUPPORT
                icb->firmware_options.enable_target_mode       = 1;
#else
                icb->firmware_options.enable_target_mode       = 0;
#endif
                icb->firmware_options.disable_initiator_mode   = 0;
                icb->firmware_options.enable_port_update_event = 1;
                icb->firmware_options.enable_full_login_on_lip = 1;
#if USE_TP_FW
                icb->firmware_options.enable_name_change = 1;
                icb->firmware_options.expanded_ifwcb = 1;
                icb->additional_firmware_options.enable_fc_tape = 1;
                icb->additional_firmware_options.enable_fc_confirm = 1;
#endif
                /*
                * Set host adapter parameters
                */
                ha->flags.enable_target_mode = icb->firmware_options.enable_target_mode;
                ha->flags.disable_luns            = nv->host_p.disable_luns;
                ha->flags.disable_risc_code_load  = nv->host_p.disable_risc_code_load;
                ha->flags.set_cache_line_size_1   = nv->host_p.set_cache_line_size_1;
                ha->flags.enable_64bit_addressing = nv->host_p.enable_64bit_addressing;

#if BITS_PER_LONG > 32
    /* Enable 64bit addressing for OS/System combination supporting it   */
    /* actual NVRAM bit is: nv->cntr_flags_1.enable_64bit_addressing     */ 
    /* but we will ignore it and use BITS_PER_LONG macro to setup for    */
    /* 64 or 32 bit access of host memory in all x86/ia-64/Alpha systems */
    ha->flags.enable_64bit_addressing = 1;
#else
    ha->flags.enable_64bit_addressing = 0;
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,18)
        if (ha->flags.enable_64bit_addressing)
           printk("[[[ qla2x00: 64 Bit PCI Addressing Enabled ]]]\n");

#if BITS_PER_LONG > 32
           /* Update our PCI device dma_mask for full 64 bit mask */
           ha->pdev->dma_mask = 0xffffffffffffffff;
#endif
#endif
                ha->flags.enable_lip_reset        = nv->host_p.enable_lip_reset;
                ha->flags.enable_lip_full_login   = nv->host_p.enable_lip_full_login;
                ha->flags.enable_target_reset     = nv->host_p.enable_target_reset;
                ha->flags.enable_flash_db_update  = nv->host_p.enable_database_storage;
                ha->operating_mode = icb->additional_firmware_options.connection_options;

            /* new for IOCTL support of APIs */
            ha->node_name[0] = icb->node_name[0];
            ha->node_name[1] = icb->node_name[1];
            ha->node_name[2] = icb->node_name[2];
            ha->node_name[3] = icb->node_name[3];
            ha->node_name[4] = icb->node_name[4];
            ha->node_name[5] = icb->node_name[5];
            ha->node_name[6] = icb->node_name[6];
            ha->node_name[7] = icb->node_name[7];
            ha->nvram_version = nv->nvram_version;
 

                ha->hiwat                 = icb->iocb_allocation;
                ha->execution_throttle  = nv->execution_throttle;

                ha->retry_count           = nv->retry_count;
                ha->login_timeout         = nv->login_timeout;
                /* Set minimum login_timeout to 4 seconds. */
                if( ha->login_timeout < 4 )
                    ha->login_timeout = 4;
                ha->port_down_retry_count = nv->port_down_retry_count;
                ha->minimum_timeout       = (ha->login_timeout * ha->retry_count)
                + ha->port_down_retry_count;
                ha->loop_reset_delay      = nv->reset_delay;
                /* Will get the value from nvram. */
                ha->loop_down_timeout     = LOOP_DOWN_TIMEOUT;
                ha->loop_down_abort_time  = LOOP_DOWN_TIME - ha->loop_down_timeout;

                /* save HBA serial number */
                ha->serial0 = nv->port_name[5];
                ha->serial1 = nv->port_name[6];
                ha->serial2 = nv->port_name[7];

                /* save OEM related items for QLA2200s and QLA2300s */
                ha->oem_id     = nv->oem_id;
                ha->oem_spare0 = nv->oem_spare0;

                for ( cnt= 2 ; cnt < 8 ; cnt++ ) 
                  ha->oem_string[cnt] = nv->oem_string[cnt]; 

                for ( cnt= 0 ; cnt < 8 ; cnt++ ) {
                  ha->oem_part[cnt]   = nv->oem_part[cnt]; 
                  ha->oem_fru[cnt]    = nv->oem_fru[cnt]; 
                  ha->oem_ec[cnt]     = nv->oem_ec[cnt]; 
                }

#ifdef FC_IP_SUPPORT
                for (cnt = 0; cnt < 8; cnt++)
                    ha->acPortName[cnt] = nv->port_name[cnt];
#endif

#if  USE_BIOS_MAX_LUNS
                if( !nv->maximum_luns_per_target )
                    ha->max_luns = MAX_LUNS;
                else if( nv->maximum_luns_per_target < MAX_LUNS )
                    ha->max_luns = nv->maximum_luns_per_target;
                else
                    ha->max_luns = MAX_LUNS;
#else
                ha->max_luns = MAX_LUNS;
#endif

                /*
                * Setup ring parameters in initialization control block
                */
                icb->request_q_outpointer  = 0;
                icb->response_q_inpointer  = 0;
                icb->request_q_length      = REQUEST_ENTRY_CNT;
                icb->response_q_length     = RESPONSE_ENTRY_CNT;
                icb->request_q_address[0]  = LS_64BITS(ha->request_dma);
                icb->request_q_address[1]  = MS_64BITS(ha->request_dma);
                icb->response_q_address[0] = LS_64BITS(ha->response_dma);
                icb->response_q_address[1] = MS_64BITS(ha->response_dma);

                icb->lun_enables = 0;
                icb->command_resource_count = 0;
                icb->immediate_notify_resource_count = 0;
                icb->timeout = 0;
                icb->reserved_2 = 0;

                ha->flags.nvram_config_done = 1;
            }

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
            if( status )
                qla2100_print("qla2200_nvram_config: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
            else
                LEAVE("qla2200_nvram_config");
#endif
            return(status);
        }

        /*
        * Get NVRAM data word
        *      Calculates word position in NVRAM and calls request routine to
        *      get the word from NVRAM.
        *
        * Input:
        *      ha      = adapter block pointer.
        *      address = NVRAM word address.
        *
        * Returns:
        *      data word.
        */
        STATIC uint16_t
        qla2100_get_nvram_word(scsi_qla_host_t *ha, uint32_t address) {
            uint32_t nv_cmd;
            uint16_t data;

#ifdef QL_DEBUG_ROUTINES
            uint8_t  saved_print_status = ql2x_debug_print;
#endif
#ifdef QL_DEBUG_LEVEL_4
            qla2100_print("qla2100_get_nvram_word: entered\n");
#endif

            nv_cmd = address << 16;
            nv_cmd |= NV_READ_OP;

#ifdef QL_DEBUG_ROUTINES
            ql2x_debug_print = FALSE;
#endif
            data = qla2100_nvram_request(ha, nv_cmd);
#ifdef QL_DEBUG_ROUTINES
            ql2x_debug_print = saved_print_status;
#endif

#ifdef QL_DEBUG_LEVEL_4
            qla2100_print("qla2100_get_nvram_word: exiting normally NVRAM data = ");
        qla2100_output_number((u_long)data, 16);
            qla2100_print("\n");
#endif
            return(data);
        }

        /*
        * NVRAM request
        *      Sends read command to NVRAM and gets data from NVRAM.
        *
        * Input:
        *      ha     = adapter block pointer.
        *      nv_cmd = Bit 26     = start bit
        *               Bit 25, 24 = opcode
        *               Bit 23-16  = address
        *               Bit 15-0   = write data
        *
        * Returns:
        *      data word.
        */
        STATIC uint16_t
        qla2100_nvram_request(scsi_qla_host_t *ha, uint32_t nv_cmd) {
            uint8_t      cnt;
            device_reg_t *reg = ha->iobase;
            uint16_t     data = 0;
            uint16_t     reg_data;

            /* Send command to NVRAM. */

            nv_cmd <<= 5;
            for( cnt = 0; cnt < 11; cnt++ ) {
                if( nv_cmd & BIT_31 )
                    qla2100_nv_write(ha, NV_DATA_OUT);
                else
                    qla2100_nv_write(ha, 0);
                nv_cmd <<= 1;
            }

            /* Read data from NVRAM. */

            for( cnt = 0; cnt < 16; cnt++ ) {
                WRT_REG_WORD(&reg->nvram, NV_SELECT+NV_CLOCK);
                /* qla2100_nv_delay(ha); */
                NVRAM_DELAY();
                data <<= 1;
                reg_data = RD_REG_WORD(&reg->nvram);
                if( reg_data & NV_DATA_IN )
                    data |= BIT_0;
                WRT_REG_WORD(&reg->nvram, NV_SELECT);
                /* qla2100_nv_delay(ha); */
                NVRAM_DELAY();
            }

            /* Deselect chip. */

            WRT_REG_WORD(&reg->nvram, NV_DESELECT);
            /* qla2100_nv_delay(ha); */
            NVRAM_DELAY();

            return(data);
        }

        STATIC void
        qla2100_nv_write(scsi_qla_host_t *ha, uint16_t data) {
            device_reg_t *reg = ha->iobase;

            WRT_REG_WORD(&reg->nvram, data | NV_SELECT);
            NVRAM_DELAY();
            /* qla2100_nv_delay(ha); */
            WRT_REG_WORD(&reg->nvram, data | NV_SELECT | NV_CLOCK);
            /* qla2100_nv_delay(ha); */
            NVRAM_DELAY();
            WRT_REG_WORD(&reg->nvram, data | NV_SELECT);
            /* qla2100_nv_delay(ha); */
            NVRAM_DELAY();
        }

        STATIC void
        qla2100_nv_delay(void) {
            SYS_DELAY(NV_DELAY_COUNT);
        }


        /*
        * Mailbox Command
        *      Issue mailbox command and waits for completion.
        *
        * Input:
        *      ha = adapter block pointer.
        *      mr = mailbox registers to load.
        *      mb = data pointer for mailbox registers.
        *
        * Output:
        *      mb[MAILBOX_REGISTER_COUNT] = returned mailbox data.
        *
        * Returns:
        *      0 = success
        *      1 = failed    (mbox status != 0x4000)
        */
        STATIC uint8_t
        qla2100_mailbox_command(scsi_qla_host_t *ha, uint32_t mr, uint16_t *mb) {
            device_reg_t     *reg       = ha->iobase;
            device2300_reg_t *reg2300   = ha->iobase2300;
            uint8_t      status = 0;
            uint32_t     cnt;
            uint16_t     *optr, *iptr;
            uint16_t     data, command, intreq;
            srb_t        *done_q_first = 0;
            srb_t        *done_q_last = 0;
            uint32_t     longdata = 0;

#ifdef QL_DEBUG_LEVEL_3
            ENTER("qla2100_mailbox_command");
#endif

            /* Acquire interrupt specific lock */
            QLA2100_INTR_LOCK(ha);

            DRIVER_LOCK
            ha->flags.mbox_busy = TRUE;

#ifdef QL_DEBUG_LEVEL_5
            sprintf(debug_buff,"scsi%d ",(int)ha->host_no);
            qla2100_print(debug_buff);
            qla2100_print("qla2100_mailbox_command: [[Start]] mbox_out[0] = ");
            qla2100_output_number((u_long)*mb, 16);
            qla2100_print("\n");  
#endif
            /* Load mailbox registers. */
            if (ha->device_id != QLA2300_DEVICE_ID) 
                optr = (uint16_t *)&reg->mailbox0;
            else
                optr = (uint16_t *)&reg2300->mailbox0;

#ifdef QL_DEBUG_LEVEL_5
            qla2100_print(
            "qla2100_mailbox_command: Load MB word registers (displayed in bytes) = \n");
            qla2100_dump_buffer((uint8_t *)mb, 16);
            qla2100_print("\n");
            qla2100_dump_buffer(((uint8_t *)mb + 0x10), 16);
            qla2100_print("\n");
            qla2100_dump_buffer(((uint8_t *)mb + 0x20), 8);
            qla2100_print("\n");
            qla2100_print("qla2100_mailbox_command: I/O address = ");
            qla2100_output_number((u_long)optr, 16);
            qla2100_print("\n");
#endif
            iptr = mb;
            command = *(mb);
            for( cnt = 0; cnt < MAILBOX_REGISTER_COUNT; cnt++ ) {
                if( mr & BIT_0 ) {
                    WRT_REG_WORD(optr, (*iptr));
                }
                mr >>= 1;
                optr++;
                iptr++;
            }
#ifdef QL_DEBUG_LEVEL_5
            qla2100_dump_regs(ha->host);
#endif

            /* Issue set host interrupt command. */
            ha->flags.mbox_int = FALSE;
            WRT_REG_WORD(&reg->host_cmd, HC_SET_HOST_INT);

            /* Wait for 30 seconds for command to finish.  */
            if (ha->device_id == QLA2300_DEVICE_ID) 
               data = qla2100_debounce_register((uint16_t *)&reg2300->host_status);
            else data = qla2100_debounce_register(&reg->istatus);

            cnt = 0x100000*2;   /* 22 secs */

            for( ; cnt > 0 && !ha->flags.mbox_int; cnt-- ) {
                /* Check for pending interrupts. */
                if (ha->device_id == QLA2300_DEVICE_ID) {
                   switch (*mb) { 
                     case MBC_LOAD_RAM:
                     case MBC_EXECUTE_FIRMWARE:
                     case MBC_MAILBOX_REGISTER_TEST:
                     case MBC_VERIFY_CHECKSUM:
                     case MBC_ABOUT_FIRMWARE:
                       /* handle ROM commands the old way */
                       data     = RD_REG_WORD(&reg->istatus);
                       intreq   = data & RISC_INT;
                       break;
                     default:
                       /* handle non-ROM commands the new way */
                       data     = RD_REG_WORD(&reg->istatus);
                       longdata = RD_REG_DWORD(&reg2300->host_status);
                       intreq   = longdata & RISC_2300_INT;
                       break;
                   }
                } else {
                   /* QLA2100 or QLA2200 */
                   data     = RD_REG_WORD(&reg->istatus);
                   intreq   = data & RISC_INT;
                }
                if ( intreq != 0 ) {
                   qla2100_isr(ha,
                              (srb_t **)&done_q_first,
                              (srb_t **)&done_q_last); 
                	/* udelay(10); */
                }
                udelay(10); /* v4.27 */
            } /* for */

            /* Check for mailbox command timeout. */
            if( !cnt ) {
#ifdef QL_DEBUG_LEVEL_2
                qla2100_print(
                "qla2100_mailbox_command: **** MB Command Timeout for cmd = ");
                qla2100_output_number((u_long)mb[0], 16);
                qla2100_print(" ****\n");
                qla2100_print(
                "qla2100_mailbox_command: **** icontrol = ");
                qla2100_output_number(RD_REG_WORD(&reg->ictrl), 16);
                qla2100_print(" ****\n");
                qla2100_print(
                "qla2100_mailbox_command: **** istatus = ");
                qla2100_output_number((u_long)data, 16);
                qla2100_print(" ****\n");
                qla2100_print(
                "qla2100_mailbox_command: **** chip mailbox[0] = ");
                qla2100_output_number((u_long)RD_REG_WORD(optr), 16);
                qla2100_print(" ****\n");
                qla2100_dump_regs(ha->host);
#endif
                ha->flags.isp_abort_needed = TRUE;
                qla2100_stats.mboxtout++;
                status = 1;
            } else if( ha->mailbox_out[0] != MBS_CMD_CMP ) {
                qla2100_stats.mboxerr++;
                status = 1;
            }

            /* Load return mailbox registers. */
            optr = mb;
            iptr = (uint16_t *)&ha->mailbox_out[0];

            mr = MAILBOX_REGISTER_COUNT;
            while( mr-- )
                *optr++ = *iptr++;

            /* Go check for any response interrupts pending. */
            ha->flags.mbox_busy = FALSE;

            qla2100_isr(ha,(srb_t **)&done_q_first,(srb_t **)&done_q_last); 

            /* Release interrupt specific lock */
            QLA2100_INTR_UNLOCK(ha);
            DRIVER_UNLOCK

            if( ha->flags.isp_abort_needed )
                qla2100_abort_isp(ha);

            if( ha->flags.reset_marker )
                qla2100_rst_aen(ha);
            if( ha->flags.update_config_needed )
                qla2100_update_config(ha);
            if( ha->flags.loop_resync_needed )
                qla2100_loop_resync(ha);

            if( done_q_first )
                qla2100_done(ha, (srb_t **)&done_q_first, (srb_t **)&done_q_last);

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
        if( status ) {
            qla2100_print("qla2100_mailbox_command: **** FAILED, mailbox0 = ");
            qla2100_output_number((u_long)mb[0], 16);
            qla2100_print(" ****\n");
        } else {
/* DEBUG(qla2100_print("qla2100_mbc: Completed OK operation=");)
DEBUG(qla2100_output_number((u_long)command, 16);)
DEBUG(qla2100_print(" \n");)
DEBUG(qla2100_print("qla2100_mbc: mailbox[1]=");)
DEBUG(qla2100_output_number((u_long)mb[1], 16);)
DEBUG(qla2100_print(" \n");)
DEBUG(qla2100_print("mbc: +++ rsp_q_in= ");)
DEBUG(qla2100_output_number(RD_REG_WORD(&ha->iobase2300->rsp_q_in), 16);)
DEBUG(qla2100_print(" +++ \n");)
DEBUG(qla2100_print("mbc: +++ rsp_q_out= ");)
DEBUG(qla2100_output_number(RD_REG_WORD(&ha->iobase2300->rsp_q_out), 16);)
DEBUG(qla2100_print(" +++ \n\n");)
DEBUG(printk("qla2100_mbc: Completed OK operation=%x\n\n",command);) */
        }
#endif
#ifdef QL_DEBUG_LEVEL_3
                LEAVE("qla2100_mailbox_command");
#endif
            return(status);
        }


        /*
        * qla2100_poll
        *      Polls ISP for interrupts.
        *
        * Input:
        *      ha = adapter block pointer.
        */
        STATIC void
        qla2100_poll(scsi_qla_host_t *ha) {
            device_reg_t     *reg       = ha->iobase;
            device2300_reg_t *reg2300   = ha->iobase2300;
            uint16_t     data;
            srb_t        *done_q_first = 0;
            srb_t        *done_q_last = 0;

#ifdef QL_DEBUG_LEVEL_3
            ENTER("qla2100_poll");
#endif

            /* Acquire interrupt specific lock */
            QLA2100_INTR_LOCK(ha);

            /* Check for pending interrupts. */
            if (ha->device_id == QLA2300_DEVICE_ID) 
              data = qla2100_debounce_register((uint16_t *)&reg2300->host_status) &
                     RISC_2300_INT;
            else data = qla2100_debounce_register(&reg->istatus) & 
                         RISC_INT;

            /* Check for pending interrupts. */
            if( data ) {
                DEBUG(qla2100_print("qla2100_poll: Calling isr\n");)
                qla2100_isr(ha, 
                           (srb_t **)&done_q_first,
                           (srb_t **)&done_q_last);
            }

            /* Release interrupt specific lock */
            QLA2100_INTR_UNLOCK(ha);

            if( !ha->flags.mbox_busy ) {
                if( ha->flags.isp_abort_needed )
                    qla2100_abort_isp(ha);
                if( ha->flags.reset_marker )
                    qla2100_rst_aen(ha);
                if( ha->flags.update_config_needed )
                    qla2100_update_config(ha);
                if( ha->flags.loop_resync_needed )
                    qla2100_loop_resync(ha);
            }

            if( done_q_first )
                qla2100_done(ha, (srb_t **)&done_q_first, (srb_t **)&done_q_last);

#ifdef QL_DEBUG_LEVEL_3
            LEAVE("qla2100_poll");
#endif
        }
        
        /*
        * qla2100_find_host
        *      This routine searches the host adapter database 
        *      and return either TRUE or FALSE.
        *
        * Input:
        *      ha = adapter block pointer.
        *      device = device data pointer.
        *
        * Returns:
        *    TRUE - found
        */
        STATIC uint8_t
        qla2100_find_host(scsi_qla_host_t *ha, device_data_t *device) {
            uint16_t cnt;
        
            for( cnt = 0; cnt < ha->host_db_ptr; cnt++ ) {
                /* if nodename/portname in database */
#if  USE_PORTNAME
                if( device->ls_wwn == ha->host_db[cnt].name[0] &&
                device->ms_wwn == ha->host_db[cnt].name[1] ) {
#else
                    if( device->ls_name == ha->host_db[cnt].name[0] &&
                    device->ms_name == ha->host_db[cnt].name[1] ) {
#endif
                    return TRUE;
                    }
            }
            return FALSE;
        }
        
        /*
        * qla2100_update_host_data
        *      This routine updates the host device database 
        *
        * Input:
        *      ha = adapter block pointer.
        *      device = device data pointer.
        *
        * Returns:
        *      0 = success, if device found or added to database.
        *      1 = error
        *      2 = database was full and device was not configured.
        */
        STATIC uint8_t
        qla2100_update_host_data(scsi_qla_host_t *ha, device_data_t *device, uint8_t enable_slot_reuse) {
            uint8_t     status = 0;
            uint16_t index;

#ifdef QL_DEBUG_LEVEL_3
            ENTER("qla2100_update_host");
#endif
                
            index = ha->host_db_ptr;
            if (index != MAX_HOST_COUNT) {
               index++;
#if  USE_PORTNAME
               ha->host_db[index].name[0] = device->ls_wwn;
               ha->host_db[index].name[1] = device->ms_wwn;
#else
               ha->host_db[index].name[0] = device->ls_name;
               ha->host_db[index].name[1] = device->ms_name;
#endif
            } else if ( enable_slot_reuse ) {
               index = 0;
               printk(KERN_INFO "qla2100_update_host: Host table Full.");
#if  USE_PORTNAME
               ha->host_db[index].name[0] = device->ls_wwn;
               ha->host_db[index].name[1] = device->ms_wwn;
#else
               ha->host_db[index].name[0] = device->ls_name;
               ha->host_db[index].name[1] = device->ms_name;
#endif
            } else {
               printk(KERN_INFO "qla2100_update_host: Host table Full.");
               status = 2;
            }
            ha->host_db_ptr = index;

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                if( status )
                    qla2100_print("qla2100_update_host: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
                else
                    LEAVE("qla2100_update_host");
#endif
                return(status);

        }

        /*
        * qla2100_update_device_data
        *      This routine updates the device data in the database and logs
        *      onto the device if necessary.
        *
        * Input:
        *      ha = adapter block pointer.
        *      device = device data pointer.
        *
        * Returns:
        *      0 = success, if device found or added to database.
        *      1 = error
        *      2 = database was full and device was not configured.
        */
        STATIC uint8_t
        qla2100_update_device_data(scsi_qla_host_t *ha, device_data_t *device, uint8_t enable_slot_reuse) {
            uint8_t     status = 0;
            uint8_t     hostflag = 0;
            uint8_t     dev_configured;
            uint16_t    cnt, i;
            uint16_t    mb[MAILBOX_REGISTER_COUNT];

#ifdef QL_DEBUG_LEVEL_3
            ENTER("qla2100_update_device");
#endif

            dev_configured = FALSE;
            if( ha->device_id == QLA2100_DEVICE_ID ) {
                ha->min_external_loopid = 1;       /* v2.19.5b3 */
                ha->max_public_loop_ids = LAST_SNS_LOOP_ID - SNS_FIRST_LOOP_ID + 1;
            } else {
                ha->max_public_loop_ids = LAST_SNS_LOOP_ID + 1;
            }

            DEBUG(sprintf(debug_buff,"qla2100: Found device - portname=%lx%lx, nodename=%lx%lx, port Id=%06lx, loop id=%04x\n",
            device->ms_wwn,device->ls_wwn,
            device->ms_name,device->ls_name,
            device->port_id[0] << 16 | device->port_id[1] <<  8 | device->port_id[2], device->loop_id);)
            DEBUG(qla2100_print(debug_buff);)

             /* if we already login to the host adapter then skip it */
            if ( qla2100_find_host(ha, device)  ) {
               DEBUG(printk("update_db: Skipping host adapter..\n");)
               return( status );
            }
            
            /* Search to see if node name is already in database. If found then change loop ID in database. */
            for( cnt = 0; cnt < MAX_FIBRE_DEVICES && !dev_configured; cnt++ ) {
                /* if nodename/portname in database then replace it */
#if  USE_PORTNAME  /* updated for ioctl merge */
            if( device->ls_wwn == ha->fc_db[cnt].wwn[0] &&
                device->ms_wwn == ha->fc_db[cnt].wwn[1] ) {
#else
            if( device->ls_name == ha->fc_db[cnt].name[0] &&
                device->ms_name == ha->fc_db[cnt].name[1] ) {
#endif
                        ha->fc_db[cnt].flag &= ~DEV_MISSING;
                        /* if device was configured by user then find and assign a loop ID for it */
                        if( ha->fc_db[cnt].loop_id == PORT_AVAILABLE ) {
                            DEBUG(qla2100_print("Port marked as already assigned.\n");)
                            /* If device found is on the public loop. */
                            /* then find the next available fabric loop ID */
                            if( device->loop_id == 0xffff ) {
                                status = 1;
                                /* Search the public database for first available slot.  */
                                for( i = ha->min_external_loopid; i < ha->max_public_loop_ids; i++ ) {
                                    if( !ha->fabricid[i].in_use ) {
                                        ha->fabricid[i].in_use = TRUE;
                                        if( ha->device_id == QLA2100_DEVICE_ID )
                                            device->loop_id = SNS_FIRST_LOOP_ID + i;
                                        else
                                            device->loop_id = i;
                                        ha->fc_db[cnt].loop_id = device->loop_id;
                                        ha->fc_db[cnt].port_id[0] = device->port_id[0];
                                        ha->fc_db[cnt].port_id[1] = device->port_id[1];
                                        ha->fc_db[cnt].port_id[2] = device->port_id[2];
                                        ha->fc_db[cnt].flag |= DEV_PUBLIC;
                                        status = 0;
                                        break;
                                    }
                                } /* end of for */
                            } else {  /* change the local loop ID in database */
                                ha->fc_db[cnt].loop_id = device->loop_id;
                            }
                        } else /* loop id may have been previously used */
                        {
                            /* If device is on public loop. */
                            if( device->loop_id == 0xffff ) {
                                /* It was previously public, so use previously assigned loop id. */
                                if( ha->fc_db[cnt].flag & DEV_PUBLIC )
                                    if( ha->device_id == QLA2100_DEVICE_ID )
                                        device->loop_id = ha->fc_db[cnt].loop_id;
                                    else {
                                        /* if the same topology and public loop */
                                        /* search for the next avaiable public loop ID */
                                        DEBUG(printk("update_db: topology prev %d, curr %d\n",
                                        ha->prev_topology, ha->current_topology );)
                                        if( ha->prev_topology == ha->current_topology ) {
                                            if( (ha->min_external_loopid) &&
                                            (ha->fc_db[cnt].loop_id < ha->min_external_loopid) ) {
                                                status = 1;
                                                /* find a loop ID for the Public device */
                                                for( i = ha->min_external_loopid; i < ha->max_public_loop_ids; i++ )
                                                    if( !ha->fabricid[i].in_use ) {
                                                        ha->fabricid[i].in_use = TRUE;
                                                        device->loop_id = i;
                                                        ha->fc_db[cnt].loop_id = device->loop_id;
                                                        status = 0;
                                                        break;
                                                    }
                                            } else
                                                device->loop_id = ha->fc_db[cnt].loop_id;
                                        } else {
                                            status = 1;
                                            /* Find an unused loop ID */
                                            for( i = ha->min_external_loopid; i < ha->max_public_loop_ids; i++ )
                                                if( !ha->fabricid[i].in_use ) {
                                                    ha->fabricid[i].in_use = TRUE;
                                                    device->loop_id = i;
                                                    ha->fc_db[cnt].loop_id = device->loop_id;
                                                    status = 0;
                                                    break;
                                                }
                                        }

                                    } else {
                                        /* If it moved from private to public loop, assign new public loop id. */
                                        status = 1;
                                            /* Find an unused loop ID */
                                        for( i = ha->min_external_loopid; i < ha->max_public_loop_ids; i++ )
                                            if( !ha->fabricid[i].in_use ) {
                                                ha->fabricid[i].in_use = TRUE;
                                                if( ha->device_id == QLA2100_DEVICE_ID )

                                                    device->loop_id = SNS_FIRST_LOOP_ID + i;
                                                else
                                                    device->loop_id = i;
                                                ha->fc_db[cnt].loop_id = device->loop_id;
                                                ha->fc_db[cnt].flag |= DEV_PUBLIC;
                                                ha->fc_db[cnt].port_id[0] = device->port_id[0];
                                                ha->fc_db[cnt].port_id[1] = device->port_id[1];
                                                ha->fc_db[cnt].port_id[2] = device->port_id[2];
                                                status = 0;
                                                break;
                                            }
                                    }
                            } else {
                                /* The found device is on private loop but was
                                previously on public loop, so free public loop id. */
                                if( ha->fc_db[cnt].flag & DEV_PUBLIC ) {
                                    ha->fc_db[cnt].flag &= ~DEV_PUBLIC;
                                    i = ha->fc_db[cnt].loop_id - SNS_FIRST_LOOP_ID;
                                    ha->fabricid[i].in_use = 0;
                                }
                                ha->fc_db[cnt].loop_id = device->loop_id;
                            }
                        }
                        
                        /* If public device in database */
                        if( !status && (ha->fc_db[cnt].flag) & DEV_PUBLIC ) {
                        
                            
                            /* If public loop device, compare port id to see if
                            device moves to another NL/N port. */
                            if( ha->fc_db[cnt].port_id[0] != device->port_id[0] ||
                            ha->fc_db[cnt].port_id[1] != device->port_id[1] ||
                            ha->fc_db[cnt].port_id[2] != device->port_id[2] ) {
                                if( ha->prev_topology == ha->current_topology ) {
                                    /* Port id changed, log device out then log back
                                    in with new port id but same loop id. */
                                    mb[0] = MBC_LOGOUT_FABRIC_PORT;
                                    mb[1] = ha->fc_db[cnt].loop_id << 8;
                                    qla2100_mailbox_command(ha, BIT_1|BIT_0, &mb[0]);
                                    ha->fc_db[cnt].port_id[0] = device->port_id[0];
                                    ha->fc_db[cnt].port_id[1] = device->port_id[1];
                                    ha->fc_db[cnt].port_id[2] = device->port_id[2];
                                }
                            }
                            /*
                            * Try and find a loop Id for the given
                            * fabric port. We keep trying Ids until we find
                            * a good one.
                            */
                            mb[0] = 0x4008;
                            while( !status && mb[0] == 0x4008 ) {
                                mb[0] = MBC_LOGIN_FABRIC_PORT;
                                mb[1] = device->loop_id << 8 | 0x01;
                                mb[2] = device->port_id[0];
                                mb[3] = device->port_id[1] << 8 | device->port_id[2];
                                qla2100_mailbox_command(ha, BIT_3|BIT_2|BIT_1|BIT_0,
                                &mb[0]);
                                /* Command parameter error or all IDS used */
                                if ( mb[0] == 0x4006 || mb[0] == 0x4009 ) {
                                    status = 1;
                                    DEBUG(printk("update_db: (1) Failed Fabric login with Loop ID = %d\n", device->loop_id);)
                                }
                                /*
                                * if loop Id is in use then try the next Id .
                                */
                                if( mb[0] == 0x4008 ) {
                                    DEBUG(printk("update_db: Used Loop ID = %04x, port id=%06x\n", device->loop_id,
                                    ((mb[1] << 16) | (((mb[2] >>8 ) &0xff) << 8) | (mb[2] & 0xff)));)
                                    if( device->loop_id++ <= LAST_SNS_LOOP_ID )
                                        ha->fabricid[device->loop_id].in_use = TRUE;
                                    else
                                        status = 1;
                                }
                            }
                            /* Set adapter flag */
                            if( !status && (mb[1] & 0x1) ) {     /* v2.19.05b3 */
                                DEBUG(printk("update_db: Warning -- Adapter found: port id=%06x, tgt=%d\n", 
                                    ((mb[1] << 16) | (((mb[2] >>8 ) &0xff) << 8) | (mb[2] & 0xff)),cnt);)
                                qla2100_update_host_data(ha, device, enable_slot_reuse); 
                                ha->fabricid[device->loop_id].in_use = FALSE;
                                hostflag++;
			                }
#if 0
                            /* Command error */
                            if( !status && mb[0] != 0x4005 ) {
                                /* Issue Abort target command to cause RISC to
                                flush all commands outstanding for this device.
                                Commands will be returned with "Aborted" status. */
                                mb[0] = MBC_ABORT_TARGET;
                                mb[1] = device->loop_id << 8;
                                mb[2] = 1;
                                status = qla2100_mailbox_command(ha, BIT_2|BIT_1|BIT_0, &mb[0]);
                            }
#endif
                        }
                        dev_configured = TRUE;
                    }
                }

                /* Device not already in database so find */
                /* an empty slot and loop id for it.      */
                if( !dev_configured ) {
                    DEBUG(printk("qla2100_db_update: New Device - not in database.\n");)

                    /* If device is on public loop.        */
                    /* First find an unused Fabric loop ID */
                    /* then find a slot.                   */
                    if( device->loop_id == 0xffff ) {
                        status = 1;
                        for( i = ha->min_external_loopid; i < ha->max_public_loop_ids; i++ ) {
                            if( !ha->fabricid[i].in_use ) {
                                ha->fabricid[i].in_use = TRUE;
                                if( ha->device_id == QLA2100_DEVICE_ID )
                                    device->loop_id = SNS_FIRST_LOOP_ID + i;
                                else
                                    device->loop_id = i;
                                status = 0;
                                break;
                            }
                        }
                        /* Preset status to Loop ID used */
                        mb[0] = 0x4008;
                        /* Check to insure loop ID for fabric device is good */
                        while( !status && mb[0] == 0x4008 ) {
                            DEBUG(printk("update_db: Trying Fabric Login @ loop id %d\n", device->loop_id);)
                            mb[0] = MBC_LOGIN_FABRIC_PORT;
                            mb[1] = device->loop_id << 8 | 0x01;
                            mb[2] = device->port_id[0];
                            mb[3] = device->port_id[1] << 8 | device->port_id[2];
                            qla2100_mailbox_command(ha, BIT_3|BIT_2|BIT_1|BIT_0, &mb[0]);
                            if ( mb[0] == 0x4006 || mb[0] == 0x4009 ) {
                                status = 1;
                                DEBUG(printk("update_db: (2) Failed Fabric login with Loop ID = %d\n", device->loop_id);)
                            }
                            if( mb[0] == 0x4008 ) {
                                DEBUG(printk("update_db: (2) Used Fabric Loop ID = %04x, port id=%06x\n", device->loop_id,
                                ((mb[1] << 16) | (((mb[2] >>8 ) &0xff) << 8) | (mb[2] & 0xff)));)
                                if( device->loop_id++ <= LAST_SNS_LOOP_ID ) 
                                    ha->fabricid[device->loop_id].in_use = TRUE;  /* v2.19.05b3 */
                                else
                                    status = 1;
                            }
                            if( (mb[1] & 0x1) ) {     /* v2.19.05b3 */
                               qla2100_update_host_data(ha, device, enable_slot_reuse); 
                               DEBUG(printk("update_db: Adapter found: port id=%06x\n", 
                                        (device->port_id[0] <<16) |
                                        (device->port_id[1] << 8) | (device->port_id[2])) );
                               ha->fabricid[device->loop_id].in_use = FALSE; 
                               hostflag++;
                            }
                        }
                    }
                    /* Now find an empty slot for the device */
                    if( !status && hostflag == 0 ) {
                        if( ha->device_id == QLA2100_DEVICE_ID )
                            ha->min_external_loopid = SNS_FIRST_LOOP_ID;
                        /* Find a empty slot and add device into database. */
                        for( i = 0; i < MAX_FIBRE_DEVICES; i++ )
                            if( ha->fc_db[i].loop_id == PORT_UNUSED ) {
                                ha->fc_db[i].flag &= ~DEV_MISSING;
                        /* get and set both wwnn and wwpn */
                        ha->fc_db[i].name[0] = device->ls_name;
                        ha->fc_db[i].name[1] = device->ms_name;
                        ha->fc_db[i].wwn[0]  = device->ls_wwn;
                        ha->fc_db[i].wwn[1]  = device->ms_wwn;

                                ha->fc_db[i].loop_id = device->loop_id;
                                if( device->loop_id >= ha->min_external_loopid ) {
                                    ha->fc_db[i].flag |= DEV_PUBLIC;
                                    ha->fc_db[i].port_id[0] = device->port_id[0];
                                    ha->fc_db[i].port_id[1] = device->port_id[1];
                                    ha->fc_db[i].port_id[2] = device->port_id[2];
                                }
                                ha->flags.updated_fc_db = TRUE;
                                dev_configured = TRUE;
                                break;
                            }
                            if( !dev_configured ) {
                                if( enable_slot_reuse ) {
                                    for( i = 0; i < MAX_FIBRE_DEVICES; i++ )
                                        if( ha->fc_db[i].loop_id == PORT_AVAILABLE ) {
                                            ha->fc_db[i].flag &= ~DEV_MISSING;
#if  USE_PORTNAME  /* ioctl support change */
                                            ha->fc_db[i].wwn[0] = device->ls_wwn;
                                            ha->fc_db[i].wwn[1] = device->ms_wwn;
#else
                                            ha->fc_db[i].name[0] = device->ls_name;
                                            ha->fc_db[i].name[1] = device->ms_name;
#endif
                                            ha->fc_db[i].loop_id = device->loop_id;
                                            if( device->loop_id >= ha->min_external_loopid ) {
                                                ha->fc_db[i].flag |= DEV_PUBLIC;
                                                ha->fc_db[i].port_id[0] = device->port_id[0];
                                                ha->fc_db[i].port_id[1] = device->port_id[1];
                                                ha->fc_db[i].port_id[2] = device->port_id[2];
                                            }
                                            ha->flags.updated_fc_db = TRUE;
                                            break;
                                        }
                                } else {
                                    ha->fabricid[device->loop_id].in_use = FALSE;
                                    status = 2;
                                }

                            }

                    }
                }
#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                if( status )
                    qla2100_print("qla2100_update_device: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
                else
                    LEAVE("qla2100_update_device");
#endif
                return(status);
            }

            /*
            * qla2100_sns_device
            *      Setup Simple Name Server devices with loop ID's.
            *
            * Input:
            *      ha = adapter block pointer.
            *
            * Returns:
            *      0 = success.
            *      1 = error
            *      2 = database was full and device was not configured.
            */
            STATIC uint8_t
            qla2100_sns_device(scsi_qla_host_t *ha, uint8_t enable_slot_reuse) {
                uint8_t     status = 1;
                uint8_t     first_port_id[3];
                uint8_t     next_port_id[3];
                uint8_t     host_port_id[3];
                sns_data_t  *sns;
#if BITS_PER_LONG > 32
                uint64_t    phys_address = 0;
#else
                uint32_t    phys_address = 0;
#endif
                uint16_t    mb[MAILBOX_REGISTER_COUNT];
                uint8_t     use_gan = 1;
                uint8_t     retry_count = 0;
                gp_idnn_t   *gp_idnn;
                uint16_t    i;
                device_data_t device;
                uint8_t     db_full = 0;
                uint16_t    public_count;
                uint32_t    fabric_devices = 0;

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_sns_device");
#endif

                /* If FL port exists, then SNS is present */
                DEBUG(printk("qla2100_sns_device: Checking for Fabric.\n");)
                mb[0] = MBC_GET_PORT_NAME;
                mb[1] = SNS_FL_PORT << 8;  /* port name */
                if( !qla2100_mailbox_command(ha, BIT_1|BIT_0, &mb[0]) ) {

#ifdef RCSN
                    /* Mark devices that need re-synchronization. */
                    qla2100_device_resync(ha);
#endif

                    /* Fl port is present */
                    host_port_id[0] = ha->port_id[0];
                    host_port_id[1] = ha->port_id[1];
                    host_port_id[2] = ha->port_id[2];

                    /* Calculate the max number of public ports */
                    if( ha->device_id == QLA2100_DEVICE_ID )
                        public_count = ha->max_public_loop_ids;
                    else
                        public_count = ha->max_public_loop_ids - ha->min_external_loopid;

                    /* Register with name server as type fc4 device */

#ifdef FC_IP_SUPPORT
                    /* Register with name server as type 5 device */
                    if (ha->flags.enable_ip == TRUE) {
                        qla2x00_register_ip_device(ha);
                    }

                    /* If IP enable, skip GP_IDNN and just use GAN */
                    if (ha->flags.enable_ip == TRUE)
                        goto tryGan;
#endif /* FC_IP_SUPPORT */

                    /* Find out if this is a Brocade switch, if so do GP_IDNN. */
                    /* otherwise use the GAN                                   */
                    mb[0] = MBC_GET_PORT_NAME;
                    mb[1] = SNS_FL_PORT << 8 | BIT_0;   /* node name */
                    qla2100_mailbox_command(ha, BIT_1|BIT_0, &mb[0]);
                    if( mb[2] == 0x0010 && mb[3] == 0x6000 &&
                    (mb[6] & 0x00FF) == 0x0069 ) {
/* 4.10 */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
                        gp_idnn = KMALLOC(GP_IDNN_LENGTH);
                        if ( gp_idnn != NULL ) {
                            phys_address = VIRT_TO_BUS(gp_idnn);
                            BZERO((caddr_t)gp_idnn, GP_IDNN_LENGTH);
                        }
#else
                        gp_idnn  = pci_alloc_consistent(ha->pdev,
                                                        GP_IDNN_LENGTH,
                                                        &phys_address);
                        BZERO((caddr_t)gp_idnn, GP_IDNN_LENGTH);
#endif
                        if ( gp_idnn != NULL ) {
                            /* Retry GP_IDNN til valid list or retries done */
                            while( retry_count++ < 10 ) {
                                /*
                                * Issue GP_IDNN to get list of port IDs and
                                * node names from name server.
                                */
                                gp_idnn->req.buffer_length = GP_IDNN_LENGTH/2;
                                /* 4.10 */
                                gp_idnn->req.buffer_address[0] = 
                                  LS_64BITS(phys_address);
                                gp_idnn->req.buffer_address[1] = 
                                  MS_64BITS(phys_address);
                                gp_idnn->req.subcommand_length = 6;
                                gp_idnn->req.subcommand = 0x173;
                                gp_idnn->req.length = GP_IDNN_LENGTH / 4;
                                gp_idnn->req.protocol = 0x08;

                                mb[0] = MBC_SEND_SNS_COMMAND;
                                mb[1] = 14;
                                mb[3] = LSW(phys_address);
                                mb[2] = MSW(phys_address);
                                mb[7] = QL21_64BITS_3RDWD(phys_address);
                                mb[6] = QL21_64BITS_4THWD(phys_address);
                                if( !qla2100_mailbox_command(ha,
                                BIT_7|BIT_6|BIT_3|BIT_2|BIT_1|BIT_0,
                                &mb[0]) ) {
                                    if( gp_idnn->rsp.response == SNS_ACCEPT ) {
                                        DEBUG3(printk("Sns: Get all Fabric devices:\n");)
                                        /* Go down device list and add devices to database. */
                                        for( i = 0; i < public_count; i++ ) {
                                            /* if not host port id then add it to the database */
                                            if( gp_idnn->rsp.port_data[i].port_id[0] != host_port_id[0] ||
                                            gp_idnn->rsp.port_data[i].port_id[1] != host_port_id[1] ||
                                            gp_idnn->rsp.port_data[i].port_id[2] != host_port_id[2] ) {
                                                device.ms_name = gp_idnn->rsp.port_data[i].nodename[0] << 24
                                                | gp_idnn->rsp.port_data[i].nodename[1] << 16
                                                | gp_idnn->rsp.port_data[i].nodename[2] << 8
                                                | gp_idnn->rsp.port_data[i].nodename[3];
                                                device.ls_name = gp_idnn->rsp.port_data[i].nodename[4] << 24
                                                | gp_idnn->rsp.port_data[i].nodename[5] << 16
                                                | gp_idnn->rsp.port_data[i].nodename[6] << 8
                                                | gp_idnn->rsp.port_data[i].nodename[7];
                                                /* get loop id */
                                                device.port_id[0] = gp_idnn->rsp.port_data[i].port_id[0];
                                                device.port_id[1] = gp_idnn->rsp.port_data[i].port_id[1];
                                                device.port_id[2] = gp_idnn->rsp.port_data[i].port_id[2];
#if USE_PORTNAME
                                                /* Get portname */
                                                if( qla2100_sns_get_name(ha, &device, 0) ) {
                                                    status =  1;  /* v2.19.5b4 */
                                                    break;
						}
#endif
                                                device.loop_id = 0xffff;
                                                /* Update device database and login to device. */
                                                fabric_devices++;
                                                if( (status = qla2100_update_device_data(ha, &device, enable_slot_reuse)) ) {
                                                    if( status == 2 )
                                                        db_full = 1;
                                                    else
                                                        break;
                                                }
                                            }
                                            if( gp_idnn->rsp.port_data[i].controlbyte == 0x80 )
                                                break;
                                        }
                                        use_gan = 0;
                                        break;
                                    }
                                }
                                /* Wait for 100ms before retrying */
                                for( i = 0; i <= 10000; i++ ) {
                                    udelay(10);
                                }
                            }
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
                            KMFREE(gp_idnn, GP_IDNN_LENGTH);
#else
                            pci_free_consistent(ha->pdev, GP_IDNN_LENGTH,
                                   gp_idnn, phys_address);
#endif
                        } else {
                            use_gan = 0;
#ifdef QL_DEBUG_LEVEL_2
                            qla2100_print(
                            "qla2100_sns_device: Failed to allocate memory, No FL Port\n");
#endif
                        }
                    }
                    /* Use the GAN (GA_NXT) Name server request to discover the ports  */

                    /*
                    *	Go through GAN list to find all fabric devices.  Will perform
                    *	necessary logout of previously existed devices that have changed
                    *	and save new devices in a new device list.
                    *
                    */

                    if( use_gan ) {
#ifdef FC_IP_SUPPORT
                        tryGan:
#endif

                        /* Find all registered ports in the Fabric */
/* 4.10 */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
                        sns = KMALLOC(sizeof(sns_data_t));
                        if ( sns != NULL ) {
                            phys_address = VIRT_TO_BUS(sns);
                            BZERO((caddr_t)sns, sizeof(sns_data_t));
                        }
#else
                        sns  = pci_alloc_consistent(ha->pdev,
                                                    sizeof(sns_data_t),
                                                    &phys_address);
                        BZERO((caddr_t)sns, sizeof(sns_data_t));
#endif
                        if ( sns != NULL ) {
                            DEBUG(printk("qla2100_sns_device: Performing a GAN (%d)\n",public_count);)
                            status = 0;
                            /* start with port ID = 0 */
                            first_port_id[0] = first_port_id[1] = first_port_id[2] = 0;
                            next_port_id[0] = next_port_id[1] = next_port_id[2] = 0;
                            mb[0] = 0;
                            for( i = 0; i < public_count && !ha->loop_down_timer &&
                            !ha->flags.loop_resync_needed; i++ ) {
                                /* GAN Get all next entries for the selected port ID from SNS. */
                                BZERO((caddr_t)sns, sizeof(sns_data_t));
                                sns->p.req.hdr.buffer_length = 318; /*304*/
                                sns->p.req.hdr.buffer_address[0] = 
                                    LS_64BITS(phys_address);
                                sns->p.req.hdr.buffer_address[1] = 
                                    MS_64BITS(phys_address);
                                sns->p.req.hdr.subcommand_length = 6;
                                sns->p.req.subcommand = 0x100;
                                sns->p.req.param[6] = next_port_id[2];
                                sns->p.req.param[7] = next_port_id[1];
                                sns->p.req.param[8] = next_port_id[0];

                                mb[0] = MBC_SEND_SNS_COMMAND;
                                mb[1] = 14;
                                mb[3] = LSW(phys_address);
                                mb[2] = MSW(phys_address);
                                mb[7] = QL21_64BITS_3RDWD(phys_address);
                                mb[6] = QL21_64BITS_4THWD(phys_address);
                                if( !qla2100_mailbox_command(ha,
                                     BIT_7|BIT_6|BIT_3|BIT_2|BIT_1|BIT_0,
                                     &mb[0])  ) {
                                    if( sns->p.rsp[8] != 0x80 ||  /* SNS_ACCEPT */
                                        sns->p.rsp[9] != 0x02   ) { /* 04/18/00 */
                                    printk("qla2100_sns_device: SEND_SNS_COMMAND Failed - 0x%2x%2x mb_res=%x\n",
                                            sns->p.rsp[8],sns->p.rsp[9],mb[0]);
                                       status = 1;
                                       break;
                                    }
                                    /* save next port ID */
                                    next_port_id[0] = sns->p.rsp[17];
                                    next_port_id[1] = sns->p.rsp[18];
                                    next_port_id[2] = sns->p.rsp[19];

                                } else {
#ifdef QL_DEBUG_LEVEL_2
                                    qla2100_print(
                                    "qla2100_sns_device: MBC_SEND_SNS_COMMAND Failed, No FL Port\n");
#endif
                                    /* v2.19.5 */
                            	   DEBUG(printk("qla2100_sns_device: Failed Performing a GAN mb0=0x%x, mb1=0x%x\n",
                                         mb[0],mb[1]);)
                                    status = 1;
                                    break;
                                }

                                /* Assign loop ID for device on SNS. */
                                if( (next_port_id[0] != first_port_id[0] ||
                                next_port_id[1] != first_port_id[1] ||
                                next_port_id[2] != first_port_id[2])
                                &&  (sns->p.rsp[284] || sns->p.rsp[285] ||
                                sns->p.rsp[286] || sns->p.rsp[287] ||
                                sns->p.rsp[288] || sns->p.rsp[289] ||
                                sns->p.rsp[290] || sns->p.rsp[291]) ) {
                                    /* if port Id local loop skip this ID  */
                                    if( next_port_id[0] != host_port_id[0] ||
                                    next_port_id[1] != host_port_id[1] ||
                                    next_port_id[2] != host_port_id[2] ) {
#if USE_PORTNAME
                                        /* Extract portname */
                                        device.ms_wwn = sns->p.rsp[20] << 24
                                        | sns->p.rsp[21] << 16
                                        | sns->p.rsp[22] << 8
                                        | sns->p.rsp[23];
                                        device.ls_wwn = sns->p.rsp[24] << 24
                                        | sns->p.rsp[25] << 16
                                        | sns->p.rsp[26] << 8
                                        | sns->p.rsp[27];
#endif
                                        /* Extract nodename */
                                        device.ms_name = sns->p.rsp[284] << 24
                                        | sns->p.rsp[285] << 16
                                        | sns->p.rsp[286] << 8
                                        | sns->p.rsp[287];
                                        device.ls_name = sns->p.rsp[288] << 24
                                        | sns->p.rsp[289] << 16
                                        | sns->p.rsp[290] << 8
                                        | sns->p.rsp[291];
                                        /* extract port ID */
                                        device.port_id[0] = next_port_id[0];
                                        device.port_id[1] = next_port_id[1];
                                        device.port_id[2] = next_port_id[2];
                                        device.loop_id = 0xffff;

                                        /* Update device database and login device in */

                                        /* if McData, skip all port types except 1 (N_port) & 2 (NL_port) */
                                        if ( !( (sns->p.rsp[16] == 0x01) ||
                                        (sns->p.rsp[16] == 0x02)    ) ) {
                                            DEBUG(printk("qla2100_sns_device: Skipping port type %x\n", sns->p.rsp[16]);)
                                        }

#ifdef FC_IP_SUPPORT
                                        else if (sns->p.rsp[579] & 0x20) {
                                            fabric_devices++;
                                            /* Update IP device */
                                            if (qla2x00_update_ip_device_data(ha, &device) == QL_STATUS_FATAL_ERROR) {
                                                status = 1;
                                                break;
                                            }
                                            /* Update SCSI device */
                                        }
#endif
                                        else {
                                            fabric_devices++;
                                            if( (status = qla2100_update_device_data(ha, &device, enable_slot_reuse)) ) {
                                                if( status == 2 )
                                                    db_full = 1;
                                                break;
                                            }
                                        }
#ifdef FC_IP_SUPPORT
                                    }
#endif
                                }

                                /*
                                * Save first port if not repeating port
                                * on another Loop ID.
                                */
                                if( !(first_port_id[0] || first_port_id[1] ||
                                first_port_id[2]) ) {
                                    first_port_id[0] = next_port_id[0];
                                    first_port_id[1] = next_port_id[1];
                                    first_port_id[2] = next_port_id[2];
                                }
                            } else
                                break;
                        }
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
                        KMFREE(sns, sizeof(sns_data_t));
#else
                        pci_free_consistent(ha->pdev, sizeof(sns_data_t),
                                   sns, phys_address);
#endif

                    }
#ifdef QL_DEBUG_LEVEL_2
                    else
                        qla2100_print(
                        "qla2100_sns_device: Failed to allocate memory, No FL Port\n");
#endif
                }
            } else
#ifdef QL_DEBUG_LEVEL_2
                qla2100_print(
                "qla2100_sns_device: MBC_GET_PORT_NAME Failed, No FL Port\n");
#else
            DEBUG(printk("No Fabric found.\n");)
#endif

            if( fabric_devices >  0)
              ha->device_flags |= DFLG_FABRIC_DEVICES;

            if( db_full )
                status = 2;

            /* Update iff F/FL found and update O.K. */
            if( !status )
                ha->prev_topology = ha->current_topology;

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
            if( status )
                qla2100_print("qla2100_sns_device: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
            else
                LEAVE("qla2100_sns_device");
#endif
            return(status);
        }

#if USE_PORTNAME
        /*
        * qla2100_sns_get_name
        *      This routine is called tot do the SNS Get Port/Name command
        *      of the specified port.
        *
        * Input:
        *      ha = adapter block pointer.
        *      flag = 0 - port name , 1 - node name
        *
        * Output:
        *
        */
        STATIC uint8_t qla2100_sns_get_name( scsi_qla_host_t *ha, device_data_t *device, uint8_t flag ) {
            uint8_t     lStatus = 0;
            uint16_t    wRetryCount;
#if BITS_PER_LONG > 32
            uint64_t    phys_address = 0;
#else
            uint32_t    phys_address = 0;
#endif
            uint16_t    mb[MAILBOX_REGISTER_COUNT];
            uint16_t    subCmd, response;
            sns_data_t  *sns;

            /* Set retry count */
            if ( flag )
                subCmd = 0x113;
            else
                subCmd = 0x112;
            DEBUG2(printk("qla2100_SnsGetName: Get opcode %x - name for port Id %06x\n", subCmd,
            (uint32_t)(device->port_id[0] << 16 | device->port_id[1] <<  8 | device->port_id[2]));)

            wRetryCount = 2;
            while (wRetryCount--) {
                /* Do 'Get Port/Node name' mailbox command for the FL attached device */
/* 4.10 */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
                sns = KMALLOC(sizeof(sns_data_t));
                if ( sns != NULL ) {
                     phys_address = VIRT_TO_BUS(sns);
                     BZERO((caddr_t)sns, sizeof(sns_data_t));
                }
#else
                sns  = pci_alloc_consistent(ha->pdev,
                                            sizeof(sns_data_t),
                                            &phys_address);
                BZERO((caddr_t)sns, sizeof(sns_data_t));
#endif
                if ( sns != NULL ) {
                    BZERO((caddr_t)sns, sizeof(sns_data_t));
                    sns->p.req.hdr.buffer_length = 12;
                    /* 4.10 */
                    sns->p.req.hdr.buffer_address[0] = 
                       LS_64BITS(phys_address);
                    sns->p.req.hdr.buffer_address[1] = 
                       MS_64BITS(phys_address);
                    sns->p.req.hdr.subcommand_length = 6;
                    sns->p.req.subcommand = subCmd;
                    sns->p.req.param[6] = device->port_id[2];
                    sns->p.req.param[7] = device->port_id[1];
                    sns->p.req.param[8] = device->port_id[0];
                    sns->p.req.param[9] = 0;

                    mb[0] = MBC_SEND_SNS_COMMAND;
                    mb[1] = 14;
                    mb[3] = LSW(phys_address);
                    mb[2] = MSW(phys_address);
                    mb[7] = QL21_64BITS_3RDWD(phys_address);
                    mb[6] = QL21_64BITS_4THWD(phys_address);
                    if( !qla2100_mailbox_command(ha,
                    BIT_7|BIT_6|BIT_3|BIT_2|BIT_1|BIT_0,
                    &mb[0]) ) {

                        response = sns->p.rsp[8] | (sns->p.rsp[9] << 8);
                        if( response == SNS_ACCEPT ) {
                            if ( flag ) {
                                device->ms_name = sns->p.rsp[16] << 24
                                | sns->p.rsp[17] << 16
                                | sns->p.rsp[18] << 8
                                | sns->p.rsp[19];
                                device->ls_name = sns->p.rsp[20] << 24
                                | sns->p.rsp[21] << 16
                                | sns->p.rsp[22] << 8
                                | sns->p.rsp[23];
                            } else {
                                device->ms_wwn = sns->p.rsp[16] << 24
                                | sns->p.rsp[17] << 16
                                | sns->p.rsp[18] << 8
                                | sns->p.rsp[19];
                                device->ls_wwn = sns->p.rsp[20] << 24
                                | sns->p.rsp[21] << 16
                                | sns->p.rsp[22] << 8
                                | sns->p.rsp[23];

                            }
                        } else {
                            printk("qla2100_SnsGetName: Get Name mb cmd response is not accept - status %x\n", mb[0]);
                        }
                    } else if (mb[0] == MBS_FATAL_ERROR) {
                        printk("qla2100_SnsGetName: Get Name mb cmd fatal error - status %x\n", mb[0]);
                        lStatus = 1;
                        break;
                    } else {
                        printk("qla2100_SnsGetName: Get Name mb cmd failed - status %x\n", mb[0]);
                    }

                }
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
                KMFREE(sns, sizeof(sns_data_t));
#else
                pci_free_consistent(ha->pdev, sizeof(sns_data_t),
                                    sns, phys_address);
#endif
            }
            return(lStatus);

        }
#endif

        /*
        * qla2100_init_fc_db
        *      Initializes Fibre Channel Device Database.
        *
        * Input:
        *      ha = adapter block pointer.
        *
        * Output:
        *      ha->fc_db = initialized
        */
        STATIC void
        qla2100_init_fc_db(scsi_qla_host_t *ha) {
            uint16_t cnt;

#ifdef QL_DEBUG_LEVEL_3
            ENTER("qla2100_init_fc_db");
#endif

            /* Initialize fc database if it is not initialized. */
            if( !ha->fc_db[0].loop_id && !ha->fc_db[1].loop_id ) {
                ha->flags.updated_fc_db = FALSE;

                /* Initialize target database. */
                for( cnt = 0; cnt < MAX_FIBRE_DEVICES; cnt++ ) {
                    ha->fc_db[cnt].name[0] = 0L;
                    ha->fc_db[cnt].name[1] = 0L;
                    ha->fc_db[cnt].loop_id = PORT_UNUSED;
                    ha->fc_db[cnt].port_login_retry_count = 8;
                    ha->fc_db[cnt].flag = 0;   /* v2.19.5b3 */
                    ha->fc_db[cnt].port_timer = 0;   /* v2.19.8 */
                }

#if USE_FLASH
                /* Move flash database to driver database. */
                qla2100_get_database(ha);
#endif
            }

#ifdef QL_DEBUG_LEVEL_3
            LEAVE("qla2100_init_fc_db");
#endif
        }

        /*
        * qla2100_configure_fabric
        *	Setup fabric devices with loop ID's.
        *
        * Input:
        *	ha = adapter block pointer.
        *	enable_slot_reuse = allows the use of PORT_AVAILABLE slots.
        *
        * Returns:
        *	0 = success.
        *	1 = error.
        *	2 = database was full and a device was not configured.
        *
        * Context:
        *	Kernel context.
        */
        STATIC uint8_t
        qla2100_configure_fabric(scsi_qla_host_t *ha, 
				uint8_t enable_slot_reuse){ 
            uint8_t  status = 0;
            uint16_t    i;

            /* get public loop devices */
            if( !ha->loop_down_timer && !ha->flags.loop_resync_needed ){
               /* Configure loop */
               if( !qla2100_configure_hba(ha) ) {
                   if( ha->device_id == QLA2100_DEVICE_ID ) {
                       ha->max_public_loop_ids = LAST_SNS_LOOP_ID - SNS_FIRST_LOOP_ID + 1;
                   } else {
                       ha->max_public_loop_ids = LAST_SNS_LOOP_ID + 1;
                        /* dg 09/15 */
                        /* if the topology have change then make all devices available */
                        if( ha->prev_topology != ha->current_topology ) {
                            /* Mark all fabric devices that where present as AVAILABLE */
                            for( i = 0; i < ha->max_public_loop_ids; i++ )
                                if( (i != SNS_FL_PORT) && (i != FABRIC_CONTROLLER)
                                && (i != SIMPLE_NAME_SERVER) )
                                    ha->fabricid[i].in_use = FALSE;
                        }
                }
                status = qla2100_sns_device(ha, enable_slot_reuse);
                qla2100_restart_queues(ha,TRUE);
            }
            status = 1;
        }
        return( status );
}

        /*
        * qla2100_check_devices
        *	Check devices with loop ID's.
        *
        * Input:
        *	ha = adapter block pointer.
        *
        * Returns:
        *	0 = success.
        *   1 = retry needed
        *
        * Context:
        *	Kernel context.
        */
        STATIC uint8_t
        qla2100_check_devices(scsi_qla_host_t *ha) {
            int cnt;
            uint8_t  ret = 0;
            uint16_t mb[MAILBOX_REGISTER_COUNT];

            /*
            * Retry any devices that wasn't found but as a WWN.
            */
            /* v2.19.05b6 */
            for( cnt = 0; cnt < MAX_FIBRE_DEVICES; cnt++ ) {
                    if( (ha->fc_db[cnt].flag & DEV_MISSING) &&
                       !(ha->fc_db[cnt].flag & DEV_OFFLINE) ) {
                        /*
                        * This dev was not detected but its WWN
                        * is valid. To handle the case where
                        * the switch may not be giving us the
                        * device list correctly, schedule for
                        * a login retry later if not previously
                        * done so.
                        */
                        DEBUG(printk("qla2100_sns:Port login retry - target %d, count=%d\n",cnt, 
                                        ha->fc_db[cnt].port_login_retry_count); )
                        if( ha->fc_db[cnt].port_login_retry_count )
                          ha->fc_db[cnt].port_login_retry_count--;

                        /*
                        * If after decrement the retry count
                        * becomes 0, mark this device OFFLINE so
                        * no more retries will be done based
                        * on this device.
                        */
                        if (ha->fc_db[cnt].port_login_retry_count == 0) {
                            DEBUG(printk("qla2100_sns:Port set to OFFLINE - target %d\n",cnt); )
                            ha->fc_db[cnt].flag |= DEV_OFFLINE;
                        }
                        ret = 1;
                    }
               }

                /*
                * Mark devices as DEV_MISSING if they were present
                * before and have a loop ID.
                */
                for( cnt = 0; cnt < MAX_FIBRE_DEVICES &&
                    !ha->loop_down_timer &&
                    !ha->flags.loop_resync_needed; cnt++ ) {
                    /* if this slot is used (i.e. loop ID 0 - 0xfe) */
                    if( ha->fc_db[cnt].loop_id <= LAST_SNS_LOOP_ID ) {
                        /* Get port name */
                        mb[0] = MBC_GET_PORT_NAME;
                        mb[1] = ha->fc_db[cnt].loop_id << 8 | BIT_0;
                        if( qla2100_mailbox_command(ha, BIT_1|BIT_0, &mb[0]) ) {
                            /* Flag as missing only once */
                            if ( !(ha->fc_db[cnt].flag & DEV_MISSING) ) {
                               if ( ha->fc_db[cnt].port_login_retry_count ) {  /* v2.19.05b3 */
                                  ha->fc_db[cnt].port_login_retry_count--;
                                  ha->fc_db[cnt].flag |= DEV_MISSING;
                                  DEBUG(printk("qla2100_sns: Missing port %d @ loop ID: %x\n",
                                     cnt, ha->fc_db[cnt].loop_id);)
                                  ret++;
                               }
                            } 
                        } else if (ha->fc_db[cnt].flag & DEV_MISSING) {
                             ha->fc_db[cnt].flag &= ~DEV_MISSING;
                             ha->fc_db[cnt].flag &= ~DEV_OFFLINE;
                             ha->fc_db[cnt].flag |= DEV_RETURN;
                             ha->fc_db[cnt].port_login_retry_count = 8;
                             DEBUG(printk("qla2100_sns: Device %d returned\n", cnt);)
                        } 
                      }
                }
                return( ret );
        }

        /*
        * qla2100_update_fc_db
        *      Updates Fibre Channel Device Database with what is actually on loop.
        *
        * Input:
        *      ha                = adapter block pointer.
        *      enable_slot_reuse = allows the use of PORT_AVAILABLE slots.
        *
        * Output:
        *      ha->fc_db = updated
        *
        * Returns:
        *      0 = success.
        *      1 = error.
        *      2 = database was full and device was not configured.
        */
        STATIC uint8_t
        qla2100_update_fc_db(scsi_qla_host_t *ha, uint8_t enable_slot_reuse) {
            uint8_t  status = 0;
            uint8_t  ret = 0;
            uint8_t  db_full = 0;
            uint16_t cnt;
            uint16_t mb[MAILBOX_REGISTER_COUNT];
            port_list_entry_t *gn_list, *port_entry;
            device_data_t device;
#if BITS_PER_LONG > 32
            uint64_t    phys_address = 0;
#else
            uint32_t    phys_address = 0;
#endif
            uint16_t i, size;
            uint16_t localdevices = 0;
            int retry_needed = 0;
            uint8_t temp0, temp1, temp2, temp3;
#ifdef FC_IP_SUPPORT
            PIP_DEVICE_BLOCK    pIpDevice;
#endif

#ifdef QL_DEBUG_LEVEL_3
            ENTER("qla2100_update_fc_db");
#endif

            /* Configure loop */
            if( !qla2100_configure_hba(ha) ) {
                if( ha->device_id == QLA2100_DEVICE_ID ) {
                    ha->max_public_loop_ids = LAST_SNS_LOOP_ID - SNS_FIRST_LOOP_ID + 1;
                } else {
                    ha->max_public_loop_ids = LAST_SNS_LOOP_ID + 1;
                    /* dg 09/15 */
                    /* if the topology have change then make all devices available */
                    if( ha->prev_topology != ha->current_topology ) {
                        /* Mark all fabric devices that where present as AVAILABLE */
                        for( i = 0; i < ha->max_public_loop_ids; i++ )
                            if( (i != SNS_FL_PORT) && (i != FABRIC_CONTROLLER)
                            && (i != SIMPLE_NAME_SERVER) )
                                ha->fabricid[i].in_use = FALSE;

                            /* Mark all local devices that where present as AVAILABLE */
                            if( ha->current_topology == ISP_CFG_F )
                                for( cnt = 0; cnt < MAX_FIBRE_DEVICES && !ha->loop_down_timer
                                && !ha->flags.loop_resync_needed; cnt++ )
                                    if( ha->fc_db[cnt].loop_id < SNS_FIRST_LOOP_ID ) {
                                        ha->fc_db[cnt].loop_id = PORT_AVAILABLE;
                                        ha->fc_db[cnt].flag &= ~DEV_PUBLIC;
                                    }
                    }
                }
		/* v2.19.03 - Mark all devices missing if configured */
               for( cnt = 0; cnt < MAX_FIBRE_DEVICES; cnt++ )
                         if( ha->fc_db[cnt].flag & DEV_CONFIGURED)
                            ha->fc_db[cnt].flag |= DEV_MISSING;
#ifdef FC_IP_SUPPORT
                /* Disable all IP devices in linked list */
                for (pIpDevice = ha->pIpDeviceTop; pIpDevice != NULL;
                pIpDevice = pIpDevice->pNextIpDevice) {
                    pIpDevice->lDeviceFlags &= ~IP_DEV_FLAG_PRESENT;
                }
#endif /* FC_IP_SUPPORT */

                /* Configure local */
                /* Get the port list of devices on the local loop */
/* 4.10 */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
                gn_list = KMALLOC(GN_LIST_LENGTH);
                if ( gn_list != NULL ) {
                     phys_address = VIRT_TO_BUS(gn_list);
                     BZERO((caddr_t)gn_list, GN_LIST_LENGTH);
                }
#else
                gn_list  = pci_alloc_consistent(ha->pdev,
                                                GN_LIST_LENGTH,
                                                &phys_address);
                BZERO((caddr_t)gn_list, GN_LIST_LENGTH);
#endif
                if( gn_list != NULL ) {

                    if( !ha->loop_down_timer && !ha->flags.loop_resync_needed ) {
                        /* Get port list.*/
                        mb[0] = MBC_GET_PORT_LIST;
#ifdef FC_IP_SUPPORT
                        if (ha->flags.enable_ip == FALSE)
                            mb[1] = BIT_0;      /* Bit 0 - return node names */
                        else
                            mb[1] = BIT_0|BIT_1;/* Bit 0 - return node names, Bit 1 - loop IDs 0-255 */
#else
                        mb[1] = BIT_0;
#endif
                        mb[3] = LSW(phys_address);
                        mb[2] = MSW(phys_address);
                        mb[7] = QL21_64BITS_3RDWD(phys_address);
                        mb[6] = QL21_64BITS_4THWD(phys_address);
                        if( !qla2100_mailbox_command(ha, BIT_7|BIT_6|BIT_3|BIT_2|BIT_1|BIT_0, &mb[0]) ) {
                            if ( mb[0] == MBS_COMMAND_COMPLETE ) {
                                port_entry = gn_list;
                                size = mb[1];
                                /* dg 10/29/99 - check for empty list */
                                if ( size/sizeof(port_list_entry_t) == 0 ) {
                                    /* Local devices were present, but may not be reponding,
                                    so retry them later */
                                    DEBUG(qla2100_print("qla2100_update_fc_db: local port list - empty\n");)
                                } else
                                    /* Scan through the port list and add devices to the database */
                                    for( ; size >= sizeof(port_list_entry_t);
                                    size -= sizeof(port_list_entry_t), port_entry++ ) {
                                        /* Skip the known ports. */
#ifdef FC_IP_SUPPORT
                                        if( ((port_entry->loop_id & LOOP_ID_MASK) == SNS_FL_PORT) ||
                                        ((port_entry->loop_id & LOOP_ID_MASK) == FABRIC_CONTROLLER) ||
                                        ((port_entry->loop_id & LOOP_ID_MASK) == SIMPLE_NAME_SERVER) )
#else
                                            if( (port_entry->loop_id == SNS_FL_PORT) ||
                                            (port_entry->loop_id == FABRIC_CONTROLLER) ||
                                            (port_entry->loop_id == SIMPLE_NAME_SERVER) )
#endif
                                                continue;

                                            /* if we are on a public loop then logout the public devices. */
                                            if( ((ha->current_topology == ISP_CFG_FL)
                                            || (ha->current_topology == ISP_CFG_F))
#ifdef FC_IP_SUPPORT
                                            && !(port_entry->loop_id & PLE_NOT_SCSI_DEVICE)
                                            && ((port_entry->loop_id & LOOP_ID_MASK) >= ha->min_external_loopid)) {
#else
                                                && (port_entry->loop_id >= ha->min_external_loopid) ) {
#endif
                                                    mb[0] = MBC_LOGOUT_FABRIC_PORT;
#ifdef FC_IP_SUPPORT
                                                    mb[1] = (port_entry->loop_id & LOOP_ID_MASK) << 8;
#else
                                                    mb[1] = port_entry->loop_id << 8;
#endif
                                                    qla2100_mailbox_command(ha, BIT_1|BIT_0, &mb[0]);
                                                } else {
                                                    /* We are on a local loop             */
                                                    /* update the database with the loop  */
                                                    /* ID and login to the device.        */
#ifdef FC_IP_SUPPORT
                                                    device.loop_id = port_entry->loop_id & LOOP_ID_MASK;
#else
                                                    device.loop_id = port_entry->loop_id;
#endif

#if USE_PORTNAME
                                                    /* Get port name */
                                                    mb[0] = MBC_GET_PORT_NAME;
                                                    /* mb[1] = device.loop_id << 8 | BIT_0; */
                                                    mb[1] = device.loop_id << 8;
                                                    if( !qla2100_mailbox_command(ha, BIT_1|BIT_0, &mb[0]) ) {
                                                        /* dg 09/15/99  */
                                                        if ( mb[0] == MBS_COMMAND_COMPLETE ) {
                                                            /* tt 1/18/00 */
                                                            mb[2] = (mb[2] & 0x00FF) << 8 | mb[2] >> 8;
                                                            mb[3] = (mb[3] & 0x00FF) << 8 | mb[3] >> 8;
                                                            mb[6] = (mb[6] & 0x00FF) << 8 | mb[6] >> 8;
                                                            mb[7] = (mb[7] & 0x00FF) << 8 | mb[7] >> 8;

                                                            device.ms_wwn = mb[2] << 16
                                                            | mb[3];
                                                            device.ls_wwn = mb[6] << 16
                                                            | mb[7];
                                                        } else {
                                                            status = 1;
                                                            printk("qla2100_update_fc_db: GET PORT NAME - bad status.\n");
                                                            goto qla2100_update_fc_db_exit;
                                                        }

                                                    } else {   /* dg 10/29/99 */
                                                        if ( mb[0] == MBS_FATAL_ERROR  ) {
                                                            status = 1;
                                                            goto qla2100_update_fc_db_exit;
                                                        }
                                                        continue;
                                                    }
#endif
                                                    /* Get the node name */
     /*device.ls_name = *(uint32_t *)&(port_entry->name[0]);*/
/* the 64 bit compiler generates un-aligned memory access for commented line */
/* so break it up and use a temp local for transfer */
     temp0 = *(&(port_entry->name[0]));
     temp1 = *(&(port_entry->name[1]));
     temp2 = *(&(port_entry->name[2]));
     temp3 = *(&(port_entry->name[3]));
     device.ls_name = temp3<<24 | temp2<<16 | temp1<<8 | temp0;


     /* device.ms_name = *(uint32_t *)&(port_entry->name[4]); */
/* the 64 bit compiler generates un-aligned memory access for commented line */
/* so break it up and use a temp local for transfer */
     temp0 = *(&(port_entry->name[4]));
     temp1 = *(&(port_entry->name[5]));
     temp2 = *(&(port_entry->name[6]));
     temp3 = *(&(port_entry->name[7]));
     device.ms_name = temp3<<24 | temp2<<16 | temp1<<8 | temp0;
 

#ifdef FC_IP_SUPPORT
                                                    if (!(port_entry->loop_id & PLE_NOT_SCSI_DEVICE)) {
                                                        /* SCSI type device */
                                                        DEBUG(sprintf(debug_buff, "qla2100_update_fc_db: SCSI device at ID %x\n\r",
                                                        device.loop_id));
                                                        DEBUG(qla2100_print(debug_buff));
#endif
                                                        if( (status = qla2100_update_device_data(ha, &device, enable_slot_reuse)) ) {
                                                            /* if not configured or full */
                                                            if( status == 2 )
                                                                db_full = 1;
                                                            else
                                                                break;
                                                        } else
                                                            localdevices++;
#ifdef FC_IP_SUPPORT
                                    } else if (ha->flags.enable_ip == TRUE) {
                                                /* SCSI login failed, assume it is IP device */
                                                DEBUG(sprintf(debug_buff, "qla2100_update_fc_db: IP device at ID %x\n\r",
                                                device.loop_id));
                                                DEBUG(qla2100_print(debug_buff));

                                                /* Update IP device database */
                                                if (qla2x00_update_ip_device_data(ha, &device) == QL_STATUS_SUCCESS) {
                                                    localdevices++;
                                                } else {
                                                    status = 1;
                                                    break;
                                                }
                                             }
#endif
                                }   
                                         }  /* end of For */
                                       }
                                    }
                            }
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
                            KMFREE(gn_list, GN_LIST_LENGTH);
#else
                            pci_free_consistent(ha->pdev, GN_LIST_LENGTH,
                                                gn_list, phys_address);
#endif
                            /*
                            * if topology is a direct attached local loop then
                            * don't serach for public devices, unless its a 2100.
                            */
                            if( ((ha->current_topology == ISP_CFG_N) ||
                            (ha->current_topology == ISP_CFG_NL)) &&
                            ha->device_id != QLA2100_DEVICE_ID ) {  /* 2/21/00 - dg */
                                ha->prev_topology = ha->current_topology;
                            } else {
                                /* dgER - we need to add logic to register 
                                 * our adapter with the Name server, so we
                                 * can send Command Transport commands (FC4).
                                 * (target mode)
                                 */
 
                                /* get public loop devices */
                                if( !ha->loop_down_timer && !ha->flags.loop_resync_needed ){
                                     /* v2.19.5 */
                                    if( (ret = qla2100_sns_device(ha, enable_slot_reuse)) == 2 )
                                        db_full = 1;
                                     /* v2.19.5b3 */
                                    if( ret == 1 ) {
                                      if( ha->device_id != QLA2100_DEVICE_ID ) {
                                        status = ret;
                                        ha->sns_retry_cnt++;
                                        if( ha->sns_retry_cnt > 8 ) {
                                           if( !(ha->dpc_flags & ISP_RESET_ONCE) )
                                             ha->dpc_flags |= ISP_RESET_NEEDED;
                                        }
                                        else
                                          retry_needed++;
                                      }
				    }
                                 }
                                      
                            }

                            /* Set local loop devices present flag, clear retry flag */
                            if (localdevices > 0 ) {
                                ha->device_flags |= DFLG_LOCAL_DEVICES;
                                ha->device_flags &= ~DFLG_RETRY_LOCAL_DEVICES;
                            }

                        if( qla2100_check_devices(ha) ){
                           DEBUG(printk("qla2100: Devices are missing or configured - retrying\n");)
                            retry_needed++;
			}
#ifdef FC_IP_SUPPORT
                        /* Clean up active IP device list */
                        for (pIpDevice = ha->pIpDeviceBottom; pIpDevice != NULL;
                        pIpDevice = pIpDevice->pLastIpDevice) {
                            if (!(pIpDevice->lDeviceFlags & IP_DEV_FLAG_PRESENT)) {
                                /* Device not present, remove it from list and free resources */
                                DEBUG(sprintf(debug_buff, "qla2100_update_fc_db: removing IP device, loop ID: %x, port ID: %x\n\r",
                                pIpDevice->wLoopId,
                                pIpDevice->acPortId[0]<<16 | pIpDevice->acPortId[1]<<8 | pIpDevice->acPortId[2]));
                                DEBUG(qla2100_print(debug_buff));

                                if (pIpDevice->lDeviceFlags & IP_DEV_FLAG_PUBLIC_DEVICE) {
                                    /* Do fabric logout and free loop ID */
                                    if (qla2x00_logout_public_device(ha, pIpDevice->wLoopId, 0) == QL_STATUS_FATAL_ERROR) {
                                        status = 1;
                                        break;
                                    }
                                    qla2x00_free_loopid(ha, pIpDevice->wLoopId);
                                }
                                qla2x00_free_ip_block(ha, pIpDevice);
                            }
                        }
#endif /* FC_IP_SUPPORT */

                    } else {
#ifdef QL_DEBUG_LEVEL_2
                        qla2100_print(
                        "qla2100_update_fc_db: Failed to allocate memory, No local loop\n");
#endif
                        status = 1;
                    }
                    /* Map the devices to target IDs */
                    if( !ha->loop_down_timer && !ha->flags.loop_resync_needed )
                        qla2100_map_targets(ha);
                } else
                    status = 1;

                if( db_full )
                    status = 2;

                if( retry_needed ) {
                    ha->device_flags |= LOGIN_RETRY_NEEDED;
                    /* v2.19.5 */
                    status = 1;
                }

                qla2100_update_fc_db_exit:

                if( status == 0 ) {
                    ha->loop_state = LOOP_READY;
                    ha->sns_retry_cnt = 0;
                    for( cnt = 0; cnt < MAX_FIBRE_DEVICES; cnt++ )
                      ha->fc_db[cnt].port_login_retry_count = 8;
                    DEBUG(printk("qla2100_update_fc_db: LOOP READY\n");)
                }

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                if( status )
                    qla2100_print("qla2100_update_fc_db: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
                else
                    LEAVE("qla2100_update_fc_db");
#endif
                return(status);
            }

            /*
            * qla2100_init_tgt_map
            *      Initializes target map.
            *
            * Input:
            *      ha = adapter block pointer.
            *
            * Output:
            *      TGT_Q initialized
            */
            STATIC void
            qla2100_init_tgt_map(scsi_qla_host_t *ha) {
                uint32_t b, t;

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_init_tgt_map");
#endif

                for( b = 0; b < MAX_BUSES; b++ )
                    for( t = 0; t < MAX_FIBRE_DEVICES; t++ )
                        TGT_Q(ha, b, t) = (tgt_t *) NULL;

#ifdef QL_DEBUG_LEVEL_3
                    LEAVE("qla2100_init_tgt_map");
#endif
            }

            /*
            * qla2100_map_targets
            *      Setup target queues.
            *
            * Input:
            *      ha = adapter block pointer.
            *
            * Returns:
            *      0 = success.
            */
            STATIC uint8_t
            qla2100_map_targets(scsi_qla_host_t *ha) {
                tgt_t    *tgt;
                uint32_t b;
                uint32_t t;
                uint8_t  status = 0;

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_map_targets");
#endif

                b = 0;
                for( t = 0; t < MAX_FIBRE_DEVICES; t++ ) {
                    /* if Port never been used. OR */
                    /*  Device does not exist on port. */
                    if( ha->fc_db[t].loop_id != PORT_UNUSED  &&
                    ha->fc_db[t].loop_id != PORT_AVAILABLE ) {  /* dg 10/29/99 */

                        if( (tgt = TGT_Q(ha, b, t)) != NULL ) {
                            DEBUG2(sprintf(debug_buff,"Target %d already allocated\n",t));
                            DEBUG2(qla2100_print(debug_buff));
                        } else
                            tgt = qla2100_tgt_alloc(ha);
                        DEBUG(sprintf(debug_buff,"Assigning target ID %02x:%02x @ (%08x) to loop id: 0x%04x\n",b,t,tgt,ha->fc_db[t].loop_id);)
                        DEBUG2(qla2100_print(debug_buff));
                        TGT_Q(ha, b, t) = tgt;
                        tgt->loop_id = ha->fc_db[t].loop_id;
                        tgt->down_timer = 0;
                    }
                }

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                if( status )
                    qla2100_print("qla2100_map_targets: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
                else
                    LEAVE("qla2100_map_targets");
#endif
                return(status);
            }
#if USE_FLASH
            /*
            * qla2100_get_database
            *      Copies and converts flash database to driver database.
            *      (may sleep)
            *
            * Input:
            *      ha = adapter block pointer.
            *
            * Returns:
            *      0 = success.
            */
            STATIC uint8_t
            qla2100_get_database(scsi_qla_host_t *ha) {
                flash_database_t *fptr;
                uint8_t          status = 1;
                uint32_t         addr;
                uint16_t         cnt;
                uint8_t          *bptr;
                uint8_t          checksum;
                uint32_t         b, t;

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_get_database");
#endif

                /* Default setup. */
                ha->flash_db = FLASH_DATABASE_0;
                ha->flash_seq = 0;

                if( (fptr = (flash_database_t *)KMALLOC(sizeof(flash_database_t))) ) {
                    /* Enable Flash Read/Write. */
                    qla2100_flash_enable(ha);

                    /* Start with flash database with the highest sequence number. */
                    b = qla2100_read_flash_byte(ha, FLASH_DATABASE_0);
                    b |= qla2100_read_flash_byte(ha, FLASH_DATABASE_0 + 1) << 8;
                    b |= qla2100_read_flash_byte(ha, FLASH_DATABASE_0 + 1) << 16;
                    b |= qla2100_read_flash_byte(ha, FLASH_DATABASE_0 + 1) << 24;
                    t = qla2100_read_flash_byte(ha, FLASH_DATABASE_1);
                    t |= qla2100_read_flash_byte(ha, FLASH_DATABASE_1 + 1) << 8;
                    t |= qla2100_read_flash_byte(ha, FLASH_DATABASE_1 + 1) << 16;
                    t |= qla2100_read_flash_byte(ha, FLASH_DATABASE_1 + 1) << 24;
                    if( t > b ) {
                        ha->flash_db = FLASH_DATABASE_1;
                    }

                    /* Select the flash database with the good checksum. */
                    for( t = 0; t < 2; t++ ) {
                        checksum = 0;
                        addr = ha->flash_db;
                        bptr = (uint8_t *)fptr;
                        fptr->hdr.size = sizeof(flash_database_t);

                        /* Read flash database to driver. */
                        for( cnt = 0; cnt < fptr->hdr.size; cnt++ ) {
                            *bptr = (uint8_t)qla2100_read_flash_byte(ha, addr++);
                            checksum += *bptr++;
                            if( bptr == &fptr->hdr.spares[0] &&
                            (fptr->hdr.size > sizeof(flash_database_t) ||
                            fptr->hdr.size < sizeof(flash_hdr_t) ||
                            !fptr->hdr.version) ) {
                                checksum = 1;
                                break;
                            }
                        }

                        if( !checksum ) {
                            status = 0;
                            break;
                        }
                        /* trying other database */
                        if( ha->flash_db == FLASH_DATABASE_0 ) {
                            ha->flash_db = FLASH_DATABASE_1;
                        } else {
                            ha->flash_db = FLASH_DATABASE_0;
                        }
                    }

                    if( !status ) {
                        ha->flash_seq = fptr->hdr.seq;

                        /* Convert flash database to driver database format. */
                        if( fptr->hdr.size -= sizeof(flash_hdr_t) ) {
                            for( cnt = 0; cnt < MAX_FIBRE_DEVICES; cnt++ ) {
                                ha->fc_db[cnt].name[0] = fptr->node[cnt].name[0];
                                ha->fc_db[cnt].name[1] = fptr->node[cnt].name[1];
                                cnt,
                                ha->fc_db[cnt].name[1],
                                ha->fc_db[cnt].name[0]);

                                ha->fc_db[cnt].loop_id = PORT_AVAILABLE;
                                ha->fc_db[cnt].flag = 0;  /* v2.19.05b3 */
                                if( !(fptr->hdr.size -= sizeof(flash_node_t)) )
                                    break;
                            }
                        }
                    }

                    qla2100_flash_disable(ha);

                    KMFREE(fptr, sizeof(flash_database_t));
                }

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                if( status )
                    qla2100_print("qla2100_get_database: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
                else
                    LEAVE("qla2100_get_database");
#endif
                return(status);
            }

            /*
            * qla2100_save_database
            *      Copies and converts driver database to flash database.
            *      (may sleep)
            *
            * Input:
            *      ha = adapter block pointer.
            *
            * Returns:
            *      0 = success.
            */
            STATIC uint8_t
            qla2100_save_database(scsi_qla_host_t *ha) {
                flash_database_t *fptr;
                uint8_t          status = 1;
                uint32_t         addr;
                uint16_t         cnt;
                uint8_t          *bptr;
                uint8_t          checksum;

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_save_database");
#endif

                if( (fptr = (flash_database_t *)KMALLOC(sizeof(flash_database_t)) ) ) {
                    /* Enable Flash Read/Write. */
                    qla2100_flash_enable(ha);

                    fptr->hdr.seq     = ++ha->flash_seq;
                    fptr->hdr.version = FLASH_DATABASE_VERSION;
                    fptr->hdr.size    = sizeof(flash_hdr_t);

                    /* Copy and convert driver database to flash database. */
                    for( cnt = 0; cnt < MAX_FIBRE_DEVICES; cnt++ ) {
                        if( ha->fc_db[cnt].loop_id == PORT_UNUSED )
                            break;
                        else {
                            fptr->node[cnt].name[0] = ha->fc_db[cnt].name[0];
                            fptr->node[cnt].name[1] = ha->fc_db[cnt].name[1];
                            fptr->hdr.size += sizeof(flash_node_t);
                        }
                    }

                    /* Calculate checksum. */
                    checksum = 0;
                    bptr = (uint8_t *)fptr;
                    for( cnt = 0; cnt < fptr->hdr.size; cnt++ )
                        checksum += *bptr++;
                    fptr->hdr.checksum = ~checksum + 1;

                    /* Setup next sector address for flash */
                    if( ha->flash_db == FLASH_DATABASE_0 )
                        addr = FLASH_DATABASE_1;
                    else
                        addr = FLASH_DATABASE_0;
                    ha->flash_db = addr;

                    /* Erase flash sector prior to write. */
                    status = qla2100_erase_flash_sector(ha, addr);

                    /* Write database to flash. */
                    bptr = (uint8_t *)fptr;
                    for( cnt = 0; cnt < fptr->hdr.size && !status; cnt++ )
                        status = qla2100_program_flash_address(ha, addr++, *bptr++);

                    qla2100_flash_disable(ha);

                    KMFREE(fptr, sizeof(flash_database_t));
                }

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                if( status )
                    qla2100_print("qla2100_save_database: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
                else
                    LEAVE("qla2100_save_database");
#endif
                return(status);
            }

            /*
            * qla2100_program_flash_address
            *      Program flash address.
            *
            * Input:
            *      ha   = adapter block pointer.
            *      addr = flash byte address.
            *      data = data to be written to flash.
            *
            * Returns:
            *      0 = success.
            */
            STATIC uint8_t
            qla2100_program_flash_address(scsi_qla_host_t *ha, uint32_t addr, uint8_t data) {
                uint8_t status;

                /* Write Program Command Sequence */
                qla2100_write_flash_byte(ha, 0x5555, 0xaa);
                qla2100_write_flash_byte(ha, 0x2aaa, 0x55);
                qla2100_write_flash_byte(ha, 0x5555, 0xa0);
                qla2100_write_flash_byte(ha, addr, data);

                /* Wait for write to complete. */
                status = qla2100_poll_flash(ha, addr, data);

#ifdef QL_DEBUG_LEVEL_2
                if( status )
                    qla2100_print("qla2100_program_flash_address: **** FAILED ****\n");
#endif
                return(status);
            }

            /*
            * qla2100_erase_flash_sector
            *      Erases flash sector.
            *
            * Input:
            *      ha   = adapter block pointer.
            *      addr = sector address.
            *
            * Returns:
            *      0 = success.
            */
            STATIC uint8_t
            qla2100_erase_flash_sector(scsi_qla_host_t *ha, uint32_t addr) {
                uint8_t status;

                addr &= 0x1c000;

                /* Individual Sector Erase Command Sequence */
                qla2100_write_flash_byte(ha, 0x5555, 0xaa);
                qla2100_write_flash_byte(ha, 0x2aaa, 0x55);
                qla2100_write_flash_byte(ha, 0x5555, 0x80);
                qla2100_write_flash_byte(ha, 0x5555, 0xaa);
                qla2100_write_flash_byte(ha, 0x2aaa, 0x55);
                qla2100_write_flash_byte(ha, addr, 0x30);

                SYS_DELAY(150);

                /* Wait for erase to complete. */
                status = qla2100_poll_flash(ha, addr, 0x80);

#ifdef QL_DEBUG_LEVEL_2
                if( status )
                    qla2100_print("qla2100_erase_flash_sector: **** FAILED ****\n");
#endif
                return(status);
            }

            /*
            * qla2100_poll_flash
            *      Polls flash for completion.
            *
            * Input:
            *      ha   = adapter block pointer.
            *      addr = flash byte address.
            *      data = data to be polled.
            *
            * Returns:
            *      0 = success.
            */
            STATIC uint8_t
            qla2100_poll_flash(scsi_qla_host_t *ha, uint32_t addr, uint8_t poll_data) {
                uint8_t  status = 1;
                uint8_t  flash_data;
                uint32_t cnt;

                poll_data &= BIT_7;

                /* Wait for 30 seconds for command to finish. */
                for( cnt = 3000000; cnt; cnt-- ) {
                    flash_data = (uint8_t)qla2100_read_flash_byte(ha, addr);

                    if( (flash_data & BIT_7) == poll_data ) {
                        status = 0;
                        break;
                    }
                    if( flash_data & BIT_5 && cnt > 2 )
                        cnt = 2;
                    SYS_DELAY(10);
                }

                return(status);
            }

            /*
            * qla2100_flash_enable
            *      Setup flash for reading/writing.
            *
            * Input:
            *      ha = adapter block pointer.
            */
            STATIC void
            qla2100_flash_enable(scsi_qla_host_t *ha) {
                device_reg_t *reg = ha->iobase;

                /* Setup bit 16 of flash address. */
                WRT_REG_WORD(&reg->nvram, NV_SELECT);

                /* Enable Flash Read/Write. */
                WRT_REG_WORD(&reg->ctrl_status, ISP_FLASH_ENABLE);

                /* Read/Reset Command Sequence */
                qla2100_write_flash_byte(ha, 0x5555, 0xaa);
                qla2100_write_flash_byte(ha, 0x2aaa, 0x55);
                qla2100_write_flash_byte(ha, 0x5555, 0xf0);
                qla2100_read_flash_byte(ha, FLASH_DATABASE_0);
            }

            /*
            * qla2100_flash_disable
            *      Disable flash and allow RISC to run.
            *
            * Input:
            *      ha = adapter block pointer.
            */
            STATIC void
            qla2100_flash_disable(scsi_qla_host_t *ha) {
                device_reg_t *reg = ha->iobase;

                /* Restore chip registers. */
                WRT_REG_WORD(&reg->ctrl_status, 0);
                WRT_REG_WORD(&reg->nvram, 0);
            }

            /*
            * qla2100_write_flash_byte
            *      Write byte to flash.
            *
            * Input:
            *      ha   = adapter block pointer.
            *      addr = flash byte address.
            *      data = data to be written.
            */
            STATIC void
            qla2100_write_flash_byte(scsi_qla_host_t *ha, uint32_t addr, uint8_t data) {
                device_reg_t *reg = ha->iobase;

                WRT_REG_WORD(&reg->flash_address, (uint16_t)addr);
                WRT_REG_WORD(&reg->flash_data, (uint16_t)data);
            }

            /*
            * qla2100_read_flash_byte
            *      Reads byte from flash, but must read a word from chip.
            *
            * Input:
            *      ha   = adapter block pointer.
            *      addr = flash byte address.
            *
            * Returns:
            *      byte from flash.
            */
            STATIC uint16_t
            qla2100_read_flash_byte(scsi_qla_host_t *ha, uint32_t addr) {
                device_reg_t *reg = ha->iobase;
                uint16_t     data;

                WRT_REG_WORD(&reg->flash_address, (uint16_t)addr);
                data = qla2100_debounce_register(&reg->flash_data);

                return(data);
            }
#endif

            /*
            * qla2100_reset_adapter
            *      Reset adapter.
            *
            * Input:
            *      ha = adapter block pointer.
            */
            STATIC void
            qla2100_reset_adapter(scsi_qla_host_t *ha) {
                device_reg_t *reg = ha->iobase;

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_reset_adapter");
#endif

                ha->flags.online = FALSE;
                qla2100_disable_intrs(ha);
                /* WRT_REG_WORD(&reg->ictrl, 0); */
                /* Reset RISC processor. */
                WRT_REG_WORD(&reg->host_cmd, HC_RESET_RISC);
                WRT_REG_WORD(&reg->host_cmd, HC_RELEASE_RISC);
#ifdef QL_DEBUG_LEVEL_3
                LEAVE("qla2100_reset_adapter");
#endif
            }

            /*
            * qla2100_loop_reset
            *      Issue loop reset.
            *
            * Input:
            *      ha = adapter block pointer.
            *
            * Returns:
            *      0 = success
            */
            STATIC uint8_t
            qla2100_loop_reset(scsi_qla_host_t *ha) {
                uint8_t  status = 0;
                uint16_t mb[MAILBOX_REGISTER_COUNT];

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_loop_reset");
#endif

                if( ha->flags.enable_lip_reset ) {
                    mb[0] = MBC_LIP_RESET;
                    mb[1] = 0xff00;
                    mb[2] = ha->loop_reset_delay;
                    status |= qla2100_mailbox_command(ha, BIT_2|BIT_1|BIT_0, &mb[0]);
                }
                if( ha->flags.enable_target_reset ) {
                    mb[0] = MBC_TARGET_RESET;
                    mb[1] = ha->loop_reset_delay;
                    status |= qla2100_mailbox_command(ha, BIT_1|BIT_0, &mb[0]);
                }
                if( (!ha->flags.enable_target_reset && !ha->flags.enable_lip_reset ) ||
                ha->flags.enable_lip_full_login ) {
                    mb[0] = MBC_LIP_FULL_LOGIN;
                    status |= qla2100_mailbox_command(ha, BIT_0, &mb[0]);
                }

                /* Issue marker command. */
                qla2100_marker(ha, 0, 0, 0, MK_SYNC_ALL);

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                if( status )
                    qla2100_print("qla2100_loop_reset: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
                else
                    LEAVE("qla2100_loop_reset");
#endif
                return(status);
            }

            /*
            * qla2100_device_reset
            *      Issue bus device reset message to the target.
            *
            * Input:
            *      ha = adapter block pointer.
            *      b  = BUS number.
            *      t  = SCSI ID.
            *
            * Returns:
            *      0 = success
            */
            STATIC uint8_t
            qla2100_device_reset(scsi_qla_host_t *ha, uint32_t b, uint32_t t) {
                tgt_t    *tgt;
                uint8_t  status;
                uint16_t mb[MAILBOX_REGISTER_COUNT];

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_device_reset");
#endif

                tgt =  TGT_Q(ha, b, t);

                mb[0] = MBC_ABORT_TARGET;
                mb[1] = tgt->loop_id << 8;
                mb[2] = 1;
                status = qla2100_mailbox_command(ha, BIT_2|BIT_1|BIT_0, &mb[0]);

                /* Issue marker command. */
                qla2100_marker(ha, b, t, 0, MK_SYNC_ID);

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                if( status )
                    qla2100_print("qla2100_device_reset: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
                else
                    LEAVE("qla2100_device_reset");
#endif
                return(status);
            }

            /*
            * qla2100_abort_device
            *      Issue an abort message to the device
            *
            * Input:
            *      ha = adapter block pointer.
            *      b  = BUS number.
            *      t  = SCSI ID.
            *      l  = SCSI LUN.
            *
            * Returns:
            *      0 = success
            */
            STATIC uint8_t
            qla2100_abort_device(scsi_qla_host_t *ha, uint32_t b, uint32_t t, uint32_t l) {
                tgt_t    *tgt;
                uint8_t  status;
                uint16_t mb[MAILBOX_REGISTER_COUNT];

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_abort_device");
#endif

                tgt = TGT_Q(ha, b, t);

                mb[0] = MBC_ABORT_DEVICE;
                mb[1] = tgt->loop_id << 8;
                mb[2] = l;
                status = qla2100_mailbox_command(ha, BIT_2|BIT_1|BIT_0, &mb[0]);

                /* Issue marker command. */
                qla2100_marker(ha, b, t, l, MK_SYNC_ID_LUN);

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                if( status )
                    qla2100_print("qla2100_abort_device: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
                else
                    LEAVE("qla2100_abort_device");
#endif
                return(status);
            }

            /*
            * qla2100_abort_command
            *      Abort command aborts a specified IOCB.
            *
            * Input:
            *      ha = adapter block pointer.
            *      sp = SB structure pointer.
            *
            * Returns:
            *      0 = success
            */
            STATIC uint8_t
            qla2100_abort_command(scsi_qla_host_t *ha, srb_t *sp) {
                uint8_t        status;
                uint16_t       mb[MAILBOX_REGISTER_COUNT];
                uint32_t       b, t, l;
                uint32_t       handle;
                tgt_t          *tgt;

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_abort_command");
#endif
		/* v2.19.8 */
                t  = SCSI_TCN_32(sp->cmd);
                if( ha->loop_state == LOOP_DOWN ||
                       PORT_DOWN(ha,t) > 0 ) {
                    return(0);
                }

                /* Locate handle number. */
                for( handle = 0; handle < MAX_OUTSTANDING_COMMANDS; handle++ )
                    if( ha->outstanding_cmds[handle] == sp )
                        break;

                    DEBUG(qla2100_print("qla2100_abort_command: Sending Abort Command for Handle =  ");)
                    DEBUG(qla2100_output_number((u_long) handle, 16);)
                    DEBUG(qla2100_print("\n");)

                    /* Get a pointer to the SCSI address */
                    b  = SCSI_BUS_32(sp->cmd);
                    l  = SCSI_LUN_32(sp->cmd);

                    tgt = TGT_Q(ha, b, t);

                    mb[0] = MBC_ABORT_COMMAND;
                    mb[1] = tgt->loop_id << 8;
                    mb[2] = (uint16_t)handle;
                    mb[3] = handle >> 16;
                    mb[6] = l;
                    if( !(status = qla2100_mailbox_command(ha, BIT_6|BIT_3|BIT_2|BIT_1|BIT_0,
                    &mb[0])) )
                        sp->flags |= SRB_ABORT_PENDING;


#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                    if( status )
                        qla2100_print("qla2100_abort_command: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
                    else
                        LEAVE("qla2100_abort_command");
#endif
                    return(status);
            }

            /*
            *  Issue marker command.
            *      Function issues marker IOCB.
            *
            * Input:
            *      ha   = adapter block pointer.
            *      b    = BUS number.
            *      t    = SCSI ID
            *      l    = SCSI LUN
            *      type = marker modifier
            */
            STATIC void
            qla2100_marker(scsi_qla_host_t *ha, uint32_t b, uint32_t t, uint32_t l, uint8_t type) {
                mrk_entry_t *pkt;
                tgt_t       *tgt;

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_marker");
#endif

                tgt = TGT_Q(ha, b, t);

                /* Get request packet. */
                if( (pkt = (mrk_entry_t *)qla2100_req_pkt(ha) ) ) {
                    pkt->entry_type = MARKER_TYPE;
                    pkt->modifier = type;

                    if( type == MK_SYNC_LIP )
                        pkt->sequence_number = ha->lip_seq;
                    else if( type != MK_SYNC_ALL ) {
                        pkt->lun = l;
                        pkt->target = (uint8_t)tgt->loop_id;
                    }

                    /* Issue command to ISP */
                    qla2100_isp_cmd(ha);
                }

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                if( !pkt )
                    qla2100_print("qla2100_marker: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
                else
                    LEAVE("qla2100_marker");
#endif
            }

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,3,18)
            /*
            * qla2100_64bit_start_scsi
            *      The start SCSI is responsible for building request packets on
            *      request ring and modifying ISP input pointer.
            *
            * Input:
            *      ha = adapter block pointer.
            *      sp = SB structure pointer.
            *
            * Returns:
            *      0 = success, was able to issue command.
            */
            STATIC uint8_t
            qla2100_64bit_start_scsi(scsi_qla_host_t *ha, srb_t *sp) {
                device_reg_t        *reg       = ha->iobase;
                device2300_reg_t    *reg2300   = ha->iobase2300;
                uint8_t         status = 0;
                Scsi_Cmnd       *cmd = sp->cmd;
                uint32_t        cnt;
                cmd_a64_entry_t     *pkt;
                uint16_t        req_cnt;
                uint16_t        seg_cnt;
                uint16_t        cdb_len,temp;
                struct scatterlist    *sg = (struct scatterlist *) NULL;
                uint32_t        timeout;
                caddr_t         data_ptr;
                uint32_t        *dword_ptr;
                uint64_t        dma_handle;

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_64bit_start_scsi:");
#endif
                DEBUG(sprintf(debug_buff,
                 "64bit_start: cmd=%x sp=%x CDB=%x\n\r",cmd,sp,cmd->cmnd[0]);)
                DEBUG(qla2100_print(debug_buff));

                /* Calculate number of entries and segments required. */
                seg_cnt = 0;
                req_cnt = 1;
                if ( cmd->use_sg ) { 
                    /* 4.10 64 bit S/G Data Transfer */
                    sg = (struct scatterlist *) cmd->request_buffer;
                    seg_cnt = pci_map_sg(ha->pdev,
                               sg,cmd->use_sg, 
                               scsi_to_pci_dma_dir(cmd->sc_data_direction));

                    if( seg_cnt > 2 ) {
                        req_cnt += (uint16_t)(seg_cnt - 2) / 5;
                        if( (uint16_t)(seg_cnt - 2) % 5 )
                            req_cnt++;
                    }
                } else if( cmd->request_bufflen )
                {   /* no S/G Data Transfer */
                    /* DEBUG5(printk("Single data transfer (0x%x)\n",
                    cmd->request_bufflen)); */
                    seg_cnt = 1;
                }

                /* Acquire ring specific lock */
                QLA2100_RING_LOCK(ha);

                if( (uint16_t)(req_cnt + 2) >= ha->req_q_cnt ) {
                    /* Calculate number of free request q out entries. */
                    if (ha->device_id == QLA2300_DEVICE_ID)  cnt = RD_REG_WORD(&reg2300->req_q_out);
                    else                                     cnt = RD_REG_WORD(&reg->mailbox4);
                    if( ha->req_ring_index < cnt )
                        ha->req_q_cnt = cnt - ha->req_ring_index;
                    else
                        ha->req_q_cnt = REQUEST_ENTRY_CNT - (ha->req_ring_index - cnt);
                }

                /* If room for request in request ring. */
                if( (uint16_t)(req_cnt + 2) < ha->req_q_cnt ) {
                    /* Check for room in outstanding command list. */
                    for( cnt = 1; cnt < MAX_OUTSTANDING_COMMANDS &&
                    ha->outstanding_cmds[cnt] != 0; cnt++ )
                        ;

                    if( cnt < MAX_OUTSTANDING_COMMANDS ) {
                        ha->outstanding_cmds[cnt] = sp;
                        ha->req_q_cnt -= req_cnt;
                        CMD_HANDLE(sp->cmd) = (unsigned char *) (u_long) cnt;

                        /*
                        * Build command packet.
                        */
                        pkt = ha->request_ring_ptr;

                        pkt->entry_type = COMMAND_A64_TYPE;
                        pkt->entry_count = (uint8_t)req_cnt;
                        pkt->sys_define = (uint8_t)ha->req_ring_index;
                        pkt->control_flags= 0;
                        pkt->entry_status = 0;
                        pkt->handle = (uint32_t)cnt;

                        /* Zero out remaining portion of packet. */
                        dword_ptr = (uint32_t *)pkt + 2;
                        for( cnt = 2; cnt < REQUEST_ENTRY_SIZE/4; cnt++ )
                            *dword_ptr++ = 0;

                        /*
                        * We subtract 2 sec. from the timeout value to insure
                        * the ISP time-out before the mid-level or the driver.
                        */
                        timeout = (uint32_t) CMD_TIMEOUT(cmd)/HZ;
                        if( timeout > 2 )
                            pkt->timeout = (uint16_t) timeout - 2;
                        else
                            pkt->timeout = (uint16_t) timeout;

                        /* Set device target ID and LUN */
                        pkt->target = TGT_Q(ha, SCSI_BUS_32(cmd), 
                                      SCSI_TCN_32(cmd))->loop_id;
                        pkt->lun = SCSI_LUN_32(cmd);

                        /* Enable simple tag queuing if device supports it. */
                        if ( cmd->device->tagged_queue ) {
                            switch (cmd->tag) {
                                case SIMPLE_QUEUE_TAG:
                                    pkt->control_flags = CF_SIMPLE_TAG;
                                    break;
                                case HEAD_OF_QUEUE_TAG:
                                    pkt->control_flags = CF_HEAD_TAG;
                                    break;
                                case ORDERED_QUEUE_TAG:
                                    pkt->control_flags = CF_ORDERED_TAG;
                                    break;
                                default:
                                    pkt->control_flags = CF_SIMPLE_TAG;
                            }
                        } else
                            pkt->control_flags = CF_SIMPLE_TAG;

                       if (ha->device_id == QLA2300_DEVICE_ID)
                           pkt->control_flags |= CF_NO_FAST_POSTING; 

                        /* Load SCSI command packet. */
                        cdb_len = (uint16_t)CMD_CDBLEN(cmd);
                        if (cdb_len > MAX_CMDSZ) cdb_len = MAX_CMDSZ;
                        data_ptr = (uint8_t *) &(CMD_CDBP(cmd));
                        for( cnt = 0; cnt < cdb_len; cnt++ )
                            pkt->scsi_cdb[cnt] = *data_ptr++;
                        pkt->byte_count = (uint32_t) CMD_XFRLEN(cmd);

                        /*
                        * Load data segments.
                        */
                        if( seg_cnt )                /* If data transfer. */
                        {
                            switch( cmd->data_cmnd[0] ) {
                                case FORMAT_UNIT:
                                case WRITE_6:
                                case MODE_SELECT:
                                case SEND_DIAGNOSTIC:
                                case WRITE_10:
                                case WRITE_BUFFER:
                                case WRITE_LONG:
                                case WRITE_SAME:
                                case MODE_SELECT_10:
                                case WRITE_12:
                                case WRITE_VERIFY_12:
                                case SEND_VOLUME_TAG:
                                    pkt->control_flags |= BIT_6; /* WRITE */
                                    break;
                                default:
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
#if QLA_SCSI_VENDOR_DIR
    				    qla2100_set_vend_direction(ha, cmd, pkt);
#else
                                    pkt->control_flags |= BIT_5; /* READ */
#endif
#else  /* kernel version is 2.4.0 or higher */
                                    if (cmd->sc_data_direction == SCSI_DATA_WRITE)
                                        pkt->control_flags |= BIT_6;/*WRITE*/
                                    else 
                                        pkt->control_flags |= BIT_5;/*READ*/
#endif /* kernel version 2.4.0 */
                                    break;
                            }
                            sp->dir = pkt->control_flags & (BIT_5|BIT_6);
 
                            /* Set total data segment count. */
                            pkt->dseg_count = seg_cnt;

                            /* Setup packet address segment pointer. */
                            dword_ptr = (uint32_t *)&pkt->dseg_0_address;

                            if( cmd->use_sg )              /* If scatter gather */
                            {
                                /* Load command entry data segments. */
                                for( cnt = 0; cnt < 2 && seg_cnt; cnt++, seg_cnt-- ) {
                                    /* 4.10 64 bit */
                                    *dword_ptr++ = cpu_to_le32(pci_dma_lo32(sg_dma_address(sg)));
                                    *dword_ptr++ = cpu_to_le32(pci_dma_hi32(sg_dma_address(sg)));
                                    *dword_ptr++ = cpu_to_le32(sg_dma_len(sg));
                                    sg++;
                                      /* DEBUG(sprintf(debug_buff,
                                      "S/G Segment phys_addr=%x %x, len=0x%x\n\r",
                                      cpu_to_le32(pci_dma_hi32(sg_dma_address(sg))),
                                      cpu_to_le32(pci_dma_lo32(sg_dma_address(sg))),
                                      cpu_to_le32(sg_dma_len(sg)));)
                                      DEBUG(qla2100_print(debug_buff)); */
                                }
#ifdef QL_DEBUG_LEVEL_5
                                qla2100_print(
                                "qla2x00_64bit_start_scsi: Scatter/gather command packet data - ");
                                qla2100_print("b");
                                qla2100_output_number((uint32_t)SCSI_BUS_32(cmd), 10);
                                qla2100_print("t");
                                qla2100_output_number((uint32_t)SCSI_TCN_32(cmd), 10);
                                qla2100_print("d");
                                qla2100_output_number((uint32_t)SCSI_LUN_32(cmd), 10);
                                qla2100_print("\n\r");
                                qla2100_dump_buffer((caddr_t)pkt, REQUEST_ENTRY_SIZE);
#endif
                                /*
                                * Build continuation packets.
                                */
                                while( seg_cnt > 0 ) {
                                    /* Adjust ring index. */
                                    ha->req_ring_index++;
                                    if( ha->req_ring_index == REQUEST_ENTRY_CNT ) {
                                        ha->req_ring_index = 0;
                                        ha->request_ring_ptr = ha->request_ring;
                                    } else
                                        ha->request_ring_ptr++;

                                    pkt = (cmd_a64_entry_t *)ha->request_ring_ptr;

                                    /* Zero out packet. */
                                    dword_ptr = (uint32_t *)pkt;
                                    for( cnt = 0;cnt < REQUEST_ENTRY_SIZE/4; cnt++ )
                                        *dword_ptr++ = 0;

                                    /* Load packet defaults. */
                                    ((cont_a64_entry_t *)pkt)->entry_type =
                                    CONTINUE_A64_TYPE;
                                    ((cont_a64_entry_t *)pkt)->entry_count = 1;
                                    ((cont_a64_entry_t *)pkt)->sys_define = (uint8_t)
                                    ha->req_ring_index;

                                    /* Setup packet address segment pointer. */
                                    dword_ptr = (uint32_t *)
                                    &((cont_a64_entry_t *)pkt)->dseg_0_address;

                                    /* Load continuation entry data segments. */
                                    for( cnt = 0; cnt < 5 && seg_cnt; cnt++, seg_cnt-- ) {
                                       /* 4.10 64 bit */
                                       *dword_ptr++ = cpu_to_le32(pci_dma_lo32(sg_dma_address(sg)));
                                       *dword_ptr++ = cpu_to_le32(pci_dma_hi32(sg_dma_address(sg)));
                                       *dword_ptr++ = cpu_to_le32(sg_dma_len(sg));
                                       sg++;
                                      /* DEBUG(sprintf(debug_buff,
                                      "S/G Segment Cont. phys_addr=%x %x, len=0x%x\n\r",
                                       cpu_to_le32(pci_dma_hi32(sg_dma_address(sg))),
                                       cpu_to_le32(pci_dma_lo32(sg_dma_address(sg))),
                                       cpu_to_le32(sg_dma_len(sg)));)
                                       DEBUG(qla2100_print(debug_buff)); */
                                    }
#ifdef QL_DEBUG_LEVEL_5
                                    qla2100_print(
                                    "qla2x00_64bit_start_scsi: continuation packet data - c");
                                    qla2100_print("b");
                            qla2100_output_number((u_long)SCSI_BUS_32(cmd), 10);

                            qla2100_print("t");
                            qla2100_output_number((u_long)SCSI_TCN_32(cmd), 10);
                            qla2100_print("d");
                            qla2100_output_number((u_long)SCSI_LUN_32(cmd), 10);
                            qla2100_print("\n\r");
                                    qla2100_dump_buffer((caddr_t)pkt, REQUEST_ENTRY_SIZE);
#endif
                                }
                            } else   /* No scatter gather data transfer */
                            {   /* 4.10 64 bit */
                                dma_handle = pci_map_single(ha->pdev, 
                                                         cmd->request_buffer,
                                                         cmd->request_bufflen,
                                                         scsi_to_pci_dma_dir(cmd->sc_data_direction));
                                /* save dma_handle for pci_unmap_single */
                                sp->saved_dma_handle = dma_handle;

                                *dword_ptr++ = cpu_to_le32(pci_dma_lo32(dma_handle));
                                *dword_ptr++ = cpu_to_le32(pci_dma_hi32(dma_handle));
                                *dword_ptr   = (uint32_t) cmd->request_bufflen;
                                /* DEBUG(sprintf(debug_buff,
                                "64_bit: No S/G map_single saved_dma_handle=%lx len=%x \n\r",dma_handle, cmd->request_bufflen));
                                DEBUG(qla2100_print(debug_buff)); */
#ifdef QL_DEBUG_LEVEL_5
                                qla2100_print(
                                "qla2x00_64bit_start_scsi: No scatter/gather command packet data - c");
                                qla2100_print("b");
                                qla2100_output_number((uint32_t)SCSI_BUS_32(cmd), 10);
                                qla2100_print("t");
                                qla2100_output_number((uint32_t)SCSI_TCN_32(cmd), 10);
                                qla2100_print("d");
                                qla2100_output_number((uint32_t)SCSI_LUN_32(cmd), 10);
                                qla2100_print("\n\r");
                                qla2100_dump_buffer((caddr_t)pkt, REQUEST_ENTRY_SIZE);
#endif
                            }
                        }
                        else                            /* No data transfer */
                        {
                            *dword_ptr++ = (uint32_t) 0;
                            *dword_ptr++ = (uint32_t) 0;
                            *dword_ptr = (uint32_t)  0;
#ifdef QL_DEBUG_LEVEL_5
                         qla2100_print(
                         "qla2x00_64bit_start_scsi: No data, command packet data - c");
                         qla2100_print("b");
                         qla2100_output_number((u_long)SCSI_BUS_32(cmd), 10);
                         qla2100_print("t");
                         qla2100_output_number((u_long)SCSI_TCN_32(cmd), 10);
                         qla2100_print("d");
                         qla2100_output_number((u_long)SCSI_LUN_32(cmd), 10);
                         qla2100_print("\n\r");
                         qla2x00_dump_buffer((caddr_t)pkt, REQUEST_ENTRY_SIZE);
#endif
                        }
                        DEBUG4(qla2100_print("\nqla2100_64bit_start_scsi: Wakeup RISC for pending command\n\r"));
                        /* Adjust ring index. */
                        ha->req_ring_index++;
                        if( ha->req_ring_index == REQUEST_ENTRY_CNT ) {
                            ha->req_ring_index = 0;
                            ha->request_ring_ptr = ha->request_ring;
                        } else
                            ha->request_ring_ptr++;

                        /* Set chip new ring index. */
#if WATCH_THREADS_SIZE
                        DEBUG3(qla2100_output_number((uint32_t)ha->actthreads, 16));
#endif
                        if (ha->device_id == QLA2300_DEVICE_ID) {
                           temp = CACHE_FLUSH(&reg2300->req_q_in);
                           WRT_REG_WORD(&reg2300->req_q_in, ha->req_ring_index);
                        } else {
                           temp = CACHE_FLUSH(&reg->mailbox4);
                           WRT_REG_WORD(&reg->mailbox4, ha->req_ring_index);
                        }
                    } else {
                        status = 1;
#ifdef QL_DEBUG_LEVEL_2
                        qla2100_print(
                        "qla2x00_64bit_start_scsi: NO ROOM IN OUTSTANDING ARRAY\n\r");
                        qla2100_print(" req_q_cnt=");
                qla2100_output_number((u_long)ha->req_q_cnt, 16);
#endif
                    }
                } else {
                    status = 1;
#ifdef QL_DEBUG_LEVEL_2
                    qla2100_print("qla2x00_64bit_start_scsi: in-ptr=");
            qla2100_output_number((u_long)ha->req_ring_index, 16);
            qla2100_print(" req_q_cnt=");
            qla2100_output_number((u_long)ha->req_q_cnt, 16);
            qla2100_print(" req_cnt=");
            qla2100_output_number((u_long)req_cnt, 16);
                    qla2100_print("\n\r");
#endif
                }

                /* Release ring specific lock */
                QLA2100_RING_UNLOCK(ha);

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                if( status )
                    qla2100_print("qla2x00_64bit_start_scsi: **** FAILED ****\n\r");
#endif
#ifdef QL_DEBUG_LEVEL_3
                else
                    qla2100_print("qla2x00_64bit_start_scsi: exiting normally\n\r");
#endif
                return(status);
            }
#endif

            /*
            * qla2100_32bit_start_scsi
            *      The start SCSI is responsible for building request packets on
            *      request ring and modifying ISP input pointer.
            *
            *      The Qlogic firmware interface allows every queue slot to have a SCSI
            *      command and up to 4 scatter/gather (SG) entries.  If we need more
            *      than 4 SG entries, then continuation entries are used that can
            *      hold another 7 entries each.  The start routine determines if there
            *      is eought empty slots then build the combination of requests to
            *      fulfill the OS request.
            *
            * Input:
            *      ha = adapter block pointer.
            *      sp = SCSI Request Block structure pointer.
            *
            * Returns:
            *      0 = success, was able to issue command.
            */
            STATIC uint8_t
            qla2100_32bit_start_scsi(scsi_qla_host_t *ha, srb_t *sp) {
                device_reg_t        *reg       = ha->iobase;
                device2300_reg_t    *reg2300   = ha->iobase2300;
                uint8_t         status = 0;
                Scsi_Cmnd       *cmd = sp->cmd;
                uint16_t        cdb_len, temp;
                uint32_t        cnt;
                cmd_entry_t     *pkt;
                uint16_t        req_cnt;
                uint16_t        seg_cnt;
                struct scatterlist    *sg = (struct scatterlist *) NULL;
                caddr_t         data_ptr;
                uint32_t        *dword_ptr;
                uint32_t        timeout;
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,18)
                uint64_t       dma_handle;
#endif

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_32bit_start_scsi"); 
#endif

#if defined(QL_DEBUG_LEVEL_5) || defined(QL_DEBUG_LEVEL_3)
                printk(
                          "32bit_start BEGIN: cmd=%x sp=%x CDB=%x\n\r",
                           cmd,sp,cmd->cmnd[0]);
#endif
#ifdef NEW
                /*
                * Send marker if required.
                */
                if (ha->marker_needed != 0) {
                    if (qla2200_marker(ha, 0, 0, MK_SYNC_ALL) != 0) {
                        RING_UNLOCK(ha);
                        return (1);
                    }
                }
#endif
                COMTRACE('S')
                /* Calculate number of entries and segments required. */
                seg_cnt = 0;
                req_cnt = 1;
                if( cmd->use_sg ) {
                    sg = (struct scatterlist *) cmd->request_buffer;
                    /* 4.10 32 bit S/G Data Transfer */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
                    seg_cnt =  cmd->use_sg;
#else
                    seg_cnt = pci_map_sg(ha->pdev,sg,cmd->use_sg, 
                              scsi_to_pci_dma_dir(cmd->sc_data_direction));
#endif
                    /*
                    * if greater than four sg entries then we need to allocate
                    * continuation entries
                    */
                    if( seg_cnt > 2 ) {
                        req_cnt += (uint16_t)(seg_cnt - 3) / 7;
                        if( (uint16_t)(seg_cnt - 3) % 7 )
                            req_cnt++;
                    }
                    DEBUG5(sprintf(debug_buff,
                    "S/G for data transfer -num segs(%d), req blk cnt(%d)\n\r",seg_cnt,req_cnt));
                    DEBUG5(qla2100_print(debug_buff));
                } else if( CMD_XFRLEN(cmd) )  /* If data transfer. */
                {  /* no S/G Data Transfer */
                   /*  DEBUG5(printk("Single data transfer (0x%x)\n",
                       cmd->request_bufflen));*/
                    seg_cnt = 1;
                }

                /* Acquire ring specific lock */
                QLA2100_RING_LOCK(ha);

                if( (uint16_t)(req_cnt + 2) >= ha->req_q_cnt ) {
                    /* Calculate number of free request entries. */
                    if (ha->device_id == QLA2300_DEVICE_ID)  
                      cnt = qla2100_debounce_register(&reg2300->req_q_out);
                    else   
                      cnt = qla2100_debounce_register(&reg->mailbox4);

                    if( ha->req_ring_index < cnt )
                        ha->req_q_cnt = cnt - ha->req_ring_index;
                    else
                        ha->req_q_cnt = REQUEST_ENTRY_CNT - (ha->req_ring_index - cnt);
                }

                DEBUG5(sprintf(debug_buff,
                 "Number of free entries = (%d)\n\r",ha->req_q_cnt));
                DEBUG5(qla2100_print(debug_buff));
                /* If room for request in request ring. */
                if( (uint16_t)(req_cnt + 2) < ha->req_q_cnt ) {
                    /* Check for room in outstanding command list. */
                    for( cnt = 1; cnt < MAX_OUTSTANDING_COMMANDS &&
                    (ha->outstanding_cmds[cnt] != 0); cnt++ )
                        ;

                    if( cnt < MAX_OUTSTANDING_COMMANDS ) {
                        ha->outstanding_cmds[cnt] = sp;
                        ha->req_q_cnt -= req_cnt;
                        /* save the handle -- helps if we want to abort it */
                        CMD_HANDLE(sp->cmd) = (unsigned char *) (u_long) cnt;

                        /*
                        * Build command packet.
                        */
                        pkt = (cmd_entry_t *)ha->request_ring_ptr;

                        pkt->entry_type = COMMAND_TYPE;
                        pkt->entry_count = (uint8_t)req_cnt;
                        pkt->sys_define = (uint8_t)ha->req_ring_index;
                        pkt->entry_status = 0;
                        pkt->control_flags= 0;
                        pkt->handle = (uint32_t)cnt;

                        /* Zero out remaining portion of packet. */
                        dword_ptr = (uint32_t *)pkt + 2;
                        for( cnt = 2; cnt < REQUEST_ENTRY_SIZE/4; cnt++ )
                            *dword_ptr++ = 0;

                        /*
                        * v2.19.8
                        * We subtract 5 sec. from the timeout value to insure
                        * the ISP time-out before the mid-level or the driver.
                        */
                        timeout = (uint32_t) CMD_TIMEOUT(cmd)/HZ;
                        if( timeout > 5 )
                            pkt->timeout = (uint16_t) timeout - 5;
                        else
                            pkt->timeout = (uint16_t) timeout;

                        /* Set device target ID and LUN */
                        pkt->target = TGT_Q(ha, 
                        SCSI_BUS_32(cmd), SCSI_TCN_32(cmd))->loop_id;
                        pkt->lun = SCSI_LUN_32(cmd);

                        /* Enable simple tag queuing if device supports it. */
                        if ( cmd->device->tagged_queue ) {
                            switch (cmd->tag) {
                                case SIMPLE_QUEUE_TAG:
                                    pkt->control_flags = CF_SIMPLE_TAG;
                                    break;
                                case HEAD_OF_QUEUE_TAG:
                                    pkt->control_flags = CF_HEAD_TAG;
                                    break;
                                case ORDERED_QUEUE_TAG:
                                    pkt->control_flags = CF_ORDERED_TAG;
                                    break;
                                default:
                                    pkt->control_flags = CF_SIMPLE_TAG;
                            }
                        } else
                            pkt->control_flags = CF_SIMPLE_TAG;

                       if (ha->device_id == QLA2300_DEVICE_ID)
                           pkt->control_flags |= CF_NO_FAST_POSTING; 

                        /* Load SCSI command packet. */
                        cdb_len = (uint16_t)CMD_CDBLEN(cmd);
                        if( cdb_len > MAX_CMDSZ )
                            cdb_len = MAX_CMDSZ;
                        data_ptr = (uint8_t *) &(CMD_CDBP(cmd));
                        for( cnt = 0; cnt < cdb_len; cnt++ )
                            pkt->scsi_cdb[cnt] = *data_ptr++;
                        DEBUG3(sprintf(debug_buff,
                        "qla2100: Packet has command[0]=0x%x, hndl=0x%x\n",pkt->scsi_cdb[0],pkt->handle);)
                        DEBUG3(qla2100_print(debug_buff);)
                        pkt->byte_count = (uint32_t) CMD_XFRLEN(cmd);

                        /*
                        * Load data segments.
                        */
                        if( seg_cnt ) {
                            /* Set transfer direction (READ and WRITE) */
                            /* Linux doesn't tell us                   */

                            switch( cmd->data_cmnd[0] ) {
                                case FORMAT_UNIT:
                                case WRITE_6:
                                case MODE_SELECT:
                                case SEND_DIAGNOSTIC:
                                case WRITE_10:
                                case WRITE_BUFFER:
                                case WRITE_LONG:
                                case WRITE_SAME:
                                case MODE_SELECT_10:
                                case WRITE_12:
                                case WRITE_VERIFY_12:
                                case SEND_VOLUME_TAG:
                                    pkt->control_flags |= BIT_6; /* WRITE */
                                    break;
                                default:
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
#if QLA_SCSI_VENDOR_DIR
    				    qla2100_set_vend_direction(ha, cmd, pkt);
#else
                                    pkt->control_flags |= BIT_5; /* READ */
#endif
#else  /* kernel version is 2.4.0 or higher */
                                    if (cmd->sc_data_direction == SCSI_DATA_WRITE)
                                        pkt->control_flags |= BIT_6;/*WRITE*/
                                    else 
                                        pkt->control_flags |= BIT_5;/*READ*/
#endif /* kernel version 2.4.0 */
                                    break;
                            }
                            sp->dir = pkt->control_flags & (BIT_5|BIT_6);

                            /* Set total data segment count. */
                            pkt->dseg_count = seg_cnt;

                            /* Setup packet address segment pointer. */
                            dword_ptr = (uint32_t *)&pkt->dseg_0_address;

                            if( cmd->use_sg )     /* If scatter gather */
                            {
                                DEBUG5(qla2100_print("Building S/G data segments..\n\r"));
                                DEBUG5(qla2100_dump_buffer((caddr_t)sg, 4*16));
                                /* Load command entry data segments. */
                                for( cnt = 0; cnt < 3 && seg_cnt; cnt++, seg_cnt-- ) {
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
                                   *dword_ptr++ = (uint32_t) cpu_to_le32(VIRT_TO_BUS(sg->address));
                                   *dword_ptr++ = sg->length;
                                   /* DEBUG(sprintf(debug_buff,
                                      "S/G Segment phys_addr=0x%x, len=0x%x\n\r",
                                       cpu_to_le32(VIRT_TO_BUS(sg->address)),sg->length));
                                       DEBUG(qla2100_print(debug_buff)); */
#else
                                   *dword_ptr++ = cpu_to_le32(pci_dma_lo32(sg_dma_address(sg)));
                                   *dword_ptr++ = cpu_to_le32(sg_dma_len(sg));
                                      /* DEBUG(sprintf(debug_buff,
                                      "S/G Segment phys_addr=0x%x, len=0x%x\n\r",
                                       cpu_to_le32(pci_dma_lo32(sg_dma_address(sg))),
                                       cpu_to_le32(sg_dma_len(sg)));)
                                       DEBUG(qla2100_print(debug_buff)); */
#endif
                                   sg++;
                                }
#ifdef QL_DEBUG_LEVEL_5
                                qla2100_print(
                                "qla2100_32bit_start_scsi: Scatter/gather command packet data - ");
                                qla2100_output_number((u_long)ha->host_no, 10);
                                qla2100_print(":");
                                qla2100_output_number((u_long)SCSI_BUS_32(cmd), 10);
                                qla2100_print(":");
                                qla2100_output_number((u_long)SCSI_TCN_32(cmd), 10);
                                qla2100_print(":");
                                qla2100_output_number((u_long)SCSI_LUN_32(cmd), 10);
                                qla2100_print("\n");
                                qla2100_dump_buffer((uint8_t *)pkt, REQUEST_ENTRY_SIZE);
#endif
                                /*
                                * Build continuation packets.
                                */
                                while( seg_cnt > 0 ) {
                                    /* Adjust ring index. */
                                    ha->req_ring_index++;
                                    if( ha->req_ring_index == REQUEST_ENTRY_CNT ) {
                                        ha->req_ring_index = 0;
                                        ha->request_ring_ptr = ha->request_ring;
                                    } else
                                        ha->request_ring_ptr++;

                                    pkt = (cmd_entry_t *)ha->request_ring_ptr;

                                    /* Zero out packet. */
                                    dword_ptr = (uint32_t *)pkt;
                                    for( cnt = 0;cnt < REQUEST_ENTRY_SIZE/4; cnt++ )
                                        *dword_ptr++ = 0;

                                    /* Load packet defaults. */
                                    ((cont_entry_t *)pkt)->entry_type = CONTINUE_TYPE;
                                    ((cont_entry_t *)pkt)->entry_count = 1;
                                    ((cont_entry_t *)pkt)->sys_define = (uint8_t)
                                    ha->req_ring_index;

                                    /* Setup packet address segment pointer. */
                                    dword_ptr = (uint32_t *)
                                    &((cont_entry_t *)pkt)->dseg_0_address;

                                    /* Load continuation entry data segments. */
                                    for( cnt = 0; cnt < 7 && seg_cnt; cnt++, seg_cnt-- ) {
                                       /* 4.10 32 bit */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
                                       *dword_ptr++ = (u_int) cpu_to_le32(VIRT_TO_BUS(sg->address));
                                       *dword_ptr++ = sg->length;
                                       /* DEBUG(sprintf(debug_buff,
                                       "S/G Segment Cont. phys_addr=0x%x, len=0x%x\n\r",
                                        cpu_to_le32(pci_dma_lo32(VIRT_TO_BUS(sg->address))),sg->length);)
                                        DEBUG(qla2100_print(debug_buff)); */
#else
                                       *dword_ptr++ = cpu_to_le32(pci_dma_lo32(sg_dma_address(sg)));
                                       *dword_ptr++ = cpu_to_le32(sg_dma_len(sg));
                                       /* DEBUG(sprintf(debug_buff,
                                       "S/G Segment Cont. phys_addr=0x%x, len=0x%x\n\r",
                                       cpu_to_le32(pci_dma_lo32(sg_dma_address(sg))),
                                       cpu_to_le32(sg_dma_len(sg)));)
                                       DEBUG(qla2100_print(debug_buff)); */
#endif
                                       sg++;
                                    }
#ifdef QL_DEBUG_LEVEL_5
                                    qla2100_print(
                                    "qla2100_32bit_start_scsi: continuation packet data - ");
                                    qla2100_output_number((u_long)ha->host_no, 10);
                                    qla2100_print(":");
                                    qla2100_output_number((u_long)SCSI_BUS_32(cmd), 10);
                                    qla2100_print(":");
                                    qla2100_output_number((u_long)SCSI_TCN_32(cmd), 10);
                                    qla2100_print(":");
                                    qla2100_output_number((u_long)SCSI_LUN_32(cmd), 10);
                                    qla2100_print("\n");
                                    qla2100_dump_buffer((uint8_t *)pkt,
                                    REQUEST_ENTRY_SIZE);
#endif
                                }
                            } else  /* No scatter gather data transfer */
                            {
                              /* 4.10 32 bit */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
                              *dword_ptr++ = (uint32_t) cpu_to_le32(VIRT_TO_BUS(cmd->request_buffer));
                              *dword_ptr = (uint32_t) cmd->request_bufflen;
#else
                              dma_handle = pci_map_single(ha->pdev, 
                                                          cmd->request_buffer,
                                                          cmd->request_bufflen,
                                                          scsi_to_pci_dma_dir(cmd->sc_data_direction));
                              sp->saved_dma_handle = dma_handle;

                              *dword_ptr++ = cpu_to_le32(pci_dma_lo32(dma_handle));
                              *dword_ptr   = (uint32_t) cmd->request_bufflen;
                              /* DEBUG(sprintf(debug_buff,
                              "32_bit: No S/G map_single dma_handle=%lx len=%x\n\r",dma_handle,cmd->request_bufflen));
                              DEBUG(qla2100_print(debug_buff)); */
#endif 
                              /* DEBUG5(printk("Single Segment ap=0x%x, len=0x%x\n",cmd->request_buffer,cmd->request_bufflen));*/

#ifdef QL_DEBUG_LEVEL_5
                              qla2100_print("qla2100_32bit_start_scsi: No scatter/gather command packet data - ");
                              qla2100_output_number((u_long)ha->host_no, 10);
                              qla2100_print(":");
                              qla2100_output_number((u_long)SCSI_BUS_32(cmd), 10);
                              qla2100_print(":");
                              qla2100_output_number((u_long)SCSI_TCN_32(cmd), 10);
                              qla2100_print(":");
                              qla2100_output_number((u_long)SCSI_LUN_32(cmd), 10);
                              qla2100_print("\n");
                              qla2100_dump_buffer((uint8_t *)pkt, REQUEST_ENTRY_SIZE);
#endif
                            }
                        }
                        else     /* No data transfer */
                        {
                            *dword_ptr++ = (uint32_t) 0;
                            *dword_ptr = (uint32_t)  0;
#ifdef QL_DEBUG_LEVEL_5
                    qla2100_print(
                    "qla2100_32bit_start_scsi: No data, command packet data - ");
                    qla2100_output_number((u_long)ha->host_no, 10);
                    qla2100_print(":");
                    qla2100_output_number((u_long)SCSI_BUS_32(cmd), 10);
                    qla2100_print(":");
                    qla2100_output_number((u_long)SCSI_TCN_32(cmd), 10);
                    qla2100_print(":");
                    qla2100_output_number((u_long)SCSI_LUN_32(cmd), 10);
                    qla2100_print("\n");
                    qla2100_dump_buffer((uint8_t *)pkt, REQUEST_ENTRY_SIZE);
#endif
                        }
                        /* Adjust ring index. */
                        ha->req_ring_index++;
                        if( ha->req_ring_index == REQUEST_ENTRY_CNT ) {
                            ha->req_ring_index = 0;
                            ha->request_ring_ptr = ha->request_ring;
                        } else
                            ha->request_ring_ptr++;

                        /* Set chip new ring index. */
                        DEBUG4(qla2100_print("\nqla2100_32bit_start_scsi: Wakeup RISC for pending command\n\r"));
                        ha->qthreads--;
                        sp->flags |= SRB_SENT;
                        sp->state = 0xde;
                        ha->actthreads++;

                     /* DEBUG(sprintf(debug_buff," Start(pid=%d) ",cmd->pid);)
                        DEBUG(qla2100_print(debug_buff);) */

#if WATCH_THREADS_SIZE
                DEBUG3(qla2100_output_number((u_long)ha->actthreads, 16)); 
#endif
                        if (ha->device_id == QLA2300_DEVICE_ID) {
                          temp = CACHE_FLUSH(&reg2300->req_q_in);
                          WRT_REG_WORD(&reg2300->req_q_in, ha->req_ring_index);
                        } else { 
                          temp = CACHE_FLUSH(&reg->mailbox4);
                          WRT_REG_WORD(&reg->mailbox4, ha->req_ring_index);
                        }
                    } else {
                        status = 1;
                        qla2100_stats.outarray_full++;
#ifdef QL_DEBUG_LEVEL_8
                        qla2100_print(
                        "qla2100_32bit_start_scsi: NO ROOM IN OUTSTANDING ARRAY\n");
#endif
                    }
                } else {
                    status = 1;
#ifdef QL_DEBUG_LEVEL_8
                    qla2100_print("qla2100_32bit_start_scsi: in-ptr=");
                    qla2100_output_number((u_long)ha->req_ring_index, 16);
                    qla2100_print(" req_q_cnt=");
                    qla2100_output_number((u_long)ha->req_q_cnt, 16);   
                    qla2100_print(" req_cnt=");
                    qla2100_output_number((u_long)req_cnt, 16);
                    qla2100_print("\n");
#endif
                }

                /* Release ring specific lock */
                QLA2100_RING_UNLOCK(ha);

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                if( status )
                      qla2100_print("qla2100_32bit_start_scsi: **** FAILED ****\n");
#ifdef QL_DEBUG_LEVEL_3
                else  qla2100_print("qla2100_32bit_start_scsi: exiting normally\n\n\r");
#endif
#endif
#ifdef QL_DEBUG_LEVEL_3
                LEAVE("qla2100_32bit_start_scsi"); 
#endif
                COMTRACE('s')
                return(status);
            }

            /*
            * qla2100_ms_req_pkt
            *      Function is responsible for locking ring and
            *      getting a zeroed out Managment Server request packet.
            *
            * Input:
            *      ha  = adapter block pointer.
            *      sp  = srb_t pointer to handle post function call
            * Returns:
            *      0 = failed to get slot.
            */
            STATIC request_t *
            qla2100_ms_req_pkt(scsi_qla_host_t *ha, srb_t  *sp) {
                device_reg_t     *reg     = ha->iobase;
                device2300_reg_t *reg2300 = ha->iobase2300;
                request_t    *pkt = 0;
                uint16_t     cnt,i;
                uint32_t     *dword_ptr;
                uint32_t     timer;

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_ms_req_pkt");
#endif

                /* Wait for 30 seconds for slot. */
                for( timer = 3000000; timer; timer-- ) {
                    /* Acquire ring specific lock */
                    QLA2100_RING_LOCK(ha);

                    if( !ha->req_q_cnt ) {
                        /* Calculate number of free request entries. */
                        if (ha->device_id == QLA2300_DEVICE_ID) cnt = qla2100_debounce_register(&reg2300->req_q_out);
                        else                                    cnt = qla2100_debounce_register(&reg->mailbox4);
                        if( ha->req_ring_index < cnt )
                            ha->req_q_cnt = cnt - ha->req_ring_index;
                        else
                            ha->req_q_cnt = REQUEST_ENTRY_CNT - (ha->req_ring_index - cnt);
                    }

                    /* Check for room in outstanding command list. */
                    for( cnt = 1; cnt < MAX_OUTSTANDING_COMMANDS &&
                    (ha->outstanding_cmds[cnt] != 0); cnt++ )
                        ;

                    if( (cnt < MAX_OUTSTANDING_COMMANDS) &&
                        ( ha->req_q_cnt != 0 )) {

                        pkt = ha->request_ring_ptr;

                        /* Zero out packet. */
                        dword_ptr = (uint32_t *)pkt;
                        for( i = 0; i < REQUEST_ENTRY_SIZE/4; i++ )
                            *dword_ptr++ = 0;

                        DEBUG(sprintf(debug_buff,
                          "qla2100_ms_req: putting sp=%x in outstanding_cmds[%x]\n",sp,cnt));
                        DEBUG(qla2100_print(debug_buff));

                        ha->outstanding_cmds[cnt] = sp;
                        /* save the handle */
                        CMD_HANDLE(sp->cmd) = (unsigned char *) (u_long) cnt;

                        ha->req_q_cnt--;
                        pkt->handle = (uint32_t)cnt;

                        /* Set system defined field. */
                        pkt->sys_define = (uint8_t)ha->req_ring_index;
                        pkt->entry_status = 0;

                        break;
                    }

                    /* Release ring specific lock */
                    QLA2100_RING_UNLOCK(ha);

                    SYS_DELAY(2);  

                    /* Check for pending interrupts. */
                    qla2100_poll(ha);
                }

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                if( !pkt )
                    qla2100_print("qla2100_ms_req_pkt: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
                else
                    LEAVE("qla2100_ms_req_pkt");
#endif
                return(pkt);
            }


            /*
            * qla2100_req_pkt
            *      Function is responsible for locking ring and
            *      getting a zeroed out request packet.
            *
            * Input:
            *      ha  = adapter block pointer.
            *
            * Returns:
            *      0 = failed to get slot.
            */
            STATIC request_t *
            qla2100_req_pkt(scsi_qla_host_t *ha) {
                device_reg_t     *reg     = ha->iobase;
                device2300_reg_t *reg2300 = ha->iobase2300;
                request_t    *pkt = 0;
                uint16_t     cnt;
                uint32_t     *dword_ptr;
                uint32_t     timer;

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_req_pkt");
#endif

                /* Wait for 30 seconds for slot. */
                for( timer = 3000000; timer; timer-- ) {
                    /* Acquire ring specific lock */
                    QLA2100_RING_LOCK(ha);

                    if( !ha->req_q_cnt ) {
                        /* Calculate number of free request entries. */
                        if (ha->device_id == QLA2300_DEVICE_ID) cnt = qla2100_debounce_register(&reg2300->req_q_out);
                        else                                    cnt = qla2100_debounce_register(&reg->mailbox4);
                        if( ha->req_ring_index < cnt )
                            ha->req_q_cnt = cnt - ha->req_ring_index;
                        else
                            ha->req_q_cnt = REQUEST_ENTRY_CNT - (ha->req_ring_index - cnt);
                    }

                    /* Found empty request ring slot? */
                    if( ha->req_q_cnt ) {
                        ha->req_q_cnt--;
                        pkt = ha->request_ring_ptr;

                        /* Zero out packet. */
                        dword_ptr = (uint32_t *)pkt;
                        for( cnt = 0; cnt < REQUEST_ENTRY_SIZE/4; cnt++ )
                            *dword_ptr++ = 0;

                        /* Set system defined field. */
                        pkt->sys_define = (uint8_t)ha->req_ring_index;

                        /* Set entry count. */
                        pkt->entry_count = 1;

                        break;
                    }

                    /* Release ring specific lock */
                    QLA2100_RING_UNLOCK(ha);

                    SYS_DELAY(2);   /* 10 */

                    /* Check for pending interrupts. */
                    qla2100_poll(ha);
                }

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                if( !pkt )
                    qla2100_print("qla2100_req_pkt: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
                else
                    LEAVE("qla2100_req_pkt");
#endif
                return(pkt);
            }

            /*
            * qla2100_isp_cmd
            *      Function is responsible for modifying ISP input pointer.
            *      Releases ring lock.
            *
            * Input:
            *      ha  = adapter block pointer.
            */
            STATIC void
            qla2100_isp_cmd(scsi_qla_host_t *ha) {
                device_reg_t     *reg     = ha->iobase;
                device2300_reg_t *reg2300 = ha->iobase2300;

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_isp_cmd");
#endif

#ifdef QL_DEBUG_LEVEL_5
                qla2100_print("qla2100_isp_cmd: IOCB data:\n");
                qla2100_dump_buffer((uint8_t *)ha->request_ring_ptr, REQUEST_ENTRY_SIZE);
#endif

                /* Adjust ring index. */
                ha->req_ring_index++;
                if( ha->req_ring_index == REQUEST_ENTRY_CNT ) {
                    ha->req_ring_index = 0;
                    ha->request_ring_ptr = ha->request_ring;
                } else
                    ha->request_ring_ptr++;

                /* Set chip new ring index. */
                if (ha->device_id == QLA2300_DEVICE_ID) WRT_REG_WORD(&reg2300->req_q_in, ha->req_ring_index);
                else                                    WRT_REG_WORD(&reg->mailbox4, ha->req_ring_index);

                /* Release ring specific lock */
                QLA2100_RING_UNLOCK(ha);

#ifdef QL_DEBUG_LEVEL_3
                LEAVE("qla2100_isp_cmd");
#endif
            }

            /*
            * qla2100_enable_lun
            *      Issue enable LUN entry IOCB.
            *
            * Input:
            *      ha = adapter block pointer.
            */
            STATIC void
            qla2100_enable_lun(scsi_qla_host_t *ha) {
                elun_entry_t *pkt;

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_enable_lun");
#endif

                /* Get request packet. */
                if( (pkt = (elun_entry_t *)qla2100_req_pkt(ha)) != NULL ) {
                    pkt->entry_type = ENABLE_LUN_TYPE;
                    pkt->command_count = 32;
                    pkt->immed_notify_count = 1;
                    pkt->timeout = 0xffff;

                    /* Issue command to ISP */
                    qla2100_isp_cmd(ha);
                }

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                if( !pkt )
                    qla2100_print("qla2100_enable_lun: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
                else
                    LEAVE("qla2100_enable_lun");
#endif
            }



#if QL2100_TARGET_MODE_SUPPORT
            /****************************************************************************/
            /*                      Target Mode Support Functions.                      */
            /****************************************************************************/


            /*
            * qla2100_notify_ack
            *      Issue notify acknowledge IOCB.
            *      If sequence ID is zero, acknowledgement of
            *      SCSI bus reset or bus device reset is assumed.
            *
            * Input:
            *      ha      = adapter block pointer.
            *      inotify = immediate notify entry pointer.
            */
            STATIC void
            qla2100_notify_ack(scsi_qla_host_t *ha, notify_entry_t *inotify) {
                nack_entry_t *pkt;

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_notify_ack: entered\n");
#endif

                /* Get request packet. */
                if( pkt = (nack_entry_t *)qla2100_req_pkt(ha) ) {
                    pkt->entry_type = NOTIFY_ACK_TYPE;
                    pkt->initiator_id = inotify->initiator_id;
                    pkt->target_id = inotify->target_id;

                    if( (pkt->status = inotify->status) == 0xe )
                        /* Reset LIP occurred. */
                        pkt->flags = OF_RESET;
                    else
                        /* Increment Immediate Notify Resource Count. */
                        pkt->flags = OF_INC_RC;

                    pkt->task_flags = inotify->task_flags;
                    pkt->seq_id = inotify->seq_id;

                    /* Issue command to ISP */
                    qla2100_isp_cmd(ha);
                }

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                if( !pkt )
                    qla2100_print("qla2100_notify_ack: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
                else
                    LEAVE("qla2100_notify_ack: exiting normally\n");
#endif
            }

            /*
            * qla2100_64bit_continue_io
            *      Issue continue target I/O IOCB.
            *
            * Input:
            *      ha   = adapter block pointer.
            *      atio = atio pointer.
            *      len  = total bytecount.
            *      addr = physical address pointer.
            */
            STATIC void
            qla2100_64bit_continue_io(scsi_qla_host_t *ha, atio_entry_t *atio, uint32_t len,
        u_long    *addr) {
                ctio_a64_entry_t *pkt;
                uint32_t         *dword_ptr;

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_64bit_continue_io: entered\n");
#endif

                /* Get request packet. */
                if( pkt = (ctio_a64_entry_t *)qla2100_req_pkt(ha) ) {
                    pkt->entry_type = CTIO_A64_TYPE;
                    pkt->initiator_id = atio->initiator_id;
                    pkt->exchange_id = atio->exchange_id;
                    pkt->flags = atio->flags | OF_FAST_POST;
                    pkt->scsi_status = atio->scsi_status;

                    if( len ) {
                        pkt->dseg_count = 1;
                        pkt->transfer_length = len;
                        pkt->dseg_0_length = len;
                        dword_ptr = (uint32_t *)addr;
                        pkt->dseg_0_address[0] = *dword_ptr++;
                        pkt->dseg_0_address[1] = *dword_ptr;
                    }

                    /* Issue command to ISP */
                    qla2100_isp_cmd(ha);
                }

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                if( !pkt )
                    qla2100_print("qla2100_64bit_continue_io: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
                else
                    LEAVE("qla2100_64bit_continue_io: exiting normally\n");
#endif
            }
            /*
            * qla2100_32bit_continue_io
            *      Issue continue target I/O IOCB.
            *
            * Input:
            *      ha   = adapter block pointer.
            *      atio = atio pointer.
            *      len  = total bytecount.
            *      addr = physical address pointer.
            */
            STATIC void
            qla2100_32bit_continue_io(scsi_qla_host_t *ha, atio_entry_t *atio, uint32_t len,
        u_long    *addr) {
                ctio_entry_t *pkt;
                uint32_t     *dword_ptr;

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_continue_io: entered\n");
#endif

                /* Get request packet. */
                if( pkt = (ctio_entry_t *)qla2100_req_pkt(ha) ) {
                    pkt->entry_type = CONTINUE_TGT_IO_TYPE;
                    pkt->initiator_id = atio->initiator_id;
                    pkt->exchange_id = atio->exchange_id;
                    pkt->flags = atio->flags | OF_FAST_POST;
                    pkt->scsi_status = atio->scsi_status;

                    if( len ) {
                        pkt->dseg_count = 1;
                        pkt->transfer_length = len;
                        pkt->dseg_0_length = len;
                        dword_ptr = (uint32_t *)addr;
                        pkt->dseg_0_address = *dword_ptr;
                    }

                    /* Issue command to ISP */
                    qla2100_isp_cmd(ha);
                }

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                if( !pkt )
                    qla2100_print("qla2100_32bit_continue_io: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
                else
                    LEAVE("qla2100_32bit_continue_io: exiting normally\n");
#endif
            }
#endif /* QL2100_TARGET_MODE_SUPPORT */



            /****************************************************************************/
            /*                        Interrupt Service Routine.                        */
            /****************************************************************************/

            /*
            *  qla2100_isr
            *      Calls I/O done on command completion.
            *
            * Input:
            *      ha           = adapter block pointer.
            *      done_q_first = done queue first pointer.
            *      done_q_last  = done queue last pointer.
            *      INTR_LOCK must be already obtained.
            */
            STATIC void
            qla2100_isr(scsi_qla_host_t *ha, srb_t **done_q_first, srb_t **done_q_last) {
                device_reg_t     *reg     = ha->iobase;
                device2300_reg_t *reg2300 = ha->iobase2300;
                response_t   *pkt, response_entry;
                srb_t        *sp;
                uint16_t     mailbox[MAILBOX_REGISTER_COUNT];
                uint16_t     *wptr, status2 = 0;
                uint32_t     index, longstatus, *dptr1, *dptr2;
                unsigned long cpu_flags = 0;

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_isr"); 
#endif
                if (ha->device_id != QLA2300_DEVICE_ID) { 
                    /* Check for 2100/2200 mailbox interrupt (semaphore set) */
                    longstatus = RD_REG_WORD(&reg->semaphore);
                    if (longstatus & BIT_0)     status2 = SEMAPHORE_SET;
                } else {
                    /* Get 2300's Interrupt Status byte */
                    longstatus = RD_REG_DWORD(&reg2300->host_status);
/*#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                    DEBUG(qla2100_print("qla2100_isr: +++ 2300 RISC_TO_HOST reg= ");)
                    DEBUG(qla2100_output_number((u_long)longstatus, 16);)
                    DEBUG(qla2100_print(" +++ \n");)
#endif */
                    switch(longstatus & 0xff) {
                      case 0x1:
                      case 0x2:
                      case 0x10:
                      case 0x11:
                      case 0x12:
                      case 0x14:
                      case 0x15:
                      case 0x16:
                      case 0x17:
                        status2 = SEMAPHORE_SET;
                        break;
                      case 0x13:
                      default:
                        status2 = 0;
                        break;
                    }
                }

                if ( status2 == SEMAPHORE_SET ) {

                    /* Get mailbox data. */
                    wptr    = &mailbox[0];
                    if (ha->device_id != QLA2300_DEVICE_ID) {
                      *wptr++ = qla2100_debounce_register(&reg->mailbox0);
                      *wptr++ = RD_REG_WORD(&reg->mailbox1);
                      *wptr   = RD_REG_WORD(&reg->mailbox2);
                    } else { 
                      *wptr++ = qla2100_debounce_register(&reg2300->mailbox0);
                      *wptr++ = RD_REG_WORD(&reg2300->mailbox1);
                      *wptr   = RD_REG_WORD(&reg2300->mailbox2);
                    }

                    WRT_REG_WORD(&reg->host_cmd, HC_CLR_RISC_INT);

#if defined(QL_DEBUG_LEVEL_4)
DEBUG(qla2100_print("qla2100_isr: SEMAPHORE SET Processing, mailbox[0]=");)
DEBUG(qla2100_output_number((u_long)mailbox[0], 16);)
DEBUG(qla2100_print(" \n");)
DEBUG(qla2100_print("qla2100_isr: mailbox[1]=");)
DEBUG(qla2100_output_number((u_long)mailbox[1], 16);)
DEBUG(qla2100_print(" \n");)
DEBUG(qla2100_print("qla2100_isr: mailbox[2]=");)
DEBUG(qla2100_output_number((u_long)mailbox[2], 16);)
DEBUG(qla2100_print(" \n");)
DEBUG(qla2100_print("qla2100_isr: mailbox[3]=");)
DEBUG(qla2100_output_number((u_long)mailbox[3], 16);)
DEBUG(qla2100_print(" \n");)
#endif 

#ifdef FC_IP_SUPPORT /*******************************************/
                    /* Handle IP send fast post */
                    if (mailbox[0] == MBA_IP_TRANSMIT_COMPLETE) {
                        SEND_CB *pSendCB;

                        /* Clear the semaphore lock , if it was set */
                        if (RD_REG_WORD(&reg->semaphore) & BIT_0)
                            WRT_REG_WORD(&reg->semaphore, 0);

                        /* Validate cmd handle and get packet pointer */
                        if (mailbox[1] < MAX_SEND_PACKETS) {
                            if ((pSendCB = (SEND_CB *)ha->apActiveIpQueue[mailbox[1]]) != NULL) {
                                ha->apActiveIpQueue[mailbox[1]] = NULL;

                                /* Complete backdoor command */
                                (*ha->pSendCompletionRoutine)(pSendCB);

                                return;
                            }
                        }

                        /* Invalid handle from RISC, reset RISC firmware */
                        printk(KERN_WARNING "qla2100_isr: bad IP send fast post handle %x\n",
                        mailbox[1]);
                        ha->flags.isp_abort_needed = TRUE;
                        return;
                    }

                    /* Handle IP receive fast post */
                    else if (mailbox[0] == MBA_IP_RECEIVE_COMPLETE ||
                    mailbox[0] == MBA_IP_RECEIVE_COMPLETE_SPLIT) {
                        PBUFFER_CB      pBufferCB, pNextBufferCB;
                        uint32_t        lTagVal;
                        uint32_t        lPacketSize;
                        uint32_t        lReceiveBufferSize;
                        volatile uint16_t *pNextMailbox;
                        uint16_t        wBufferCount;

                        pNextMailbox = &reg->mailbox10;

                        /* If split buffer, set header size for 1st buffer */
                        if (mailbox[0] == MBA_IP_RECEIVE_COMPLETE_SPLIT)
                            lReceiveBufferSize = ha->wHeaderSize;
                        else
                            lReceiveBufferSize = ha->lReceiveBufferSize;

                        if ((lTagVal = RD_REG_WORD(pNextMailbox)) >= ha->wReceiveBufferCount) {
                            goto InvalidIpBufferHandle;
                        }

                        pBufferCB = &ha->pReceiveBufferCBs[lTagVal];

                        if (!(pBufferCB->lFlags &  BCB_FLAGS_RISC_OWNS_BUFFER)) {
                            goto InvalidIpBufferHandle;
                        }

                        /* Set buffer belongs to driver now */
                        pBufferCB->lFlags &= ~BCB_FLAGS_RISC_OWNS_BUFFER;

                        lPacketSize = RD_REG_WORD(&reg->mailbox3);
                        pBufferCB->lPacketSize = lPacketSize;
                        pNextBufferCB = pBufferCB;

                        for (wBufferCount = 1; ; wBufferCount++) {
                            if (lPacketSize > lReceiveBufferSize) {
                                pNextBufferCB->lBufferSize = lReceiveBufferSize;
                                lPacketSize               -= lReceiveBufferSize;

                                /* If split buffer, only use header size on 1st buffer */
                                lReceiveBufferSize = ha->lReceiveBufferSize;

                                pNextMailbox++;
                                if ((lTagVal = RD_REG_WORD(pNextMailbox)) >=
                                ha->wReceiveBufferCount) {
                                    InvalidIpBufferHandle:
                                    printk(KERN_WARNING "qla2100_isr: bad IP receive fast post handle %x\n",
                                    lTagVal);
                                    ha->flags.isp_abort_needed = TRUE;
                                    return;
                                }

                                pNextBufferCB->pNextBufferCB = &ha->pReceiveBufferCBs[lTagVal];
                                pNextBufferCB = pNextBufferCB->pNextBufferCB;

                                if (!(pNextBufferCB->lFlags & BCB_FLAGS_RISC_OWNS_BUFFER)) {
                                    goto InvalidIpBufferHandle;
                                }

                                /* Set buffer belongs to driver now */
                                pNextBufferCB->lFlags &= ~BCB_FLAGS_RISC_OWNS_BUFFER;
                            } else {
                                pNextBufferCB->lBufferSize = lPacketSize;
                                pNextBufferCB->pNextBufferCB = NULL;
                                break;
                            }
                        }

                        /* Clear the semaphore lock , if it was set */
                        if (RD_REG_WORD(&reg->semaphore) & BIT_0)
                            WRT_REG_WORD(&reg->semaphore, 0);

                        /* Pass received packet to IP driver */
                        pBufferCB->wBufferCount = wBufferCount;

                        (*ha->pReturnReceivePacketsRoutine)
                        (ha->pReturnReceivePacketsContext,
                        pBufferCB);

                        /* Keep track of RISC buffer pointer (for IP reinit) */
                        ha->wIpBufferOut += wBufferCount;
                        if (ha->wIpBufferOut >= IP_BUFFER_QUEUE_DEPTH)
                            ha->wIpBufferOut -= IP_BUFFER_QUEUE_DEPTH;

                        return;
                    }
#endif /* FC_IP_SUPPORT ****************************************8*/

                    if( mailbox[0] != MBA_SCSI_COMPLETION ) {
#ifdef QL_DEBUG_LEVEL_4
                        qla2100_print("qla2100_isr: non MBA_SCSI_COMPLETION ; Saving mailbox data\n");
#endif
                        wptr++;
                        if (ha->device_id != QLA2300_DEVICE_ID) {
                          *wptr++ = RD_REG_WORD(&reg->mailbox3);
                          *wptr++ = qla2100_debounce_register(&reg->mailbox4);
                          *wptr++ = qla2100_debounce_register(&reg->mailbox5);
                          *wptr++ = RD_REG_WORD(&reg->mailbox6);
                          *wptr   = RD_REG_WORD(&reg->mailbox7);
                        } else {
                          *wptr++ = RD_REG_WORD(&reg2300->mailbox3);
                          *wptr++ = qla2100_debounce_register(&reg2300->mailbox4);
                          *wptr++ = qla2100_debounce_register(&reg2300->mailbox5);
                          *wptr++ = RD_REG_WORD(&reg2300->mailbox6);
                          *wptr   = RD_REG_WORD(&reg2300->mailbox7);
                        }
                    }

                    /* Clear the semaphore lock , if it was set */
                    if (RD_REG_WORD(&reg->semaphore) & BIT_0)
                        WRT_REG_WORD(&reg->semaphore, 0);

#ifdef QL_DEBUG_LEVEL_4
                    qla2100_print("qla2100_isr: +++ mailbox interrupt mailbox[0] = ");
                    qla2100_output_number((u_long)mailbox[0], 16);
                    qla2100_print("+++ \n");
 #endif 
                    /* Handle asynchronous (0x80xx) and 
                       mailbox command completion (0x400x) events */ 
                    switch( mailbox[0] ) {
                        case MBA_SCSI_COMPLETION:   /* 0x8020 */
                            if( ha->flags.online ) {
                                /* Get outstanding command index. */
                                index = (uint32_t)(mailbox[2] << 16 | mailbox[1]);
                                /* Validate handle. */
                                if( index < MAX_OUTSTANDING_COMMANDS ) {
                                    sp = ha->outstanding_cmds[index];
                                } else
                                    sp = 0;

                                if( sp ) {
                                    /* Free outstanding command slot. */
                                    ha->outstanding_cmds[index] = 0;

                                    /* Save ISP completion status */
                                    CMD_RESULT(sp->cmd) = DID_OK;
		                    /* v2.19.5b2 Reset port down retry on success. */
			            sp->port_down_retry_count = ha->port_down_retry_count;
        
                                    QLA2100_TIMER_LOCK(ha);
                                    ha->actthreads--;
                                    /* Place block on done queue */
                                    qla2100_stats.done_q_cnt++;
                                    DEBUG(sp->state = 3;)
                                    
                                    sp->s_next = NULL;
                                    sp->s_prev = *done_q_last;
                                    if( !(*done_q_first) )
                                        *done_q_first = sp;
                                    else
                                        (*done_q_last)->s_next = sp;
                                    *done_q_last = sp;
                                    QLA2100_TIMER_UNLOCK(ha);
                                } else {
#ifdef QL_DEBUG_LEVEL_2
                                    qla2100_print("qla2100_isr: ISP invalid handle\n");
#endif
                                    ha->flags.isp_abort_needed = TRUE;
                                }
                            }
                            break;
                        case MBA_RESET:                 /* Reset 0x8001*/
#ifdef QL_DEBUG_LEVEL_2
                            qla2100_print("qla2100_isr: asynchronous RESET\n");
#endif
                            ha->flags.reset_marker = TRUE;
                            break;
                        case MBA_SYSTEM_ERR:        /* System Error 0x8002 */
#ifdef QL_DEBUG_LEVEL_2
                            qla2100_print("qla2100_isr: ISP System Error - mbx1=");
                            qla2100_output_number((u_long)mailbox[1], 16);
                            qla2100_print(", mbx2=");
                            qla2100_output_number((u_long)mailbox[2], 16);
                            qla2100_print(", mbx3=");
                            qla2100_output_number((u_long)mailbox[3], 16);
                            qla2100_print("\n");
#endif
                            printk(KERN_WARNING
                            "!qla2100_isr: ISP System Error - mbx1=%xh, mbx2=%xh, mbx3=%xh",
                            mailbox[1], mailbox[2], mailbox[3]);
                            ha->flags.isp_abort_needed = TRUE;
                            break;
                        case MBA_REQ_TRANSFER_ERR:  /* Request Transfer Error */
#ifdef QL_DEBUG_LEVEL_2
                            qla2100_print("qla2100_isr: ISP Request Transfer Error\n");
#endif
                            printk(KERN_WARNING "qla2100: ISP Request Transfer Error\n");
                            ha->flags.isp_abort_needed = TRUE;
                            break;
                        case MBA_RSP_TRANSFER_ERR:  /* Response Transfer Error */
#ifdef QL_DEBUG_LEVEL_2
                            qla2100_print("qla2100_isr: ISP Response Transfer Error\n");
#endif
                            printk(KERN_WARNING "qla2100: ISP Response Transfer Error\n");
                            ha->flags.isp_abort_needed = TRUE;
                            break;
                        case MBA_WAKEUP_THRES:      /* Request Queue Wake-up */
#ifdef QL_DEBUG_LEVEL_2
                            qla2100_print("qla2100_isr: asynchronous WAKEUP_THRES\n");
#endif
                            break;
                        case MBA_LIP_OCCURRED:      /* Loop Initialization Procedure */
                            if(!qla2100_quiet) printk("scsi(%d): LIP occurred.\n",(int)ha->host_no);       
                            DEBUG(sprintf(debug_buff,"\n\nscsi(%d): LIP occurred.\n",(int)ha->host_no);)
                            DEBUG(qla2100_print(debug_buff));
#ifdef QL_DEBUG_LEVEL_2
                            qla2100_print(
                            "qla2100_isr: asynchronous MBA_LIP_OCCURRED\n");
#endif
		                    ha->dpc_flags = ha->dpc_flags | COMMAND_WAIT_NEEDED;
                            /* Save LIP sequence. */
                            ha->lip_seq = mailbox[1];
                            if( ha->loop_state != LOOP_DOWN ) {
                                    ha->loop_state = LOOP_DOWN;
                                    ha->loop_down_timer = LOOP_DOWN_TIME;
                            }
                            ha->lip_count++;
                            break;
                        case MBA_LOOP_UP:
                            printk("scsi(%d): LOOP UP detected\n",(int)ha->host_no);
#ifdef QL_DEBUG_LEVEL_2
                            qla2100_print("qla2100_isr: asynchronous MBA_LOOP_UP\n");
#endif
                            ha->loop_state = LOOP_UP;
                            break;
                        case MBA_LOOP_DOWN:
                            printk("scsi(%d): LOOP DOWN detected\n",(int)ha->host_no);
#ifdef QL_DEBUG_LEVEL_2
                            qla2100_print("qla2100_isr: asynchronous MBA_LOOP_DOWN\n");
#endif
		                    ha->dpc_flags = ha->dpc_flags | COMMAND_WAIT_NEEDED;
                            if( ha->loop_state != LOOP_DOWN ) {
                                    ha->loop_state = LOOP_DOWN;
                                    ha->loop_down_timer = LOOP_DOWN_TIME;
                            }
                            break;
                        case MBA_LIP_RESET:         /* LIP reset occurred. */
                            if(!qla2100_quiet) printk("scsi(%d): LIP reset occurred\n",(int)ha->host_no);
#ifdef QL_DEBUG_LEVEL_2
                            qla2100_print(
                            "qla2100_isr: asynchronous MBA_LIP_RESET\n");
#endif
		            ha->dpc_flags = ha->dpc_flags | COMMAND_WAIT_NEEDED;
                            ha->flags.reset_marker = TRUE;
                            ha->loop_down_timer = LOOP_DOWN_TIME;
                            ha->loop_state = LOOP_DOWN;
                            ha->operating_mode = LOOP;
                            break;
                        case MBA_LINK_MODE_UP:      /* Link mode up. */
                            DEBUG(printk("scsi(%d): Link node is up\n",(int)ha->host_no);)
#ifdef QL_DEBUG_LEVEL_2
                            qla2100_print(
                            "qla2100_isr: asynchronous MBA_LINK_MODE_UP\n");
#endif
		                    ha->dpc_flags = ha->dpc_flags | COMMAND_WAIT_NEEDED;
                            break;
                        case MBA_UPDATE_CONFIG:      /* Update Configuration. */
                            printk("scsi(%d): Configuration change detected: value %d.\n",(int)ha->host_no,mailbox[1]);
#ifdef QL_DEBUG_LEVEL_2
                            qla2100_print(
                            "qla2100_isr: asynchronous MBA_UPDATE_CONFIG\n");
#endif
                            ha->flags.update_config_needed = 1;
                            ha->loop_state = LOOP_DOWN;  /* dg - 03/30 */
                            ha->flags.isp_abort_needed = TRUE;
                            break;
                        case MBA_PORT_UPDATE:       /* Port database update occurred. */
                            DEBUG(printk("scsi(%d): Port database changed\n",(int)ha->host_no);)
#ifdef QL_DEBUG_LEVEL_2
                            qla2100_print(
                            "qla2100_isr: asynchronous MBA_PORT_UPDATE\n");
#endif
                            ha->loop_down_timer = 0;
                            ha->flags.loop_resync_needed = TRUE;
                            ha->loop_state = LOOP_UPDATE;
                            break;
                        case MBA_SCR_UPDATE:        /* State Change Registration. */
#ifdef QL_DEBUG_LEVEL_2
                            qla2100_print(
                            "qla2100_isr: asynchronous MBA_RSCR_UPDATE\n");
#endif
                            mailbox[1] = RD_REG_WORD(&reg->mailbox1);
                            mailbox[2] = RD_REG_WORD(&reg->mailbox2);

                            DEBUG(printk("scsi(%d): RSCN database changed - 0x%x,0x%x\n",(int)ha->host_no,mailbox[1],mailbox[2]);)
#ifdef RCSN
                            index = ha->rscn_in_ptr + 1;
                            if (index == MAX_RSCN_COUNT)
                                index = 0;
                            if (index != ha->rscn_out_ptr) {
                                    ha->rscn_queue[ha->rscn_in_ptr].format =
                                    MSB(mb[1]);
                                    ha->rscn_queue[ha->rscn_in_ptr].d_id.b.domain =
                                    LSB(mb[1]);
                                    ha->rscn_queue[ha->rscn_in_ptr].d_id.b.area =
                                    MSB(mb[2]);
                                    ha->rscn_queue[ha->rscn_in_ptr].d_id.b.al_pa =
                                    LSB(mb[2]);
                                    ha->rscn_in_ptr = (uint8_t)index;
                            } else {
                                    ha->device_flags |= RSCN_QUEUE_OVERFLOW;
                            }
#endif
                            ha->device_flags |= RSCN_UPDATE;
                            ha->loop_down_timer = 0;
                            ha->flags.loop_resync_needed = TRUE;
                            ha->loop_state = LOOP_UPDATE;
		         /*    ha->dpc_flags = ha->dpc_flags | COMMAND_WAIT_NEEDED; */
                            break;
                        case MBA_CTIO_COMPLETION:
#ifdef QL_DEBUG_LEVEL_2
                            qla2100_print(
                            "qla2100_isr: asynchronous MBA_CTIO_COMPLETION\n");
#endif
                            break;
                        default:
                            if( mailbox[0] < MBA_ASYNC_EVENT  /* 0x8000 */) {
                                    wptr = &mailbox[0];
                                    ha->mailbox_out[0] = *wptr++;
                                    ha->mailbox_out[1] = *wptr++;
                                    ha->mailbox_out[2] = *wptr++;
                                    ha->mailbox_out[3] = *wptr++;
                                    ha->mailbox_out[4] = *wptr++;
                                    ha->mailbox_out[5] = *wptr++;
                                    ha->mailbox_out[6] = *wptr++;
                                    ha->mailbox_out[7] = *wptr;
                                    ha->flags.mbox_int = TRUE;
#ifdef QL_DEBUG_LEVEL_2
if (mailbox[0] != 0x4000) {
                            qla2100_print("qla2100_isr: MBA Switch Default mailbox[0]= ");
                            qla2100_output_number(mailbox[0] , 16);
                            qla2100_print("\n");
}
#endif 
#ifdef QL_DEBUG_LEVEL_4
                                    qla2100_print("qla2100_isr: Setting flags.mbox_int=1 in Default mailbox[0]= ");
                                    qla2100_output_number(mailbox[0] , 16);
                                    qla2100_print("\n");
#endif
                            }
                            break;
                    } /* switch */
                } else { /* not a SEMAPHORE Set Completion */
                   if (ha->device_id != QLA2300_DEVICE_ID) 
                     mailbox[5]=qla2100_debounce_register(&reg->mailbox5);
                   else 
                     mailbox[5]=qla2100_debounce_register(&reg2300->rsp_q_in);

                    WRT_REG_WORD(&reg->host_cmd, HC_CLR_RISC_INT);
                    /*
                    * Response Ring Update
                    */
                    /* Clear mailbox busy flag for 2300s;
                       so we don't ignore its Respose Ring Updates 
                       during send of mailbox command */
                    if (ha->device_id == QLA2300_DEVICE_ID) 
                        ha->flags.mbox_busy = FALSE;

                    if( ha->flags.online && !(ha->flags.mbox_busy) ) { 
                        if( mailbox[5] < RESPONSE_ENTRY_CNT ) {
                            while( ha->rsp_ring_index != mailbox[5] ) {
                                pkt = ha->response_ring_ptr;

#ifdef QL_DEBUG_LEVEL_5
                                qla2100_print("qla2100_isr: ha->rsp_ring_index = ");
                                qla2100_output_number((u_long)ha->rsp_ring_index, 16);
                                qla2100_print(" mailbox[5] = ");
                                qla2100_output_number((u_long)mailbox[5], 16);
                                qla2100_print("\n");
                                qla2100_print("\nqla2100_isr: response packet data\n");
                                qla2100_dump_buffer((uint8_t *)pkt, RESPONSE_ENTRY_SIZE);
#endif

#ifdef FC_IP_SUPPORT /************************************************/
                                /* Handle IP send completion */
                                if (pkt->entry_type == ET_IP_COMMAND_64) {
                                    uint32_t            lTagVal;
                                    SEND_CB             *pSendCB;

                                    /* Set packet pointer from queue entry handle */
                                    if ((lTagVal = pkt->handle) < MAX_SEND_PACKETS) {
                                        if ((pSendCB = (SEND_CB *)ha->apActiveIpQueue[lTagVal]) != NULL) {
                                            ha->apActiveIpQueue[lTagVal] = NULL;

                                            /* Return send packet to IP driver */
                                            (*ha->pSendCompletionRoutine)(pSendCB);
                                        } else {
                                            /* Invalid handle from RISC, reset RISC firmware */
                                            printk(KERN_WARNING "qla2100_isr: bad IP send handle %x\n", lTagVal);
                                            ha->flags.isp_abort_needed = TRUE;
                                        }
                                    } else {
                                        /* Invalid handle from RISC, reset RISC firmware */
                                        printk(KERN_WARNING "qla2100_isr: bad IP send handle %x\n", lTagVal);
                                        ha->flags.isp_abort_needed = TRUE;
                                    }

                                    /* Adjust ring index. */
                                    ha->rsp_ring_index++;
                                    if( ha->rsp_ring_index == RESPONSE_ENTRY_CNT ) {
                                        ha->rsp_ring_index = 0;
                                        ha->response_ring_ptr = ha->response_ring;
                                    } else
                                        ha->response_ring_ptr++;
                                        if (ha->device_id != QLA2300_DEVICE_ID) 
                                             WRT_REG_WORD(&reg->mailbox5, ha->rsp_ring_index);
                                        else     
                                             WRT_REG_WORD(&reg2300->rsp_q_out, ha->rsp_ring_index);
                                    continue;
                                }

                                /* Handle IP receive packet */
                                else if (pkt->entry_type == ET_IP_RECEIVE) {
                                    PIP_RECEIVE_ENTRY   pIpReceiveEntry = (PIP_RECEIVE_ENTRY)pkt;
                                    PBUFFER_CB          pBufferCB, pNextBufferCB;
                                    uint32_t            lTagVal;
                                    uint32_t            lPacketSize;
                                    uint16_t            wBufferCount;
                                    uint32_t            lReceiveBufferSize;

                                    /* If split buffer, set header size for 1st buffer */
                                    if (pIpReceiveEntry->wCompletionStatus & IP_REC_STATUS_SPLIT_BUFFER)
                                        lReceiveBufferSize = ha->wHeaderSize;
                                    else
                                        lReceiveBufferSize = ha->lReceiveBufferSize;

                                    if ((lTagVal = pIpReceiveEntry->waBufferHandle[0]) >=
                                    ha->wReceiveBufferCount) {
                                        /* Invalid handle from RISC, reset RISC firmware */
                                        printk(KERN_WARNING "qla2100_isr: bad IP buffer handle %x\n", lTagVal);
                                        ha->flags.isp_abort_needed = TRUE;
                                        goto InvalidIpHandle;
                                    }
                                    pBufferCB = &ha->pReceiveBufferCBs[lTagVal];

                                    if (!(pBufferCB->lFlags &  BCB_FLAGS_RISC_OWNS_BUFFER)) {
                                        /* Invalid handle from RISC, reset RISC firmware */
                                        printk(KERN_WARNING "qla2100_isr: bad IP buffer handle %x\n", lTagVal);
                                        ha->flags.isp_abort_needed = TRUE;
                                        goto InvalidIpHandle;
                                    }

                                    /* Set buffer belongs to driver now */
                                    pBufferCB->lFlags &= ~BCB_FLAGS_RISC_OWNS_BUFFER;

                                    lPacketSize = pIpReceiveEntry->wSequenseLength;
                                    pBufferCB->lPacketSize = lPacketSize;
                                    pNextBufferCB = pBufferCB;

                                    for (wBufferCount = 1; ; wBufferCount++) {
                                        if (lPacketSize > lReceiveBufferSize) {
                                            pNextBufferCB->lBufferSize = lReceiveBufferSize;
                                            lPacketSize               -= lReceiveBufferSize;

                                            /* If split buffer, only use header size on 1st buffer */
                                            lReceiveBufferSize = ha->lReceiveBufferSize;

                                            if ((lTagVal = pIpReceiveEntry->waBufferHandle[wBufferCount]) >=
                                            ha->wReceiveBufferCount) {
                                                /* Invalid handle from RISC, reset RISC firmware */
                                                printk(KERN_WARNING "qla2100_isr: bad IP buffer handle %x\n", lTagVal);
                                                ha->flags.isp_abort_needed = TRUE;
                                                goto InvalidIpHandle;
                                            }
                                            pNextBufferCB->pNextBufferCB = &ha->pReceiveBufferCBs[lTagVal];;
                                            pNextBufferCB = pNextBufferCB->pNextBufferCB;

                                            if (!(pNextBufferCB->lFlags & BCB_FLAGS_RISC_OWNS_BUFFER)) {
                                                /* Invalid handle from RISC, reset RISC firmware */
                                                printk(KERN_WARNING "qla2100_isr: bad IP buffer handle %x\n", lTagVal);
                                                ha->flags.isp_abort_needed = TRUE;
                                                goto InvalidIpHandle;
                                            }

                                            /* Set buffer belongs to driver now */
                                            pNextBufferCB->lFlags &= ~BCB_FLAGS_RISC_OWNS_BUFFER;
                                        } else {
                                            pNextBufferCB->lBufferSize = lPacketSize;
                                            pNextBufferCB->pNextBufferCB = NULL;
                                            break;
                                        }
                                    }

                                    /* Check for incoming ARP packet with matching IP address */
                                    if (pIpReceiveEntry->wServiceClass == 0) {
                                        PPACKET_HEADER  pPacket = (PPACKET_HEADER)pBufferCB->pBuffer;
                                        PIP_DEVICE_BLOCK pIpDevice;
                                        uint8_t     acPortId[3];

                                        /* Scan list of IP devices to see if login needed */
                                        for (pIpDevice = ha->pIpDeviceTop; pIpDevice != NULL;
                                        pIpDevice = pIpDevice->pNextIpDevice) {
                                            if (*(uint16_t *)(&pIpDevice->acWorldWideName[2]) ==
                                            pPacket->sNetworkHeader.wSourceAddrHigh &&
                                            *(uint32_t *)(&pIpDevice->acWorldWideName[4]) ==
                                            pPacket->sNetworkHeader.lSourceAddrLow) {
                                                /* Device already in IP list, skip login */
                                                goto SkipDeviceLogin;
                                            }
                                        }

                                        /* Device not in list, need to do login */
                                        acPortId[0] = pIpReceiveEntry->cS_IDHigh;
                                        acPortId[1] = (uint8_t)(pIpReceiveEntry->wS_IDLow >> 8);
                                        acPortId[2] = (uint8_t)pIpReceiveEntry->wS_IDLow;

                                        /* Make sure its not a local device */
                                        if (acPortId[0] == ha->port_id[0] &&
                                        acPortId[1] == ha->port_id[1]) {
                                            goto SkipDeviceLogin;
                                        }

                                        if (qla2x00_add_new_ip_device(ha, PUBLIC_LOOP_DEVICE,
                                        acPortId,
                                        (uint8_t *)&pPacket->sNetworkHeader.wSourceNAA,
                                        TRUE) == QL_STATUS_FATAL_ERROR) {
                                            /* Fatal error, reinitialize */
                                            ha->flags.isp_abort_needed = TRUE;
                                        }
                                    }
                                    SkipDeviceLogin:
                                    /* Pass received packet to IP driver */
                                    pBufferCB->wBufferCount = wBufferCount;

                                    (*ha->pReturnReceivePacketsRoutine)
                                    (ha->pReturnReceivePacketsContext,
                                    pBufferCB);

                                    /* Keep track of RISC buffer pointer (for IP reinit) */
                                    ha->wIpBufferOut += wBufferCount;
                                    if (ha->wIpBufferOut >= IP_BUFFER_QUEUE_DEPTH)
                                        ha->wIpBufferOut -= IP_BUFFER_QUEUE_DEPTH;
                                    InvalidIpHandle:
                                    /* Adjust ring index. */
                                    ha->rsp_ring_index++;
                                    if( ha->rsp_ring_index == RESPONSE_ENTRY_CNT ) {
                                        ha->rsp_ring_index = 0;
                                        ha->response_ring_ptr = ha->response_ring;
                                    } else
                                        ha->response_ring_ptr++;
                                        if (ha->device_id != QLA2300_DEVICE_ID) 
                                            WRT_REG_WORD(&reg->mailbox5, ha->rsp_ring_index);
                                        else
                                            WRT_REG_WORD(&reg2300->rsp_q_out, ha->rsp_ring_index);
                                        continue;
                                }

                                /* Handle IP FARP request */
                                else if (pkt->entry_type == ET_IP_FARP_REQUEST) {
                                    PIP_FARP_REQUEST_ENTRY  pIpFarpRequestEntry;
                                    uint8_t                 acPortId[3];
                                    uint8_t                 acPortName[8];

                                    pIpFarpRequestEntry = (PIP_FARP_REQUEST_ENTRY)pkt;
                                    acPortId[0] = pIpFarpRequestEntry->cRequesterPortIdHigh;
                                    acPortId[1] = (uint8_t)(pIpFarpRequestEntry->wRequesterPortIdLow >> 8);
                                    acPortId[2] = (uint8_t)pIpFarpRequestEntry->wRequesterPortIdLow;
                                    acPortName[0] = pIpFarpRequestEntry->acRequesterPortName[7];
                                    acPortName[1] = pIpFarpRequestEntry->acRequesterPortName[6];
                                    acPortName[2] = pIpFarpRequestEntry->acRequesterPortName[5];
                                    acPortName[3] = pIpFarpRequestEntry->acRequesterPortName[4];
                                    acPortName[4] = pIpFarpRequestEntry->acRequesterPortName[3];
                                    acPortName[5] = pIpFarpRequestEntry->acRequesterPortName[2];
                                    acPortName[6] = pIpFarpRequestEntry->acRequesterPortName[1];
                                    acPortName[7] = pIpFarpRequestEntry->acRequesterPortName[0];

                                    /* Login and add device to IP database */
                                    if (qla2x00_add_new_ip_device(ha, PUBLIC_LOOP_DEVICE,
                                    acPortId,
                                    acPortName,
                                    TRUE) == QL_STATUS_FATAL_ERROR) {
                                        /* Fatal error, reinitialize */
                                        ha->flags.isp_abort_needed = TRUE;
                                    }

                                    /* Adjust ring index. */
                                    ha->rsp_ring_index++;
                                    if( ha->rsp_ring_index == RESPONSE_ENTRY_CNT ) {
                                        ha->rsp_ring_index = 0;
                                        ha->response_ring_ptr = ha->response_ring;
                                    } else
                                        ha->response_ring_ptr++;
                                        if (ha->device_id != QLA2300_DEVICE_ID) 
                                          WRT_REG_WORD(&reg->mailbox5, ha->rsp_ring_index);
                                        else
                                          WRT_REG_WORD(&reg2300->rsp_q_out, ha->rsp_ring_index);

                                    continue;
                                }
#endif /* FC_IP_SUPPORT *******************************************/

                                if( pkt->entry_type == STATUS_TYPE ||
                                    pkt->entry_status ) {
                                    ha->actthreads--; 
                                    if( pkt->entry_type == STATUS_TYPE ) {
                                        qla2100_status_entry(ha, (sts_entry_t *)pkt,
                                        done_q_first, done_q_last);
                                        /* DEBUG(printk("qla2100_isr: RespRingUpdate STATUS TYPE\n");) */
                                    } else {
                                        qla2100_error_entry(ha, pkt,
                                        done_q_first, done_q_last);
                                        /* DEBUG(printk("qla2100_isr: RespRingUpdate ERROR TYPE \n");)*/
                                    }
                                    /* Adjust ring index. */
                                    ha->rsp_ring_index++;
                                    if( ha->rsp_ring_index == RESPONSE_ENTRY_CNT ) {
                                        ha->rsp_ring_index = 0;
                                        ha->response_ring_ptr = ha->response_ring;
                                    } else
                                        ha->response_ring_ptr++;
                                        if (ha->device_id != QLA2300_DEVICE_ID) 
                                           WRT_REG_WORD(&reg->mailbox5, ha->rsp_ring_index);
                                        else
                                           WRT_REG_WORD(&reg2300->rsp_q_out, ha->rsp_ring_index);
                                } else {
                                    pkt = &response_entry;

                                    /* Copy packet. */
                                    dptr1 = (uint32_t *)ha->response_ring_ptr;
                                    dptr2 = (uint32_t *)pkt;
                                    for( index = 0; index < RESPONSE_ENTRY_SIZE/4;
                                    index++ )
                                        *dptr2++ = *dptr1++;

                                    /* Adjust ring index. */
                                    ha->rsp_ring_index++;
                                    if( ha->rsp_ring_index == RESPONSE_ENTRY_CNT ) {
                                        ha->rsp_ring_index = 0;
                                        ha->response_ring_ptr = ha->response_ring;
                                    } else
                                        ha->response_ring_ptr++;
                                        if (ha->device_id != QLA2300_DEVICE_ID) 
                                          WRT_REG_WORD(&reg->mailbox5, ha->rsp_ring_index);
                                        else
                                          WRT_REG_WORD(&reg2300->rsp_q_out, ha->rsp_ring_index);

                                    /* Release interrupt specific lock */
                                    QLA2100_INTR_UNLOCK(ha);

#if QLA2100_TARGET_MODE_SUPPORT
                                    switch( pkt->entry_type ) {
                                        case ACCEPT_TGT_IO_TYPE:
                                            qla2100_atio_entry(ha, (atio_entry_t *)pkt);
                                            break;
                                        case IMMED_NOTIFY_TYPE:
                                            qla2100_notify_ack(ha, (notify_entry_t *)pkt);
                                            break;
                                        default:
                                            break;
                                    }
#endif   /**** FC_TARGET_MODE_SUPPORT */

                                    /* Acquire interrupt specific lock */
                                    QLA2100_INTR_LOCK(ha);
                                }
                            }
                        } else {
                            ha->flags.isp_abort_needed = TRUE;
#ifdef QL_DEBUG_LEVEL_2
                            qla2100_print("qla2100_isr:  $$$ Response Pointer Error $$$ mb5=\n");
                            qla2100_output_number((u_long)mailbox[5], 16);
                            qla2100_print(" \n");
                            printk("qla2100_isr: Response pointer Error mailbox[5]=%x\n",mailbox[5]);
#endif
                        }
                    }  
                }

#ifdef QL_DEBUG_LEVEL_3
                LEAVE("qla2100_isr"); 
#endif
            }



            /*
            *  qla2100_rst_aen
            *      Processes asynchronous reset.
            *
            * Input:
            *      ha  = adapter block pointer.
            */
            STATIC void
            qla2100_rst_aen(scsi_qla_host_t *ha) {
#if QL2100_TARGET_MODE_SUPPORT
                notify_entry_t nentry;
#endif /* QL2100_TARGET_MODE_SUPPORT */

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_rst_aen");
#endif

                if( ha->flags.online && !ha->flags.reset_active &&
                !ha->loop_down_timer && !ha->flags.abort_isp_active ) {
                    ha->flags.reset_active = TRUE;
                    do {
                        ha->flags.reset_marker = FALSE;

                        /* Issue marker command. */
                        qla2100_marker(ha, 0, 0, 0, MK_SYNC_ALL);

#if QL2100_TARGET_MODE_SUPPORT
                        if( !ha->loop_down_timer && !ha->flags.reset_marker ) {
                            /* Issue notify acknowledgement command. */
                            BZERO((caddr_t)&nentry, sizeof(notify_entry_t));
                            nentry.initiator_id = ha->id;
                            /* dg 7/3/99 nentry.target_id = ha->id; */
                            nentry.task_flags = BIT_13;
                            qla2100_notify_ack(ha, &nentry);
                        }
#endif /* QL2100_TARGET_MODE_SUPPORT */
                    }while( !ha->loop_down_timer && ha->flags.reset_marker );
                    ha->flags.reset_active = FALSE;
                }

#ifdef QL_DEBUG_LEVEL_3
                LEAVE("qla2100_rst_aen");
#endif
            }

#if  QLA2100_TARGET_MODE_SUPPORT
            /*
            *  qla2100_atio_entry
            *      Processes received ISP accept target I/O entry.
            *
            * Input:
            *      ha  = adapter block pointer.
            *      pkt = entry pointer.
            */
            STATIC void
            qla2100_atio_entry(scsi_qla_host_t *ha, atio_entry_t *pkt) {
                uint64_t  *a64;
                uint64_t  *end_a64;
        u_long    phy_addr[2];
        u_long    end_addr[2];
                uint32_t  len;
                uint32_t  offset;
                uint8_t   t;
                uint8_t   *sense_ptr;

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_atio_entry: entered\n");
#endif

                t = pkt->initiator_id;
                sense_ptr = ha->tsense + t * TARGET_SENSE_SIZE;
                a64 = (uint64_t *)&phy_addr[0];
                end_a64 = (uint64_t *)&end_addr[0];

                switch( pkt->status & ~BIT_7 ) {
                    case 7:                         /* Path invalid */
#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                        qla2100_print("qla2100_atio_entry: Path invalid\n");
#endif
                        break;
                    case 0x16:                  /* Requested Capability Not Available */
#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                        qla2100_print(
                        "qla2100_atio_entry: Requested Capability Not Available\n");
#endif
                        break;
                    case 0x17:                  /* Bus Device Reset Message Received */
#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                        qla2100_print(
                        "qla2100_atio_entry: Bus Device Reset Message Received\n");
#endif
                        break;
                    case 0x3D:                  /* CDB Received */

                        /* Check for invalid LUN */
                        if( pkt->lun && pkt->cdb[0] != SS_INQUIR &&
                        pkt->cdb[0] != SS_REQSEN )
                            pkt->cdb[0] = SS_TEST;

                        switch( pkt->cdb[0] ) {
                        case SS_TEST:
#ifdef QL_DEBUG_LEVEL_3
                            qla2100_print("qla2100_atio_entry: SS_TEST\n");
#endif
                            BZERO(sense_ptr, TARGET_SENSE_SIZE);
                            len = 0;
                            if( pkt->lun == 0 )
                                pkt->scsi_status = S_GOOD;
                            else {
                                *sense_ptr = 0x70;
                                *(sense_ptr+2) = SD_ILLREQ;
                                *(sense_ptr+7) = TARGET_SENSE_SIZE-8;
                                *(sense_ptr+12) = SC_INVLUN;
                                pkt->scsi_status = S_CKCON;
                            }
                            pkt->flags = (uint16_t)(OF_SSTS | OF_INC_RC | OF_NO_DATA);
                            break;
                        case SS_REQSEN:
#ifdef QL_DEBUG_LEVEL_3
                            qla2100_print("qla2100_atio_entry: SS_REQSEN\n");
#endif
                            phy_addr[0] = ha->tsense_dma;
                            phy_addr[1] = 0;
                            *a64 += t * TARGET_SENSE_SIZE;
                            if( pkt->cdb[4] > TARGET_SENSE_SIZE )
                                len = TARGET_SENSE_SIZE;
                            else
                                len = pkt->cdb[4];
                            pkt->scsi_status = S_GOOD;
                            pkt->flags = (uint16_t)(OF_SSTS | OF_INC_RC | OF_DATA_IN);
                            break;
                        case SS_INQUIR:
#ifdef QL_DEBUG_LEVEL_3
                            qla2100_print("qla2100_atio_entry: SS_INQUIR\n");
#endif
                            BZERO(sense_ptr, TARGET_SENSE_SIZE);
                            phy_addr[0] = ha->tbuf_dma;
                            phy_addr[1] = 0;
                            *a64 += TARGET_INQ_OFFSET;

                            if( pkt->lun == 0 ) {
                                    ha->tbuf->inq.id_type = ID_PROCESOR;
                                    ha->tbuf->inq.id_pqual = ID_QOK;
                            } else {
                                    ha->tbuf->inq.id_type = ID_NODEV;
                                    ha->tbuf->inq.id_pqual = ID_QNOLU;
                            }

                            if( pkt->cdb[4] > sizeof(struct ident) )
                                len = sizeof(struct ident);
                            else
                                len = pkt->cdb[4];
                            pkt->scsi_status = S_GOOD;
                            pkt->flags = (uint16_t)(OF_SSTS | OF_INC_RC | OF_DATA_IN);
                            break;
                        case SM_WRDB:
                            BZERO(sense_ptr, TARGET_SENSE_SIZE);
                            offset = pkt->cdb[5];
                            offset |= pkt->cdb[4] << 8;
                            offset |= pkt->cdb[3] << 16;
                            len = pkt->cdb[8];
                            len |= pkt->cdb[7] << 8;
                            len |= pkt->cdb[6] << 16;
                            end_addr[0] = phy_addr[0] = ha->tbuf_dma;
                            end_addr[1] = phy_addr[1] = 0;
                            *end_a64 += TARGET_DATA_OFFSET + TARGET_DATA_SIZE;
                            switch( pkt->cdb[1] & 7 ) {
                                case RW_BUF_HDATA:
#ifdef QL_DEBUG_LEVEL_3
                                    qla2100_print("qla2100_atio_entry: SM_WRDB, RW_BUF_HDATA\n");
#endif
                                    if( len > TARGET_DATA_SIZE + 4 ) {
#ifdef QL_DEBUG_LEVEL_2
                                        qla2100_print("qla2100_atio_entry: SM_WRDB, length > buffer size\n");
#endif
                                        *sense_ptr = 0x70;
                                        *(sense_ptr+2) = SD_ILLREQ;
                                        *(sense_ptr+7) = TARGET_SENSE_SIZE-8;
                                        *(sense_ptr+12) = SC_ILLCDB;
                                        pkt->scsi_status = S_CKCON;
                                        pkt->flags = (uint16_t)(OF_SSTS | OF_INC_RC |
                                        OF_NO_DATA);
                                        len = 0;
                                    } else if( len ) {
                                            pkt->scsi_status = S_GOOD;
                                            pkt->flags =(uint16_t)(OF_SSTS | OF_INC_RC |
                                            OF_DATA_OUT);
                                    } else {
#ifdef QL_DEBUG_LEVEL_2
                                            qla2100_print("qla2100_atio_entry: SM_WRDB, zero length\n");
#endif
                                            pkt->scsi_status = S_GOOD;
                                            pkt->flags = (uint16_t)(OF_SSTS | OF_INC_RC |
                                            OF_NO_DATA);
                                    }

                                    break;
                                case RW_BUF_DATA:
#ifdef QL_DEBUG_LEVEL_3
                                    qla2100_print("qla2100_atio_entry: SM_WRDB, RW_BUF_DATA\n");
#endif
                                    *a64 += offset + TARGET_DATA_OFFSET;
                                    if( pkt->cdb[2] != 0 || *a64 >= *end_a64 ||
                                    *a64 + len > *end_a64 ) {
#ifdef QL_DEBUG_LEVEL_2
                                            qla2100_print("qla2100_atio_entry: SM_WRDB, RW_BUF_DATA BAD\n");
                                            qla2100_print("buf_id=");
                        qla2100_output_number((u_long)pkt->cdb[2], 16);
                        qla2100_print(", offset=");
                        qla2100_output_number((u_long)offset, 16);
                                            qla2100_print(", length=");
                        qla2100_output_number((u_long)len, 16);
                                            qla2100_print("\n");
#endif
                                            *sense_ptr = 0x70;
                                            *(sense_ptr+2) = SD_ILLREQ;
                                            *(sense_ptr+7) = TARGET_SENSE_SIZE-8;
                                            *(sense_ptr+12) = SC_ILLCDB;
                                            len = 0;
                                            pkt->scsi_status = S_CKCON;
                                            pkt->flags = (uint16_t)(OF_SSTS | OF_INC_RC |
                                            OF_NO_DATA);
                                    } else if( len ) {
                                            pkt->scsi_status = S_GOOD;
                                            pkt->flags =(uint16_t)(OF_SSTS | OF_INC_RC |
                                            OF_DATA_OUT);
                                    } else {
#ifdef QL_DEBUG_LEVEL_2
                                            qla2100_print("qla2100_atio_entry: SM_WRDB, zero length\n");
#endif
                                            pkt->scsi_status = S_GOOD;
                                            pkt->flags = (uint16_t)(OF_SSTS | OF_INC_RC |
                                            OF_NO_DATA);
                                    }
                                    break;
                                default:
#ifdef QL_DEBUG_LEVEL_2
                                    qla2100_print("qla2100_atio_entry: SM_WRDB unknown mode\n");
#endif
                                    *sense_ptr = 0x70;
                                    *(sense_ptr+2) = SD_ILLREQ;
                                    *(sense_ptr+7) = TARGET_SENSE_SIZE-8;
                                    *(sense_ptr+12) = SC_ILLCDB;
                                    len = 0;
                                    pkt->scsi_status = S_CKCON;
                                    pkt->flags = (uint16_t)(OF_SSTS | OF_INC_RC |
                                    OF_NO_DATA);
                                    break;
                            }
                            break;
                        case SM_RDDB:
                            BZERO(sense_ptr, TARGET_SENSE_SIZE);
                            offset = pkt->cdb[5];
                            offset |= pkt->cdb[4] << 8;
                            offset |= pkt->cdb[3] << 16;
                            len = pkt->cdb[8];
                            len |= pkt->cdb[7] << 8;
                            len |= pkt->cdb[6] << 16;
                            end_addr[0] = phy_addr[0] = ha->tbuf_dma;
                            end_addr[1] = phy_addr[1] = 0;
                            *end_a64 += TARGET_DATA_OFFSET + TARGET_DATA_SIZE;
                            switch( pkt->cdb[1] & 7 ) {
                                case RW_BUF_HDATA:
#ifdef QL_DEBUG_LEVEL_3
                                    qla2100_print("qla2100_atio_entry: SM_RDDB, RW_BUF_HDATA\n");
#endif
                                    if( len ) {
                                        ha->tbuf->hdr[0] = 0;
                                        ha->tbuf->hdr[1] =
                                        (uint8_t)(TARGET_DATA_SIZE >> 16);
                                        ha->tbuf->hdr[2] =
                                        (uint8_t)(TARGET_DATA_SIZE >> 8);
                                        ha->tbuf->hdr[3] = (uint8_t)TARGET_DATA_SIZE;
                                        if( len > TARGET_DATA_SIZE + 4 )
                                            len = TARGET_DATA_SIZE + 4;
                                        pkt->scsi_status = S_GOOD;
                                        pkt->flags = (uint16_t)(OF_SSTS | OF_INC_RC |
                                        OF_DATA_IN);
                                    } else {
#ifdef QL_DEBUG_LEVEL_2
                                            qla2100_print("qla2100_atio_entry: SM_RDDB, zero length\n");
#endif
                                            pkt->scsi_status = S_GOOD;
                                            pkt->flags = (uint16_t)(OF_SSTS | OF_INC_RC |
                                            OF_NO_DATA);
                                    }
                                    break;
                                case RW_BUF_DATA:
#ifdef QL_DEBUG_LEVEL_3
                                    qla2100_print("qla2100_atio_entry: SM_RDDB, RW_BUF_DATA\n");
#endif
                                    *a64 += offset + TARGET_DATA_OFFSET;
                                    if( pkt->cdb[2] != 0 || *a64 >= *end_a64 ) {
#ifdef QL_DEBUG_LEVEL_2
                                            qla2100_print("qla2100_atio_entry: SM_RDDB, RW_BUF_DATA BAD\n");
                                            qla2100_print("buf_id=");
                        qla2100_output_number((u_long)pkt->cdb[2], 16);
                        qla2100_print(", offset=");
                        qla2100_output_number((u_long)offset, 16);
                                            qla2100_print("\n");
#endif
                                            *sense_ptr = 0x70;
                                            *(sense_ptr+2) = SD_ILLREQ;
                                            *(sense_ptr+7) = TARGET_SENSE_SIZE-8;
                                            *(sense_ptr+12) = SC_ILLCDB;
                                            len = 0;
                                            pkt->scsi_status = S_CKCON;
                                            pkt->flags = (uint16_t)(OF_SSTS | OF_INC_RC |
                                            OF_NO_DATA);
                                    } else {
                                            if( *a64 + len > *end_a64 )
                                                len = *end_a64 - *a64;
                                            if( len ) {
                                                pkt->scsi_status = S_GOOD;
                                                pkt->flags = (uint16_t)(OF_SSTS |
                                                OF_INC_RC | OF_DATA_IN);
                                            } else {
#ifdef QL_DEBUG_LEVEL_2
                                                    qla2100_print("qla2100_atio_entry: SM_RDDB, zero length\n");
#endif
                                                    pkt->scsi_status = S_GOOD;
                                                    pkt->flags = (uint16_t)(OF_SSTS |
                                                    OF_INC_RC | OF_NO_DATA);
                                            }
                                    }
                                    break;
                                case RW_BUF_DESC:
#ifdef QL_DEBUG_LEVEL_3
                                    qla2100_print("qla2100_atio_entry: SM_RDDB, RW_BUF_DESC\n");
#endif
                                    if( len ) {
                                            if( len > 4 )
                                                len = 4;

                                            ha->tbuf->hdr[0] = 0;
                                            if( pkt->cdb[2] != 0 ) {
                                                ha->tbuf->hdr[1] = 0;
                                                ha->tbuf->hdr[2] = 0;
                                                ha->tbuf->hdr[3] = 0;
                                            } else {
                                                    ha->tbuf->hdr[1] =
                                                    (uint8_t)(TARGET_DATA_SIZE >> 16);
                                                    ha->tbuf->hdr[2] =
                                                    (uint8_t)(TARGET_DATA_SIZE >> 8);
                                                    ha->tbuf->hdr[3] =
                                                    (uint8_t)TARGET_DATA_SIZE;
                                            }
                                            pkt->scsi_status = S_GOOD;
                                            pkt->flags = (uint16_t)(OF_SSTS | OF_INC_RC |
                                            OF_DATA_IN);
                                    } else {
#ifdef QL_DEBUG_LEVEL_2
                                            qla2100_print("qla2100_atio_entry: SM_RDDB, zero length\n");
#endif
                                            pkt->scsi_status = S_GOOD;
                                            pkt->flags = (uint16_t)(OF_SSTS | OF_INC_RC |
                                            OF_NO_DATA);
                                    }
                                    break;
                                default:
#ifdef QL_DEBUG_LEVEL_2
                                    qla2100_print("qla2100_atio_entry: SM_RDDB unknown mode\n");
#endif
                                    *sense_ptr = 0x70;
                                    *(sense_ptr+2) = SD_ILLREQ;
                                    *(sense_ptr+7) = TARGET_SENSE_SIZE-8;
                                    *(sense_ptr+12) = SC_ILLCDB;
                                    len = 0;
                                    pkt->scsi_status = S_CKCON;
                                    pkt->flags = (uint16_t)(OF_SSTS | OF_INC_RC |
                                    OF_NO_DATA);
                                    break;
                            }
                            break;
                        default:
#ifdef QL_DEBUG_LEVEL_2
                            qla2100_print("qla2100_atio_entry: Unknown SCSI command\n");
                            qla2100_dump_buffer((uint8_t *)&pkt->cdb[0], MAX_CMDSZ);
#endif
                            BZERO(sense_ptr, TARGET_SENSE_SIZE);
                            *sense_ptr = 0x70;
                            *(sense_ptr+2) = SD_ILLREQ;
                            *(sense_ptr+7) = TARGET_SENSE_SIZE-8;
                            *(sense_ptr+12) = SC_INVOPCODE;
                            len = 0;
                            pkt->scsi_status = S_CKCON;
                            pkt->flags = (uint16_t)(OF_SSTS | OF_INC_RC | OF_NO_DATA);
                            break;
                        }
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,18)
                        if ( ha->flags.enable_64bit_addressing )
                            qla2100_64bit_continue_io(ha, pkt, len, &phy_addr);
                        else
#endif
                        qla2100_32bit_continue_io(ha, pkt, len, &phy_addr);
                        break;
                    default:
                        break;
                }

#ifdef QL_DEBUG_LEVEL_3
                LEAVE("qla2100_atio_entry: exiting normally\n");
#endif
            }
#endif  /* QLA2100_TARGET_MODE_SUPPORT */

            /*
            *  qla2100_status_entry
            *      Processes received ISP status entry.
            *
            * Input:
            *      ha           = adapter block pointer.
            *      pkt          = entry pointer.
            *      done_q_first = done queue first pointer.
            *      done_q_last  = done queue last pointer.
            */
            STATIC void
            qla2100_status_entry(scsi_qla_host_t *ha, sts_entry_t *pkt, srb_t **done_q_first,
            srb_t **done_q_last) {
                uint32_t       b, t, l;
                uint8_t        sense_sz = 0;
                srb_t          *sp, *sp2;
                scsi_lu_t      *q;
                Scsi_Cmnd       *cp;

#ifdef QL_DEBUG_LEVEL_3
                ENTER("qla2100_status_entry");
#endif
                /* Validate handle. */
                if( pkt->handle < MAX_OUTSTANDING_COMMANDS )
                    sp = ha->outstanding_cmds[pkt->handle];
                else
                    sp = 0;

                if( sp ) {
                    /* Free outstanding command slot. */
                    ha->outstanding_cmds[pkt->handle] = 0;
                    cp = sp->cmd;
                    sp->ccode = pkt->comp_status;
                    sp->scode = pkt->scsi_status;

                    /* Generate LU queue on cntrl, target, LUN */
                    b = SCSI_BUS_32(cp);
                    t = SCSI_TCN_32(cp);
                    l = SCSI_LUN_32(cp);
                    q = GET_LU_Q(ha, b, t, l);

                    /* Target busy */
                    if( pkt->scsi_status & SS_BUSY_CONDITION &&
                    (uint8_t)pkt->scsi_status != SS_RESERVE_CONFLICT ) {
#ifdef QL_DEBUG_LEVEL_2
                     qla2100_print("qla2100_status_entry: SCSI busy status, scsi(");
                qla2100_output_number((u_long)ha->host_no, 10);
                qla2100_print(":");
                qla2100_output_number((u_long)b, 10);
                qla2100_print(":");
                qla2100_output_number((u_long)t, 10);
                qla2100_print(":");
                qla2100_output_number((u_long)l, 10);
                        qla2100_print(")\n");
#endif
                        sp->retry_count--;
                        CMD_RESULT(cp) = (int) (DID_BUS_BUSY << 16) |
                        (pkt->scsi_status & 0xff);

                    }
#if 0
                    /* dg - 03/30      */
                    else if( ha->loop_down_timer  ) {
#endif
                        else if( ha->loop_down_timer ||
                        ha->loop_state != LOOP_READY ) {
#ifdef QL_DEBUG_LEVEL_3
                            qla2100_print("scsi(");
                qla2100_output_number((u_long)ha->host_no, 10);
                qla2100_print(":");
                qla2100_output_number((u_long)b, 10);
                qla2100_print(":");
                qla2100_output_number((u_long)t, 10);
                qla2100_print(":");
                qla2100_output_number((u_long)l, 10);
                qla2100_print("): Loop Not ready - pid =");
                qla2100_output_number((u_long)sp->cmd->pid, 16);
                            qla2100_print("\n");
#endif
                            CMD_RESULT(cp) = (int) (DID_BUS_BUSY << 16);
                        } else if( sp->port_down_retry_count > 1 &&
                        (pkt->comp_status == CS_PORT_UNAVAILABLE ||
                        pkt->comp_status == CS_PORT_LOGGED_OUT ||
                        pkt->comp_status == CS_PORT_CONFIG_CHG ||
                        pkt->comp_status == CS_PORT_BUSY) ) {
                            /* if the port is unavaliable and we haven't exceeded the port down count */
                            /* then send command back to the mid-level. */
#ifdef QL_DEBUG_LEVEL_5
                            qla2100_print("scsi(");
                qla2100_output_number((u_long)ha->host_no, 10);
                qla2100_print(":");
                qla2100_output_number((u_long)b, 10);
                qla2100_print(":");
                qla2100_output_number((u_long)t, 10);
                qla2100_print(":");
                qla2100_output_number((u_long)l, 10);
                            qla2100_print("): Port Down Retry (");
                qla2100_output_number((u_long)sp->port_down_retry_count, 10);
                            qla2100_print("): , pid =");
                qla2100_output_number((u_long)sp->cmd->pid, 16);
                            qla2100_print(", status =");
                qla2100_output_number((u_long)pkt->comp_status, 16);
                            qla2100_print("\n");
#endif
                            sp->port_down_retry_count--;

                            /* dg 08/17/99
                            * Force the SCSI layer to keep retrying until our
                            * port_down_retry_count expire. They will normally
                            * try and reset the bus after half the retries
                            * have completed, so double the count.
                            */
                            CMD_RESULT(sp->cmd) = DID_BUS_BUSY << 16;

                            /* Acquire target queue lock */
                            if( !(q->q_flag & QLA2100_QSUSP) ) {
                                q->q_flag |= QLA2100_QSUSP;  /* suspend starting new commands */

                                /* Decrement port down count on all pending commands. */
                                /* and return them back to OS.                        */
                                for( sp2 = q->q_first; sp2; sp2 = sp2->s_next ) {
                                    if( sp2->port_down_retry_count )
                                        sp2->port_down_retry_count--;
                                    /*  v2.19.14  - unconditionally retry these 
				     *	requests.
				     */
                                    CMD_RESULT(sp2->cmd) = DID_BUS_BUSY << 16;
                                    qla2100_callback(ha,sp2, TRUE);
                                }
                                q->q_first = q->q_last = NULL;
                                /* if port timer is not active then start it */
                                if( !ha->queue_restart_timer ) {
                                    ha->queue_restart_timer = PORT_RETRY_TIME;
                                }
                                if( TGT_Q(ha, b, t)->down_timer == 0 ) {
                		    TGT_Q(ha, b, t)->down_timer = 
                                        ha->port_down_retry_count * PORT_RETRY_TIME;
				}
                            }

                            /* Release LU queue specific lock */
                        } else {
#ifdef QL_DEBUG_LEVEL_2
                            if( pkt->comp_status ) {
                                qla2100_print(
                        "qla2100_status_entry: Compl error = ");
                    qla2100_output_number((u_long)pkt->comp_status, 16);
                                qla2100_print(", scsi(");
                    qla2100_output_number((u_long)ha->host_no, 10);
                    qla2100_print(":");
                    qla2100_output_number((u_long)b, 10);
                    qla2100_print(":");
                    qla2100_output_number((u_long)t, 10);
                    qla2100_print(":");
                    qla2100_output_number((u_long)l, 10);
                                qla2100_print("), retry count= ");
                    qla2100_output_number((u_long)sp->port_down_retry_count, 10);
                                qla2100_print(", pid = ");
                    qla2100_output_number((u_long)cp->pid, 16);
                                qla2100_print("\n");
                            }
#endif
                            /* Set ISP completion status and target status byte. */
                            CMD_RESULT(cp) = qla2100_return_status(ha, pkt, cp);

                            memset((caddr_t)cp->sense_buffer, 0,sizeof(cp->sense_buffer));
                            if( pkt->scsi_status & SS_CHECK_CONDITION ) {
                                /* Mid-level always zero sense buffer before giving it to us */
                                if( pkt->scsi_status & SS_SENSE_LEN_VALID ) {
                                    if( pkt->req_sense_length < CMD_SNSLEN(cp) )
                                        sense_sz = pkt->req_sense_length;
                                    else
                                        sense_sz = CMD_SNSLEN(cp) - 1;

                                    BCOPY((caddr_t)&pkt->req_sense_data, cp->sense_buffer, sense_sz);

                                }

#ifdef QL_DEBUG_LEVEL_2
                                qla2100_print(
                                "qla2100_status_entry: Check condition Sense data, scsi(");
                    qla2100_output_number((u_long)ha->host_no, 10);
                    qla2100_print(":");
                    qla2100_output_number((u_long)b, 10);
                    qla2100_print(":");
                    qla2100_output_number((u_long)t, 10);
                    qla2100_print(":");
                    qla2100_output_number((u_long)l, 10);
                                qla2100_print(")\n");
                                if( sense_sz )
                                    qla2100_dump_buffer(cp->sense_buffer, sense_sz);
#endif
                            }
                        }
                        /* Place command on done queue. */
                        qla2100_done_q_put(ha, sp, done_q_first, done_q_last);
                    } else {
#ifdef QL_DEBUG_LEVEL_2
                        qla2100_print("qla2100_status_entry: ISP Invalid handle\n");
#endif
                        printk(KERN_WARNING "!qla2100: Status Entry invalid handle");
                        ha->flags.isp_abort_needed = TRUE;
                    }
#ifdef QL_DEBUG_LEVEL_3
                    LEAVE("qla2100_status_entry");
#endif
                }

                /*
                *  qla2100_error_entry
                *      Processes error entry.
                *
                * Input:
                *      ha           = adapter block pointer.
                *      pkt          = entry pointer.
                *      done_q_first = done queue first pointer.
                *      done_q_last  = done queue last pointer.
                */
                STATIC void
                qla2100_error_entry(scsi_qla_host_t *ha, response_t *pkt, srb_t **done_q_first,
                srb_t **done_q_last) {
                    srb_t *sp;

#ifdef QL_DEBUG_LEVEL_3
                    ENTER("qla2100_error_entry");
#endif

#ifdef QL_DEBUG_LEVEL_2
                    if( pkt->entry_status & BIT_5 )
                        qla2100_print("qla2100_error_entry: Invalid Entry Order\n");
                    else if( pkt->entry_status & BIT_4 )
                        qla2100_print("qla2100_error_entry: Invalid Entry Count\n");
                    else if( pkt->entry_status & BIT_3 )
                        qla2100_print("qla2100_error_entry: Invalid Entry Parameter\n");
                    else if( pkt->entry_status & BIT_2 )
                        qla2100_print("qla2100_error_entry: Invalid Entry Type\n");
                    else if( pkt->entry_status & BIT_1 )
                        qla2100_print("qla2100_error_entry: Busy\n");
                    else
                        qla2100_print("qla2100_error_entry: UNKNOWN flag error\n");
#endif

                    /* Validate handle. */
                    if( pkt->handle < MAX_OUTSTANDING_COMMANDS )
                        sp = ha->outstanding_cmds[pkt->handle];
                    else
                        sp = 0;

                    if( sp ) {
                        /* Free outstanding command slot. */
                        ha->outstanding_cmds[pkt->handle] = 0;

                        /* Bad payload or header */
                        if( pkt->entry_status & (BIT_5 + BIT_4 + BIT_3 + BIT_2) ) {
                            /* Bad payload or header, set error status. */
                            CMD_RESULT(sp->cmd) = (int) DID_ERROR << 16;

                        } else if( pkt->entry_status & BIT_1 && sp->retry_count ) /* FULL flag */
                        {
                            sp->retry_count--;
                            CMD_RESULT(sp->cmd) = (int) DID_BUS_BUSY << 16;
                        } else {
                            /* Set error status. */
                            CMD_RESULT(sp->cmd) =(int)  DID_ERROR << 16;
                        }
                        /* Place command on done queue. */
                        qla2100_done_q_put(ha, sp, done_q_first, done_q_last);
                    } else if( pkt->entry_type == COMMAND_A64_TYPE ||
                    pkt->entry_type == COMMAND_TYPE ) {
#ifdef QL_DEBUG_LEVEL_2
                        qla2100_print("qla2100_error_entry: ISP Invalid handle\n");
#endif
                        printk(KERN_WARNING "!qla2100: Error Entry invalid handle");
                        ha->flags.isp_abort_needed = TRUE;
                    }

#ifdef QL_DEBUG_LEVEL_3
                    LEAVE("qla2100_error_entry");
#endif
                }

                /*
                *  qla2100_abort_isp
                *      Resets ISP and aborts all outstanding commands.
                *
                * Input:
                *      ha           = adapter block pointer.
                *
                * Returns:
                *      0 = success
                */
                STATIC uint8_t
                qla2100_abort_isp(scsi_qla_host_t *ha) {
                    uint16_t       cnt;
                    srb_t          *sp;
                    scsi_lu_t      *q;
                    uint32_t       b, t, l;
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,95)
                    unsigned long cpu_flags = 0;
#endif
                    uint8_t        status = 0;

                    ENTER("qla2100_abort_isp");

                    DRIVER_LOCK
                    ha->flags.isp_abort_needed = FALSE;
                    if( !ha->flags.abort_isp_active && ha->flags.online ) {
                        ha->flags.abort_isp_active = TRUE;
                        ha->flags.online = FALSE;
	                ha->dpc_flags &= ~COMMAND_WAIT_NEEDED;
	                ha->dpc_flags &= ~COMMAND_WAIT_ACTIVE;
                        qla2100_stats.ispAbort++;
                        ha->isp_aborts++; 
                        ha->sns_retry_cnt = 0;
                        printk(KERN_INFO
                        "qla2100: Performing ISP error recovery - ha= %p\n",
                         (void *) ha);
                        qla2100_reset_chip(ha);

                        if( ha->loop_state != LOOP_DOWN ) {
                            ha->loop_state = LOOP_DOWN;
                            ha->loop_down_timer = LOOP_DOWN_TIME;
                        }

#ifdef FC_IP_SUPPORT
                        /* Return all IP send packets */
                        for (cnt = 0; cnt < MAX_SEND_PACKETS; cnt++) {
                            if (ha->apActiveIpQueue[cnt] != NULL) {
                                (*ha->pSendCompletionRoutine)(ha->apActiveIpQueue[cnt]);

                                ha->apActiveIpQueue[cnt] = NULL;
                            }
                        }
#endif

                        /* Requeue all commands in outstanding command list. */
                        for( cnt = 1; cnt < MAX_OUTSTANDING_COMMANDS; cnt++ ) {
                            sp = ha->outstanding_cmds[cnt];
                            if( sp ) {
                                ha->outstanding_cmds[cnt] = 0;
                                /* Generate LU queue on controller, target, LUN */
                                b = SCSI_BUS_32(sp->cmd);
                                t = SCSI_TCN_32(sp->cmd);
                                l = SCSI_LUN_32(sp->cmd);
                                if ((q = (scsi_lu_t *)GET_LU_Q(ha, b, t, l))) {
                                    /* Reset outstanding command count. */
                                    q->q_outcnt = 0;
                                    q->q_flag &= ~QLA2100_QBUSY;
                                }
                                /* sp->flags &= ~(SRB_SENT | SRB_TIMEOUT); */
                                sp->flags = 0;
                                /* we need to send the command back to OS */
                                CMD_RESULT(sp->cmd) = DID_BUS_BUSY << 16;
                                CMD_HANDLE(sp->cmd) = (unsigned char *) NULL;
                                qla2100_done_q_put(ha, sp, (srb_t **)&ha->done_q_first, (srb_t **)&ha->done_q_last);
                            }
                        }

                        if( ha->device_id == QLA2100_DEVICE_ID )
                            qla2100_nvram_config(ha);
                        else
                            qla2200_nvram_config(ha);

						/* v2.19.12 */	
		        		ha->retry_count = ql2xretrycount;
                        if( !qla2100_configure_loop(ha, TRUE) ) {
                            ha->flags.reset_marker = FALSE;

                            if( !ha->loop_down_timer )
                                qla2100_marker(ha, 0, 0, 0, MK_SYNC_ALL);

                            ha->flags.online = TRUE;

                            /* Enable target response to SCSI bus. */
                            if( ha->flags.enable_target_mode )
                                qla2100_enable_lun(ha);

#ifdef FC_IP_SUPPORT
                            /* Reenable IP support */
                            if (ha->flags.enable_ip)
                                qla2x00_ip_initialize(ha);
#endif
                            /* Enable ISP interrupts. */
                            qla2100_enable_intrs(ha);

                            /* v2.19.5b6 Return all commands */
                            qla2100_abort_queues(ha, TRUE);
                            
                            /* Restart queues that may have been stopped. */
                            ha->flags.abort_isp_active = FALSE;
                            /* 6/9 if( !ha->loop_down_timer ) */
                                qla2100_restart_queues(ha,TRUE);
                        } else {
                            printk(KERN_WARNING
                            "qla2100: ISP error recovery failed, board disabled");
                            qla2100_reset_adapter(ha);
                            qla2100_abort_queues(ha, FALSE);
                        }
                    }

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                    if( status )
                        qla2100_print("qla2100_abort_isp: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
                    else
                        LEAVE("qla2100_abort_isp");
#endif
                    return(status);
                }
                /*
                *  qla2100_restart_watchdog_queue
                *      Restart device queues.
                *
                * Input:
                *      ha = adapter block pointer.
                */
                STATIC void
                qla2100_restart_watchdog_queue(scsi_qla_host_t *ha) {
                    srb_t  *sp, *sp_next;

                    for( sp = ha->retry_q_first; (sp); sp = sp_next ) {
                        sp_next = sp->s_next;
                        /* when time expire return request back to OS as BUSY */
                        qla2100_timeout_remove(ha, sp);
                        CMD_RESULT(sp->cmd) = DID_BUS_BUSY << 16;
                        CMD_HANDLE(sp->cmd) = (unsigned char *) NULL;
                        qla2100_done_q_put(ha, sp, (srb_t **)&ha->done_q_first, (srb_t **)&ha->done_q_last);
                    }

                }

                /*
                *  qla2100_restart_queues
                *      Restart device queues.
                *
                * Input:
                *      ha = adapter block pointer.
                */
                STATIC void
                qla2100_restart_queues(scsi_qla_host_t *ha, uint8_t flush) {
                    scsi_lu_t *q;
                    uint32_t  b, t, l;
                    srb_t  *sp, *sp_next;
                    srb_t        *done_q_first = (srb_t *) NULL;
                    srb_t        *done_q_last = (srb_t *) NULL;
                    int cnt;
                    unsigned long cpu_flags = 0;

#ifdef QL_DEBUG_LEVEL_3
                    ENTER("qla2100_restart_queues");
#endif

                    ha->flags.restart_queues_needed = FALSE;

                    /*
                    * start all queues working again.
                    */
                    for( b = 0; b < MAX_BUSES; b++ )
                        for( t = 0; t < ha->max_targets; t++ ) {
                            if( TGT_Q(ha, b, t)  == NULL )
                                continue;
                            for( l = 0; l < ha->max_luns; l++ ) {
                                q = (scsi_lu_t *) GET_LU_Q(ha, b, t, l);
                                if( q != NULL ) {
                                    q->q_flag &= ~QLA2100_QSUSP;
                                    if( q->q_first )
                                        qla2100_next(ha, q);
                                }
                            }
                        }

                        /*
                        * Clear out our retry queue
                        */
                        if( flush ) {
                            for( sp = ha->retry_q_first; (sp); sp = sp_next ) {
                                sp_next = sp->s_next;
                                /* when time expire return request back to OS as BUSY */
                                qla2100_timeout_remove(ha, sp);
                                CMD_RESULT(sp->cmd) = DID_BUS_BUSY << 16;
                                CMD_HANDLE(sp->cmd) = (unsigned char *) NULL;
                                qla2100_done_q_put(ha, sp, (srb_t **)&done_q_first, (srb_t **)&done_q_last);
                            }

                            /* Callback everything in done queue */
                    	    cnt = 0;
                            while( done_q_first ) {
                                QLA2100_TIMER_LOCK(ha);
                                /* remove command from done list */
                                sp = done_q_first;
                                if( !(done_q_first = sp->s_next) )
                                    done_q_last = NULL;
                                else
                                    (done_q_first)->s_prev = NULL;
                                cnt++;
                                qla2100_stats.done_q_cnt--;
                                DEBUG(sp->state = 5;)
                                QLA2100_TIMER_UNLOCK(ha);
                                /* DEBUG(sprintf(debug_buff,
                                  "qla2100_restart_queues: callback pid %d\n",
                                  sp->cmd->pid);)
                                  DEBUG(qla2100_print(debug_buff);) */
                                qla2100_callback(ha,sp,FALSE);
                            }
                            DEBUG(sprintf(debug_buff,"qla2100_restart_queues: callback %d commands.\n",cnt);)
                            DEBUG(qla2100_print(debug_buff);)
                      }

#ifdef QL_DEBUG_LEVEL_3
                            LEAVE("qla2100_restart_queues");
#endif
                }

                /*
                *  qla2100_abort_queues
                *      Abort all commands on device queues.
                *
                * Input:
                *      ha = adapter block pointer.
                */
                STATIC void
                qla2100_abort_queues(scsi_qla_host_t *ha, uint8_t doneqflg) {
                    scsi_lu_t   *q;
                    uint32_t    b, t, l;
                    srb_t       *sp, *sp_next;

#ifdef QL_DEBUG_LEVEL_3
                    ENTER("qla2100_abort_queues");
#endif
                    ha->flags.abort_queue_needed = FALSE;

                    for( b = 0; b < MAX_BUSES; b++ )
                        for( t = 0; t < ha->max_targets; t++ ) {
                            if( TGT_Q(ha, b, t) == NULL )
                                continue;
                            for( l = 0; l < MAX_LUNS; l++ ) {
                                q = GET_LU_Q(ha, b, t, l);
                                if( q != NULL ) {
                                    /* Try to acquire LU queue specific lock */
                                    /* if( queue is not busy )
                                    { */
                                    sp = q->q_first;
                                    q->q_first = q->q_last = NULL;

                                    while( sp ) {
                                        q->q_incnt--;
                                        sp_next = sp->s_next;
                                        CMD_RESULT(sp->cmd) = DID_BUS_BUSY << 16;
                                        if ( doneqflg ) {
                                            CMD_HANDLE(sp->cmd) = (unsigned char *) NULL;
                                            qla2100_done_q_put(ha, sp, (srb_t **)&ha->done_q_first, (srb_t **)&ha->done_q_last);
                                        } else
                                            qla2100_callback(ha,sp,FALSE);
                                        sp = sp_next;
                                    }
                                    /* }
                                    else
                                    ha->flags.abort_queue_needed = TRUE;
                                    */
                                }
                            }
                        }

#ifdef QL_DEBUG_LEVEL_3
                        LEAVE("qla2100_abort_queues");
#endif
                }

                /*
                *  qla2100_update_config
                *      Restart RISC in order to update the connection mode.
                *
                * Input:
                *      ha = adapter block pointer.
                *
                * Returns:
                *      0 = success
                */
                uint8_t
                qla2100_update_config(scsi_qla_host_t *ha) {
                    uint8_t   status = 0;

#ifdef QL_DEBUG_LEVEL_3
                    qla2100_print("qla2100_update_config: entered\n");
#endif
                    /* Turn-off flag, so we don't get called again */
                    ha->flags.update_config_needed = FALSE;

                    /* get the new topology */
                    qla2100_configure_hba(ha);

                    ha->init_cb->additional_firmware_options.connection_options = ha->operating_mode;
                    DEBUG(printk("qla2100_update_config: Setting new topology to %d\n" , ha->operating_mode);)

                    qla2100_reset_chip(ha);

                    if( ha->loop_state != LOOP_DOWN ) {
                        ha->loop_state = LOOP_DOWN;
                        ha->loop_down_timer = LOOP_DOWN_TIME;
                    }

                    if( !(status = qla2100_configure_loop(ha, TRUE)) ) {
                        ha->flags.reset_marker = FALSE;
                        if( !ha->loop_down_timer )
                            qla2100_marker(ha, 0, 0, 0, MK_SYNC_ALL);

                        ha->flags.online = TRUE;

                        /* Enable target response to SCSI bus. */
                        if( ha->flags.enable_target_mode )
                            qla2100_enable_lun(ha);

                    }

                    /* Enable ISP interrupts. */
                    qla2100_enable_intrs(ha);
                    /* WRT_REG_WORD(&reg->ictrl, ISP_EN_INT + ISP_EN_RISC); */
#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                    if( status )
                        qla2100_print("qla2100_update_config: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
                    else
                        qla2100_print("qla2100_update_config: exiting normally\n");
#endif
                    return(status);
                }

                /*
                *  qla2100_loop_resync
                *      Resync with fibre channel devices.
                *
                * Input:
                *      ha = adapter block pointer.
                *
                * Returns:
                *      0 = success
                */
                STATIC uint8_t
                qla2100_loop_resync(scsi_qla_host_t *ha) {
                    uint8_t   status;

#ifdef QL_DEBUG_LEVEL_3
                    ENTER("qla2100_loop_resync");
#endif

                    ha->loop_state = LOOP_UPDATE;
                    if( ha->flags.online && !ha->flags.loop_resync_active &&
                    !ha->flags.abort_isp_active ) {
                        ha->flags.loop_resync_active = TRUE;
                        if( !(status = qla2100_fw_ready(ha)) ) {
                            do {
                                ha->flags.loop_resync_needed = FALSE;
                                /* v2.19.05b6 */
                                ha->loop_state = LOOP_UPDATE;

                                /* Issue marker command. */
                                qla2100_marker(ha, 0, 0, 0, MK_SYNC_ALL);

                                /* Remap devices on Loop. */
                                qla2100_update_fc_db(ha, TRUE);

                            }while( !ha->loop_down_timer && ha->flags.loop_resync_needed );
                        }
                        ha->flags.loop_resync_active = FALSE;
                        /* v2.19 - we don't want to call this if we are already
                         * in the loop resync code
                         */
                        qla2100_restart_queues(ha,TRUE);
                    } else
                        status = 0;

                    /* Restart queues that may have been stopped. */
                    /* 04/10 if( !ha->loop_down_timer ) {
                        qla2100_restart_queues(ha,TRUE);
                    } */
                    /* v2.19 */ 
                    /* deleted qla2100_restart_queues(ha,TRUE); */

#if defined(QL_DEBUG_LEVEL_2) || defined(QL_DEBUG_LEVEL_3)
                    if( status )
                        qla2100_print("qla2100_loop_resync: **** FAILED ****\n");
#endif
#ifdef QL_DEBUG_LEVEL_3
                    else
                        LEAVE("qla2100_loop_resync");
#endif
                    return(status);
                }

                /*
                * qla2100_debounce_register
                *      Debounce register.
                *
                * Input:
                *      port = register address.
                *
                * Returns:
                *      register value.
                */
                STATIC uint16_t
                qla2100_debounce_register(volatile uint16_t *addr) {
                    volatile uint16_t ret;
                    volatile uint16_t ret2;

                    do {
                        ret = RD_REG_WORD(addr);
                        ret2 = RD_REG_WORD(addr);
                    }while( ret != ret2 );

                    return(ret);
                }
                
    /* qla2100_cmd_wait
    *	Stall driver until all outstanding commands are returned.
    *
    * Input:
    *	ha = adapter state pointer.
    *
    * Return;
    *  0 -- Done
    *  1 -- continue;
    *
    * Context:
    *	Kernel context.
    */
    STATIC uint8_t
    qla2100_cmd_wait(scsi_qla_host_t *ha) {
	    uint16_t index;
	    uint8_t stat = 1;

	    ENTER("qla2200_cmd_wait: started\n");

	    /* Wait for all outstanding commands to be returned. */
	    for (index = 1; index < MAX_OUTSTANDING_COMMANDS; index++) {
		    if (ha->outstanding_cmds[index] == NULL)
			    continue;
                
            /* if command not completed then wait for it */
            if (ha->flags.isp_abort_needed){
	        stat = 0;
                break;
            }
                
	    if( (ha->dpc_flags & COMMAND_WAIT_ACTIVE) &&
		 ha->cmd_wait_cnt-- == 0 ) {
                   ha->flags.isp_abort_needed = TRUE;
	           DEBUG(printk("qla2200_cmd_wait: ISP abort %d\n",index);)
	    } else {
    	       ha->cmd_wait_cnt = 30;
	       ha->dpc_flags |= COMMAND_WAIT_ACTIVE;
            }

	    DEBUG5( if( (ha->dpc_flags & COMMAND_WAIT_ACTIVE) ) )
	    DEBUG5(printk("qla2200_cmd_wait: on handle %d - cnt %d\n",index,ha->cmd_wait_cnt);)

            }

	if (index == MAX_OUTSTANDING_COMMANDS ||
            ha->flags.isp_abort_needed) {
	   ha->dpc_flags &= ~COMMAND_WAIT_NEEDED;
	   ha->dpc_flags &= ~COMMAND_WAIT_ACTIVE;
	   stat = 0;
        }
        return( stat );
    }

                /*
                * qla2100_reset_chip
                *      Reset ISP chip.
                *
                * Input:
                *      ha = adapter block pointer.
                */
                STATIC void
                qla2100_reset_chip(scsi_qla_host_t *ha) {
                    uint32_t     cnt;
                    device_reg_t *reg = ha->iobase;

#ifdef QL_DEBUG_LEVEL_3
                    ENTER("qla2100_reset_chip");
#endif

                    /* Disable ISP interrupts. */
                    qla2100_disable_intrs(ha);
                    /* WRT_REG_WORD(&reg->ictrl, 0); */

#if 1
                    /* Pause RISC. */
                    WRT_REG_WORD(&reg->host_cmd, HC_PAUSE_RISC);
                    for (cnt = 0; cnt < 30000; cnt++) {
                        if ((RD_REG_WORD(&reg->host_cmd) & HC_RISC_PAUSE) != 0)
                            break;
                        else
                            udelay(100);
                    }

                    /* Select FPM registers. */
                    WRT_REG_WORD(&reg->ctrl_status, 0x20);

                    /* FPM Soft Reset. */
                    WRT_REG_WORD(&reg->fpm_diag_config, 0x100);

                    /* Select frame buffer registers. */
                    WRT_REG_WORD(&reg->ctrl_status, 0x10);

                    /* Reset frame buffer FIFOs. */
                    WRT_REG_WORD(&reg->fb_cmd, 0xa000);

                    /* Select RISC module registers. */
                    WRT_REG_WORD(&reg->ctrl_status, 0);

                    /* Reset RISC module. */
                    WRT_REG_WORD(&reg->host_cmd, HC_RESET_RISC);

                    /* Reset ISP semaphore. */
                    WRT_REG_WORD(&reg->semaphore, 0);

                    /* Release RISC module. */
                    WRT_REG_WORD(&reg->host_cmd, HC_RELEASE_RISC);

                    /* Wait for RISC to recover from reset. */
                    for (cnt = 0; cnt < 30000; cnt++) {
                        if (RD_REG_WORD(&reg->mailbox0) != MBS_BUSY)
                            break;
                        else
                            udelay(100);
                    }

                    /* Disable RISC pause on FPM parity error. */
                    WRT_REG_WORD(&reg->host_cmd, HC_DISABLE_PARITY_PAUSE);
#else
                    /* Insure mailbox registers are free. */
                    WRT_REG_WORD(&reg->semaphore, 0);
                    WRT_REG_WORD(&reg->host_cmd, HC_CLR_RISC_INT);
                    WRT_REG_WORD(&reg->host_cmd, HC_CLR_HOST_INT);

                    /* clear mailbox busy */
                    ha->flags.mbox_busy = FALSE;

                    /* Reset ISP chip. */
                    WRT_REG_WORD(&reg->ctrl_status, ISP_RESET);

                    /*
                    * Delay after reset, for chip to recover.
                    * Otherwise causes system PANIC
                    */
                    mdelay(2);

                    for( cnt = 30000; cnt; cnt-- ) {
                        if( !(RD_REG_WORD(&reg->ctrl_status) & ISP_RESET) )
                            break;
                        udelay(100);
                    }

                    /* Reset RISC processor. */
                    WRT_REG_WORD(&reg->host_cmd, HC_RESET_RISC);
                    WRT_REG_WORD(&reg->host_cmd, HC_RELEASE_RISC);
                    for( cnt = 30000; cnt; cnt-- ) {
                        if( RD_REG_WORD(&reg->mailbox0) != MBS_BUSY )
                            break;
                        udelay(100);
                    }
#endif

#ifdef QL_DEBUG_LEVEL_3
                    LEAVE("qla2100_reset_chip");
#endif
                }
                
                
#ifdef RCSN
                /*
                * qla2100_device_resync
                *	Marks devices in the database that needs resynchronization.
                *
                * Input:
                *	ha = adapter block pointer.
                *
                * Context:
                *	Kernel context.
                */
                STATIC void
                qla2100_device_resync(scsi_qla_host_t *ha) {
                    uint16_t index;
                    uint32_t mask;
                    rscn_t dev;
                    port_id_t p;

                    ENTERT("qla2100_device_resync:");
                    while (ha->rscn_out_ptr != ha->rscn_in_ptr ||
                    ha->device_flags & RSCN_QUEUE_OVERFLOW) {
                        INTR_LOCK(ha);
                        BCOPY((void *)&ha->rscn_queue[ha->rscn_out_ptr], (void *)&dev,
                        sizeof (rscn_t));
                        ha->rscn_out_ptr++;
                        if (ha->rscn_out_ptr == MAX_RSCN_COUNT)
                            ha->rscn_out_ptr = 0;

                        /* Queue overflow, set switch default case. */
                        if (ha->device_flags & RSCN_QUEUE_OVERFLOW) {
                            dev.format = 3;
                            ha->device_flags = ha->device_flags & ~RSCN_QUEUE_OVERFLOW;
                        }

                        switch (dev.format) {
                            case 0:
                                mask = 0xffffff;
                                break;
                            case 1:
                                mask = 0xffff00;
                                break;
                            case 2:
                                mask = 0xff0000;
                                break;
                            default:
                                mask = 0x0;
                                dev.d_id.b24 = 0;
                                ha->rscn_out_ptr = ha->rscn_in_ptr;
                                break;
                        }
                        INTR_UNLOCK(ha);

                        for (index = 0; index < MAX_FIBRE_DEVICES; index++) {
                            p.b.b24 = dev.d_id.b24;
                            if (ha->fc_db[index].flags & DEV_PUBLIC &&
                            ha->fc_db[index].port_id[2] == p.r.port_id[2] &&
                            ha->fc_db[index].port_id[1] == p.r.port_id[1] &&
                            ha->fc_db[index].port_id[0] == p.r.port_id[0]  )
                                if (ha->fc_db[index].loop_id <= SNS_LAST_LOOP_ID)
                                    printk("qla2100_device_resync: %d:%d:%d\n",
                                    ha->fc_db[index].port_id[2] ,
                                    ha->fc_db[index].port_id[1] ,
                                    ha->fc_db[index].port_id[0] )
                                    ha->fc_db[index].flags |= DEV_MISSING;
                        }
                    }
                }

                LEAVE("qla2100_device_resync: exiting normally");
            }
#endif /* RCSN */

#ifdef   GET_PORT_INFO
            /*
            * qla2100_get_port_database
            *	Issue enhanced get port database mailbox command
            *	and copy device name as necessary.
            *
            * Input:
            *	ha = adapter state pointer.
            *	dev = structure pointer.
            *	opt = mailbox 1 option byte.
            *
            * Returns:
            *	qla2100 local function return status code.
            *
            * Context:
            *	Kernel context.
            */
            STATIC int
            qla2100_get_port_database(scsi_qla_host_t *ha, fcdev_t *dev, uint8_t opt) {
                int rval = 0;
                port_database_t *pd;
                u_long      phys_address = 0;
                uint16_t    mb[MAILBOX_REGISTER_COUNT];

                ENTER("qla2200_get_port_database:");
/* 4.10 */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
                pd = KMALLOC(PORT_DATABASE_SIZE);
                if ( pd != NULL ) {
                     phys_address = VIRT_TO_BUS(pd);
                     BZERO((caddr_t)pd, PORT_DATABASE_SIZE);
                }
#else
                pd  = pci_alloc_consistent(ha->pdev,
                                           PORT_DATABASE_SIZE,
                                           &phys_address);
                BZERO((caddr_t)pd, PORT_DATABASE_SIZE);
#endif
                if( pd  == NULL ) {
                    return 2;
                }
                BZERO((caddr_t)pd, PORT_DATABASE_SIZE);

                mb[0] = MBC_GET_PORT_DATABASE;
                mb[1] = dev->loop_id << 8 | opt;
                mb[2] = MSW(phys_address);
                mb[3] = LSW(phys_address);
                mb[6] = 0;
                mb[7] = 0;
                if( !qla2100_mailbox_command(ha,
                BIT_7|BIT_6|BIT_3|BIT_2|BIT_1|BIT_0,
                &mb[0]) ) {
                    /* Get d_id of device. */
                    /*
                    dev->d_id.b.al_pa = pd->port_id[2];
                    dev->d_id.b.area = pd->port_id[3];
                    dev->d_id.b.domain = pd->port_id[0];
                    dev->d_id.b.rsvd_1 = 0;
                    */

                    /* Get initiator status of device. */
                    pd->prli_svc_param_word_3[0] & BIT_5 ?
                    (dev->flags = dev->flags | DEV_INITIATOR) :
                    (dev->flags = dev->flags & ~DEV_INITIATOR);
                } else {
                    printk("qla2200_get_port_database: failed");
                    rval = 1;
                }
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,18)
                KMFREE(pd, PORT_DATABASE_SIZE);
#else
                pci_free_consistent(ha->pdev, PORT_DATABASE_SIZE,
                                    pd, phys_address);
#endif
                LEAVE("qla2200_get_port_database:");

                return (rval);
            }
#endif

            /*
            *  qla2100_configure_loop
            *      Resync with fibre channel devices.
            *
            * Input:
            *      ha = adapter block pointer.
            *
            * Returns:
            *      0 = success
            */

            STATIC uint8_t qla2100_configure_loop(scsi_qla_host_t *ha, uint8_t reuse) {
                uint8_t status = 0;

                /* If firmware needs to be loaded */
                if( qla2100_isp_firmware(ha) ) {
                    ha->flags.online = FALSE;
                    if( !(status = qla2100_chip_diag(ha)) )
                        status = qla2100_setup_chip(ha);
                }

                if( !status && !(status = qla2100_init_rings(ha)) ) {
                    if( !qla2100_fw_ready(ha) ) {
                        ha->flags.reset_marker = FALSE;
                        do {
                            ha->flags.loop_resync_needed = FALSE;
                            /* remap devices on loop */
                            qla2100_update_fc_db(ha, reuse);
                        }while( !ha->loop_down_timer && ha->flags.loop_resync_needed );
                    }
                }
                return(status);
            }

            /*
             * This routine will wait for fabric devices for
             * the reset delay.
             */ 
            void qla2100_check_fabric_devices(scsi_qla_host_t *ha) {
               uint16_t mb[MAILBOX_REGISTER_COUNT];

               mb[0] = MBC_GET_FIRMWARE_STATE;
               qla2100_mailbox_command(ha, BIT_0, &mb[0]);
            }

#if QLA2100_EXT_TIMEOUT
            /*
            * qla2100_extend_timeout
            *      This routine will extend the timeout to the specified value.
            *
            * Input:
            *      cmd = SCSI command structure
            *
            * Returns:
            *      None.
            */
            static void qla2100_extend_timeout(Scsi_Cmnd *cmd, int timeout) {
                del_timer(&cmd->eh_timeout);
                cmd->eh_timeout.expires = jiffies + timeout;
                add_timer(&cmd->eh_timeout);
            }
#endif
            /*
            * qla2100_display_fc_names
            *      This routine will the node names of the different devices found
            *      after port inquiry.
            *
            * Input:
            *      cmd = SCSI command structure
            *
            * Returns:
            *      None.
            */
            STATIC void qla2100_display_fc_names(scsi_qla_host_t *ha) {
                uint16_t	index;

                /* Display the node name for adapter */
                printk(KERN_INFO
                "scsi-qla%d-adapter-node=%02x%02x%02x%02x%02x%02x%02x%02x;\n",
                (int)ha->instance,
                ha->init_cb->node_name[0],
                ha->init_cb->node_name[1],
                ha->init_cb->node_name[2],
                ha->init_cb->node_name[3],
                ha->init_cb->node_name[4],
                ha->init_cb->node_name[5],
                ha->init_cb->node_name[6],
                ha->init_cb->node_name[7]);

                /* display the port name for adapter */
                printk(KERN_INFO
                "scsi-qla%d-adapter-port=%02x%02x%02x%02x%02x%02x%02x%02x;\n",
                (int)ha->instance,
                ha->init_cb->port_name[0],
                ha->init_cb->port_name[1],
                ha->init_cb->port_name[2],
                ha->init_cb->port_name[3],
                ha->init_cb->port_name[4],
                ha->init_cb->port_name[5],
                ha->init_cb->port_name[6],
                ha->init_cb->port_name[7]);

                /* Print out device port names */
                for (index = 0; index < MAX_FIBRE_DEVICES; index++) {
                    if (ha->fc_db[index].loop_id == PORT_UNUSED)
                        continue;

#if USE_PORTNAME
                    printk(KERN_INFO
                    "scsi-qla%d-target-%d=%08x%08x;\n",
                    (int)ha->instance, index,
                    ha->fc_db[index].wwn[1],
                    ha->fc_db[index].wwn[0]);
#else
                    printk(KERN_INFO
                    "scsi-qla%d-target-%d=%08x%08x;\n",
                    (int)ha->instance, index,
                    ha->fc_db[index].name[1],
                    ha->fc_db[index].name[0]);
#endif
                }
            }

            /*
            * qla2100_find_propname
            *	Get property in database.
            *
            * Input:
            *	ha = adapter structure pointer.
            *      db = pointer to database
            *      propstr = pointer to dest array for string
            *	propname = name of property to search for.
            *
            * Returns:
            *	0 = no property
            *  value = index of property value.
            *
            * Context:
            *	Kernel context.
            */
            STATIC uint8_t
            qla2100_find_propname(scsi_qla_host_t *ha,
            char *propname, char *propstr, char *db) {
                char	*np, *cp;
                int   i,k,l;

                /* find the specified string */
                for( l=0, cp = db; (*cp) && l < strlen(db) ; cp = np, l++ ) {
                    np = qla2100_get_line(cp, propstr);
                    DEBUG5(printk("qla2100_find_propname: %d - Searching for {%s} in cmd substr: {%s}, next line: {%s} \n",l,propname,propstr, np);)
                    /* find the property name */
                    k = strlen(propname);
                    for ( i = 0; (propstr[i]) && i < strlen(db); i++ ) {
                        if( strncmp(propname,&propstr[i],k) == 0) {
                            DEBUG5(printk("qla2100_find_propname: found at index = %d\n",i+k );)
                            return (i+k);   /* match */
                        }
                    }
                }
                return (0);
            }



            /*
            * qla2100_get_prop_16chars
            *	Get an 8-byte property value for the specified property name by
            *      converting from the property string found in the configuration file.
            *      The resulting converted value is in big endian format (MSB at byte0).
            *
            * Input:
            *	ha = adapter state pointer.
            *	propname = property name pointer.
            *	propval  = pointer to location for the converted property val.
            *      db = pointer to database
            *
            * Returns:
            *	0 = value returned successfully.
            *
            * Context:
            *	Kernel context.
            */
            static int
            qla2100_get_prop_16chars(scsi_qla_host_t *ha,  char *propname,
            char *propval, char *db) {
                char	*propstr;
                int		i, k;
                int		rval;
                uint8_t		nval;
                uint8_t		*pchar;
                uint8_t		*ret_byte;
                uint8_t		*tmp_byte;
                uint8_t		*retval = (uint8_t*)propval;
                uint8_t		tmpval[8] = {0, 0, 0, 0, 0, 0, 0, 0
                };
                uint16_t	max_byte_cnt = 8; /* 16 chars = 8 bytes */
                uint16_t	max_strlen = 16;
                char buf[LINESIZE];

                rval = qla2100_find_propname(ha, propname, buf, db);
                if( rval >= LINESIZE )
                    rval = 0;
                propstr = &buf[rval];
                if ( *propstr == '=' )
                    propstr++;   /* ignore equal sign */

                if (rval == 0 ) {
                    return (1);
		}

                if (strlen(propstr) != max_strlen) {
                    printk(KERN_INFO "qla2x00: Failed to find prop for %s - rval=%d, strlen(propstr)=%d->(16), val=%s.\n",
                    propname, rval, (int)strlen(propstr),propstr);
                    return (1);
                }

                /* Convert string to numbers. */

                pchar = (uint8_t *)propstr;
                tmp_byte = (uint8_t *)tmpval;

                rval = 0;
                for (i = 0; i < max_strlen; i++) {
                    /*
                    * Check for invalid character, two at a time,
                    * then convert them starting with first byte.
                    */

                    if ((pchar[i] >= '0') && (pchar[i] <= '9')) {
                        nval = pchar[i] - '0';
                    } else if ((pchar[i] >= 'A') && (pchar[i] <= 'F')) {
                        nval = pchar[i] - 'A' + 10;
                    } else if ((pchar[i] >= 'a') && (pchar[i] <= 'f')) {
                        nval = pchar[i] - 'a' + 10;
                    } else {
                        /* invalid character */
                        rval = 1;
                        break;
                    }

                    if (i & BIT_0) {
                        *tmp_byte = *tmp_byte | nval;
                        tmp_byte++;
                    } else {
                        *tmp_byte = *tmp_byte | nval << 4;
                    }
                }

                if (rval != 0) {
                    /* Encountered invalid character. */
                    return (rval);
                }

                /* Copy over the converted value. */

                ret_byte = retval;
                tmp_byte = tmpval;

                i = max_byte_cnt;
                k = 0;
                while (i--) {
                    /* *ret_byte++ = *tmp_byte++; */
                    ret_byte[k++] = tmp_byte[i];  /* 02/10/2000 */
                }

                /* big endian (retval[0]; */
                return (0);
            }

            /*
            * qla2100_get_properties
            *	Find all properties for the specified adapeter in
            *      command line.
            *
            * Input:
            *	ha = adapter block pointer.
            *	cmdline = pointer to command line string
            *
            * Context:
            *	Kernel context.
            */
            static void
            qla2100_get_properties(scsi_qla_host_t *ha, char *cmdline) {
                char		propbuf[LINESIZE];
                uint8_t         cnt, i;
                uint16_t	tgt;
                uint8_t		tmp_name[16];
#ifdef CHECK_BINDING
                uint8_t		tmp_name1[16];
#endif

                /* Adapter FC names. */
                sprintf(propbuf, "scsi-qla%d-adapter-node", (int) ha->instance);
#if 0
                qla2100_get_prop_16chars (ha, propbuf,
                	(caddr_t)(&ha->init_cb->node_name), cmdline);
#endif
                sprintf(propbuf, "scsi-qla%d-adapter-port", (int) ha->instance);
#ifdef CHECK_BINDING
                /* DG 04/07 check portname of adapter */
                qla2100_get_prop_16chars (ha, propbuf,
                	(caddr_t)(tmp_name1), cmdline);
                for (i = 0, cnt = 8; (cnt--); i++)
                    tmp_name[cnt] = tmp_name1[i];
                if (strncmp(&ha->init_cb->port_name[0], &tmp_name[0], 8) != 0) {
                    /* Inform users */
                    printk(KERN_WARNING
                    "qla2x00: qla%ld found mismatch in adapter port names.\n",
                    ha->instance);
                    printk(KERN_INFO
                    "       qla%ld port name found in NVRAM -> %02x%02x%02x%02x%02x%02x%02x%02x\n",
                    ha->instance,
                    ha->init_cb->port_name[0],
                    ha->init_cb->port_name[1],
                    ha->init_cb->port_name[2],
                    ha->init_cb->port_name[3],
                    ha->init_cb->port_name[4],
                    ha->init_cb->port_name[5],
                    ha->init_cb->port_name[6],
                    ha->init_cb->port_name[7]);
                    printk(KERN_INFO
                    "      qla%ld port name found on command line -> %02x%02x%02x%02x%02x%02x%02x%02x\n",
                    ha->instance,
                    tmp_name[0],
                    tmp_name[1],
                    tmp_name[2],
                    tmp_name[3],
                    tmp_name[4],
                    tmp_name[5],
                    tmp_name[6],
                    tmp_name[7]);
                    printk(KERN_INFO
                    "      Using port name from NVRAM.\n");
                    /* don't load it if mismatch */
                     return;
                }
#else
                qla2100_get_prop_16chars (ha, propbuf,
                	(caddr_t)(tmp_name), cmdline);
               /* swap bytes */
                for (i = 0, cnt = 8; (cnt--); i++)
                    ha->init_cb->port_name[cnt] = tmp_name[i];

                /* v2.19.5b3 qla2100_get_prop_16chars (ha, propbuf,
                (caddr_t)(&ha->init_cb->port_name), cmdline); */
#endif

                /* FC name for devices */
                for (tgt = 0; tgt < MAX_FIBRE_DEVICES; tgt++) { 
                    sprintf(propbuf, "scsi-qla%d-target-%d",
                    (int) ha->instance,  tgt);
                    if( !qla2100_get_prop_16chars
                    (ha, propbuf, (caddr_t)(&ha->fc_db[tgt].wwn), cmdline) ) {
                        ha->fc_db[tgt].loop_id = PORT_AVAILABLE;
                        ha->fc_db[tgt].flag = 0;  /* v2.19.05b3 */
                        ha->fc_db[tgt].flag |= DEV_CONFIGURED;
                        DEBUG(printk("Target %d - configured by user: ",tgt);)
                        DEBUG(printk("scsi-target=\"%08x%08x\"\n",
		              ha->fc_db[tgt].wwn[1],
                              ha->fc_db[tgt].wwn[0]);)/*ioctl support change*/
                    }
                }

            }
            /*
            * Declarations for load module
            */

/* 2.19.15 */
#ifndef FC_IP_SUPPORT
/************************************************************************/
/* qla2x00_reserve_loopid                                               */
/*    This routine reserves an unused public loop ID.                   */
/*                                                                      */
/* Arguments:                                                           */
/*    ha - adapter block pointer                                        */
/*    pLoopID   - pointer to word for returning loop ID                 */
/*                                                                      */
/* Return Value:                                                        */
/*    QL_STATUS_SUCCESS         if no error                             */
/*    QL_STATUS_RESOURCE_ERROR  if out of loop IDs                      */
/************************************************************************/

static int qla2x00_reserve_loopid(scsi_qla_host_t *ha, uint16_t *pLoopId)
{
    int     i;

    /* Look for unused loop ID */
    for (i = ha->min_external_loopid; i < ha->max_public_loop_ids; i++)
    {
        if (!ha->fabricid[i].in_use)
        {
            /* Found free loop ID */
            ha->fabricid[i].in_use = TRUE;
            *pLoopId = i;

            DEBUG(sprintf(debug_buff, "qla2x00_reserve_loopid: assigned loop ID %x\n\r", *pLoopId));
            DEBUG(qla2100_print(debug_buff));
            return QL_STATUS_SUCCESS;
        }
    }

    /* Out of loop IDs */
    *pLoopId = ha->max_public_loop_ids + 1;     /* Set out of range */
    DEBUG(qla2100_print("qla2x00_reserve_loopid: out of loop IDs\n\r"));
    return QL_STATUS_RESOURCE_ERROR;
} /* qla2x00_reserve_loopid */


/************************************************************************/
/* qla2x00_free_loopid                                                  */
/*    This routine frees a public loop ID.                              */
/*                                                                      */
/* Arguments:                                                           */
/*    ha - adapter block pointer                                        */
/*    wLoopID   - loop ID to free                                       */
/*                                                                      */
/* Return Value:                                                        */
/*    none                                                              */
/************************************************************************/

static void qla2x00_free_loopid(scsi_qla_host_t *ha, uint16_t wLoopId)
{
    if (wLoopId < ha->max_public_loop_ids)
    {
        ha->fabricid[wLoopId].in_use = FALSE;
        DEBUG(sprintf(debug_buff, "qla2x00_free_loopid: free loop ID %x\n\r", wLoopId));
        DEBUG(qla2100_print(debug_buff));
    }
    else
    {
        DEBUG(sprintf(debug_buff, "qla2x00_free_loopid: loop ID %x out of range\n\r", wLoopId));
        DEBUG(qla2100_print(debug_buff));
    }
} /* qla2x00_free_loopid */

			
/************************************************************************/
/* qla2x00_login_public_device                                          */
/*    This routine issues mailbox command to login fabric port.         */
/*                                                                      */
/* Arguments:                                                           */
/*    ha - adapter block pointer                                        */
/*    wLoopID   - public loop ID for device                             */
/*    pPortID   - pointer to port ID for fabric login                   */
/*    wOptions  - MBC_NO_PLOGI_IF_LOGGED_IN (bit 0)                     */
/*                MBC_NO_PROCESS_LOGIN (bit 1)                          */
/*                                                                      */
/* Return Value:                                                        */
/*    QL_STATUS_SUCCESS         if no error                             */
/*    QL_STATUS_ERROR           if any other error                      */
/*    QL_STATUS_RESOURCE_ERROR  if out of loop IDs                      */
/*    QL_STATUS_FATAL_ERROR     if fatal error                          */
/************************************************************************/

static int qla2x00_login_public_device(scsi_qla_host_t *ha,
                                       uint16_t *pLoopId,
                                       uint8_t  *pPortID,
                                       uint16_t wOptions)
{
    int         status = QL_STATUS_SUCCESS;
    int         wRetryCount;
    uint16_t    mb[MAILBOX_REGISTER_COUNT];

    /* Set retry count */
    wRetryCount = 2;

    while (wRetryCount--)
    {
        DEBUG(sprintf(debug_buff, "qla2x00_login_public_device: login loop ID: %x  port ID: %x, option: %x\n\r",
        *pLoopId, *pPortID << 16 | *(pPortID+1) << 8 | *(pPortID+2), wOptions ));
        DEBUG(qla2100_print(debug_buff));

        /* Issue fabric login request */
        mb[0] = MBC_LOGIN_FABRIC_PORT;
        mb[1] = (uint16_t)(*pLoopId << 8 | (wOptions & 0x00FF));
        mb[2] = (uint16_t)(*pPortID);
        mb[3] = (uint16_t)(*(pPortID+1) << 8 | *(pPortID+2));
        if (qla2100_mailbox_command(ha, BIT_3|BIT_2|BIT_1|BIT_0, &mb[0]) == 0)
        {
            /* Login successful */
            status = QL_STATUS_SUCCESS;
            break;
        }

        /* Login failed, check status */
        if (mb[0] == MBS_FATAL_ERROR)
        {
            DEBUG(qla2100_print("qla2x00_login_public_device: LOGIN_FABRIC_PORT fatal error\n\r"));
            status = QL_STATUS_FATAL_ERROR;
            break;
        }
        else if (mb[0] == MBS_LOOP_ID_IN_USE)
        {
            DEBUG(sprintf(debug_buff, "qla2x00_login_public_device: loop ID %x in use by port ID %x (4008)\n\r",
                     *pLoopId, mb[1] << 16 | mb[2]));
            DEBUG(qla2100_print(debug_buff));

            /* Allocate another loop ID and retry */
            if ((status = qla2x00_reserve_loopid(ha, pLoopId)) == QL_STATUS_SUCCESS)
            {
                wRetryCount++;
            }
            else
            {
                break;
            }
        }
        else if (mb[0] == MBS_PORT_ID_IN_USE)
        {
            DEBUG(sprintf(debug_buff, "qla2x00_login_public_device: port ID already assigned to loop ID %x (4007)\n\r",
                     mb[1]));
            DEBUG(qla2100_print(debug_buff));

            /* Free loop ID and use one assigned by RISC */
            qla2x00_free_loopid(ha, *pLoopId);
            *pLoopId = mb[1];

            /* Must reissue login mailbox command with new loop ID */
            wRetryCount++;
        }
        else
        {
            DEBUG(sprintf(debug_buff, "qla2x00_login_public_device: login error status %x, MB1: %x, MB2: %x\n\r",
                     mb[0], mb[1], mb[2]));
            DEBUG(qla2100_print(debug_buff));
            status = QL_STATUS_ERROR;
        }
    }
    return(status);
} /* qla2x00_login_public_device */


#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
#ifdef MODULE
Scsi_Host_Template driver_template = QLA2100_LINUX_TEMPLATE;
#include "scsi_module.c"
#endif
#else   /* new kernel scsi initialization scheme */
static  Scsi_Host_Template driver_template = QLA2100_LINUX_TEMPLATE;
#include "scsi_module.c"
#endif

#ifdef QL_DEBUG_ROUTINES
/****************************************************************************/
/*                         Driver Debug Functions.                          */
/****************************************************************************/

            /*
            *  Get byte from I/O port
            */
            STATIC uint8_t
            qla2100_getbyte(uint8_t *port) {
                uint8_t ret;

#ifdef MEMORY_MAPPED_IO
                ret = *port;
#else
                ret = inb((int)port);
#endif

                if( ql2x_debug_print ) {
                    qla2100_print("qla2100_getbyte: address = ");
            qla2100_output_number((u_long)port, 16);
            qla2100_print(" data = 0x");
            qla2100_output_number((u_long)ret, 16);
                    qla2100_print("\n");
                }

                return(ret);
            }

            /*
            *  Get word from I/O port
            */
            STATIC uint16_t
            qla2100_getword(uint16_t *port) {
                uint16_t ret;

#ifdef MEMORY_MAPPED_IO
                ret = *port;
#else
                ret = inw((int)port);
#endif

                if( ql2x_debug_print ) {
                    qla2100_print("qla2100_getword: address = ");
            qla2100_output_number((u_long)port, 16);
            qla2100_print(" data = 0x");
            qla2100_output_number((u_long)ret, 16);
                    qla2100_print("\n");
                }

                return(ret);
            }

            /*
            *  Get double word from I/O port
            */
            STATIC uint32_t
            qla2100_getdword(uint32_t *port) {
                uint32_t ret;

#ifdef MEMORY_MAPPED_IO
                ret = *port;
#else
                ret = inl((int)port);
#endif

                if( ql2x_debug_print ) {
                    qla2100_print("qla2100_getdword: address = ");
            qla2100_output_number((u_long)port, 16);
            qla2100_print(" data = 0x");
            qla2100_output_number((u_long)ret, 16);
                    qla2100_print("\n");
                }

                return(ret);
            }

            /*
            *  Send byte to I/O port
            */
            STATIC void
            qla2100_putbyte(uint8_t *port, uint8_t data) {
#ifdef MEMORY_MAPPED_IO
                *port = data;
#else
                outb(data, (int)port);
#endif

                if( ql2x_debug_print ) {
                    qla2100_print("qla2100_putbyte: address = ");
            qla2100_output_number((u_long)port, 16);
            qla2100_print(" data = 0x");
            qla2100_output_number((u_long)data, 16);
                    qla2100_print("\n");
                }
            }

            /*
            *  Send word to I/O port
            */
            STATIC void
            qla2100_putword(uint16_t *port, uint16_t data) {
#ifdef MEMORY_MAPPED_IO
                *port = data;
#else
#ifdef _LINUX_IOPORTS
                outw(data, (int)port);
#else
                outw((int)port, data);
#endif
#endif

                if( ql2x_debug_print ) {
                    qla2100_print("qla2100_putword: address = ");
            qla2100_output_number((u_long)port, 16);
            qla2100_print(" data = 0x");
            qla2100_output_number((u_long)data, 16);
                    qla2100_print("\n");
                }
            }

            /*
            *  Send double word to I/O port
            */
            STATIC void
            qla2100_putdword(uint32_t *port, uint32_t data) {
#ifdef MEMORY_MAPPED_IO
                *port = data;
#else
#ifdef _LINUX_IOPORTS
                outl(data,(int)port);
#else
                outl((int)port, data);
#endif
#endif

                if( ql2x_debug_print ) {
                    qla2100_print("qla2100_putdword: address = ");
            qla2100_output_number((u_long)port, 16);
            qla2100_print(" data = 0x");
            qla2100_output_number((u_long)data, 16);
                    qla2100_print("\n");
                }
            }

            /*
            * Dummy function to prevent warnings for
            * declared and unused debug functions
            */
            void
            qla2100_debug(void) {
                qla2100_getbyte(0);
                qla2100_getword(0);
                qla2100_getdword(0);
                qla2100_putbyte(0, 0);
                qla2100_putword(0, 0);
                qla2100_putdword(0, 0);
            }

            /*
            *  Out character to COM1 port.
            *      PORT must be at standard address for COM1 = 0x3F8
            *      This port is available on both Lion and ia32 systems
            */
#define OUTB(addr,data)   outb((data),(addr))
            STATIC void
            qla2100_putc(int8_t c) {
#ifdef QL_DEBUG_CONSOLE

                printk("%c",c);

#else /* QL_DEBUG_CONSOLE */

                uint8_t data;
                int     com_addr              = 0x3f8; /* COM1 */
                int     hardware_flow_control = 1;
                int     software_flow_control = 0;
                uint8_t loop                  = TRUE;

                do {

                    /* Wait for transmitter holding and shift registers for empty. */
                    do {
                        data = inb(com_addr+5);
                    }while( !(data & BIT_6) );

                    /*
                    * Set BAUD rate for COM1 to 9600
                    */

                    /* BAUD rate divisor LSB. */
                    OUTB(com_addr+3, 0x83);

                    /* BAUD rate divisor MSB. */
                    OUTB(com_addr, 0xc);           /* 0xC = 9600 baud */

                    /* Set No parity, 8 bits, 1 stop bit and
                    select interrupt enable register. */
                    OUTB(com_addr+3, 3);

                    /* Disable interrupts. */
                    OUTB(com_addr+1, 0);

                    /* Set data terminal ready and request to send */
                    OUTB(com_addr+1, 0);

                    if( hardware_flow_control ) {
                        /* Wait for clear-to-send and data-set-ready */
                        do {
                            data = inb(com_addr+6) & (BIT_5 + BIT_4);
                        }while( data != (BIT_5 + BIT_4) );
                    } else if( software_flow_control ) {
                        /* Test for data ready. */
                        data = inb(com_addr+5);
                        if( data & BIT_0 ) {
                            /* If XOFF */
                            data = inb(com_addr);
                            if( data == '\023' ) {
                                /* Wait for XON */
                                do {
                                    /* Wait for int8_t */
                                    do {
                                        data = inb(com_addr+5);
                                    }while( !(data & BIT_0) );
                                    data = inb(com_addr);
                                }while( data != '\021' );
                            }
                        }
                    }

                    /* Output character. */
                    OUTB(com_addr, c);

                    /* Add return. */
                    if( c == '\n' )
                        c = '\r';
                    else
                        loop = FALSE;

                }while( loop );
#endif  /* QL_DEBUG_CONSOLE */
            }

            /*
            *  Out NULL terminated string to COM port.
            */
            STATIC void
            qla2100_print(int8_t *s) {
                if( ql2x_debug_print ) {
#ifdef QL_DEBUG_CONSOLE
                    printk("%s",s);
#else
                    /* Output string. */
                    while( *s )
                        qla2100_putc(*s++);
#endif
                }
            }

            /*
            *  Output long number to COM port.
            */
            STATIC void
        qla2100_output_number(u_long n, uint8_t base) {
                int8_t str[12];
                int8_t *s      = &str[11];
                uint8_t output = 0;
                uint8_t hex    = FALSE;

                if( ql2x_debug_print ) {
                    if( base == 10 || base == 16 ) {
                        if( base == 16 && n > 9 )
                            hex = TRUE;

                        *s = 0;
                        do {
                            s--;
                            *s = n % base;
                            if( *s > 9 )
                                *s += 55;
                            else
                                *s += '0';
                            n /= base;
                        }while( n );

                        for( ; *s; s++ ) {
                            if( *s != '0' )
                                output = 1;
                            if( output )
                                qla2100_putc(*s);
                        }
                        if( !output )
                            qla2100_putc(*--s);

                        if( hex )
                            qla2100_putc('h');
                    }
                }
            }

            STATIC void
            qla2100_dump_buffer(uint8_t *b, uint32_t size) {
                uint32_t cnt;
                uint8_t c;

                if( ql2x_debug_print ) {
                    qla2100_print(
                    " 0   1   2   3   4   5   6   7   8   9   Ah  Bh  Ch  Dh  Eh  Fh\n");
                    qla2100_print(
                    "---------------------------------------------------------------\n");

                    for( cnt = 0; cnt < size; ) {
                        c = *b++;
                        if( c < 16 )
                            qla2100_putc(' ');
                        qla2100_output_number((uint32_t)c, 16);
                        cnt++;
                        if( !(cnt % 16) )
                            qla2100_print("\n");
                        else if( c < 10 )
                            qla2100_print("  ");
                        else
                            qla2100_putc(' ');
                    }
                    if( cnt % 16 )
                        qla2100_print("\n");
                }
            }
            /**************************************************************************
            *   ql2100_print_scsi_cmd
            *
            **************************************************************************/
            void qla2100_print_scsi_cmd(Scsi_Cmnd *cmd) {
                scsi_qla_host_t *ha;
                struct Scsi_Host  *host = cmd->host;
                srb_t           *sp;

                int i;
                ha = (scsi_qla_host_t *) host->hostdata;

                ql2x_debug_print = 1;
                sp = (srb_t *) CMD_SP(cmd);
                sprintf(debug_buff,"SCSI Command=0x%p, Handle=0x%08lx pid=%x\n\r", cmd, (u_long)CMD_HANDLE(cmd),cmd->pid);
                qla2100_print(debug_buff);
                sprintf(debug_buff,"  chan=%d, target = 0x%02x, lun = 0x%02x, cmd_len = 0x%02x\n\r",
                cmd->channel, cmd->target, cmd->lun, cmd->cmd_len);
                qla2100_print(debug_buff);
                qla2100_print(" CDB = ");
                for( i = 0; i < cmd->cmd_len; i++ ) {
                    sprintf(debug_buff,"0x%02x ", cmd->cmnd[i]);
                    qla2100_print(debug_buff);
                }

                sprintf(debug_buff,"\n\r  seg_cnt =%d, retries=%d, serial_number_at_timeout=0x%lx\n\r",cmd->use_sg,cmd->retries,cmd->serial_number_at_timeout);
                qla2100_print(debug_buff);
                sprintf(debug_buff,"  request buffer=0x%p, request buffer len=0x%x\n\r",cmd->request_buffer,cmd->request_bufflen);
                qla2100_print(debug_buff);
                sprintf(debug_buff,"  tag=%d, flags=0x%x, transfersize=0x%x \n\r",
                cmd->tag, cmd->flags,cmd->transfersize);
                qla2100_print(debug_buff);
                sprintf(debug_buff,"  Pid=%d, SP=0x%x\n\r", (int)cmd->pid, CMD_SP(cmd));

                qla2100_print(debug_buff);
                sprintf(debug_buff,"  sp flags=0x%lx, sp state=%x, wdgtime=%d\n\r",sp->flags,sp->state,sp->wdg_time);
                qla2100_print(debug_buff);
            }


            void qla2100_print_q_info(scsi_lu_t *q) {
                sprintf(debug_buff,"Queue info: queue in =%d, queue out= %d, flags=0x%lx\n\r", q->q_incnt, q->q_outcnt, q->q_flag);
                qla2100_print(debug_buff);
            }
#endif




            /**************************************************************************
            *   ql2100_dump_regs
            *
            **************************************************************************/
            static void qla2100_dump_regs(struct Scsi_Host *host) {
                printk("Mailbox registers:\n");
                printk("qla2100 : mbox 0 0x%04x \n", inw(host->io_port + 0x10));
                printk("qla2100 : mbox 1 0x%04x \n", inw(host->io_port + 0x12));
                printk("qla2100 : mbox 2 0x%04x \n", inw(host->io_port + 0x14));
                printk("qla2100 : mbox 3 0x%04x \n", inw(host->io_port + 0x16));
                printk("qla2100 : mbox 4 0x%04x \n", inw(host->io_port + 0x18));
                printk("qla2100 : mbox 5 0x%04x \n", inw(host->io_port + 0x1a));
#ifdef TRACECODE
                sprintf(debug_buff,"qla2100 : mbox 0 0x%04x \n\r", inw(host->io_port + 0x10));
                qla2100_print(debug_buff);
                sprintf(debug_buff,"qla2100 : mbox 1 0x%04x \n\r", inw(host->io_port + 0x12));
                qla2100_print(debug_buff);
                sprintf(debug_buff,"qla2100 : mbox 2 0x%04x \n\r", inw(host->io_port + 0x14));
                qla2100_print(debug_buff);
                sprintf(debug_buff,"qla2100 : mbox 3 0x%04x \n\r", inw(host->io_port + 0x16));
                qla2100_print(debug_buff);
                sprintf(debug_buff,"qla2100 : mbox 4 0x%04x \n\r", inw(host->io_port + 0x18));
                qla2100_print(debug_buff);
                sprintf(debug_buff,"qla2100 : mbox 5 0x%04x \n\r", inw(host->io_port + 0x1a));
                qla2100_print(debug_buff);
#endif
            }


#if  STOP_ON_ERROR
            /**************************************************************************
            *   ql2100_panic
            *
            **************************************************************************/
            static void qla2100_panic(char *cp, struct Scsi_Host *host) {
                scsi_qla_host_t *ha;
                long  *fp;

                ha = (scsi_qla_host_t *) host->hostdata;
                DEBUG2(ql2x_debug_print = 1;)
                sprintf(debug_buff,"qla2100 - PANIC:  %s\n",cp);
                qla2100_print(debug_buff);
                sprintf(debug_buff,"Current time=0x%lx\n", jiffies);
                qla2100_print(debug_buff);
                sprintf(debug_buff,"Number of pending commands =0x%lx\n", ha->actthreads);
                qla2100_print(debug_buff);
                sprintf(debug_buff,"Number of queued commands =0x%lx\n", ha->qthreads);
                qla2100_print(debug_buff);
                sprintf(debug_buff,"Number of free entries = (%d)\n",ha->req_q_cnt);
                qla2100_print(debug_buff);
                sprintf(debug_buff,"Request Queue @ 0x%lx, Response Queue @ 0x%lx\n",
                ha->request_dma,
                ha->response_dma);
                qla2100_print(debug_buff);
                sprintf(debug_buff,"Request In Ptr %d\n", ha->req_ring_index);
                qla2100_print(debug_buff);
                fp = (long *) &ha->flags;
                sprintf(debug_buff,"HA flags =0x%lx\n", *fp);
                qla2100_print(debug_buff);
                ql2100_dump_requests(ha);
                qla2100_dump_regs(host);
                cli();
                for( ;; ) {
                    QLA2100_DELAY(2); barrier();
                }
                sti();
            }
#endif
#if 0
    static void qla2100_set_flags(int flag) {

        switch( flag ) {
        case 0x1:
            qla2100_verbose = 1L;

        }

    }
#endif
            /**************************************************************************
            *   ql2100_dump_requests
            *
            **************************************************************************/
            void
            ql2100_dump_requests(scsi_qla_host_t *ha) {

                Scsi_Cmnd       *cp;
                srb_t           *sp;
                int i;
#ifdef QL_DEBUG_ROUTINES
                qla2100_print("Outstanding Commands on controller:\n\r");
#else
                printk("Outstanding Commands on controller:\n");
#endif
                for( i=0; i < MAX_OUTSTANDING_COMMANDS; i++ ) {
                    if( (sp = ha->outstanding_cmds[i]) == NULL )
                        continue;
                    if( (cp = sp->cmd) == NULL )
                        continue;
                    sprintf(debug_buff,"(%d): Pid=%ld, sp flags=0x%x, cmd=0x%p\n\r", i, (int)sp->cmd->pid, (long)sp->flags,CMD_SP(sp->cmd));

#ifdef QL_DEBUG_ROUTINES
                    qla2100_print(debug_buff);
#else
                    printk("%s",debug_buff);
#endif
                }

            }
            

            /**************************************************************************
            *   qla2100_setup
            *
            *   Handle Linux boot parameters. This routine allows for assigning a value
            *   to a parameter with a ';' between the parameter and the value.
            *   ie. qla2x00=arg0;arg1;...;argN;<properties .... properties>  OR
            *   via the command line.
            *   ie. qla2x00 ql2xopts=arg0;arg1;...;argN;<properties .... properties>
            **************************************************************************/
            void qla2100_setup(char *s, int *dummy) {
                char *cp, *np;
                char	*slots[MAXARGS];
                char	**argv = &slots[0];
                char	buf[LINESIZE];
                int	argc, opts;

                /*
                * Determine if we have any properties.
                */
                cp = s;
                opts = 1;
                while( *cp && (np = qla2100_get_line(cp, buf)) != NULL ) {
                    if( strncmp("scsi-qla",buf,8) == 0 ) {
                        DEBUG(printk("qla2100: devconf=%s\n",cp);)
                        ql2xdevconf = cp;
                        (opts > 0)? opts-- : 0;
                        break;
                    }
                    opts++;
                    cp = np;
                }
                /*
                * Parse the args before the properties
                */
                if( opts ) {
                    opts = (opts > MAXARGS-1)? MAXARGS-1: opts;
                    argc = qla2100_get_tokens(s, argv, opts);
                    while (argc > 0 ) {
                        cp = *argv;
                        DEBUG(printk("scsi: found cmd arg =[%s]\n", cp);)
                        if( strcmp(cp, "verbose") == 0 ) {
                            DEBUG(printk("qla2100: verbose\n");)
                            qla2100_verbose++;
                        } else if (strcmp(cp, "quiet") == 0) {
                            qla2100_quiet = 1;
                        } else if( strcmp(cp, "reinit_on_loopdown") == 0 ) {
                            qla2100_reinit++;
                            DEBUG(printk("qla2100: reinit_on_loopdown\n");)
                        }
                        argc--, argv++;
                    }
                }

            }

            /********************** qla2100_get_line *********************
            * qla2100_get_line
            * Copy a substring from the specified string. The substring
            * consists of any number of chars seperated by white spaces (i.e. spaces)
            * and ending with a newline '\n' or a semicolon ';'.
            *
            * Enter:
            * str - orig string
            * line - substring
            *
            * Returns:
            *   cp - pointer to next string
            *     or
            *   null - End of string
            *************************************************************/
            static char	*qla2100_get_line(char *str, char *line) {
                register	char 	*cp = str;
                register	char 	*sp = line;

                /* skip preceeding spaces */
                while( *cp && *cp == ' ' )
                    ++cp;
                while ( (*cp) && *cp != '\n' && *cp != ';' )   /* end of line */
                    *sp++ = *cp++;

                *sp = '\0';
                DEBUG5(printk("qla2100_get_line: %s\n",line);)
                if( (*cp) ) {
                    cp++;
                    return( cp );
                }
                return( NULL );
            }


            /**************************** get_tokens *********************
            * Parse command line into argv1, argv2, ... argvX
            * Arguments are seperated by white spaces and colons and end
            * with a NULL.
            *************************************************************/
            static int	qla2100_get_tokens(char *line, char **argv, int maxargs ) {
                register	char 	*cp = line;
                int	count = 0;

                while( *cp && count < maxargs ) {
                    /* skip preceeding spaces */
                    while((*cp) && *cp == ' ')
                        ++cp;
                    /* symbol starts here */
                    argv[count++] = cp;
                    /* skip symbols */
                    while ( (*cp) && !( *cp == ' ' || *cp == ';' || *cp == ':' ) )
                        cp++;
                    /* replace comma or space with a null */
                    if( (*cp) && (*cp ==' ' ) && argv[count-1] != cp )
                        *cp++ = '\0';
                }
                return( count );
            }

#ifdef FC_IP_SUPPORT
            /* Include routines for supporting IP */
#include "qla2100ip.c"
#endif /* FC_IP_SUPPORT */

#if  APIDEV
/****************************************************************************/
/* Create character driver "HbaApiDev" w dynamically allocated major number */
/* and create "/proc/scsi/qla2x00/HbaApiNode" as the device node associated */
/* with the major number.                                                   */
/****************************************************************************/

#define APIDEV_NODE  "HbaApiNode"
#define APIDEV_NAME  "HbaApiDev"

static int apidev_major = 0;
static struct Scsi_Host *apidev_host = 0;

static int apidev_open(struct inode *inode, struct file *file)
{
    printk ("qla2100_apidev: open MAJOR number = %d, MINOR number = %d\n", MAJOR (inode->i_rdev), MINOR (inode->i_rdev));
    return 0;
}
static int apidev_close(struct inode *inode, struct file *file)
{
    printk ("qla2100_apidev: closed\n");
    return 0;
}

static int apidev_ioctl(struct inode *inode, struct file *fp, unsigned int cmd, unsigned long arg)
{
    Scsi_Device fake_scsi_device;
    fake_scsi_device.host = apidev_host;
    return(qla2100_ioctl(&fake_scsi_device, (int)cmd, (void*)arg));
}

static struct file_operations apidev_fops = {
    ioctl:    apidev_ioctl,
    open:     apidev_open,
    release:  apidev_close
};

static int apidev_init(struct Scsi_Host *host)
{
    if(apidev_host) return 0;
    if (0 > (apidev_major = register_chrdev(0, APIDEV_NAME, &apidev_fops)))
    {
        DEBUG(printk("qla2100_apidev: register_chrdev rc=%d\n",apidev_major);)
        return apidev_major;
    }
    apidev_host = host;
    DEBUG(printk("qla2x00: Created /proc/scsi/qla2x00/%s major=%d\n",APIDEV_NODE,apidev_major);)
    proc_mknod(APIDEV_NODE, 0777+S_IFCHR,host->hostt->proc_dir,(kdev_t)MKDEV(apidev_major,0));
    return 0;
}

static int apidev_cleanup()
{
    if(!apidev_host) return 0;
    unregister_chrdev(apidev_major,APIDEV_NAME);
    remove_proc_entry(APIDEV_NODE,apidev_host->hostt->proc_dir);
    apidev_host = 0;
    return 0;
}
#endif /* APIDEV */

#ifdef QL_DEBUG_ROUTINES
#if  DEBUG_GET_FW_DUMP
#include  "x2300dbg.c"
#endif
#endif


            /*
            * Overrides for Emacs so that we almost follow Linus's tabbing style.
            * Emacs will notice this stuff at the end of the file and automatically
            * adjust the settings for this buffer only.  This must remain at the end
            * of the file.
            * ---------------------------------------------------------------------------
            * Local variables:
            * c-indent-level: 2
            * c-brace-imaginary-offset: 0
            * c-brace-offset: -2
            * c-argdecl-indent: 2
            * c-label-offset: -2
            * c-continued-statement-offset: 2
            * c-continued-brace-offset: 0
            * indent-tabs-mode: nil
            * tab-width: 8
            * End:
            */










