/*
 * iSCSI connection daemon
 * Copyright (C) 2001 Cisco Systems, Inc.
 * maintained by linux-iscsi@cisco.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * See the file COPYING included with this distribution for more details.
 *
 * $Id: iscsiAuthClient.h,v 1.2 2001/08/08 15:13:59 smferris Exp $ 
 *
 * File: iscsiAuthClient.h
 * Created: March 2001  ssenum@cisco.com
 *
 */

/*
 * This file is the include file for for iscsiAuthClient.c
 */


#ifndef ISCSIAUTHCLIENT_H
#define ISCSIAUTHCLIENT_H

#ifdef __cplusplus
extern "C" {
#endif


enum {
	iscsiAuthStringMaxLength = 100,
	iscsiAuthDataMaxLength = iscsiAuthStringMaxLength / 2
};

enum {iscsiAuthRecvEndMaxCount = 10};

enum {iscsiAuthClientSignature = 0x5984B2E3};

enum {iscsiAuthChallengeLength = 16};

enum iscsiAuthKeyType_t {
	iscsiAuthKeyTypeAuthMethod = 0,
	iscsiAuthKeyTypeFirst = iscsiAuthKeyTypeAuthMethod,
	iscsiAuthKeyTypeAlgorithm,
	iscsiAuthKeyTypeIdentifier,
	iscsiAuthKeyTypeChallenge,
	iscsiAuthKeyTypeResponse,
	iscsiAuthKeyTypeUsername,
	iscsiAuthKeyTypeSecurityContextComplete,
	iscsiAuthKeyTypeLast = iscsiAuthKeyTypeSecurityContextComplete,
	iscsiAuthKeyTypeMaxCount
};
typedef enum iscsiAuthKeyType_t IscsiAuthKeyType;

enum iscsiAuthMethod_t {
	iscsiAuthMethodNotPresent = -1,
	iscsiAuthMethodNone = 1,
	iscsiAuthMethodChap = 2,
	iscsiAuthMethodMaxCount = 2
};
typedef enum iscsiAuthMethod_t IscsiAuthMethod;

enum iscsiAuthChapAlgorithm_t {
	iscsiAuthChapAlgorithmNotPresent = -1,
	iscsiAuthChapAlgorithmNone = 1, /* Only used for unit testing. */
	iscsiAuthChapAlgorithmMd5 = 5,
	iscsiAuthChapAlgorithmMaxCount = 2
};
typedef enum iscsiAuthChapAlgorithm_t IscsiAuthChapAlgorithm;

enum iscsiAuthStatus_t {
	iscsiAuthStatusNoError = 0,
	iscsiAuthStatusError,
	iscsiAuthStatusPass,
	iscsiAuthStatusFail,
	iscsiAuthStatusContinue,
	iscsiAuthStatusInProgress
};
typedef enum iscsiAuthStatus_t IscsiAuthStatus;

enum iscsiAuthNodeType_t {
	iscsiAuthNodeTypeInitiator = 1,
	iscsiAuthNodeTypeTarget = 2
};
typedef enum iscsiAuthNodeType_t IscsiAuthNodeType;

enum iscsiAuthPhase_t {
	iscsiAuthPhaseConfigure = 1,
	iscsiAuthPhaseAuthMethod,
	iscsiAuthPhaseAlgorithm,
	iscsiAuthPhaseAuthenticate,
	iscsiAuthPhaseDone,
	iscsiAuthPhaseError
};
typedef enum iscsiAuthPhase_t IscsiAuthPhase;

enum iscsiAuthLocalState_t {
	iscsiAuthLocalStateRecvChallenge = 1,
	iscsiAuthLocalStateDone,
	iscsiAuthLocalStateError
};
typedef enum iscsiAuthLocalState_t IscsiAuthLocalState;

enum iscsiAuthRemoteState_t {
	iscsiAuthRemoteStateSendChallenge = 1,
	iscsiAuthRemoteStateRecvResponse,
	iscsiAuthRemoteStateAuthRequest,
	iscsiAuthRemoteStateSendSecurityContextComplete,
	iscsiAuthRemoteStateSentSecurityContextComplete,
	iscsiAuthRemoteStateDone,
	iscsiAuthRemoteStateError
};
typedef enum iscsiAuthRemoteState_t IscsiAuthRemoteState;


typedef void IscsiAuthClientCallback(void *, void *, int);


struct iscsiAuthClientGlobalStats_t {
	unsigned long requestSent;
	unsigned long responseReceived;
};
typedef struct iscsiAuthClientGlobalStats_t IscsiAuthClientGlobalStats;

struct iscsiAuthClientKey_t {
	int present;
	char value[iscsiAuthStringMaxLength];
};
typedef struct iscsiAuthClientKey_t IscsiAuthClientKey;

struct iscsiAuthClient_t {
	unsigned long signature;

	void *glueHandle;
	struct iscsiAuthClient_t *next;
	unsigned int authRequestId;

	IscsiAuthNodeType nodeType;
	unsigned int authMethodCount;
	IscsiAuthMethod authMethodList[iscsiAuthMethodMaxCount];
	unsigned int chapAlgorithmCount;
	IscsiAuthChapAlgorithm chapAlgorithmList[iscsiAuthChapAlgorithmMaxCount];
	int authRemote;
	char username[iscsiAuthStringMaxLength];
	unsigned int passwordLength;
	unsigned char passwordData[iscsiAuthDataMaxLength];
	char listName[iscsiAuthStringMaxLength];

	int recvInProgressFlag;
	int recvEndCount;
	IscsiAuthClientCallback *callback;
	void *userHandle;
	void *messageHandle;

	IscsiAuthPhase phase;
	IscsiAuthLocalState localState;
	IscsiAuthRemoteState remoteState;
	IscsiAuthMethod negotiatedAuthMethod;
	IscsiAuthChapAlgorithm negotiatedChapAlgorithm;
	IscsiAuthStatus remoteAuthStatus;
	int authResponseFlag;

	unsigned int identifier;
	unsigned char challengeData[iscsiAuthChallengeLength];

	IscsiAuthClientKey recv[iscsiAuthKeyTypeMaxCount];
	IscsiAuthClientKey send[iscsiAuthKeyTypeMaxCount];
};
typedef struct iscsiAuthClient_t IscsiAuthClient;


#include "iscsiAuthClientGlue.h"


extern IscsiAuthClientGlobalStats iscsiAuthClientGlobalStats;


extern int iscsiAuthClientInit(IscsiAuthClient *, IscsiAuthNodeType);
extern int iscsiAuthClientFinish(IscsiAuthClient *);

extern int iscsiAuthClientRecvBegin(IscsiAuthClient *);
extern int iscsiAuthClientRecvEnd(
	IscsiAuthClient *, IscsiAuthClientCallback *, void *, void *);

extern const char *iscsiAuthClientGetKeyName(int);
extern int iscsiAuthClientRecvKeyValue(IscsiAuthClient *, int, const char *);
extern int iscsiAuthClientSendKeyValue(IscsiAuthClient *, int, char *);

extern int iscsiAuthClientSetAuthMethod(
	IscsiAuthClient *, unsigned int, const int *);
extern int iscsiAuthClientSetChapAlgorithm(
	IscsiAuthClient *, unsigned int, const int *);
extern int iscsiAuthClientSetUsername(IscsiAuthClient *, const char *);
extern int iscsiAuthClientSetPassword(
	IscsiAuthClient *, const unsigned char *, unsigned int);
extern int iscsiAuthClientSetAuthRemote(IscsiAuthClient *, int);
extern int iscsiAuthClientSetGlueHandle(IscsiAuthClient *, void *);
extern int iscsiAuthClientSetListName(IscsiAuthClient *, const char *);

extern void iscsiAuthClientAuthResponse(IscsiAuthClient *, int);

/*
 * The following routines are considered platform dependent,
 * and need to be implemented for use by iscsiAuthClient.c.
 */

extern int iscsiAuthClientChapAuthRequest(
	IscsiAuthClient *, char *, unsigned int,
	unsigned char *, unsigned int, unsigned char *, unsigned int);
extern void iscsiAuthClientChapAuthCancel(IscsiAuthClient *);

extern int iscsiAuthClientTextToNumber(char *, long *);
extern void iscsiAuthClientNumberToText(long, char *);

extern void iscsiAuthRandomSetData(unsigned char *, unsigned int);
extern void iscsiAuthMd5Init(IscsiAuthMd5Context *);
extern void iscsiAuthMd5Update(
	IscsiAuthMd5Context *, unsigned char *, unsigned int);
extern void iscsiAuthMd5Final(unsigned char *, IscsiAuthMd5Context *);

extern int iscsiAuthClientData(
	unsigned char *, unsigned int *, unsigned char *, unsigned int);


#ifdef __cplusplus
}
#endif

#endif /* #ifndef ISCSIAUTHCLIENT_H */
