#ifndef ISCSI_H_
#define ISCSI_H_

/*
 * iSCSI driver for Linux
 * Copyright (C) 2001 Cisco Systems, Inc.
 * maintained by linux-iscsi@cisco.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * See the file COPYING included with this distribution for more details.
 *
 * $Id: iscsi.h,v 1.5 2001/08/08 15:13:59 smferris Exp $ 
 *
 * iscsi.h
 *
 *    Main include for iSCSI kernel module
 * 
 */


#define ISCSI_MAX_TARGETS	8
#define ISCSI_MAX_LUN	        32
#define ISCSI_MAX_CHANNELS_PER_HBA 1

#ifndef MIN
#define MIN(x, y)		(x < y)? x : y
#endif

#define ISCSI_MAX_CMDS		12
#define ISCSI_CANQUEUE		64
#define ISCSI_TASKS_PER_HBA     ISCSI_CANQUEUE
#define ISCSI_MAX_SG		64
#define ISCSI_RXCTRL_SIZE	        (4096 + sizeof(struct IscsiHdr))

#define ISCSI_PROC_INFO_DEF iscsi_proc_info

/*
 * Scsi_Host Template
 */
#define ISCSI {                             \
    next : NULL,                                \
    module : NULL,                              \
    proc_dir : NULL,                            \
    proc_info : ISCSI_PROC_INFO_DEF,        \
    name : NULL,                                \
    detect : iscsi_detect,                  \
    release : iscsi_release,                \
    info : iscsi_info,                      \
    ioctl : NULL,                               \
    command : NULL,                             \
    queuecommand : iscsi_queue,             \
    eh_strategy_handler : NULL,                 \
    eh_abort_handler : iscsi_eh_abort,      \
    eh_device_reset_handler : iscsi_eh_device_reset, \
    eh_bus_reset_handler : iscsi_eh_bus_reset, \
    eh_host_reset_handler : iscsi_eh_host_reset, \
    abort : NULL,                               \
    reset : NULL,                               \
    slave_attach : NULL,                        \
    bios_param : iscsi_biosparam,           \
    can_queue : ISCSI_CANQUEUE,             \
    this_id: -1,                                \
    sg_tablesize : ISCSI_MAX_SG,		\
    cmd_per_lun: ISCSI_MAX_CMDS,            \
    present : 0,                                \
    unchecked_isa_dma : 0,                      \
    use_clustering : ENABLE_CLUSTERING,         \
    use_new_eh_code : 1,                        \
    emulated : 1                                \
}

/*    sg_tablesize : SG_NONE,                     */
/*    sg_tablesize : SG_ALL,                      */

#define ISCSI_CMD_CONTROL	0x00
#define ISCSI_CMD_WRITE	0x01
#define ISCSI_CMD_READ	0x02

/* definitions for the flag bits of an iscsi_task */
#define TASK_RX_RSP       0
#define TASK_RX_OVERFLOW  1
#define TASK_RX_UNDERFLOW 2
#define TASK_ABORTING     3
#define TASK_ABORT_SENT   4
#define TASK_ABORTED      5
#define TASK_NEED_R2T     6
#define TASK_GOT_R2T      7

typedef struct iscsi_task_ {
	struct iscsi_task_	*next;
	struct iscsi_task_	*prev;
	Scsi_Cmnd	        *volatile scsi_cmnd;
	struct iscsi_session_	*session;
	spinlock_t              lock;
	int			rxdata;
    	unsigned long           flags;
	int			direction;
	unsigned int            itt;
	unsigned int		ttt;
	unsigned int		data_offset;
	unsigned int		cmdsn;
	unsigned long		jiffies;
	int			data_credit;
} iscsi_task_t;

typedef struct iscsi_session_ {
	struct iscsi_session_	*next;
	struct iscsi_session_	*prev;
	struct iscsi_hba_       *hba;
	struct socket		*socket;
	int                     channel;
	int                     iscsi_bus;
	int                     target_id;
	unsigned long           lun_bitmap[8];
	int                     address_length;
	unsigned char		ip_address[16];
	int                     Port;
	char			TargetName[TARGET_NAME_MAXLEN+1];
	unsigned int		ConnFlag;
 	/* the queue of SCSI commands that we need to send on this session */
    	spinlock_t              scsi_cmnd_lock;
	Scsi_Cmnd		*scsi_cmnd_head;
	Scsi_Cmnd		*scsi_cmnd_tail;
	unsigned int		CmdSn;
	volatile unsigned int	ExpCmdSn;
	volatile unsigned int	MaxCmdSn;
	int			initialR2T;
	int			dataPDULength;
	int			firstBurstSize;
	int                     immediateData;
	uint32_t                itt;
    	volatile unsigned long  last_rx;
	volatile unsigned long  last_ping;
	int                     ActiveTimeout;
    	int                     IdleTimeout;
	int                     PingTimeout;
	/* the following fields may have to move if we decide to implement multiple connections,
         * per session, and decide to have threads for each connection rather than for each session.
         */
	/* the queue of SCSI commands that have been sent on this session, and for which we're waiting for a reply */
	atomic_t                num_tasks;
	spinlock_t              task_lock;
	iscsi_task_t	        *task_head;
	iscsi_task_t            *task_tail;
#if ( LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,0) )  
	wait_queue_head_t	tx_wait_q;
#else
	struct wait_queue	*tx_wait_q;
#endif
    	unsigned int            control_bits;
	pid_t                   rx_pid;
	pid_t			tx_pid;
    	/* the following fields are per-connection, not per session, and will need to move if 
         * we decide to support multiple connections per session.
         */
	unsigned int		ExpStatSn;
	unsigned char		RxBuf[ISCSI_RXCTRL_SIZE];
	struct iovec		RxIov[ISCSI_MAX_SG];
	struct iovec		TxIov[(ISCSI_MAX_SG+1)];
} iscsi_session_t;

/* tx control bits */
#define TX_WAKE 0
#define TX_PING 1
#define TX_NOP  2
#define TX_SCSI_COMMAND 3
#define TX_R2T_DATA 4
#define TX_ABORT 5

typedef struct iscsi_hba_ {
	struct iscsi_hba_       *next;
	int			active;
    	unsigned int            hostno;
    	spinlock_t              session_lock;
	iscsi_session_t         *session_list_head;
	iscsi_session_t         *session_list_tail;
    	spinlock_t              task_lock;
	iscsi_task_t	        *task_mem;
	iscsi_task_t	        *task_max;
	iscsi_task_t	        *free_task_head;
	iscsi_task_t            *free_task_tail;
	unsigned int            active_tasks;
} iscsi_hba_t;

/*
 * Connection information flags
 */
#define CONN_ALIVE	0x01
#define CONN_PING	0x02
#define CONN_WAKE	0x04
#define CONN_PINGRSP	0x08
#define CONN_DEAD	0x10

#ifdef DEBUG_INIT
#define DEBUG_INIT0(DI0) printk(DI0);
#define DEBUG_INIT1(DI0,DI1) printk(DI0,DI1);
#define DEBUG_INIT2(DI0,DI1,DI2) printk(DI0,DI1,DI2);
#define DEBUG_INIT3(DI0,DI1,DI2,DI3) printk(DI0,DI1,DI2,DI3);
#define DEBUG_INIT4(DI0,DI1,DI2,DI3,DI4) printk(DI0,DI1,DI2,DI3,DI4);
#define DEBUG_INIT5(DI0,DI1,DI2,DI3,DI4,DI5) printk(DI0,DI1,DI2,DI3,DI4,DI5);
#else
#define DEBUG_INIT0(DI0)
#define DEBUG_INIT1(DI0,DI1)
#define DEBUG_INIT2(DI0,DI1,DI2)
#define DEBUG_INIT3(DI0,DI1,DI2,DI3)
#define DEBUG_INIT4(DI0,DI1,DI2,DI3,DI4)
#define DEBUG_INIT5(DI0,DI1,DI2,DI3,DI4,DI5)
#endif

#ifdef DEBUG_FLOW
#define DEBUG_FLOW0(DF0) printk(DF0);
#define DEBUG_FLOW1(DF0,DF1) printk(DF0,DF1);
#define DEBUG_FLOW2(DF0,DF1,DF2) printk(DF0,DF1,DF2);
#define DEBUG_FLOW3(DF0,DF1,DF2,DF3) printk(DF0,DF1,DF2,DF3);
#define DEBUG_FLOW4(DF0,DF1,DF2,DF3,DF4) printk(DF0,DF1,DF2,DF3,DF4);
#define DEBUG_FLOW5(DF0,DF1,DF2,DF3,DF4,DF5) printk(DF0,DF1,DF2,DF3,DF4,DF5);
#define DEBUG_FLOW6(DF0,DF1,DF2,DF3,DF4,DF5,DF6) printk(DF0,DF1,DF2,DF3,DF4,DF5,DF6);
#else
#define DEBUG_FLOW0(DF0)
#define DEBUG_FLOW1(DF0,DF1)
#define DEBUG_FLOW2(DF0,DF1,DF2)
#define DEBUG_FLOW3(DF0,DF1,DF2,DF3)
#define DEBUG_FLOW4(DF0,DF1,DF2,DF3,DF4)
#define DEBUG_FLOW5(DF0,DF1,DF2,DF3,DF4,DF5)
#define DEBUG_FLOW6(DF0,DF1,DF2,DF3,DF4,DF5,DF6)
#endif

#ifdef DEBUG_ERROR
#define DEBUG_ERR0(DE0) printk(DE0);
#define DEBUG_ERR1(DE0,DE1) printk(DE0,DE1);
#define DEBUG_ERR2(DE0,DE1,DE2) printk(DE0,DE1,DE2);
#define DEBUG_ERR3(DE0,DE1,DE2,DE3) printk(DE0,DE1,DE2,DE3);
#define DEBUG_ERR4(DE0,DE1,DE2,DE3,DE4) printk(DE0,DE1,DE2,DE3,DE4);
#define DEBUG_ERR5(DE0,DE1,DE2,DE3,DE4,DE5) printk(DE0,DE1,DE2,DE3,DE4,DE5);
#else
#define DEBUG_ERR0(DE0)
#define DEBUG_ERR1(DE0,DE1)
#define DEBUG_ERR2(DE0,DE1,DE2)
#define DEBUG_ERR3(DE0,DE1,DE2,DE3)
#define DEBUG_ERR4(DE0,DE1,DE2,DE3,DE4)
#define DEBUG_ERR5(DE0,DE1,DE2,DE3,DE4,DE5)
#endif

#endif

/*
 * iSCSI driver for Linux
 * Copyright (C) 2001 Cisco Systems, Inc.
 * maintained by linux-iscsi@cisco.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * See the file COPYING included with this distribution for more details.
 *
 *
 * $Id: version.h,v 1.5 2001/08/08 20:06:51 smferris Exp $ 
 *
 *      controls the version number printed by the iSCSI driver
 *
 */

#define DRIVER_MAJOR_VERSION 2
#define DRIVER_MINOR_VERSION 0
#define DRIVER_PATCH_VERSION	1
#define DRIVER_INTERNAL_VERSION	8

#define ISCSI_DATE	" 8-Aug-2001"
#define BUILD_STR	NULL
