#ifndef ISCSI_TRACE_H_
#define ISCSI_TRACE_H_

/*
 * iSCSI driver for Linux
 * Copyright (C) 2001 Cisco Systems, Inc.
 * maintained by linux-iscsi@cisco.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * See the file COPYING included with this distribution for more details.
 *
 * $Id: iscsi-trace.h,v 1.2 2001/08/08 15:13:59 smferris Exp $
 *
 * iscsi-trace.h
 *
 *    include for driver trace info
 * 
 */


#define ISCSI_TRACE_COUNT	100

typedef struct iscsiTraceEntry_t {
	unsigned char	flag;
	unsigned char	lun;
	unsigned char	cmd;
	unsigned char	target;
	unsigned long	itt;
	unsigned long	data;
	int		activecmds;
	unsigned long	jiffies;
} iscsiTraceEntry;

/*
 * Trace flags
 */
#define ISCSI_TRACE_Qd		        0x01
#define ISCSI_TRACE_TxCmd		0x02
#define ISCSI_TRACE_RxCmd		0x03
#define ISCSI_TRACE_RxCmdStatus	        0x13
#define ISCSI_TRACE_RxCmdFlow	        0x23
#define ISCSI_TRACE_RxCmdCmdStatus	0x33
#define ISCSI_TRACE_RxAsnEv             0x41
#define ISCSI_TRACE_TxData		0x04
#define ISCSI_TRACE_RxData		0x05
#define ISCSI_TRACE_TxAbort		0x06
#define ISCSI_TRACE_RxAbort		0x07
#define ISCSI_TRACE_CmdDone		0x08
#define ISCSI_TRACE_CmdAborted	        0x09
#define ISCSI_TRACE_RttData		0x0a
#define ISCSI_TRACE_TxPing		0x0b
#define ISCSI_TRACE_RxPing		0x0c
#define ISCSI_TRACE_TxNop		0x0d

#endif
