#ifndef ISCSI_IOCTL_H_
#define ISCSI_IOCTL_H_

/*
 * iSCSI connection daemon
 * Copyright (C) 2001 Cisco Systems, Inc.
 * maintained by linux-iscsi@cisco.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * See the file COPYING included with this distribution for more details.
 *
 * $Id: iscsi-ioctl.h,v 1.2 2001/08/08 15:13:59 smferris Exp $
 *
 * include for ioctl calls between the daemon and the kernel module
 *
 */

#include "iscsiAuthClient.h"

/*
 * ioctls
 */
#define ISCSI_GO	        0x00470301
#define ISCSI_SESSION           0x00470302
#define ISCSI_TERMINATE_SESSION 0x00470303
#define ISCSI_GETTRACE	        0x00470304

/* Various phases of a connection */
typedef enum connPhase {
    connNotLoggedIn_e = 0,
    authPhaseNegotiate_e,
    authPhaseAuthenticate_e,
    opParmsNegotiate_e,
    fullFeaturePhase_e
} connPhase_t;

typedef struct iscsi_session_ioctl_ {
	int		socket_fd;
	int		ActiveTimeout;
	int		IdleTimeout;
	int		PingTimeout;
	int		initialR2T;
	int		immediateData;
	int		dataPDULength;
	int		firstBurstSize;
	unsigned short	isid;
	unsigned short	tsid;
	unsigned long	CmdSn;
	unsigned long	ExpCmdSn;
	unsigned long	MaxCmdSn;
	unsigned long   InitStatSn;
	int             iscsi_bus;
    	int		TargetId;
	char		TargetName[TARGET_NAME_MAXLEN+1];
	int             AddressLength;
	unsigned char	RemoteIpAddr[16];
	int		Port;
	connPhase_t	connPhase;  
	IscsiAuthClient *authClient;  /* FIXME: remove this, it shouldn't leave the daemon */
	IscsiAuthStatus	authStatus_m; /* FIXME: remove this, it shouldn't leave the daemon */
} iscsi_session_ioctl_t;

#endif
