/*****************************************************************************
*
* QLogic ISP2x00 device driver for Linux 2.2.x and 2.4.x 
* Copyright (C) 2000,2001 Qlogic Corporation 
* (www.qlogic.com)
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation; either version 2, or (at your option) any
* later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
****************************************************************************/

/* 
   Rev 8     Jan 08, 2001   BN
             - Added LOOP_BACK ioctl define

   Rev 7     Nov 06, 2000   BN
             - Added EXT_DEF_MAX_AEN_QUEUE_OS define
             - Added define for handle_hba_t

   Rev 6     Oct 25, 2000   BN
             - Added EXT_CC_DRIVER_PROP_OS define

   Rev 5     Oct 25, 2000   BN
             - Redo the copyright header and add AEN details

   Rev 4     Oct 23, 2000   BN
             - Added definition for BOOLEAN

   Rev 3     Oct 23, 2000
             BN
             - Added definitions for EXT_ADDR_MODE_OS
               and also include of <linux/ioctl.h>

   Rev 2     Oct 18, 2000
             BN
             - Enable API Exention support

   Rev 1     Original version Sep 7, 2000 
             BN



*/

#include <linux/ioctl.h>

#if BITS_PER_LONG <= 32
#define EXT_ADDR_MODE_OS  EXT_DEF_ADDR_MODE_32
#else
#define EXT_ADDR_MODE_OS  EXT_DEF_ADDR_MODE_64
#endif

#define	UINT8	uint8_t
#define	UINT16	uint16_t
#define	UINT32	uint32_t
#define	UINT64	void *
#define BOOLEAN uint8_t

#define uint8_t  unsigned char
#define uint16_t unsigned short
#define uint32_t unsigned int

#if BITS_PER_LONG > 32
#define uint64_t unsigned long
#else
#define uint64_t unsigned long long
#endif

typedef struct  track_instance
{

  int   handle;

} track_instance_t;


#define	EXT_DEF_MAX_HBA_OS		256	/* 0 - 0xFF */
#define	EXT_DEF_MAX_BUS_OS		1
#define	EXT_DEF_MAX_TARGET_OS		256	/* 0 - 0xFF */
#define	EXT_DEF_MAX_LUN_OS		256	/* 0 - 0xFF */

#define EXT_DEF_MAX_AEN_QUEUE_OS        64

#define QLMULTIPATH_MAGIC 'y'
#define _QLBUILD   /* for exioct.h to enable include of qinsdmgt.h */

#define EXT_CC_STARTIOCTL   _IOWR(QLMULTIPATH_MAGIC, 0 , sizeof(EXT_IOCTL))
#define EXT_CC_SETINSTANCE  _IOWR(QLMULTIPATH_MAGIC, 1 , sizeof(EXT_IOCTL))

#define EXT_CC_QUERY_OS  _IOWR(QLMULTIPATH_MAGIC, 2 , sizeof(EXT_IOCTL))
#define EXT_CC_SEND_FCCT_PASSTHRU_OS _IOWR(QLMULTIPATH_MAGIC, 3 , sizeof(EXT_IOCTL))
#define EXT_CC_READ_NVRAM_OS _IOWR(QLMULTIPATH_MAGIC, 4 , sizeof(EXT_IOCTL))
#define EXT_CC_SCSI_PASSTHRU_OS _IOWR(QLMULTIPATH_MAGIC, 5 , sizeof(EXT_IOCTL))
#define EXT_CC_STOP_QCMD     _IOWR(QLMULTIPATH_MAGIC, 6 , sizeof(EXT_IOCTL))
#define EXT_CC_RESUME_QCMD   _IOWR(QLMULTIPATH_MAGIC, 7 , sizeof(EXT_IOCTL))
#define EXT_CC_GET_DATA_OS   _IOWR(QLMULTIPATH_MAGIC, 8 , sizeof(EXT_IOCTL))
#define	EXT_CC_WWPN_TO_SCSIADDR _IOWR(QLMULTIPATH_MAGIC, 9 , sizeof(EXT_IOCTL))
#define	EXT_CC_REG_AEN_OS  _IOWR(QLMULTIPATH_MAGIC, 10 , sizeof(EXT_IOCTL))
#define	EXT_CC_GET_AEN_OS  _IOWR(QLMULTIPATH_MAGIC, 11 , sizeof(EXT_IOCTL))

#define	EXT_CC_DRIVER_PROP_OS  _IOWR(QLMULTIPATH_MAGIC, 12 , sizeof(EXT_IOCTL))

#define EXT_CC_LOOPBACK_OS   _IOWR(QLMULTIPATH_MAGIC, 20 , sizeof(EXT_IOCTL))



    /*
    * Overrides for Emacs so that we almost follow Linus's tabbing style.
    * Emacs will notice this stuff at the end of the file and automatically
    * adjust the settings for this buffer only.  This must remain at the end
    * of the file.
    * ---------------------------------------------------------------------------
    * Local variables:
    * c-indent-level: 2
    * c-brace-imaginary-offset: 0
    * c-brace-offset: -2
    * c-argdecl-indent: 2
    * c-label-offset: -2
    * c-continued-statement-offset: 2
    * c-continued-brace-offset: 0
    * indent-tabs-mode: nil
    * tab-width: 8
    * End:
    */

