/*****************************************************************************
*
* QLogic ISP2x00 device driver for Linux 2.2.x and 2.4.x 
* Copyright (C) 2000 and 2001         Qlogic Corporation 
* (www.qlogic.com)
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation; either version 2, or (at your option) any
* later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
**
******************************************************************************/

#ifndef	_EXIOCT_H
#define	_EXIOCT_H
/*
 * File Name: exioct.h
 *
 * San/Device Management Ioctl Header
 * File is created to adhere to Solaris requirement using 8-space tabs.
 */


/*
 * NOTE: the following version defines must be updated each time the
 *	 changes made may affect the backward compatibility of the
 *	 input/output relations of the SDM IOCTL functions.
 */
#define	EXT_VERSION					5


/*
 * OS independent General definitions
 */
#define	EXT_DEF_SIGNATURE_SIZE				8
#define	EXT_DEF_WWN_NAME_SIZE				8
#define	EXT_DEF_WWP_NAME_SIZE				8
#define	EXT_DEF_SERIAL_NUM_SIZE				4
#define	EXT_DEF_PORTID_SIZE				4
#define	EXT_DEF_PORTID_SIZE_ACTUAL			3
#define	EXT_DEF_MAX_STR_SIZE				128
#define	EXT_DEF_SCSI_PASSTHRU_CDB_LENGTH		12

#define	EXT_DEF_ADDR_MODE_32				1
#define	EXT_DEF_ADDR_MODE_64				2

/*
 * ***********************************************************************
 * X OS type definitions
 * ***********************************************************************
 */
#ifdef _MSC_VER						/* NT */

#pragma pack(1)
#include "ExIoctNT.h"

#elif defined(linux)					/* Linux */

#include "exioctln.h"

#elif defined(sun) || defined(__sun)			/* Solaris */

#include "exioctso.h"

#endif

/*
 * ***********************************************************************
 * OS dependent General configuration defines
 * ***********************************************************************
 */
#define	EXT_DEF_MAX_HBA                 EXT_DEF_MAX_HBA_OS
#define	EXT_DEF_MAX_BUS                 EXT_DEF_MAX_BUS_OS
#define	EXT_DEF_MAX_TARGET              EXT_DEF_MAX_TARGET_OS
#define	EXT_DEF_MAX_LUN                 EXT_DEF_MAX_LUN_OS

/*
 * ***********************************************************************
 * Common header struct definitions for San/Device Mgmt
 * ***********************************************************************
 */
typedef struct {
	UINT64    Signature;			/* 8 chars string */
	UINT16    AddrMode;			/* 2 */
	UINT16    Version;			/* 2 */
	UINT16    SubCode;			/* 2 */
	UINT16    Instance;			/* 2 */
	UINT32    Status;			/* 4 */
	UINT32    DetailStatus;			/* 4 */
	UINT32    Reserved1;			/* 4 */
	UINT32    RequestLen;			/* 4 */
	UINT32    ResponseLen;			/* 4 */
	UINT64    RequestAdr;			/* 8 */
	UINT64    ResponseAdr;			/* 8 */
	UINT16    HbaSelect;			/* 2 */
	UINT16    VendorSpecificStatus[11];	/* 22 */
	UINT64    VendorSpecificData;		/* 8 chars string */
} EXT_IOCTL, *PEXT_IOCTL;			/* 84 / 0x54 */

/*
 * Addressing mode used by the user application
 */
#define	EXT_ADDR_MODE			EXT_ADDR_MODE_OS

/*
 * Status.  These macros are being used for setting Status field in
 * EXT_IOCTL structure.
 */
#define	EXT_STATUS_OK				0
#define	EXT_STATUS_ERR				1
#define	EXT_STATUS_BUSY				2
#define	EXT_STATUS_PENDING			3
#define	EXT_STATUS_SUSPENDED			4
#define	EXT_STATUS_RETRY_PENDING		5
#define	EXT_STATUS_INVALID_PARAM		6
#define	EXT_STATUS_DATA_OVERRUN			7
#define	EXT_STATUS_DATA_UNDERRUN		8
#define	EXT_STATUS_DEV_NOT_FOUND		9
#define	EXT_STATUS_COPY_ERR			10
#define	EXT_STATUS_MAILBOX			11
#define	EXT_STATUS_UNSUPPORTED_SUBCODE		12
#define	EXT_STATUS_UNSUPPORTED_VERSION		13
#define	EXT_STATUS_MS_NO_RESPONSE		14
#define	EXT_STATUS_SCSI_STATUS			15
#define	EXT_STATUS_BUFFER_TOO_SMALL		16
#define	EXT_STATUS_NO_MEMORY			17
#define	EXT_STATUS_UNKNOWN			18
#define	EXT_STATUS_UNKNOWN_DSTATUS		19
#define	EXT_STATUS_INVALID_REQUEST		20

/*
 * Detail Status contains the SCSI bus status codes.
 */

#define	EXT_DSTATUS_GOOD			0x00
#define	EXT_DSTATUS_CHECK_CONDITION		0x02
#define	EXT_DSTATUS_CONDITION_MET		0x04
#define	EXT_DSTATUS_BUSY			0x08
#define	EXT_DSTATUS_INTERMEDIATE		0x10
#define	EXT_DSTATUS_INTERMEDIATE_COND_MET	0x14
#define	EXT_DSTATUS_RESERVATION_CONFLICT	0x18
#define	EXT_DSTATUS_COMMAND_TERMINATED		0x22
#define	EXT_DSTATUS_QUEUE_FULL			0x28

/*
 * Detail Status contains the needed Response buffer space(bytes)
 * when Status = EXT_STATUS_BUFFER_TOO_SMALL
 */


/*
 * Detail Status contains one of the following codes
 * when Status = EXT_STATUS_INVALID_PARAM or
 *             = EXT_STATUS_DEV_NOT_FOUND
 */
#define EXT_DSTATUS_NOADNL_INFO			0x00
#define EXT_DSTATUS_HBA_INST			0x01
#define EXT_DSTATUS_TARGET			0x02
#define EXT_DSTATUS_LUN				0x03
#define EXT_DSTATUS_REQUEST_LEN			0x04
#define EXT_DSTATUS_PATH_INDEX			0x05

/*
 * Currently supported DeviceControl / ioctl command codes
 */
#define	EXT_CC_QUERY			EXT_CC_QUERY_OS
#define	EXT_CC_SEND_FCCT_PASSTHRU	EXT_CC_SEND_FCCT_PASSTHRU_OS
#define	EXT_CC_REG_AEN			EXT_CC_REG_AEN_OS
#define	EXT_CC_GET_AEN			EXT_CC_GET_AEN_OS
#define	EXT_CC_SEND_ELS_RNID		EXT_CC_SEND_ELS_RNID_OS
#define	EXT_CC_SEND_SCSI_PASSTHRU	EXT_CC_SCSI_PASSTHRU_OS
#define	EXT_CC_READ_HOST_PARAMS		EXT_CC_READ_HOST_PARAMS_OS    
#define	EXT_CC_READ_RISC_PARAMS		EXT_CC_READ_RISC_PARAMS_OS    
#define	EXT_CC_UPDATE_HOST_PARAMS	EXT_CC_UPDATE_HOST_PARAMS_OS
#define	EXT_CC_UPDATE_RISC_PARAMS	EXT_CC_UPDATE_RISC_PARAMS_OS
#define	EXT_CC_READ_NVRAM		EXT_CC_READ_NVRAM_OS
#define	EXT_CC_UPDATE_NVRAM		EXT_CC_UPDATE_NVRAM_OS

#define EXT_CC_LOOPBACK                 EXT_CC_LOOPBACK_OS
/*
 * HBA port operations
 */
#define	EXT_CC_GET_DATA			EXT_CC_GET_DATA_OS
#define	EXT_CC_SET_DATA			EXT_CC_SET_DATA_OS

/*
 * The following DeviceControl / ioctl command codes currently are not
 * supported.
 */
#define	EXT_CC_SEND_ELS_RTIN		EXT_CC_SEND_ELS_RTIN_OS


/*
 * ***********************************************************************
 * EXT_IOCTL SubCode definition.
 * These macros are being used for setting SubCode field in EXT_IOCTL
 * structure.
 * ***********************************************************************
 */

/*
 * Query.
 * Uses with EXT_QUERY as the ioctl code.
 */
#define	EXT_SC_QUERY_HBA_NODE		1
#define	EXT_SC_QUERY_HBA_PORT		2
#define	EXT_SC_QUERY_DISC_PORT		3
#define	EXT_SC_QUERY_DISC_TGT		4
#define	EXT_SC_QUERY_DISC_LUN		5	/* Currently Not Supported */
#define	EXT_SC_QUERY_DRIVER		6
#define	EXT_SC_QUERY_FW			7
#define	EXT_SC_QUERY_CHIP		8

/*
 * Get.
 * Uses with EXT_GET_DATA as the ioctl code
 */
/* 1 - 99 Common */
#define	EXT_SC_GET_SCSI_ADDR		1	/* Currently Not Supported */
#define	EXT_SC_GET_ERR_DETECTIONS	2	/* Currently Not Supported */
#define	EXT_SC_GET_STATISTICS		3
#define	EXT_SC_GET_BUS_MODE		4	/* Currently Not Supported */
#define	EXT_SC_GET_DR_DUMP_BUF		5	/* Currently Not Supported */
#define	EXT_SC_GET_RISC_CODE		6
#define	EXT_SC_GET_FLASH_RAM		7

/* 100 - 199 FC_INTF_TYPE */
#define	EXT_SC_GET_LINK_STATUS		101	/* Currently Not Supported */
#define	EXT_SC_GET_LOOP_ID		102	/* Currently Not Supported */
#define	EXT_SC_GET_LUN_BITMASK		103
#define	EXT_SC_GET_PORT_DATABASE	104	/* Currently Not Supported */
#define	EXT_SC_GET_PORT_DATABASE_MEM	105	/* Currently Not Supported */
#define	EXT_SC_GET_PORT_SUMMARY		106
#define	EXT_SC_GET_POSITION_MAP		107
#define	EXT_SC_GET_RETRY_CNT		108	/* Currently Not Supported */
#define	EXT_SC_GET_RNID			109	
#define	EXT_SC_GET_RTIN			110	/* Currently Not Supported */
#define	EXT_SC_GET_FC_LUN_BITMASK	111
#define	EXT_SC_GET_FC_STATISTICS	112

/* 200 - 299 SCSI_INTF_TYPE */
#define	EXT_SC_GET_SEL_TIMEOUT		201	/* Currently Not Supported */


/* 
 * Set.
 * Uses with EXT_SET_DATA as the ioctl code
 */
/* 1 - 99 Common */
#define	EXT_SC_RST_STATISTICS		3	/* Currently Not Supported */
#define	EXT_SC_SET_BUS_MODE		4	/* Currently Not Supported */
#define	EXT_SC_SET_DR_DUMP_BUF		5	/* Currently Not Supported */
#define	EXT_SC_SET_RISC_CODE		6
#define	EXT_SC_SET_FLASH_RAM		7

/* 100 - 199 FC_INTF_TYPE */
#define	EXT_SC_SET_LUN_BITMASK		103
#define	EXT_SC_SET_RETRY_CNT		108	/* Currently Not Supported */
#define	EXT_SC_SET_RNID			109	
#define	EXT_SC_SET_RTIN			110	/* Currently Not Supported */
#define	EXT_SC_SET_FC_LUN_BITMASK	111
#define	EXT_SC_ADD_TARGET_DEVICE	112
#define	EXT_SC_SWAP_TARGET_DEVICE	113

/* 200 - 299 SCSI_INTF_TYPE */
#define	EXT_SC_SET_SEL_TIMEOUT		201	/* Currently Not Supported */

/* SCSI passthrough */
#define	EXT_SC_SEND_SCSI_PASSTHRU	0
#define	EXT_SC_SEND_FC_SCSI_PASSTHRU	1

/* NVRAM */
#define	EXT_SC_NVRAM_HARDWARE		0	/* Save */
#define	EXT_SC_NVRAM_DRIVER		1	/* Driver (Apply) */
#define	EXT_SC_NVRAM_ALL		2	/* NVRAM/Driver (Save+Apply) */

/* Read */

/* Write */

/* Reset */

/* Request struct */


/*
 * Response struct
 */
typedef struct _EXT_HBA_NODE {
	UINT8     WWNN         [EXT_DEF_WWN_NAME_SIZE];	/* 8 */
	UINT8     Manufacturer [EXT_DEF_MAX_STR_SIZE];	/* 128; "QLOGIC" */
	UINT8     Model        [EXT_DEF_MAX_STR_SIZE];	/* 128; "QLA2200" */
	UINT8     SerialNum    [EXT_DEF_SERIAL_NUM_SIZE];/* 4;  123  */
	UINT8     DriverVersion[EXT_DEF_MAX_STR_SIZE];	/* 128; "7.4.3" */
	UINT8     FWVersion    [EXT_DEF_MAX_STR_SIZE];	/* 128; "2.1.6" */

	/* The following field is currently not supported */
	UINT8     OptRomVersion[EXT_DEF_MAX_STR_SIZE];	/* 128; "1.44" */

	UINT16    PortCount;				/* 2; 1 */
	UINT16    InterfaceType;			/* 2; FC/SCSI */

	/* The following two fields are not yet supported */
	UINT32    DriverAttr;				/* 4 */
	UINT32    FWAttr;				/* 4 */

	UINT32    Reserved[8];				/* 32 */
} EXT_HBA_NODE, *PEXT_HBA_NODE;				/* 696 */

/* HBA node query interface type */
#define	EXT_DEF_FC_INTF_TYPE			1
#define	EXT_DEF_SCSI_INTF_TYPE			2

typedef struct _EXT_HBA_PORT {
	UINT8     WWPN[EXT_DEF_WWN_NAME_SIZE];	/* 8 */
	UINT8     Id  [EXT_DEF_PORTID_SIZE];	/* 4; 3 bytes valid Port Id. */
	UINT16    Type;				/* 2; Port Type */
	UINT16    State;			/* 2; Port State */
	UINT16    Mode;				/* 2 */
	UINT16    DiscPortCount;		/* 2 */
	UINT16    DiscPortNameType;		/* 2; USE_NODE_NAME or */
						/* USE_PORT_NAME */
	UINT16    DiscTargetCount;		/* 2 */
	UINT16    Bus;				/* 1 */
	UINT16    Target;			/* 1 */
	UINT16    Lun;				/* 1 */
	UINT16    Unused;			/* 1 */
	UINT32    Reserved[6];			/* 28 */
} EXT_HBA_PORT, *PEXT_HBA_PORT;			/* 56 */

/* port type bit definitions */
#define	EXT_DEF_INITIATOR_DEV		0x1
#define	EXT_DEF_TARGET_DEV		0x2
#define	EXT_DEF_TAPE_DEV		0x4
#define	EXT_DEF_FABRIC_DEV		0x8


/* HBA port state */
#define	EXT_DEF_HBA_OK			0
#define	EXT_DEF_HBA_SUSPENDED		1
#define	EXT_DEF_HBA_LOOP_DOWN		2

/* Connection mode */
#define	EXT_DEF_P2P_MODE		1
#define	EXT_DEF_LOOP_MODE		2

/* Valid name type for Disc. port/target */
#define	EXT_DEF_USE_NODE_NAME		1
#define	EXT_DEF_USE_PORT_NAME		2

typedef struct _EXT_DISC_PORT {
	UINT8     WWNN[EXT_DEF_WWN_NAME_SIZE];	/* 8 */
	UINT8     WWPN[EXT_DEF_WWN_NAME_SIZE];	/* 8 */
	UINT8     Id  [EXT_DEF_PORTID_SIZE];	/* 4; 3 bytes used. big endian*/

	/* The following fields currently are not supported */
	UINT16    Type;				/* 2; Port Type */
	UINT16    Status;			/* 2; Port Status */
	UINT16    Bus;				/* 2; n/a for Solaris */

	UINT16    TargetId;			/* 2 */
	UINT32    Reserved[8];			/* 32 */
} EXT_DISC_PORT, *PEXT_DISC_PORT;		/* 60 */

typedef struct _EXT_DISC_TARGET {
	UINT8     WWNN[EXT_DEF_WWN_NAME_SIZE];	/* 8 */
	UINT8     WWPN[EXT_DEF_WWN_NAME_SIZE];	/* 8 */
	UINT8     Id  [EXT_DEF_PORTID_SIZE];	/* 4; 3 bytes used. big endian*/

	/* The following fields currently are not supported */
	UINT16    Type;				/* 2; Target Type */
	UINT16    Status;			/* 2; Target Status*/
	UINT16    Bus;				/* 2; n/a for Solaris */

	UINT16    TargetId;			/* 2 */

	/* The following field is currently not supported */
	UINT16    LunCount;			/* 2; n/a for nt */

	UINT16    Reserved[15];			/* 30 */
} EXT_DISC_TARGET, *PEXT_DISC_TARGET;		/* 60 */

/* The following command is not supported */
typedef struct _EXT_DISC_LUN {			/* n/a for nt */
	UINT16    Id;				/* 2 */
	UINT16    State;			/* 2 */
	UINT16    IoCount;			/* 2 */
	UINT16    Reserved[15];			/* 30 */
} EXT_DISC_LUN, *PEXT_DISC_LUN;			/* 36 */


/* SCSI address */
typedef struct _EXT_SCSI_ADDR {
	UINT16    Bus;				/* 2 */
	UINT16    Target;			/* 2 */
	UINT16    Lun;				/* 2 */
	UINT16    Padding[5];			/* 10 */
} EXT_SCSI_ADDR, *PEXT_SCSI_ADDR;		/* 16 */


/* Fibre Channel address */
typedef struct _EXT_FC_ADDR {
	union {
		UINT8    WWNN[EXT_DEF_WWN_NAME_SIZE];	/* 8 */
		UINT8    WWPN[EXT_DEF_WWN_NAME_SIZE];	/* 8 */
		UINT8    Id[EXT_DEF_PORTID_SIZE];	/* 4 */
	} FcAddr;
	UINT16    Type;					/* 2 */
	UINT16    Padding[2];				/* 2 */
} EXT_FC_ADDR, *PEXT_FC_ADDR;				/* 24 */

#define	EXT_DEF_TYPE_WWNN                   1
#define	EXT_DEF_TYPE_WWPN                   2
#define	EXT_DEF_TYPE_PORTID                 3
#define	EXT_DEF_TYPE_FABRIC                 4


/* Destination address */
typedef struct _EXT_DEST_ADDR {
	union {
		UINT8    WWNN[EXT_DEF_WWN_NAME_SIZE];	/* 8 */
		UINT8    WWPN[EXT_DEF_WWN_NAME_SIZE];	/* 8 */
		UINT8    Id[EXT_DEF_PORTID_SIZE];	/* 4 */
		struct {
			UINT16    Bus;			/* 2 */
			UINT16    Target;		/* 2 */
		} ScsiAddr;
	} DestAddr;
	UINT16    DestType;				/* 2 */
	UINT16    Lun;					/* 2 */
	UINT16    Padding[2];				/* 4 */
} EXT_DEST_ADDR, *PEXT_DEST_ADDR;			/* 20 */


#define	EXT_DEF_DESTTYPE_WWNN			1
#define	EXT_DEF_DESTTYPE_WWPN			2
#define	EXT_DEF_DESTTYPE_PORTID			3
#define	EXT_DEF_DESTTYPE_FABRIC			4
#define	EXT_DEF_DESTTYPE_SCSI			5

/* Statistic */
typedef struct _EXT_HBA_PORT_STAT {
	UINT32    ControllerErrorCount;		/* 4 */
	UINT32    DeviceErrorCount;		/* 4 */
	UINT32    TotalIoCount;			/* 4 */
	UINT32    TotalMBytes;			/* 4; MB of data processed */
	UINT32    TotalLipResets;		/* 4; Total no. of LIP Reset */
	UINT32    TotalInterrupts;		/* 4; Total no. of Interrupts */
	UINT32    TotalLinkFailures;		/* 4 */
	UINT32    TotalLossOfSync;		/* 4 */
	UINT32    TotalLossOfSignals;		/* 4 */
	UINT32    PrimitiveSeqProtocolErrorCount;/* 4 */
	UINT32    InvalidTransmissionWordCount;	/* 4 */
	UINT32    InvalidCRCCount;		/* 4 */
	UINT32    Reserved[16];			/* 64 */
} EXT_HBA_PORT_STAT, *PEXT_HBA_PORT_STAT;	/* 112 */


/* Driver property */
typedef struct _EXT_DRIVER {
	UINT8     Version[EXT_DEF_MAX_STR_SIZE];/* 128 */
	UINT16    NumOfBus;			/* 2; Port Type */
	UINT16    TargetsPerBus;		/* 2; Port Status */
	UINT16    LunsPerTarget;		/* 2 */
	UINT32    MaxTransferLen;		/* 4 */
	UINT32    MaxDataSegments;		/* 4 */
	UINT16    DmaBitAddresses;		/* 2 */
	UINT16    IoMapType;			/* 2 */
	UINT32    Attrib;			/* 4 */
	UINT32    InternalFlags[4];		/* 16 */
	UINT32    Reserved[8];			/* 32 */
} EXT_DRIVER, *PEXT_DRIVER;			/* 198 */


/* Firmware property */
typedef struct _EXT_FW {
	UINT8     Version[EXT_DEF_MAX_STR_SIZE];/* 128 */
	UINT32    Attrib;			/* 4 */
	UINT16    Reserved[33];			/* 66 */
} EXT_FW, *PEXT_FW;				/* 198 */


/* ISP/Chip property */
typedef struct _EXT_CHIP {
	UINT16    VendorId;			/* 2 */
	UINT16    DeviceId;			/* 2 */
	UINT16    SubVendorId;			/* 2 */
	UINT16    SubSystemId;			/* 2 */
	UINT16    PciBusNumber;			/* 2 */
	UINT16    PciSlotNumber;		/* 2 */
	UINT32    IoAddr;			/* 4 */
	UINT32    IoAddrLen;			/* 4 */
	UINT32    MemAddr;			/* 4 */
	UINT32    MemAddrLen;			/* 4 */
	UINT16    ChipType;			/* 2 */
	UINT16    InterruptLevel;		/* 2 */
	UINT16    OutMbx[8];			/* 16 */
	UINT32    Reserved[8];			/* 32 */
} EXT_CHIP, *PEXT_CHIP;				/* 80 */


/* Request Buffer for RNID */
typedef struct _EXT_RNID_REQ {
	EXT_FC_ADDR Addr;
	UINT8       DataFormat;
	UINT32      Reserved[16];	
} EXT_RNID_REQ, *PEXT_RNID_REQ;	

/* Request Buffer for Set RNID */
typedef struct _EXT_SET_RNID_REQ {
	UINT8     IPVersion[2];
	UINT8     UDPPortNumber[2];
	UINT8     IPAddress[16];
	UINT32    Reserved[16];
} EXT_SET_RNID_REQ, *PEXT_SET_RNID_REQ;

/* RNID definition and data struct */
#define	SEND_RNID_RSP_SIZE  72

typedef struct _RNID_DATA
{
	UINT8     WWN[16];			/* 16 */
	UINT32    UnitType;			/* 4 */
	UINT8     PortId[4];			/* 4 */
	UINT32    NumOfAttachedNodes;		/* 4 */
	UINT8     IPVersion[2];			/* 2 */
	UINT8     UDPPortNumber[2];		/* 2 */
	UINT8     IPAddress[16];		/* 16 */
	UINT16    Reserved;			/* 2 */
	UINT16    TopoDiscFlags;		/* 2 */
} EXT_RNID_DATA, *PEXT_RNID_DATA;		/* 52 */


/* SCSI pass-through */
typedef struct _EXT_SCSI_PASSTHRU {
	EXT_SCSI_ADDR   TargetAddr;
	UINT8           Direction;
	UINT8           CdbLength;
	UINT8           Cdb[EXT_DEF_SCSI_PASSTHRU_CDB_LENGTH];
	UINT32          Reserved[16];
	UINT8           SenseData[256];
} EXT_SCSI_PASSTHRU, *PEXT_SCSI_PASSTHRU;

/* FC SCSI pass-through */
typedef struct _EXT_FC_SCSI_PASSTHRU {
	EXT_DEST_ADDR   FCScsiAddr;
	UINT8           Direction;
	UINT8           CdbLength;
	UINT8           Cdb[EXT_DEF_SCSI_PASSTHRU_CDB_LENGTH];
	UINT32          Reserved[16];
	UINT8           SenseData[256];
} EXT_FC_SCSI_PASSTHRU, *PEXT_FC_SCSI_PASSTHRU;

/* SCSI pass-through direction */
#define	EXT_DEF_SCSI_PASSTHRU_DATA_IN		1
#define	EXT_DEF_SCSI_PASSTHRU_DATA_OUT		2


/* EXT_REG_AEN Request struct */
typedef struct _EXT_REG_AEN {
	UINT32    Enable;	/* 4; non-0 to enable, 0 to disable. */
	UINT32    Reserved;	/* 4 */
} EXT_REG_AEN, *PEXT_REG_AEN;	/* 8 */

/* EXT_GET_AEN Response struct */
typedef struct _EXT_ASYNC_EVENT {
	UINT32	AsyncEventCode;		/* 4 */
	union {
		struct {
			UINT8   RSCNInfo[EXT_DEF_PORTID_SIZE_ACTUAL];/* 3, BE */
			UINT8   AddrFormat;			/* 1 */
			UINT32  Rsvd_1[2];			/* 8 */
		} RSCN;

		UINT32  Reserved[3];	/* 12 */
	} Payload;
} EXT_ASYNC_EVENT, *PEXT_ASYNC_EVENT;	/* 16 */

/* Asynchronous Event Codes */
#define	EXT_DEF_LIP_OCCURRED		0x8010
#define	EXT_DEF_LINK_UP			0x8011
#define	EXT_DEF_LINK_DOWN		0x8012
#define	EXT_DEF_LIP_RESET		0x8013
#define	EXT_DEF_RSCN			0x8015
#define	EXT_DEF_DEVICE_UPDATE		0x8014

/* Required # of entries in the queue buffer allocated. */
#define	EXT_DEF_MAX_AEN_QUEUE		EXT_DEF_MAX_AEN_QUEUE_OS

/* LUN BitMask structure definition, array of 32bit words,
 * 1 bit per lun.  When bit == 1, the lun is masked.
 * Most significant bit of mask[0] is lun 0, bit 24 is lun 7.
 */
typedef struct _EXT_LUN_BIT_MASK {
#if ((EXT_MAX_LUN & 0x7) == 0)
	UINT8	mask[EXT_DEF_MAX_LUN >> 3];
#else
	UINT8	mask[(EXT_DEF_MAX_LUN + 8) >> 3 ];
#endif
} EXT_LUN_BIT_MASK, *PEXT_LUN_BIT_MASK;

/* Device type to get for EXT_SC_GET_PORT_SUMMARY */
#define	EXT_DEF_GET_KNOWN_DEVICE	0x1
#define	EXT_DEF_GET_VISIBLE_DEVICE	0x2
#define	EXT_DEF_GET_HIDDEN_DEVICE	0x4
#define	EXT_DEF_GET_FABRIC_DEVICE	0x8
#define	EXT_DEF_GET_LOOP_DEVICE		0x10

/* Each entry in device database */
typedef struct _EXT_DEVICEDATAENTRY
{
	UINT8		NodeWWN[8];	/* Node World Wide Name for device */
	UINT8		PortWWN[8];	/* Port World Wide Name for device */
	UINT8		PortID[3];	/* Current PortId for device */
	UINT8		ControlFlags;	/* Control flag */
	EXT_SCSI_ADDR	TargetAddress;	/* scsi address */
	UINT32		DeviceFlags;	/* Flags for device */
	UINT16		LoopID;		/* Loop ID */
	UINT16		BaseLunNumber;  
	UINT32		Reserved[32];
} EXT_DEVICEDATAENTRY, *PEXT_DEVICEDATAENTRY;

#define	EXT_DEF_EXTERNAL_LUN_COUNT          2048
#define	EXT_DEF_EXTERNAL_LUN_BITMASK_BYTES  (EXT_DEF_EXTERNAL_LUN_COUNT / 8)

/* Structure as used in the IOCTL. */

typedef struct _EXT_EXTERNAL_LUN_BITMASK_ENTRY
{
	UINT8	NodeName[EXT_DEF_WWN_NAME_SIZE];
	UINT8	PortName[EXT_DEF_WWN_NAME_SIZE];

	UINT32	Reserved2;
	UINT32	Reserved3;
	UINT32	Reserved4;
	UINT32	Reserved5;     /* Pad to 32-byte header.*/

	UINT8	Bitmask[EXT_DEF_EXTERNAL_LUN_BITMASK_BYTES];
} EXT_EXTERNAL_LUN_BITMASK_ENTRY, *PEXT_EXTERNAL_LUN_BITMASK_ENTRY;


/* Structure as it is stored in the NT registry.*/

typedef struct _LUN_BITMASK_LIST
{
	UINT16	Version;       /* Should be LUN_BITMASK_REGISTRY_VERSION */
	UINT16	EntryCount;    /* Count of variable entries following.*/
	UINT32	Reserved1;
	UINT32	Reserved2;
	UINT32	Reserved3;
	UINT32	Reserved4;
	UINT32	Reserved5;
	UINT32	Reserved6;
	UINT32	Reserved7;     /* Pad to 32-byte header.*/

	EXT_EXTERNAL_LUN_BITMASK_ENTRY BitmaskEntry[1];
		               /* Variable-length data.*/

} EXT_LUN_BITMASK_LIST, *PEXT_LUN_BITMASK_LIST;


/* Device database information */
typedef struct _EXT_DEVICEDATA
{
	UINT32	TotalDevices;          /* Set to total number of device. */
	UINT32	ReturnListEntryCount;  /* Set to number of device entries */
		                       /* returned in list. */

	EXT_DEVICEDATAENTRY  EntryList[1]; /* Variable length */
} EXT_DEVICEDATA, *PEXT_DEVICEDATA;


/* Swap Target Device Data structure */
typedef struct _EXT_SWAPTARGETDEVICE
{
	EXT_DEVICEDATAENTRY CurrentExistDevice;
	EXT_DEVICEDATAENTRY NewDevice;
} EXT_SWAPTARGETDEVICE, *PEXT_SWAPTARGETDEVICE;

#define	EXT_DEF_LUN_BITMASK_LIST_MIN_ENTRIES	1
#define	EXT_DEF_LUN_BITMASK_LIST_MAX_ENTRIES	256

#ifdef _WIN64
#define	EXT_DEF_LUN_BITMASK_LIST_HEADER_SIZE	32
#else
#define	EXT_DEF_LUN_BITMASK_LIST_HEADER_SIZE \
    offsetof(LUN_BITMASK_LIST_BUFFER, asBitmaskEntry)
#endif

#define	EXT_DEF_LUN_BITMASK_LIST_MIN_SIZE   \
    (EXT_DEF_LUN_BITMASK_LIST_HEADER_SIZE + \
    (sizeof(EXT_EXTERNAL_LUN_BITMASK_ENTRY) * EXT_DEF_LUN_BITMASK_LIST_MIN_ENTRIES))
#define	EXT_LUN_BITMASK_LIST_MAX_SIZE   \
    (EXT_LUN_BITMASK_LIST_HEADER_SIZE + \
    (sizeof(EXT_EXTERNAL_LUN_BITMASK_ENTRY) * EXT_DEF_LUN_BITMASK_LIST_MAX_ENTRIES))
/*
 * LUN mask bit manipulation macros
 *
 *   P = Pointer to an EXT_LUN_BIT_MASK union.
 *   L = LUN number.
 */
#define EXT_IS_LUN_BIT_SET(P,L) \
    ((P->mask[L/8] & (0x80 >> (L%8)))?1:0)

#define EXT_SET_LUN_BIT(P,L) \
    (P->mask[L/8] |= (0x80 >> (L%8)))

#define EXT_CLR_LUN_BIT(P,L) \
    (P->mask[L/8] &= ~(0x80 >> (L%8)))



#ifdef _MSC_VER
#pragma pack()
#endif

#endif /* _EXIOCT_H */
