/*++
 * Adaptec aacraid device driver for Linux.
 *
 * Copyright (c) 2000 Adaptec, Inc. (aacraid@adaptec.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Module Name:
 *   port.h
 *
 * Abstract: This module defines functions and structures that are in common among all miniports
 *
 *	
 --*/

#ifndef _PORT_
#define _PORT_

static char *ident_porth = "aacraid_ident port.h 1.0.6 2000/10/09 Adaptec, Inc.";

#ifdef DBG
#define AfaPortPrint if (AfaPortPrinting) DbgPrint
extern int AfaPortPrinting;
#else
#define AfaPortPrint 
#endif /* DBG */

extern int AfaPortPrinting;


BOOLEAN
AfaPortAllocateAdapterCommArea(
	IN PVOID		Arg1,
	IN OUT PVOID	*CommHeaderAddress,
	IN ULONG		CommAreaSize,
	IN ULONG		CommAreaAlignment
	);


BOOLEAN
AfaPortFreeAdapterCommArea(
	IN PVOID		Arg1
	);


AAC_STATUS
AfaPortBuildSgMap(
	PVOID Arg1,
	IN PSGMAP_CONTEXT SgMapContext
	);


VOID
AfaPortFreeDmaResources(
	PVOID Arg1,
    IN PSGMAP_CONTEXT SgMapContext
    );


BOOLEAN
AfaPortAllocateAndMapFibSpace(
	PVOID Arg1,
    IN PMAPFIB_CONTEXT MapFibContext
    );


BOOLEAN
AfaPortUnmapAndFreeFibSpace(
	PVOID Arg1,
    IN PMAPFIB_CONTEXT MapFibContext
    );


#endif // _PORT_

