/*++
 * Adaptec aacraid device driver for Linux.
 *
 * Copyright (c) 2000 Adaptec, Inc. (aacraid@adaptec.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Module Name:
 *   perfpack.h
 *
 * Abstract: This file defines the layout of the performance data that is passed
 *           back from the FSA filesystem driver.
 *
 *	
 --*/

#ifndef _FSA_PERFPACK_H_
#define _FSA_PERFPACK_H_	1

static char *ident_perf = "aacraid_ident perfpack.h 1.0.6 2000/10/09 Adaptec, Inc.";

//#define FSA_DO_PERF		1		/* enable the engineering counters */

#ifdef FSA_DO_PERF
//
// engineering counters
//
typedef struct _FSA_PERF_DATA {
			ULONG FibsSent;
			ULONG ReadDirs;
			ULONG GetAttrs;
			ULONG SetAttrs;
			ULONG Lookups;
			ULONG ReadFibs;
			ULONG WriteFibs;
			ULONG CreateFibs;
			ULONG MakeDirs;
			ULONG RemoveFibs;
			ULONG RemoveDirs;
			ULONG RenameFibs;
			ULONG ReadDirPlus;
			ULONG FsStat;
			ULONG WriteBytes;
			ULONG ReadBytes;
// NT FSA entry points
			ULONG FsaFsdCreateCount;
			ULONG FsaFsdCloseCount;
			ULONG FsaFsdReadCount;
			ULONG FsaFsdWriteCount;
			ULONG FsaFsdQueryInformationCount;

			struct _FsaFsdSetInfomation{
				ULONG FsaSetAllocationInfoCount;
				ULONG FsaSetBasicInfoCount;
				ULONG FsaSetDispositionInfoCount;
				ULONG FsaSetEndOfFileInfoCount;
				ULONG FsaSetPositionInfoCount;
				ULONG FsaSetRenameInfoCount;
				ULONG FsaClearArchiveBitCount;
			};

			ULONG FsaFsdFlushBuffersCount;
			ULONG FsaFsdQueryVolumeInfoCount;
			ULONG FsaFsdSetVolumeInfoCount;
			ULONG FsaFsdCleanupCount;
			ULONG FsaFsdDirectoryControlCount;
			ULONG FsaFsdFileSystemControlCount;
			ULONG FsaFsdLockControlCount;
			ULONG FsaFsdDeviceControlCount;
			ULONG FsaFsdShutdownCount;
			ULONG FsaFsdQuerySecurityInfo;
			ULONG FsaFsdSetSecurityInfo;
			ULONG FastIoCheckIfPossibleCount;
			ULONG FastIoReadCount;
			ULONG FastIoWriteCount;
			ULONG FastIoQueryBasicInfoCount;
			ULONG FastIoQueryStandardInfoCount;
			ULONG FastIoLockCount;
			ULONG FastIoUnlockSingleCount;
			ULONG FastIoUnlockAllCount;
			ULONG FastIoUnlockAllByKeyCount;
			ULONG FastIoDeviceControlCount;
 } FSA_PERF_DATA;

typedef FSA_PERF_DATA *PFSA_PERF_DATA;


#else /* FSA_DO_PERF */

//
// engineering performance counters are disabled
//
#define FSA_DO_PERF_INC(Counter)		/* */
#define FSA_DO_FSP_PERF_INC(Counter)	/* */

#endif /* FSA_DO_PERF */

#endif // _FSA_PERFPACK_H_
