/*++
 * Adaptec aacraid device driver for Linux.
 *
 * Copyright (c) 2000 Adaptec, Inc. (aacraid@adaptec.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Module Name:
 *   pcisup.h
 *
 * Abstract: This module defines functions that are defined in PciSup.c
 *
 --*/
#ifndef _PCISUP_
#define _PCISUP_

static char *ident_pcisup = "aacraid_ident pcisup.h 1.0.6 2000/10/09 Adaptec, Inc.";

	
/*
 * define which interrupt handler needs to be installed
 */

#define SaISR	1
#define RxISR	2

typedef struct _PCI_MINIPORT_COMMON_EXTENSION {
	ULONG					AdapterNumber;			// Which FSA# this miniport is
	
	ULONG					PciBusNumber;			// Which PCI bus we are located on
	ULONG					PciSlotNumber;			// Whiat PCI slot we are in
	
	PVOID					Adapter;				// Back pointer to Fsa adapter object
	ULONG					AdapterIndex;			// Index into PlxAdapterTypes array
	PDEVICE_OBJECT			DeviceObject;			// Pointer to our device object
	
	FSAPORT_FUNCS			AdapterFuncs;
	ULONG					FilesystemRevision; 	// Main driver's revision number
	
	
	PADAPTER_INIT_STRUCT	InitStruct;				// Holds initialization info to communicate with adapter
	PVOID					PhysicalInitStruct; 	// Holds physical address of the init struct
	
	
	PVOID					PrintfBufferAddress;	// pointer to buffer used for printf's from the adapter
	
	BOOLEAN 				AdapterPrintfsToScreen; 		
	BOOLEAN 				AdapterConfigured;		// set to true when we know adapter can take FIBs
	
	void *					MiniPort;
	
	caddr_t					CommAddress;	// Base address of Comm area
	paddr32_t				CommPhysAddr;	// Physical Address of Comm area
	size_t					CommSize;

	OsKI_t 					OsDep;			// OS dependent kernel interfaces

	
} PCI_MINIPORT_COMMON_EXTENSION;

typedef PCI_MINIPORT_COMMON_EXTENSION *PPCI_MINIPORT_COMMON_EXTENSION;

typedef int
(*PFSA_MINIPORT_INIT) (
	IN PPCI_MINIPORT_COMMON_EXTENSION CommonExtension,
	IN ULONG AdapterNumber,
	IN ULONG PciBus,
	IN ULONG PciSlot
	);

typedef struct _FSA_MINIPORT {
	USHORT				VendorId;
	USHORT				DeviceId;
	USHORT				SubVendorId;
	USHORT				SubSystemId;
	PCHAR				DevicePrefix;
  PFSA_MINIPORT_INIT	InitRoutine;
  PCHAR               DeviceName;
  PCHAR               Vendor;
  PCHAR               Model;
} FSA_MINIPORT;
typedef FSA_MINIPORT *PFSA_MINIPORT;


#endif // _PCISUP_
