/*++
 * Adaptec aacraid device driver for Linux.
 *
 * Copyright (c) 2000 Adaptec, Inc. (aacraid@adaptec.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Module Name:
 *   fsaport.h
 *
 * Abstract: This module defines all of the globally used procedures in the FSA
 *           file system.
 *
 *
 *
 --*/
#ifndef _FSAPORT_
#define _FSAPORT_

static char *ident_fsaport = "aacraid_ident fsaport.h 1.0.6 2000/10/09 Adaptec, Inc.";

//
// The scatter/gather map context is the information we 
// we need to keep the map and transfer data to and from the
// adapter.
//

typedef struct _SGMAP_CONTEXT {
	
	caddr_t		BaseAddress;
    PVOID 		MapRegBase;
    ULONG 		NumberMapRegs;
	PSGMAP		SgMapPtr;
	ULONG		ByteCount;		// Used to check the Mdl length.
	BOOLEAN		WriteToDevice;

	struct buf	*bp;


} SGMAP_CONTEXT;
typedef SGMAP_CONTEXT *PSGMAP_CONTEXT;

typedef struct _MAPFIB_CONTEXT {
	PMDL		Mdl;    
    PVOID 		MapRegBase;
    ULONG 		NumberMapRegs;
	PVOID		FibVirtualAddress;
	ULONG		Size;
	PVOID	    FibPhysicalAddress;


} MAPFIB_CONTEXT;
typedef MAPFIB_CONTEXT *PMAPFIB_CONTEXT;

typedef BOOLEAN
(*PFSA_ALLOCATE_ADAPTER_COMM_AREA)(
	PVOID AdapterExtension,
	IN OUT PVOID	*BaseAddress,
	IN ULONG		Size,
	IN ULONG		Alignment
	);

typedef BOOLEAN
(*PFSA_FREE_ADAPTER_COMM_AREA)(
	PVOID	AdapterExtension
	);

typedef VOID
(*PFSA_FREE_DMA_RESOURCES)(	 
	IN PVOID AdapterExtension,
    IN PSGMAP_CONTEXT SgMapContext
    );

typedef BOOLEAN
(*PFSA_ALLOCATE_AND_MAP_FIB_SPACE)(
	IN PVOID AdapterExtension, 
	IN PMAPFIB_CONTEXT MapFibContext
    );

typedef BOOLEAN
(*PFSA_UNMAP_AND_FREE_FIB_SPACE)(
	IN PVOID AdapterExtension, 
	IN PMAPFIB_CONTEXT MapFibContext
    );

typedef VOID
(*PFSA_INTERRUPT_ADAPTER)(
	IN PVOID AdapterExtension
	);

typedef VOID
(*PFSA_NOTIFY_ADAPTER)(
	IN PVOID AdapterExtension,
    IN HOST_2_ADAP_EVENT AdapterEvent
    );

typedef VOID
(*PFSA_RESET_DEVICE)(
	PVOID AdapterExtension
	);

typedef AAC_STATUS
(*PFSA_BUILD_SGMAP)(  
	IN PVOID AdapterExtension,
	IN PSGMAP_CONTEXT SgMapContext
	);

typedef PVOID
(*PFSA_ADAPTER_ADDR_TO_SYSTEM_ADDR)(  
	IN PVOID AdapterExtension,
	IN PVOID AdapterAddress
	);

typedef VOID
(*PFSA_INTERRUPT_HOST)(
	PVOID			Adapter,
	ADAPTER_EVENT	AdapterEvent
	);

typedef VOID
(*PFSA_ENABLE_INTERRUPT)(
	PVOID			Adapter,
	ADAPTER_EVENT	AdapterEvent,
	BOOLEAN			AtDeviceIrq
	);


typedef VOID
(*PFSA_DISABLE_INTERRUPT)(
	PVOID			Adapter,
	ADAPTER_EVENT	AdapterEvent,
	BOOLEAN			AtDeviceIrq
	);

typedef AAC_STATUS
(*PFSA_OPEN_ADAPTER) (
	IN PVOID Adapter
	);

typedef int
(*PFSA_DEVICE_CONTROL) (
	IN PVOID Adapter,
	IN PAFA_IOCTL_CMD IoctlCmdPtr
	);

typedef AAC_STATUS
(*PFSA_CLOSE_ADAPTER) (
	IN PVOID Adapter
	);

typedef BOOLEAN
(*PFSA_SEND_SYNCH_FIB) (
	IN PVOID Adapter,
	IN ULONG FibPhysicalAddress
	);

typedef struct _FSAPORT_FUNCS {
	ULONG								SizeOfFsaPortFuncs;

	PFSA_ALLOCATE_ADAPTER_COMM_AREA		AllocateAdapterCommArea;
	PFSA_FREE_ADAPTER_COMM_AREA			FreeAdapterCommArea;
	PFSA_FREE_DMA_RESOURCES				FreeDmaResources;
	PFSA_ALLOCATE_AND_MAP_FIB_SPACE		AllocateAndMapFibSpace;
	PFSA_UNMAP_AND_FREE_FIB_SPACE		UnmapAndFreeFibSpace;
	PFSA_INTERRUPT_ADAPTER				InterruptAdapter;
	PFSA_NOTIFY_ADAPTER					NotifyAdapter;
	PFSA_ENABLE_INTERRUPT				EnableInterrupt;
	PFSA_DISABLE_INTERRUPT				DisableInterrupt;
	PFSA_RESET_DEVICE					ResetDevice;
	PFSA_BUILD_SGMAP					BuildSgMap;
	PFSA_ADAPTER_ADDR_TO_SYSTEM_ADDR	AdapterAddressToSystemAddress;

	PFSA_INTERRUPT_HOST					InterruptHost;
	PFSA_OPEN_ADAPTER					OpenAdapter;
	PFSA_DEVICE_CONTROL					DeviceControl;
	PFSA_CLOSE_ADAPTER					CloseAdapter;

	PFSA_SEND_SYNCH_FIB					SendSynchFib;

} FSAPORT_FUNCS;
typedef FSAPORT_FUNCS *PFSAPORT_FUNCS;

typedef AAC_STATUS
(*PFSA_SETVAR_CALLBACK) (
	IN PVOID Adapter,
	IN ULONG NewValue
	);

typedef struct _FSA_USER_VAR {
	char					Name[32];
	ULONG					*Address;
	PFSA_SETVAR_CALLBACK	SetVarCallback;
} FSA_USER_VAR;

typedef FSA_USER_VAR *PFSA_USER_VAR;

typedef struct _FSA_NEW_ADAPTER {
	PVOID				AdapterExtension;
	PFSAPORT_FUNCS		AdapterFuncs;
	PVOID				Adapter;
	BOOLEAN				AdapterInterruptsBelowDpc;
	PFSA_USER_VAR		AdapterUserVars;
	ULONG				AdapterUserVarsSize;
	void				*Dip;
} FSA_NEW_ADAPTER;
typedef FSA_NEW_ADAPTER *PFSA_NEW_ADAPTER;

#define	FSAFS_GET_NEXT_ADAPTER			CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 2048, METHOD_NEITHER, FILE_ANY_ACCESS)
#define	FSAFS_INIT_NEW_ADAPTER			CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 2049, METHOD_NEITHER, FILE_ANY_ACCESS)

#endif
