/*++
 * Adaptec aacraid device driver for Linux.
 *
 * Copyright (c) 2000 Adaptec, Inc. (aacraid@adaptec.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Module Name:
 *   commerr.h
 *
 * Abstract: This file defines all errors that are unique to the Adaptec Fsa Filesystem
 *
 *
 *
 --*/

#ifndef _FSAERR_
#define _FSAERR_

static char *ident_commerr = "aacraid_ident commerr.h 1.0.6 2000/10/09 Adaptec, Inc.";

//
//  Note: comments in the .mc file must use both ";" and "//".
//
//  Status values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-------------------------+-------------------------------+
//  |Sev|C|       Facility          |               Code            |
//  +---+-+-------------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//


//
// %1 is reserved by the IO Manager. If IoAllocateErrorLogEntry is
// called with a device, the name of the device will be inserted into
// the message at %1. Otherwise, the place of %1 will be left empty.
// In either case, the insertion strings from the driver's error log
// entry starts at %2. In other words, the first insertion string goes
// to %2, the second to %3 and so on.
//

//
//  Values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//


#define FACILITY_FSAFS_ERROR_CODE        0x7



//
// MessageId: FSAFS_FIB_INVALID
//
// MessageText:
//
//  A communication packet was detected to be formatted poorly. Please Contact Adaptec support.
//
#define FSAFS_FIB_INVALID                ((AAC_STATUS)0xE0070009L)


//
// MessageId: FSAFS_TIMED_OUT_FIB_COMPLETED
//
// MessageText:
//
//  A Fib previously timed out by host has been completed by the adapter. (\\.\Afa%2)
//
#define FSAFS_TIMED_OUT_FIB_COMPLETED    ((AAC_STATUS)0xA007000EL)

#endif /* _FSAERR_ */
