/*++
 * Adaptec aacraid device driver for Linux.
 *
 * Copyright (c) 2000 Adaptec, Inc. (aacraid@adaptec.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Module Name:
 *   AfaComm.h
 *
 * Abstract:
 *   This module defines all of the external interfaces to the AFA comm layer.
 *
 *
 *
 --*/
#ifndef _AFACOMM_
#define _AFACOMM_

static char *ident_afacomm = "aacraid_ident afacomm.h 1.0.6 2000/10/09 Adaptec, Inc.";

#include "fsaport.h"

typedef void	*PFIB_CONTEXT;

typedef VOID
(*PFIB_CALLBACK)(
	PVOID		FibCallbackContext,
	PFIB_CONTEXT	FibContext,
	AAC_STATUS	Status
	);


typedef PFIB_CONTEXT
(*PAFA_COMM_ALLOCATE_FIB) (
	IN PVOID AdapterExtension
    );

typedef VOID
(*PAFA_COMM_FREE_FIB) (
    IN PFIB_CONTEXT FibContext
    );


typedef AAC_STATUS
(*PAFA_COMM_DEALLOCATE_FIB) (
    IN PFIB_CONTEXT FibContext
    );


typedef VOID
(*PAFA_COMM_FREE_FIB_FROM_DPC) (
    IN PFIB_CONTEXT FibContext
    );

typedef AAC_STATUS
(*PAFA_COMM_INITIALIZE_FIB) (
	IN PFIB_CONTEXT FibContext
    );

typedef PVOID
(*PAFA_COMM_GET_FIB_DATA) (
	IN PFIB_CONTEXT FibContext
	);

typedef AAC_STATUS
(*PAFA_COMM_SEND_FIB) (
    IN FIB_COMMAND Command, 
	IN PFIB_CONTEXT FibContext,
    IN ULONG Size,
    IN COMM_PRIORITIES Priority,
    IN BOOLEAN Wait,
    IN PVOID WaitOn,
    IN BOOLEAN ResponseExpected,
	IN PFIB_CALLBACK FibCallback,
	IN PVOID FibCallbackContext
    );

typedef AAC_STATUS
(*PAFA_COMM_COMPLETE_FIB) (
	IN PFIB_CONTEXT FibContext
    );

typedef AAC_STATUS
(*PAFA_COMM_COMPLETE_ADAPTER_FIB) (
	IN PFIB_CONTEXT FibContext,
	IN USHORT Size
    );

typedef BOOLEAN
(*PAFA_COMM_SEND_SYNCH_FIB) (
	PVOID 			AdapterExtension,
	FIB_COMMAND  	Command,
	PVOID			Data,
	USHORT		 	Size,
	PVOID			Response,
	USHORT		 	*ResponseSize
	);


typedef struct _AFACOMM_FUNCS {
	ULONG					SizeOfAfaCommFuncs;
	PAFA_COMM_ALLOCATE_FIB			AllocateFib;
	PAFA_COMM_FREE_FIB			FreeFib;
	PAFA_COMM_FREE_FIB_FROM_DPC		FreeFibFromDpc;
	PAFA_COMM_DEALLOCATE_FIB		DeallocateFib;
	PAFA_COMM_INITIALIZE_FIB		InitializeFib;
	PAFA_COMM_GET_FIB_DATA			GetFibData;
	PAFA_COMM_SEND_FIB			SendFib;
	PAFA_COMM_COMPLETE_FIB			CompleteFib;
	PAFA_COMM_COMPLETE_ADAPTER_FIB		CompleteAdapterFib;
	PAFA_COMM_SEND_SYNCH_FIB		SendSynchFib;
	PFSA_FREE_DMA_RESOURCES			FreeDmaResources;
	PFSA_BUILD_SGMAP			BuildSgMap;
	PFSA_ADAPTER_ADDR_TO_SYSTEM_ADDR	AdapterAddressToSystemAddress;
} AFACOMM_FUNCS;
typedef AFACOMM_FUNCS *PAFACOMM_FUNCS;


typedef AAC_STATUS
(*PAFA_CLASS_OPEN_ADAPTER) (
	IN PVOID Adapter
	);


typedef AAC_STATUS
(*PAFA_CLASS_CLOSE_ADAPTER) (
	IN PVOID Adapter
	);


typedef BOOLEAN
(*PAFA_CLASS_DEV_CONTROL) (
	IN PVOID Adapter,
	IN PAFA_IOCTL_CMD	IoctlCmdPtr,
	OUT int * Status
	);

typedef BOOLEAN
(*PAFA_CLASS_HANDLE_AIF) (
	IN PVOID Adapter,
	IN PFIB_CONTEXT FibContext
	);


typedef struct _AFA_NEW_CLASS_DRIVER {
	PVOID			        ClassDriverExtension;
	PAFA_CLASS_OPEN_ADAPTER	        OpenAdapter;
        PAFA_CLASS_CLOSE_ADAPTER	CloseAdapter;
        PAFA_CLASS_DEV_CONTROL 	        DeviceControl;
	PAFA_CLASS_HANDLE_AIF	        HandleAif;
	PFSA_USER_VAR			UserVars;
	ULONG				NumUserVars;
} AFA_NEW_CLASS_DRIVER;
typedef AFA_NEW_CLASS_DRIVER *PAFA_NEW_CLASS_DRIVER;


typedef struct _AFA_NEW_CLASS_DRIVER_RESPONSE {
	PAFACOMM_FUNCS		CommFuncs;
	PVOID			CommPortExtension;
	PVOID			MiniPortExtension;
	OS_SPINLOCK_COOKIE	SpinLockCookie;
	void			*Dip;
} AFA_NEW_CLASS_DRIVER_RESPONSE;
typedef AFA_NEW_CLASS_DRIVER_RESPONSE *PAFA_NEW_CLASS_DRIVER_RESPONSE;


typedef struct _AFA_CLASS_DRIVER {
	struct _AFA_CLASS_DRIVER	*Next;
	PVOID				ClassDriverExtension;
	PAFA_CLASS_OPEN_ADAPTER		OpenAdapter;
	PAFA_CLASS_CLOSE_ADAPTER	CloseAdapter;
	PAFA_CLASS_DEV_CONTROL 		DeviceControl;
	PAFA_CLASS_HANDLE_AIF		HandleAif;
} AFA_CLASS_DRIVER;
typedef AFA_CLASS_DRIVER *PAFA_CLASS_DRIVER;


#endif // _AFACOMM_
