/*****************************************************************************
 *****************************************************************************

 Copyright (c) 1999-2001 Intel Corporation. 

 All rights reserved.

 Redistribution and use in source and binary forms, with or without 
 modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, 
     this list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice,
     this list of conditions and the following disclaimer in the documentation 
     and/or other materials provided with the distribution.

  3. Neither the name of Intel Corporation nor the names of its contributors 
     may be used to endorse or promote products derived from this software 
     without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

 *****************************************************************************
 *****************************************************************************/

/*************************************************************************/
/*! \file   e1000.h
 *  \author Intel Corporation
 *  \date   1999-2001
 *  \brief  Linux PRO/1000 Ethernet Driver main header file
 *************************************************************************/

#ifndef _E1000_H_
#define _E1000_H_


#include <linux/config.h>
#include "e1000_kcompat.h"
#include <linux/module.h>
#include <linux/types.h>
#include <asm/byteorder.h>


#include "e1000_fxhw.h"
#include "e1000_phy.h"

#ifdef IANS
#include "base_comm.h"
#include "ans_driver.h"
#include "ans.h"
#endif

#ifdef IDIAG
#include "idiag_pro.h"
#include "idiag_e1000.h"
#include "e1000_idiag.h"
#endif

#define PCI_DEVICE_ID_82542        0x1000
#define PCI_DEVICE_ID_82543GC_FIBER  0x1001
#define PCI_DEVICE_ID_82543GC_COPPER 0x1004
#define PCI_DEVICE_ID_82544EI_COPPER 0x1008
#define PCI_DEVICE_ID_82544GC_CREB   0x100D
#define BAR_0 0

/* 8254x can use Dual Address Cycles for 64-bit addressing */
/* Advertise that we can DMA from any address location */
#define E1000_DMA_MASK (~0x0UL)
#define E1000_DBG(args...)
// #define E1000_DBG(args...) printk("e1000: " args)
#define E1000_ERR(args...) printk(KERN_ERR "e1000: " args)
#define E1000_MAX_INTR 10
#define MAX_NUM_MULTICAST_ADDRESSES 128

#include <linux/init.h>
#include <linux/mm.h>
#include <linux/errno.h>
#include <linux/ioport.h>
#include <linux/pci.h>
#include <linux/kernel.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/delay.h>
#include <linux/timer.h>
#include <linux/slab.h>
#include <linux/interrupt.h>
#include <linux/string.h>
#include <linux/pagemap.h>
#include <asm/bitops.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <linux/capability.h>
#include <linux/in.h>
#include <linux/ip.h>
#include <linux/tcp.h>
#include <linux/udp.h>
#include <net/pkt_sched.h>
#include <linux/ethtool.h>
#include <asm/uaccess.h>

#define B_TRUE  1
#define B_FALSE 0
#define TRUE    1
#define FALSE   0

/* command line options defaults */
#define DEFAULT_TXD     256
#define MAX_TXD         256
#define MIN_TXD          80
#define DEFAULT_RXD     256
#define MAX_RXD         256
#define MIN_RXD          80
#define DEFAULT_TIDV     64
#define MAX_TIDV     0xFFFF
#define MIN_TIDV          0
#define DEFAULT_RIDV     64
#define MAX_RIDV     0xFFFF
#define MIN_RIDV          0

#define OPTION_UNSET    -1
#define OPTION_DISABLED 0
#define OPTION_ENABLED  1
#define JUMBO_DEFAULT        OPTION_ENABLED
#define XSUMRX_DEFAULT       OPTION_ENABLED
#define WAITFORLINK_DEFAULT  OPTION_ENABLED
#define AUTONEG_ADV_DEFAULT  0x2F
#define AUTONEG_ADV_MASK     0x2F
#define FLOW_CONTROL_DEFAULT FLOW_CONTROL_FULL

#define E1000_REPORT_TX_EARLY  2
#define E1000_PCI_MWI_ENABLE   1
#define E1000_PCI_MLT_OVERRIDE 0

#define E1000_BUS_TYPE_PCI               1
#define E1000_BUS_TYPE_PCIX              2

#define E1000_BUS_SPEED_PCI_33MHZ        1
#define E1000_BUS_SPEED_PCI_66MHZ        2
#define E1000_BUS_SPEED_PCIX_50_66MHZ    3
#define E1000_BUS_SPEED_PCIX_66_100MHZ   4
#define E1000_BUS_SPEED_PCIX_100_133MHZ  5
#define E1000_BUS_SPEED_PCIX_RESERVED    6

#define E1000_BUS_WIDTH_32_BIT           1
#define E1000_BUS_WIDTH_64_BIT           2

/* Supported RX Buffer Sizes */
#define E1000_RXBUFFER_2048        2048
#define E1000_RXBUFFER_4096        4096
#define E1000_RXBUFFER_8192        8192
#define E1000_RXBUFFER_16384      16384

#define ETH_LENGTH_OF_ADDRESS 6

#define RET_STATUS_SUCCESS 0
#define RET_STATUS_FAILURE 1

#define E1000_PCI

/* The size in bytes of a standard ethernet header */
#define ENET_HEADER_SIZE    14
#define MAX_INTS            256
#define CRC_LENGTH 4

#define MAXIMUM_ETHERNET_PACKET_SIZE    1514
#define RCV_PKT_MUL              5

/* Round size up to the next multiple of unit */
#define E1000_ROUNDUP(size, unit) ((((size) + (unit) - 1) / (unit)) * (unit))
/* This is better, but only works for unit sizes that are powers of 2 */
#define E1000_ROUNDUP2(size, unit) (((size) + (unit) - 1) & ~((unit) - 1))

/* wrapper around a pointer to a socket buffer,
 * so a DMA handle can be stored along with the buffer */
struct e1000_buffer {
	struct sk_buff *skb;
	uint64_t dma;
	unsigned long length;
};

/* Adapter->flags definitions */
#define E1000_BOARD_OPEN 0

typedef enum _XSUM_CONTEXT_T {
	OFFLOAD_NONE,
	OFFLOAD_TCP_IP,
	OFFLOAD_UDP_IP
} XSUM_CONTEXT_T;

/* board specific private data structure */

struct adapter;
struct adapter {
	struct adapter *next;
	struct adapter *prev;

#ifdef IANS
	void *iANSReserved;
	piANSsupport_t iANSdata;
	u32 ans_link;
	u32 ans_speed;
	u32 ans_duplex;
	u32 ans_suspend;
	IANS_BD_TAGGING_MODE tag_mode;
#endif

	/* MMIO PCI Registers */
	volatile PE1000_REGISTERS HardwareVirtualAddress;

	spinlock_t stats_lock;
	spinlock_t rx_fill_lock;

	u32 flags;
	u32 bd_number;
	struct timer_list timer_id;

	/* Ethernet Node Address */
	u8 CurrentNetAddress[ETH_LENGTH_OF_ADDRESS];
	u8 PermNetAddress[ETH_LENGTH_OF_ADDRESS];

	/* Mac and Phy Settings */
	u8 MacType;
	u8 MediaType;
	u32 PhyId;
	u32 PhyAddress;

	/* MAC Configuration */
	u8 AutoNeg;
	u8 ForcedSpeedDuplex;
	u16 AutoNegAdvertised;
	u8 WaitAutoNegComplete;

	/* Status Flags */
	unsigned char LinkIsActive;
	u16 LineSpeed;
	u16 FullDuplex;
	unsigned char GetLinkStatus;
	unsigned char LinkStatusChanged;
	unsigned char LongPacket;
	u32 RxBufferLen;
	unsigned char TbiCompatibilityEnable;
	unsigned char TbiCompatibilityOn;

	/* PCI Device Info */
	u16 VendorId;
	u16 DeviceId;
	u8 RevId;
	u16 SubVendorId;
	u16 SubSystemId;

	/* PCI Bus Info */
	u8 BusType;
	u8 BusSpeed;
	u8 BusWidth;

	u32 PartNumber;

	unsigned char NosEnabledMulticastPromiscuous;

	unsigned char e1000_adapter_stopped;
	u32 IntMask;
	u16 PciCommandWord;
	u8 DmaFairness;
	u32 OriginalFlowControl;
	u8 FlowControl;
	u16 FlowControlHighWatermark;
	u16 FlowControlLowWatermark;
	u16 FlowControlPauseTime;
	unsigned char FlowControlSendXon;
	unsigned char ReportTxEarly;
	u32 TxcwRegValue;
	u32 AutoNegFailed;

	u32 MaxFrameSize;
#if 0
	/* e1000_adaptive */
	unsigned char AdaptiveTxThreshold;
	u32 CurrentTxThreshold;
	u8 TxThresholdTimer;
	unsigned char AdaptiveIFS;
	unsigned char InIFSMode;
	unsigned char IFSParamsForced;
	u16 CurrentIFSValue;
	u16 IFSMaxValue;
	u16 IFSMinValue;
	u16 IFSStepSize;
	u16 IFSRatio;
#endif

	/* driver specific */
	struct tasklet_struct rx_fill_tasklet;

	int NumTxDescriptors;
	u32 TxIntDelay;
	int NextAvailTxDescriptor;
	int OldestUsedTxDescriptor;
	E1000_TRANSMIT_DESCRIPTOR *TxDescriptors;
	dma_addr_t TxDescDMA;
	struct e1000_buffer *tx_skb;
	atomic_t NumTxDescriptorsAvail;
	u32 TxdCmd;

	int NumRxDescriptors;
	u32 RxIntDelay;
	int NextRxDescriptorToCheck;
	E1000_RECEIVE_DESCRIPTOR *RxDescriptors;
	dma_addr_t RxDescDMA;
	struct e1000_buffer *rx_skb;
	atomic_t NumRxDescriptorsEmpty;
	int NextRxDescriptorToFill;
	atomic_t tx_timeout;

	uint64_t XsumRXGood;
	uint64_t XsumRXError;

	/* Linux driver specific */
	struct net_device *netdev;
	struct pci_dev *pdev;
	struct net_device_stats net_stats;
	char *id_string;
	u8 JumboFrames;
	u8 RxChecksum;
	XSUM_CONTEXT_T ActiveChecksumContext;

	/* Multicast Stuff */
	u32 MulticastFilterType;
	u32 NumberOfMcAddresses;
	unsigned char MulticastAddressList[MAX_NUM_MULTICAST_ADDRESSES][ETH_LENGTH_OF_ADDRESS];
	/* calling these out as unsigned longs helps match up with the OS
	 * stats, which as unsigned longs change from 32 to 64 bits when moving
	 * to a 64-bit CPU, that change should not effect us */

	/* statistic registers present in the 82542 */
	unsigned long Crcerrs;
	unsigned long Symerrs;
	unsigned long Mpc;
	unsigned long Scc;
	unsigned long Ecol;
	unsigned long Mcc;
	unsigned long Latecol;
	unsigned long Colc;
	unsigned long Dc;
	unsigned long Sec;
	unsigned long Rlec;
	unsigned long Xonrxc;
	unsigned long Xontxc;
	unsigned long Xoffrxc;
	unsigned long Xofftxc;
	unsigned long Fcruc;
	unsigned long Prc64;
	unsigned long Prc127;
	unsigned long Prc255;
	unsigned long Prc511;
	unsigned long Prc1023;
	unsigned long Prc1522;
	unsigned long Gprc;
	unsigned long Bprc;
	unsigned long Mprc;
	unsigned long Gptc;
	unsigned long Gorcl;
	unsigned long Gorch;
	unsigned long Gotcl;
	unsigned long Gotch;
	unsigned long Rnbc;
	unsigned long Ruc;
	unsigned long Rfc;
	unsigned long Roc;
	unsigned long Rjc;
	unsigned long Torcl;
	unsigned long Torch;
	unsigned long Totcl;
	unsigned long Totch;
	unsigned long Tpr;
	unsigned long Tpt;
	unsigned long Ptc64;
	unsigned long Ptc127;
	unsigned long Ptc255;
	unsigned long Ptc511;
	unsigned long Ptc1023;
	unsigned long Ptc1522;
	unsigned long Mptc;
	unsigned long Bptc;
	/* statistic registers added in the 82543 */
	unsigned long Algnerrc;
	unsigned long Rxerrc;
	unsigned long Tuc;
	unsigned long Tncrs;
	unsigned long Cexterr;
	unsigned long Rutec;
	unsigned long Tsctc;
	unsigned long Tsctfc;
};

/* PCI defines needed by e1000_fxhw.c */
/* define these using the Linux names for the same thing (pci.h) */
#define CMD_MEM_WRT_INVALIDATE PCI_COMMAND_INVALIDATE
#define PCI_COMMAND_REGISTER PCI_COMMAND

/* Prototypes */
/* e1000_main.c */
extern int e1000_init_module (void);
extern int e1000_probe_all (void);
extern void e1000_exit_module (void);
extern int e1000_probe (struct pci_dev *pdev, const struct pci_device_id *ent);
extern void e1000_remove (struct pci_dev *pdev);
extern void e1000_delete (struct adapter *Adapter);
extern int e1000_open (struct net_device *netdev);
extern int e1000_close (struct net_device *netdev);
extern void e1000_set_multi (struct net_device *netdev);
extern int e1000_xmit_frame (struct sk_buff *skb, struct net_device *netdev);
extern struct net_device_stats *e1000_get_stats (struct net_device *netdev);
extern int e1000_change_mtu (struct net_device *netdev, int new_mtu);
extern int e1000_set_mac (struct net_device *netdev, void *p);
extern void e1000_intr (int irq, void *data, struct pt_regs *regs);
extern int e1000_ioctl (struct net_device *netdev, struct ifreq *ifr, int cmd);
extern void e1000_watchdog (unsigned long data);
extern void e1000_diag_ioctl (struct net_device *netdev, struct ifreq *ifr);

/* e1000_fxhw.c */
extern void e1000_adapter_stop (struct adapter * Adapter);
extern unsigned char e1000_initialize_hardware (struct adapter * Adapter);
extern void e1000_init_rx_addresses (struct adapter * Adapter);
extern unsigned char e1000_setup_flow_control_andLink (struct adapter * Adapter);
extern unsigned char e1000_setup_pcs_link (struct adapter * Adapter, u32 DeviceControlReg);
extern void e1000_config_flow_control_afterLinkUp (struct adapter * Adapter);
extern void e1000_force_mac_flow_controlSetting (struct adapter * Adapter);
extern void e1000_check_for_link (struct adapter * Adapter);
extern void e1000_clear_hw_stats_counters (struct adapter * Adapter);
extern void e1000_get_speed_and_duplex (struct adapter * Adapter, u16 * Speed, u16 * Duplex);
extern unsigned short e1000_read_eeprom_word (struct adapter * Adapter, unsigned short Reg);
extern unsigned char e1000_validate_eeprom_checksum (struct adapter * Adapter);
extern void e1000_update_eeprom_checksum (struct adapter * Adapter);
extern unsigned char e1000_write_eeprom_word (struct adapter * Adapter, unsigned short Reg, unsigned short Data);
extern unsigned char e1000_read_part_number (struct adapter * Adapter, u32 * PartNumber);
extern void e1000_id_led_on (struct adapter * Adapter);
extern void e1000_id_led_off (struct adapter * Adapter);
extern void e1000_multicast_address_list_update (struct adapter * Adapter, unsigned char * MulticastAddressList, u32 MulticastAddressCount, u32 Padding);
extern void e1000_adjust_tbi_accepted_stats (struct adapter * Adapter, u32 FrameLength, unsigned char * MacAddress);
extern void e1000_write_vfta (struct adapter * Adapter, u32 Offset, u32 Value);
extern void e1000_clear_vfta (struct adapter * Adapter);

/* e1000_phy.h */
extern u16 e1000_read_phy_register (struct adapter * Adapter, u32 RegAddress, u32 PhyAddress);
extern void e1000_phy_hardware_reset (struct adapter * Adapter);

/*  #include "e1000_adaptive.h" */
#include "e1000_proc.h"
#endif				/* _E1000_H_ */
