/*
 * Compaq Hot Plug Controller Driver
 *
 * Copyright (c) 1995,2001 Compaq Computer Corporation
 * Copyright (c) 2001 Greg Kroah-Hartman (greg@kroah.com)
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, GOOD TITLE or
 * NON INFRINGEMENT.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Send feedback to <linuxhotplug@compaq.com>
 *
 */
#ifndef _CPQPHPD_IOCTL
#define MAXLEN 128

struct public_bus_info {
	int bus_number;
	int current_speed;
	int supported_speed;
};

struct public_slot_info {
	int slot_number;
	int is_hotpluggable;
	int power;
	int attention_status;
	int latch_status;
	int adapter_presence;
	int bit_mode;	// 0 = 32-bit, 1 = 64-bit
	struct public_bus_info* bus;
};

struct public_function_info {
	int is_bridge;
	int is_driverloaded;
	int supported_speed_mode;
	int vendor_id;
	int subvendor_id;
	int device_id;
	int subdevice_id;
	int bus_number;
	int device_number;
	int function_number;
	char device_name[MAXLEN];
	char driver_name[MAXLEN];
};

struct public_adapter_info {
	char adapter_name[MAXLEN];
	struct public_slot_info* slot;
	struct public_function_info* function;
};

struct ioctl_data {
	u8 offset;
	u8 value;
	u8 bus;
	u8 device;
	u8 function;
	u8 type_of_request;
	u8 return_status;
	u8 physical_slot;
	struct public_function_info* adapter_info;
};

struct pci_hp_message {
	int	eb_serial_number;
	int	message_id;
};


/* this number needs adjusting to the maximum amount of pending messages
 * possible.
 * If there is no upper bound on this, the implementation here is rather 
 * dangerous to use, as messages are not prevented to "step over" each
 * other.
 */
#define HPCD_BUFFER_LENGTH	32


#define PCI_HP_IOCTL_REQUEST_GET_CTRL_STRUCTURE		1
#define PCI_HP_IOCTL_REQUEST_GET_IRQ_ROUTE		2
#define PCI_HP_IOCTL_REQUEST_POWER_DOWN_BOARD		3
#define PCI_HP_IOCTL_REQUEST_WRITE_REGISTER_VALUE	4
#define PCI_HP_IOCTL_REQUEST_SET_SOGO			5
#define PCI_HP_IOCTL_REQUEST_HARDWARE_TEST		8
#define PCI_HP_IOCTL_REQUEST_ADD_BOARD			10	
#define PCI_HP_IOCTL_REQUEST_SET_ATTENTION_STATUS	11
#define PCI_HP_IOCTL_REQUEST_GET_STATUS			12


/* Our ioctl command */
/* FIXME!  put something real here... gregkh */
#define GUI_BACK_DOOR		28

extern int pci_hp_gui_back_door(struct ioctl_data *stuff);

#endif
