
/*
 *  Broadcom Cryptonet Driver software is distributed as is, without any warranty
 *  of any kind, either express or implied as further specified in the GNU Public
 *  License. This software may be used and distributed according to the terms of
 *  the GNU Public License.
 *
 * Cryptonet is a registered trademark of Broadcom Corporation.
 */
/******************************************************************************
 *
 *  Copyright 2000
 *  Broadcom Corporation
 *  16215 Alton Parkway
 *  PO Box 57013
 *  Irvine CA 92619-7013
 *
 *****************************************************************************/
/* 
 * Broadcom Corporation uBSec SDK 
 */
/*
 * param.c: IO parameter manipulation routines
 */
/*
 * Revision History:
 *
 * May 2000 SOR/JTT Created.
 * March 2001 PW Release for Linux 2.4 UP and SMP kernel
 */

#include "cdevincl.h"

int
KeyCommandCopyin(unsigned long Command, 
		 ubsec_KeyCommandParams_pt pSRLParams, 
		 ubsec_KeyCommandParams_pt pIOparams,
		 unsigned char *KeyLoc,
		 ubsec_FragmentInfo_pt InputKeyInfo)
{

  /*
   * Now we need to format the command for the SRL.
   * This depends on the type of the key command.
   */
  switch (Command) {
  case UBSEC_DH_PUBLIC    :
  case UBSEC_DH_SHARED  :
    ubsec_keysetup_Diffie_Hellman(Command, pSRLParams,
					     pIOparams, KeyLoc);
    break;

  case UBSEC_RSA_PUBLIC  :
  case UBSEC_RSA_PRIVATE  : 
    ubsec_keysetup_RSA(Command, pSRLParams,
				  pIOparams, KeyLoc);
    break;

  case UBSEC_DSA_VERIFY: 
  case UBSEC_DSA_SIGN: 
    ubsec_keysetup_DSA(Command, pSRLParams,
				  pIOparams, KeyLoc,InputKeyInfo);
    break;

  default:
    printk("ubsec CDEV: Invalid Key Command %lx\n",Command);
    return -EINVAL;
  }

return 0 ;
}

/*
 * 
 */
int
KeyCommandCopyout(unsigned long Command, 
		 ubsec_KeyCommandParams_pt pSRLParams, 
		 ubsec_KeyCommandParams_pt pIOparams,
		 unsigned char *KeyLoc)
{
  ubsec_DH_Params_pt pDHparams=NULL,pDHIOparams = NULL;
  ubsec_RSA_Params_pt pRSAparams=NULL, pRSAIOparams=NULL;
  ubsec_DSA_Params_pt pDSAparams=NULL, pDSAIOparams=NULL;


  /* 
   * Now we need to copyout those parameters that were changed
   */
  switch (Command) {
  case UBSEC_DH_SHARED:
    pDHparams=&pSRLParams->DHParams;
    pDHIOparams=&pIOparams->DHParams;
    pDHIOparams->K.KeyLength = pDHparams->N.KeyLength;
    copyout(&KeyLoc[MAX_KEY_BYTE_SIZE*DH_K_OFFSET],
	    pDHIOparams->K.KeyValue,
	    BITSTOBYTES(pDHIOparams->K.KeyLength));
    break;

  case UBSEC_DH_PUBLIC:
    pDHparams=&pSRLParams->DHParams;
    pDHIOparams=&pIOparams->DHParams;
    if (!pDHparams->RNGEnable) {
      pDHparams->X.KeyLength = 
	pDHIOparams->UserX.KeyLength; 
    }
    else
      pDHparams->X.KeyLength=pDHparams->RandomKeyLen;
    pDHIOparams->Y.KeyLength = pDHparams->N.KeyLength;
    copyout(&KeyLoc[MAX_KEY_BYTE_SIZE*DH_Y_OFFSET],
	    pDHIOparams->Y.KeyValue,
	    BITSTOBYTES(pDHIOparams->Y.KeyLength));

    pDHIOparams->X.KeyLength = pDHparams->X.KeyLength;
    copyout(&KeyLoc[MAX_KEY_BYTE_SIZE*DH_X_OFFSET],
	    pDHIOparams->X.KeyValue,
	    BITSTOBYTES(pDHIOparams->X.KeyLength));
    break;
  case UBSEC_RSA_PUBLIC  :
  case UBSEC_RSA_PRIVATE  : 
    pRSAparams=&pSRLParams->RSAParams;
    pRSAIOparams=&pIOparams->RSAParams;
    pRSAIOparams->OutputKeyInfo.KeyLength =
#if 0
      pRSAparams->OutputKeyInfo.KeyLength;
#else
      pRSAparams->OutputKeyInfo.KeyLength;
#endif
    copyout(&KeyLoc[MAX_KEY_BYTE_SIZE*RSA_OUT_OFFSET],
	    pRSAIOparams->OutputKeyInfo.KeyValue,
	    BITSTOBYTES(pRSAIOparams->OutputKeyInfo.KeyLength));
    break;

  case UBSEC_DSA_SIGN     : 
    pDSAparams=&pSRLParams->DSAParams;
    pDSAIOparams=&pIOparams->DSAParams;
    pDSAparams->SigS.KeyValue = &KeyLoc[MAX_KEY_BYTE_SIZE*DSA_S_OFFSET];
    pDSAparams->SigR.KeyValue = &KeyLoc[MAX_KEY_BYTE_SIZE*DSA_R_OFFSET];
    pDSAparams->SigS.KeyLength = pDSAparams->SigR.KeyLength = 
      pDSAIOparams->ModQ.KeyLength;
    pDSAIOparams->SigS.KeyLength = pDSAparams->SigS.KeyLength;
    pDSAIOparams->SigR.KeyLength = pDSAparams->SigR.KeyLength;
    copyout(&KeyLoc[MAX_KEY_BYTE_SIZE*DSA_S_OFFSET],
	    pDSAIOparams->SigS.KeyValue,
	    BITSTOBYTES(pDSAIOparams->SigS.KeyLength));
    copyout(&KeyLoc[MAX_KEY_BYTE_SIZE*DSA_R_OFFSET],
	    pDSAIOparams->SigR.KeyValue,
	    BITSTOBYTES(pDSAIOparams->SigR.KeyLength));
    break;

  case UBSEC_DSA_VERIFY   : 
    pDSAIOparams=&pIOparams->DSAParams;
    pDSAparams=&pSRLParams->DSAParams;
    pDSAIOparams->V.KeyLength = pDSAparams->ModQ.KeyLength;
    copyout(&KeyLoc[MAX_KEY_BYTE_SIZE*DSA_V_OFFSET],
	    pDSAIOparams->V.KeyValue,
	    BITSTOBYTES(pDSAIOparams->V.KeyLength));
    break;
  }
return 0 ;
}


/*
 * Diffie Hellman key setup function. Builds KeyCommandInfo for call to SRL.
 */
int
ubsec_keysetup_Diffie_Hellman(unsigned long command, 
			      ubsec_KeyCommandParams_pt pSRLparams, 
			      ubsec_KeyCommandParams_pt pIOparams,
			      unsigned char *KeyLoc)
{
  ubsec_DH_Params_pt 	pDHSRLparams = &pSRLparams->DHParams;
  ubsec_DH_Params_pt 	pDHIOparams = &pIOparams->DHParams;

  /* 
   * Setup key parameter locations and align them. Start with modulus N.
   */
  copy_from_user( &KeyLoc[MAX_KEY_BYTE_SIZE*DH_N_OFFSET],pDHIOparams->N.KeyValue,
	 BITSTOBYTES(pDHIOparams->N.KeyLength));
  pDHSRLparams->N.KeyValue=(void *)&KeyLoc[MAX_KEY_BYTE_SIZE*DH_N_OFFSET];
  pDHSRLparams->N.KeyLength = pDHIOparams->N.KeyLength;

  /* 
   * Now copy in the specific parameters.
   */
  if ((command & UBSEC_DH_SHARED)==UBSEC_DH_SHARED) {
    /*
     * Computing K=Y**x|N
     */
    copy_from_user(&KeyLoc[MAX_KEY_BYTE_SIZE*DH_Y_OFFSET],pDHIOparams->Y.KeyValue,
	   BITSTOBYTES(pDHIOparams->Y.KeyLength));

    /*
     * Copy in our secret value x. 
     */
    copy_from_user(&KeyLoc[MAX_KEY_BYTE_SIZE*DH_X_OFFSET],pDHIOparams->X.KeyValue,
	   BITSTOBYTES(pDHIOparams->X.KeyLength));
    pDHSRLparams->X.KeyLength = pDHIOparams->X.KeyLength;
	/*
	 * Output parameter is the shared key. Must represent integral
	 * number of 32 bit words.
	 */
    pDHSRLparams->K.KeyValue=(void *) 
      (&KeyLoc[MAX_KEY_BYTE_SIZE*DH_K_OFFSET]);
    pDHSRLparams->K.KeyLength = pDHIOparams->K.KeyLength;
  } 
  else {
    /*
     * Computing Y=g**x|N
     */
    copy_from_user( &KeyLoc[MAX_KEY_BYTE_SIZE*DH_G_OFFSET],pDHIOparams->G.KeyValue,
	   BITSTOBYTES(pDHIOparams->G.KeyLength));
    pDHSRLparams->G.KeyValue=(void *)(&KeyLoc[MAX_KEY_BYTE_SIZE*DH_G_OFFSET]);
    pDHSRLparams->G.KeyLength = pDHIOparams->G.KeyLength;
    pDHSRLparams->RNGEnable=pDHIOparams->RNGEnable;

    /*
     * X and Y are input/output fragment data and must be physical addresses.
     */
    pDHSRLparams->X.KeyValue=(void *)(&KeyLoc[MAX_KEY_BYTE_SIZE*DH_X_OFFSET]);
 
    if (!pDHSRLparams->RNGEnable) {
      copy_from_user(&KeyLoc[MAX_KEY_BYTE_SIZE*DH_USERX_OFFSET],pDHIOparams->UserX.KeyValue,
	     BITSTOBYTES(pDHIOparams->UserX.KeyLength));
      pDHSRLparams->UserX.KeyValue=(void *)
	(&KeyLoc[MAX_KEY_BYTE_SIZE*DH_USERX_OFFSET]);
      pDHSRLparams->UserX.KeyLength = pDHIOparams->UserX.KeyLength;
	/*
	 * Set length for return. X will be copied from supplied UserX.
	 */
      pDHIOparams->X.KeyLength = pDHIOparams->UserX.KeyLength;

	/*
	 * User supplied secret value will be copied to the output X.
	 * Output needs to be an integral number of 32-bit words.
	 */
      pDHSRLparams->X.KeyLength=pDHIOparams->UserX.KeyLength;
    }
    else {
      /*
       * Set length for return. X will be the random number
       * generated by the chip. Output needs to be integral 
       * number of 32-bit words.
       */
      pDHIOparams->X.KeyLength = pDHIOparams->RandomKeyLen;
      pDHSRLparams->X.KeyLength = pDHIOparams->X.KeyLength;
      pDHSRLparams->RandomKeyLen=pDHIOparams->RandomKeyLen;
    }
  }

  /*
   * X and Y are input/output fragment data and must be physical addresses.
   */
  pDHSRLparams->X.KeyValue=(void *) (&KeyLoc[MAX_KEY_BYTE_SIZE*DH_X_OFFSET]);
  pDHSRLparams->Y.KeyValue=(void *) (&KeyLoc[MAX_KEY_BYTE_SIZE*DH_Y_OFFSET]);
  pDHSRLparams->Y.KeyLength = pDHIOparams->Y.KeyLength ;
  return 0 ;
}

/*
 * RSA key setup function. Builds KeyCommandInfo for call to SRL.
 */
int
ubsec_keysetup_RSA(unsigned long command, ubsec_KeyCommandParams_pt pSRLparams, 
	ubsec_KeyCommandParams_pt pIOparams,unsigned char *KeyLoc)
{
  ubsec_RSA_Params_pt 	pRSASRLparams=&pSRLparams->RSAParams;
  ubsec_RSA_Params_pt 	pRSAIOparams=&pIOparams->RSAParams;

  /*
   * Message in, message out, same for public or private. Both are
   * fragment data, must be physical address.
   */
  copy_from_user(&KeyLoc[MAX_KEY_BYTE_SIZE*RSA_IN_OFFSET],pRSAIOparams->InputKeyInfo.KeyValue,
	 BITSTOBYTES(pRSAIOparams->InputKeyInfo.KeyLength));

  /*
   * Output buffer will have to be corrected to be an integral number of 
   * 32-bit words. This will depend on the operation.
   */
  pRSASRLparams->OutputKeyInfo.KeyValue = (void *) 
    (&KeyLoc[MAX_KEY_BYTE_SIZE*RSA_OUT_OFFSET]);

  /*
   * Keys depend on public or private operations.
   */
  if ((command & UBSEC_RSA_PUBLIC)==UBSEC_RSA_PUBLIC) {
    copy_from_user(&KeyLoc[MAX_KEY_BYTE_SIZE*RSA_N_OFFSET],pRSAIOparams->ModN.KeyValue,
	   BITSTOBYTES(pRSAIOparams->ModN.KeyLength));
    pRSASRLparams->ModN.KeyValue=
      (void *)(&KeyLoc[MAX_KEY_BYTE_SIZE*RSA_N_OFFSET]);
    pRSASRLparams->ModN.KeyLength = pRSAIOparams->ModN.KeyLength;

    pRSASRLparams->OutputKeyInfo.KeyLength=pRSAIOparams->OutputKeyInfo.KeyLength;
    copy_from_user( &KeyLoc[MAX_KEY_BYTE_SIZE*RSA_E_OFFSET],pRSAIOparams->ExpE.KeyValue,
	   BITSTOBYTES(pRSAIOparams->ExpE.KeyLength));
    pRSASRLparams->ExpE.KeyValue= (void *)(&KeyLoc[MAX_KEY_BYTE_SIZE*RSA_E_OFFSET]);
    pRSASRLparams->ExpE.KeyLength = pRSAIOparams->ExpE.KeyLength;
    pRSASRLparams->InputKeyInfo.KeyLength = pRSAIOparams->InputKeyInfo.KeyLength;
  }
  else { /* Private. */
    copy_from_user( &KeyLoc[MAX_KEY_BYTE_SIZE*RSA_P_OFFSET],pRSAIOparams->PrimeP.KeyValue,
	   BITSTOBYTES(pRSAIOparams->PrimeP.KeyLength));
    pRSASRLparams->PrimeP.KeyValue= (void *)(&KeyLoc[MAX_KEY_BYTE_SIZE*RSA_P_OFFSET]);
    pRSASRLparams->PrimeP.KeyLength = pRSAIOparams->PrimeP.KeyLength;
    copy_from_user( &KeyLoc[MAX_KEY_BYTE_SIZE*RSA_Q_OFFSET],pRSAIOparams->PrimeQ.KeyValue,
	   BITSTOBYTES(pRSAIOparams->PrimeQ.KeyLength));
    pRSASRLparams->PrimeQ.KeyValue = (void *)(&KeyLoc[MAX_KEY_BYTE_SIZE*RSA_Q_OFFSET]);
    pRSASRLparams->PrimeQ.KeyLength = pRSAIOparams->PrimeQ.KeyLength;
    copy_from_user( &KeyLoc[MAX_KEY_BYTE_SIZE*RSA_EDP_OFFSET],pRSAIOparams->PrimeEdp.KeyValue,
	   BITSTOBYTES(pRSAIOparams->PrimeEdp.KeyLength));
    pRSASRLparams->PrimeEdp.KeyValue=
      (void *)(&KeyLoc[MAX_KEY_BYTE_SIZE*RSA_EDP_OFFSET]);
    pRSASRLparams->PrimeEdp.KeyLength = pRSAIOparams->PrimeEdp.KeyLength;
    copy_from_user( &KeyLoc[MAX_KEY_BYTE_SIZE*RSA_EDQ_OFFSET],pRSAIOparams->PrimeEdq.KeyValue,
	   BITSTOBYTES(pRSAIOparams->PrimeEdq.KeyLength));
    pRSASRLparams->PrimeEdq.KeyValue=
      (void *)(&KeyLoc[MAX_KEY_BYTE_SIZE*RSA_EDQ_OFFSET]);
    pRSASRLparams->PrimeEdq.KeyLength = pRSAIOparams->PrimeEdq.KeyLength;
    copy_from_user( &KeyLoc[MAX_KEY_BYTE_SIZE*RSA_PINV_OFFSET],pRSAIOparams->Pinv.KeyValue,
	   BITSTOBYTES(pRSAIOparams->Pinv.KeyLength));
    pRSASRLparams->Pinv.KeyValue= (void *)(&KeyLoc[MAX_KEY_BYTE_SIZE*RSA_PINV_OFFSET]);
    pRSASRLparams->Pinv.KeyLength = pRSAIOparams->Pinv.KeyLength;

    pRSASRLparams->OutputKeyInfo.KeyLength=pRSAIOparams->OutputKeyInfo.KeyLength;
    pRSASRLparams->InputKeyInfo.KeyLength=pRSAIOparams->InputKeyInfo.KeyLength;
  }      

  pRSASRLparams->InputKeyInfo.KeyValue = (void *) 
    (&KeyLoc[MAX_KEY_BYTE_SIZE*RSA_IN_OFFSET]);
  return 0;
}

/*
 * DSA key setup function. Builds KeyCommandInfo for call to SRL.
 */
 int
ubsec_keysetup_DSA(unsigned long command, ubsec_KeyCommandParams_pt pSRLparams, 
	ubsec_KeyCommandParams_pt pIOparams,unsigned char *KeyLoc,
        ubsec_FragmentInfo_pt InputKeyInfo)
{
  ubsec_DSA_Params_pt 	pDSASRLparams=&pSRLparams->DSAParams;
  ubsec_DSA_Params_pt 	pDSAIOparams=&pIOparams->DSAParams;

  ubsec_FragmentInfo_t IOInputKeyInfo; /* For DSA */

  copy_from_user( &IOInputKeyInfo,pDSAIOparams->pInputKeyInfo,sizeof(IOInputKeyInfo));
  pDSAIOparams->pInputKeyInfo=&IOInputKeyInfo;
  pDSASRLparams->pInputKeyInfo = InputKeyInfo;

  /*
   * Message in, signature in/out, key parameters used for both sign and verify.
   */
  pDSASRLparams->HashEnable = pDSAIOparams->HashEnable;
  /* TO_BE_FIXED This code assumes that the input message is in a single fragment. */
  copy_from_user( &KeyLoc[MAX_KEY_BYTE_SIZE*DSA_IN_OFFSET],pDSAIOparams->pInputKeyInfo[0].KeyValue,
	 BITSTOBYTES(pDSAIOparams->pInputKeyInfo[0].KeyLength));
  pDSASRLparams->pInputKeyInfo[0].KeyValue = 
    (void *)(&KeyLoc[MAX_KEY_BYTE_SIZE*DSA_IN_OFFSET]);
  pDSASRLparams->pInputKeyInfo[0].KeyLength = pDSAIOparams->pInputKeyInfo[0].KeyLength;
  pDSASRLparams->NumInputFragments = 1;

  copy_from_user( &KeyLoc[MAX_KEY_BYTE_SIZE*DSA_Q_OFFSET],pDSAIOparams->ModQ.KeyValue,
	 BITSTOBYTES(pDSAIOparams->ModQ.KeyLength));
  pDSASRLparams->ModQ.KeyValue = (void *)(&KeyLoc[MAX_KEY_BYTE_SIZE*DSA_Q_OFFSET]);
  pDSASRLparams->ModQ.KeyLength = pDSAIOparams->ModQ.KeyLength;

  copy_from_user( &KeyLoc[MAX_KEY_BYTE_SIZE*DSA_P_OFFSET],pDSAIOparams->ModP.KeyValue,
	 BITSTOBYTES(pDSAIOparams->ModP.KeyLength));
  pDSASRLparams->ModP.KeyValue = (void *)(&KeyLoc[MAX_KEY_BYTE_SIZE*DSA_P_OFFSET]);
  pDSASRLparams->ModP.KeyLength = pDSAIOparams->ModP.KeyLength;
  copy_from_user( &KeyLoc[MAX_KEY_BYTE_SIZE*DSA_G_OFFSET],pDSAIOparams->BaseG.KeyValue,
	 BITSTOBYTES(pDSAIOparams->BaseG.KeyLength));
  pDSASRLparams->BaseG.KeyValue = (void *)(&KeyLoc[MAX_KEY_BYTE_SIZE*DSA_G_OFFSET]);
  pDSASRLparams->BaseG.KeyLength = pDSAIOparams->BaseG.KeyLength;

  copy_from_user( &KeyLoc[MAX_KEY_BYTE_SIZE*DSA_KEY_OFFSET],pDSAIOparams->Key.KeyValue,
	 BITSTOBYTES(pDSAIOparams->Key.KeyLength));
  pDSASRLparams->Key.KeyValue = (void *)(&KeyLoc[MAX_KEY_BYTE_SIZE*DSA_KEY_OFFSET]);
  pDSASRLparams->Key.KeyLength = pDSAIOparams->Key.KeyLength;

  /*
   * R and S are always input/output fragment data, physical addresses.
   */
  pDSASRLparams->SigS.KeyValue=(void *) (&KeyLoc[MAX_KEY_BYTE_SIZE*DSA_S_OFFSET]);
  pDSASRLparams->SigR.KeyValue=(void *) (&KeyLoc[MAX_KEY_BYTE_SIZE*DSA_R_OFFSET]);

  if ((command & UBSEC_DSA_SIGN) == UBSEC_DSA_SIGN) {
    /*
     * Output will be in R and S, fragment data.
     */
    pDSASRLparams->RNGEnable=pDSAIOparams->RNGEnable;
    if (!pDSASRLparams->RNGEnable) {
      copy_from_user(&KeyLoc[MAX_KEY_BYTE_SIZE*DSA_RAND_OFFSET],pDSAIOparams->Random.KeyValue,
	     BITSTOBYTES(pDSAIOparams->Random.KeyLength));
      pDSASRLparams->Random.KeyValue = (void *)
	(&KeyLoc[MAX_KEY_BYTE_SIZE*DSA_RAND_OFFSET]);
      pDSASRLparams->Random.KeyLength = pDSAIOparams->Random.KeyLength;
    }
    pDSASRLparams->SigS.KeyLength = 160; 
    pDSASRLparams->SigR.KeyLength = 160;     
    /*
     * Set Return lengths
     */
    pDSAIOparams->SigS.KeyLength = pDSAIOparams->ModQ.KeyLength;
    pDSAIOparams->SigR.KeyLength = pDSAIOparams->ModQ.KeyLength;
  } else {
    /*
     * Verify.
     *
     * Input will be in R and S, fragment data.
     */
    copy_from_user( &KeyLoc[MAX_KEY_BYTE_SIZE*DSA_S_OFFSET],pDSAIOparams->SigS.KeyValue,
	   BITSTOBYTES(pDSAIOparams->SigS.KeyLength));
    pDSASRLparams->SigS.KeyLength = pDSAIOparams->SigS.KeyLength;
    copy_from_user( &KeyLoc[MAX_KEY_BYTE_SIZE*DSA_R_OFFSET],pDSAIOparams->SigR.KeyValue,
	   BITSTOBYTES(pDSAIOparams->SigR.KeyLength));
    pDSASRLparams->SigR.KeyLength = pDSAIOparams->SigR.KeyLength;

    /*
     * Output verification value is also fragmented data, must be
     * integral number of 32-bit words.
     */
    pDSASRLparams->V.KeyValue=(void *)(&KeyLoc[MAX_KEY_BYTE_SIZE*DSA_V_OFFSET]);
    pDSASRLparams->V.KeyLength = 160; 
    /*
     * Set value for return.
     */
    pDSAIOparams->V.KeyLength = 160; /*pDSAIOparams->ModQ.KeyLength;*/
  }
	
  return 0;
}
