
/*
 *  Broadcom Cryptonet Driver software is distributed as is, without any warranty
 *  of any kind, either express or implied as further specified in the GNU Public
 *  License. This software may be used and distributed according to the terms of
 *  the GNU Public License.
 *
 * Cryptonet is a registered trademark of Broadcom Corporation.
 */
/******************************************************************************
 *
 *  Copyright 2000
 *  Broadcom Corporation
 *  16215 Alton Parkway
 *  PO Box 57013
 *  Irvine CA 92619-7013
 *
 *****************************************************************************/
/* 
 * Broadcom Corporation uBSec SDK 
 */
/*
 * dispatch.c: Character driver interface to the ubsec driver
 */
/* Revision History:
 *
 * May   2000 SOR Created
 * March 2001 PW Release for Linux 2.4 UP and SMP kernel 
 * May   2001 PW added selftest for bcmdiag
 * May   2001 SRM added support for dumping statistics to the proc
 *   		  file system
 * May   2001 SRM change stats file name to bcm5820 
 * May   2001 SRM Move snmp related stuff to snmp.c. Also support
 *		  statistics thru' snmp for linux kernel less than
 *		  2 2 17.
 * June  2001 SRM Added per device testing and forced device failure. 
 * July  2001 RJT Added support for BCM5821
 */

#define MODULE

#define NUMBER_OF_KEY_MCRS 128
#define NUMBER_OF_CRYPTO_MCRS 64 
#include "cdevincl.h"
#include <linux/capability.h>

char kernel_version[] = UTS_RELEASE;

#undef  KERN_DEBUG
#define KERN_DEBUG "<1>"

static int ubsec_ioctl(struct inode *inode, struct file *filp,unsigned int cmd, unsigned long arg);

static int ubsec_open(struct inode *inode, struct file *filp);

static void ubsec_release(struct inode *inode, struct file *filp);

int NumDevices=0;

int 
GetDeviceStatus(DeviceInfo_t Device)
{ 
  return Device.DeviceStatus;
}

int 
SetDeviceStatus(DeviceInfo_pt pDevice, int Status)
{ 
  return pDevice->DeviceStatus = Status;
}

#if defined(UBSEC_5820)
#define UBS_DEVICE_TYPE "BCM5820"
#elif defined(UBSEC_5821)
#define UBS_DEVICE_TYPE "BCM5821"
#else
#define UBS_DEVICE_TYPE "BCM5805"
#endif

unsigned short Version=0x0117; /* Upper byte is major, lower byte is Minor */
static char *version_string="Broadcom Corporation Cryptonet %s driver v%x.%02x \n";

int ubsec_major_number = -1;
static int SelectedDevice=0;
/*
 *  UBSEC's set of file operations.  This is the data structure that
 *  will be passed when we call register_chrdev().
 */
#ifndef LINUX2dot2
static struct file_operations ubsec_file_ops = {
 
        owner:          THIS_MODULE,
        ioctl:          ubsec_ioctl,
        open:           ubsec_open,
        release:        ubsec_release,
};
 
#else       
struct file_operations ubsec_file_ops = {
  NULL,          /* lseek   */
  NULL,          /* read    */
  NULL,          /* write   */
  NULL,          /* readdir */
  NULL,          /* select  */
  ubsec_ioctl,/* ioctl   */
  NULL,          /* mmap    */
  ubsec_open,          /* open    */
  ubsec_release,          /* release */
  NULL           /* fsync   */
  /* fill any remaining entries with NULL */
};

#endif

/**************************************************************************
 *
 *  Function:  ubsec_ioctl
 *
 *************************************************************************/
static int 
ubsec_ioctl(struct inode *inode,struct file *filp,unsigned int cmd,unsigned long arg)
{

  long			Retval=0;
  ubsec_key_io_t *      buf;

  int                   status = 0;
  int                   deadlockctr = 0;
  
  buf=(ubsec_key_io_t*)arg;
  
#ifdef MULTIPLE_DEVICES
  
  /* Simple round robin scheduling of device. We need to increment
     first since the keysetup command may block. */
  
 TheBeginning:

  deadlockctr = 0;
  do {

    /* For diagnostic related stuff do not try any available devices */
    /* Try the intended device or all devices as directed by the command */

    if (cmd >= UBSEC_DEVICEDUMP || cmd == UBSEC_SELFTEST | cmd == UBSEC_FAILDEVICE) {
      break;
    }

    if(++deadlockctr == (NumDevices * 2)) {  /* to be conservative... */
#ifdef DEBUG_FAILOVER
      printk("Cryptonet: dispatch found no more devices.\n");
#endif
      return 1; /* error: no more devices */
    }

    if ((++SelectedDevice) == NumDevices)
      SelectedDevice=0;

  } while(GetDeviceStatus(DeviceInfoList[SelectedDevice]));

#ifdef DEBUG_FAILOVER
  printk("\ndsptch-pre: SltdDev=%d,DevStati=%d %d\n", 
	 SelectedDevice, DeviceInfoList[0].DeviceStatus, DeviceInfoList[1].DeviceStatus);
#endif

#endif

  switch(cmd) {
  case UBSEC_ENCRYPT_DECRYPT_FUNC:
    status = do_encrypt(DeviceInfoList[SelectedDevice].Context, (void *)arg);
    break;

  case UBSEC_KEY_SETUP_FUNC:
    status = ubsec_keysetup(DeviceInfoList[SelectedDevice].Context, (void *)arg);
    break;

  case UBSEC_MATH_FUNC:
    status = ubsec_math(DeviceInfoList[SelectedDevice].Context, (void *)arg);
    break;

  case UBSEC_RNG_FUNC:
    status = ubsec_rng(DeviceInfoList[SelectedDevice].Context, (void *)arg);
    break;
    
  case UBSEC_TLS_HMAC_FUNC:
    status = ubsec_tlsmac(DeviceInfoList[SelectedDevice].Context, (void *)arg);
    break;
    
  case UBSEC_SSL_MAC_FUNC:
    status = ubsec_sslmac(DeviceInfoList[SelectedDevice].Context, (void *)arg);
    break;
    
  case UBSEC_SSL_HASH_FUNC:
    status = ubsec_hash(DeviceInfoList[SelectedDevice].Context, (void *)arg);
    break;

  case UBSEC_SSL_DES_FUNC:
    status = ubsec_sslcipher(DeviceInfoList[SelectedDevice].Context, (void *)arg);
    break;

  case UBSEC_SSL_ARC4_FUNC:
    status = ubsec_sslarc4(DeviceInfoList[SelectedDevice].Context, (void *)arg);
    break;

  case UBSEC_CHIPINFO_FUNC:
    status = ubsec_chipinfo(DeviceInfoList[SelectedDevice].Context, (void *)arg);
    break;
    
  case UBSEC_DEVICEDUMP:
    Retval=DumpDeviceInfo((PInt)arg);
    if (Retval)
      return(-1); /* Error */
    break;

  case UBSEC_FAILDEVICE:
    if (!capable(CAP_SYS_ADMIN))
    	return -EPERM;
    Retval=FailDevices((PInt)arg);
    if (Retval)
      return(-1); /* Error */
    break;

  case UBSEC_SELFTEST:
    Retval=TestDevices((PInt)arg);
    if (Retval)
      return(-1); /* Error */
    break;

  case UBSEC_GETVERSION:
    Retval=GetHardwareVersion((PInt)arg); /* For the moment one card */
    Retval=Retval<<16;
    Retval+=Version;
    return(-Retval);
    break;

  default:
    return -EINVAL;
  }
  
#ifdef DEBUG_FAILOVER
  printk("dsptch-pst: SltdDev=%d,DevStati=%d %d\n", 
	 SelectedDevice, DeviceInfoList[0].DeviceStatus, DeviceInfoList[1].DeviceStatus);
  if((status == ETIMEDOUT) || (status == -ETIMEDOUT)) {
    printk("dispatch.c: TIMED OUT SelectedDevice=%d, DeviceStatus=%d\n", 
	   SelectedDevice, DeviceInfoList[SelectedDevice].DeviceStatus);
  }
#endif

  switch(status) {
  case 0:
    break;

  case (-ETIMEDOUT):
  case (ETIMEDOUT):
    DeviceInfoList[SelectedDevice].DeviceStatus = TestDevice(SelectedDevice);
    /*  goto TheBeginning; */
    return(status);
    break;
    
  default:
    /*  goto TheBeginning; */
    return(status);
    break;
  }
  
  return 0;
}


/**************************************************************************
 *
 *  Function:  init_module
 *   
 *************************************************************************/
int init_module(void)
{
  printk(version_string,UBS_DEVICE_TYPE,Version>>8,Version&0xff);

#ifdef DEBUG
printk("ubsec SRL version %d.%x%c\n",UBSEC_VERSION_MAJOR,UBSEC_VERSION_MINOR,UBSEC_VERSION_REV);
#endif

/*
 * First try to find and initialize the ubsec devices.
 */
 if ((NumDevices=InitDevices(NUMBER_OF_CRYPTO_MCRS,NUMBER_OF_KEY_MCRS)) ==0) {
    printk(KERN_DEBUG "Cryptonet: Device startup failed\n");
    return -ENOMEM;
 }

 if (init_keyif() < 0) {
   printk(KERN_DEBUG "Cryptonet: no memory for key buffer\n");
   return(ENOMEM);
 }

 if (init_mathif() < 0) {
   printk(KERN_DEBUG "Cryptonet: no memory for mathif buffer\n");
   shutdown_keyif();
   return(ENOMEM);
 }

 if (init_rngif() < 0) {
   printk(KERN_DEBUG "Cryptonet: no memory for rng buffer\n");
   shutdown_keyif();
   shutdown_mathif();
   return(ENOMEM);
 }

 if (init_cryptoif() < 0) {
   printk(KERN_DEBUG "Cryptonet: crypto init failed\n");
   shutdown_keyif();
   shutdown_mathif();
   return(ENOMEM);
 }

 if(init_arc4if() < 0) {
   printk(KERN_DEBUG "Cryptonet: ssl init failed\n");
   shutdown_cryptoif();
   shutdown_rngif();
   shutdown_keyif();
   shutdown_mathif();
   return(ENOMEM);
 }

 /* create a /proc/net/ubsec entry for possible SNMP support */
#if (defined(UBSEC_STATS) && defined(CONFIG_PROC_FS))
  init_snmp_stats_support();
#endif

  /*
   *  Register the device -- ask for a dnynamicly assigned major number
   */
 ubsec_major_number = register_chrdev(0, UBSEC_KEYDEVICE_NAME, &ubsec_file_ops);
 if(ubsec_major_number < 0 ) /* Bound? */
   return(ubsec_major_number);

#if 0 
register_chrdev(ubsec_major_number, UBSEC_KEYDEVICE_NAME, &ubsec_file_ops);
#endif

 EXPORT_NO_SYMBOLS;
 return 0; /* success */
}

/**************************************************************************
 *
 *  Function:  cleanup_module
 *
 *************************************************************************/
void
cleanup_module(void)
{
  int i;

  shutdown_keyif();
  shutdown_mathif();
  shutdown_rngif();
  shutdown_cryptoif();
  shutdown_arc4if();
#if (defined(UBSEC_STATS) && defined(CONFIG_PROC_FS))
  shutdown_snmp_stats_support();
#endif

#if 0
  unregister_chrdev(ubsec_major_number, UBSEC_DEVICE_NAME);
#endif
  unregister_chrdev(ubsec_major_number, UBSEC_KEYDEVICE_NAME);

#ifdef MULTIPLE_DEVICES
  /* Shutdown all the devices. */
  for (i=0; i < NumDevices ; i++)
    ubsec_ShutdownDevice(DeviceInfoList[i].Context); /* Shutdown the device */
#endif
}

/*
 * ubsec_open:
 */
static int
ubsec_open(struct inode *inode, struct file *filp)
{
  MOD_INC_USE_COUNT;
  return 0;
}

/*
 * ubsec_release:
 */
static void
ubsec_release(struct inode *inode, struct file *filp)
{
  MOD_DEC_USE_COUNT;
}
