
/*
 * Broadcom Cryptonet Driver software is distributed as is, without any warranty
 * of any kind, either express or implied as further specified in the GNU Public
 * License. This software may be used and distributed according to the terms of
 * the GNU Public License.
 *
 * Cryptonet is a registered trademark of Broadcom Corporation.
 */

/******************************************************************************
 *
 * Copyright 2001
 * Broadcom Corporation
 * 16215 Alton Parkway
 * PO Box 57013
 * Irvine CA 92619-7013
 *
 *****************************************************************************/

/*******************************************************************************
 *
 * File: Linux/chipinfo.c
 * 
 * What: ubsec_chipinfo returns the maximum key size for the installed h/w. 
 *
 * Description: 
 *              
 * Revision History:
 *                   When       Who   What
 *                   06/28/01   DNA   Removed SRL call, uses Linux #define now.
 *                   03/13/01   DNA   Created.
 *
 ******************************************************************************/

#include "cdevincl.h"

/**************************************************************************
 *
 * Function:     ubsec_chipinfo
 * 
 * Called from:  ubsec_ioctl() in Linux/dispatch.c
 *
 * Description: 
 *
 * Return Values: 
 *                == 0   =>   Success
 *                != 0   =>   Failure
 *
 *************************************************************************/

int
ubsec_chipinfo(
	       ubsec_DeviceContext_t   pContext,
	       ubsec_chipinfo_io_pt *  ppIOInfo
	       ) {
  
  ubsec_chipinfo_io_t   IOInfo;
  ubsec_chipinfo_io_pt  pIOInfo = &IOInfo;
  
  copy_from_user(pIOInfo, *ppIOInfo, sizeof(ubsec_chipinfo_io_t));
  
#ifdef UBSEC_5820
  pIOInfo->max_key_len = 2048;
#else
  pIOInfo->max_key_len = 1024;
#endif
  
  copy_to_user(*ppIOInfo, pIOInfo, sizeof(ubsec_chipinfo_io_t));
  
  pIOInfo->result_status = UBSEC_STATUS_SUCCESS;
  
  return(pIOInfo->result_status);
}

