
/*
 *  Broadcom Cryptonet Driver software is distributed as is, without any warranty
 *  of any kind, either express or implied as further specified in the GNU Public
 *  License. This software may be used and distributed according to the terms of
 *  the GNU Public License.
 *
 * Cryptonet is a registered trademark of Broadcom Corporation.
 */
/******************************************************************************
 *
 *  Copyright 2000
 *  Broadcom Corporation
 *  16215 Alton Parkway
 *  PO Box 57013
 *  Irvine CA 92619-7013
 *
 *****************************************************************************/
/* 
 * Broadcom Corporation uBSec SDK 
 */
/*
 * Revision History:
 *
 * May 2000 SOR/JTT Created.
 */
/*
 * Character device externs header file.
 */

#ifndef _CDEXTRN_H_
#define _CDEXTRN_H_

extern int InitDevices(int NumberOfCryptoMCRs,int NumberOfKeyMCRs);
extern int init_keyif(void);
extern void shutdown_keyif(void);
extern int init_mathif(void);
extern void shutdown_mathif(void);
extern int init_cryptoif(void);
extern void shutdown_cryptoif(void);
extern int init_rngif(void);
extern void shutdown_rngif(void);
extern void copywords(unsigned long *out, unsigned long *in,int num);
int ubsec_keysetup(ubsec_DeviceContext_t pContext,
	       ubsec_key_io_pt *pKeyIOInfo);

extern int ubsec_encrypt(ubsec_io_pt *test_cmd);
extern int ubsec_math(ubsec_DeviceContext_t pContext,
	   ubsec_math_io_pt *pIOInfo);
extern int ubsec_rng(ubsec_DeviceContext_pt pContext, ubsec_rng_io_pt *rng_cmd);

int
KeyCommandCopyin(unsigned long Command, 
		 ubsec_KeyCommandParams_pt pSRLParams, 
		 ubsec_KeyCommandParams_pt pDHIOparams,
		 unsigned char *KeyLoc,
		 ubsec_FragmentInfo_pt InputKeyInfo);

int
KeyCommandCopyout(unsigned long Command, 
		 ubsec_KeyCommandParams_pt pSRLParams, 
		 ubsec_KeyCommandParams_pt pIOparams,
		 unsigned char *KeyLoc);

int ubsec_keysetup_Diffie_Hellman(unsigned long command, 
	ubsec_KeyCommandParams_pt pIOparams, ubsec_KeyCommandParams_pt pSRLparams, 	
	unsigned char *KeyLoc);

int ubsec_keysetup_RSA(unsigned long command, 
	ubsec_KeyCommandParams_pt pIOparams, ubsec_KeyCommandParams_pt pSRLparams, 	
	unsigned char *KeyLoc);
int ubsec_keysetup_DSA(unsigned long command,
	ubsec_KeyCommandParams_pt pIOparams, ubsec_KeyCommandParams_pt pSRLparams, 	
	unsigned char *KeyLoc, ubsec_FragmentInfo_pt InputKeyInfo);

extern void tv_sub(struct timeval *out, struct timeval *in);
extern unsigned long stop_time(struct timeval *tv_stop);
extern void start_time(struct timeval *tv_start)  ;

extern void gotosleep(wait_queue_t **WaitQ);
extern void Wakeup(wait_queue_t **WaitQ);
extern int do_encrypt(ubsec_DeviceContext_t pContext,ubsec_io_pt *at);
extern int Selftest(ubsec_DeviceContext_t pContext,struct pci_dev* pDev);

extern void CmdCompleteCallback(unsigned long CallBackContext,ubsec_Status_t Result);

#endif /* _CDEXTRN_H_ */

