# 1 "setup.S"















































# 1 "/home/gaurav/redhat-linux/include/linux/config.h" 1 3



# 1 "/home/gaurav/redhat-linux/include/linux/autoconf.h" 1 3





















































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































# 5 "/home/gaurav/redhat-linux/include/linux/config.h" 2 3


# 49 "setup.S" 2 3
# 1 "/home/gaurav/redhat-linux/include/asm/segment.h" 1 3










# 50 "setup.S" 2 3
# 1 "/home/gaurav/redhat-linux/include/linux/version.h" 1 3



# 51 "setup.S" 2 3
# 1 "/home/gaurav/redhat-linux/include/linux/compile.h" 1 3






# 52 "setup.S" 2 3
# 1 "/home/gaurav/redhat-linux/include/asm/boot.h" 1 3















# 53 "setup.S" 2 3
# 1 "/home/gaurav/redhat-linux/include/asm/e820.h" 1 3

























# 38 "/home/gaurav/redhat-linux/include/asm/e820.h" 3



# 54 "setup.S" 2 3





INITSEG  = 0x9000		# 0x9000, we move boot here, out of the way
SYSSEG   = 0x1000		# 0x1000, system loaded at 0x10000 (65536).
SETUPSEG = 0x9020		# 0x9020, this is the current segment
				# ... and the former contents of CS

DELTA_INITSEG = SETUPSEG - INITSEG	# 0x0020

.code16
.globl begtext, begdata, begbss, endtext, enddata, endbss

.text
begtext:
.data
begdata:
.bss
begbss:
.text

start:
	jmp	trampoline

# This is the setup header, and it must start at %cs:2 (old 0x9020:2)

		.ascii	"HdrS"		# header signature
		.word	0x0202		# header version number (>= 0x0105)
					# or else old loadlin-1.5 will fail)
realmode_swtch:	.word	0, 0		# default_switch, SETUPSEG
start_sys_seg:	.word	SYSSEG
		.word	kernel_version	# pointing to kernel version string
					# above section of header is compatible
					# with loadlin-1.5 (header v1.5). Don't
					# change it.

type_of_loader:	.byte	0		# = 0, old one (LILO, Loadlin,
					#      Bootlin, SYSLX, bootsect...)
					# See Documentation/1/boot.txt for
					# assigned ids
	
# flags, unused bits must be zero (RFU) bit within loadflags
loadflags:
LOADED_HIGH	= 1			# If set, the kernel is loaded high
CAN_USE_HEAP	= 0x80			# If set, the loader also has set
					# heap_end_ptr to tell how much
					# space behind setup.S can be used for
					# heap purposes.
					# Only the loader knows what is free



		.byte	LOADED_HIGH


setup_move_size: .word  0x8000		# size to move, when setup is not
					# loaded at 0x90000. We will move setup 
					# to 0x90000 then just before jumping
					# into the kernel. However, only the
					# loader knows how much data behind
					# us also needs to be loaded.

code32_start:				# here loaders can put a different
					# start address for 32-bit code.



		.long	0x100000	# 0x100000 = default for big kernel


ramdisk_image:	.long	0		# address of loaded ramdisk image
					# Here the loader puts the 32-bit
					# address where it loaded the image.
					# This only will be read by the kernel.

ramdisk_size:	.long	0		# its size in bytes

bootsect_kludge:
		.word  bootsect_helper, SETUPSEG

heap_end_ptr:	.word	modelist+1024	# (Header version 0x0201 or later)
					# space from here (exclusive) down to
					# end of setup code can be used by setup
					# for local heap purposes.

pad1:		.word	0
cmd_line_ptr:	.long 0			# (Header version 0x0202 or later)
					# If nonzero, a 32-bit pointer
					# to the kernel command line.
					# The command line should be
					# located between the start of
					# setup and the end of low
					# memory (0xa0000), or it may
					# get overwritten before it
					# gets read.  If this field is
					# used, there is no longer
					# anything magical about the
					# 0x90000 segment; the setup
					# can be located anywhere in
					# low memory 0x10000 or higher.

trampoline:	call	start_of_setup
		.space	1024
# End of setup header #####################################################

start_of_setup:
# Bootlin depends on this being done early
	movw	$0x01500, %ax
	movb	$0x81, %dl
	int	$0x13








# Set %ds = %cs, we know that SETUPSEG = %cs at this point
	movw	%cs, %ax		# aka SETUPSEG
	movw	%ax, %ds
# Check signature at end of setup
	cmpw	$0xAA55, setup_sig1
	jne	bad_sig

	cmpw	$0x5A5A, setup_sig2
	jne	bad_sig

	jmp	good_sig1

# Routine to print asciiz string at ds:si
prtstr:
	lodsb
	andb	%al, %al
	jz	fin

	call	prtchr
	jmp	prtstr

fin:	ret

# Space printing
prtsp2:	call	prtspc		# Print double space
prtspc:	movb	$0x20, %al	# Print single space (note: fall-thru)

# Part of above routine, this one just prints ascii al
prtchr:	pushw	%ax
	pushw	%cx
	xorb	%bh, %bh
	movw	$0x01, %cx
	movb	$0x0e, %ah
	int	$0x10
	popw	%cx
	popw	%ax
	ret

beep:	movb	$0x07, %al
	jmp	prtchr
	
no_sig_mess: .string	"No setup signature found ..."

good_sig1:
	jmp	good_sig

# We now have to find the rest of the setup code/data
bad_sig:
	movw	%cs, %ax			# SETUPSEG
	subw	$DELTA_INITSEG, %ax		# INITSEG
	movw	%ax, %ds
	xorb	%bh, %bh
	movb	(497), %bl			# get setup sect from bootsect
	subw	$4, %bx				# LILO loads 4 sectors of setup
	shlw	$8, %bx				# convert to words (1sect=2^8 words)
	movw	%bx, %cx
	shrw	$3, %bx				# convert to segment
	addw	$SYSSEG, %bx
	movw	%bx, %cs:start_sys_seg
# Move rest of setup code/data to here
	movw	$2048, %di			# four sectors loaded by LILO
	subw	%si, %si
	pushw	%cs
	popw	%es
	movw	$SYSSEG, %ax
	movw	%ax, %ds
	rep
	movsw
	movw	%cs, %ax			# aka SETUPSEG
	movw	%ax, %ds
	cmpw	$0xAA55, setup_sig1
	jne	no_sig

	cmpw	$0x5A5A, setup_sig2
	jne	no_sig

	jmp	good_sig

no_sig:
	lea	no_sig_mess, %si
	call	prtstr

no_sig_loop:
	jmp	no_sig_loop

good_sig:
	movw	%cs, %ax			# aka SETUPSEG
	subw	$DELTA_INITSEG, %ax 		# aka INITSEG
	movw	%ax, %ds
# Check if an old loader tries to load a big-kernel
	testb	$LOADED_HIGH, %cs:loadflags	# Do we have a big kernel?
	jz	loader_ok			# No, no danger for old loaders.

	cmpb	$0, %cs:type_of_loader 		# Do we have a loader that
						# can deal with us?
	jnz	loader_ok			# Yes, continue.

	pushw	%cs				# No, we have an old loader,
	popw	%ds				# die. 
	lea	loader_panic_mess, %si
	call	prtstr

	jmp	no_sig_loop

loader_panic_mess: .string "Wrong loader, giving up..."

loader_ok:
# Get memory size (extended mem, kB)

	xorl	%eax, %eax
	movl	%eax, (0x1e0)

	movb	%al, (0x1e8		)
# Try three different memory detection schemes.  First, try
# e820h, which lets us assemble a memory map, then try e801h,
# which returns a 32-bit memory size, and finally 88h, which
# returns 0-64m

# method E820H:
# the memory map from hell.  e820h returns memory classified into
# a whole bunch of different types, and allows memory holes and
# everything.  We scan through this memory map and build a list
# of the first 32 memory areas, which we return at [0x2d0		].
# This is documented at http://www.teleport.com/~acpi/acpihtml/topic245.htm



meme820:
	xorl	%ebx, %ebx			# continuation counter
	movw	$0x2d0		, %di			# point into the whitelist
						# so we can have the bios
						# directly write into it.

jmpe820:
	movl	$0x0000e820, %eax		# e820, upper word zeroed
	movl	$0x534d4150, %edx			# ascii 'SMAP'
	movl	$20, %ecx			# size of the e820rec
	pushw	%ds				# data record.
	popw	%es
	int	$0x15				# make the call
	jc	bail820				# fall to e801 if it fails

	cmpl	$0x534d4150, %eax			# check the return is `0x534d4150'
	jne	bail820				# fall to e801 if it fails

#	cmpl	$1, 16(%di)			# is this usable memory?
#	jne	again820

	# If this is usable memory, we save it by simply advancing %di by
	# sizeof(e820rec).
	#
good820:
	movb	(0x1e8		), %al			# up to 32 entries
	cmpb	$32		, %al
	jnl	bail820

	incb	(0x1e8		)
	movw	%di, %ax
	addw	$20, %ax
	movw	%ax, %di
again820:
	cmpl	$0, %ebx			# check to see if
	jne	jmpe820				# %ebx is set to EOF
bail820:


# method E801H:
# memory size is in 1k chunksizes, to avoid confusing loadlin.
# we store the 0xe801 memory size in a completely different place,
# because it will most likely be longer than 16 bits.
# (use 1e0 because that's what Larry Augustine uses in his
# alternative new memory detection scheme, and it's sensible
# to write everything into the same place.)

meme801:
	stc					# fix to work around buggy
	xorw	%cx,%cx				# BIOSes which dont clear/set
	xorw	%dx,%dx				# carry on pass/error of
						# e801h memory size call
						# or merely pass cx,dx though
						# without changing them.
	movw	$0xe801, %ax
	int	$0x15
	jc	mem88

	cmpw	$0x0, %cx			# Kludge to handle BIOSes
	jne	e801usecxdx			# which report their extended
	cmpw	$0x0, %dx			# memory in AX/BX rather than
	jne	e801usecxdx			# CX/DX.  The spec I have read
	movw	%ax, %cx			# seems to indicate AX/BX 
	movw	%bx, %dx			# are more reasonable anyway...

e801usecxdx:
	andl	$0xffff, %edx			# clear sign extend
	shll	$6, %edx			# and go from 64k to 1k chunks
	movl	%edx, (0x1e0)			# store extended memory size
	andl	$0xffff, %ecx			# clear sign extend
 	addl	%ecx, (0x1e0)			# and add lower memory into
						# total size.

# Ye Olde Traditional Methode.  Returns the memory size (up to 16mb or
# 64mb, depending on the bios) in ax.
mem88:


	movb	$0x88, %ah
	int	$0x15
	movw	%ax, (2)

# Set the keyboard repeat rate to the max
	movw	$0x0305, %ax
	xorw	%bx, %bx
	int	$0x16

# Check for video adapter and its parameters and allow the
# user to browse video modes.
	call	video				# NOTE: we need %ds pointing
						# to bootsector

# Get hd0 data...
	xorw	%ax, %ax
	movw	%ax, %ds
	ldsw	(4 * 0x41), %si
	movw	%cs, %ax			# aka SETUPSEG
	subw	$DELTA_INITSEG, %ax		# aka INITSEG
	pushw	%ax
	movw	%ax, %es
	movw	$0x0080, %di
	movw	$0x10, %cx
	pushw	%cx
	cld
	rep
 	movsb
# Get hd1 data...
	xorw	%ax, %ax
	movw	%ax, %ds
	ldsw	(4 * 0x46), %si
	popw	%cx
	popw	%es
	movw	$0x0090, %di
	rep
	movsb
# Check that there IS a hd1 :-)
	movw	$0x01500, %ax
	movb	$0x81, %dl
	int	$0x13
	jc	no_disk1
	
	cmpb	$3, %ah
	je	is_disk1

no_disk1:
	movw	%cs, %ax			# aka SETUPSEG
	subw	$DELTA_INITSEG, %ax 		# aka INITSEG
	movw	%ax, %es
	movw	$0x0090, %di
	movw	$0x10, %cx
	xorw	%ax, %ax
	cld
	rep
	stosb
is_disk1:
# check for Micro Channel (MCA) bus
	movw	%cs, %ax			# aka SETUPSEG
	subw	$DELTA_INITSEG, %ax		# aka INITSEG
	movw	%ax, %ds
	xorw	%ax, %ax
	movw	%ax, (0xa0)			# set table length to 0
	movb	$0xc0, %ah
	stc
	int	$0x15				# moves feature table to es:bx
	jc	no_mca

	pushw	%ds
	movw	%es, %ax
	movw	%ax, %ds
	movw	%cs, %ax			# aka SETUPSEG
	subw	$DELTA_INITSEG, %ax		# aka INITSEG
	movw	%ax, %es
	movw	%bx, %si
	movw	$0xa0, %di
	movw	(%si), %cx
	addw	$2, %cx				# table length is a short
	cmpw	$0x10, %cx
	jc	sysdesc_ok

	movw	$0x10, %cx			# we keep only first 16 bytes
sysdesc_ok:
	rep
	movsb
	popw	%ds
no_mca:
# Check for PS/2 pointing device
	movw	%cs, %ax			# aka SETUPSEG
	subw	$DELTA_INITSEG, %ax		# aka INITSEG
	movw	%ax, %ds
	movw	$0, (0x1ff)			# default is no pointing device
	int	$0x11				# int 0x11: equipment list
	testb	$0x04, %al			# check if mouse installed
	jz	no_psmouse

	movw	$0xAA, (0x1ff)			# device present
no_psmouse:


# Then check for an APM BIOS...
						# %ds points to the bootsector
	movw	$0, 0x40			# version = 0 means no APM BIOS
	movw	$0x05300, %ax			# APM BIOS installation check
	xorw	%bx, %bx
	int	$0x15
	jc	done_apm_bios			# Nope, no APM BIOS
	
	cmpw	$0x0504d, %bx			# Check for "PM" signature
	jne	done_apm_bios			# No signature, no APM BIOS

	andw	$0x02, %cx			# Is 32 bit supported?
	je	done_apm_bios			# No 32-bit, no (good) APM BIOS

	movw	$0x05304, %ax			# Disconnect first just in case
	xorw	%bx, %bx
	int	$0x15				# ignore return code
	movw	$0x05303, %ax			# 32 bit connect
	xorl	%ebx, %ebx
	xorw	%cx, %cx			# paranoia :-)
	xorw	%dx, %dx			#   ...
	xorl	%esi, %esi			#   ...
	xorw	%di, %di			#   ...
	int	$0x15
	jc	no_32_apm_bios			# Ack, error. 

	movw	%ax,  (66)			# BIOS code segment
	movl	%ebx, (68)			# BIOS entry point offset
	movw	%cx,  (72)			# BIOS 16 bit code segment
	movw	%dx,  (74)			# BIOS data segment
	movl	%esi, (78)			# BIOS code segment lengths
	movw	%di,  (82)			# BIOS data segment length
# Redo the installation check as the 32 bit connect
# modifies the flags returned on some BIOSs
	movw	$0x05300, %ax			# APM BIOS installation check
	xorw	%bx, %bx
	xorw	%cx, %cx			# paranoia
	int	$0x15
	jc	apm_disconnect			# error -> shouldn't happen

	cmpw	$0x0504d, %bx			# check for "PM" signature
	jne	apm_disconnect			# no sig -> shouldn't happen

	movw	%ax, (64)			# record the APM BIOS version
	movw	%cx, (76)			# and flags
	jmp	done_apm_bios

apm_disconnect:					# Tidy up
	movw	$0x05304, %ax			# Disconnect
	xorw	%bx, %bx
	int	$0x15				# ignore return code

	jmp	done_apm_bios

no_32_apm_bios:
	andw	$0xfffd, (76)			# remove 32 bit support bit
done_apm_bios:


# Now we want to move to protected mode ...
	cmpw	$0, %cs:realmode_swtch
	jz	rmodeswtch_normal

	lcall	%cs:realmode_swtch

	jmp	rmodeswtch_end

rmodeswtch_normal:
        pushw	%cs
	call	default_switch

rmodeswtch_end:
# we get the code32 start address and modify the below 'jmpi'
# (loader may have changed it)
	movl	%cs:code32_start, %eax
	movl	%eax, %cs:code32

# Now we move the system to its rightful place ... but we check if we have a
# big-kernel. In that case we *must* not move it ...
	testb	$LOADED_HIGH, %cs:loadflags
	jz	do_move0			# .. then we have a normal low
						# loaded zImage
						# .. or else we have a high
						# loaded bzImage
	jmp	end_move			# ... and we skip moving

do_move0:
	movw	$0x100, %ax			# start of destination segment
	movw	%cs, %bp			# aka SETUPSEG
	subw	$DELTA_INITSEG, %bp		# aka INITSEG
	movw	%cs:start_sys_seg, %bx		# start of source segment
	cld
do_move:
	movw	%ax, %es			# destination segment
	incb	%ah				# instead of add ax,#0x100
	movw	%bx, %ds			# source segment
	addw	$0x100, %bx
	subw	%di, %di
	subw	%si, %si
	movw 	$0x800, %cx
	rep
	movsw
	cmpw	%bp, %bx			# assume start_sys_seg > 0x200,
						# so we will perhaps read one
						# page more than needed, but
						# never overwrite INITSEG
						# because destination is a
						# minimum one page below source
	jb	do_move

end_move:
# then we load the segment descriptors
	movw	%cs, %ax			# aka SETUPSEG
	movw	%ax, %ds
		
# Check whether we need to be downward compatible with version <=201
	cmpl	$0, cmd_line_ptr
	jne	end_move_self		# loader uses version >=202 features
	cmpb	$0x20, type_of_loader
	je	end_move_self		# bootsect loader, we know of it

# Boot loader doesnt support boot protocol version 2.02.
# If we have our code not at 0x90000, we need to move it there now.
# We also then need to move the params behind it (commandline)
# Because we would overwrite the code on the current IP, we move
# it in two steps, jumping high after the first one.
	movw	%cs, %ax
	cmpw	$SETUPSEG, %ax
	je	end_move_self

	cli					# make sure we really have
						# interrupts disabled !
						# because after this the stack
						# should not be used
	subw	$DELTA_INITSEG, %ax		# aka INITSEG
	movw	%ss, %dx
	cmpw	%ax, %dx
	jb	move_self_1

	addw	$INITSEG, %dx
	subw	%ax, %dx			# this will go into %ss after
						# the move
move_self_1:
	movw	%ax, %ds
	movw	$INITSEG, %ax			# real INITSEG
	movw	%ax, %es
	movw	%cs:setup_move_size, %cx
	std					# we have to move up, so we use
						# direction down because the
						# areas may overlap
	movw	%cx, %di
	decw	%di
	movw	%di, %si
	subw	$move_self_here+0x200, %cx
	rep
	movsb
	ljmp	$SETUPSEG, $move_self_here

move_self_here:
	movw	$move_self_here+0x200, %cx
	rep
	movsb
	movw	$SETUPSEG, %ax
	movw	%ax, %ds
	movw	%dx, %ss
end_move_self:					# now we are at the right place
	lidt	idt_48				# load idt with 0,0
	xorl	%eax, %eax			# Compute gdt_base
	movw	%ds, %ax			# (Convert %ds:gdt to a linear ptr)
	shll	$4, %eax
	addl	$gdt, %eax
	movl	%eax, (gdt_48+2)
	lgdt	gdt_48				# load gdt with whatever is
						# appropriate

# that was painless, now we enable a20
	call	empty_8042

	movb	$0xD1, %al			# command write
	outb	%al, $0x64
	call	empty_8042

	movb	$0xDF, %al			# A20 on
	outb	%al, $0x60
	call	empty_8042


#	You must preserve the other bits here. Otherwise embarrasing things
#	like laptops powering off on boot happen. Corrected version by Kira
#	Brown from Linux 2.2

	inb	$0x92, %al			# 
	orb	$02, %al			# "fast A20" version
	outb	%al, $0x92			# some chips have only this

# wait until a20 really *is* enabled; it can take a fair amount of
# time on certain systems; Toshiba Tecras are known to have this
# problem.  The memory location used here (0x200) is the int 0x80
# vector, which should be safe to use.

	xorw	%ax, %ax			# segment 0x0000
	movw	%ax, %fs
	decw	%ax				# segment 0xffff (HMA)
	movw	%ax, %gs
a20_wait:
	incw	%ax				# unused memory location <0xfff0
	movw	%ax, %fs:(0x200)		# we use the "int 0x80" vector
	cmpw	%gs:(0x210), %ax		# and its corresponding HMA addr
	je	a20_wait			# loop until no longer aliased

# make sure any possible coprocessor is properly reset..
	xorw	%ax, %ax
	outb	%al, $0xf0
	call	delay

	outb	%al, $0xf1
	call	delay

# well, that went ok, I hope. Now we mask all interrupts - the rest
# is done in init_IRQ().
	movb	$0xFF, %al			# mask all interrupts for now
	outb	%al, $0xA1
	call	delay
	
	movb	$0xFB, %al			# mask all irq's but irq2 which
	outb	%al, $0x21			# is cascaded

# Well, that certainly wasn't fun :-(. Hopefully it works, and we don't
# need no steenking BIOS anyway (except for the initial loading :-).
# The BIOS-routine wants lots of unnecessary data, and it's less
# "interesting" anyway. This is how REAL programmers do it.

# Well, now's the time to actually move into protected mode. To make
# things as simple as possible, we do no register set-up or anything,
# we let the gnu-compiled 32-bit programs do that. We just jump to
# absolute address 0x1000 (or the loader supplied one),
# in 32-bit protected mode.

# Note that the short jump isn't strictly needed, although there are
# reasons why it might be a good idea. It won't hurt in any case.
	movw	$1, %ax				# protected mode (PE) bit
	lmsw	%ax				# This is it!
	jmp	flush_instr

flush_instr:
	xorw	%bx, %bx			# Flag to indicate a boot
	xorl	%esi, %esi			# Pointer to real-mode code
	movw	%cs, %si
	subw	$DELTA_INITSEG, %si
	shll	$4, %esi			# Convert to 32-bit pointer
# NOTE: For high loaded big kernels we need a
#	jmpi    0x100000,0x10

#	but we yet haven't reloaded the CS register, so the default size 
#	of the target offset still is 16 bit.
#       However, using an operant prefix (0x66), the CPU will properly
#	take our 48 bit far pointer. (INTeL 80386 Programmer's Reference
#	Manual, Mixing 16-bit and 32-bit code, page 16-6)

	.byte 0x66, 0xea			# prefix + jmpi-opcode
code32:	.long	0x1000				# will be set to 0x100000
						# for big kernels
	.word	0x10

# Here's a bunch of information about your current kernel..
kernel_version:	.ascii	"2.4.7-10custom"
		.ascii	" ("
		.ascii	"gaurav"
		.ascii	"@"
		.ascii	"rembrandt.art.cs.cmu.edu"
		.ascii	") "
		.ascii	"#9 Tue Sep 17 19:13:58 EDT 2002"
		.byte	0

# This is the default real mode switch routine.
# to be called just before protected mode transition
default_switch:
	cli					# no interrupts allowed !
	movb	$0x80, %al			# disable NMI for bootup
						# sequence
	outb	%al, $0x70
	lret

# This routine only gets called, if we get loaded by the simple
# bootsect loader _and_ have a bzImage to load.
# Because there is no place left in the 512 bytes of the boot sector,
# we must emigrate to code space here.
bootsect_helper:
	cmpw	$0, %cs:bootsect_es
	jnz	bootsect_second

	movb	$0x20, %cs:type_of_loader
	movw	%es, %ax
	shrw	$4, %ax
	movb	%ah, %cs:bootsect_src_base+2
	movw	%es, %ax
	movw	%ax, %cs:bootsect_es
	subw	$SYSSEG, %ax
	lret					# nothing else to do for now

bootsect_second:
	pushw	%cx
	pushw	%si
	pushw	%bx
	testw	%bx, %bx			# 64K full?
	jne	bootsect_ex

	movw	$0x8000, %cx			# full 64K, INT15 moves words
	pushw	%cs
	popw	%es
	movw	$bootsect_gdt, %si
	movw	$0x8700, %ax
	int	$0x15
	jc	bootsect_panic			# this, if INT15 fails

	movw	%cs:bootsect_es, %es		# we reset %es to always point
	incb	%cs:bootsect_dst_base+2		# to 0x10000
bootsect_ex:
	movb	%cs:bootsect_dst_base+2, %ah
	shlb	$4, %ah				# we now have the number of
						# moved frames in %ax
	xorb	%al, %al
	popw	%bx
	popw	%si
	popw	%cx
	lret

bootsect_gdt:
	.word	0, 0, 0, 0
	.word	0, 0, 0, 0

bootsect_src:
	.word	0xffff

bootsect_src_base:
	.byte	0x00, 0x00, 0x01		# base = 0x010000
	.byte	0x93				# typbyte
	.word	0				# limit16,base24 =0

bootsect_dst:
	.word	0xffff

bootsect_dst_base:
	.byte	0x00, 0x00, 0x10		# base = 0x100000
	.byte	0x93				# typbyte
	.word	0				# limit16,base24 =0
	.word	0, 0, 0, 0			# BIOS CS
	.word	0, 0, 0, 0			# BIOS DS

bootsect_es:
	.word	0

bootsect_panic:
	pushw	%cs
	popw	%ds
	cld
	leaw	bootsect_panic_mess, %si
	call	prtstr
	
bootsect_panic_loop:
	jmp	bootsect_panic_loop

bootsect_panic_mess:
	.string	"INT15 refuses to access high mem, giving up."

# This routine checks that the keyboard command queue is empty
# (after emptying the output buffers)

# Some machines have delusions that the keyboard buffer is always full
# with no keyboard attached...

# If there is no keyboard controller, we will usually get 0xff
# to all the reads.  With each IO taking a microsecond and
# a timeout of 100,000 iterations, this can take about half a
# second ("delay" == outb to port 0x80). That should be ok,
# and should also be plenty of time for a real keyboard controller
# to empty.


empty_8042:
	pushl	%ecx
	movl	$100000, %ecx

empty_8042_loop:
	decl	%ecx
	jz	empty_8042_end_loop

	call	delay

	inb	$0x64, %al			# 8042 status port
	testb	$1, %al				# output buffer?
	jz	no_output

	call	delay
	inb	$0x60, %al			# read it
	jmp	empty_8042_loop

no_output:
	testb	$2, %al				# is input buffer full?
	jnz	empty_8042_loop			# yes - loop
empty_8042_end_loop:
	popl	%ecx
	ret

# Read the cmos clock. Return the seconds in al
gettime:
	pushw	%cx
	movb	$0x02, %ah
	int	$0x1a
	movb	%dh, %al			# %dh contains the seconds
	andb	$0x0f, %al
	movb	%dh, %ah
	movb	$0x04, %cl
	shrb	%cl, %ah
	aad
	popw	%cx
	ret

# Delay is needed after doing I/O
delay:
	outb	%al,$0x80
	ret

# Descriptor tables
gdt:
	.word	0, 0, 0, 0			# dummy
	.word	0, 0, 0, 0			# unused

	.word	0xFFFF				# 4Gb - (0x100000*0x1000 = 4Gb)
	.word	0				# base address = 0
	.word	0x9A00				# code read/exec
	.word	0x00CF				# granularity = 4096, 386
						#  (+5th nibble of limit)

	.word	0xFFFF				# 4Gb - (0x100000*0x1000 = 4Gb)
	.word	0				# base address = 0
	.word	0x9200				# data read/write
	.word	0x00CF				# granularity = 4096, 386
						#  (+5th nibble of limit)
idt_48:
	.word	0				# idt limit = 0
	.word	0, 0				# idt base = 0L
gdt_48:
	.word	0x8000				# gdt limit=2048,
						#  256 GDT entries

	.word	0, 0				# gdt base (filled in later)

# Include video setup & detection code

# 1 "video.S" 1













# 1 "/home/gaurav/redhat-linux/include/linux/config.h" 1 3






# 15 "video.S" 2 3





























































































# This is the main entry point called by setup.S
# %ds *must* be pointing to the bootsector
video:	pushw	%ds		# We use different segments
	pushw	%ds		# FS contains original DS
	popw	%fs
	pushw	%cs		# DS is equal to CS
	popw	%ds
	pushw	%cs		# ES is equal to CS
	popw	%es
	xorw	%ax, %ax
	movw	%ax, %gs	# GS is zero
	cld
	call	basic_detect	# Basic adapter type testing (EGA/VGA/MDA/CGA)

	movw	%fs:(0x01fa), %ax		# User selected video mode
	cmpw	$0xfffd		, %ax			# Bring up the menu
	jz	vid2

	call	mode_set			# Set the mode
	jc	vid1


	leaw	badmdt, %si			# Invalid mode ID
	call	prtstr



vid2:	call	mode_menu
vid1:

	call	restore_screen			# Restore screen contents


	call	mode_params			# Store mode parameters
	popw	%ds				# Restore original DS
	ret

# Detect if we have CGA, MDA, EGA or VGA and pass it to the kernel.
basic_detect:
	movb	$0, %fs:(0x0f)
	movb	$0x12, %ah	# Check EGA/VGA
	movb	$0x10, %bl
	int	$0x10
	movw	%bx, %fs:(0x0a)	# Identifies EGA to the kernel
	cmpb	$0x10, %bl			# No, it's a CGA/MDA/HGA card.
	je	basret

	incb	adapter
	movw	$0x1a00, %ax			# Check EGA or VGA?
	int	$0x10
	cmpb	$0x1a, %al			# 1a means VGA...
	jne	basret				# anything else is EGA.
	
	incb	%fs:(0x0f)		# We've detected a VGA
	incb	adapter
basret:	ret

# Store the video mode parameters for later usage by the kernel.
# This is done by asking the BIOS except for the rows/columns
# parameters in the default 80x25 mode -- these are set directly,
# because some very obscure BIOSes supply insane values.
mode_params:

	cmpb	$0, graphic_mode
	jnz	mopar_gr

	movb	$0x03, %ah			# Read cursor position
	xorb	%bh, %bh
	int	$0x10
	movw	%dx, %fs:(0x00)
	movb	$0x0f, %ah			# Read page/mode/width
	int	$0x10
	movw	%bx, %fs:(0x04)
	movw	%ax, %fs:(0x06)	# Video mode and screen width
	cmpb	$0x7, %al			# MDA/HGA => segment differs
	jnz	mopar0

	movw	$0xb000, video_segment
mopar0: movw	%gs:(0x485), %ax		# Font size
	movw	%ax, %fs:(0x10)	# (valid only on EGA/VGA)
	movw	force_size, %ax			# Forced size?
	orw	%ax, %ax
	jz	mopar1

	movb	%ah, %fs:(0x07)
	movb	%al, %fs:(0x0e)
	ret

mopar1:	movb	$25, %al
	cmpb	$0, adapter			# If we are on CGA/MDA/HGA, the
	jz	mopar2				# screen must have 25 lines.

	movb	%gs:(0x484), %al		# On EGA/VGA, use the EGA+ BIOS
	incb	%al				# location of max lines.
mopar2: movb	%al, %fs:(0x0e)
	ret


# Fetching of VESA frame buffer parameters
mopar_gr:
	leaw	modelist+1024, %di
	movb	$0x23, %fs:(0x0f)
	movw	16(%di), %ax
	movw	%ax, %fs:(0x24)
	movw	18(%di), %ax
	movw	%ax, %fs:(0x12)
	movw	20(%di), %ax
	movw	%ax, %fs:(0x14)
	movb	25(%di), %al
	movb	$0, %ah
	movw	%ax, %fs:(0x16)
	movb	29(%di), %al	
	movb	$0, %ah
	movw	%ax, %fs:(0x32)
	movl	40(%di), %eax
	movl	%eax, %fs:(0x18)
	movl	31(%di), %eax
	movl	%eax, %fs:(0x26)
	movl	35(%di), %eax
	movl	%eax, %fs:(0x26+4)

# get video mem size
	leaw	modelist+1024, %di
	movw	$0x4f00, %ax
	int	$0x10
	xorl	%eax, %eax
	movw	18(%di), %ax
	movl	%eax, %fs:(0x1c)
# get protected mode interface informations
	movw	$0x4f0a, %ax
	xorw	%bx, %bx
	xorw	%di, %di
	int	$0x10
	cmp	$0x004f, %ax
	jnz	no_pm

	movw	%es, %fs:(0x2e)
	movw	%di, %fs:(0x30)
no_pm:	ret

# The video mode menu
mode_menu:
	leaw	keymsg, %si			# "Return/Space/Timeout" message
	call	prtstr
	call	flush
nokey:	call	getkt

	cmpb	$0x0d, %al			# ENTER ?
	je	listm				# yes - manual mode selection

	cmpb	$0x20, %al			# SPACE ?
	je	defmd1				# no - repeat

	call 	beep
	jmp	nokey

defmd1:	ret					# No mode chosen? Default 80x25

listm:	call	mode_table			# List mode table
listm0:	leaw	name_bann, %si			# Print adapter name
	call	prtstr
	movw	card_name, %si
	orw	%si, %si
	jnz	an2

	movb	adapter, %al
	leaw	old_name, %si
	orb	%al, %al
	jz	an1

	leaw	ega_name, %si
	decb	%al
	jz	an1

	leaw	vga_name, %si
	jmp	an1

an2:	call	prtstr
	leaw	svga_name, %si
an1:	call	prtstr
	leaw	listhdr, %si			# Table header
	call	prtstr
	movb	$0x30, %dl			# DL holds mode number
	leaw	modelist, %si
lm1:	cmpw	$0xfffd		, (%si)			# End?
	jz	lm2

	movb	%dl, %al			# Menu selection number
	call	prtchr
	call	prtsp2
	lodsw
	call	prthw				# Mode ID
	call	prtsp2
	movb	0x1(%si), %al
	call	prtdec				# Rows
	movb	$0x78, %al			# the letter 'x'
	call	prtchr
	lodsw
	call	prtdec				# Columns
	movb	$0x0d, %al			# New line
	call	prtchr
	movb	$0x0a, %al
	call	prtchr
	incb	%dl				# Next character
	cmpb	$0x3a, %dl
	jnz	lm1

	movb	$0x61, %dl
	jmp	lm1

lm2:	leaw	prompt, %si			# Mode prompt
	call	prtstr
	leaw	edit_buf, %di			# Editor buffer
lm3:	call	getkey
	cmpb	$0x0d, %al			# Enter?
	jz	lment

	cmpb	$0x08, %al			# Backspace?
	jz	lmbs

	cmpb	$0x20, %al			# Printable?
	jc	lm3

	cmpw	$edit_buf+4, %di		# Enough space?
	jz	lm3

	stosb
	call	prtchr
	jmp	lm3

lmbs:	cmpw	$edit_buf, %di			# Backspace
	jz	lm3

	decw	%di
	movb	$0x08, %al
	call	prtchr
	call	prtspc
	movb	$0x08, %al
	call	prtchr
	jmp	lm3
	
lment:	movb	$0, (%di)
	leaw	crlft, %si
	call	prtstr
	leaw	edit_buf, %si
	cmpb	$0, (%si)			# Empty string = default mode
	jz	lmdef

	cmpb	$0, 1(%si)			# One character = menu selection
	jz	mnusel

	cmpw	$0x6373, (%si)			# "scan" => mode scanning
	jnz	lmhx

	cmpw	$0x6e61, 2(%si)
	jz	lmscan

lmhx:	xorw	%bx, %bx			# Else => mode ID in hex
lmhex:	lodsb
	orb	%al, %al
	jz	lmuse1

	subb	$0x30, %al
	jc	lmbad

	cmpb	$10, %al
	jc	lmhx1

	subb	$7, %al
	andb	$0xdf, %al
	cmpb	$10, %al
	jc	lmbad

	cmpb	$16, %al
	jnc	lmbad

lmhx1:	shlw	$4, %bx
	orb	%al, %bl
	jmp	lmhex

lmuse1:	movw	%bx, %ax
	jmp	lmuse

mnusel:	lodsb					# Menu selection
	xorb	%ah, %ah
	subb	$0x30, %al
	jc	lmbad

	cmpb	$10, %al
	jc	lmuse
	
	cmpb	$0x61-0x30, %al
	jc	lmbad
	
	subb	$0x61-0x30-10, %al
	cmpb	$36, %al
	jnc	lmbad

lmuse:	call	mode_set
	jc	lmdef

lmbad:	leaw	unknt, %si
	call	prtstr
	jmp	lm2
lmscan:	cmpb	$0, adapter			# Scanning only on EGA/VGA
	jz	lmbad

	movw	$0, mt_end			# Scanning of modes is
	movb	$1, scanning			# done as new autodetection.
	call	mode_table
	jmp	listm0
lmdef:	ret

# Additional parts of mode_set... (relative jumps, you know)
setv7:						# Video7 extended modes
	call store_screen
	subb	$0x0900>>8, %bh
	movw	$0x6f05, %ax
	int	$0x10
	stc
	ret

_setrec:	jmp	setrec			# Ugly...
_set_80x25:	jmp	set_80x25

# Aliases for backward compatibility.
setalias:
	movw	$0x0f00, %ax
	incw	%bx
	jz	mode_set

	movb	$0x0f01-0x0f00, %al
	incw	%bx
	jnz	setbad				# Fall-through!

# Setting of user mode (AX=mode ID) => CF=success
mode_set:
	movw	%ax, %bx
	cmpb	$0xff, %ah
	jz	setalias

	testb	$0x8000>>8, %ah
	jnz	_setrec

	cmpb	$0x1000>>8, %ah
	jnc	setres
	
	cmpb	$0x0f00>>8, %ah
	jz	setspc
	
	cmpb	$0x0900>>8, %ah
	jz	setv7
	
	cmpb	$0x0200>>8, %ah
	jnc	check_vesa
	
	orb	%ah, %ah
	jz	setmenu
	
	decb	%ah
	jz	setbios

setbad:	clc
	movb	$0, do_restore			# The screen needn't be restored
	ret

setvesa:
	call store_screen
	subb	$0x0200>>8, %bh
	movw	$0x4f02, %ax			# VESA BIOS mode set call
	int	$0x10
	cmpw	$0x004f, %ax			# AL=4f if implemented
	jnz	setbad				# AH=0 if OK

	stc
	ret

setbios:
	call store_screen
	int	$0x10				# Standard BIOS mode set call
	pushw	%bx
	movb	$0x0f, %ah			# Check if really set
	int	$0x10
	popw	%bx
	cmpb	%bl, %al
	jnz	setbad
	
	stc
	ret

setspc:	xorb	%bh, %bh			# Set special mode
	cmpb	$0x0f09-0x0f00, %bl
	jnc	setbad
	
	addw	%bx, %bx
	jmp	*spec_inits(%bx)

setmenu:
	orb	%al, %al			# 80x25 is an exception
	jz	_set_80x25
	
	pushw	%bx				# Set mode chosen from menu
	call	mode_table			# Build the mode table
	popw	%ax
	shlw	$2, %ax
	addw	%ax, %si
	cmpw	%di, %si
	jnc	setbad
	
	movw	(%si), %ax			# Fetch mode ID
_m_s:	jmp	mode_set

setres:	pushw	%bx				# Set mode chosen by resolution
	call	mode_table
	popw	%bx
	xchgb	%bl, %bh
setr1:	lodsw
	cmpw	$0xfffd		, %ax			# End of the list?
	jz	setbad
	
	lodsw
	cmpw	%bx, %ax
	jnz	setr1
	
	movw	-4(%si), %ax			# Fetch mode ID
	jmp	_m_s

check_vesa:
	leaw	modelist+1024, %di
	subb	$0x0200>>8, %bh
	movw	%bx, %cx			# Get mode information structure
	movw	$0x4f01, %ax
	int	$0x10
	addb	$0x0200>>8, %bh
	cmpw	$0x004f, %ax
	jnz	setbad

	movb	(%di), %al			# Check capabilities.
	andb	$0x19, %al
	cmpb	$0x09, %al
	jz	setvesa				# This is a text mode

	movb	(%di), %al			# Check capabilities.
	andb	$0x99, %al
	cmpb	$0x99, %al
	jnz	_setbad				# Doh! No linear frame buffer.

	subb	$0x0200>>8, %bh
	orw	$0x4000, %bx			# Use linear frame buffer
	movw	$0x4f02, %ax			# VESA BIOS mode set call
	int	$0x10
	cmpw	$0x004f, %ax			# AL=4f if implemented
	jnz	_setbad				# AH=0 if OK

	movb	$1, graphic_mode		# flag graphic mode
	movb	$0, do_restore			# no screen restore
	stc
	ret

_setbad:	jmp	setbad          	# Ugly...

# Recalculate vertical display end registers -- this fixes various
# inconsistencies of extended modes on many adapters. Called when
# the 0x8000 flag is set in the mode ID.

setrec:	subb	$0x8000>>8, %ah		# Set the base mode
	call	mode_set
	jnc	rct3

	movw	%gs:(0x485), %ax		# Font size in pixels
	movb	%gs:(0x484), %bl		# Number of rows
	incb	%bl
	mulb	%bl				# Number of visible
	decw	%ax				# scan lines - 1
	movw	$0x3d4, %dx
	movw	%ax, %bx
	movb	$0x12, %al			# Lower 8 bits
	movb	%bl, %ah
	outw	%ax, %dx
	movb	$0x07, %al		# Bits 8 and 9 in the overflow register
	call	inidx
	xchgb	%al, %ah
	andb	$0xbd, %ah
	shrb	%bh
	jnc	rct1
	orb	$0x02, %ah
rct1:	shrb	%bh
	jnc	rct2
	orb	$0x40, %ah
rct2:	movb	$0x07, %al
	outw	%ax, %dx
	stc
rct3:	ret

# Table of routines for setting of the special modes.
spec_inits:
	.word	set_80x25
	.word	set_8pixel
	.word	set_80x43
	.word	set_80x28
	.word	set_current
	.word	set_80x30
	.word	set_80x34
	.word	set_80x60
	.word	set_gfx

# Set the 80x25 mode. If already set, do nothing.
set_80x25:
	movw	$0x5019, force_size		# Override possibly broken BIOS
use_80x25:





	movb	$0x0f, %ah			# Get current mode ID
	int	$0x10
	cmpw	$0x5007, %ax	# Mode 7 (80x25 mono) is the only one available
	jz	st80		# on CGA/MDA/HGA and is also available on EGAM

	cmpw	$0x5003, %ax	# Unknown mode, force 80x25 color
	jnz	force3

st80:	cmpb	$0, adapter	# CGA/MDA/HGA => mode 3/7 is always 80x25
	jz	set80

	movb	%gs:(0x0484), %al	# This is EGA+ -- beware of 80x50 etc.
	orb	%al, %al		# Some buggy BIOS'es set 0 rows
	jz	set80
	
	cmpb	$24, %al		# It's hopefully correct
	jz	set80

force3:	call store_screen
	movw	$0x0003, %ax			# Forced set
	int	$0x10
set80:	stc
	ret

# Set the 80x50/80x43 8-pixel mode. Simple BIOS calls.
set_8pixel:
	call store_screen
	call	use_80x25			# The base is 80x25
set_8pt:
	movw	$0x1112, %ax			# Use 8x8 font
	xorb	%bl, %bl
	int	$0x10
	movw	$0x1200, %ax			# Use alternate print screen
	movb	$0x20, %bl
	int	$0x10
	movw	$0x1201, %ax			# Turn off cursor emulation
	movb	$0x34, %bl
	int	$0x10
	movb	$0x01, %ah			# Define cursor scan lines 6-7
	movw	$0x0607, %cx
	int	$0x10
set_current:
	stc
	ret

# Set the 80x28 mode. This mode works on all VGA's, because it's a standard
# 80x25 mode with 14-point fonts instead of 16-point.
set_80x28:
	call store_screen
	call	use_80x25			# The base is 80x25
set14:	movw	$0x1111, %ax			# Use 9x14 font
	xorb	%bl, %bl
	int	$0x10
	movb	$0x01, %ah			# Define cursor scan lines 11-12
	movw	$0x0b0c, %cx
	int	$0x10
	stc
	ret

# Set the 80x43 mode. This mode is works on all VGA's.
# It's a 350-scanline mode with 8-pixel font.
set_80x43:
	call store_screen
	movw	$0x1201, %ax			# Set 350 scans
	movb	$0x30, %bl
	int	$0x10
	movw	$0x0003, %ax			# Reset video mode
	int	$0x10
	jmp	set_8pt				# Use 8-pixel font

# Set the 80x30 mode (all VGA's). 480 scanlines, 16-pixel font.
set_80x30:
	call	use_80x25			# Start with real 80x25
	call store_screen
	movw	$0x3cc, %dx			# Get CRTC port
	inb	%dx, %al
	movb	$0xd4, %dl
	rorb	%al				# Mono or color?
	jc	set48a

	movb	$0xb4, %dl
set48a:	movw	$0x0c11, %ax		# Vertical sync end (also unlocks CR0-7)
 	call	outidx
	movw	$0x0b06, %ax			# Vertical total
 	call	outidx
	movw	$0x3e07, %ax			# (Vertical) overflow
 	call	outidx
	movw	$0xea10, %ax			# Vertical sync start
 	call	outidx
	movw	$0xdf12, %ax			# Vertical display end
	call	outidx
	movw	$0xe715, %ax			# Vertical blank start
 	call	outidx
	movw	$0x0416, %ax			# Vertical blank end
 	call	outidx
	pushw	%dx
	movb	$0xcc, %dl			# Misc output register (read)
 	inb	%dx, %al
 	movb	$0xc2, %dl			# (write)
 	andb	$0x0d, %al	# Preserve clock select bits and color bit
 	orb	$0xe2, %al			# Set correct sync polarity
 	outb	%al, %dx
	popw	%dx
	movw	$0x501e, force_size
	stc					# That's all.
	ret

# Set the 80x34 mode (all VGA's). 480 scans, 14-pixel font.
set_80x34:
	call	set_80x30			# Set 480 scans
	call	set14				# And 14-pt font
	movw	$0xdb12, %ax			# VGA vertical display end
	movw	$0x5022, force_size
setvde:	call	outidx
	stc
	ret

# Set the 80x60 mode (all VGA's). 480 scans, 8-pixel font.
set_80x60:
	call	set_80x30			# Set 480 scans
	call	set_8pt				# And 8-pt font
	movw	$0xdf12, %ax			# VGA vertical display end
	movw	$0x503c, force_size
	jmp	setvde

# Special hack for ThinkPad graphics
set_gfx:







	ret



# Store screen contents to temporary buffer.
store_screen:
	cmpb	$0, do_restore			# Already stored?
	jnz	stsr

	testb	$CAN_USE_HEAP, loadflags	# Have we space for storing?
	jz	stsr
	
	pushw	%ax
	pushw	%bx
	pushw	force_size			# Don't force specific size
	movw	$0, force_size
	call	mode_params			# Obtain params of current mode
	popw	force_size
	movb	%fs:(0x0e), %ah
	movb	%fs:(0x07), %al
	movw	%ax, %bx			# BX=dimensions
	mulb	%ah
	movw	%ax, %cx			# CX=number of characters
	addw	%ax, %ax			# Calculate image size
	addw	$modelist+1024+4, %ax
	cmpw	heap_end_ptr, %ax
	jnc	sts1				# Unfortunately, out of memory

	movw	%fs:(0x00), %ax	# Store mode params
	leaw	modelist+1024, %di
	stosw
	movw	%bx, %ax
	stosw
	pushw	%ds				# Store the screen
	movw	video_segment, %ds
	xorw	%si, %si
	rep
	movsw
	popw	%ds
	incb	do_restore			# Screen will be restored later
sts1:	popw	%bx
	popw	%ax
stsr:	ret

# Restore screen contents from temporary buffer.
restore_screen:
	cmpb	$0, do_restore			# Has the screen been stored?
	jz	res1

	call	mode_params			# Get parameters of current mode
	movb	%fs:(0x0e), %cl
	movb	%fs:(0x07), %ch
	leaw	modelist+1024, %si		# Screen buffer
	lodsw					# Set cursor position
	movw	%ax, %dx
	cmpb	%cl, %dh
	jc	res2
	
	movb	%cl, %dh
	decb	%dh
res2:	cmpb	%ch, %dl
	jc	res3
	
	movb	%ch, %dl
	decb	%dl
res3:	movb	$0x02, %ah
	movb	$0x00, %bh
	int	$0x10
	lodsw					# Display size
	movb	%ah, %dl			# DL=number of lines
	movb	$0, %ah				# BX=phys. length of orig. line
	movw	%ax, %bx
	cmpb	%cl, %dl			# Too many?
	jc	res4

	pushw	%ax
	movb	%dl, %al
	subb	%cl, %al
	mulb	%bl
	addw	%ax, %si
	addw	%ax, %si
	popw	%ax
	movb	%cl, %dl
res4:	cmpb	%ch, %al			# Too wide?
	jc	res5
	
	movb	%ch, %al			# AX=width of src. line
res5:	movb	$0, %cl
	xchgb	%ch, %cl
	movw	%cx, %bp			# BP=width of dest. line
	pushw	%es
	movw	video_segment, %es
	xorw	%di, %di			# Move the data
	addw	%bx, %bx			# Convert BX and BP to _bytes_
	addw	%bp, %bp
res6:	pushw	%si
	pushw	%di
	movw	%ax, %cx
	rep
	movsw
	popw	%di
	popw	%si
	addw	%bp, %di
	addw	%bx, %si
	decb	%dl
	jnz	res6
	
	popw	%es				# Done
res1:	ret


# Write to indexed VGA register (AL=index, AH=data, DX=index reg. port)
outidx:	outb	%al, %dx
	pushw	%ax
	movb	%ah, %al
	incw	%dx
	outb	%al, %dx
	decw	%dx
	popw	%ax
	ret

# Build the table of video modes (stored after the setup.S code at the
# `modelist' label. Each video mode record looks like:
#	.word	MODE-ID		(our special mode ID (see above))
#	.byte	rows		(number of rows)
#	.byte	columns		(number of columns)
# Returns address of the end of the table in DI, the end is marked
# with a 0xfffd		 ID.
mode_table:
	movw	mt_end, %di			# Already filled?
	orw	%di, %di
	jnz	mtab1x
	
	leaw	modelist, %di			# Store standard modes:
	movl	$0x0f00 + 0x50190000, %eax	# The 80x25 mode (ALL)
	stosl
	movb	adapter, %al			# CGA/MDA/HGA -- no more modes
	orb	%al, %al
	jz	mtabe
	
	decb	%al
	jnz	mtabv
	
	movl	$0x0f01 + 0x502b0000, %eax	# The 80x43 EGA mode
	stosl
	jmp	mtabe

mtab1x:	jmp	mtab1

mtabv:	leaw	vga_modes, %si			# All modes for std VGA
	movw	$vga_modes_end-vga_modes, %cx
	rep	# I'm unable to use movsw as I don't know how to store a half
	movsb	# of the expression above to cx without using explicit shr.

	cmpb	$0, scanning			# Mode scan requested?
	jz	mscan1
	
	call	mode_scan
mscan1:






	call	vesa_modes			# Detect VESA VGA modes










mtabe:


	leaw	modelist, %si
	movw	%di, %dx
	movw	%si, %di
cmt1:	cmpw	%dx, %si			# Scan all modes
	jz	cmt2

	leaw	modelist, %bx			# Find in previous entries
	movw	2(%si), %cx
cmt3:	cmpw	%bx, %si
	jz	cmt4

	cmpw	2(%bx), %cx			# Found => don't copy this entry
	jz	cmt5

	addw	$4, %bx
	jmp	cmt3

cmt4:	movsl					# Copy entry
	jmp	cmt1

cmt5:	addw	$4, %si				# Skip entry
	jmp	cmt1

cmt2:


	movw	$0xfffd		, (%di)			# End marker
	movw	%di, mt_end
mtab1:	leaw	modelist, %si			# SI=mode list, DI=list end
ret0:	ret

# Modes usable on all standard VGAs
vga_modes:
	.word	0x0f01
	.word	0x5032				# 80x50
	.word	0x0f02
	.word	0x502b				# 80x43
	.word	0x0f03
	.word	0x501c				# 80x28
	.word	0x0f05
	.word	0x501e				# 80x30
	.word	0x0f06
	.word	0x5022				# 80x34
	.word	0x0f07
	.word	0x503c				# 80x60





vga_modes_end:
# Detect VESA modes.


vesa_modes:
	cmpb	$2, adapter			# VGA only
	jnz	ret0

	movw	%di, %bp			# BP=original mode table end
	addw	$0x200, %di			# Buffer space
	movw	$0x4f00, %ax			# VESA Get card info call
	int	$0x10
	movw	%bp, %di
	cmpw	$0x004f, %ax			# Successful?
	jnz	ret0
	
	cmpw	$0x4556, 0x200(%di)
	jnz	ret0
	
	cmpw	$0x4153, 0x202(%di)
	jnz	ret0
	
	movw	$vesa_name, card_name		# Set name to "VESA VGA"
	pushw	%gs
	lgsw	0x20e(%di), %si			# GS:SI=mode list
	movw	$128, %cx			# Iteration limit
vesa1:
# gas version 2.9.1, using BFD version 2.9.1.0.23 buggers the next inst.
# XXX:	lodsw	%gs:(%si), %ax			# Get next mode in the list
	gs; lodsw
	cmpw	$0xffff, %ax			# End of the table?
	jz	vesar
	
	cmpw	$0x0080, %ax			# Check validity of mode ID
	jc	vesa2
	
	orb	%ah, %ah		# Valid IDs: 0x0000-0x007f/0x0100-0x07ff
	jz	vesan			# Certain BIOSes report 0x80-0xff!

	cmpw	$0x0800, %ax
	jnc	vesae

vesa2:	pushw	%cx
	movw	%ax, %cx			# Get mode information structure
	movw	$0x4f01, %ax
	int	$0x10
	movw	%cx, %bx			# BX=mode number
	addb	$0x0200>>8, %bh
	popw	%cx
	cmpw	$0x004f, %ax
	jnz	vesan			# Don't report errors (buggy BIOSES)

	movb	(%di), %al			# Check capabilities. We require
	andb	$0x19, %al			# a color text mode.
	cmpb	$0x09, %al
	jnz	vesan
	
	cmpw	$0xb800, 8(%di)		# Standard video memory address required
	jnz	vesan

	testb	$2, (%di)			# Mode characteristics supplied?
	movw	%bx, (%di)			# Store mode number
	jz	vesa3
	
	xorw	%dx, %dx
	movw	0x12(%di), %bx			# Width
	orb	%bh, %bh
	jnz	vesan
	
	movb	%bl, 0x3(%di)
	movw	0x14(%di), %ax			# Height
	orb	%ah, %ah
	jnz	vesan
	
	movb	%al, 2(%di)
	mulb	%bl
	cmpw	$8193, %ax		# Small enough for Linux console driver?
	jnc	vesan

	jmp	vesaok

vesa3:	subw	$0x8108, %bx	# This mode has no detailed info specified,
	jc	vesan		# so it must be a standard VESA mode.

	cmpw	$5, %bx
	jnc	vesan

	movw	vesa_text_mode_table(%bx), %ax
	movw	%ax, 2(%di)
vesaok:	addw	$4, %di				# The mode is valid. Store it.
vesan:	loop	vesa1			# Next mode. Limit exceeded => error
vesae:	leaw	vesaer, %si
	call	prtstr
	movw	%bp, %di			# Discard already found modes.
vesar:	popw	%gs
	ret

# Dimensions of standard VESA text modes
vesa_text_mode_table:
	.byte	60, 80				# 0108
	.byte	25, 132				# 0109
	.byte	43, 132				# 010A
	.byte	50, 132				# 010B
	.byte	60, 132				# 010C


# Scan for video modes. A bit dirty, but should work.
mode_scan:
	movw	$0x0100, %cx			# Start with mode 0
scm1:	movb	$0, %ah				# Test the mode
	movb	%cl, %al
	int	$0x10
	movb	$0x0f, %ah
	int	$0x10
	cmpb	%cl, %al
	jnz	scm2				# Mode not set

	movw	$0x3c0, %dx			# Test if it's a text mode
	movb	$0x10, %al			# Mode bits
	call	inidx
	andb	$0x03, %al
	jnz	scm2
	
	movb	$0xce, %dl			# Another set of mode bits
	movb	$0x06, %al
	call	inidx
	shrb	%al
	jc	scm2
	
	movb	$0xd4, %dl			# Cursor location
	movb	$0x0f, %al
	call	inidx
	orb	%al, %al
	jnz	scm2
	
	movw	%cx, %ax			# Ok, store the mode
	stosw
	movb	%gs:(0x484), %al		# Number of rows
	incb	%al
	stosb
	movw	%gs:(0x44a), %ax		# Number of columns
	stosb
scm2:	incb	%cl
	jns	scm1
	
	movw	$0x0003, %ax			# Return back to mode 3
	int	$0x10
	ret

tstidx:	outw	%ax, %dx			# OUT DX,AX and inidx
inidx:	outb	%al, %dx			# Read from indexed VGA register
	incw	%dx			# AL=index, DX=index reg port -> AL=data
	inb	%dx, %al
	decw	%dx
	ret

# Try to detect type of SVGA card and supply (usually approximate) video
# mode table for it.

# 1786 "video.S"


# User-defined local mode table (VGA only)
# 1814 "video.S"


# Read a key and return the ASCII code in al, scan code in ah
getkey:	xorb	%ah, %ah
	int	$0x16
	ret

# Read a key with a timeout of 30 seconds.
# The hardware clock is used to get the time.
getkt:	call	gettime
	addb	$30, %al			# Wait 30 seconds
	cmpb	$60, %al
	jl	lminute

	subb	$60, %al
lminute:
	movb	%al, %cl
again:	movb	$0x01, %ah
	int	$0x16
	jnz	getkey				# key pressed, so get it

	call	gettime
	cmpb	%cl, %al
	jne	again

	movb	$0x20, %al			# timeout, return `space'
	ret

# Flush the keyboard buffer
flush:	movb	$0x01, %ah
	int	$0x16
	jz	empty
	
	xorb	%ah, %ah
	int	$0x16
	jmp	flush

empty:	ret

# Print hexadecimal number.
prthw:	pushw	%ax
	movb	%ah, %al
	call	prthb
	popw	%ax
prthb:	pushw	%ax
	shrb	$4, %al
	call	prthn
	popw	%ax
	andb	$0x0f, %al
prthn:	cmpb	$0x0a, %al
	jc	prth1

	addb	$0x07, %al
prth1:	addb	$0x30, %al
	jmp	prtchr

# Print decimal number in al
prtdec:	pushw	%ax
	pushw	%cx
	xorb	%ah, %ah
	movb	$0x0a, %cl
	idivb	%cl
	cmpb	$0x09, %al
	jbe	lt100

	call	prtdec
	jmp	skip10

lt100:	addb	$0x30, %al
	call	prtchr
skip10:	movb	%ah, %al
	addb	$0x30, %al
	call	prtchr	
	popw	%cx
	popw	%ax
	ret

# VIDEO_SELECT-only variables
mt_end:		.word	0	# End of video mode table if built
edit_buf:	.space	6	# Line editor buffer
card_name:	.word	0	# Pointer to adapter name
scanning:	.byte	0	# Performing mode scan
do_restore:	.byte	0	# Screen contents altered during mode change
svga_prefix:	.byte	0x0100>>8	# Default prefix for BIOS modes
graphic_mode:	.byte	0	# Graphic mode with a linear frame buffer

# Status messages
keymsg:		.ascii	"Press <RETURN> to see video modes available, "
		.ascii	"<SPACE> to continue or wait 30 secs"
		.byte	0x0d, 0x0a, 0

listhdr:	.byte	0x0d, 0x0a
		.ascii	"Mode:    COLSxROWS:"

crlft:		.byte	0x0d, 0x0a, 0

prompt:		.byte	0x0d, 0x0a
		.asciz	"Enter mode number or `scan': "

unknt:		.asciz	"Unknown mode ID. Try again."

badmdt:		.ascii	"You passed an undefined mode number."
		.byte	0x0d, 0x0a, 0

vesaer:		.ascii	"Error: Scanning of VESA modes failed. Please "
		.ascii	"report to <mj@ucw.cz>."
		.byte	0x0d, 0x0a, 0

old_name:	.asciz	"CGA/MDA/HGA"

ega_name:	.asciz	"EGA"

svga_name:	.ascii	" "

vga_name:	.asciz	"VGA"

vesa_name:	.asciz	"VESA"

name_bann:	.asciz	"Video adapter: "


# Other variables:
adapter:	.byte	0	# Video adapter: 0=CGA/MDA/HGA,1=EGA,2=VGA
video_segment:	.word	0xb800	# Video memory segment
force_size:	.word	0	# Use this size instead of the one in BIOS vars
# 930 "setup.S" 2

# Setup signature -- must be last
setup_sig1:	.word	0xAA55
setup_sig2:	.word	0x5A5A

# After this point, there is some free space which is used by the video mode
# handling code to store the temporary mode table (not used by the kernel).

modelist:

.text
endtext:
.data
enddata:
.bss
endbss:
