/*
 * Copyright (c) 2001 Christoph Hellwig.
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ident "$Id: stat.c,v 1.1 2001/03/31 17:04:49 hch Exp $"

/*
 * Emulation for iABI stat(2) and friends.
 */
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/file.h>
#include <linux/fs.h>
#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/stat.h>
#include <asm/uaccess.h>

#include <abi/abi.h>
#include <abi/stat.h>


/*
 * Believe it or not, the original stat structure is compatible with ibcs2.
 * The xstat struct used by SVr4 is different than our new struct, but we will
 * deal with that later
 */
static int
cp_abi_stat(struct inode *ip, struct ibcs_stat *stp)
{
	struct ibcs_stat	st;

	memset(&st, 0, sizeof(struct ibcs_stat));
	
	/*
	 * Note that we have to fold a long inode number down to a short.
	 * This must match what happens in coff:ibcs_read() and
	 * open.c:svr4_getdents() since code that figures out cwd needs
	 * the inodes to match. Because it must match read() on a
	 * directory we have to avoid the situation where we end up
	 * with a zero inode value. A zero inode value in a read()
	 * on a directory indicates an empty directory slot.
	 */
	if ((u_long)ip->i_ino & 0xffff)
		st.st_ino = (u_long)ip->i_ino & 0xffff;
	else
		st.st_ino = 0xfffe;

	st.st_dev =	ip->i_dev;
	st.st_mode =	ip->i_mode;
	st.st_nlink =	ip->i_nlink;
	st.st_uid =	ip->i_uid;
	st.st_gid =	ip->i_gid;
	st.st_rdev =	ip->i_rdev;
	st.st_size =	ip->i_size;
	st.st_atime =	ip->i_atime;
	st.st_mtime =	ip->i_mtime;
	st.st_ctime =	ip->i_ctime;

	return (copy_to_user(stp, &st, sizeof(struct ibcs_stat)) ? -EFAULT : 0);
}

DEF_STAT(abi_stat, struct ibcs_stat, cp_abi_stat);
DEF_LSTAT(abi_lstat, struct ibcs_stat, cp_abi_stat);
DEF_FSTAT(abi_fstat, struct ibcs_stat, cp_abi_stat);
