/* $Id: mmap.c,v 1.5 2001/07/30 11:50:35 hch Exp $
 * mmap.c - svr4 mmap(2) emulation
 *
 * Copyright (c) 1994 Eric Youngdale
 * Copyright (c) 2001 Christoph Hellwig
 */

#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/file.h>
#include <linux/module.h>
#include <linux/mm.h>
#include <linux/mman.h>
#include <linux/personality.h>

int
svr4_mmap(u_int addr, u_int len, int prot, int flags, int fd, u_int off)
{
	struct file *		fp = NULL;
	u_long			ret;

	if (!(flags & MAP_ANONYMOUS)) {
		fp = fget(fd);
		if (!fp)
			return -EBADFD;
	}

	if (!(flags & 0x80000000) && addr) {
		down_write(&current->mm->mmap_sem);
		ret = do_mmap(fp, addr, len, prot, flags | MAP_FIXED, off);
		up_write(&current->mm->mmap_sem);
		if (ret == addr)
			ret = 0;
	} else {
		down_write(&current->mm->mmap_sem);
		ret = do_mmap(fp, addr, len, prot, flags & 0x7fffffff, off);
		up_write(&current->mm->mmap_sem);
	}

	if (fp)
		fput(fp);
	return ret;
}
