/* $Id: isc_funcs.c,v 1.7 2001/06/07 22:45:47 hch Exp $
 * isc_funcs.c - the isc syscall dispatcher
 */

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/personality.h>
#include <linux/syscall.h>
#include <asm/uaccess.h>

#include <abi/svr4/sysent.h>

#include <abi/sysent.h>
#include <abi/abi.h>
#include <abi/abi4.h>

static abi_func_t ISC_funcs[] = {
   { 0,			Ukn	ITR(1, "isc_sysisc0",	"")	}, /* 00 */
   { isc_setostype,	1	ITR(0, "isc_setostype",	"d")	}, /* 01 */
   { SC(rename),	-2	ITR(0, "isc_rename",	"ss")	}, /* 02 */
   { abi_sigaction,	3	ITR(0, "isc_sigaction",	"dxx")	}, /* 03 */
   { abi_sigprocmask,	3	ITR(0, "isc_sicprocmask","dxx")	}, /* 04 */
   { 0,			1	ITR(0, "isc_sigpending","x")	}, /* 05 */
   { sys_getgroups16,	2	ITR(0, "isc_getgroups",	"dp")	}, /* 06 */
   { sys_setgroups16,	2	ITR(0, "isc_setgroups",	"dp")	}, /* 07 */
   { 0,			Ukn	ITR(1, "pathconf",	"")	}, /* 08 */
   { 0,			Ukn	ITR(1, "fpathconf",	"")	}, /* 09 */
   { ibcs_sysconf,	1	ITR(0, "sysconf",	"d")	}, /* 10 */
   { SC(waitpid),	-3	ITR(0, "isc_waitpid",	"dxx")	}, /* 11 */
   { SC(setsid),	-ZERO	ITR(0, "isc_setsid",	"")	}, /* 12 */
   { SC(setpgid),	-2	ITR(0, "isc_setpgid",	"dd")	}, /* 13 */
   { 0,			Ukn	ITR(1, "isc_adduser",	"")	}, /* 14 */
   { 0,			Ukn	ITR(1, "isc_setuser",	"")	}, /* 15 */
   { 0,			Ukn	ITR(1, "isc_sysisc16",	"")	}, /* 16 */
   { abi_sigsuspend,	Spl	ITR(0, "isc_sigsuspend","x")	}, /* 17 */
   { SC(symlink),	-2	ITR(0, "isc_symlink",	"ss")	}, /* 18 */
   { SC(readlink),	-3	ITR(0, "isc_readlink",	"spd")	}, /* 19 */
   { 0,			Ukn	ITR(1, "isc_getmajor",	"")	} /* 20 */
};


void iBCS_class_ISC(struct pt_regs *regs) {
	int i;

	get_user(i, ((unsigned long *)regs->esp)+1);
	if (i > 20) {
		regs->eax = iABI_errors(-EINVAL);
		regs->eflags |= 1;
		return;
	}
	
	abi_dispatch(regs, &ISC_funcs[i], 2);
	return;
}
