/* $Id: errmap.c,v 1.3 2001/05/03 15:13:22 hch Exp $
 * funcs.c - iBCS syscall dispatch table
 *
 */

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/init.h>
#include <abi/abi.h>
#include <abi/signal.h>
#include <abi/svr4.h>
#include <abi/abi4.h>

static char type_svr4_to_linux_seg1[] = {
        SOCK_STREAM,
        SOCK_DGRAM,
        0,
        SOCK_RAW,
        SOCK_RDM,
        SOCK_SEQPACKET
};
struct map_segment svr4_socktype_map[] = {
        /* 1 to 6 are remapped as indicated. Nothing else is valid. */
        { 1, 6, type_svr4_to_linux_seg1 },
        { -1 }
};

/* Map Linux RESTART* values (512,513,514) to EINTR */
static unsigned char LNX_err_table[] = {
        EINTR, EINTR, EINTR
};


/*
 * Default Linux to iBCS mapping.
 * We could remove some of the long identity mapped runs but at the
 * expense of extra comparisons for each mapping at run time...
 */
static unsigned char SVR4_err_table[] = {
          0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
         16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
         32, 33, 34, 45, 78, 46, 89, 93, 90, 90, 35, 36, 37, 38, 39, 40,
         41, 42, 43, 44, 50, 51, 52, 53, 54, 55, 56, 57, 60, 61, 62, 63,
         64, 65, 66, 67, 68, 69, 70, 71, 74, 76, 77, 79, 80, 81, 82, 83,
         84, 85, 86, 87, 88, 91, 92, 94, 95, 96, 97, 98, 99,120,121,122,
        123,124,125,126,127,128,129,130,131,132,133,134,143,144,145,146,
        147,148,149,150, 22,135,137,138,139,140, 28
};


/* SVR4 (aka the full official iBCS) is the base mapping - no exceptions,
 * other than the RESTART* values.
 */
struct map_segment svr4_err_map[] = {
        { 0,    0+sizeof(SVR4_err_table)-1,     SVR4_err_table },
        { 512,  512+sizeof(LNX_err_table)-1,    LNX_err_table },
        { -1 }
};
