/*	$Id: sysent.c,v 1.2 2001/07/16 14:37:47 hch Exp $	*/
/*
 *  abi/solaris/do_solaris.c
 *
 * Solaris sysent table and module initilization.
 */

#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/personality.h>
#include <linux/syscall.h>

#include <abi/abi.h>
#include <abi/abi4.h>
#include <abi/svr4.h>
#include <abi/solaris.h>
#include <abi/socket.h>
#include <abi/sysent.h>

#include <abi/svr4/sysent.h>
#include <abi/solaris/sysent.h>

EXPORT_NO_SYMBOLS;


extern void svr4_class_cxenix(struct pt_regs *regs);
extern void iBCS_class_ISC(struct pt_regs *regs);	/* XXX: ISC on solaris? */


static abi_func_t Solaris_funcs[] = {
   { abi_syscall,	Fast	ITR(0, "syscall",	"")	}, /*    0 */
   { SC(exit),		-1	ITR(0, "exit",		"d")	}, /*    1 */
   { abi_fork,		Spl	ITR(0, "fork",		"")	}, /*    2 */
   { abi_read,		3	ITR(0, "read",		"dpd")	}, /*    3 */
   { SC(write),		-3	ITR(0, "write",		"dpd")	}, /*    4 */
   { svr4_open,		3	ITR(0, "open",		"soo")	}, /*    5 */
   { SC(close),		-1	ITR(0, "close",		"d")	}, /*    6 */
   { abi_wait,		Spl	ITR(0, "wait",		"xxx")	}, /*    7 */
   { SC(creat),		-2	ITR(0, "creat",		"so")	}, /*    8 */
   { SC(link),		-2	ITR(0, "link",		"ss")	}, /*    9 */
   { SC(unlink),	-1	ITR(0, "unlink",	"s")	}, /*   10 */
   { abi_exec,		Spl	ITR(0, "exec",		"sxx")	}, /*   11 */
   { SC(chdir),		-1	ITR(0, "chdir",		"s")	}, /*   12 */
   { abi_time,		0	ITR(0, "time",		"")	}, /*   13 */
   { abi_mknod,		3	ITR(0, "mknod",		"soo")	}, /*   14 */
   { SC(chmod),		-2	ITR(0, "chmod",		"so")	}, /*   15 */
   { SC(chown),		-3	ITR(0, "chown",		"sdd")	}, /*   16 */
   { abi_brk,		1	ITR(0, "brk/break",	"x")	}, /*   17 */
   { abi_stat,		2	ITR(0, "stat",		"sp")	}, /*   18 */
   { sys_lseek,		3	ITR(0, "seek/lseek",	"ddd")	}, /*   19 */
   { abi_getpid,	Spl	ITR(0, "getpid",	"")	}, /*   20 */
   { 0,			Ukn	ITR(1, "mount",		"")	}, /*   21 */
   { SC(umount),	-1	ITR(0, "umount",	"s")	}, /*   22 */
   { SC(setuid),	-1	ITR(0, "setuid",	"d")	}, /*   23 */
   { abi_getuid,	Spl	ITR(0, "getuid",	"")	}, /*   24 */
   { SC(stime),		-1	ITR(0, "stime",		"d")	}, /*   25 */
   { 0,			Ukn	ITR(0, "ptrace",	"")	}, /*   26 */
   { SC(alarm),		-1	ITR(0, "alarm",		"d")	}, /*   27 */
   { abi_fstat,		2	ITR(0, "fstat",		"dp")	}, /*   28 */
   { SC(pause),		-ZERO	ITR(0, "pause",		"")	}, /*   29 */
   { SC(utime),		-2	ITR(0, "utime",		"xx")	}, /*   30 */
   { 0,			Ukn	ITR(0, "stty",		"")	}, /*   31 */
   { 0,			Ukn	ITR(1, "gtty",		"")	}, /*   32 */
   { SC(access),	-2	ITR(0, "access",	"so")	}, /*   33 */
   { SC(nice),		-1	ITR(0, "nice",		"d")	}, /*   34 */
   { svr4_statfs,	4	ITR(0, "statfs",	"spdd")	}, /*   35 */
   { SC(sync),		-ZERO	ITR(0, "sync",		"")	}, /*   36 */
   { abi_kill,		2	ITR(0, "kill",		"dd")	}, /*   37 */
   { svr4_fstatfs,	4	ITR(0, "fstatfs",	"dpdd")	}, /*   38 */
   { abi_procids,	Spl	ITR(0, "ibcs_procids",	"d")	}, /*   39 */
   { svr4_class_cxenix,	Fast	ITR(0, "cxenix",	"")	}, /*   40 */
   { SC(dup),		-1	ITR(0, "dup",		"d")	}, /*   41 */
   { abi_pipe,		Spl	ITR(0, "pipe",		"")	}, /*   42 */
   { SC(times),		-1	ITR(0, "times",		"p")	}, /*   43 */
   { SC(profil),	-4	ITR(0, "prof",		"xxxx")}, /*   44 */
   { 0,			Ukn	ITR(1, "lock/plock",	"")	}, /*   45 */
   { SC(setgid),	-1	ITR(0, "setgid",	"d")	}, /*   46 */
   { abi_getgid,	Spl	ITR(0, "getgid",	"")	}, /*   47 */
   { abi_sigfunc,	Fast	ITR(0, "sigfunc",	"xxx")	}, /*   48 */
   { svr4_msgsys,	Spl	ITR(0, "msgsys",	"dxddd")}, /*   49 */
   { svr4_sysi86,	Spl	ITR(0, "sysi86/sys3b",	"d")	}, /*   50 */
   { SC(acct),		-1	ITR(0, "acct/sysacct",	"x")	}, /*   51 */
   { svr4_shmsys,	Fast	ITR(0, "shmsys",	"ddxo")}, /*   52 */
   { svr4_semsys,	Spl	ITR(0, "semsys",	"dddx")}, /*   53 */
   { svr4_ioctl,	Spl	ITR(0, "ioctl",		"dxx")	}, /*   54 */
   { 0,			3	ITR(0, "uadmin",	"xxx")	}, /*   55 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   56 */
   { v7_utsname,	1	ITR(0, "utsys",		"x")	}, /*   57 */
   { SC(fsync),		-1	ITR(0, "fsync",		"d")	}, /*   58 */
   { abi_exec,		Spl	ITR(0, "execv",		"spp")	}, /*   59 */
   { SC(umask),		-1	ITR(0, "umask",		"o")	}, /*   60 */
   { SC(chroot),	-1	ITR(0, "chroot",	"s")	}, /*   61 */
   { svr4_fcntl,	Spl	ITR(0, "fcntl",		"dxx")	}, /*   62 */
   { svr4_ulimit,	2	ITR(0, "ulimit",	"xx")	}, /*   63 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   64 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   65 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   66 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   67 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   68 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   69 */
   { 0,			Ukn	ITR(1, "advfs",		"")	}, /*   70 */
   { 0,			Ukn	ITR(1, "unadvfs",	"")	}, /*   71 */
   { 0,			Ukn	ITR(1, "rmount",	"")	}, /*   72 */
   { 0,			Ukn	ITR(1, "rumount",	"")	}, /*   73 */
   { 0,			Ukn	ITR(1, "rfstart",	"")	}, /*   74 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   75 */
   { 0,			Ukn	ITR(1, "rdebug",	"")	}, /*   76 */
   { 0,			Ukn	ITR(1, "rfstop",	"")	}, /*   77 */
   { 0,			Ukn	ITR(1, "rfsys",		"")	}, /*   78 */
   { SC(rmdir),		-1	ITR(0, "rmdir",		"s")	}, /*   79 */
   { abi_mkdir,		2	ITR(0, "mkdir",		"so")	}, /*   80 */
   { svr4_getdents,	3	ITR(0, "getdents",	"dxd")	}, /*   81 */
   { 0,			Ukn	ITR(1, "libattach",	"")	}, /*   82 */
   { 0,			Ukn	ITR(1, "libdetach",	"")	}, /*   83 */
   { svr4_sysfs,	3	ITR(0, "sysfs",		"dxx")	}, /*   84 */
   { svr4_getmsg,	Spl	ITR(0, "getmsg",	"dxxx")	}, /*   85 */
   { svr4_putmsg,	Spl	ITR(0, "putmsg",	"dxxd")	}, /*   86 */
   { SC(poll),		-3	ITR(0, "poll",		"xdd")	}, /*   87 */
   { abi_lstat,		2	ITR(0, "lstat",		"sp")	}, /*   88 */
   { SC(symlink),	-2	ITR(0, "symlink",	"ss")	}, /*   89 */
   { SC(readlink),	-3	ITR(0, "readlink",	"spd")	}, /*   90 */
   { sys_setgroups,	2	ITR(0, "setgroups",	"dp")	}, /*   91 */
   { sys_getgroups,	2	ITR(0, "getgroups",	"dp")	}, /*   92 */
   { SC(fchmod),	-2	ITR(0, "fchmod",	"do")	}, /*   93 */
   { SC(fchown),	-3	ITR(0, "fchown",	"ddd")	}, /*   94 */
   { abi_sigprocmask,	3	ITR(0, "sigprocmask",	"dxx")	}, /*   95 */
   { abi_sigsuspend,	Spl	ITR(0, "sigsuspend",	"x")	}, /*   96 */
   { 0,			2	ITR(1, "sigaltstack",	"xx")	}, /*   97 */
   { abi_sigaction,	3	ITR(0, "sigaction",	"dxx")	}, /*   98 */
   { svr4_sigpending,	2	ITR(1, "sigpending",	"dp")	}, /*   99 */
   { svr4_context,	Spl	ITR(0, "context",	"")	}, /*   100 */
   { 0,			Ukn	ITR(1, "evsys",		"")	}, /*   101 */
   { 0,			Ukn	ITR(1, "evtrapret",	"")	}, /*   102 */
   { abi_statvfs,	2	ITR(0, "statvfs",	"sp")	}, /*   103 */
   { abi_fstatvfs,	2	ITR(0, "fstatvfs",	"dp")	}, /*   104 */
   { iBCS_class_ISC,	Fast	ITR(0, "sysisc",	"")	}, /*   105 */
   { 0,			Ukn	ITR(1, "nfssys",	"")	}, /*   106 */
   { 0,			4	ITR(0, "waitid",	"ddxd")	}, /*   107 */
   { 0,			3	ITR(1, "sigsendsys",	"ddd")	}, /*   108 */
   { svr4_hrtsys,	Spl	ITR(0, "hrtsys",	"xxx")	}, /*   109 */
   { 0,			3	ITR(1, "acancel",	"dxd")	}, /*   110 */
   { 0,			Ukn	ITR(1, "async",		"")	}, /*   111 */
   { 0,			Ukn	ITR(1, "priocntlsys",	"")	}, /*   112 */
   { svr4_pathconf,	2	ITR(1, "pathconf",	"sd")	}, /*   113 */
   { 0,			3	ITR(1, "mincore",	"xdx")	}, /*   114 */
   { svr4_mmap,		6	ITR(0, "mmap",		"xxxxdx") },/*   115 */
   { SC(mprotect),	-3	ITR(0, "mprotect",	"xdx")  },/*   116 */
   { SC(munmap),	-2	ITR(0, "munmap",	"xd")   },/*   117 */
   { svr4_fpathconf,	2	ITR(1, "fpathconf",	"dd")	}, /*   118 */
   { abi_fork,		Spl	ITR(0, "vfork",		"")	}, /*   119 */
   { SC(fchdir),	-1	ITR(0, "fchdir",	"d")	}, /*   120 */
   { SC(readv),		-3	ITR(0, "readv",		"dxd")	}, /*   121 */
   { SC(writev),	-3	ITR(0, "writev",	"dxd")	}, /*   122 */
   { svr4_xstat,	3	ITR(0, "xstat",		"dsx")	}, /*   123 */
   { svr4_lxstat,     	3	ITR(0, "lxstat",	"dsx")	}, /*   124 */
   { svr4_fxstat,	3	ITR(0, "fxstat",	"ddx")	}, /*   125 */
   { svr4_xmknod,	4	ITR(0, "xmknod",	"dsox")}, /*   126 */
   { 0,			Spl	ITR(0, "syslocal",	"d")	}, /*   127 */
   { svr4_getrlimit,	2	ITR(0, "setrlimit",	"dx")	}, /*   128 */
   { svr4_setrlimit,	2	ITR(0, "getrlimit",	"dx")	}, /*   129 */
   { 0,			3	ITR(1, "lchown",	"sdd")	}, /*   130 */
   { 0,			Ukn	ITR(1, "memcntl",	"")	}, /*   131 */
#ifdef CONFIG_ABI_XTI
   { svr4_getpmsg,	5	ITR(0, "getpmsg",	"dxxxx")}, /*   132 */
   { svr4_putpmsg,	5	ITR(0, "putpmsg",	"dxxdd")}, /*   133 */
#else
   { 0,			5	ITR(0, "getpmsg",	"dxxxx")}, /*   132 */
   { 0,			5	ITR(0, "putpmsg",	"dxxdd")}, /*   133 */
#endif
   { SC(rename),	-2	ITR(0, "rename",	"ss")	}, /*   134 */
   { abi_utsname,	1	ITR(0, "uname",		"x")	}, /*   135 */
   { svr4_setegid,	1	ITR(1, "setegid",	"d")	}, /*   136 */
   { svr4_sysconfig,	1	ITR(0, "sysconfig",	"d")	}, /*   137 */
   { 0,			Ukn	ITR(1, "adjtime",	"")	}, /*   138 */
   { svr4_sysinfo,	3	ITR(0, "systeminfo",	"dsd")	}, /*   139 */
   { socksys_syscall,	1	ITR(0, "socksys_syscall","x")	}, /*   140 */
   { svr4_seteuid,	1	ITR(1, "seteuid",	"d")	}, /*   141 */
   { 0,			Ukn	ITR(1, "vtrace",       	"")	}, /*   142 */
   { 0,			Ukn	ITR(1, "fork1",		"")	}, /*   143 */
   { 0,			Ukn	ITR(1, "sigtimedwait",	"")	}, /*	144 */
   { 0,			Ukn	ITR(1, "lwp_info",	"")	}, /*	145 */
   { 0,			Ukn	ITR(1, "yield",		"")	}, /*	146 */
   { 0,			Ukn	ITR(1, "lwp_sema_wait",	"")	}, /*	147 */
   { 0,			Ukn	ITR(1, "lwp_sema_post",	"")	}, /*	148 */
   { 0,			Ukn	ITR(1, "lwp_sema_trywait","")	}, /*	149 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*	150 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*	151 */
   { 0,			Ukn	ITR(1, "modctl",       	"")	}, /*	152 */
   { 0,			Ukn	ITR(1, "fchroot",	"")	}, /*	153 */
   { 0,			Ukn	ITR(1, "utimes",	"")	}, /*	154 */
   { 0,			Ukn	ITR(1, "vhangup",      	"")	}, /*	155 */
   { SC(gettimeofday),	-2	ITR(0, "gettimeofday",	"xx")	}, /*	156 */
   { SC(getitimer),	-2	ITR(0, "getitimer",    	"dx")	}, /*	157 */
   { SC(setitimer),	-3	ITR(0, "setitimer",	"dxx")	}, /*	158 */
   { 0,			Ukn	ITR(1, "lwp_create",	"")	}, /*	159 */
   { 0,			Ukn	ITR(1, "lwp_exit",	"")	}, /*	160 */
   { 0,			Ukn	ITR(1, "lwp_suspend",	"")	}, /*	161 */
   { 0,			Ukn	ITR(1, "lwp_continue",	"")	}, /*	162 */
   { 0,			Ukn	ITR(1, "lwp_kill",	"")	}, /*	163 */
   { 0,			Ukn	ITR(1, "lwp_self",	"")	}, /*	164 */
   { 0,			Ukn	ITR(1, "lwp_setprivate","")	}, /*	165 */
   { 0,			Ukn	ITR(1, "lwp_getprivate","")	}, /*	166 */
   { 0,			Ukn	ITR(1, "lwp_wait",	"")	}, /*	167 */
   { 0,			Ukn	ITR(1, "lwp_mutex_unlock","")	}, /*	168 */
   { 0,			Ukn	ITR(1, "lwp_mutex_lock","")	}, /*	169 */
   { 0,			Ukn	ITR(1, "lwp_cond_wait",	"")	}, /*	170 */
   { 0,			Ukn	ITR(1, "lwp_cond_signal","")	}, /*	171 */
   { 0,			Ukn	ITR(1, "lwp_cond_broadcast","")	}, /*	172 */
   { SC(pread),	       	-4	ITR(1, "pread",		"dpdd")	}, /*	173 */
   { SC(pwrite),	-4	ITR(1, "pwrite",	"dpdd")	}, /*	174 */
   { sol_llseek,      	Spl	ITR(1, "llseek",	"dxxd")	}, /*	175 */
   { 0,			Ukn	ITR(1, "inst_sync",	"")	}, /*	176 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*	177 */
   { 0,			Ukn	ITR(1, "kaio",		"")	}, /*	178 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*	179 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*	180 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*	181 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*	182 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*	183 */
   { 0,			Ukn	ITR(1, "tsolsys",      	"")	}, /*	184 */
   { sol_acl,		4	ITR(1, "acl",		"sddp")	}, /*	185 */
   { 0,			Ukn	ITR(1, "auditsys",	"")	}, /*	186 */
   { 0,			Ukn	ITR(1, "processor_bind","")	}, /*	187 */
   { 0,			Ukn	ITR(1, "processor_info","")	}, /*	188 */
   { 0,			Ukn	ITR(1, "p_online",     	"")	}, /*	189 */
   { 0,			Ukn	ITR(1, "sigqueue",	"")	}, /*	190 */
   { 0,			Ukn	ITR(1, "clock_gettime",	"")	}, /*	191 */
   { 0,			Ukn	ITR(1, "clock_settime",	"")	}, /*	192 */
   { 0,			Ukn	ITR(1, "clock_getres",	"")	}, /*	193 */
   { 0,			Ukn	ITR(1, "timer_create",	"")	}, /*	194 */
   { 0,			Ukn	ITR(1, "timer_delete",	"")	}, /*	195 */
   { 0,			Ukn	ITR(1, "timer_settime",	"")	}, /*	196 */
   { 0,			Ukn	ITR(1, "timer_gettime",	"")	}, /*	197 */
   { 0,			Ukn	ITR(1, "timer_getoverrun","")	}, /*	198 */
   { SC(nanosleep),	-2	ITR(1, "nanosleep",	"pp")	}, /*	199 */
   { 0,			Ukn	ITR(1, "modstat",	"")	}, /*	200 */
   { 0,			Ukn	ITR(1, "facl",		"")	}, /*	201 */
   { SC(setreuid),	-2	ITR(1, "setreuid",	"dd")	}, /*	202 */
   { SC(setregid),	-2	ITR(1, "setregid",	"dd")	}, /*	203 */
   { 0,			Ukn	ITR(1, "install_utrap",	"")	}, /*	204 */
   { 0,			Ukn	ITR(1, "signotify",	"")	}, /*	205 */
   { 0,			Ukn	ITR(1, "schedctl",	"")	}, /*	206 */
   { 0,			Ukn	ITR(1, "pset",		"")	}, /*	207 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /* 208 */
   { 0,			Ukn	ITR(1, "resolvepath",	"")	}, /* 209 */
   { 0,			Ukn	ITR(1, "signotifywait",	"")	}, /* 210 */
   { 0,			Ukn	ITR(1, "lwp_sigredirect","")	}, /* 211 */
   { 0,			Ukn	ITR(1, "lwp_alarm",	"")	}, /* 212 */
   { sol_getdents64,	3  	ITR(0, "getdents64", 	"dxd")	}, /* 213 */
   { sol_mmap64,	7	ITR(1, "mmap64",      "pxdddxx")}, /*214 */
   { sol_stat64,      	2	ITR(0, "stat64",       	"sp")	}, /* 215 */
   { sol_lstat64,	2	ITR(0, "lstat64",	"sp")	}, /* 216 */
   { sol_fstat64,	2	ITR(0, "fstat64",       "dp")	}, /* 217 */
   { 0,			Ukn	ITR(1, "statvfs64",	"")	}, /* 218 */
   { 0,			Ukn	ITR(1, "fstatvfs64",	"")	}, /* 219 */
   { 0,			Ukn	ITR(1, "setrlimit64",	"")	}, /* 220 */
   { 0,			Ukn	ITR(1, "getrlimit64",	"")	}, /* 221 */
   { 0,			Ukn	ITR(1, "pread64",	"")	}, /* 222 */
   { 0,			Ukn	ITR(1, "pwrite64",	"")	}, /* 223 */
   { 0,			Ukn	ITR(1, "creat64",	"")	}, /* 224 */
   { sol_open64,      	3	ITR(0, "open64",       	"soo")	}, /* 225 */
   { 0,			Ukn	ITR(1, "rpcsys",	"")	}, /* 226 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /* 227 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /* 228 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /* 229 */
   { solaris_socket,		3	ITR(1, "so_socket",	"ddd")	}, /* 230 */
   { solaris_socketpair,	1	ITR(1, "so_socketpair",	"dddx")	}, /* 231 */
   { solaris_bind,		3	ITR(1, "bind",		"dxd")	}, /* 232 */
   { solaris_listen,		2	ITR(1, "listen",	"dd")	}, /* 233 */
   { solaris_accept,		3	ITR(1, "accept",	"dxx")	}, /* 234 */
   { solaris_connect,		3	ITR(1, "connect",	"dxd")	}, /* 235 */
   { solaris_shutdown,		2	ITR(1, "shutdown",	"dd")	}, /* 236 */
   { solaris_recv,		4	ITR(1, "recv",		"dxdd")	}, /* 237 */
   { solaris_recvfrom,		6	ITR(1, "recvfrom",     "dxddxd")}, /* 238 */
   { solaris_recvmsg,		3	ITR(1, "recvmsg",	"dxd")	}, /* 239 */
   { solaris_send,		4	ITR(1, "send",		"dxdd")	}, /* 240 */
   { solaris_sendmsg,  		3	ITR(0, "sendmsg",      	"dxd")	}, /* 241 */
   { solaris_sendto,		6	ITR(1, "sendto",       "dxddxd")}, /* 242 */
   { solaris_getpeername,	3	ITR(1, "getpeername",	"dxx")	}, /* 243 */
   { solaris_getsockname,	3	ITR(1, "getsockname",	"dxx")	}, /* 244 */
   { solaris_getsockopt,	5	ITR(1, "getsockopt",	"dddxx")}, /* 245 */
   { solaris_setsockopt,	5	ITR(1, "setsockopt",	"dddxd")}, /* 246 */
   { 0,			Ukn	ITR(1, "sockconfig",	"")	}, /* 247 */
   { 0,			Ukn	ITR(1, "ntp_gettime",	"")	}, /* 248 */
   { 0,     	 	Ukn	ITR(0, "ntp_adjtime",  	"")	}, /* 249 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /* 250 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /* 251 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /* 252 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /* 253 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /* 254 */
   { 0,			Ukn	ITR(1, "?",		"")	}  /* 255 */
};



static void Solaris_lcall7(int segment, struct pt_regs * regs)
{
	abi_dispatch(regs, &Solaris_funcs[regs->eax & 0xff], 1);
}

extern struct map_segment svr4_err_map[];
extern struct map_segment svr4_socktype_map[];
extern struct map_segment abi_sockopt_map[];
extern struct map_segment abi_af_map[];

extern long linux_to_ibcs_signals[];
extern long ibcs_to_linux_signals[];


struct exec_domain solaris_exec_domain = {
	"Solaris/x86",
	Solaris_lcall7,
	13 /* PER_SOLARIS */, 13 /* PER_SOLARIS */,
	ibcs_to_linux_signals,
	linux_to_ibcs_signals,
	svr4_err_map,
	svr4_socktype_map,
	abi_sockopt_map,
	abi_af_map,
	THIS_MODULE,
	NULL
};


static void __exit solaris_cleanup(void)
{
	unregister_exec_domain(&solaris_exec_domain);
}

static int __init solaris_init(void)
{
	return register_exec_domain(&solaris_exec_domain);
}

module_init(solaris_init);
module_exit(solaris_cleanup);
