/* 
 * Real-Time and Multimedia Systems Laboratory
 * Copyright (c) 2000 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */

#include <time.h>
#include <rk/posix_timers.h>
#include <sys/time.h>
#include <linux/unistd.h>
#include <errno.h>

int clock_settime(clockid_t clock_id, const struct timespec *tp)
{
    struct timeval tv;
    if (clock_id != CLOCK_REALTIME || tp->tv_nsec < 0
	|| tp->tv_nsec >= 1000000000) {
	errno = EINVAL;
	return -1;
    }
    tv.tv_sec = tp->tv_sec;
    tv.tv_usec = tp->tv_nsec / 1000;
    return settimeofday(&tv, NULL);
}

int clock_gettime(clockid_t clock_id, struct timespec *tp)
{
    struct timeval tv;
    if (clock_id != CLOCK_REALTIME) {
	errno = EINVAL;
	return -1;
    }
    gettimeofday(&tv, NULL);
    tp->tv_sec = tv.tv_sec;
    tp->tv_nsec = tv.tv_usec * 1000;
    return 0;
}

int clock_getres(clockid_t clock_id, struct timespec *res)
{
    if (clock_id != CLOCK_REALTIME) {
	errno = EINVAL;
	return -1;
    }
    if (res) {
	res->tv_sec = 0;
	res->tv_nsec = 1000;
    }
    return 0;
}

_syscall3(int, timer_create,
	  clockid_t, clock_id, struct sigevent *, evp, timer_t_rk *, timerid)

_syscall1(int, timer_delete, timer_t_rk, timerid)
_syscall4(int, timer_settime,
	   timer_t_rk, timerid,
	   int, flags,
	   const struct itimerspec *, value, struct itimerspec *, ovalue)

_syscall2(int, timer_gettime, timer_t_rk, timerid, struct itimerspec *, value)
_syscall1(int, timer_getoverrun, timer_t_rk, timerid)
