/*
 * Copyright (C) 2000 TimeSys Corporation
 *
 * This is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <unistd.h>
#include <rk/rk.h>
#include <rk/rk_error.h>
#include <signal.h>

rk_resource_set_t rs;

void print_usage(char *cmdname)
{
    printf("usage: %s n (ms/sec) \n", cmdname);
}

int main(int argc, char *argv[])
{

    rk_reserve_t cpu_rsv;
    struct timespec c, t;
    int load = 100;		/* load of Xms/1sec */
    cpu_reserve_attr_data_t attr;
    char name[16];
    int i, j, res;

    if (argc > 2)
	print_usage(argv[0]);

    if (argc == 2)
	load = atoi(argv[1]);


    /* create resource set */
    sprintf(name, "RK: %d", getpid());
    rs = rk_resource_set_create("name");
    {
	rk_reserve_param_data_t p;	/* specify sch_mode, enforcement, replenishment */
	c.tv_sec = 0, c.tv_nsec = load * 1000 * 1000;	/* Computation: load ms */
	t.tv_sec = 1, t.tv_nsec = 0;	/* Period: 1 sec        */
	p.enf_mode = RSV_HARD;	/* enum in rk.h -> check =0x1 */
	p.sch_mode = p.rep_mode = RSV_HARD;
	attr.compute_time = c;
	attr.period = t;
	attr.deadline = t;
	attr.blocking_time.tv_sec = 0;
	attr.blocking_time.tv_nsec = 0;
	attr.start_time.tv_sec = 0;
	attr.start_time.tv_nsec = 0;
	attr.reserve_type = p;
	//attr.c_cycles = (load * 206400)/1000;

	printf("Reserve params-> enf: %d, sch: %d, rep: %d\n",
	       attr.reserve_type.enf_mode, attr.reserve_type.sch_mode,
	       attr.reserve_type.rep_mode);

	cpu_rsv = rk_cpu_reserve_create(rs, &attr);
    }

    /* attach the current process to a resource set */
    if ((res = rk_resource_set_attach_process(rs, getpid())) == RK_ERROR) {
	fprintf(stderr, "rk_resource_set_attach_process: failed on %d\n",
		getpid());
	exit(-1);
    }

    printf("Resource Set (0x%x)=(%d) CPU Reserve (0x%x)\n", (int) rs,
	   (int) rs, (int) cpu_rsv);

    for (i = 0; i < 50; i++) {
	fprintf(stderr, "(i: %d)", i);
	for (j = 0; j < 10000000; j++) {
	    /* just consume time */
	}
    }

    return 0;
}
