/* 
 * Real-Time and Multimedia Systems Laboratory
 * Copyright (c) 2000 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <rk/rk.h>
#include <rk/css.h>

#define SLEEP_TIME 1

char out1[] = "output1.tar\0";
char out2[] = "output2.tar\0";


void
fork_and_tar(int result, char * dir, int rsv_flag)
{
    int child;
    char * args[6] = {"tar\0","-b100\0","-cf\0"};
    rk_resource_set_t rs;
    rk_reserve_param_data_t p; 
    css_disk_cpu_reserve_attr_data_t attr;

    child = fork();
    if (child == -1) {
	 perror("fork: ");
	 exit(-1);
    } else if (child != 0)
	 return;

    /* Insert fs_rsv foo here */
    if (rsv_flag) {
      rs = rk_resource_set_create("");
      if (!rs) {
	printf("resource_set create error! \n");
	exit(1);
      }
      /* create css reserve */
      p.enf_mode = RSV_HARD;            /* enum in rk.h   */
      p.sch_mode = RSV_HARD;
      p.rep_mode = RSV_HARD;
#define KB 1024
      attr.compute_bf.tv_sec = 0;
      attr.compute_bf.tv_nsec = 0;
      attr.compute_af.tv_sec = 0;
      attr.compute_af.tv_nsec = 0;
      attr.size = 400*KB;
      attr.period.tv_sec = 0;
      attr.period.tv_nsec = 400000000; /* 400 ms */
      attr.deadline = attr.period;
      attr.blocking_time.tv_sec = (long int) 0;
      attr.blocking_time.tv_nsec = (long int) 0;
      attr.start_time.tv_sec = (long int) 0;
      attr.start_time.tv_nsec = (long int) 0;
      attr.reserve_type = p;
      if (css_disk_cpu_reserve_create(rs, &attr)) {
	printf("css create failed! \n");
	rk_resource_set_destroy(rs);
	exit(1);
      }
      
      /* Let's wait that the reserves are attached to their resource sets */
      while(rk_resource_set_get_cpu_rsv(rs) == 0);
      if (rk_resource_set_attach_process(rs, getpid())) {
	printf("attach process error!\n");
	rk_resource_set_destroy(rs);
	exit(1);
      }
    }
    else rs = NULL_RESOURCE_SET;

    /* Exec tar */
    if (result == 1)
	 args[3] = out1;
    else
	 args[3] = out2;
    args[4] = dir;
    args[5] = NULL;

    if (execvp("tar",args) < 0)
	 perror("exec: ");

    if (rs) rk_resource_set_destroy(rs);
    return;
}


void
watch_tarballs()
{
    struct stat stats;
    ssize_t s1,s2;
    char buf[60];

    s1 = 0;
    s2 = 0;
    for(;;) {
	 if (!stat(out1,&stats))
	     s1 = stats.st_size;

	 if (!stat(out2,&stats))
	     s2 = stats.st_size;

	 bzero(buf,sizeof(buf));
	 snprintf(buf,sizeof(buf),"\r%s: %d, %s: %d",out1,s1,out2,s2);
	 write(fileno(stdout),buf,sizeof(buf));

	 sleep(SLEEP_TIME);
    }
}


int
main(int argc, char *argv[])
{
  int rsv_flag;
    if (argc != 4) {
	 printf("Insufficient arguments.\n");
	 printf("Usage: %s [directory1/] [directory2/] [rsv_flag]\n", argv[0]);
	 printf("This demo will spawn two processes to tar two directories. \n");
	 printf("With rsv_flag set to 1, the directory2 (which is spawned later) is tarred w/ fs reservation. Otherwise, neither of both doesn't have reservations \n");
	 exit(-1);
    }

    rsv_flag =  atoi(argv[3]);

    if (rsv_flag) {
      fork_and_tar(1, argv[1], 0);
      fork_and_tar(2, argv[2], 1);
    }
    else {
      fork_and_tar(1, argv[1], 0);
      fork_and_tar(2, argv[2], 0);
    }

    watch_tarballs();

    return 0;
}
