/* 
 * Real-Time and Multimedia Systems Laboratory
 * Copyright (c) 2000 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <unistd.h>
#include <rk/rk.h>
#include <signal.h>

rk_resource_set_t rs;

#define KB 1024
void 
print_usage(char *cmdname){
  printf("Usage: %s <resource_set> <reserved_Kbytes> <period-ms> \n", cmdname);
}

int 
main(int argc, char *argv[]){

  rk_reserve_t	disk_rsv;
  unsigned long period;

  int load = 1; /* load of Xms/1sec */

  if (argc != 4){
    print_usage(argv[0]);
    return -1;
  }
  
  if ((rs = (rk_resource_set_t)atoi(argv[1])) == NULL) {
    fprintf(stderr, "%s: could not create resource set.  RK module loaded?\n", argv[0]);
    exit(-1);
  }

  load = atoi(argv[2]);
  period = atoi(argv[3]);

  {
    rk_reserve_param_data_t p; /* specify sch_mode, enforcement, replenishment */
      disk_reserve_attr_data_t attr;

      p.enf_mode = RSV_HARD;		/* enum in rk.h   */ 
      p.sch_mode = RSV_HARD;
      p.rep_mode = RSV_HARD;

      attr.size = load*KB;
      attr.period.tv_sec = period/1000;
      attr.period.tv_nsec = (period%1000)*1000000;
      attr.deadline = attr.period;
      attr.blocking_time.tv_sec = (long int) 0;
      attr.blocking_time.tv_nsec = (long int) 0;
      attr.start_time.tv_sec = (long int) 0;
      attr.start_time.tv_nsec = (long int) 0; 
      attr.reserve_type = p;
      disk_rsv = rk_disk_reserve_create(rs, &attr);
      printf("size = %d bytes, period = (%d,%d) \n", 
	     (int) attr.size, 
	     (int) attr.period.tv_sec,
	     (int) attr.period.tv_nsec);
  }

  printf("Resource Set (0x%x)=(%d) DISK Reserve (0x%x)=(%d)\n", 
	 (int)rs, (int)rs, (int)disk_rsv, (int)disk_rsv);
  
  return (int)disk_rsv; 
}
