/* 
 * Real-Time and Multimedia Systems Laboratory
 * Copyright (c) 2000 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */

#include <stdlib.h>
#include <stdio.h>
#include <time.h>

#include <rk/rk.h>
#include <rk/rk_error.h>
#include <rk/posix_timers.h>
#include <rk/timespec.h>
#include <sys/mman.h>


#define BUFFSIZE 1024 
#define KB 1024
static char line[BUFFSIZE * KB];
static int timevec[4*KB];
static int timereq_sec[4*KB];
static int timereq_nsec[4*KB];
static int timedone_sec[4*KB];
static int timedone_nsec[4*KB];

void usage(char *command) {
  printf("%s [filename] [size of blocks (KB)] [blocks to read] [number of loops(0-until the end of the file)]<break_time (ms)>\n", command);
}

int main(int argc, char *argv[])
{
  char filename[128], outfilename[128];
  FILE *fp,*fo;
  int bytes, break_time,blocks,i,j,loop;
  struct timespec t_start,t_stop;
  struct timespec sleep_time;
  struct timespec remain_time;
  
  if (argc < 4) {
    usage(argv[0]);
    return -1;
  }
  strcpy(filename, argv[1]);
  bytes = atoi(argv[2]); 
  blocks = atoi(argv[3]);
  if (argc<5) loop = 0;
  else loop = atoi(argv[4]);

  if (argc<6) break_time = 0;
  else break_time = atoi(argv[5]);

  if (bytes * blocks > BUFFSIZE) {
    printf("buffer overflow, should specify less than %d KB \n", BUFFSIZE);
    return -1;
  }
#if 0
  if (mlockall(MCL_FUTURE)) {
    printf("memory lock error \n");
    exit(1);
  }
#endif 
  /* try to load everything */
  memset(line,0,BUFFSIZE*KB); 
  fp = fopen(filename, "r"); 
  if (!fp) {
    printf("file open error! \n");
    return -1;
  }
  printf("Input the output filename \n");

  scanf("%s", outfilename);
  fo = fopen(outfilename, "w");
  if (!fo) {
    printf("file output error! \n");
    return -1;
  }
  fprintf(fo,"#filename = %s bytes = %d blocks = %d  breaktime = %d ms\n",filename, bytes, blocks, break_time);
  fprintf(fo,"#Completion time in micro-seconds \n");
  fprintf(fo,"# <iteration> <completion time> \n");

  if (loop == 0) loop = 4*KB;
  for (i=0; i<loop;i++) {
    
    line[0]=0;
    clock_gettime(CLOCK_REALTIME, &t_start);
    if (!fread(line, bytes * KB, blocks, fp)) {
      goto close;
    }
    clock_gettime(CLOCK_REALTIME, &t_stop);
    {
      /* find completion time */
      unsigned long tm1, tm2;
      tm1 = t_start.tv_sec * 1000000 + t_start.tv_nsec / 1000;
      tm2 = t_stop.tv_sec * 1000000 + t_stop.tv_nsec / 1000;
      //printf("%d\n", i);
      timevec[i]=tm2-tm1;
      timereq_sec[i]=t_start.tv_sec;
      timereq_nsec[i]=t_start.tv_nsec;
      timedone_sec[i]=t_stop.tv_sec;
      timedone_nsec[i]=t_stop.tv_nsec;

    }
    if (break_time) {
      sleep_time.tv_sec = break_time/1000;
      sleep_time.tv_nsec = (break_time%1000)*1000000;
      nanosleep(&sleep_time, &remain_time);
    }
  }
 close:
  clock_gettime(CLOCK_REALTIME, &t_stop);
  {
    /* find completion time */
    unsigned long tm1, tm2;
    tm1 = t_start.tv_sec * 1000000 + t_start.tv_nsec / 1000;
    tm2 = t_stop.tv_sec * 1000000 + t_stop.tv_nsec / 1000;
    timevec[i]=0;
    timereq_sec[i]=0;             /* ignore all this */
    timereq_nsec[i]=0;
    timedone_sec[i]=0;
    timedone_nsec[i]=0;
  }

  printf(" loop i ends at %d \n", i);
  if (i>=4*KB) printf("Warning: i beyonds the buffer size \n");
  fclose(fp); 
  /* write data to file */
  for (j=0;i>0;i--,j++) {
    fprintf(fo,"%d %d\n",j*400,timevec[j]);
  }
  fclose(fo);
  printf(".......end of the program write data output to %s complete!\n", outfilename);
#if 0
  if (munlockall()) {
   printf("unlock memory error \n");
   exit(1);
  }
#endif 
  return 0;
}  
