/* Hey Emacs, this is -*-C-*- 
 ******************************************************************************
 * ava.h -- AVA definition file.
 * 
 * Author          : Peter Bosch
 * Created On      : Wed Apr 14 15:07:39 1999
 * Last Modified By: Peter Bosch
 * Last Modified On: Fri Apr 16 09:41:01 1999
 * Status          : Unknown, Use with caution!
 * 
 * Unless other notices are present in any part of this file
 * explicitly claiming copyrights for other people and/or 
 * organizations, the contents of this file is fully copyright 
 * (C) 1999 Peter Bosch, all rights reserved.
 * 
 ******************************************************************************
 */

#ifndef _AVA_H
#define _AVA_H

typedef struct {
  uint32_t     	f_frame;		/* Frame number */
  uint32_t	f_where;		/* Location of frame */
  uint32_t	f_tile;			/* Tile index offset */
  uint32_t      f_size;                 /* Size of frame */
} frameindex_t;

typedef struct {
  uint32_t	t_frame;		/* Frame number */
  Time_t	t_tc;			/* Time code of frame */
} timeindex_t;

#define K		1024
#define M 		(K * K)
#define MAXPDUSZ	(4 * K)
#define FRAMENUM(buf, bufsize)	\
((uint32_t)			\
 ((((uint8_t *)(buf))[(bufsize) - 11] & 0xFF) << 16) | \
 ((((uint8_t *)(buf))[(bufsize) - 10] & 0xFF) << 8)  | \
 ((((uint8_t *)(buf))[(bufsize) - 9] & 0xFF)))
#define MAXPACKF	100

#endif

