/*                               -*- Mode: C -*- 
 * cwtruncate.c -- Truncate a dp.
 * 
 * Author          : 
 * Created On      : Sun Jan 31 12:35:21 1999
 * Last Modified By: Peter Bosch
 * Last Modified On: Thu Sep 23 10:43:22 1999
 * Status          : Unknown, Use with caution!
 * 
 * Unless other notices are present in any part of this file
 * explicitly claiming copyrights for other people and/or 
 * organizations, the contents of this file is fully copyright 
 * (C) 1999 Peter Bosch, all rights reserved.
 */

#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/stat.h>
#include <unistd.h>
#include <sched.h>
#include <string.h>
#include <sys/sysmacros.h>

#include "cwif.h"

static char *progname;

extern int optind;
extern char *optarg;

static void
usage()
{
  fprintf(stderr, "Usage: %s [-?] dpname dpsize_hi dpsize_lo\n", progname);
  exit(1);
}

int
main(int argc, char **argv)
{
  int opt, fd;
  char *dpname;
  uint64_t dpsize;
  uint32_t dplo, dphi;

  progname = argv[0];
  while ((opt = getopt(argc, argv, "?")) != EOF) {
    switch (opt) {
    case '?':
      usage();
    }
  }
  if (optind != argc - 3) usage();

  dpname = argv[optind++];
  dphi = strtoul(argv[optind++], (char **)NULL, 0);
  dplo = strtoul(argv[optind++], (char **)NULL, 0);
  dpsize = ((uint64_t)dphi << 32)|(uint32_t)dplo;

  fd = open(dpname, O_RDWR);
  if (fd < 0) {
    fprintf(stderr, "%s: Cannot open %s: %s\n",
	    progname, dpname, strerror(errno));
    exit(1);
  }

  printf("dpsize x%016qX\n", dpsize);
  if (ioctl(fd, CW_TRUNCATE, &dpsize) < 0) {
    fprintf(stderr, "%s: Cannot truncate %s: %s\n",
	    progname, dpname, strerror(errno));
    exit(1);
  }
  (void)close(fd);
  exit(0);
}
