# Hey Emacs, this is -*-Python-*- 
                                                                               
# install.py -- Install a file.
# 
# Author          : Peter Bosch
# Created On      : Mon Oct 11 12:33:21 1999
# Last Modified By: Peter Bosch
# Last Modified On: Mon Oct 11 13:19:16 1999
# Status          : Unknown, Use with caution!
# 
# Unless other notices are present in any part of this file
# explicitly claiming copyrights for other people and/or 
# organizations, the contents of this file is fully copyright 
# (C) 1999 Peter Bosch, all rights reserved.
                                                                               
# 

import sys, posix

K = 1024
M = K * K 
cwutils = '/home/huygens/peterb/src/cw'
cwreserve = cwutils + '/cwreserve/cwreserve'

if len(sys.argv) != 5:
    sys.stderr.write('Usage: ' + sys.argv[0] + ' ifile odp dbmhi dbmlo\n')
    sys.exit(1)

fname   = sys.argv[1]
dbmhi   = sys.argv[3]
dbmlo   = sys.argv[4]
(a, b, c, nlinks, uid, gid, fsize, time1, time2, time3) = posix.stat(fname)
nblocks = (fsize + M - 1) / M

pid = posix.fork()
if pid == 0:
    args = ['reserve', sys.argv[2], `nblocks`, '1', dbmhi, dbmlo, '0']
    posix.execv(cwreserve, args)

pid, status = posix.waitpid(pid, 0)
if status:
    sys.stderr.write(sys.argv[0] + ': Cannot create DP, status: ' + 
		     `status` + '\n')
    sys.exit(1)

posix.execv('/bin/dd', ['dd', 'if=' + fname, 'bs=1024k', 'conv=sync,notrunc',
			'of=/dev/cw_dir/c_' + sys.argv[2]])

