/* 
 * Real-Time and Multimedia Systems Laboratory
 * Copyright (c) 2000 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */

#include <stdio.h>
#include <rk/rk.h>

void Usage(char *com)
{
    fprintf(stderr, "Usage: %s <resource set id> ...\n", com);
}

int main(int argc, char *argv[])
{
    int i;
    rk_resource_set_t *id;

    if (argc == 1) {
	Usage(argv[0]);
	exit(-1);
    }

    for (i = 1; i < argc; i++) {
	sscanf(argv[i], "%p", &id);
	printf("destroying resource_set id (%p)\n", id);
	if (rk_resource_set_destroy(id) != 0) {
	    fprintf(stderr, "%s: could not destroy rset %p\n",
		    argv[0], id);
	}
    }

    return 0;
}
