/* 
 * Real-Time and Multimedia Systems Laboratory
 * Copyright (c) 2000 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <unistd.h>
#include <rk/rk.h>
#include <rk/rk_error.h>

void Usage(char *com)
{
    fprintf(stderr,
	    "Usage: %s <resource set id in hex> <process id 1> <process id 2> ...\n",
	    com);
}

int main(int argc, char *argv[])
{
    int i;
    void *id;
    unsigned int pid;

    if (argc < 3) {
	Usage(argv[0]);
	exit(-1);
    }

    /* get resource id */
    sscanf(argv[1], "%p", &id);

    /* get process id and attach it */
    for (i = 2; i < argc; i++) {
	sscanf(argv[i], "%u", &pid);
	if (rk_resource_set_attach_process((rk_reserve_t) id, pid) !=
	    RK_SUCCESS) {
	    fprintf(stderr,
		    "Attaching process (with pid %d) to rset %p failed.\n",
		    pid, id);
	}
    }

    return 0;
}
