/*
 * vscale_thread.c: code to support energy-aware voltage-scaling 
 * algorithm on processor. This is a kernel thread to do the voltage
 * and frequency scaling outside the context switch which is necessary 
 * for BitsyX and IPAQ platform.
 *
 *
 * Real-time and Multimedia Systems Laboratory
 * Copyright (c) 2000 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */

///!!!!!! NOTE:::: IPAQ coding is not finished yet !!!

#ifdef ENERGY_AWARE
#if defined(__bitsyx__) || defined(__glencoe__)

#include <rk/rk_linux.h>
#include <rk/rk_error.h>
#include <rk/rk.h>
#include <rk/timespec.h>
#include <linux/time.h>
#include <linux/sched.h>
#include <asm/processor.h>
#include <asm/uaccess.h>
#include <asm/signal.h>
#include <asm/uaccess.h>
#include <asm/io.h>
#include <asm/types.h>
#include <asm/hardware.h>
#ifdef CONFIG_MEASURE
#include <linux/measure.h>
#endif				/* CONFIG_MEASURE */

//extern unsigned int cpufreq_get(int cpu);
//extern int cpufreq_set(unsigned int freq);


extern int rk_going_down; /* from timer.c */
extern int freqIndex; /* from cpu_energy_aware.c */
extern int freq_set[]; /* from cpu_energy_aware.c */
#ifdef __glencoe__
extern int l_freq[];
extern int n_freq[];
#endif
static int vscale_thread_body(void *unused);
wait_queue_head_t    vscale_wait;
static int request_pending = 0;
static int vscale_busy = 0;
static pid_t vscale_pid = 0;
int vscale_thread_init(void) {
   // start daemon
  // int kernel_thread( int (*fn) (void *), void *arg, unsigned long flags);
  init_waitqueue_head(&vscale_wait);
  vscale_pid = kernel_thread(vscale_thread_body, NULL, CLONE_FS | CLONE_FILES);
  printk("kernel_thread is done \n");
 
  return vscale_pid;
}

void vscale_thread_wakeup(void) {

  
  /* Send request_pending flag when a request comes in when 
   * (1) the vscale thread is not created    or
   * (2) the vscale_thread has not done with the voltage/frequency setting 
   *     of the previous request.
   */
  if ((!vscale_pid) || vscale_busy) {
    /* notify the thread about the new request pending */
    /* request_pending states the number of pending requests */
    request_pending++;
  } else {
    /* wake it up */
    wake_up(&vscale_wait);
  }
}

void vscale_thread_force_wakeup(void) {
  printk("waking up vscale thread\n");
  wake_up(&vscale_wait);
}


/* The daemon */
static int vscale_thread_body(void *unused) {
  unsigned int current_freq;
  static int setFreqIndex = 3;

  printk("vscale kernel thread is up and running \n");
  DECLARE_WAITQUEUE(wait, current);

  daemonize("rk_vscale");
#ifdef __glencoe__
#else
  reparent_to_init();
#endif
  //strcpy(current->comm,"rk_vscale");
  //sigfillset(&current->blocked);

  while (rk_going_down == 0) {
    add_wait_queue(&vscale_wait, &wait);
    
    // no request pending; put the thread to sleep
    if (!request_pending) {
      
      //set_current_state(TASK_INTERRUPTIBLE);
      set_task_state(current, TASK_INTERRUPTIBLE);
      
      vscale_busy = 0;
      // wait until the rk module send signal
      schedule_timeout(MAX_SCHEDULE_TIMEOUT);
    }
    
    vscale_busy = 1;
    request_pending = 0;  // just need to service the current request;                          
    current->state = TASK_RUNNING;

#if 0    
  while(!rk_going_down) {
    set_task_state(current, TASK_INTERRUPTIBLE);
    add_wait_queue(&vscale_wait, &wait);
    if(!request_pending)
      schedule();
    else
      __set_task_state(current, TASK_RUNNING);
    
    vscale_busy = 1;
    request_pending = 0;    
    remove_wait_queue(&vscale_wait, &wait);
#endif
    
    // set the voltage and frequency
    if (freqIndex != setFreqIndex) {
#ifdef __glencoe__
      pxa27x_set_cpufreq(l_freq[freqIndex], n_freq[freqIndex], 1, ((freq_set[freqIndex] > 208000)? 2 : 0), 1);
#else
      cpufreq_set(freq_set[freqIndex]);
#endif

      // just checking if the hw is really updated
      
#ifdef __glencoe__
      current_freq = cpufreq_get( smp_processor_id() );
#else
      current_freq = pxa27x_cpufreq_get( smp_processor_id() );
#endif
      if (current_freq != freq_set[freqIndex]) {
	  printk("Set new frequency error!!: current_freq = %d , ideal freq = %d \n", current_freq,  freq_set[freqIndex]);
      }
      setFreqIndex = freqIndex;
    }

    remove_wait_queue(&vscale_wait, &wait);
  }
    
  printk("rk_vscale thread exiting \n");
  //#ifdef __glencoe__
  //  pxa27x_set_cpufreq(l_freq[4], n_freq[4], 1, ((freq_set[4] > 208000)? 2 : 0), 1);
  //#endif
  return 0;
}


#endif /* __bitsyx__ */

#endif /* ENERGY_AWARE */
