/*
 * rk_isr.c: interrupt hooks
 *
 * Copyright (C) 2000 TimeSys Corporation
 *
 * This is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 * This file is derived from software distributed under the following terms:
 *
 * Real-Time and Multimedia Systems Laboratory
 * Copyright (c) 2006 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
#include <rk/rk_linux.h>
#include <rk/rk_error.h>
#include <rk/rk.h>
#include <linux/interrupt.h>
#include <linux/sched.h>
#include <asm/system.h>
#include <asm/io.h>

#include <asm/arch/irq.h>
#include <asm/irq.h>
#include <asm/hardware.h> 
#include <asm/arch/pxa-regs.h>

#if defined (__brh__) || defined (CONFIG_ARCH_BRH)
#include <linux/interrupt.h>
#include <asm/mach/irq.h>
extern  struct irqaction timer_irq;
extern int setup_arm_irq(int irq, struct irqaction * new);
#endif /* defined (__brh__) || (CONFIG_ARCH_BRH) */

/* same as brh */
#if defined (__bitsyx__) || defined (CONFIG_ARCH_ADSBITSYX)
#include <linux/interrupt.h>
#include <asm/mach/irq.h>
extern struct irqaction timer_irq;
extern int setup_arm_irq(int irq, struct irqaction * new);

extern int cpufreq_set(unsigned int);
#endif /* defined (__bitsyx__) || (CONFIG_ARCH_ADSBITSYX) */

#if defined (__glencoe__)
#include <linux/interrupt.h>
#include <asm/mach/irq.h>
extern struct irqaction pxa_timer_irq;
extern int setup_irq(unsigned int irq, struct irqaction * new);

extern int cpufreq_set(unsigned int);
#endif

#ifdef	DEBUG_RK  
#define	DEBUG_RK_ISR      
#ifdef	DEBUG_RK_ENFORCE
int debug_rk_enforce_flag;
#endif
#endif  /*DEBUG_RK */

#if defined(__i386__)
void (*rk_kernel_intr_in_hook) (void);  /* arch/i386/kernel/irq.h */            
void (*rk_restore_all_hook) (struct pt_regs regs);	/* arch/i386/kernel/entry.S */
void (*rk_ret_with_reschedule_hook) (struct pt_regs regs);



int rk_do_IRQ(struct pt_regs regs)
{
    extern int rk_timer_isr(void);
    unsigned int irq;
    int ret = 1;		/* by default for Linux */

    irq = regs.orig_eax & 0xff;
    rk_in_intr = 1;
    if (irq == 0) {
	/*
	 * return 1:    also for Linux 
	 * return 0:    only for RK
	 */
	ret = rk_timer_isr();
	if (!ret) {
	    outb(0x20, 0x20);	/* send EIO to PIC */
	}
    }
    rk_in_intr = 0;
    return ret;
}

// I changed the config __arm__ to __ipaq__ and __brh__ in order to 
// avoid the confusion between strongARM in IPAQ and XScale in BRH board  
//                      -Apple
#elif defined (__ipaq__)
/* arch/arm/kernel/entry-armv.S */
int     (*rk_kernel_intr_in_hook)(int irq, struct pt_regs * regs, unsigned int);
// Gaurav, you may need to port these hooks as well -Apple 
/* arch/arm/kernel/entry-common.S */
void (*rk_ret_with_reschedule_hook) (struct pt_regs regs);
/* arch/arm/kernel/entry-common.S */
void (*rk_restore_all_hook) (struct pt_regs regs);



extern volatile int rk_in_intr;

int rk_do_IRQ(int irq, struct pt_regs * regs)
{
    extern int rk_timer_isr(void);
    int ret = 1;		/* by default for Linux */
    cpu_tick_data_t now;
    
    rk_rdtsc(&now);
    rk_in_intr = 1;
    
    if (irq == 26) {
      rk_cpu_tick_at_last_jiffy = now;
      rk_in_intr = 0;
      return ret;
    }
      
    if (irq == 29) {
	/*
	 * return 1:    also for Linux 
	 * return 0:    only for RK
	 */
      OSSR = 0x8;
      ret = rk_timer_isr();

      if (!ret) {
	enable_irq(29);
      }
    }
    rk_in_intr = 0;

    return ret;
}


#elif defined (__brh__) || defined (CONFIG_ARCH_BRH)
/* arch/arm/kernel/entry-common.S */
void (*rk_ret_with_reschedule_hook) (struct pt_regs regs);
/* arch/arm/kernel/entry-common.S */
void (*rk_restore_all_hook) (struct pt_regs regs);

#elif defined (__bitsyx__) || defined (CONFIG_ARCH_ADSBITSYX)
/* arch/arm/kernel/entry-common.S */
void (*rk_ret_with_reschedule_hook) (struct pt_regs regs);
/* arch/arm/kernel/entry-common.S */
void (*rk_restore_all_hook) (struct pt_regs regs);

#elif defined (__glencoe__)
/* arch/arm/kernel/entry-common.S */
void (*rk_ret_with_reschedule_hook) (struct pt_regs regs);
/* arch/arm/kernel/entry-common.S */
void (*rk_restore_all_hook) (struct pt_regs regs);

#elif defined (__powerpc__)
int      (*rk_timer_interrupt_hook)(void);

int rk_timer_interrupt(void)
{
    extern int rk_timer_isr(void);
    int ret;

    /*
     * return 1:    also for Linux 
     * return 0:    only for RK
     */
    ret = rk_timer_isr();
    return ret;
}

#else 
#error I do not know how to handle interrupts on this architecture.
#endif


void cpu_reserve_sched_disable(struct rs_proc_list *rs_proc,
			       unsigned int arg);
void cpu_reserve_sched_blocking(struct rs_proc_list *rs_proc,
				unsigned int arg);

/*
 * For "rk_ret_with_reschedule_hook"
 */
asmlinkage void rk_ret_with_reschedule(struct pt_regs regs)
{

  /* do nothing */
#if 0
    rk_resource_set_t rs;
    rk_reserve_t cpu_rsv;
    void cpu_reserve_sched_timeshare_self(void);



    if ((rs = rk_current_resource_set)) {
	if (rk_resource_set_depleted(rs)) {
#ifdef DEBUG_BRH
	  printk("rk_ret_with_reschedule: brh is working \n");
#endif /* DEBUG_BRH */
#if	defined(DEBUG_RK_ISR) || defined(DEBUG_RK_ENFORCE)
	    printk("rk_ret_with_reschedule: depleted rs(0x%x)\n",
		   (int) rs);
#endif				/* DEBUG_RK_ENFORCE */
	    cpu_rsv = rs->rs_cpu;
	    switch (cpu_rsv->rsv_reserve_param.enf_mode) {
	    case RSV_SOFT:
	    case RSV_FIRM:
		cpu_reserve_sched_timeshare_self();
		break;
	    case RSV_HARD:
	    default:
		/* sleep when hard (or bad) enforcement */
#if 0
		{
		    struct pt_regs *regs =
			(struct pt_regs *) (init_task.tss.esp0 -
					    sizeof(struct pt_regs));

		    if (!(regs->eflags & 0x200)) {
			if (current == &init_task)
			    printk("Current is init\n");

			printk("Idle task has interrupts disabled!\n");
			printk("EAX 0x%x EBX 0x%x ECX 0x%x EDX 0x%x\n",
			       regs->orig_eax, regs->ebx, regs->ecx,
			       regs->edx);
			printk("ESP 0x%x EBP 0x%x ESI 0x%x EDI 0x%x\n",
			       regs->esp, regs->ebp, regs->esi, regs->edi);
			printk("CS 0x%x DS 0x%x EFLAGS 0x%x EIP 0x%x\n",
			       regs->xcs, regs->xds, regs->eflags,
			       regs->eip);


//                                              regs->eflags|=0x200;
		    }
		}
#endif


		rs_proc_list_apply(&cpu_rsv->rsv_rs->rs_proc_list,
				   cpu_reserve_sched_blocking, 0);

		current->need_resched = 1;
	    }
	}
    }
    return 0;
#endif
}



/*
 * For "rk_restore_all_hook"
 */
asmlinkage void rk_restore_all(struct pt_regs regs)
{
}
     

#if defined (__brh__)
static void rk_brh_timer_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
    extern int rk_timer_isr(void);
    if (rk_timer_isr()!=0) {
         /* this is the jiffy interrupt, let Linux do its job */
         do_timer(regs);
    }
    
}

static struct irqaction rk_brh_timer_irq = {
    name: "rk_timer",
    handler: rk_brh_timer_interrupt,
    flags: SA_INTERRUPT
};
#endif

#if defined (__bitsyx__)
static void rk_bitsyx_timer_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
    extern int rk_timer_isr(void);
//printk(".");
    if (rk_timer_isr()!=0) {
//printk("2");
         /* this is the jiffy interrupt, let Linux do its job */
         do_timer(regs);
//printk("\n");
    }

}

static struct irqaction rk_bitsyx_timer_irq = {
    name: "rk_timer",
    handler: rk_bitsyx_timer_interrupt,
    flags: SA_INTERRUPT
};
#endif

#if defined (__glencoe__)
static void rk_glencoe_timer_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
    extern int rk_timer_isr(void);
    if (rk_timer_isr()!=0) {
         /* this is the jiffy interrupt, let Linux do its job */
         do_timer(regs);
    }
}

static struct irqaction rk_glencoe_timer_irq = {
    name: "rk_timer",
    handler: rk_glencoe_timer_interrupt,
    flags: SA_INTERRUPT
};
#endif

/*
 *
 */
void rk_enable_isr(void)
{
    unsigned long flags;

    /*debug_rk_enforce_flag = 1; */

#if 0
    if (rk_kernel_intr_in_hook == rk_kernel_intr_in
	&& rk_restore_all_hook == rk_restore_all
	&& rk_ret_with_reschedule_hook == rk_ret_with_reschedule)
	return;
#endif

    {
	/* install hooks */
#ifdef __i386__
        rk_spin_lock(flags);
	rk_kernel_intr_in_hook = rk_kernel_intr_in;
	rk_restore_all_hook = rk_restore_all;
	rk_ret_with_reschedule_hook = rk_ret_with_reschedule;
	//Gaurav
#elif defined(__ipaq__)
        rk_spin_lock(flags);
	enable_irq(29);
	OIER |= 8;
	rk_kernel_intr_in_hook = rk_do_IRQ;
	rk_restore_all_hook = rk_restore_all;
	rk_ret_with_reschedule_hook = rk_ret_with_reschedule;
#elif defined(__brh__) || defined(CONFIG_ARCH_BRH)
#ifdef DEBUG_BRH       
	printk("rk_enable_isr: brh initializes the timer interrupt \n");
	printk("brh &timer_irq = %p \n", &timer_irq);
	printk("brh *dev_id = %p \n", timer_irq.dev_id);
	//	printk("brh value of dev_id = %d \n", *(struct irqaction *)(timer_irq.dev_id));
#endif /* DEBUG_BRH */
	// capture the timer interrupt for RK
	// replace the old timer handler to RK's	
	
	while (*BRH_TIMER0_VALUE < 0xff) {
	  /* do nothing */
	  // To avoid the interrupt happening while the handler is intalled
	}
	
	rk_spin_lock(flags);
	disable_irq(IRQ_BRH_TIMERA);
	free_irq(IRQ_BRH_TIMERA, timer_irq.dev_id);
	setup_arm_irq(IRQ_BRH_TIMERA, &rk_brh_timer_irq);
	enable_irq(IRQ_BRH_TIMERA);
	/* now wait for the first jiffy interrupt */
	rk_restore_all_hook = rk_restore_all;
	rk_ret_with_reschedule_hook = rk_ret_with_reschedule;

#elif defined(__bitsyx__) || defined(CONFIG_ARCH_ADSBITSYX)
#ifdef DEBUG_BITSYX
        printk("rk_enable_isr: bitsyx initializes the timer interrupt \n");
        printk("bitsyx &timer_irq = %p \n", &timer_irq);
        printk("bitsyx *dev_id = %p \n", timer_irq.dev_id);
#endif /* DEBUG_BITSYX */

        /* capture the timer interrupt for RK
           replace the old timer handler to RK's */

        while ( OSMR0 - OSCR < 0xff ) {
          /* do nothing */
          /* To avoid the interrupt happening while the handler is intalled */
        }

        rk_spin_lock(flags);
        disable_irq(IRQ_OST0);

        free_irq(IRQ_OST0, timer_irq.dev_id);
        setup_arm_irq(IRQ_OST0, &rk_bitsyx_timer_irq);

	/* Alice: setup_arm_irq enables the new irq automatically */
        //enable_irq(IRQ_OST0);
        //OSCR = 0;
        /* now wait for the first jiffy interrupt */
        rk_restore_all_hook = rk_restore_all;
        rk_ret_with_reschedule_hook = rk_ret_with_reschedule;
#elif defined(__glencoe__)
#ifdef DEBUG_GLENCOE
        printk("rk_enable_isr: glencoe initializes the timer interrupt \n");
        printk("glencoe &pxa_timer_irq = %p \n", &pxa_timer_irq);
        printk("glencoe *dev_id = %p \n", pxa_timer_irq.dev_id);
#endif /* DEBUG_GLENCOE */

        /* capture the timer interrupt for RK
           replace the old timer handler to RK's */

        while ( OSMR0 - OSCR < 0xff ) {
          /* do nothing */
          /* To avoid the interrupt happening while the handler is intalled */
        }

        rk_spin_lock(flags);
        disable_irq(IRQ_OST0);

        free_irq(IRQ_OST0, pxa_timer_irq.dev_id);
        setup_irq(IRQ_OST0, &rk_glencoe_timer_irq);
	//OIER |= OIER_E0;
	//OSCR = 0;

        /* now wait for the first jiffy interrupt */
        rk_restore_all_hook = rk_restore_all;
        rk_ret_with_reschedule_hook = rk_ret_with_reschedule;
#elif defined(__powerpc__)
	rk_spin_lock(flags);
	rk_timer_interrupt_hook = rk_timer_interrupt;
#else
#error I do not know the ISR hooks for this architecture.
#endif
    }
    rk_spin_unlock(flags);
#if defined(DEBUG_RK) || defined (DEBUG_BRH)
    printk("rk_enable_isr: rk kernel in/out hook enabled.\n");
#endif
}

void rk_disable_isr(void)
{
    unsigned long flags;
#if 0
    if (rk_kernel_intr_in_hook == (void *) 0
	&& rk_restore_all_hook == (void *) 0
	&& rk_ret_with_reschedule_hook == (void *) 0)
	return;
#endif
    /* This needs an interrupt, so the lock can't be held. */
    rk_release_hw_timer();

    rk_spin_lock(flags);
      {
	/* remove hooks */
#ifdef __i386__
	rk_kernel_intr_in_hook = NULL;
	rk_restore_all_hook = NULL;
	rk_ret_with_reschedule_hook = NULL;
	//Gaurav
#elif defined __ipaq__
	disable_irq(29);
	rk_kernel_intr_in_hook = NULL;
#elif defined __brh__
	// disable interrupt
	disable_irq(IRQ_BRH_TIMERB);
	free_irq(IRQ_BRH_TIMERB, (void *)0);
	// restore the linux timer handler
	disable_irq(IRQ_BRH_TIMERA);
	free_irq(IRQ_BRH_TIMERA, rk_brh_timer_irq.dev_id);
        setup_arm_irq(IRQ_BRH_TIMERA, &timer_irq);
	enable_irq(IRQ_BRH_TIMERA);
	rk_restore_all_hook = NULL;
	rk_ret_with_reschedule_hook = NULL;
#elif defined __bitsyx__
        // disable interrupt
        disable_irq(IRQ_OST1);
        free_irq(IRQ_OST1, (void *)0);
        // restore the linux timer handler
        disable_irq(IRQ_OST0);
        free_irq(IRQ_OST0, rk_bitsyx_timer_irq.dev_id);
        setup_arm_irq(IRQ_OST0, &timer_irq);
        /* Alice: setup_arm_irq enables the new irq automatically */
	//enable_irq(IRQ_OST0);
        rk_restore_all_hook = NULL;
        rk_ret_with_reschedule_hook = NULL;
#elif defined __glencoe__
        // disable interrupt
        disable_irq(IRQ_OST2);
        free_irq(IRQ_OST2, (void *)0);
        // restore the linux timer handler
        disable_irq(IRQ_OST0);
        free_irq(IRQ_OST0, rk_glencoe_timer_irq.dev_id);
        setup_irq(IRQ_OST0, &pxa_timer_irq);
	//enable_irq(IRQ_OST0);
	//OIER |= OIER_E0;
	//OSCR = 0;
        rk_restore_all_hook = NULL;
        rk_ret_with_reschedule_hook = NULL;
#elif defined(__powerpc__)
	rk_timer_interrupt_hook = NULL;
#else
#error I do not know the ISR hooks for this architecture.
#endif
    }
    rk_spin_unlock(flags);
#ifdef	DEBUG_RK
    printk("rk_disable_isr: rk kernel in/out hook diabled.\n");
#endif
}


#ifdef	DEBUG_RK_ENFORCE
asmlinkage void rk_ret_from_sys_call_msg(void)
{
    unsigned long flags;
    rk_spin_lock(flags);
    {
	printk("ret_from_sys_call! pid(%d) eflag(0x%x)\n",
	       (int) current->pid, (int) flags);
    }
    rk_spin_unlock(flags);
}

asmlinkage void rk_signal_return_msg(void)
{
    unsigned long flags;
    rk_spin_lock(flags);
    {
	printk("signal_return! eflag(0x%x)\n", (int) flags);
    }
    rk_spin_unlock(flags);
}

asmlinkage void rk_ret_from_intr_msg(void)
{
    unsigned long flags;
    rk_spin_lock(flags);
    {
	printk("ret_from_intr! pid(%d) eflag(0x%x)\n",
	       (int) current->pid, (int) flags);
    }
    rk_spin_unlock(flags);
}

asmlinkage void rk_reschedule_msg(void)
{
    unsigned long flags;
    rk_spin_lock(flags);
    {
	printk("reschedule! pid(%d) eflag(0x%x)\n",
	       (int) current->pid, (int) flags);
    }
    rk_spin_unlock(flags);
}

#endif

      
