
#include <time.h>
#include <rk/posix_timers.h>
#include <sys/time.h>
#include <linux/unistd.h>
#include <errno.h>

int clock_settime(clockid_t clock_id, const struct timespec *tp)
{
    struct timeval tv;
    if (clock_id != CLOCK_REALTIME || tp->tv_nsec < 0
	|| tp->tv_nsec >= 1000000000) {
	errno = EINVAL;
	return -1;
    }
    tv.tv_sec = tp->tv_sec;
    tv.tv_usec = tp->tv_nsec / 1000;
    return settimeofday(&tv, NULL);
}

int clock_gettime(clockid_t clock_id, struct timespec *tp)
{
    struct timeval tv;
    if (clock_id != CLOCK_REALTIME) {
	errno = EINVAL;
	return -1;
    }
    gettimeofday(&tv, NULL);
    tp->tv_sec = tv.tv_sec;
    tp->tv_nsec = tv.tv_usec * 1000;
    return 0;
}

int clock_getres(clockid_t clock_id, struct timespec *res)
{
    if (clock_id != CLOCK_REALTIME) {
	errno = EINVAL;
	return -1;
    }
    if (res) {
	res->tv_sec = 0;
	res->tv_nsec = 1000;
    }
    return 0;
}

_syscall3(int, timer_create,
	  clockid_t, clock_id, struct sigevent *, evp, timer_t *, timerid)

_syscall1(int, timer_delete, timer_t, timerid)
_syscall4(int, timer_settime,
	   timer_t, timerid,
	   int, flags,
	   const struct itimerspec *, value, struct itimerspec *, ovalue)

_syscall2(int, timer_gettime, timer_t, timerid, struct itimerspec *, value)
_syscall1(int, timer_getoverrun, timer_t, timerid)
