/* 
 * Real-Time and Multimedia Systems Laboratory
 * Copyright (c) 2000 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */

/* Test is the frequency is really changed  by Saowanee Saewong */

/*
 * This program just run a fixed loop and report the execution time of the program
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <wait.h>
#include <string.h>

#include <rk/rk.h>
#include <rk/rk_error.h>
#include <rk/posix_timers.h>
#include <rk/timespec.h>


#define ITER 200
int main(int argc, char *argv[])
{
  struct timespec begin, end;
  int i, j, k;
  unsigned long duration;

  clock_gettime(CLOCK_REALTIME, &begin);
  for (i = 0; i < ITER; i++) {
    /* do busy loop */
    k = i;
    for (j = 0; j < 1000000; j++) {
      k += i*j + (j + 3);
      k += 2* k;
      k += k + (3i * j);
    }
    printf("loop %d k = %d \n", i, k);
  }
  clock_gettime(CLOCK_REALTIME, &end);
  timespec_sub(end, begin);
  duration = end.tv_nsec / 1000000 + end.tv_sec * 1000;
  printf("duration = %lu ms\n", (unsigned long) duration); 
  return 0;
}
