/*
 * Copyright (C) 2000 TimeSys Corporation
 *
 * This is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <unistd.h>
#include <rk/rk.h>
#include <signal.h>

rk_resource_set_t rs;

void print_usage(char *cmdname)
{
    printf("usage: %s <resource set name>\n", cmdname);
}

int main(int argc, char *argv[])
{

    if (argc != 2) {
	print_usage(argv[0]);
    }

    /* create resource set */
    rs = rk_resource_set_create(argv[1]);
    printf("Resource_Set_Created 0x%x %d\n", (int) rs, (int) rs);
    return (int) rs;
}
