/*
 * Copyright (C) 2003-2004 Intel Corporation.
 * 
 * This software program is licensed subject to the GNU General Public License
 * (GPL).Version 2,June 1991, available at http://www.fsf.org/copyleft/gpl.html
 *
 */

#ifndef	__IPMC_H
#define	__IPMC_H

#ifdef __KERNEL__
#include <linux/ioctl.h>
#include <linux/miscdevice.h>
//#include <asm/xscale-pmu.h>
#endif

/* Use 'K' as magic number */
#define IPMC_IOC_MAGIC  'K'

/* To keep compitable with old cpufreqd user application.  */
#if 0
#define IPMC_IOCTL_GET 	_IOR(IPMC_IOC_MAGIC, 1, struct ipm_config) 
#define IPMC_IOCTL_SET  _IOW(IPMC_IOC_MAGIC, 2, struct ipm_config)

#endif
#define IPMC_IOCTL_GET_DPM_CONFIG  _IOR(IPMC_IOC_MAGIC, 3, struct ipm_config)
#define IPMC_IOCTL_SET_DPM_CONFIG  _IOW(IPMC_IOC_MAGIC, 4, struct ipm_config)

#define IPMC_IOCTL_GET_DVFM_CONFIG  _IOR(IPMC_IOC_MAGIC, 3, struct ipm_config)
#define IPMC_IOCTL_SET_DVFM_CONFIG  _IOW(IPMC_IOC_MAGIC, 4, struct ipm_config)

#define IPMC_IOCTL_GET_EVENT   _IOR(IPMC_IOC_MAGIC, 5, int)
#define IPMC_IOCTL_SET_EVENT   _IOW(IPMC_IOC_MAGIC, 6, int)

#define IPMC_IOCTL_RESET_UI_TIMER _IOW(IPMC_IOC_MAGIC, 8, int)

#define	IPMC_IOCTL_GET_SLEEPTIME  _IOR(IPMC_IOC_MAGIC, 9, int) 
#define	IPMC_IOCTL_SET_SLEEPTIME  _IOW(IPMC_IOC_MAGIC, 10, int) 

#define	IPMC_IOCTL_GET_WAKETIME  _IOR(IPMC_IOC_MAGIC, 11, int) 
#define	IPMC_IOCTL_SET_WAKETIME  _IOW(IPMC_IOC_MAGIC, 12, int) 

#define	IPMC_IOCTL_GET_UITIME	_IOR(IPMC_IOC_MAGIC, 13, int)
#define	IPMC_IOCTL_SET_UITIME	_IOW(IPMC_IOC_MAGIC, 14, int)

#define	IPMC_IOCTL_GET_SLEEPLEVEL _IOR(IPMC_IOC_MAGIC, 15, int)
#define	IPMC_IOCTL_SET_SLEEPLEVEL _IOW(IPMC_IOC_MAGIC, 16, int)

#define	IPMC_IOCTL_STARTPMU	 _IOW(IPMC_IOC_MAGIC, 17, int)
#define	IPMC_IOCTL_STOPPMU	_IOW(IPMC_IOC_MAGIC, 18, struct pmu_results)

#define	IPMC_IOCTL_CLEAR_EVENTLIST _IOW(IPMC_IOC_MAGIC, 20, int)

#define	IPMC_IOCTL_SET_WINDOWSIZE	_IOW(IPMC_IOC_MAGIC, 22, int)
#define NOVOLCHG    0
#define HIGHER      1
#define LOWER       2


#define MAX_IPME_NUM 20	/*	20 IPM event max */
/*      IPM events queue */

struct  ipm_config {
	/*  Below  items must be set to set configurations. */
	unsigned int    cpu_mode;
	unsigned int    l;  /* L */
	unsigned int	n2; /* 2N */
	unsigned int    core_vltg;    /*  in mV.  */
	unsigned int    turbo_mode;     /* =2 turbo, =1 half turbo */
	unsigned int    fast_bus_mode;
	unsigned int	mem_clk_conf;
	/*  Below items may need to get system DPM configurations. */
	unsigned int	core_freq;
	unsigned int    sys_bus_freq;
	unsigned int    mem_bus_freq;
	unsigned int    lcd_freq;
	unsigned int    enabled_device;
};

struct ipm_event {
	unsigned int type;	/*	What type of IPM events.	*/
	unsigned int kind;	/*	What kind, or sub-type of events.*/
//	void *infodata;		/*	events specific data.	*/
	unsigned int info;
};

#ifdef __KERNEL__
struct ipme_queue{
        int head;
        int tail;
        int len;
        struct ipm_event  ipmes[MAX_IPME_NUM];
        wait_queue_head_t waitq;
};
#endif

#define	IPM_EVENTS_TYPE(x)   ((x&0xFF000000)>>24)
#define	IPM_EVENTS_KIND(x)   ((x&0x00F00000)>>16)
#define	IPM_EVENTS_INFO(x)   (x&0xFF)

/*	IPM event types.	*/
#define	IPM_EVENT_DEVICE	0x1		/*	Device interrupt event.	*/
#define	IPM_EVENT_TIMER		0x2		/*	Device Timer timeout event.	*/

#define	IPM_EVENT_PROFILER	0x3		/*	Profiler events.	*/
#define	IPM_EVENT_SYSTEM_WAKEUP	0x4
#define	IPM_EVENT_CPU		0x5		/*	CPU utilization change  event.	*/

/*	IPM event kinds.	*/
#define	IPM_EVENT_POWER_LOW		0x1
#define	IPM_EVENT_POWER_FAULT	0x2
#define	IPM_EVENT_POWER_OK		0x3

#define	IPM_EVENT_DEVICE_TIMEOUT	0x4
#define	IPM_EVENT_DEVICE_INT	0x5

#define	IPM_EVENT_IDLE_PROFILER	0x0
#define	IPM_EVENT_PERF_PROFILER	0x1

#define	IPM_EVENT_RTCWAKEUP	0x0
#define	IPM_EVENT_UIWAKEUP	0x1

#define	IPM_EVENT_CPUVERYBUSY		0x0		/*	report CPU is very busy now.	*/
#define	IPM_EVENT_CPUBUSY		0x1		/*	report CPU is very busy now.	*/
#define	IPM_EVENT_CPUFREE		0x2		/*	report CPU is free now.	*/

/*	IPM event infos, not defined yet.	*/
#define	IPM_EVENT_NULLINFO	0x0
#define	IPM_WAKEUPBYRTC		0x1
#define	IPM_WAKEUPBYUI		0x2

/*	IPM functions	*/
#ifdef __KERNEL__
int 	ipmc_open(struct inode *inode, struct file *filep);
int 	ipmc_close( struct inode *inode, struct file *filep );
ssize_t ipmc_read(struct file *filep, char *buf, size_t count,loff_t *f_pos);
ssize_t ipmc_write(struct file *filep, const char *buf, size_t count,loff_t *f_pos);
int 	ipmc_ioctl (struct inode *inode, struct file *file, unsigned int cmd,unsigned long arg);
void 	set_ipm_conf(struct ipm_config *conf);
void 	ipm_event_notify(int  type, int kind, int info);
#endif


#endif
