/**
 * Prefix solicitation and advertisement
 *
 * Authors:
 * Jaakko Laine <jola@niksula.hut.fi>
 *
 * $Id: prefix.h,v 1.1 2002/03/22 18:34:46 ayer Exp $
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#ifndef _PREFIX_H
#define _PREFIX_H

#include <net/addrconf.h>

/**
 * mipv6_handle_pfx_icmpv6 - handle prefix advertisements and solicitations
 * @skb: sk_buff including the icmp6 message
 */
int mipv6_handle_pfx_icmpv6(struct sk_buff *skb);

/**
 * mipv6_pfx_cancel_send - cancel pending pfx_advs/sols to daddr
 * @daddr: destination address
 * @ifindex: pending items on this interface will be canceled
 *
 * if ifindex == -1, all items to daddr will be removed
 */
void mipv6_pfx_cancel_send(struct in6_addr *daddr, int ifindex);

/**
 * mipv6_pfx_add_ha - add a new HA to send prefix solicitations to
 * @daddr: address of HA
 * @saddr: our address to use as source address
 * @ifindex: interface index
 */
void mipv6_pfx_add_ha(struct in6_addr *daddr, struct in6_addr *saddr,
		      int ifindex);

void mipv6_pfxs_modified(struct prefix_info *pinfo, int ifindex);

int mipv6_initialize_pfx_icmpv6(void);
void mipv6_shutdown_pfx_icmpv6(void);

#endif
