/*
 *      Access control list
 *
 *      Authors:
 *      Juha Mynttinen            <jmynttin@cc.hut.fi>
 *
 *      $Id: access.h,v 1.6 2002/01/10 11:46:51 antti Exp $
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version
 *      2 of the License, or (at your option) any later version.
 *
 */

/*
 * List of Mobile Nodes (home addresses) this node may act as a Home Agent 
 * 
 * This module implements this mobile nodes access list 
 */

#ifndef _ACCESS_H
#define _ACCESS_H

#include <linux/in6.h>

#define DENY 0
#define ALLOW 1
#define FLUSH 2

struct mipv6_acl_record {
	struct in6_addr mask;
	unsigned char prefix_len;
	unsigned char action;
};

int mipv6_acl_add(struct mipv6_acl_record *rule);
int mipv6_is_allowed_home_addr(struct in6_addr *home_addr);

int mipv6_initialize_access(void);
int mipv6_destroy_access(void);

#endif /* _ACCESS_H */
