/*
 * linux/include/asm-arm/arch-sa1100/jornada56x.h
 *
 * Created 2002/3/6 by John Ankcorn <jca@alum.mit.edu>
 *
 * This file contains the hardware specific definitions for HP Jornada 56x
 *
 */

#ifndef __ASM_ARCH_JORNADA56X_H
#define __ASM_ARCH_JORNADA56X_H

#ifndef __ASM_ARCH_HARDWARE_H
#error "include <asm/hardware.h> instead"
#endif

#ifndef __ASSEMBLY__
#if 0
#define GPIO_JORNADA56X_KEYBOARD	GPIO_GPIO(0)
#define GPIO_JORNADA56X_MOUSE		GPIO_GPIO(9)

#define GPIO_JORNADA56X_KEYBOARD_IRQ	IRQ_GPIO0
#define GPIO_JORNADA56X_MOUSE_IRQ		IRQ_GPIO9
#endif

#define JORNADA56X_ASIC_BASE	0xf0000000 /* physical 0x40000000 */

#define PMU_REAL_BASE		JORNADA56X_ASIC_BASE
struct pmureg {
	long scr;			/* System Control Register - scr */
#define ASIC_SLEEP_En		0x0001
#define RCLK_En				0x0002 /* 1=Enable internal system reference clock 3.6864MHz */
#define INT_TEST			0x0004
#define PLL_En				0x0008	/*1=Enable PLL, 0=Bypass PLL */
#define PLL_Lock			0x0010	/*1=Locked, 0=Not locked */
#define SPI_FClk_en			0x0020
	long gpioafr;		/*GPIO Alternative Funciton Register - gpioafr */
#define GP_PWM1				0x02
#define GP_PWM2				0x04
#define GP_MW				0x08
#define GP_L3				0x10
#define GP_SPI				0x20
	long pwm1_ckdr;
	long pwm2_ckdr;
	long pcr;			/* Power Control register - pcr */
#define L3CLK_En			0x0001
#define PWM1CLK_En			0x0002
#define PWM2CLK_En			0x0004
#define MW_CLK_En			0x0010
#define I2S_CLK_En			0x0020
#define GPIO_INT_CLK_En		0x0040
#define UART_CLK_En			0x0080
#define SM_CLK_En			0x0100
#define MMC_CLK_En			0x0200
#define SPI_CLK_En			0x0400	
#define CF_CLK_En			0x0800	
#define MUX_CLK0			0x1000	
#define MUX_CLK1			0x2000	
	long srr;			/*Defines for srr */
#define L3_RST				0x0001
#define PWM_RST				0x0002
#define MW_RST				0x0008
#define I2S_RST				0x0010
#define AL_RST				0x0020
#define GPIO_RST			0x0040
#define INT_RST				0x0080
#define UART_RST			0x0100
#define SM_RST				0x0200
#define MMC_RST				0x0400
#define SPI_RST				0x0800
#define CF_RST				0x1000	
};

/* Interrupt Control Register Locations */
#define INTR_REAL_BASE		(JORNADA56X_ASIC_BASE+0x100)
struct intrreg {
	long int_en;
	long int_stat;
/* Interrupt Source for Group 1 - int_en / int_stat */
#define MMC_INT				0x0001
#define MMC_DETECT_INT		0x0002
#define MMC_REMOVE_INT		0x0004
#define L3_DONE_INT			0x0008
#define MW_TX_INT			0x0020
#define MW_RX_INT			0x0040
#define MW_TUR_INT			0x0080
#define MW_TOR_INT			0x0100
#define MW_ROR_INT			0x0200
#define ALARM_ACK_INT		0x0400
#define CF_REMOVE			0x0800
#define GPIO_B_INT			0x1000
#define GPIO_C_INT			0x2000
	long int_wk_en;
	long int_wk_pol;
	long int_test;
	long gpiob_re_en;
	long gpiob_fe_en;
	long gpiob_stat;
	long gpiob_wk_en;
	long gpiob_wk_pol;
	long gpioc_re_en;
	long gpioc_fe_en;
	long gpioc_stat;
	long gpioc_wk_en;
	long gpioc_wk_pol;
	long int_en2;
	long int_stat2;
/* Interrupt Source for Group 2 - int_en2 / int_stat2 */
#define UART_INT			0x0001
#define UART_RID_INT		0x0002
#define SM_DETECT_INT		0x0004
#define SM_REMOVE_INT		0x0008
#define SM_RFS_INT			0x0010
#define SM_TFS_INT			0x0020
#define SM_RID_INT			0x0040
#define SPI_TX_INT			0x0080	/*SPI_TX FIFO below threshold */
#define SPI_RX_INT			0x0100	/*SPI_RX FIFO above threshold */
#define SPI_TUR_INT			0x0200	/*SPI_TX FIFO under-run */
#define SPI_TOR_INT			0x0400	/*SPI_TX FIFO overrun */
#define SPI_ROR_INT			0x0800	/*SPI_RX FIFO overrun */
#define CF_INT				0x1000	/*CF IREQ Interrupt */
#define CF_INSERT			0x2000	/*CF Card Detect (insertion) */
#define CF_STSCHG			0x4000	/*CF Status change */
#define CF_WAIT_ERR			0x8000	/*CF wait time-out */
	long int_wk_en2;
	long int_wk_pol2;
	long int_test2;
};

/* CF Control Register Locations */
#define CF_REAL_BASE		(JORNADA56X_ASIC_BASE+0x280)
struct cfreg {
	long cfsr;			/* CF Status Register Bits */
#define CF_READY 			0x00000001
#define CF_VALID  			0x00000002
#define CF_VS1  			0x00000004
#define CF_VS2  			0x00000008
#define CF_WP  				0x00000010
#define CF_BVD1  			0x00000020
#define CF_BVD2  			0x00000040
#define CF_WAIT_TOUT  		0x00000080
#define CF_INSERT_LATCH		0x00000100
#define CF_REMOVE_LATCH		0x00000200
	long cfcr;			/* CF Status Register Bits */
#define CF_Reset			0x00000001
#define CF_FLT  			0x00000002
#define CF_PWAIT_En  		0x00000004
#define CF_Sleepstate  		0x00000008
	long cfwdcr;
};

/* PWM Control Register Locations */
#define PWM_REAL_BASE		(JORNADA56X_ASIC_BASE+0x400)
struct pwmreg {
	long pwm_ctrl;
	long pwm1_data;
	long pwm2_data;
};

/* Microwire Control Register Locations */
#define MICROWIRE_REAL_BASE	(JORNADA56X_ASIC_BASE+0x500)
struct microwirereg {
	long mwcr;			/* Microwire Control register - mwcr */
#define MW_EN			0x01	/* 1=Enable Microwire Controller */
#define DSS_16_BIT		0x06	/* Receive data width = 16 bit */
#define FIFO_RST		0x08	/* 1= Reset the FIFO */
#define MWCR_V_SCR		8		/*Serial Clock Rate bit offset */
	long mwdr;
	long mwfsr;			/* FIFO Status Register -mwfsr */
#define MW_TNE		0x00000001	/*1=TX FIFO not empty */
#define MW_TOR		0x00000002	/*1=TX FIFO overrun: try to write when FIFO is full */
#define MW_TFL		0x00000004	/*1=TX FIFO is full */
#define MW_RNE		0x00000008	/*1=RX FIFO not empty */
#define MW_BSY		0x00000010	/*1=Busy TX or RX */
#define MW_TFS		0x00000020	/*1=TX FIFO is <= TFL threshold request int */
#define MW_RFS		0x00000040	/*1=RX FIFO is => RFL threshold request int */
#define MW_ROR		0x00000080	/*1=RX FIFO overrun: FIFO full request int */
	long mwfer;
	long mwftr;
};

/*Defines for FIFO Control Register mwfcr */
#define MWFCR_V_TFT		0		/*Transmit FIFO threshold bit offset */
#define MWFCR_V_RFT		5		/*Receive FIFO threshold bit offset */

/* L3 Control Register Locations */
#define L3_REAL_BASE			(JORNADA56X_ASIC_BASE+0x600)

struct l3reg {
	long l3cfr;
	long l3car;
	long l3cdw;
	long l3cdr;
};
#define L3_EN					0x01
#define L3_READ_TRG				0x02
#define L3_ADDR_DONE			0x04
#define L3_DATA_DONE			0x08
#define L3_READ_DONE			0x10


/* HP ASIC GPIO Control Register Locations */
#define E_GPIO_REAL_BASE		(JORNADA56X_ASIC_BASE+0x700)
struct egpioreg {
	long dummy1;
	long gpbpsr;
	long gpcpsr;
	long dummy2;
	long gpbpcr;
	long gpcpcr;
	long dummy3;
	long gpbplr;
	long gpcplr;
	long dummy4;
	long gpbpdr;
	long gpcpdr;
	long dummy5;
	long gpbpsdr;
	long gpcpsdr;
	long dummy6;
	long gpbpslr;
	long gpcpslr;
	long dummy7;
	long gpbpfdr;
	long gpcpfdr;
	long dummy8;
	long gpbpflr;
	long gpcpflr;
	long gpdpsr;
	long gpdpcr;
	long gpdplr;
	long gpdpdr;
	long gpdpsdr;
	long gpdpslr;
	long gpdpfdr;
	long gpdpflr;
};

void jornada56x_mcu_init(void);
void jornada_contrast(int arg_contrast);
int jornada_brightness(int arg_brightness);
void jornada56x_battery(void);
int jornada56x_getkey(unsigned char *data, int size);
int jornada56x_gettouch(int *arg_x, int *arg_y);
#endif
#endif /* __ASM_ARCH_JORNADA56X_H */
