
/* 
 * Copyright (C) Jim Zajkowski <jamesez@umich.edu> (package maintainer)
 * Copyright (C) Chris Lahey <clahey@umich.edu> (original author)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/*
 * This code was taken from the Winnov Videum V4L2 driver, by Bill Dirks
 * <bdirks@pacbell.net>.  His notice follows,
 */


/*	
 *	Configuration EEPROM definition for Winnov Videum video 
 *	capture cards
 */
/*	Winnov Videum
 *	Video for Linux driver
 *
 *	This program is copyright 1998
 *	by Bill Dirks
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version
 *	2 of the License, or (at your option) any later version.
 *
 */


struct EEPROM
    {
	__u8	bSignature;	//  Keep this at first byte
#define EEPROM_SIG	0xBD
#define EEPROM_SIG_FAKE	0xFC  //present when Eeprom read from INI file...

	__u8	bBoardType;
	__u8	bMinorType;
	__u8	bSpecial;
	__u32	dwNumber;
	__u32	dwKey;
	__u32	dwHwFlags;
	__u32	dwSwFlags;

	__u8	filler[21];	//  Make structure 128 bytes

	char	szBoardRev[16];
	char	szProduct[30];
	char	szOemName[20];
	char	szSerial[20];

	__u8	bChecksum;
    };


/* bBoardType: */
#define		VERSION_LITE		0x80	/* BoardType MSB */

#define 	TYPE_MOVIEMAN		0
#define 	TYPE_ODIN2		1
#define		TYPE_SPAM2		2
#define 	TYPE_HOTSHOT		3
#define 	TYPE_VIDEUM		4
#define 	TYPE_ALARIS		5
#define 	TYPE_VIDEUM10		6
#define		TYPE_WIMPCAM1		7
#define		NBOARDTYPES		8

/* bMinorType: */
#define 	MINORTYPE_WINNOV	0	/* Winnov configuration on 8-pin */
#define 	MINORTYPE_PICTURETEL	1	/* PictureTel configuration on 8-pin */
#define 	MINORTYPE_HITACHI	2	/* Hitachi configuration on 8-pin */
#define 	MINORTYPE_V2WINNOV	3	/* Videum2 standard configuration */
#define 	MINORTYPE_AV		4	/* Videum10 AV */
#define 	MINORTYPE_VO		5	/* Videum10 VO */

/* bSpecial: */
#define		DISABLE_HWCOMPRESS	0x01	/* LSB */
#define		SPECIAL_PROMOTIONAL	0x02

/* dwHwFlags */
#define		HWFLAGS_CS4218    	0x00000001	/* using CS4218 audio codec */
#define		HWFLAGS_AUDXSEL		0x00000002	/* using AUDXSEL for audio xtal select */
#define		HWFLAGS_INV_VSYNC	0x00000004	/* If set we need to invert Vsync */
#define		HWFLAGS_VCLK_INV	0x00000008	/* Set VCLK_INV bit in CTL2 */

#define		HWFLAGS_WIMPDEVICE	0x00000FF0	/* Field for various WIMP-based devices */
#define		 HWFLAGS_PHILIPS	0x00000010	/* Philips WIMP camera */

#define		HWFLAGS_XTAL_8K_NOT_PRESENT	0x00001000	/* 24.5760 Mhz xtal not present */
#define		HWFLAGS_XTAL_11K_NOT_PRESENT	0x00002000	/* 22.5792 Mhz xtal not present */






