/*	Some additional code for the wnv.c Winnov Videum driver.
 *	This file contains the Huffman decompression and YCQ
 *	format decode.
 */


static __u32	g_huffcode[ 2  ][  10  ] =
{	       /*[Sign][Length]*/
	{ 0x00, 0x00, 0x00, 0x01, 0x03, 0x07, 0x0F, 0x1F, 0x3F, 0x07F, },
	{ 0x00, 0x00, 0x00, 0x05, 0x0B, 0x17, 0x2F, 0x5F, 0xBF, 0x17F, },
};
static char	g_huffdecode[ 2  ][  10  ] =
{	         /*[Sign][Length]*/
	{ 0, 0, 0,  1,  2,  3,  4,  5,  6,  7, },
	{ 0, 0, 0, -1, -2, -3, -4, -5, -6, -7, },
};


//  Fill in decode and length, 9-bit-indexed Huffman decode tables.
//  These tables are used to decode a single Huffman code.
//
static void
translate_filldehuff9lut(struct lookup_dehuff	*lut,
			 __u32			depth)/* 4,5,6,7 */
{
	__u32	len;
	__u32	sign;
	__u32	i;
	__u32	step;
	__u32	dhshift;
	__u32	decode;

	dhshift = 8 - depth;
	for (len = 1; len < 10; ++len)
	{
		if (len == 2)
			continue;
		for (sign = 0; sign < 2; ++sign)
		{
			if (len == 1 && sign == 1)
				continue;
			decode = g_huffdecode[sign][len] << dhshift;
			step = 1 << len;
			for (i = g_huffcode[sign][len]; 
			     i < sizeof(lut->decode1); i += step)
			{
				lut->decode1[i] = (__u8)decode;
				lut->length1[i] = (__u8)len;
			}
		}
	}
}

//  Fill in decode4, length4 and dcase, 12-bit-indexed Huffman decode tables.
//  These tables are used to decode four Huffman codes simultaneously.
//
static void
translate_filldehuff12lut(struct lookup_dehuff	*lut,
			  __u32			depth)/* 4,5,6,7 */
{
	__u32	lYa, lU, lYb, lV;
	__u32	sYa, sU, sYb, sV;
	__u32	i;
	__u32	step;
	__u32	ncase;
	__u32	dhshift;
	__u32	decode4;
	__u32	t1, t2, t3, t4;
	__u32	len;

	dhshift = 8 - depth;
	memset(lut->dcase, 0, sizeof(lut->dcase));

	for (lYa = 1; lYa < 10; ++lYa)
	 for (lU  = 1; lU  < 10; ++lU)
	  for (lYb = 1; lYb < 10; ++lYb)
	   for (lV  = 1; lV  < 10; ++lV)
	    {
		if (lYa + lU + lYb + lV > 12 ||
		    lYa == 2 || lU == 2 || lYb == 2 || lV == 2)
			continue;
		for (sYa = 0; sYa < 2; ++sYa)
		 for (sU  = 0; sU  < 2; ++sU)
		  for (sYb = 0; sYb < 2; ++sYb)
		   for (sV  = 0; sV  < 2; ++sV)
		    {
			if (lYa == 1 && lU == 1 && lYb == 1 && lV == 1)
				ncase = 1;
			else if (lU == 1 && lYb == 1 && lV == 1)
				ncase = 2;
			else if (lYa == 1 && lU == 1 && lV == 1)
				ncase = 3;
			else if (lU == 1 && lV == 1)
				ncase = 4;
			else
				ncase = 5;
//ncase = 0;
			t1 = (g_huffdecode[sYa][lYa] << dhshift) & 0xFF;
			t2 = (g_huffdecode[sU ][lU ] << dhshift) & 0xFF;
			t3 = (g_huffdecode[sYb][lYb] << dhshift) & 0xFF;
			t4 = (g_huffdecode[sV ][lV ] << dhshift) & 0xFF;

			/*  YUYV output byte order  */
			t2 <<= 8;
			t3 <<= 16;
			t4 <<= 24;

			i = (g_huffcode[sV ][lV ] << (lYb + lU + lYa)) +
			    (g_huffcode[sYb][lYb] << (lU + lYa)) +
			    (g_huffcode[sU ][lU ] << (lYa)) +
			    (g_huffcode[sYa][lYa]);
			decode4	= t4 + t3 + t2 + t1;
			len = lYa + lU + lYb + lV;
			step = 1 << len;
			for (; i < sizeof(lut->length4); i += step)
			{
				lut->decode4[i] = decode4;
				lut->length4[i] = (__u8)len;
				lut->dcase[i] = (__u8)ncase;
			}
		    }
	    }	
}


static int
translate_make_dehuff_lut(struct translation *xlat)
{
	struct lookup_dehuff	*lut;
	int			i;

	if (xlat->lut[0].type == LUT_DEHUFF4)
		return 1;

	for (i = 0; i < 4; ++i)
	{
		if (xlat->lut[i].table.base)
			vfree(xlat->lut[i].table.base);
		xlat->lut[i].table.base =
			vmalloc(sizeof(struct lookup_dehuff));
		if (xlat->lut[i].table.base == NULL)
		{
			err_msg("vmalloc() failed in make_dehuff_lut\n");
			return 0;
		}
		xlat->lut[i].type = LUT_DEHUFF4 + i;
		lut = xlat->lut[i].table.dehuff;
	
		//  9-bit-indexed Huffman decode tables
		translate_filldehuff9lut(lut, i + 4);
		//  12-bit-indexed Huffman decode tables
		translate_filldehuff12lut(lut, i + 4);
	}
	return 1;
}

#if 1

/////////////////////////////////////////////////////////////////////////////
// Copyright (c) Winnov L.P., 1998.  All rights reserved.
// Huffman2.c
// Author : Marcin Buczek
/////////////////////////////////////////////////////////////////////////////
// Modified by Bill Dirks


#define reload {ValidBits|=((u32)(*((__u16*)lpNext))<<ValidBitsLeft);\
	ValidBitsLeft+=16;lpNext+=2;}


//  Delta-Huffman decompression procedure
static __u32
translate_dh_yuyv(struct translation *xlat)
{
	__u8			*lpOut		= xlat->out;
	__u8			*lpIn		= xlat->in;
	__u32			bIn		= 0;
	__u32			dwWidth		= xlat->width;
	__u32			dwHeight	= xlat->height;
	long			lNextLine	= xlat->width * 2;
	struct lookup_dehuff	*lut;
	__u32			dwBitDepth	= xlat->ilut + 4;
	__u32			j;
	__u8			MaxBits		= (__u8)dwBitDepth + 8;
	__u8			Scale		= 8 - (__u8)dwBitDepth;
	__u8			ValidBitsLeft	= 32 - (__u8)bIn;
	__u8*			lpNext		= (__u8*)lpIn;
	__u32			ValidBits	= (*((__u32 *)lpNext)) >> bIn;
	__u32			Tmp;
	__u8			*ptmp8;
	__u32			PreviousDual	= 0;

	lut = xlat->lut[xlat->ilut].table.dehuff;
	lpNext += 4;
	lNextLine -= 2*dwWidth;

	while (dwHeight > 0)
	{
		j = dwWidth >> 1;

		while (j > 0)
		{
			Tmp = ValidBits & 0xFFF;
			switch (lut->dcase[Tmp])
			{
			
			//General case
			//Decode four Huffman/ABS codes into Ya U Yb V.
			case(0):
				*((__u32*)lpOut) = PreviousDual;

				// Ya
				if ((ValidBits & 0xFF) == 0xFF)
				{//  Absolute code
					ValidBits >>= 8;
					lpOut[0] = (__u8)((ValidBits & 0xFF) 
							  << Scale);
					ValidBits >>= dwBitDepth;
					ValidBitsLeft -= MaxBits;
					if (ValidBitsLeft < 16) reload;
					lpOut[2] = lpOut[0];
				}
				else
				{//  Delta code
					lpOut[2] += lut->decode1
						[ValidBits & 0x1FF];
					ValidBitsLeft -= lut->length1
						[ValidBits & 0x1FF];
					ValidBits >>= lut->length1
						[ValidBits & 0x1FF];
					if (ValidBitsLeft < 16) reload;
					lpOut[0] = lpOut[2];
				}

				//Cb
				if ((ValidBits & 0xFF) == 0xFF)
				{//  Absolute code
					ValidBits >>= 8;
					lpOut[1] = (__u8)((ValidBits & 0xFF) 
							  << Scale);
					ValidBits >>= dwBitDepth;
					ValidBitsLeft -= MaxBits;
					if (ValidBitsLeft < 16) reload;
				}
				else
				{//  Delta code
					lpOut[1] += lut->decode1
						[ValidBits & 0x1FF];
					ValidBitsLeft -= lut->length1
						[ValidBits & 0x1FF];
					ValidBits >>= lut->length1
						[ValidBits & 0x1FF];
					if (ValidBitsLeft < 16) reload;
				}

				//Yb
				if ((ValidBits & 0xFF) == 0xFF)
				{//  Absolute code
					ValidBits >>= 8;
					lpOut[2] = (__u8)((ValidBits & 0xFF) 
							  << Scale);
					ValidBits >>= dwBitDepth;
					ValidBitsLeft -= MaxBits;
					if (ValidBitsLeft < 16) reload;
				}
				else
				{//  Delta code
					lpOut[2] = lpOut[0] + lut->decode1
						[ValidBits & 0x1FF];
					ValidBitsLeft -= lut->length1
						[ValidBits & 0x1FF];
					ValidBits >>= lut->length1
						[ValidBits & 0x1FF];
					if (ValidBitsLeft < 16) reload;
				}

				//Cr
				if ((ValidBits & 0xFF) == 0xFF)
				{//  Absolute code
					ValidBits >>= 8;
					lpOut[3] = (__u8)((ValidBits & 0xFF) 
							  << Scale);
					ValidBits >>= dwBitDepth;
					ValidBitsLeft -= MaxBits;
					if (ValidBitsLeft < 16) reload;
				}
				else
				{//  Delta code
					lpOut[3] += lut->decode1
						[ValidBits & 0x1FF];
					ValidBitsLeft -= lut->length1
						[ValidBits & 0x1FF];
					ValidBits >>= lut->length1
						[ValidBits & 0x1FF];
					if (ValidBitsLeft < 16) reload;
				}

				PreviousDual = *((__u32*)lpOut);
				break;
			
			//Next four codes are <0><0><0><0>
			//Ya = last Yb.
			//Note: This is the second most common case (after 5)
			case(1):
				*((__u32*)lpOut) = PreviousDual;
				lpOut[0] = lpOut[2];
				PreviousDual = *((__u32*)lpOut);

				ValidBits >>= 4;
				ValidBitsLeft -= 4;
				if (ValidBitsLeft < 16) reload;
				break;
			
			//Next four codes are <Delta-Ya><0><Delta-Yb><0>  
			//Decode Ya and Yb.
			case(2):
			case(3):
			case(4):
				*((__u32*)lpOut) = PreviousDual;
				ptmp8 = (__u8 *)&lut->decode4[Tmp];
				lpOut[2] += ptmp8[0];
				lpOut[0] = lpOut[2];
				lpOut[2] += ptmp8[2];
				PreviousDual = *((__u32*)lpOut);
				ValidBits >>= lut->length4[Tmp];
				ValidBitsLeft -= lut->length4[Tmp];
				if (ValidBitsLeft < 16) reload;
				break;
			
			//Next four codes are all deltas
			//Decode 4 Huffman codes simultaneously to Ya U Yb V.
			//Note: This is the most common case!
			case(5):	
				*((__u32*)lpOut) = PreviousDual;
				ptmp8 = (__u8 *)&lut->decode4[Tmp];
				lpOut[3] += ptmp8[3];
				lpOut[2] += ptmp8[0];
				lpOut[1] += ptmp8[1];
				lpOut[0] = lpOut[2];
				lpOut[2] += ptmp8[2];
				PreviousDual = *((__u32*)lpOut);
				ValidBits >>= lut->length4[Tmp];
				ValidBitsLeft -= lut->length4[Tmp];
				if (ValidBitsLeft < 16) reload;
				break;
			}
			lpOut += 4;
			j--;
		}
		dwHeight--;
		lpOut += lNextLine;
	}
	return (((__u32)lpNext - (__u32)lpIn) << 3) - bIn - ValidBitsLeft;
}

#endif


/*	Because compression doesn't guarantee that the compressed image
 *	will fit in SRAM (it is likely to) we have a worst case alternate
 *	plan. When the compressed size is too big we use YCQ at one half
 *	the normal vertical resolution. This results in a guaranteed 4
 *	bits per pixel. This routine converts a half-vertical-res YCQ 
 *	image to a normal size YUYV.
 */
static __u32
translate_ycq_yuyv(struct translation *xlat)
{
	__u32	*src, *dst;
	__u32	uv, quad;
	int	row, i;

	src = (__u32 *)xlat->in;
	dst = (__u32 *)xlat->out;
	for (row = xlat->height >> 1; row; --row)
	{
		for (i = xlat->width >> 2; i; --i)
		{
			quad = *src++;
			uv     =  ((quad & 0x0000FC00) << 16)
				| ((quad & 0xFC000000) >> 16);
			dst[0] =  ((quad & 0x0000001F) << 3)
				| ((quad & 0x000003E0) << 14)
				| uv;
			dst[1] =  ((quad & 0x001F0000) >> 13)
				| ((quad & 0x03E00000) >> 2)
				| uv;
			dst += 2;
		}

		/*  Now duplicate the row (an interpolate would be better) */
		memcpy(dst, (char *)dst - xlat->width * 2, xlat->width * 2);
		(char *)dst += xlat->width*2;
	}
	return 1;
}


static int
compression_adjust(struct videum_device	*dev,
		   int			last_vdf,
		   int			lastsize)
{
	int	next_vdf	= last_vdf;

	if (lastsize < 0)
		return last_vdf;/*  error, but not a compression error */

	if (last_vdf == WAVI_VDF_YCH)
	{/*	Not compressing  */
		return WAVI_VDF_YCH;
	}

	if (last_vdf == WAVI_VDF_YCQ)
	{
		next_vdf = WAVI_VDF_DH4;
	}
	else if (lastsize <= 0)
	{/*	Capture error: Lower the quality  */
		switch (dev->capture_vdf)
		{
		case WAVI_VDF_DH4:
			/*  Error on DH4, go to worstcase  */
			next_vdf = WAVI_VDF_YCQ;
			break;
		case WAVI_VDF_DH5:
			next_vdf = WAVI_VDF_DH4;
			break;
		case WAVI_VDF_DH6:
			next_vdf = WAVI_VDF_DH5;
			break;
		case WAVI_VDF_DH7:
			next_vdf = WAVI_VDF_DH6;
			break;
		}
	}
	else if (lastsize < dev->capture_low_water)
	{/*	Raise the quality  */
		switch (dev->capture_vdf)
		{
		case WAVI_VDF_DH4:
			next_vdf = WAVI_VDF_DH5;
			break;
		case WAVI_VDF_DH5:
			next_vdf = WAVI_VDF_DH6;
			break;
		case WAVI_VDF_DH6:
			next_vdf = WAVI_VDF_DH7;
			break;
		case WAVI_VDF_DH7:
			/*  Can't go any higher */
			break;
		}
	}
	else if (lastsize >= dev->capture_high_water)
	{/*	Lower the quality  */
		switch (dev->capture_vdf)
		{
		case WAVI_VDF_DH4:
			/*  Don't go to worst case unless capture error */
			break;
		case WAVI_VDF_DH5:
			next_vdf = WAVI_VDF_DH4;
			break;
		case WAVI_VDF_DH6:
			next_vdf = WAVI_VDF_DH5;
			break;
		case WAVI_VDF_DH7:
			next_vdf = WAVI_VDF_DH6;
			break;
		}
	}
//if (last_vdf != next_vdf) debug_msg("New VDF %d\n", next_vdf>>5);
	return next_vdf;
}
