/* 
 * Copyright (C) Jim Zajkowski <jamesez@umich.edu> (package maintainer)
 * Copyright (C) Chris Lahey <clahey@umich.edu> (original author)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/*
 * This code was taken from the Winnov Videum V4L2 driver, by Bill Dirks
 * <bdirks@pacbell.net>.  
 */


/* MediaPlug interface */

#define LCMD_DOG_BIT            0x0001
#define LCMD_POWER_BIT          0x0002
#define LCMD_CABLE_CLOCK_BIT    0x0004
#define LCMD_IC_CLOCK_BIT       0x0008
#define LCMD_POW_NEED_BIT       0x0020
#define LCMD_OBSOLETE_BIT       0x0040
#define LCMD_CABLE_CONNECT_BIT  0x0080
#define LCMD_TO_0_BIT           0x4000
#define LCMD_TO_1_BIT           0x8000

#define CMD_WATCHDOG_BIT        0x4000
#define CMD_DIRTY_BIT           0x8000

#define CMD_RST                 0
#define CMD_END_STREAM          1
#define CMD_WRITE_REG           2
#define CMD_READ_REG            3
#define CMD_WRITE_STREAM        4
#define CMD_NOP_1               5
#define CMD_NOP_2               6
#define CMD_READ_STREAM         7

#define MP_BUILD_CMD( reg, cmd ) (((reg) << 3) + (cmd))

/* Sends a command along the CMD line. */
/* 
static __u16
mp_cmd_read( videum_device *videum )
{
  return videum->mem_start[0];
}
*/
/* Sends a command along the LCMD line. */
static __u16
mp_lcmd_read( videum_device *videum )
{
  return videum->mem_start[1];
}

/* Sends a data __u16 to the camera. */
static __u16
mp_data_read( videum_device *videum )
{
  return videum->data[0];
}

/* Reads the CMD line. */
static void
mp_cmd_write( videum_device *videum, __u16 value )
{
  videum->mem_start[0] = value;
}

/* Reads the LCMD line. */
static void
mp_lcmd_write( videum_device *videum, __u16 value )
{
  videum->mem_start[1] = value;
}

/* Reads the DATA line. */
static void
mp_data_write( videum_device *videum, __u16 value )
{
  videum->data[0] = value;
}

/* Sets the given bits on the LCMD line. */
static void
mp_lcmd_set_bits( videum_device *videum, __u16 bits )
{
  __u16 value = mp_lcmd_read( videum );
  value |= bits;
  mp_lcmd_write( videum, value );
}

/* Unsets the given bits on the LCMD line. */
static void
mp_lcmd_unset_bits( videum_device *videum, __u16 bits )
{
  __u16 value = mp_lcmd_read( videum );
  value &= ~bits;
  mp_lcmd_write( videum, value );
}

/* Tests if any of the given bits are on in the LCMD line. */
static int
mp_lcmd_test_any_bits( videum_device *videum, __u16 bits )
{
  __u16 value = mp_lcmd_read( videum );
  return (value & bits) != 0;
}

/* Tests is all of the given bits are on in the LCMD line. */
/* static int
mp_lcmd_test_all_bits( videum_device *videum, __u16 bits )
{
  __u16 value = mp_lcmd_read( videum );
  return (value & bits) == bits;
}
*/

/** Higher level functions. **/

/* Reads a register from the camera. */
static int
mp_register_read( videum_device *videum, int reg )
{
  mp_cmd_write( videum, MP_BUILD_CMD( reg, CMD_READ_REG ) );
  return mp_data_read( videum );
}

/* Writes a register in the camera. */
static void
mp_register_write( videum_device *videum, int reg, int value )
{
  mp_cmd_write( videum, MP_BUILD_CMD( reg, CMD_WRITE_REG ) );
  mp_data_write( videum, value );
}

int
mp_register_set_bits( videum_device *videum, int reg, int bits )
{
  int value = mp_register_read( videum, reg );
  value |= bits;
  mp_register_write( videum, reg, value );
  return value;
}

int
mp_register_unset_bits( videum_device *videum, int reg, int bits )
{
  int value = mp_register_read( videum, reg );
  value &= ~bits;
  mp_register_write( videum, reg, value );
  return value;
}

/* Reads a block from the camera.  Not sure if this is correct. */
void
mp_stream_read( videum_device *videum, int sram_add,
		__u16 *buffer, int length )
{
  int blocks = length;
  mp_cmd_write( videum, MP_BUILD_CMD( sram_add, CMD_READ_STREAM ) );
  for( ; blocks > 0; blocks -- )
    {
      *buffer = mp_data_read( videum );
      buffer ++;
    }
  mp_cmd_write( videum, CMD_END_STREAM );
}

/* Writes a block to the camera.  Not sure if this is correct. */
void
mp_stream_write( videum_device *videum, int sram_add, 
		 __u16 *buffer, int length )
{
  int blocks = length;
  mp_cmd_write( videum, MP_BUILD_CMD( sram_add, CMD_WRITE_STREAM ) );
  for( ; blocks > 0; blocks -- )
    {
      mp_data_write( videum, *buffer );
      buffer ++;
    }
  mp_cmd_write( videum, CMD_END_STREAM );
}

/* Tests if the cable is attached. */
static int
mp_cable_attached( videum_device *videum )
{
  return ! mp_lcmd_test_any_bits( videum, LCMD_CABLE_CONNECT_BIT );
}

/* Turns the light on. */
static void
mp_light_on( videum_device *videum )
{	
  mp_register_write( videum, WAVI_MMA, WAVI_AUDXSEL_INT97 | WAVI_CS4218BIT );
}

static void
mp_power_on( videum_device *videum )
{
  mp_lcmd_set_bits( videum, LCMD_POWER_BIT | LCMD_CABLE_CLOCK_BIT | LCMD_IC_CLOCK_BIT );
  wnv_sleep( 100 );
}

static void
mp_power_off( videum_device *videum )
{
  mp_lcmd_unset_bits( videum, LCMD_POWER_BIT | LCMD_CABLE_CLOCK_BIT | LCMD_IC_CLOCK_BIT );
}

/*
static void
mp_light_blink( videum_device *videum )
{
  mp_power_on( videum );
  wnv_sleep( 250 );
  mp_light_on( videum );
  wnv_sleep( 500 );
  mp_power_off( videum );
}
*/

static void
mp_reset_camera( videum_device *videum )
{
  mp_cmd_write( videum, CMD_RST );
  wnv_sleep( 350 );
}
