/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.BasicMapEntry;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class HashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    static final int DEFAULT_CAPACITY = 11;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final long serialVersionUID = 362498820763181265L;
    private int threshold;
    final float loadFactor;
    transient HashEntry[] buckets;
    transient int modCount;
    transient int size;
    private transient Set entries;

    public HashMap() {
        this(11, 0.75f);
    }

    public HashMap(Map m) {
        this(Math.max(m.size() * 2, 11), 0.75f);
        this.putAllInternal(m);
    }

    public HashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (!(loadFactor > 0.0f)) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.buckets = new HashEntry[initialCapacity];
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object get(Object key) {
        int idx = this.hash(key);
        HashEntry e = this.buckets[idx];
        while (e != null) {
            if (AbstractMap.equals(key, e.key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public boolean containsKey(Object key) {
        int idx = this.hash(key);
        HashEntry e = this.buckets[idx];
        while (e != null) {
            if (AbstractMap.equals(key, e.key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object put(Object key, Object value) {
        int idx = this.hash(key);
        HashEntry e = this.buckets[idx];
        while (e != null) {
            if (AbstractMap.equals(key, e.key)) {
                return e.setValue(value);
            }
            e = e.next;
        }
        ++this.modCount;
        if (++this.size > this.threshold) {
            this.rehash();
            idx = this.hash(key);
        }
        this.addEntry(key, value, idx, true);
        return null;
    }

    public void putAll(Map m) {
        Iterator itr = m.entrySet().iterator();
        for (int msize = m.size(); msize > 0; --msize) {
            Map.Entry e = (Map.Entry)itr.next();
            if (e instanceof BasicMapEntry) {
                BasicMapEntry entry = (BasicMapEntry)e;
                this.put(entry.key, entry.value);
                continue;
            }
            this.put(e.getKey(), e.getValue());
        }
    }

    public Object remove(Object key) {
        int idx = this.hash(key);
        HashEntry e = this.buckets[idx];
        HashEntry last = null;
        while (e != null) {
            if (AbstractMap.equals(key, e.key)) {
                ++this.modCount;
                if (last == null) {
                    this.buckets[idx] = e.next;
                } else {
                    last.next = e.next;
                }
                --this.size;
                return e.cleanup();
            }
            last = e;
            e = e.next;
        }
        return null;
    }

    public void clear() {
        if (this.size != 0) {
            ++this.modCount;
            Arrays.fill(this.buckets, null);
            this.size = 0;
        }
    }

    public boolean containsValue(Object value) {
        for (int i = this.buckets.length - 1; i >= 0; --i) {
            HashEntry e = this.buckets[i];
            while (e != null) {
                if (AbstractMap.equals(value, e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public Object clone() {
        HashMap copy = null;
        try {
            copy = (HashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        copy.buckets = new HashEntry[this.buckets.length];
        copy.putAllInternal(this);
        copy.entries = null;
        return copy;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet(this){
                private /* synthetic */ HashMap this$0;
                {
                    this.this$0 = this$0;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return this.this$0.iterator(0);
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object o) {
                    return this.this$0.containsKey(o);
                }

                public boolean remove(Object o) {
                    int oldsize = this.this$0.size;
                    this.this$0.remove(o);
                    return oldsize != this.this$0.size;
                }
            };
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(this){
                private /* synthetic */ HashMap this$0;
                {
                    this.this$0 = this$0;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return this.this$0.iterator(1);
                }

                public void clear() {
                    this.this$0.clear();
                }
            };
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet(this){
                private /* synthetic */ HashMap this$0;
                {
                    this.this$0 = this$0;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return this.this$0.iterator(2);
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object o) {
                    return this.this$0.getEntry(o) != null;
                }

                public boolean remove(Object o) {
                    HashEntry e = this.this$0.getEntry(o);
                    if (e != null) {
                        this.this$0.remove(e.key);
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.entries;
    }

    void addEntry(Object key, Object value, int idx, boolean callRemove) {
        HashEntry e = new HashEntry(key, value);
        e.next = this.buckets[idx];
        this.buckets[idx] = e;
    }

    private HashEntry getEntry(Object o) {
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Map.Entry me = (Map.Entry)o;
        int idx = this.hash(me.getKey());
        HashEntry e = this.buckets[idx];
        while (e != null) {
            if (e.equals(me)) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    final int hash(Object key) {
        if (key == null) {
            return 0;
        }
        return Math.abs(key.hashCode() % this.buckets.length);
    }

    Iterator iterator(int type) {
        return new HashIterator(this, type);
    }

    void putAllInternal(Map m) {
        int msize;
        Iterator itr = m.entrySet().iterator();
        this.size = msize = m.size();
        while (msize > 0) {
            Map.Entry e = (Map.Entry)itr.next();
            Object key = e.getKey();
            int idx = this.hash(key);
            this.addEntry(key, e.getValue(), idx, false);
            --msize;
        }
    }

    private void rehash() {
        HashEntry[] oldBuckets = this.buckets;
        int newcapacity = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)newcapacity * this.loadFactor);
        this.buckets = new HashEntry[newcapacity];
        for (int i = oldBuckets.length - 1; i >= 0; --i) {
            HashEntry e = oldBuckets[i];
            while (e != null) {
                int idx = this.hash(e.key);
                HashEntry dest = this.buckets[idx];
                if (dest != null) {
                    while (dest.next != null) {
                        dest = dest.next;
                    }
                    dest.next = e;
                } else {
                    this.buckets[idx] = e;
                }
                HashEntry next = e.next;
                e.next = null;
                e = next;
            }
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.buckets.length);
        s.writeInt(this.size);
        Iterator it = this.iterator(2);
        while (it.hasNext()) {
            HashEntry entry = (HashEntry)it.next();
            s.writeObject(entry.key);
            s.writeObject(entry.value);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.buckets = new HashEntry[s.readInt()];
        for (int len = s.readInt(); len > 0; --len) {
            this.put(s.readObject(), s.readObject());
        }
    }

    final class HashIterator
    implements Iterator {
        private /* synthetic */ HashMap this$0;
        private final int type;
        private int knownMod;
        private int count;
        private int idx;
        private HashEntry last;
        private HashEntry next;

        private /* synthetic */ void finit$() {
            this.knownMod = this.this$0.modCount;
            this.count = this.this$0.size;
            this.idx = this.this$0.buckets.length;
        }

        HashIterator(HashMap this$0, int type) {
            this.this$0 = this$0;
            this.finit$();
            this.type = type;
        }

        public boolean hasNext() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.count > 0;
        }

        public Object next() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.count == 0) {
                throw new NoSuchElementException();
            }
            --this.count;
            HashEntry e = this.next;
            while (e == null) {
                e = this.this$0.buckets[--this.idx];
            }
            this.next = e.next;
            this.last = e;
            if (this.type == 1) {
                return e.value;
            }
            if (this.type == 0) {
                return e.key;
            }
            return e;
        }

        public void remove() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.this$0.remove(this.last.key);
            this.last = null;
            ++this.knownMod;
        }
    }

    static class HashEntry
    extends BasicMapEntry {
        HashEntry next;

        HashEntry(Object key, Object value) {
            super(key, value);
        }

        Object cleanup() {
            return this.value;
        }
    }
}

