/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.io.ObjectIdentityWrapper;
import gnu.java.lang.reflect.TypeSignature;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.SerializablePermission;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private static final int BUFFER_SIZE = 1024;
    private static int defaultProtocolVersion = 1;
    private DataOutputStream dataOutput;
    private boolean writeDataAsBlocks;
    private DataOutputStream realOutput;
    private DataOutputStream blockDataOutput;
    private byte[] blockData;
    private int blockDataCount;
    private Object currentObject;
    private ObjectStreamClass currentObjectStreamClass;
    private PutField currentPutField;
    private boolean fieldsAlreadyWritten;
    private boolean replacementEnabled;
    private boolean isSerializing;
    private int nextOID;
    private Hashtable OIDLookupTable;
    private int protocolVersion;
    private boolean useSubclassMethod;

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    static /* synthetic */ ObjectStreamClass access$1(ObjectOutputStream inst$, ObjectStreamClass write_parm_value$) {
        inst$.currentObjectStreamClass = write_parm_value$;
        return inst$.currentObjectStreamClass;
    }

    public ObjectOutputStream(OutputStream out) throws IOException {
        this.realOutput = new DataOutputStream(out);
        this.blockData = new byte[1024];
        this.blockDataCount = 0;
        this.blockDataOutput = new DataOutputStream(this);
        this.setBlockDataMode(true);
        this.replacementEnabled = false;
        this.isSerializing = false;
        this.nextOID = 0x7E0000;
        this.OIDLookupTable = new Hashtable();
        this.protocolVersion = defaultProtocolVersion;
        this.useSubclassMethod = false;
        this.writeStreamHeader();
    }

    public final void writeObject(Object obj) throws IOException {
        if (this.useSubclassMethod) {
            this.writeObjectOverride(obj);
            return;
        }
        boolean was_serializing = this.isSerializing;
        if (!was_serializing) {
            this.setBlockDataMode(false);
        }
        try {
            block35: {
                try {
                    Object replacedObject;
                    this.isSerializing = true;
                    boolean replaceDone = false;
                    this.drain();
                    while (true) {
                        if (obj == null) {
                            this.realOutput.writeByte(112);
                            break block35;
                        }
                        Integer handle = this.findHandle(obj);
                        if (handle != null) {
                            this.realOutput.writeByte(113);
                            this.realOutput.writeInt(handle);
                            break block35;
                        }
                        if (obj instanceof Class) {
                            this.realOutput.writeByte(118);
                            this.writeObject(ObjectStreamClass.lookup((Class)obj));
                            this.assignNewHandle(obj);
                            break block35;
                        }
                        if (obj instanceof ObjectStreamClass) {
                            ObjectStreamClass osc = (ObjectStreamClass)obj;
                            this.realOutput.writeByte(114);
                            this.realOutput.writeUTF(osc.getName());
                            this.realOutput.writeLong(osc.getSerialVersionUID());
                            this.assignNewHandle(obj);
                            int flags = osc.getFlags();
                            if (this.protocolVersion == 2 && osc.isExternalizable()) {
                                flags |= 8;
                            }
                            this.realOutput.writeByte(flags);
                            ObjectStreamField[] fields = osc.fields;
                            this.realOutput.writeShort(fields.length);
                            for (int i = 0; i < fields.length; ++i) {
                                ObjectStreamField field = fields[i];
                                this.realOutput.writeByte(field.getTypeCode());
                                this.realOutput.writeUTF(field.getName());
                                if (field.isPrimitive()) continue;
                                this.writeObject(field.getTypeString());
                            }
                            this.setBlockDataMode(true);
                            this.annotateClass(osc.forClass());
                            this.setBlockDataMode(false);
                            this.realOutput.writeByte(120);
                            if (osc.isSerializable()) {
                                this.writeObject(osc.getSuper());
                            } else {
                                this.writeObject(null);
                            }
                            break block35;
                        }
                        replacedObject = null;
                        if (!this.replacementEnabled && !(obj instanceof Serializable) || replaceDone) break;
                        replacedObject = obj;
                        if (obj instanceof Serializable) {
                            Method m = null;
                            try {
                                Class[] classArgs = new Class[]{};
                                m = obj.getClass().getDeclaredMethod("writeReplace", classArgs);
                                obj = m.invoke(obj, new Object[0]);
                            }
                            catch (NoSuchMethodException ignore) {
                            }
                            catch (IllegalAccessException ignore) {
                            }
                            catch (InvocationTargetException ignore) {
                                // empty catch block
                            }
                        }
                        if (this.replacementEnabled) {
                            obj = this.replaceObject(obj);
                        }
                        replaceDone = true;
                    }
                    if (obj instanceof String) {
                        this.realOutput.writeByte(116);
                        this.assignNewHandle(obj);
                        this.realOutput.writeUTF((String)obj);
                        break block35;
                    }
                    Class clazz = obj.getClass();
                    ObjectStreamClass osc = ObjectStreamClass.lookup(clazz);
                    if (osc == null) {
                        throw new NotSerializableException(clazz.getName());
                    }
                    if (clazz.isArray()) {
                        this.realOutput.writeByte(117);
                        this.writeObject(osc);
                        this.assignNewHandle(obj);
                        this.writeArraySizeAndElements(obj, clazz.getComponentType());
                        break block35;
                    }
                    this.realOutput.writeByte(115);
                    this.writeObject(osc);
                    if (replaceDone) {
                        this.assignNewHandle(replacedObject);
                    } else {
                        this.assignNewHandle(obj);
                    }
                    if (obj instanceof Externalizable) {
                        if (this.protocolVersion == 2) {
                            this.setBlockDataMode(true);
                        }
                        ((Externalizable)obj).writeExternal(this);
                        if (this.protocolVersion == 2) {
                            this.setBlockDataMode(false);
                            this.drain();
                        }
                        break block35;
                    }
                    if (obj instanceof Serializable) {
                        this.currentObject = obj;
                        ObjectStreamClass[] hierarchy = ObjectStreamClass.getObjectStreamClasses(clazz);
                        for (int i = 0; i < hierarchy.length; ++i) {
                            this.currentObjectStreamClass = hierarchy[i];
                            this.fieldsAlreadyWritten = false;
                            boolean has_write = this.currentObjectStreamClass.hasWriteMethod();
                            this.writeFields(obj, this.currentObjectStreamClass.fields, has_write);
                            if (!has_write) continue;
                            this.drain();
                            this.realOutput.writeByte(120);
                        }
                        this.currentObject = null;
                        this.currentObjectStreamClass = null;
                        this.currentPutField = null;
                        break block35;
                    }
                    throw new NotSerializableException(clazz.getName());
                }
                catch (IOException e) {
                    this.realOutput.writeByte(123);
                    this.reset(true);
                    try {
                        this.writeObject(e);
                    }
                    catch (IOException ioe) {
                        throw new StreamCorruptedException("Exception " + ioe + " thrown while exception was being written to stream.");
                    }
                    this.reset(true);
                }
            }
            Object var3_5 = null;
            this.isSerializing = was_serializing;
            if (!was_serializing) {
                this.setBlockDataMode(true);
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.isSerializing = was_serializing;
            if (!was_serializing) {
                this.setBlockDataMode(true);
            }
            throw throwable;
        }
    }

    public void defaultWriteObject() throws IOException, NotActiveException {
        this.markFieldsWritten();
        this.writeFields(this.currentObject, this.currentObjectStreamClass.fields, false);
    }

    private void markFieldsWritten() throws IOException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("defaultWriteObject called by non-active class and/or object");
        }
        if (this.fieldsAlreadyWritten) {
            throw new IOException("Only one of putFields and defaultWriteObject may be called, and it may only be called once");
        }
        this.fieldsAlreadyWritten = true;
    }

    public void reset() throws IOException {
        this.reset(false);
    }

    private void reset(boolean internal) throws IOException {
        if (!internal) {
            if (this.isSerializing) {
                throw new IOException("Reset called while serialization in progress");
            }
            this.realOutput.writeByte(121);
        }
        this.clearHandles();
    }

    public void useProtocolVersion(int version) throws IOException {
        if (version != 1 && version != 2) {
            throw new IOException("Invalid protocol version requested.");
        }
        this.protocolVersion = version;
    }

    public static void setDefaultProtocolVersion(int version) throws IOException {
        if (version != 1 && version != 2) {
            throw new IOException("Invalid protocol version requested.");
        }
        defaultProtocolVersion = version;
    }

    protected void annotateClass(Class cl) throws IOException {
    }

    protected Object replaceObject(Object obj) throws IOException {
        return obj;
    }

    protected boolean enableReplaceObject(boolean enable) throws SecurityException {
        SecurityManager sm;
        if (enable && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new SerializablePermission("enableSubstitution"));
        }
        boolean old_val = this.replacementEnabled;
        this.replacementEnabled = enable;
        return old_val;
    }

    protected void writeStreamHeader() throws IOException {
        this.realOutput.writeShort(-21267);
        this.realOutput.writeShort(5);
    }

    protected ObjectOutputStream() throws IOException, SecurityException {
        SecurityManager sec_man = System.getSecurityManager();
        if (sec_man != null) {
            sec_man.checkPermission(ObjectStreamConstants.SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.useSubclassMethod = true;
    }

    protected void writeObjectOverride(Object obj) throws NotActiveException, IOException {
        throw new NotActiveException("Subclass of ObjectOutputStream must implement writeObjectOverride");
    }

    public void write(int data) throws IOException {
        if (this.writeDataAsBlocks) {
            if (this.blockDataCount == 1024) {
                this.drain();
            }
            this.blockData[this.blockDataCount++] = (byte)data;
        } else {
            this.realOutput.write(data);
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.writeDataAsBlocks) {
            if (len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (this.blockDataCount + len < 1024) {
                System.arraycopy(b, off, this.blockData, this.blockDataCount, len);
                this.blockDataCount += len;
            } else {
                this.drain();
                this.writeBlockDataHeader(len);
                this.realOutput.write(b, off, len);
            }
        } else {
            this.realOutput.write(b, off, len);
        }
    }

    public void flush() throws IOException {
        this.drain();
        this.realOutput.flush();
    }

    protected void drain() throws IOException {
        if (this.blockDataCount == 0) {
            return;
        }
        this.writeBlockDataHeader(this.blockDataCount);
        this.realOutput.write(this.blockData, 0, this.blockDataCount);
        this.blockDataCount = 0;
    }

    public void close() throws IOException {
        this.drain();
        this.realOutput.close();
    }

    public void writeBoolean(boolean data) throws IOException {
        this.dataOutput.writeBoolean(data);
    }

    public void writeByte(int data) throws IOException {
        this.dataOutput.writeByte(data);
    }

    public void writeShort(int data) throws IOException {
        this.dataOutput.writeShort(data);
    }

    public void writeChar(int data) throws IOException {
        this.dataOutput.writeChar(data);
    }

    public void writeInt(int data) throws IOException {
        this.dataOutput.writeInt(data);
    }

    public void writeLong(long data) throws IOException {
        this.dataOutput.writeLong(data);
    }

    public void writeFloat(float data) throws IOException {
        this.dataOutput.writeFloat(data);
    }

    public void writeDouble(double data) throws IOException {
        this.dataOutput.writeDouble(data);
    }

    public void writeBytes(String data) throws IOException {
        this.dataOutput.writeBytes(data);
    }

    public void writeChars(String data) throws IOException {
        this.dataOutput.writeChars(data);
    }

    public void writeUTF(String data) throws IOException {
        this.dataOutput.writeUTF(data);
    }

    public PutField putFields() throws IOException {
        this.markFieldsWritten();
        this.currentPutField = new PutField(this){
            private /* synthetic */ ObjectOutputStream this$0;
            private byte[] prim_field_data;
            private Object[] objs;
            {
                this.this$0 = this$0;
                this.finit$();
            }

            private /* synthetic */ void finit$() {
                this.prim_field_data = new byte[((ObjectOutputStream)this.this$0).currentObjectStreamClass.primFieldSize];
                this.objs = new Object[((ObjectOutputStream)this.this$0).currentObjectStreamClass.objectFieldCount];
            }

            public void put(String name, boolean value) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.this$0.currentObjectStreamClass.getField(name);
                this.checkType(field, 'Z');
                this.prim_field_data[field.getOffset()] = value ? (byte)1 : 0;
            }

            public void put(String name, byte value) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.this$0.currentObjectStreamClass.getField(name);
                this.checkType(field, 'B');
                this.prim_field_data[field.getOffset()] = value;
            }

            public void put(String name, char value) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.this$0.currentObjectStreamClass.getField(name);
                this.checkType(field, 'C');
                int off = field.getOffset();
                this.prim_field_data[off++] = (byte)(value >>> 8);
                this.prim_field_data[off] = (byte)value;
            }

            public void put(String name, double value) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.this$0.currentObjectStreamClass.getField(name);
                this.checkType(field, 'D');
                int off = field.getOffset();
                long l_value = Double.doubleToLongBits(value);
                this.prim_field_data[off++] = (byte)(l_value >>> 52);
                this.prim_field_data[off++] = (byte)(l_value >>> 48);
                this.prim_field_data[off++] = (byte)(l_value >>> 40);
                this.prim_field_data[off++] = (byte)(l_value >>> 32);
                this.prim_field_data[off++] = (byte)(l_value >>> 24);
                this.prim_field_data[off++] = (byte)(l_value >>> 16);
                this.prim_field_data[off++] = (byte)(l_value >>> 8);
                this.prim_field_data[off] = (byte)l_value;
            }

            public void put(String name, float value) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.this$0.currentObjectStreamClass.getField(name);
                this.checkType(field, 'F');
                int off = field.getOffset();
                int i_value = Float.floatToIntBits(value);
                this.prim_field_data[off++] = (byte)(i_value >>> 24);
                this.prim_field_data[off++] = (byte)(i_value >>> 16);
                this.prim_field_data[off++] = (byte)(i_value >>> 8);
                this.prim_field_data[off] = (byte)i_value;
            }

            public void put(String name, int value) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.this$0.currentObjectStreamClass.getField(name);
                this.checkType(field, 'I');
                int off = field.getOffset();
                this.prim_field_data[off++] = (byte)(value >>> 24);
                this.prim_field_data[off++] = (byte)(value >>> 16);
                this.prim_field_data[off++] = (byte)(value >>> 8);
                this.prim_field_data[off] = (byte)value;
            }

            public void put(String name, long value) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.this$0.currentObjectStreamClass.getField(name);
                this.checkType(field, 'J');
                int off = field.getOffset();
                this.prim_field_data[off++] = (byte)(value >>> 52);
                this.prim_field_data[off++] = (byte)(value >>> 48);
                this.prim_field_data[off++] = (byte)(value >>> 40);
                this.prim_field_data[off++] = (byte)(value >>> 32);
                this.prim_field_data[off++] = (byte)(value >>> 24);
                this.prim_field_data[off++] = (byte)(value >>> 16);
                this.prim_field_data[off++] = (byte)(value >>> 8);
                this.prim_field_data[off] = (byte)value;
            }

            public void put(String name, short value) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.this$0.currentObjectStreamClass.getField(name);
                this.checkType(field, 'S');
                int off = field.getOffset();
                this.prim_field_data[off++] = (byte)(value >>> 8);
                this.prim_field_data[off] = (byte)value;
            }

            public void put(String name, Object value) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.this$0.currentObjectStreamClass.getField(name);
                if (value != null && !field.getType().isAssignableFrom(value.getClass())) {
                    throw new IllegalArgumentException();
                }
                this.objs[field.getOffset()] = value;
            }

            public void write(ObjectOutput out) throws IOException {
                this.this$0.setBlockDataMode(false);
                out.write(this.prim_field_data);
                for (int i = 0; i < this.objs.length; ++i) {
                    out.writeObject(this.objs[i]);
                }
                this.this$0.setBlockDataMode(true);
            }

            private void checkType(ObjectStreamField field, char type) throws IllegalArgumentException {
                if (TypeSignature.getEncodingOfClass(field.getType()).charAt(0) != type) {
                    throw new IllegalArgumentException();
                }
            }
        };
        return this.currentPutField;
    }

    public void writeFields() throws IOException {
        if (this.currentPutField == null) {
            throw new NotActiveException("writeFields can only be called after putFields has been called");
        }
        this.currentPutField.write(this);
    }

    private void writeBlockDataHeader(int size) throws IOException {
        if (size < 256) {
            this.realOutput.writeByte(119);
            this.realOutput.write(size);
        } else {
            this.realOutput.writeByte(122);
            this.realOutput.writeInt(size);
        }
    }

    private Integer findHandle(Object obj) {
        return (Integer)this.OIDLookupTable.get(new ObjectIdentityWrapper(obj));
    }

    private int assignNewHandle(Object obj) {
        this.OIDLookupTable.put(new ObjectIdentityWrapper(obj), new Integer(this.nextOID));
        return this.nextOID++;
    }

    private void clearHandles() {
        this.nextOID = 0x7E0000;
        this.OIDLookupTable.clear();
    }

    private void writeArraySizeAndElements(Object array, Class clazz) throws IOException {
        int length = Array.getLength(array);
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                boolean[] cast_array = (boolean[])array;
                this.realOutput.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    this.realOutput.writeBoolean(cast_array[i]);
                }
                return;
            }
            if (clazz == Byte.TYPE) {
                byte[] cast_array = (byte[])array;
                this.realOutput.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    this.realOutput.writeByte(cast_array[i]);
                }
                return;
            }
            if (clazz == Character.TYPE) {
                char[] cast_array = (char[])array;
                this.realOutput.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    this.realOutput.writeChar(cast_array[i]);
                }
                return;
            }
            if (clazz == Double.TYPE) {
                double[] cast_array = (double[])array;
                this.realOutput.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    this.realOutput.writeDouble(cast_array[i]);
                }
                return;
            }
            if (clazz == Float.TYPE) {
                float[] cast_array = (float[])array;
                this.realOutput.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    this.realOutput.writeFloat(cast_array[i]);
                }
                return;
            }
            if (clazz == Integer.TYPE) {
                int[] cast_array = (int[])array;
                this.realOutput.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    this.realOutput.writeInt(cast_array[i]);
                }
                return;
            }
            if (clazz == Long.TYPE) {
                long[] cast_array = (long[])array;
                this.realOutput.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    this.realOutput.writeLong(cast_array[i]);
                }
                return;
            }
            if (clazz == Short.TYPE) {
                short[] cast_array = (short[])array;
                this.realOutput.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    this.realOutput.writeShort(cast_array[i]);
                }
                return;
            }
        } else {
            Object[] cast_array = (Object[])array;
            this.realOutput.writeInt(length);
            for (int i = 0; i < length; ++i) {
                this.writeObject(cast_array[i]);
            }
        }
    }

    private void writeFields(Object obj, ObjectStreamField[] fields, boolean call_write_method) throws IOException {
        if (call_write_method) {
            this.setBlockDataMode(true);
            this.callWriteMethod(obj);
            this.setBlockDataMode(false);
            return;
        }
        for (int i = 0; i < fields.length; ++i) {
            String field_name = fields[i].getName();
            Class type = fields[i].getType();
            if (type == Boolean.TYPE) {
                this.realOutput.writeBoolean(this.getBooleanField(obj, field_name));
                continue;
            }
            if (type == Byte.TYPE) {
                this.realOutput.writeByte(this.getByteField(obj, field_name));
                continue;
            }
            if (type == Character.TYPE) {
                this.realOutput.writeChar(this.getCharField(obj, field_name));
                continue;
            }
            if (type == Double.TYPE) {
                this.realOutput.writeDouble(this.getDoubleField(obj, field_name));
                continue;
            }
            if (type == Float.TYPE) {
                this.realOutput.writeFloat(this.getFloatField(obj, field_name));
                continue;
            }
            if (type == Integer.TYPE) {
                this.realOutput.writeInt(this.getIntField(obj, field_name));
                continue;
            }
            if (type == Long.TYPE) {
                this.realOutput.writeLong(this.getLongField(obj, field_name));
                continue;
            }
            if (type == Short.TYPE) {
                this.realOutput.writeShort(this.getShortField(obj, field_name));
                continue;
            }
            this.writeObject(this.getObjectField(obj, field_name, TypeSignature.getEncodingOfClass(type)));
        }
    }

    private void setBlockDataMode(boolean on) {
        this.writeDataAsBlocks = on;
        this.dataOutput = on ? this.blockDataOutput : this.realOutput;
    }

    private void callWriteMethod(Object obj) throws IOException {
        Class klass = obj.getClass();
        try {
            Class[] classArgs = new Class[]{ObjectOutputStream.class$("java.io.ObjectOutputStream")};
            Method m = ObjectOutputStream.getMethod(klass, "writeObject", classArgs);
            if (m == null) {
                return;
            }
            Object[] args = new Object[]{this};
            m.invoke(obj, args);
        }
        catch (InvocationTargetException x) {
            Throwable exception = x.getTargetException();
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException("Exception thrown from writeObject() on " + klass + ": " + exception.getClass().getName());
        }
        catch (Exception x) {
            throw new IOException("Failure invoking writeObject() on " + klass + ": " + x.getClass().getName());
        }
    }

    private boolean getBooleanField(Object obj, String field_name) throws IOException {
        try {
            Class klass = obj.getClass();
            Field f = ObjectOutputStream.getField(klass, field_name);
            boolean b = f.getBoolean(obj);
            return b;
        }
        catch (Exception _) {
            throw new IOException();
        }
    }

    private byte getByteField(Object obj, String field_name) throws IOException {
        try {
            Class klass = obj.getClass();
            Field f = ObjectOutputStream.getField(klass, field_name);
            byte b = f.getByte(obj);
            return b;
        }
        catch (Exception _) {
            throw new IOException();
        }
    }

    private char getCharField(Object obj, String field_name) throws IOException {
        try {
            Class klass = obj.getClass();
            Field f = ObjectOutputStream.getField(klass, field_name);
            char b = f.getChar(obj);
            return b;
        }
        catch (Exception _) {
            throw new IOException();
        }
    }

    private double getDoubleField(Object obj, String field_name) throws IOException {
        try {
            Class klass = obj.getClass();
            Field f = ObjectOutputStream.getField(klass, field_name);
            double b = f.getDouble(obj);
            return b;
        }
        catch (Exception _) {
            throw new IOException();
        }
    }

    private float getFloatField(Object obj, String field_name) throws IOException {
        try {
            Class klass = obj.getClass();
            Field f = ObjectOutputStream.getField(klass, field_name);
            float b = f.getFloat(obj);
            return b;
        }
        catch (Exception _) {
            throw new IOException();
        }
    }

    private int getIntField(Object obj, String field_name) throws IOException {
        try {
            Class klass = obj.getClass();
            Field f = ObjectOutputStream.getField(klass, field_name);
            int b = f.getInt(obj);
            return b;
        }
        catch (Exception _) {
            throw new IOException();
        }
    }

    private long getLongField(Object obj, String field_name) throws IOException {
        try {
            Class klass = obj.getClass();
            Field f = ObjectOutputStream.getField(klass, field_name);
            long b = f.getLong(obj);
            return b;
        }
        catch (Exception _) {
            throw new IOException();
        }
    }

    private short getShortField(Object obj, String field_name) throws IOException {
        try {
            Class klass = obj.getClass();
            Field f = ObjectOutputStream.getField(klass, field_name);
            short b = f.getShort(obj);
            return b;
        }
        catch (Exception _) {
            throw new IOException();
        }
    }

    private Object getObjectField(Object obj, String field_name, String type_code) throws IOException {
        try {
            Class klass = obj.getClass();
            Field f = ObjectOutputStream.getField(klass, field_name);
            Object o = f.get(obj);
            return o;
        }
        catch (Exception _) {
            throw new IOException();
        }
    }

    private static native Field getField(Class var0, String var1) throws NoSuchFieldException;

    private static native Method getMethod(Class var0, String var1, Class[] var2) throws NoSuchMethodException;

    public static abstract class PutField {
        public abstract void put(String var1, boolean var2) throws IOException, IllegalArgumentException;

        public abstract void put(String var1, byte var2) throws IOException, IllegalArgumentException;

        public abstract void put(String var1, char var2) throws IOException, IllegalArgumentException;

        public abstract void put(String var1, double var2) throws IOException, IllegalArgumentException;

        public abstract void put(String var1, float var2) throws IOException, IllegalArgumentException;

        public abstract void put(String var1, int var2) throws IOException, IllegalArgumentException;

        public abstract void put(String var1, long var2) throws IOException, IllegalArgumentException;

        public abstract void put(String var1, short var2) throws IOException, IllegalArgumentException;

        public abstract void put(String var1, Object var2) throws IOException, IllegalArgumentException;

        public abstract void write(ObjectOutput var1) throws IOException;
    }
}

