/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans;

import gnu.java.beans.BeanInfoEmbryo;
import gnu.java.beans.DoubleKey;
import gnu.java.lang.ArrayHelper;
import gnu.java.lang.ClassHelper;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class IntrospectionIncubator {
    Hashtable propertyMethods;
    Hashtable listenerMethods;
    Vector otherMethods;
    Class propertyStopClass;
    Class eventStopClass;
    Class methodStopClass;
    static final int IS = 0;
    static final int GET_I = 1;
    static final int SET_I = 2;
    static final int GET = 3;
    static final int SET = 4;
    static final int ADD = 0;
    static final int REMOVE = 1;

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    private /* synthetic */ void finit$() {
        this.propertyMethods = new Hashtable();
        this.listenerMethods = new Hashtable();
        this.otherMethods = new Vector();
    }

    public IntrospectionIncubator() {
        this.finit$();
    }

    public void addMethod(Method method) {
        if (Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())) {
            String name = ClassHelper.getTruncatedName(method.getName());
            Class retType = method.getReturnType();
            Class[] params = method.getParameterTypes();
            boolean isVoid = retType.equals(Void.TYPE);
            Class methodClass = method.getDeclaringClass();
            if (this.propertyStopClass == null || this.propertyStopClass.isAssignableFrom(methodClass) && !this.propertyStopClass.equals(methodClass)) {
                if (name.startsWith("is") && retType.equals(Boolean.TYPE) && params.length == 0) {
                    this.addToPropertyHash(name, method, 0);
                } else if (name.startsWith("get") && !isVoid) {
                    if (params.length == 0) {
                        this.addToPropertyHash(name, method, 3);
                    } else if (params.length == 1 && params[0].equals(Integer.TYPE)) {
                        this.addToPropertyHash(name, method, 1);
                    } else {
                        this.otherMethods.addElement(method);
                    }
                } else if (name.startsWith("set") && isVoid) {
                    if (params.length == 1) {
                        this.addToPropertyHash(name, method, 4);
                    } else if (params.length == 2 && params[0].equals(Integer.TYPE)) {
                        this.addToPropertyHash(name, method, 2);
                    } else {
                        this.otherMethods.addElement(method);
                    }
                }
            }
            if (this.eventStopClass == null || this.eventStopClass.isAssignableFrom(methodClass) && !this.eventStopClass.equals(methodClass)) {
                if (name.startsWith("add") && isVoid && params.length == 1 && IntrospectionIncubator.class$("java.util.EventListener").isAssignableFrom(params[0])) {
                    this.addToListenerHash(name, method, 0);
                } else if (name.startsWith("remove") && isVoid && params.length == 1 && IntrospectionIncubator.class$("java.util.EventListener").isAssignableFrom(params[0])) {
                    this.addToListenerHash(name, method, 1);
                }
            }
            if (this.methodStopClass == null || this.methodStopClass.isAssignableFrom(methodClass) && !this.methodStopClass.equals(methodClass)) {
                this.otherMethods.addElement(method);
            }
        }
    }

    public void addMethods(Method[] m) {
        for (int i = 0; i < m.length; ++i) {
            this.addMethod(m[i]);
        }
    }

    public void setPropertyStopClass(Class c) {
        this.propertyStopClass = c;
    }

    public void setEventStopClass(Class c) {
        this.eventStopClass = c;
    }

    public void setMethodStopClass(Class c) {
        this.methodStopClass = c;
    }

    public BeanInfoEmbryo getBeanInfoEmbryo() throws IntrospectionException {
        BeanInfoEmbryo b = new BeanInfoEmbryo();
        this.findXXX(b, 0);
        this.findXXXInt(b, 1);
        this.findXXXInt(b, 2);
        this.findXXX(b, 3);
        this.findXXX(b, 4);
        this.findAddRemovePairs(b);
        for (int i = 0; i < this.otherMethods.size(); ++i) {
            MethodDescriptor newMethod = new MethodDescriptor((Method)this.otherMethods.elementAt(i));
            if (b.hasMethod(newMethod)) continue;
            b.addMethod(new MethodDescriptor((Method)this.otherMethods.elementAt(i)));
        }
        return b;
    }

    public BeanInfo getBeanInfo() throws IntrospectionException {
        return this.getBeanInfoEmbryo().getBeanInfo();
    }

    void findAddRemovePairs(BeanInfoEmbryo b) throws IntrospectionException {
        Enumeration listenerEnum = this.listenerMethods.keys();
        while (listenerEnum.hasMoreElements()) {
            DoubleKey k = (DoubleKey)listenerEnum.nextElement();
            Method[] m = (Method[])this.listenerMethods.get(k);
            if (m[0] == null || m[1] == null) continue;
            EventSetDescriptor e = new EventSetDescriptor(Introspector.decapitalize(k.getName()), k.getType(), k.getType().getMethods(), m[0], m[1]);
            e.setUnicast(ArrayHelper.contains(m[0].getExceptionTypes(), IntrospectionIncubator.class$("java.util.TooManyListenersException")));
            if (b.hasEvent(e)) continue;
            b.addEvent(e);
        }
    }

    void findXXX(BeanInfoEmbryo b, int funcType) throws IntrospectionException {
        Enumeration keys = this.propertyMethods.keys();
        while (keys.hasMoreElements()) {
            DoubleKey k = (DoubleKey)keys.nextElement();
            Method[] m = (Method[])this.propertyMethods.get(k);
            if (m[funcType] == null) continue;
            PropertyDescriptor p = new PropertyDescriptor(Introspector.decapitalize(k.getName()), m[0] != null ? m[0] : m[3], m[4]);
            if (m[4] != null) {
                p.setConstrained(ArrayHelper.contains(m[4].getExceptionTypes(), IntrospectionIncubator.class$("java.beans.PropertyVetoException")));
            }
            if (b.hasProperty(p)) continue;
            b.addProperty(p);
        }
    }

    void findXXXInt(BeanInfoEmbryo b, int funcType) throws IntrospectionException {
        Enumeration keys = this.propertyMethods.keys();
        while (keys.hasMoreElements()) {
            IndexedPropertyDescriptor p;
            DoubleKey k = (DoubleKey)keys.nextElement();
            Method[] m = (Method[])this.propertyMethods.get(k);
            if (m[funcType] == null) continue;
            boolean constrained = m[2] != null ? ArrayHelper.contains(m[2].getExceptionTypes(), IntrospectionIncubator.class$("java.beans.PropertyVetoException")) : false;
            Class arrayType = Array.newInstance(k.getType(), 0).getClass();
            DoubleKey findSetArray = new DoubleKey(arrayType, k.getName());
            Method[] m2 = (Method[])this.propertyMethods.get(findSetArray);
            if (m2 == null) {
                p = new IndexedPropertyDescriptor(Introspector.decapitalize(k.getName()), null, null, m[1], m[2]);
            } else {
                if (constrained && m2[4] != null) {
                    constrained = ArrayHelper.contains(m2[4].getExceptionTypes(), IntrospectionIncubator.class$("java.beans.PropertyVetoException"));
                }
                p = new IndexedPropertyDescriptor(Introspector.decapitalize(k.getName()), m2[3], m2[4], m[1], m[2]);
            }
            p.setConstrained(constrained);
            if (b.hasProperty(p)) continue;
            b.addProperty(p);
        }
    }

    void addToPropertyHash(String name, Method method, int funcType) {
        String newName;
        Class type;
        switch (funcType) {
            case 0: {
                type = Boolean.TYPE;
                newName = name.substring(2);
                break;
            }
            case 1: {
                type = method.getReturnType();
                newName = name.substring(3);
                break;
            }
            case 2: {
                type = method.getParameterTypes()[1];
                newName = name.substring(3);
                break;
            }
            case 3: {
                type = method.getReturnType();
                newName = name.substring(3);
                break;
            }
            case 4: {
                type = method.getParameterTypes()[0];
                newName = name.substring(3);
                break;
            }
            default: {
                return;
            }
        }
        newName = IntrospectionIncubator.capitalize(newName);
        DoubleKey k = new DoubleKey(type, newName);
        Method[] methods = (Method[])this.propertyMethods.get(k);
        if (methods == null) {
            methods = new Method[5];
            this.propertyMethods.put(k, methods);
        }
        methods[funcType] = method;
    }

    void addToListenerHash(String name, Method method, int funcType) {
        String newName;
        Class type;
        switch (funcType) {
            case 0: {
                type = method.getParameterTypes()[0];
                newName = name.substring(3, name.length() - 8);
                break;
            }
            case 1: {
                type = method.getParameterTypes()[0];
                newName = name.substring(6, name.length() - 8);
                break;
            }
            default: {
                return;
            }
        }
        newName = IntrospectionIncubator.capitalize(newName);
        DoubleKey k = new DoubleKey(type, newName);
        Method[] methods = (Method[])this.listenerMethods.get(k);
        if (methods == null) {
            methods = new Method[2];
            this.listenerMethods.put(k, methods);
        }
        methods[funcType] = method;
    }

    static String capitalize(String name) {
        try {
            if (Character.isUpperCase(name.charAt(0))) {
                return name;
            }
            char[] c = name.toCharArray();
            c[0] = Character.toLowerCase(c[0]);
            return new String(c);
        }
        catch (StringIndexOutOfBoundsException E) {
            return name;
        }
        catch (NullPointerException E) {
            return null;
        }
    }
}

